/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.common.consts.DropPlanOrderConst;

public class DropPlanOrderLogListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(DropPlanOrderLogListPlugin.class);

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        boolean fromMessageCenter = parameter.getCustomParams().containsKey("q_caculatelog.number");
        if (fromMessageCenter) {
            List commonFilterColumns = args.getCommonFilterColumns();
            for (FilterColumn filterColumn : commonFilterColumns) {
                String fieldName = filterColumn.getFieldName();
                if (!"operationdate".equals(fieldName)) continue;
                filterColumn.setDefaultValue("");
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        String[] showDropStatus = new String[]{DropPlanOrderConst.DropStatusEnum.C.name(), DropPlanOrderConst.DropStatusEnum.D.name(), DropPlanOrderConst.DropStatusEnum.E.name(), ""};
        qFilters.add(new QFilter("dropstatus", "in", (Object)showDropStatus));
        this.addFilterForMessageCenter(qFilters);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent evt = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = evt.getFieldName();
        ListSelectedRow currentRow = evt.getCurrentRow();
        Object logPk = currentRow.getPrimaryKeyValue();
        if ("billno".equals(fieldName)) {
            args.setCancel(true);
            this.showPlanOrder(logPk);
        } else if ("targetbillno".equals(fieldName)) {
            args.setCancel(true);
            this.showTargetBill(logPk);
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String fieldKey = args.getListFieldKey();
        if ("dropstatus".equals(fieldKey)) {
            List comboItems = args.getComboItems();
            Iterator iterator = comboItems.iterator();
            while (iterator.hasNext()) {
                ValueMapItem item = (ValueMapItem)iterator.next();
                String itemValue = item.getValue();
                if ("D".equals(itemValue) || "E".equals(itemValue)) continue;
                iterator.remove();
            }
        }
    }

    private void addFilterForMessageCenter(List<QFilter> qFilters) {
        String failType;
        String supplyOrgIdStr;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String logNumber = (String)formShowParameter.getCustomParam("q_caculatelog.number");
        if (StringUtils.isNotBlank((CharSequence)logNumber)) {
            qFilters.add(new QFilter("planoperatenum", "=", (Object)logNumber));
        }
        if (StringUtils.isNotBlank((CharSequence)(supplyOrgIdStr = (String)formShowParameter.getCustomParam("q_proorpurorg")))) {
            qFilters.add(new QFilter("proorpurorg", "=", (Object)Long.parseLong(supplyOrgIdStr)));
        }
        if (StringUtils.isNotBlank((CharSequence)(failType = (String)formShowParameter.getCustomParam("q_failtype")))) {
            qFilters.add(new QFilter("failtype", "=", (Object)failType));
        }
        if (StringUtils.isNotBlank((CharSequence)logNumber)) {
            long currUserId = RequestContext.get().getCurrUserId();
            QFilter[] filters = new QFilter[]{new QFilter("planoperatenum", "=", (Object)logNumber), new QFilter("planpersonid", "=", (Object)currUserId)};
            DynamicObjectCollection notifyPlanOrders = QueryServiceHelper.query((String)"mrp_planorder", (String)"id", (QFilter[])filters);
            List notifyPlanOrderIdList = notifyPlanOrders.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            qFilters.add(new QFilter("planorderid", "in", notifyPlanOrderIdList));
        }
    }

    private void showPlanOrder(Object logPk) {
        QFilter logFilter = new QFilter("id", "=", logPk);
        DynamicObject log = QueryServiceHelper.queryOne((String)"mrp_dropplanorderlog", (String)"planorderid", (QFilter[])logFilter.toArray());
        if (log == null) {
            logger.info("\u6839\u636e\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u65e5\u5fd7id[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6295\u653e\u65e5\u5fd7", logPk);
            return;
        }
        long planOrderId = log.getLong("planorderid");
        QFilter planOrderFilter = new QFilter("id", "=", (Object)planOrderId);
        boolean planOrderExists = QueryServiceHelper.exists((String)"mrp_planorder", (QFilter[])planOrderFilter.toArray());
        if (!planOrderExists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u4e0d\u5b58\u5728\u3002", (String)"DropPlanOrderLogListPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId("mrp_planorder");
        param.setPkId((Object)planOrderId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showTargetBill(Object logPk) {
        long targetOrderId;
        QFilter targetOrderFilter;
        QFilter logFilter = new QFilter("id", "=", logPk);
        String selectFields = String.join((CharSequence)",", "targetorder", "targetorderid");
        DynamicObject log = QueryServiceHelper.queryOne((String)"mrp_dropplanorderlog", (String)selectFields, (QFilter[])logFilter.toArray());
        if (log == null) {
            logger.info("\u6839\u636e\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u65e5\u5fd7id[{}]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6295\u653e\u65e5\u5fd7", logPk);
            return;
        }
        String targetOrder = log.getString("targetorder");
        boolean targetOrderExists = QueryServiceHelper.exists((String)targetOrder, (QFilter[])(targetOrderFilter = new QFilter("id", "=", (Object)(targetOrderId = log.getLong("targetorderid")))).toArray());
        if (!targetOrderExists) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e0d\u5b58\u5728\u3002", (String)"DropPlanOrderLogListPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        BillShowParameter param = new BillShowParameter();
        param.setFormId(targetOrder);
        param.setPkId((Object)targetOrderId);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)param);
    }
}

