/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.msplan.business.helper.ExportHelper;

public class GetFieldsFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    private static final String BUTTON_GETINFO = "getinfo";
    private static final String BUTTON_EXPORTENTRYDATA = "exportentrydata";
    private static final String[] fields = new String[]{"propertynameinfo", "propertykeyinfo", "typeinfo", "databasefield"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BUTTON_GETINFO});
        this.addClickListeners(new String[]{BUTTON_EXPORTENTRYDATA});
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt.getSource() instanceof Button) {
            Button bt = (Button)evt.getSource();
            String keyValue = bt.getKey();
            if (BUTTON_GETINFO.equals(keyValue)) {
                this.doSearchInfo(false);
            } else if (BUTTON_EXPORTENTRYDATA.equals(keyValue)) {
                this.doSearchInfo(true);
            }
        }
    }

    private void doSearchInfo(boolean isExport) {
        DynamicObject dynamicObject = this.getModel().getDataEntity().getDynamicObject("entityobj");
        if (dynamicObject == null) {
            this.getModel().deleteEntryData("entryentityinfo");
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u9700\u8981\u67e5\u8be2\u7684\u5355\u636e\u5bf9\u8c61\u3002", (String)"GetFieldsFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        String entityobjNumber = dynamicObject.getString("number");
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityobjNumber);
        ArrayList<List<String>> resultList = new ArrayList<List<String>>(16);
        this.buildDataEntityData(mainEntityType.getProperties(), resultList);
        this.populateEntryEntity(resultList, fields, "entryentityinfo");
        if (isExport) {
            this.exportData(resultList);
        }
    }

    private void exportData(List<List<String>> resultList) {
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentityinfo");
        if (entryentity == null || entryentity.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u6570\u636e\u53ef\u4ee5\u5bfc\u51fa\u3002", (String)"GetFieldsFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<List<Object>> excel = new ArrayList<List<Object>>(16);
        ArrayList<String> listName = new ArrayList<String>(16);
        listName.add(ResManager.loadKDString((String)"\u5c5e\u6027\u540d\u79f0", (String)"GetFieldsFormPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u5c5e\u6027\u6807\u8bc6", (String)"GetFieldsFormPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"GetFieldsFormPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        listName.add(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u5b57\u6bb5", (String)"GetFieldsFormPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        excel.add(listName);
        excel.addAll(resultList);
        SimpleDateFormat sdf = new SimpleDateFormat("MMdd");
        String dateStr = sdf.format(new Date());
        String suffix = "_".concat(dateStr);
        ExportHelper.export(excel, (String)String.format(ResManager.loadKDString((String)"\u5355\u636e\u5bf9\u8c61\u5b57\u6bb5%s", (String)"GetFieldsFormPlugin_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), suffix), (IFormView)this.getView());
    }

    private void buildDataEntityData(DataEntityPropertyCollection propertyCollection, List<List<String>> resultList) {
        LinkedList<IDataEntityProperty> list = new LinkedList<IDataEntityProperty>();
        ArrayList<String> propertyList = null;
        for (IDataEntityProperty pro : propertyCollection) {
            String displayName;
            String name = pro.getName();
            String alias = pro.getAlias();
            String type = pro.getPropertyType() != null ? pro.getPropertyType().getSimpleName() : "";
            String string = displayName = pro.getDisplayName() != null ? pro.getDisplayName().toString() : "";
            if (pro instanceof EntryProp) {
                list.add(pro);
                continue;
            }
            propertyList = new ArrayList(16);
            propertyList.add(displayName);
            propertyList.add(name);
            propertyList.add(type);
            propertyList.add(alias);
            resultList.add(propertyList);
        }
        for (IDataEntityProperty property : list) {
            EntryProp entryProp = (EntryProp)property;
            DataEntityPropertyCollection entryProperties = entryProp._collectionItemPropertyType.getProperties();
            propertyList = new ArrayList<String>(16);
            propertyList.add(entryProp.getDisplayName() + "");
            propertyList.add(entryProp.getName());
            propertyList.add("EntryProp");
            resultList.add(propertyList);
            this.buildDataEntityData(entryProperties, resultList);
        }
    }

    private void populateEntryEntity(List<List<String>> resultList, String[] fields, String entryKey) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter tvs = new TableValueSetter(fields);
        for (List<String> result : resultList) {
            tvs.addRow(result.toArray());
        }
        model.deleteEntryData(entryKey);
        model.batchCreateNewEntryRow(entryKey, tvs);
        this.getView().updateView(entryKey);
        EntryGrid entryentityinfo = (EntryGrid)this.getControl("entryentityinfo");
        if (entryentityinfo != null) {
            entryentityinfo.setPageIndex(1);
        }
    }
}

