/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.common.dao.MultiorgsupdemPojo;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportingPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String NODEDETAILS = "mrp_nodedetails";
    private static final String ENABLE = "enable";
    private static final String ID = "id";
    private static final String PARENTDNYID = "parentdnyid";
    private MultiorgsupdemPojo saveIm;
    private List<String> supplyRuleList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u9886\u6599", (String)"ImportingPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u8c03\u62e8", (String)"ImportingPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"ImportingPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])});
    private List<String> stocksetup = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5168\u90e8\u4ed3\u5e93", (String)"ImportingPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4ed3\u5e93", (String)"ImportingPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6392\u9664\u6307\u5b9a\u4ed3\u5e93", (String)"ImportingPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])});
    private static final Log logger = LogFactory.getLog(ImportingPlugin.class);
    private static final String BD_INVTYPE = "bd_invtype";
    private String IMPORTTYPE = "";
    private Map<String, Integer> cellValue = new HashMap<String, Integer>(8);
    private static final String BD_INVSTATUS = "bd_invstatus";
    private static final String CACHEKEY_PROGRESS = "progress";
    private Map<String, Long> demandOrgNumberMap = new HashMap<String, Long>(8);
    private List<String> exitOrgNumber = new ArrayList<String>(8);
    private Map<String, Long> stockDemandOrgNumberMap = new HashMap<String, Long>(8);
    private List<String> supplyOrgNumberList = new ArrayList<String>(8);
    private Map<String, List<String>> specialSupplyOrgNumberMap = new HashMap<String, List<String>>(8);
    private Map<String, String> supplyOrgTypeSaveMap = new HashMap<String, String>(8);
    private Map<String, String> priority = new HashMap<String, String>(8);
    private Map<Long, Long> multiorgsupdemAndDny = new HashMap<Long, Long>(8);
    private Map<String, Map<String, Long>> stockAndOrgMap = new HashMap<String, Map<String, Long>>(8);
    private Map<String, Map<String, Long>> stockAndStockIndexMap = new HashMap<String, Map<String, Long>>(8);
    private Map<String, String> exitOrgAndstockAndStockIndexMap = new HashMap<String, String>(8);
    private Map<String, String> supplyTypeMap = new HashMap<String, String>(8);
    private Map<String, Long> stockTypeMap = new HashMap<String, Long>(8);
    private Map<String, Long> stockStatusMap = new HashMap<String, Long>(8);
    private Map<String, String> supplyOrgTypeNumberMap = new HashMap<String, String>(8);
    private Map<String, Long> allMaterialNumberMap = new HashMap<String, Long>(8);
    private List<String> exitMaterialNumberList = new ArrayList<String>(8);
    private Map<String, String> otherscaleMap = new HashMap<String, String>(8);
    private Map<String, Map<BigDecimal, Integer>> supplyOrgTypeAndRatio = new HashMap<String, Map<BigDecimal, Integer>>(8);
    private Map<String, String> demandOrgMap = new HashMap<String, String>(8);
    private Map<Integer, String> errorMessageMap = new HashMap<Integer, String>(8);
    private Map<String, Long> allOrgNumberMap = new HashMap<String, Long>(8);
    private BigDecimal supplyratio = BigDecimal.ZERO;
    private boolean isCheckDeafaultSupply = true;
    private String stockNumber = "";
    private String materialNumber = "";
    private String demandOrgNumber = "";
    private String supplyOrgNumber = "";
    private String supplyOrgType = "";
    private int beginRow = 0;
    private int endRow = 0;
    private int supplyTypeBeginRow = 0;
    private int supplyTypeEndRow = 0;
    private int supplyBaseNum = 0;
    private static final String SUPPLYORG = "supplyorg";
    private static final String STOCKSUPPLY = "stocksupply";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndetails", "btnresult", "btnsuspend", "btncancel"});
        ProgressBar progressbar = (ProgressBar)this.getControl("progressbarap");
        progressbar.addProgressListener((ProgresssListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCreateNewData(EventObject e) {
        IFormView view = this.getView();
        view.setVisible(Boolean.FALSE, new String[]{"failpanel", "successpanel", "buttonap", "btnok", "suspendpanel", "btncancel"});
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        try (ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)("ImportingPlugin" + this.getView().getPageId()), (int)1);){
            this.setBillName();
            progressBar.start();
            Dealdata myTask = new Dealdata(RequestContext.get(), this.getView());
            threadPool.execute((Runnable)myTask);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (key.equals("btndetails")) {
            try {
                XSSFWorkbook errorBook = this.creatErrorBook();
                this.setErrorMessageToExcel(errorBook);
                String title = String.format(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f\u2014\u2014%s", (String)"ImportingPlugin_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getExcelName());
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.writeFile(errorBook, title));
                HashMap<String, String> map = new HashMap<String, String>(8);
                map.put("nodeMessage", this.getPageCache().get("nodeMessage"));
                this.getView().returnDataToParent(map);
                this.getView().close();
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        } else if ("btncancel".equals(key)) {
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("nodeMessage", this.getPageCache().get("nodeMessage"));
            this.getView().returnDataToParent(map);
            this.getView().close();
        } else if ("btnresult".equals(key)) {
            this.putDataToParent();
        }
    }

    private void putDataToParent() {
        HashMap<String, String> map = new HashMap<String, String>(8);
        map.put("time", this.getPageCache().get("time"));
        map.put("success", this.getPageCache().get("success"));
        map.put("faile", this.getPageCache().get("errorMessage"));
        map.put("url", this.getUrl());
        map.put("nodeMessage", this.getPageCache().get("nodeMessage"));
        this.getView().returnDataToParent(map);
        this.getView().close();
    }

    private void setErrorMessageToExcel(XSSFWorkbook errorBook) {
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("errorMessage"));
        XSSFSheet errorSheet = errorBook.getSheetAt(0);
        CellStyle cellStyle = this.creatErrorBookCellStyle(errorBook);
        for (Map.Entry mapEntry : map.entrySet()) {
            XSSFRow row = errorSheet.getRow(((Integer)mapEntry.getKey()).intValue());
            XSSFCell cell = row.getCell(0);
            if (cell == null) {
                cell = row.createCell(0);
            }
            cell.setCellStyle(cellStyle);
            row.getCell(0).setCellValue((String)mapEntry.getValue());
        }
    }

    private String getExcelName() {
        String[] split = this.getUrl().split("/");
        return split[split.length - 1];
    }

    private CellStyle creatErrorBookCellStyle(XSSFWorkbook errorBook) {
        XSSFCellStyle style = errorBook.createCellStyle();
        XSSFFont font = errorBook.createFont();
        font.setColor((short)10);
        style.setFont((Font)font);
        return style;
    }

    private String getUrl() {
        return (String)this.getView().getFormShowParameter().getCustomParam("url");
    }

    private XSSFWorkbook creatErrorBook() throws IOException {
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = service.getInputStream(this.getUrl());
        XSSFWorkbook xssFWorkbook = new XSSFWorkbook(in);
        XSSFSheet firstSheet = xssFWorkbook.getSheetAt(0);
        XSSFWorkbook errorBook = new XSSFWorkbook();
        XSSFSheet errorSheet = errorBook.createSheet();
        errorSheet.setColumnWidth(0, 5000);
        for (int i = 0; i <= firstSheet.getLastRowNum(); ++i) {
            XSSFRow row = firstSheet.getRow(i);
            XSSFRow errorRow = errorSheet.createRow(i);
            if (i == 2) {
                errorRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ImportingPlugin_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            this.copyRow(errorRow, row, errorSheet);
        }
        return errorBook;
    }

    private void copyRow(XSSFRow errorxssfRow, XSSFRow row, XSSFSheet errorSheet) {
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            errorSheet.setColumnWidth(i, 5000);
            XSSFCell xssfCell = row.getCell(i);
            if (xssfCell == null) continue;
            XSSFCell newCell = errorxssfRow.createCell(i + 1);
            this.copyCell(xssfCell, newCell);
        }
    }

    private void copyCell(XSSFCell xssfCell, XSSFCell newCell) {
        if (CellType.STRING.equals((Object)xssfCell.getCellType()) || CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
            if (CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
                newCell.setCellValue(NumberToTextConverter.toText((double)xssfCell.getNumericCellValue()).trim());
            } else {
                newCell.setCellValue(xssfCell.getStringCellValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private void setBillName() {
        Label labelap4 = (Label)this.getControl("labelap4");
        String imTitle = this.getImTitle();
        labelap4.setText(ResManager.loadKDString((String)imTitle, (String)"ImportingPlugin_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        Dealdata dealdata = new Dealdata(RequestContext.get(), this.getView());
        FileService service = FileServiceFactory.getAttachmentFileService();
        InputStream in = service.getInputStream(this.getUrl());
        XSSFSheet firstSheet = dealdata.getFirstSheet(in);
        Label rowCount = (Label)this.getControl("rowcount");
        rowCount.setText(firstSheet.getLastRowNum() + "");
    }

    private String getImTitle() {
        String sign = (String)this.getView().getFormShowParameter().getCustomParam("sign");
        if (SUPPLYORG.equals(sign)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5bfc\u5165\u4f9b\u5e94\u7f51\u7edc\u3002", (String)"ImportingPlugin_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        }
        if (STOCKSUPPLY.equals(sign)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5bfc\u5165\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ImportingPlugin_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5728\u5bfc\u5165\u591a\u7ec4\u7ec7\u4f9b\u9700\u5173\u7cfb\u4e2d\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"ImportingPlugin_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
    }

    public void onProgress(ProgressEvent evt) {
        int progress = this.getProgress();
        ProgressBar progressBar = (ProgressBar)evt.getSource();
        if (progress == 0) {
            Label rowCount = (Label)this.getControl("currentrow");
            rowCount.setText(this.getView().getPageCache().get("rowcount"));
        }
        evt.setProgress(progress * 100);
        if (progress * 100 == 100) {
            String errorMessage = this.getPageCache().get("errorMessage");
            if (errorMessage != null) {
                this.errorMessageMap = (Map)SerializationUtils.deSerializeFromBase64((String)errorMessage);
            }
            if (this.errorMessageMap.containsKey(-1)) {
                progressBar.stop();
                throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u6545\u969c\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"ImportingPlugin_57", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            this.getView().setVisible(Boolean.FALSE, new String[]{"importpanel", "btnsuspend", "suspendpanel"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"buttonap", "btncancel"});
            int row = Integer.parseInt(this.getPageCache().get("success"));
            if (row < 0) {
                row = 0;
            }
            if (this.errorMessageMap.size() != 0) {
                Label success = (Label)this.getControl("success");
                Label fail = (Label)this.getControl("failed");
                success.setText("" + row);
                fail.setText("" + this.errorMessageMap.size());
                try {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"failpanel"});
                    HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                    notHidden.put("gr", 1);
                    this.getView().updateControlMetadata("failpanel", notHidden);
                }
                catch (Exception e) {
                    progressBar.stop();
                    throw new KDBizException(e.getMessage());
                }
                progressBar.stop();
            } else {
                Label success = (Label)this.getControl("successall");
                success.setText("" + row);
                this.getView().setVisible(Boolean.TRUE, new String[]{"successpanel"});
                HashMap<String, Integer> notHidden = new HashMap<String, Integer>();
                notHidden.put("gr", 1);
                this.getView().updateControlMetadata("successpanel", notHidden);
                progressBar.stop();
            }
        }
    }

    private int getProgress() {
        String str = this.getPageCache().get(CACHEKEY_PROGRESS);
        return StringUtils.isBlank((CharSequence)str) ? 0 : Integer.parseInt(str);
    }

    public class Dealdata
    implements Runnable {
        private RequestContext rc;
        private IFormView view;

        public Dealdata(RequestContext rc, IFormView view) {
            this.rc = rc;
            this.view = view;
        }

        @Override
        public void run() {
            RequestContext.set((RequestContext)this.rc);
            Long beginTime = TimeServiceHelper.getTimeStamp();
            this.executeData();
            this.saveData();
            Long endtime = TimeServiceHelper.getTimeStamp() + 1000L;
            this.view.getPageCache().put("time", beginTime + "," + endtime);
        }

        private void saveData() {
            try {
                Object[] save1;
                ArrayList<DynamicObject[]> copyid;
                ArrayList<Long> alreadycopy;
                String nodeMessage;
                String save = ImportingPlugin.this.getPageCache().get("save");
                if (save == null) {
                    return;
                }
                List saveData = (List)SerializationUtils.deSerializeFromBase64((String)save);
                ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(16);
                HashMap<Long, DynamicObject> nodedetail = new HashMap<Long, DynamicObject>(8);
                DynamicObject dynamicObject1 = ORM.create().newDynamicObject(ImportingPlugin.NODEDETAILS);
                if (ImportingPlugin.this.multiorgsupdemAndDny.size() != 0) {
                    DynamicObject[] dynamicObjects;
                    for (DynamicObject mapEntry : dynamicObjects = (DynamicObject[])BusinessDataServiceHelper.load((Object[])ImportingPlugin.this.multiorgsupdemAndDny.values().toArray(), (IDataEntityType)dynamicObject1.getDataEntityType())) {
                        nodedetail.put(mapEntry.getLong(ImportingPlugin.ID), mapEntry);
                    }
                }
                HashMap map = (nodeMessage = this.getNodeMessage()) == null ? new HashMap(8) : (HashMap)SerializationUtils.deSerializeFromBase64((String)nodeMessage);
                map.put("datachange", new ArrayList(8));
                ArrayList<Long> add = (ArrayList<Long>)map.get("add");
                if (add == null) {
                    add = new ArrayList<Long>();
                }
                if ((alreadycopy = (ArrayList<Long>)map.get("alreadycopy")) == null) {
                    alreadycopy = new ArrayList<Long>();
                }
                if ((copyid = (ArrayList<DynamicObject[]>)map.get("copyid")) == null) {
                    copyid = new ArrayList<DynamicObject[]>();
                }
                boolean isNew = false;
                ORM orm = ORM.create();
                ArrayList<DynamicObject> dynList = new ArrayList<DynamicObject>(8);
                for (MultiorgsupdemPojo multiorgsupdemPojo : saveData) {
                    DynamicObject dynamicObject = null;
                    if (ImportingPlugin.this.multiorgsupdemAndDny.containsKey(multiorgsupdemPojo.getId())) {
                        dynamicObject = (DynamicObject)nodedetail.get(ImportingPlugin.this.multiorgsupdemAndDny.get(multiorgsupdemPojo.getId()));
                        if (!add.contains(dynamicObject.getLong(ImportingPlugin.ID)) && !alreadycopy.contains(dynamicObject.getLong(ImportingPlugin.ID))) {
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            DynamicObject newDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
                            newDyn.set(ImportingPlugin.ENABLE, (Object)0);
                            dynList.add(newDyn);
                            alreadycopy.add(dynamicObject.getLong(ImportingPlugin.ID));
                            map.put("alreadycopy", alreadycopy);
                        }
                    } else {
                        dynamicObject = this.getDynamicObjects(orm);
                        isNew = true;
                    }
                    if (ImportingPlugin.this.multiorgsupdemAndDny.size() != 0) {
                        isNew = false;
                    }
                    if (ImportingPlugin.SUPPLYORG.equals(this.getSign())) {
                        this.setDefaultsupplyBase(dynamicObject, isNew, multiorgsupdemPojo);
                        this.setDefaultsupplyValue(dynamicObject, multiorgsupdemPojo, isNew);
                        this.setMaterialentryentity(dynamicObject, multiorgsupdemPojo, isNew);
                        this.setSupplyorgentryentity(dynamicObject, multiorgsupdemPojo, isNew);
                    } else if (ImportingPlugin.STOCKSUPPLY.equals(this.getSign())) {
                        this.setStocksupplyBase(dynamicObject, isNew, multiorgsupdemPojo);
                        this.setStocksorgentrentryentity(dynamicObject, isNew, multiorgsupdemPojo);
                        this.setStocksetupentryentity(dynamicObject, isNew, multiorgsupdemPojo);
                        this.setMaterialsetup(dynamicObject, isNew, multiorgsupdemPojo);
                    }
                    list.add(dynamicObject);
                    this.view.getPageCache().put(ImportingPlugin.CACHEKEY_PROGRESS, saveData.size() / list.size() + "");
                }
                if (dynList.size() != 0) {
                    save1 = SaveServiceHelper.save((DynamicObject[])dynList.toArray(new DynamicObject[dynList.size()]));
                    DynamicObject[] copy = (DynamicObject[])((DynamicObject)save1[0]).getPkValue();
                    copyid.add(copy);
                    map.put("copyid", copyid);
                }
                if (list.size() != 0) {
                    save1 = SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
                    for (DynamicObject dynamicObject : (DynamicObject[])save1) {
                        if (alreadycopy.contains(dynamicObject.getLong(ImportingPlugin.ID))) continue;
                        add.add(dynamicObject.getLong(ImportingPlugin.ID));
                        map.put("add", add);
                    }
                    this.view.getPageCache().put("nodeMessage", SerializationUtils.serializeToBase64(map));
                    if (!ImportingPlugin.SUPPLYORG.equals(this.getSign())) {
                        DynamicObject[] dynamicObjects = new DynamicObject[save1.length];
                        int i = 0;
                        for (DynamicObject dynamicObject : (DynamicObject[])save1) {
                            this.changOrAndStockToShowentity(dynamicObject, isNew);
                            dynamicObjects[i] = dynamicObject;
                            ++i;
                        }
                        SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                    }
                } else {
                    this.setProgress(1);
                }
            }
            catch (Exception ex) {
                logger.error((Throwable)ex);
                this.view.getPageCache().put("errorMessage", SerializationUtils.serializeToBase64((Object)ImportingPlugin.this.errorMessageMap));
                this.setProgress(1);
            }
        }

        private DynamicObject getDynamicObjects(ORM orm) {
            return orm.newDynamicObject(ImportingPlugin.NODEDETAILS);
        }

        private void setMaterialsetup(DynamicObject dynamicObject, boolean isNew, MultiorgsupdemPojo multiorgsupdemPojo) {
            DynamicObjectCollection materialsetup = dynamicObject.getDynamicObjectCollection("materialsetup");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && materialsetup != null) {
                materialsetup.clear();
            }
            if (multiorgsupdemPojo.getMaterialsetup() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getMaterialsetup().entrySet()) {
                if (materialsetup == null) break;
                DynamicObject newDny = materialsetup.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void setStocksetupentryentity(DynamicObject dynamicObject, boolean isNew, MultiorgsupdemPojo multiorgsupdemPojo) {
            DynamicObjectCollection stocksetupentryentity = dynamicObject.getDynamicObjectCollection("stocksetupentryentity");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && stocksetupentryentity != null) {
                stocksetupentryentity.clear();
            }
            if (multiorgsupdemPojo.getStocksetupentryentity() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getStocksetupentryentity().entrySet()) {
                if (stocksetupentryentity == null) break;
                DynamicObject newDny = stocksetupentryentity.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void setStocksorgentrentryentity(DynamicObject dynamicObject, boolean isNew, MultiorgsupdemPojo multiorgsupdemPojo) {
            DynamicObjectCollection stocksorgentrentryentity = dynamicObject.getDynamicObjectCollection("stocksorgentrentryentity");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && stocksorgentrentryentity != null) {
                stocksorgentrentryentity.clear();
            }
            if (multiorgsupdemPojo.getStocksorgentrentryentity() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getStocksorgentrentryentity().entrySet()) {
                if (stocksorgentrentryentity == null) break;
                DynamicObject newDny = stocksorgentrentryentity.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void setStocksupplyBase(DynamicObject dynamicObject, boolean isNew, MultiorgsupdemPojo multiorgsupdemPojo) {
            dynamicObject.set("stockdemandorg", (Object)multiorgsupdemPojo.getStockdemandorg());
            dynamicObject.set(ImportingPlugin.PARENTDNYID, (Object)this.getDny());
            dynamicObject.set(ImportingPlugin.ENABLE, (Object)"1");
            dynamicObject.set("bodtime", (Object)multiorgsupdemPojo.getBodtime());
            this.setMuBaseData(dynamicObject, multiorgsupdemPojo.getStocktype(), "stocktype", isNew);
            this.setMuBaseData(dynamicObject, multiorgsupdemPojo.getStockstatus(), "stockstatus", isNew);
            dynamicObject.set("stocksetup", (Object)multiorgsupdemPojo.getStocksetup());
        }

        private void setSupplyorgentryentity(DynamicObject dynamicObject, MultiorgsupdemPojo multiorgsupdemPojo, boolean isNew) {
            DynamicObjectCollection supplyorg = dynamicObject.getDynamicObjectCollection("supplyorgentryentity");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && supplyorg != null) {
                supplyorg.clear();
            }
            if (multiorgsupdemPojo.getSupplyOrgEntryentity() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getSupplyOrgEntryentity().entrySet()) {
                if (supplyorg == null) break;
                DynamicObject newDny = supplyorg.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void setMaterialentryentity(DynamicObject dynamicObject, MultiorgsupdemPojo multiorgsupdemPojo, boolean isNew) {
            DynamicObjectCollection materialsupply = dynamicObject.getDynamicObjectCollection("materialentryentity");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && materialsupply != null) {
                materialsupply.clear();
            }
            if (multiorgsupdemPojo.getMaterialEntryentity() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getMaterialEntryentity().entrySet()) {
                if (materialsupply == null) break;
                DynamicObject newDny = materialsupply.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void setDefaultsupplyBase(DynamicObject dynamicObject, boolean isNew, MultiorgsupdemPojo multiorgsupdemPojo) {
            dynamicObject.set("demandorg", (Object)multiorgsupdemPojo.getDemandorg());
            dynamicObject.set(ImportingPlugin.PARENTDNYID, (Object)this.getDny());
            dynamicObject.set(ImportingPlugin.ENABLE, (Object)"1");
            dynamicObject.set("supplyorggrouptext_tag", (Object)multiorgsupdemPojo.getSupplyorggrouptext());
        }

        private void setDefaultsupplyValue(DynamicObject dynamicObject, MultiorgsupdemPojo multiorgsupdemPojo, boolean isNew) {
            DynamicObjectCollection defaultsupply = dynamicObject.getDynamicObjectCollection("defaultsupply");
            if (("override".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) && defaultsupply != null) {
                defaultsupply.clear();
            }
            if (multiorgsupdemPojo.getDefaultSupply() == null) {
                return;
            }
            for (Map.Entry mapEntry : multiorgsupdemPojo.getDefaultSupply().entrySet()) {
                if (defaultsupply == null) break;
                DynamicObject newDny = defaultsupply.addNew();
                Map value = (Map)mapEntry.getValue();
                for (Map.Entry valueEntry : value.entrySet()) {
                    newDny.set((String)valueEntry.getKey(), valueEntry.getValue());
                }
            }
        }

        private void executeData() {
            try (InputStream inputStream = this.getInputStream();){
                try {
                    XSSFSheet firstSheet = this.getFirstSheet(inputStream);
                    this.getInitData();
                    this.getDemandOrgRow(firstSheet);
                    int lastRowNum = firstSheet.getLastRowNum();
                    ArrayList<MultiorgsupdemPojo> list = new ArrayList<MultiorgsupdemPojo>(8);
                    for (int i = 4; i <= lastRowNum; ++i) {
                        XSSFRow row = firstSheet.getRow(i);
                        if (this.isContinueRow(i) || row == null) continue;
                        if (ImportingPlugin.this.endRow == 0 || i > ImportingPlugin.this.endRow) {
                            ImportingPlugin.this.beginRow = 0;
                            ImportingPlugin.this.endRow = 0;
                            this.checkCols(row, firstSheet);
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                list.add(ImportingPlugin.this.saveIm);
                            }
                        }
                        this.view.getPageCache().put("rowcount", i - 4 + "");
                    }
                    this.view.getPageCache().put("save", SerializationUtils.serializeToBase64(list));
                    this.view.getPageCache().put("success", list.size() + "");
                    this.view.getPageCache().put("errorMessage", SerializationUtils.serializeToBase64((Object)ImportingPlugin.this.errorMessageMap));
                    this.view.getPageCache().put("row", ImportingPlugin.this.demandOrgMap.size() + "");
                }
                catch (Exception ex) {
                    ImportingPlugin.this.errorMessageMap.put(-1, ex.toString());
                    this.view.getPageCache().put("errorMessage", SerializationUtils.serializeToBase64((Object)ImportingPlugin.this.errorMessageMap));
                    this.setProgress(1);
                    logger.error((Throwable)ex);
                }
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }

        private boolean isContinueRow(int i) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                if (ImportingPlugin.this.endRow < i) {
                    ImportingPlugin.this.isCheckDeafaultSupply = true;
                    ImportingPlugin.this.beginRow = 0;
                    ImportingPlugin.this.endRow = 0;
                    ImportingPlugin.this.demandOrgNumber = "";
                } else {
                    return true;
                }
            }
            return false;
        }

        private void initData() {
            ImportingPlugin.this.supplyOrgNumberList = new ArrayList(8);
            ImportingPlugin.this.exitMaterialNumberList = new ArrayList(8);
            ImportingPlugin.this.exitOrgAndstockAndStockIndexMap = new HashMap(8);
            ImportingPlugin.this.supplyOrgTypeAndRatio = new HashMap(8);
            ImportingPlugin.this.priority = new HashMap(8);
            ImportingPlugin.this.supplyratio = BigDecimal.ZERO;
            ImportingPlugin.this.supplyBaseNum = 0;
        }

        private void checkCols(XSSFRow row, XSSFSheet firstSheet) {
            this.checkDemandOrgNumber(row, firstSheet);
            if (ImportingPlugin.this.beginRow == row.getRowNum()) {
                this.initData();
                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                    if (ImportingPlugin.SUPPLYORG.equals(this.getSign())) {
                        this.checkDeafaultSupply(firstSheet);
                        ImportingPlugin.this.supplyratio = BigDecimal.ZERO;
                        ImportingPlugin.this.supplyOrgNumberList = new ArrayList();
                        this.checkSpecialEntity(firstSheet);
                        ImportingPlugin.this.saveIm.setSupplyorggrouptext(SerializationUtils.serializeToBase64((Object)ImportingPlugin.this.supplyOrgTypeSaveMap));
                    } else if (ImportingPlugin.STOCKSUPPLY.equals(this.getSign())) {
                        this.checkbodTime(firstSheet);
                        this.checkStocType(firstSheet, 3, ImportingPlugin.this.stockTypeMap);
                        this.checkStocType(firstSheet, 5, ImportingPlugin.this.stockStatusMap);
                        this.checkStockOrg(firstSheet);
                        this.chenckStocksetup(firstSheet);
                        this.checkStockSetUp(firstSheet);
                        this.checkStockMaterial(firstSheet);
                    }
                    if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                        return;
                    }
                }
            } else {
                return;
            }
        }

        private void checkbodTime(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                XSSFRow row = firstSheet.getRow(i);
                String cellValue = this.getFieldCellValue(row, "bodtime");
                if (i != ImportingPlugin.this.beginRow) continue;
                if (cellValue.isEmpty()) {
                    ImportingPlugin.this.saveIm.setBodtime(0);
                    continue;
                }
                try {
                    int bodTime = Integer.parseInt(cellValue);
                    if (0 > bodTime || bodTime > 1000) {
                        errorMessage = ResManager.loadKDString((String)"\u8fd0\u8f93\u5468\u671f\u8bf7\u586b\u5199[0,1000]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"ImportingPlugin_58", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                        continue;
                    }
                    ImportingPlugin.this.saveIm.setBodtime(bodTime);
                    continue;
                }
                catch (Exception ex) {
                    ImportingPlugin.this.saveIm.setBodtime(0);
                }
            }
            this.recordErroTip(ImportingPlugin.this.beginRow, errorMessage);
        }

        private void checkSpecialEntity(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            int errorRow = 0;
            int manullRow = 0;
            int sunullRow = 0;
            HashMap<String, HashMap<String, Object>> map_ma = new HashMap<String, HashMap<String, Object>>(8);
            HashMap<String, HashMap<String, Object>> map_su = new HashMap<String, HashMap<String, Object>>(8);
            ImportingPlugin.this.supplyOrgTypeSaveMap = new HashMap();
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow && ImportingPlugin.this.isCheckDeafaultSupply; ++i) {
                HashMap<String, Object> valueMap_ma = new HashMap<String, Object>(8);
                HashMap<String, Object> valueMap_su = new HashMap<String, Object>(8);
                XSSFRow row = firstSheet.getRow(i);
                String supplyBaseCellValue = this.getFieldCellValue(row, "supplyorggroupbase.number");
                String materialCellValue = this.getFieldCellValue(row, "materialnumber.number");
                String orgCelllValue = this.getFieldCellValue(row, "supplyorg.number");
                String ratioCellValue = this.getFieldCellValue(row, "supplyproportion");
                String ruleCellValue = this.getFieldCellValue(row, "supplyrule");
                if (ImportingPlugin.this.supplyTypeMap.size() == 0) {
                    if (!(materialCellValue.isEmpty() && orgCelllValue.isEmpty() && ratioCellValue.isEmpty() && ruleCellValue.isEmpty())) {
                        errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        errorRow = ImportingPlugin.this.beginRow;
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                } else {
                    if (ImportingPlugin.this.supplyTypeBeginRow == 0 || i > ImportingPlugin.this.supplyTypeEndRow) {
                        ImportingPlugin.this.supplyOrgType = "";
                        ImportingPlugin.this.supplyOrgNumber = "";
                        ImportingPlugin.this.materialNumber = "";
                        ImportingPlugin.this.supplyratio = BigDecimal.ZERO;
                        ImportingPlugin.this.supplyOrgNumberList = new ArrayList();
                        ImportingPlugin.this.specialSupplyOrgNumberMap = new HashMap();
                        this.getSupplyTypeRnageRow(supplyBaseCellValue, i);
                        manullRow = 0;
                        sunullRow = 0;
                    }
                    if (i <= ImportingPlugin.this.supplyTypeEndRow) {
                        if (i == ImportingPlugin.this.supplyTypeBeginRow) {
                            ImportingPlugin.this.supplyOrgType = supplyBaseCellValue;
                            ImportingPlugin.this.supplyBaseNum++;
                            if (!ImportingPlugin.this.supplyOrgTypeNumberMap.containsKey(ImportingPlugin.this.supplyOrgType)) {
                                errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u5206\u7c7b\u4e0d\u5b58\u5728\u5f53\u524d\u4f9b\u5e94\u7ec4\u7ec7\u5206\u7c7b\u7f16\u7801\u3002", (String)"ImportingPlugin_41", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                                errorRow = i;
                                ImportingPlugin.this.isCheckDeafaultSupply = false;
                            } else {
                                valueMap_ma.put("msupplyorggroup", ((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(ImportingPlugin.this.supplyOrgType)).split(",")[0]);
                                ImportingPlugin.this.supplyOrgTypeSaveMap.put(((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(supplyBaseCellValue)).split(",")[0] + "_" + ImportingPlugin.this.supplyBaseNum, ((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(supplyBaseCellValue)).split(",")[1]);
                            }
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                this.checkMaterialNumber(materialCellValue, i, valueMap_ma, "materialnumber");
                            }
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                this.checkSupplyOrgNumber(orgCelllValue, i, valueMap_su, ImportingPlugin.SUPPLYORG);
                            }
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                this.checkSupplyRatio(ratioCellValue, i, valueMap_su, "supplyproportion");
                            }
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                this.checkSupplyRule(ruleCellValue, i, valueMap_su, "supplyrule");
                            }
                            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                valueMap_su.put("ssupplyorggroup", ((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(ImportingPlugin.this.supplyOrgType)).split(",")[0]);
                                map_ma.put(i - ImportingPlugin.this.beginRow + "", valueMap_ma);
                                map_su.put(i - ImportingPlugin.this.beginRow + "", valueMap_su);
                            }
                        } else {
                            if (materialCellValue.isEmpty()) {
                                if (manullRow == 0) {
                                    ImportingPlugin.this.materialNumber = "";
                                    manullRow = i;
                                } else if (!ImportingPlugin.this.materialNumber.isEmpty()) {
                                    errorMessage = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_109", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                                    errorRow = manullRow;
                                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                                }
                            } else {
                                this.checkMaterialNumber(materialCellValue, i, valueMap_ma, "materialnumber");
                                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                    valueMap_ma.put("msupplyorggroup", ((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(ImportingPlugin.this.supplyOrgType)).split(",")[0]);
                                    map_ma.put(i - ImportingPlugin.this.beginRow + "", valueMap_ma);
                                }
                            }
                            if (orgCelllValue.isEmpty() && ratioCellValue.isEmpty() && ruleCellValue.isEmpty()) {
                                if (sunullRow == 0) {
                                    ImportingPlugin.this.supplyOrgNumber = "";
                                    sunullRow = i;
                                } else if (!ImportingPlugin.this.supplyOrgNumber.isEmpty()) {
                                    errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_102", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                                    errorRow = sunullRow;
                                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                                }
                            } else {
                                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                    this.checkSupplyOrgNumber(orgCelllValue, i, valueMap_su, ImportingPlugin.SUPPLYORG);
                                }
                                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                    this.checkSupplyRatio(ratioCellValue, i, valueMap_su, "supplyproportion");
                                }
                                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                    this.checkSupplyRule(ruleCellValue, i, valueMap_su, "supplyrule");
                                }
                                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                                    valueMap_su.put("ssupplyorggroup", ((String)ImportingPlugin.this.supplyOrgTypeNumberMap.get(ImportingPlugin.this.supplyOrgType)).split(",")[0]);
                                    map_su.put(i - ImportingPlugin.this.beginRow + "", valueMap_su);
                                }
                            }
                        }
                    }
                    if (i == ImportingPlugin.this.supplyTypeEndRow && ImportingPlugin.this.supplyratio.compareTo(BigDecimal.ONE) < 0 && ImportingPlugin.this.isCheckDeafaultSupply) {
                        this.recordErroTip(i, ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e0d\u7b49\u4e8e1\u3002", (String)"ImportingPlugin_106", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                }
                this.recordErroTip(errorRow, errorMessage);
            }
            ImportingPlugin.this.saveIm.setMaterialEntryentity(map_ma);
            ImportingPlugin.this.saveIm.setSupplyOrgEntryentity(map_su);
        }

        private void getSupplyTypeRnageRow(String cellValue, int i) {
            String rnageRow = (String)ImportingPlugin.this.supplyTypeMap.get(cellValue + "_" + i);
            if (rnageRow != null && rnageRow.contains(",")) {
                ImportingPlugin.this.supplyTypeEndRow = Integer.parseInt(rnageRow.split(",")[1]);
                ImportingPlugin.this.supplyTypeBeginRow = Integer.parseInt(rnageRow.split(",")[0]);
            }
        }

        private void checkStockMaterial(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            int nullRow = 0;
            ImportingPlugin.this.priority = new HashMap();
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                XSSFRow row = firstSheet.getRow(i);
                String materielCellValue = this.getFieldCellValue(row, "materiel.number");
                String materialorgCellValue = this.getFieldCellValue(row, "materialorg.number");
                String stockCellValue = this.getFieldCellValue(row, "stock.number");
                String stockindexsCellValue = this.getFieldCellValue(row, "stockindexs.number");
                String prioritylevelcellValue = this.getFieldCellValue(row, "prioritylevel");
                String stockratioCellValue = this.getFieldCellValue(row, "stockratio");
                if (i == ImportingPlugin.this.beginRow) {
                    if (materielCellValue.isEmpty() && materialorgCellValue.isEmpty() && stockCellValue.isEmpty() && stockindexsCellValue.isEmpty() && prioritylevelcellValue.isEmpty() && stockratioCellValue.isEmpty()) {
                        nullRow = ImportingPlugin.this.beginRow;
                        continue;
                    }
                    this.checkOrgAndMaterial(materielCellValue, materialorgCellValue, stockCellValue, stockindexsCellValue, prioritylevelcellValue, stockratioCellValue, valueMap, i, map);
                    continue;
                }
                if (nullRow == 0) {
                    if (materielCellValue.isEmpty() && materialorgCellValue.isEmpty() && stockCellValue.isEmpty() && stockindexsCellValue.isEmpty() && prioritylevelcellValue.isEmpty() && stockratioCellValue.isEmpty()) {
                        nullRow = i;
                        continue;
                    }
                    this.checkOrgAndMaterial(materielCellValue, materialorgCellValue, stockCellValue, stockindexsCellValue, prioritylevelcellValue, stockratioCellValue, valueMap, i, map);
                    continue;
                }
                if (materielCellValue.isEmpty() && materialorgCellValue.isEmpty() && stockCellValue.isEmpty() && stockindexsCellValue.isEmpty() && prioritylevelcellValue.isEmpty() && stockratioCellValue.isEmpty()) continue;
                errorMessage = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_109", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            ImportingPlugin.this.saveIm.setMaterialsetup(map);
            this.recordErroTip(nullRow, errorMessage);
        }

        private void checkOrgAndMaterial(String materialcellValue, String orgCellValue, String stockCellValue, String stockIndexcellValue, String prioritycellValue, String stockratiocellValue, Map<String, Object> valueMap, int i, Map<String, Map<String, Object>> map) {
            this.checkStockMaterialNumber(materialcellValue, i, valueMap, "materiel");
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkMaterialOrgNumber(orgCellValue, i, valueMap, "materialorg");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStock(stockCellValue, i, valueMap, "stock");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockIndex(stockIndexcellValue, i, valueMap, "stockindexs");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockSetPriority(prioritycellValue, i, valueMap, "prioritylevel");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockscale(stockratiocellValue, i, valueMap, "stockratio");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                map.put(i - ImportingPlugin.this.beginRow + "", valueMap);
            }
        }

        private void checkMaterialOrgNumber(String cellValue, int i, Map<String, Object> valueMap, String materialorg) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            if (cellValue.isEmpty()) {
                errorMessage = ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_17", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else if (!ImportingPlugin.this.allOrgNumberMap.containsKey(cellValue)) {
                errorMessage = ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u4e2d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_107", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else {
                ImportingPlugin.this.supplyOrgNumber = cellValue;
                valueMap.put(materialorg, ImportingPlugin.this.allOrgNumberMap.get(cellValue));
            }
            this.recordErroTip(i, errorMessage);
        }

        private void chenckStocksetup(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                XSSFRow row = firstSheet.getRow(i);
                String stocksetupcellValue = this.getFieldCellValue(row, "stocksetup");
                if (i != ImportingPlugin.this.beginRow) continue;
                if (!stocksetupcellValue.isEmpty()) {
                    if (!ImportingPlugin.this.stocksetup.contains(stocksetupcellValue)) {
                        errorMessage = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u4ed3\u5e93\u8fd0\u7b97\u8303\u56f4\u3002", (String)"ImportingPlugin_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                        continue;
                    }
                    String stockSetup = this.getStockSetup(stocksetupcellValue);
                    ImportingPlugin.this.saveIm.setStocksetup(stockSetup);
                    continue;
                }
                errorMessage = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4ed3\u5e93\u8fd0\u7b97\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_70", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(ImportingPlugin.this.beginRow, errorMessage);
        }

        private String getStockSetup(String cellValue) {
            if (ResManager.loadKDString((String)"\u5168\u90e8\u4ed3\u5e93", (String)"ImportingPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(cellValue)) {
                return "1";
            }
            if (ResManager.loadKDString((String)"\u6307\u5b9a\u4ed3\u5e93", (String)"ImportingPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(cellValue)) {
                return "2";
            }
            return "3";
        }

        private void checkStockSetUp(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            if ("1".equals(ImportingPlugin.this.saveIm.getStocksetup())) {
                return;
            }
            int nullRow = 0;
            String errorMessage = null;
            ImportingPlugin.this.priority = new HashMap(8);
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                XSSFRow row = firstSheet.getRow(i);
                String stockorgcellValue = this.getFieldCellValue(row, "stockorg.number");
                String stocknumbercellValue = this.getFieldCellValue(row, "stocknumber.number");
                String stockindexcellValue = this.getFieldCellValue(row, "stockindex.number");
                String supplyprioritycellValue = this.getFieldCellValue(row, "supplypriority");
                String wastewarehousecellValue = this.getFieldCellValue(row, "wastewarehouse");
                if (i == ImportingPlugin.this.beginRow) {
                    this.checkStockSetUpCell(stockorgcellValue, stocknumbercellValue, stockindexcellValue, supplyprioritycellValue, wastewarehousecellValue, valueMap, map, i);
                    continue;
                }
                if (nullRow == 0) {
                    if (stockorgcellValue.isEmpty() && stocknumbercellValue.isEmpty() && stockindexcellValue.isEmpty() && supplyprioritycellValue.isEmpty() && wastewarehousecellValue.isEmpty()) {
                        nullRow = i;
                        continue;
                    }
                    this.checkStockSetUpCell(stockorgcellValue, stocknumbercellValue, stockindexcellValue, supplyprioritycellValue, wastewarehousecellValue, valueMap, map, i);
                    continue;
                }
                if (stockorgcellValue.isEmpty() && stocknumbercellValue.isEmpty() && stockindexcellValue.isEmpty() && supplyprioritycellValue.isEmpty() && wastewarehousecellValue.isEmpty()) continue;
                errorMessage = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_59", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                this.recordErroTip(nullRow, errorMessage);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            ImportingPlugin.this.saveIm.setStocksetupentryentity(map);
        }

        private void checkStockSetUpCell(String orgCellValue, String stockCellValue, String stockIndexcellValue, String prioritycellValue, String wastewarehousecellValue, Map<String, Object> valueMap, Map<String, Map<String, Object>> map, int i) {
            this.checkStockOrgNumber(orgCellValue, i, valueMap, "stockorg");
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStock(stockCellValue, i, valueMap, "stocknumber");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockIndex(stockIndexcellValue, i, valueMap, "stockindex");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockSetPriority(prioritycellValue, i, valueMap, "supplypriority");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkWastewarehouse(wastewarehousecellValue, i, valueMap, "wastewarehouse");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                map.put(i - ImportingPlugin.this.beginRow + "", valueMap);
            }
        }

        private void checkWastewarehouse(String cellValue, int i, Map<String, Object> valueMap, String wastewarehouse) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            if (cellValue.isEmpty()) {
                valueMap.put(wastewarehouse, "0");
            } else if (cellValue.equalsIgnoreCase("true") || cellValue.equals(ResManager.loadKDString((String)"\u662f", (String)"ImportingPlugin_71", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]))) {
                valueMap.put(wastewarehouse, "1");
            } else {
                valueMap.put(wastewarehouse, "0");
            }
        }

        private void checkStockIndex(String cellValue, int i, Map<String, Object> valueMap, String stockindex) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            Map map = (Map)ImportingPlugin.this.stockAndStockIndexMap.get(ImportingPlugin.this.stockNumber);
            if (!(cellValue.isEmpty() || map != null && map.containsKey(cellValue))) {
                errorMessage = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4ed3\u5e93\u7f16\u7801\u4e0e\u4ed3\u4f4d\u7f16\u7801\u4e0d\u5339\u914d\uff0c\u8bf7\u786e\u8ba4\u5f53\u524d\u884c\u4ed3\u5e93\u662f\u5426\u4e3a\u5f53\u524d\u884c\u4ed3\u4f4d\u7684\u4f7f\u7528\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                String key = ImportingPlugin.this.supplyOrgNumber + "," + ImportingPlugin.this.stockNumber + "," + cellValue;
                if ("stockindexs".equals(stockindex)) {
                    key = ImportingPlugin.this.materialNumber + "," + ImportingPlugin.this.supplyOrgNumber + "," + ImportingPlugin.this.stockNumber + "," + cellValue;
                }
                if (ImportingPlugin.this.exitOrgAndstockAndStockIndexMap.containsKey(key)) {
                    String s = (String)ImportingPlugin.this.exitOrgAndstockAndStockIndexMap.get(key);
                    s = s + "," + i;
                    errorMessage = "stockindexs".equals(stockindex) ? ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\uff0c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7,\u7269\u6599,\u4ed3\u5e93,\u4ed3\u4f4d\u90fd\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\uff0c\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"ImportingPlugin_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[]{s}) : ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\uff0c\u5b58\u5728\u5e93\u5b58\u7ec4\u7ec7,\u4ed3\u5e93,\u4ed3\u4f4d\u90fd\u76f8\u540c\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\uff0c\u8bf7\u5904\u7406\u91cd\u590d\u884c\u3002", (String)"ImportingPlugin_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[]{s});
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else {
                    ImportingPlugin.this.exitOrgAndstockAndStockIndexMap.put(key, i + "");
                    if (!cellValue.isEmpty()) {
                        valueMap.put(stockindex, map.get(cellValue));
                    } else {
                        valueMap.put(stockindex, null);
                    }
                }
            }
            this.recordErroTip(i, errorMessage);
        }

        private void checkStock(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            if (!cellValue.isEmpty()) {
                Map map = (Map)ImportingPlugin.this.stockAndOrgMap.get(ImportingPlugin.this.supplyOrgNumber);
                if (map == null || !map.containsKey(cellValue)) {
                    errorMessage = "stock".equals(field) ? ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u72b6\u6001\u3002", (String)"ImportingPlugin_121", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u72b6\u6001\u3002", (String)"ImportingPlugin_111", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else {
                    ImportingPlugin.this.stockNumber = cellValue;
                    valueMap.put(field, map.get(cellValue));
                }
            } else {
                errorMessage = !ImportingPlugin.this.materialNumber.isEmpty() && "stock".equals(field) ? ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_110", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4ed3\u5e93\u8fd0\u7b97\u8303\u56f4\u2260\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u7684\u4ed3\u5e93\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkStockOrg(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            int nullRow = 0;
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                XSSFRow row = firstSheet.getRow(i);
                String orgcellValue = this.getFieldCellValue(row, "storageorg.number");
                String priorityCellValue = this.getFieldCellValue(row, "priority");
                String scaleCellValue = this.getFieldCellValue(row, "stockscale");
                if (i == ImportingPlugin.this.beginRow) {
                    this.checkStockCell(orgcellValue, priorityCellValue, scaleCellValue, valueMap, map, i);
                    continue;
                }
                if (nullRow == 0) {
                    if (orgcellValue.isEmpty() && priorityCellValue.isEmpty() && scaleCellValue.isEmpty()) {
                        nullRow = i;
                        continue;
                    }
                    this.checkStockCell(orgcellValue, priorityCellValue, scaleCellValue, valueMap, map, i);
                    continue;
                }
                if (orgcellValue.isEmpty() && priorityCellValue.isEmpty() && scaleCellValue.isEmpty()) continue;
                errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_112", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                this.recordErroTip(nullRow, errorMessage);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            ImportingPlugin.this.saveIm.setStocksorgentrentryentity(map);
        }

        private void checkStockCell(String orgCellValue, String priorityCellValue, String scaleCellValue, Map<String, Object> valueMap, Map<String, Map<String, Object>> map, int i) {
            this.checkStockOrgNumber(orgCellValue, i, valueMap, "storageorg");
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockPriority(priorityCellValue, i, valueMap, "priority");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkStockscale(scaleCellValue, i, valueMap, "stockscale");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                map.put(i - ImportingPlugin.this.beginRow + "", valueMap);
            }
        }

        private void checkStockscale(String cellValue, int i, Map<String, Object> valueMap, String stockscale) {
            String errorMessage;
            block14: {
                if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                    return;
                }
                errorMessage = null;
                if (!cellValue.isEmpty()) {
                    try {
                        BigDecimal bigDecimal = new BigDecimal(cellValue).setScale(10, 1);
                        if (bigDecimal.compareTo(BigDecimal.ONE) > 0 || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                            errorMessage = stockscale.equals("stockscale") ? ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u8bf7\u586b\u5199[0,1]\u8303\u56f4\u5185\u7684\u503c\u3002", (String)"ImportingPlugin_27", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u8bf7\u586b\u5199[0,1]\u8303\u56f4\u5185\u7684\u503c\u3002", (String)"ImportingPlugin_92", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                            ImportingPlugin.this.isCheckDeafaultSupply = false;
                            break block14;
                        }
                        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) {
                            errorMessage = stockscale.equals("stockscale") ? ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a0\u3002", (String)"ImportingPlugin_28", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a0\u3002", (String)"ImportingPlugin_93", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                            ImportingPlugin.this.isCheckDeafaultSupply = false;
                            break block14;
                        }
                        if (!stockscale.equals("stockscale")) {
                            Long MaterialId = (Long)ImportingPlugin.this.allMaterialNumberMap.get(ImportingPlugin.this.materialNumber);
                            Long orgId = (Long)ImportingPlugin.this.allOrgNumberMap.get(ImportingPlugin.this.supplyOrgNumber);
                            String key = orgId + "," + MaterialId;
                            logger.info("checkStockscale:" + key);
                            logger.info("checkStockscale:" + ImportingPlugin.this.otherscaleMap.toString());
                            if (ImportingPlugin.this.otherscaleMap.containsKey(key)) {
                                String bigDecimalAndRow = (String)ImportingPlugin.this.otherscaleMap.get(key);
                                String[] split = bigDecimalAndRow.split("\\|\\|");
                                BigDecimal bigDecimal_n = new BigDecimal(split[0]).add(bigDecimal);
                                if (bigDecimal_n.compareTo(BigDecimal.ONE) > 0) {
                                    errorMessage = !split[1].contains(",") ? (split[1].equals("-1") ? String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u5728\u6570\u636e\u5e93\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%s,\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1,\u8bf7\u5904\u7406\u884c\u3002", (String)"ImportingPlugin_122", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), bigDecimal_n) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u5728\u6570\u636e\u5e93\u548c\u7b2c[%1$s]\u884c\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%2$s,\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1,\u8bf7\u5904\u7406\u884c\u3002", (String)"ImportingPlugin_123", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), i, bigDecimal_n)) : String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u4e2d\uff1a\u5e93\u5b58\u7ec4\u7ec7+\u7269\u6599\u5728\u6570\u636e\u5e93\u548c\u7b2c[%1$s]\u884c\u7684\u5404\u9879\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e4b\u548c\u4e3a%2$s,\u8be5\u503c\u5927\u4e8e\u5176\u4e0a\u9650\u503c1,\u8bf7\u5904\u7406\u884c\u3002", (String)"ImportingPlugin_123", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), i, bigDecimal_n);
                                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                                } else {
                                    if (split[1].equals("-1")) {
                                        ImportingPlugin.this.otherscaleMap.put(key, bigDecimal.toPlainString() + "||" + i);
                                    } else {
                                        String row = split[1] + "," + i;
                                        ImportingPlugin.this.otherscaleMap.put(key, bigDecimal.toPlainString() + "||" + row);
                                    }
                                    valueMap.put(stockscale, cellValue);
                                }
                            } else {
                                ImportingPlugin.this.otherscaleMap.put(key, bigDecimal.toPlainString() + "||" + i);
                                valueMap.put(stockscale, cellValue);
                            }
                            break block14;
                        }
                        valueMap.put(stockscale, cellValue);
                    }
                    catch (Exception ex) {
                        errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u6bd4\u4f8b\u8bf7\u586b\u5165\u6570\u503c\u3002", (String)"ImportingPlugin_120", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                } else {
                    errorMessage = stockscale.equals("stockscale") ? ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_105", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u53ef\u4f9b\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_94", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                }
            }
            this.recordErroTip(i, errorMessage);
        }

        private void checkStockSetPriority(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            if (!cellValue.isEmpty()) {
                try {
                    int i = Integer.parseInt(cellValue);
                    if (i < 0 || i > 0x7FFFFFFE) {
                        errorMessage = "supplypriority".equals(field) ? ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4ed3\u5e93\u4f9b\u8d27\u4f18\u5148\u7ea7\u8bf7\u586b\u5199[0,2147483646]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"ImportingPlugin_116", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u8d27\u4f18\u5148\u7ea7\u8bf7\u586b\u5199[0,2147483646]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"ImportingPlugin_117", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                }
                catch (Exception ex) {
                    cellValue = "0";
                }
                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                    if (ImportingPlugin.this.priority.containsKey(cellValue)) {
                        String s = (String)ImportingPlugin.this.priority.get(cellValue);
                        String[] split = s.split(",");
                        if ("prioritylevel".equals(field)) {
                            if (split[0].equals(ImportingPlugin.this.materialNumber)) {
                                s = split[1] + "," + (errorRow + 1);
                                errorMessage = ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u540c\u4e00\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u4e0d\u540c\u7684\u4ed3\u5e93\u4f9b\u8d27\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"ImportingPlugin_30", (String)"mpscmm-msplan-formplugin", (Object[])new Object[]{s});
                                ImportingPlugin.this.isCheckDeafaultSupply = false;
                            }
                        } else if (split[0].equals(ImportingPlugin.this.supplyOrgNumber)) {
                            s = split[1] + "," + (errorRow + 1);
                            errorMessage = ResManager.loadKDString((String)"\u7b2c[%s]\u884c\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u540c\u4e00\u5e93\u5b58\u7ec4\u7ec7\u4e0b\u4e0d\u540c\u7684\u4ed3\u5e93\u4f9b\u8d27\u4f18\u5148\u7ea7\u91cd\u590d\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"ImportingPlugin_91", (String)"mpscmm-msplan-formplugin", (Object[])new Object[]{s});
                            ImportingPlugin.this.isCheckDeafaultSupply = false;
                        }
                    } else if ("prioritylevel".equals(field)) {
                        ImportingPlugin.this.priority.put(cellValue, ImportingPlugin.this.materialNumber + "," + errorRow);
                        valueMap.put(field, cellValue);
                    } else {
                        ImportingPlugin.this.priority.put(cellValue, ImportingPlugin.this.supplyOrgNumber + "," + errorRow);
                        valueMap.put(field, cellValue);
                    }
                }
            } else {
                errorMessage = "prioritylevel".equals(field) ? ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u8d27\u4f18\u5148\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4ed3\u5e93\u8fd0\u7b97\u8303\u56f4\u2260\u5168\u90e8\u4ed3\u5e93\u65f6\uff0c\u4ed3\u5e93\u4f9b\u8d27\u4f18\u5148\u7ea7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_32", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkStockPriority(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            if (!cellValue.isEmpty()) {
                try {
                    int i = Integer.parseInt(cellValue);
                    if (i < 0 || i > 0x7FFFFFFE) {
                        errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7ec4\u7ec7\u4f9b\u8d27\u4f18\u5148\u7ea7\u8bf7\u586b\u5199[0,2147483646]\u8303\u56f4\u5185\u7684\u6574\u6570\u3002", (String)"ImportingPlugin_115", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                }
                catch (Exception ex) {
                    cellValue = "0";
                }
                if (ImportingPlugin.this.isCheckDeafaultSupply) {
                    if (ImportingPlugin.this.priority.containsKey(cellValue)) {
                        String s = (String)ImportingPlugin.this.priority.get(cellValue);
                        s = s + "," + (errorRow + 1);
                        errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7ec4\u7ec7\u4f9b\u8d27\u4f18\u5148\u7ea7\u7b2c\u201c%s\u201d\u4f18\u5148\u7ea7\u91cd\u590d\u3002", (String)"ImportingPlugin_33", (String)"mpscmm-msplan-formplugin", (Object[])new Object[]{s});
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        ImportingPlugin.this.priority.put(cellValue, errorRow + 1 + "");
                        valueMap.put(field, cellValue);
                    }
                }
            } else {
                errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7ec4\u7ec7\u4f9b\u8d27\u4f18\u5148\u7ea7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_34", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkStocType(XSSFSheet firstSheet, int rownum, Map<String, Long> map) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                XSSFRow row = firstSheet.getRow(i);
                String cellValue = "";
                cellValue = rownum == 3 || rownum == 16 ? this.getFieldCellValue(row, "stocktype.number") : this.getFieldCellValue(row, "stockstatus.number");
                if (i != ImportingPlugin.this.beginRow) continue;
                if (cellValue.isEmpty()) {
                    Long[] pkId = new Long[map.size()];
                    int k = 0;
                    for (Map.Entry<String, Long> mapEntry : map.entrySet()) {
                        pkId[k] = mapEntry.getValue();
                        ++k;
                    }
                    if (rownum == 3 || rownum == 16) {
                        ImportingPlugin.this.saveIm.setStocktype(pkId);
                        continue;
                    }
                    ImportingPlugin.this.saveIm.setStockstatus(pkId);
                    continue;
                }
                String[] split = cellValue.split(",");
                Long[] pkId = new Long[split.length];
                int k = 0;
                for (String s : split) {
                    if (!map.containsKey(s) && ImportingPlugin.this.isCheckDeafaultSupply) {
                        if (rownum == 3 || rownum == 16) {
                            this.recordErroTip(i, ResManager.loadKDString((String)"\u5176\u4e2d\u6709\u53c2\u4e0eMRP\u5e93\u5b58\u7c7b\u578b\u7684\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ImportingPlugin_35", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                        } else {
                            this.recordErroTip(i, ResManager.loadKDString((String)"\u5176\u4e2d\u6709\u53c2\u4e0eMRP\u5e93\u5b58\u72b6\u6001\u7684\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ImportingPlugin_36", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                        }
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        pkId[k] = map.get(s);
                    }
                    ++k;
                }
                if (rownum == 3 || rownum == 16) {
                    ImportingPlugin.this.saveIm.setStocktype(pkId);
                    continue;
                }
                ImportingPlugin.this.saveIm.setStockstatus(pkId);
            }
        }

        private void checkStockMaterialNumber(String cellValue, int i, Map<String, Object> valueMap, String stockorg) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            String errorMessage = null;
            if (cellValue.isEmpty()) {
                errorMessage = ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u4e3a\u7a7a\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_37", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else if (ImportingPlugin.this.allMaterialNumberMap.containsKey(cellValue)) {
                ImportingPlugin.this.materialNumber = cellValue;
                valueMap.put(stockorg, ImportingPlugin.this.allMaterialNumberMap.get(cellValue));
            } else {
                errorMessage = ResManager.loadKDString((String)"\u7279\u6b8a\u7269\u6599\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u6570\u636e\u72b6\u6001\u3002", (String)"ImportingPlugin_38", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(i, errorMessage);
        }

        private void getDemandOrgRow(XSSFSheet firstSheet) {
            String orgNumber = "";
            String befOrgNumber = "";
            for (int i = 4; i < firstSheet.getLastRowNum() + 1; ++i) {
                XSSFRow row = firstSheet.getRow(i);
                if (row == null) {
                    if (!befOrgNumber.isEmpty()) {
                        ImportingPlugin.this.demandOrgMap.put(befOrgNumber, (String)ImportingPlugin.this.demandOrgMap.get(befOrgNumber) + "," + (i - 1));
                        befOrgNumber = "";
                    }
                    orgNumber = "";
                    continue;
                }
                String cellValue = this.getFieldCellValue(row, "demandorg.number");
                if (!cellValue.isEmpty()) {
                    String[] s1;
                    cellValue = cellValue + "_" + i;
                    if (orgNumber.isEmpty()) {
                        if (!befOrgNumber.isEmpty()) {
                            if (ImportingPlugin.this.demandOrgMap.containsKey(befOrgNumber)) {
                                ImportingPlugin.this.demandOrgMap.put(befOrgNumber, (String)ImportingPlugin.this.demandOrgMap.get(befOrgNumber) + "," + (i - 1));
                            } else {
                                ImportingPlugin.this.demandOrgMap.put(befOrgNumber + "_" + i, (String)ImportingPlugin.this.demandOrgMap.get(befOrgNumber) + "," + (i - 1));
                            }
                        }
                        befOrgNumber = orgNumber = cellValue;
                        ImportingPlugin.this.demandOrgMap.put(orgNumber, i + "");
                        continue;
                    }
                    String[] s = orgNumber.split("_");
                    if (s[0].equals((s1 = cellValue.split("_"))[0]) || ImportingPlugin.this.demandOrgMap.containsKey(cellValue)) continue;
                    ImportingPlugin.this.demandOrgMap.put(befOrgNumber, (String)ImportingPlugin.this.demandOrgMap.get(befOrgNumber) + "," + (i - 1));
                    ImportingPlugin.this.demandOrgMap.put(cellValue, i + "");
                    befOrgNumber = cellValue;
                    orgNumber = cellValue;
                    continue;
                }
                if (i == 4) continue;
                if (!orgNumber.isEmpty()) {
                    befOrgNumber = orgNumber;
                }
                orgNumber = "";
            }
            for (Map.Entry mapEntry : ImportingPlugin.this.demandOrgMap.entrySet()) {
                String value = (String)mapEntry.getValue();
                if (value.contains(",")) continue;
                String key = (String)mapEntry.getKey();
                ImportingPlugin.this.demandOrgMap.put(key, value + "," + firstSheet.getLastRowNum());
            }
        }

        private void getSupplyType(XSSFSheet firstSheet) {
            String supplyTypeNumber = "";
            String befSupplyTypeNumber = "";
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow; ++i) {
                XSSFRow row;
                if (i == ImportingPlugin.this.beginRow) {
                    ImportingPlugin.this.supplyTypeMap = new HashMap(8);
                }
                if ((row = firstSheet.getRow(i)) == null) {
                    if (!befSupplyTypeNumber.isEmpty()) {
                        ImportingPlugin.this.supplyTypeMap.put(befSupplyTypeNumber, (String)ImportingPlugin.this.supplyTypeMap.get(befSupplyTypeNumber) + "," + (i - 1));
                        befSupplyTypeNumber = "";
                    }
                    supplyTypeNumber = "";
                    continue;
                }
                String cellValue = this.getFieldCellValue(row, "supplyorggroupbase.number");
                if (!cellValue.isEmpty()) {
                    String[] s1;
                    cellValue = cellValue + "_" + i;
                    if (supplyTypeNumber.isEmpty()) {
                        if (!befSupplyTypeNumber.isEmpty()) {
                            if (ImportingPlugin.this.supplyTypeMap.containsKey(befSupplyTypeNumber)) {
                                ImportingPlugin.this.supplyTypeMap.put(befSupplyTypeNumber, (String)ImportingPlugin.this.supplyTypeMap.get(befSupplyTypeNumber) + "," + (i - 1));
                            } else {
                                ImportingPlugin.this.supplyTypeMap.put(befSupplyTypeNumber + "_" + i, (String)ImportingPlugin.this.supplyTypeMap.get(befSupplyTypeNumber) + "," + (i - 1));
                            }
                        }
                        befSupplyTypeNumber = supplyTypeNumber = cellValue;
                        ImportingPlugin.this.supplyTypeMap.put(supplyTypeNumber, i + "");
                        continue;
                    }
                    String[] s = supplyTypeNumber.split("_");
                    if (s[0].equals((s1 = cellValue.split("_"))[0])) continue;
                    ImportingPlugin.this.supplyTypeMap.put(befSupplyTypeNumber, (String)ImportingPlugin.this.supplyTypeMap.get(befSupplyTypeNumber) + "," + (i - 1));
                    ImportingPlugin.this.supplyTypeMap.put(cellValue, i + "");
                    befSupplyTypeNumber = cellValue;
                    supplyTypeNumber = cellValue;
                    continue;
                }
                if (i == 4) continue;
                if (!supplyTypeNumber.isEmpty()) {
                    befSupplyTypeNumber = supplyTypeNumber;
                }
                supplyTypeNumber = "";
            }
            for (Map.Entry mapEntry : ImportingPlugin.this.supplyTypeMap.entrySet()) {
                String value = (String)mapEntry.getValue();
                if (value.contains(",")) continue;
                String key = (String)mapEntry.getKey();
                ImportingPlugin.this.supplyTypeMap.put(key, value + "," + ImportingPlugin.this.endRow);
            }
        }

        private void checkMaterialNumber(String cellValue, int i, Map<String, Object> valueMap, String filed) {
            String errorMessage = null;
            int errorRow = 0;
            if (cellValue.isEmpty()) {
                errorMessage = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                errorRow = i;
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else if (ImportingPlugin.this.allMaterialNumberMap.containsKey(cellValue)) {
                if (ImportingPlugin.this.exitMaterialNumberList.contains(cellValue)) {
                    errorMessage = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5df2\u5b58\u5728\u8be5\u7269\u6599\u7f16\u7801\u3002", (String)"ImportingPlugin_40", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    errorRow = i;
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else {
                    ImportingPlugin.this.exitMaterialNumberList.add(cellValue);
                    ImportingPlugin.this.materialNumber = cellValue;
                    valueMap.put(filed, ImportingPlugin.this.allMaterialNumberMap.get(ImportingPlugin.this.materialNumber));
                }
            } else {
                errorMessage = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u8be5\u7269\u6599\u7f16\u7801\u4e0d\u5b58\u5728\u3002", (String)"ImportingPlugin_108", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                errorRow = i;
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkSupplyRule(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            String errorMessage = null;
            if (cellValue.isEmpty()) {
                if (!ImportingPlugin.this.demandOrgNumber.equals(ImportingPlugin.this.supplyOrgNumber)) {
                    errorMessage = "defaultsupplyrule".equals(field) ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_42", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u89c4\u5219\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_103", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                }
            } else if (!ImportingPlugin.this.supplyRuleList.contains(cellValue)) {
                errorMessage = "defaultsupplyrule".equals(field) ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u4f9b\u5e94\u89c4\u5219\u3002", (String)"ImportingPlugin_43", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4e0d\u5b58\u5728\u5f53\u524d\u4f9b\u5e94\u89c4\u5219\u3002", (String)"ImportingPlugin_104", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else {
                String supplyValue = this.getSupplyValue(cellValue);
                valueMap.put(field, supplyValue);
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private String getSupplyValue(String cellValue) {
            if (ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u8c03\u62e8", (String)"ImportingPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(cellValue)) {
                return "2";
            }
            if (ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u9886\u6599", (String)"ImportingPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(cellValue)) {
                return "1";
            }
            return "3";
        }

        private void checkSupplyRatio(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            String errorMessage = null;
            if (cellValue.isEmpty()) {
                errorMessage = field.equals("supplyratio") ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_29", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_98", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else {
                try {
                    Double.parseDouble(cellValue);
                    BigDecimal bigDecimal = new BigDecimal(cellValue).setScale(10, 1);
                    if (bigDecimal.compareTo(BigDecimal.ONE) > 0 || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
                        errorMessage = field.equals("supplyratio") ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u53ef\u4f9b\u6bd4\u4f8b\u8bf7\u586b\u5199[0,1]\u8303\u56f4\u5185\u7684\u503c\u3002", (String)"ImportingPlugin_99", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u53ef\u4f9b\u6bd4\u4f8b\u8bf7\u586b\u5199[0,1]\u8303\u56f4\u5185\u7684\u503c\u3002", (String)"ImportingPlugin_100", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        ImportingPlugin.this.supplyratio = bigDecimal.add(ImportingPlugin.this.supplyratio);
                        if (ImportingPlugin.this.supplyratio.compareTo(BigDecimal.ONE) > 0) {
                            errorMessage = field.equals("supplyratio") ? ResManager.loadKDString((String)"\u5f53\u524d\u9700\u6c42\u7ec4\u7ec7\u7684\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u4f9b\u5e94\u6bd4\u4f8b\u5927\u4e8e1\u3002", (String)"ImportingPlugin_44", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u524d\u9700\u6c42\u7ec4\u7ec7\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u7684\u4f9b\u5e94\u6bd4\u4f8b\u5927\u4e8e1\u3002", (String)"ImportingPlugin_118", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                            ImportingPlugin.this.isCheckDeafaultSupply = false;
                        } else {
                            valueMap.put(field, bigDecimal);
                        }
                    }
                }
                catch (Exception ex) {
                    errorMessage = field.equals("supplyratio") ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u6bd4\u4f8b\u8bf7\u8f93\u5165\u6570\u503c\u578b\u5185\u5bb9\u3002", (String)"ImportingPlugin_90", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u6bd4\u4f8b\u8bf7\u8f93\u5165\u6570\u503c\u578b\u5185\u5bb9\u3002", (String)"ImportingPlugin_101", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                }
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkDeafaultSupply(XSSFSheet firstSheet) {
            if (!ImportingPlugin.this.isCheckDeafaultSupply) {
                return;
            }
            int nullRow = 0;
            HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(8);
            for (int i = ImportingPlugin.this.beginRow; i <= ImportingPlugin.this.endRow && ImportingPlugin.this.isCheckDeafaultSupply; ++i) {
                HashMap<String, Object> valueMap = new HashMap<String, Object>(8);
                XSSFRow row = firstSheet.getRow(i);
                String orgCellValue = this.getFieldCellValue(row, "defaultsupplyorg.number");
                String ratioCellValue = this.getFieldCellValue(row, "supplyratio");
                String ruleCellValue = this.getFieldCellValue(row, "defaultsupplyrule");
                if (i == ImportingPlugin.this.beginRow) {
                    this.checkDeafaultSupplyCell(orgCellValue, ratioCellValue, ruleCellValue, valueMap, map, i);
                    continue;
                }
                if (nullRow == 0) {
                    if (orgCellValue.isEmpty() && ratioCellValue.isEmpty() && ruleCellValue.isEmpty()) {
                        ImportingPlugin.this.supplyOrgNumber = "";
                        nullRow = i;
                        continue;
                    }
                    this.checkDeafaultSupplyCell(orgCellValue, ratioCellValue, ruleCellValue, valueMap, map, i);
                    continue;
                }
                if (orgCellValue.isEmpty() && ratioCellValue.isEmpty() && ruleCellValue.isEmpty()) continue;
                this.recordErroTip(nullRow, ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_45", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            if (ImportingPlugin.this.supplyratio.compareTo(BigDecimal.ONE) < 0 && ImportingPlugin.this.isCheckDeafaultSupply) {
                this.recordErroTip(ImportingPlugin.this.endRow, ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u7684\u4f9b\u5e94\u6bd4\u4f8b\u4e0d\u7b49\u4e8e1\u3002", (String)"ImportingPlugin_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            ImportingPlugin.this.saveIm.setDefaultSupply(map);
        }

        private void checkDeafaultSupplyCell(String orgCellValue, String ratioCellValue, String ruleCellValue, Map<String, Object> valueMap, Map<String, Map<String, Object>> map, int i) {
            this.checkSupplyOrgNumber(orgCellValue, i, valueMap, "defaultsupplyorg");
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkSupplyRatio(ratioCellValue, i, valueMap, "supplyratio");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                this.checkSupplyRule(ruleCellValue, i, valueMap, "defaultsupplyrule");
            }
            if (ImportingPlugin.this.isCheckDeafaultSupply) {
                map.put(i - ImportingPlugin.this.beginRow + "", valueMap);
            }
        }

        private void checkSupplyOrgNumber(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            String errorMessage = null;
            if (!cellValue.isEmpty()) {
                if (!ImportingPlugin.SUPPLYORG.equals(field)) {
                    if (!ImportingPlugin.this.allOrgNumberMap.containsKey(cellValue)) {
                        errorMessage = ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u4e2d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_119", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else if (ImportingPlugin.this.supplyOrgNumberList.contains(cellValue)) {
                        errorMessage = ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5df2\u5b58\u5728\u8be5\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_97", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        ImportingPlugin.this.supplyOrgNumberList.add(cellValue);
                        ImportingPlugin.this.supplyOrgNumber = cellValue;
                        valueMap.put(field, ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                    }
                } else if (!ImportingPlugin.this.allOrgNumberMap.containsKey(cellValue)) {
                    errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u4e2d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_95", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else {
                    ArrayList<String> list = (ArrayList<String>)ImportingPlugin.this.specialSupplyOrgNumberMap.get(ImportingPlugin.this.supplyOrgType);
                    if (list != null && list.contains(cellValue)) {
                        errorMessage = ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728\u3002", (String)"ImportingPlugin_96", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        if (list == null) {
                            list = new ArrayList<String>(8);
                        }
                        list.add(cellValue);
                        ImportingPlugin.this.supplyOrgNumber = cellValue;
                        ImportingPlugin.this.specialSupplyOrgNumberMap.put(ImportingPlugin.this.supplyOrgType, list);
                        valueMap.put(field, ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                    }
                }
            } else {
                errorMessage = !ImportingPlugin.SUPPLYORG.equals(field) ? ResManager.loadKDString((String)"\u9ed8\u8ba4\u4f9b\u5e94\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_102", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkStockOrgNumber(String cellValue, int errorRow, Map<String, Object> valueMap, String field) {
            String errorMessage = null;
            if (!cellValue.isEmpty()) {
                if (!ImportingPlugin.this.allOrgNumberMap.containsKey(cellValue)) {
                    errorMessage = ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u4e2d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else if (field.equals("stockorg")) {
                    if (!ImportingPlugin.this.supplyOrgNumberList.contains(cellValue)) {
                        errorMessage = ResManager.loadKDString((String)"\u5bf9\u5e94\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\uff0c\u4e0d\u5b58\u5728\u5f53\u524d\u884c\u4ed3\u5e93\u8bbe\u7f6e\u4e2d\u586b\u5199\u7684\u7684\u5e93\u5b58\u7ec4\u7ec7\uff0c\u4e0d\u5141\u8bb8\u5f15\u5165\uff0c\u8bf7\u8865\u5145\u6216\u53d8\u66f4\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_50", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    } else {
                        ImportingPlugin.this.supplyOrgNumber = cellValue;
                        valueMap.put(field, ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                    }
                } else if (ImportingPlugin.this.supplyOrgNumberList.contains(cellValue)) {
                    errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u5df2\u5b58\u5728\u8be5\u5e93\u5b58\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_49", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                } else {
                    ImportingPlugin.this.supplyOrgNumberList.add(cellValue);
                    ImportingPlugin.this.supplyOrgNumber = cellValue;
                    valueMap.put(field, ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                }
            } else if (field.equals("storageorg")) {
                errorMessage = ResManager.loadKDString((String)"\u7ec4\u7ec7\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_112", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else {
                errorMessage = ResManager.loadKDString((String)"\u4ed3\u5e93\u8bbe\u7f6e\u9875\u7b7e\u4e2d\u7684\u5e93\u5b58\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ImportingPlugin_113", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private String getFieldCellValue(XSSFRow row, String number) {
            if (!ImportingPlugin.this.cellValue.containsKey(number)) {
                return "";
            }
            return this.getCellValue((Cell)row.getCell(((Integer)ImportingPlugin.this.cellValue.get(number)).intValue()));
        }

        private void checkDemandOrgNumber(XSSFRow row, XSSFSheet firstSheet) {
            String errorMessage = null;
            int errorRow = 0;
            int rowNum = row.getRowNum();
            String cellValue = this.getFieldCellValue(row, "demandorg.number");
            if (!cellValue.isEmpty()) {
                if (ImportingPlugin.this.beginRow == 0) {
                    this.getRnageRow(cellValue, rowNum);
                    if (ImportingPlugin.this.allOrgNumberMap.containsKey(cellValue)) {
                        this.getSupplyType(firstSheet);
                        ImportingPlugin.this.saveIm = new MultiorgsupdemPojo();
                        if (ImportingPlugin.SUPPLYORG.equals(this.getSign())) {
                            if ("new".equals(ImportingPlugin.this.IMPORTTYPE)) {
                                this.checkImportTypeNew(cellValue, rowNum, ImportingPlugin.this.demandOrgNumberMap, ImportingPlugin.this.stockDemandOrgNumberMap, ImportingPlugin.SUPPLYORG);
                            } else if ("override".equals(ImportingPlugin.this.IMPORTTYPE)) {
                                this.checkImportTypeOverride(cellValue, rowNum, ImportingPlugin.this.demandOrgNumberMap, ImportingPlugin.SUPPLYORG);
                            } else {
                                this.checkImportTypeOther(cellValue, rowNum, ImportingPlugin.this.demandOrgNumberMap, ImportingPlugin.SUPPLYORG);
                            }
                        } else if (ImportingPlugin.STOCKSUPPLY.equals(this.getSign())) {
                            if ("new".equals(ImportingPlugin.this.IMPORTTYPE)) {
                                this.checkImportTypeNew(cellValue, rowNum, ImportingPlugin.this.stockDemandOrgNumberMap, ImportingPlugin.this.demandOrgNumberMap, ImportingPlugin.STOCKSUPPLY);
                            } else if ("override".equals(ImportingPlugin.this.IMPORTTYPE)) {
                                this.checkImportTypeOverride(cellValue, rowNum, ImportingPlugin.this.stockDemandOrgNumberMap, ImportingPlugin.STOCKSUPPLY);
                            } else {
                                this.checkImportTypeOther(cellValue, rowNum, ImportingPlugin.this.stockDemandOrgNumberMap, ImportingPlugin.STOCKSUPPLY);
                            }
                        }
                    } else {
                        errorMessage = ResManager.loadKDString((String)"\u5f53\u524d\u9700\u6c42\u7ec4\u7ec7\u7f16\u7801\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u4e1a\u52a1\u5355\u5143\u4e2d\u5b58\u5728\u8be5\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_53", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                        errorRow = rowNum;
                        ImportingPlugin.this.isCheckDeafaultSupply = false;
                    }
                } else if (ImportingPlugin.this.endRow == rowNum) {
                    ImportingPlugin.this.beginRow = 0;
                    ImportingPlugin.this.endRow = 0;
                    ImportingPlugin.this.isCheckDeafaultSupply = true;
                    ImportingPlugin.this.demandOrgNumber = "";
                }
            } else if (ImportingPlugin.this.demandOrgNumber.isEmpty()) {
                errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u9700\u6c42\u7ec4\u7ec7\u201d\u3002", (String)"ImportingPlugin_54", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                errorRow = rowNum;
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(errorRow, errorMessage);
        }

        private void checkImportTypeOther(String cellValue, int rowNum, Map<String, Long> demandOrgNumberMap_l, String sign) {
            String errorMessage = null;
            if (!demandOrgNumberMap_l.containsKey(cellValue)) {
                if (!ImportingPlugin.this.exitOrgNumber.contains(cellValue)) {
                    ImportingPlugin.this.demandOrgNumber = cellValue;
                    if (ImportingPlugin.SUPPLYORG.equals(sign)) {
                        ImportingPlugin.this.saveIm.setDemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                    } else {
                        ImportingPlugin.this.saveIm.setStockdemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                    }
                    ImportingPlugin.this.exitOrgNumber.add(cellValue);
                } else {
                    errorMessage = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_51", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    ImportingPlugin.this.isCheckDeafaultSupply = false;
                }
            } else if (!ImportingPlugin.this.exitOrgNumber.contains(cellValue)) {
                ImportingPlugin.this.multiorgsupdemAndDny.put(ImportingPlugin.this.saveIm.getId(), demandOrgNumberMap_l.get(cellValue));
                ImportingPlugin.this.demandOrgNumber = cellValue;
                if (ImportingPlugin.SUPPLYORG.equals(sign)) {
                    ImportingPlugin.this.saveIm.setDemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                } else {
                    ImportingPlugin.this.saveIm.setStockdemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                }
                ImportingPlugin.this.exitOrgNumber.add(cellValue);
            } else {
                errorMessage = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_51", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(rowNum, errorMessage);
        }

        private void checkImportTypeOverride(String cellValue, int rowNum, Map<String, Long> demandOrgNumberMap_l, String sign) {
            String errorMessage = null;
            if (!demandOrgNumberMap_l.containsKey(cellValue)) {
                errorMessage = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_52", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else if (!ImportingPlugin.this.exitOrgNumber.contains(cellValue)) {
                ImportingPlugin.this.multiorgsupdemAndDny.put(ImportingPlugin.this.saveIm.getId(), demandOrgNumberMap_l.get(cellValue));
                if (ImportingPlugin.SUPPLYORG.equals(sign)) {
                    ImportingPlugin.this.saveIm.setDemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                } else {
                    ImportingPlugin.this.saveIm.setStockdemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                }
                ImportingPlugin.this.demandOrgNumber = cellValue;
            } else {
                errorMessage = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_51", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(rowNum, errorMessage);
        }

        private void checkImportTypeNew(String cellValue, int rowNum, Map<String, Long> demandOrgNumberMap_l, Map<String, Long> stockOrgNumberMap_l, String sign) {
            String errorMessage = null;
            if (demandOrgNumberMap_l.containsKey(cellValue)) {
                errorMessage = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_51", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            } else if (!ImportingPlugin.this.exitOrgNumber.contains(cellValue)) {
                if (stockOrgNumberMap_l.containsKey(cellValue)) {
                    ImportingPlugin.this.multiorgsupdemAndDny.put(ImportingPlugin.this.saveIm.getId(), stockOrgNumberMap_l.get(cellValue));
                }
                ImportingPlugin.this.demandOrgNumber = cellValue;
                ImportingPlugin.this.exitOrgNumber.add(cellValue);
                if (ImportingPlugin.SUPPLYORG.equals(sign)) {
                    ImportingPlugin.this.saveIm.setDemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                } else {
                    ImportingPlugin.this.saveIm.setStockdemandorg((Long)ImportingPlugin.this.allOrgNumberMap.get(cellValue));
                }
            } else {
                errorMessage = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"ImportingPlugin_51", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                ImportingPlugin.this.isCheckDeafaultSupply = false;
            }
            this.recordErroTip(rowNum, errorMessage);
        }

        private void getRnageRow(String cellValue, int rowNum) {
            String rnageRow = (String)ImportingPlugin.this.demandOrgMap.get(cellValue + "_" + rowNum);
            if (rnageRow.contains(",")) {
                ImportingPlugin.this.endRow = Integer.parseInt(rnageRow.split(",")[1]);
                ImportingPlugin.this.beginRow = Integer.parseInt(rnageRow.split(",")[0]);
            }
        }

        private void recordErroTip(int errorRow, String errorString) {
            if (errorString == null) {
                return;
            }
            ImportingPlugin.this.errorMessageMap.put(errorRow, errorString);
        }

        public String getCellValue(Cell cell) {
            if (cell == null) {
                return "";
            }
            switch (cell.getCellType()) {
                case STRING: {
                    return cell.getStringCellValue() == null ? "" : cell.getStringCellValue();
                }
                case NUMERIC: {
                    double d = cell.getNumericCellValue();
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date cal = DateUtil.getJavaDate((double)d);
                        return this.getStringByDate(cal);
                    }
                    BigDecimal bd = new BigDecimal(Double.toString(d));
                    String s = bd.toString();
                    if (s.endsWith(".0")) {
                        s = s.substring(0, s.length() - 2);
                    }
                    return s;
                }
                case FORMULA: {
                    String valueStr = null;
                    valueStr = cell.getStringCellValue();
                    if (valueStr != null && valueStr.trim().length() > 0) {
                        return valueStr.trim();
                    }
                    double value = cell.getNumericCellValue();
                    BigDecimal bd = new BigDecimal(Double.toString(value));
                    valueStr = bd.toString();
                    if (valueStr.endsWith(".0")) {
                        valueStr = valueStr.substring(0, valueStr.length() - 2);
                    }
                    return valueStr;
                }
                case BOOLEAN: {
                    return String.valueOf(cell.getBooleanCellValue());
                }
                case BLANK: {
                    return "";
                }
            }
            return cell.getStringCellValue() == null ? "" : cell.getStringCellValue().trim();
        }

        private String getStringByDate(Date d) {
            Calendar cl = Calendar.getInstance();
            cl.setTime(d);
            StringBuilder dateStr = new StringBuilder();
            dateStr.append(cl.get(1));
            dateStr.append('-');
            int month = cl.get(2) + 1;
            if (month < 10) {
                dateStr.append('0');
            }
            dateStr.append(month);
            dateStr.append('-');
            int day = cl.get(5);
            if (day < 10) {
                dateStr.append('0');
            }
            dateStr.append(day);
            return dateStr.toString();
        }

        public XSSFSheet getFirstSheet(InputStream inputStream) {
            XSSFWorkbook xssFWorkbook = null;
            try {
                xssFWorkbook = new XSSFWorkbook(inputStream);
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u4ef6\u3002", (String)"ImportingPlugin_55", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            XSSFSheet firstSheet = xssFWorkbook.getSheetAt(0);
            return firstSheet;
        }

        private void getInitData() {
            this.getAllOrgNumber();
            this.getExitOrgNumberList();
            this.getAllMaterialNumber();
            ImportingPlugin.this.IMPORTTYPE = (String)this.view.getFormShowParameter().getCustomParam("importtype");
            ImportingPlugin.this.cellValue = (Map)SerializationUtils.deSerializeFromBase64((String)((String)this.view.getFormShowParameter().getCustomParam("cellValue")));
            if (ImportingPlugin.SUPPLYORG.equals(this.getSign())) {
                this.getAllSupplyOrgTypeNumber();
            } else if (ImportingPlugin.STOCKSUPPLY.equals(this.getSign())) {
                this.getStockPkId(ImportingPlugin.BD_INVTYPE);
                this.getStockPkId(ImportingPlugin.BD_INVSTATUS);
                this.getStockMap();
                this.getStockIndexMap();
                this.getSqlMaterialAndOrgData();
            } else {
                this.getAllSupplyOrgTypeNumber();
                this.getStockPkId(ImportingPlugin.BD_INVTYPE);
                this.getStockPkId(ImportingPlugin.BD_INVSTATUS);
                this.getStockMap();
                this.getStockIndexMap();
            }
        }

        private void getSqlMaterialAndOrgData() {
            QFilter ofilter = new QFilter("materialsetup.materialorg.id", "!=", (Object)0L);
            QFilter mfilter = new QFilter("materialsetup.materiel.id", "!=", (Object)0L);
            QFilter enablefilter = new QFilter(ImportingPlugin.ENABLE, "=", (Object)"1");
            DynamicObjectCollection materials = null;
            if (!"new".equals(ImportingPlugin.this.IMPORTTYPE)) {
                QFilter notDny = new QFilter(ImportingPlugin.PARENTDNYID, "!=", (Object)this.getDny());
                materials = QueryServiceHelper.query((String)ImportingPlugin.NODEDETAILS, (String)"id,materialsetup.materialorg.id,materialsetup.materiel.id,materialsetup.stockratio", (QFilter[])new QFilter[]{ofilter.and(mfilter).and(enablefilter).and(notDny)});
            } else {
                materials = QueryServiceHelper.query((String)ImportingPlugin.NODEDETAILS, (String)"id,materialsetup.materialorg.id,materialsetup.materiel.id,materialsetup.stockratio", (QFilter[])new QFilter[]{ofilter.and(mfilter).and(enablefilter)});
            }
            for (DynamicObject material : materials) {
                String materialorgId = material.getString("materialsetup.materialorg.id");
                String materielId = material.getString("materialsetup.materiel.id");
                String key = materialorgId + "," + materielId;
                BigDecimal bigDecimal = material.getBigDecimal("materialsetup.stockratio");
                if (ImportingPlugin.this.otherscaleMap.containsKey(key)) {
                    String value = (String)ImportingPlugin.this.otherscaleMap.get(key);
                    String[] split = value.split("\\|\\|");
                    bigDecimal = bigDecimal.add(new BigDecimal(split[0]));
                    value = bigDecimal + "||-1";
                    ImportingPlugin.this.otherscaleMap.put(key, value);
                    continue;
                }
                ImportingPlugin.this.otherscaleMap.put(key, bigDecimal + "||-1");
            }
        }

        private void getStockIndexMap() {
            DynamicObjectCollection stocks = QueryServiceHelper.query((String)"bd_warehouse", (String)"number,entryentity.*,entryentity.location.*", (QFilter[])new QFilter[]{new QFilter(ImportingPlugin.ID, "!=", (Object)0L)});
            for (int i = 0; i < stocks.size(); ++i) {
                Map<String, Long> map;
                DynamicObject object = (DynamicObject)stocks.get(i);
                if (object.get("entryentity.location.number") == null) continue;
                if (ImportingPlugin.this.stockAndStockIndexMap.containsKey(object.getString("number"))) {
                    map = (Map)ImportingPlugin.this.stockAndStockIndexMap.get(object.getString("number"));
                    map.put(object.getString("entryentity.location.number"), object.getLong("entryentity.location.id"));
                    continue;
                }
                map = new HashMap<String, Long>(8);
                map.put(object.getString("entryentity.location.number"), object.getLong("entryentity.location.id"));
                ImportingPlugin.this.stockAndStockIndexMap.put(object.getString("number"), map);
            }
        }

        private void getStockMap() {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id,warehouse.number,org.number", (QFilter[])new QFilter[]{new QFilter("initstatus", "=", (Object)"B")});
            for (DynamicObject dynamicObject : query) {
                Map<String, Long> map;
                String orgNumber = dynamicObject.getString("org.number");
                if (orgNumber == null) continue;
                if (ImportingPlugin.this.stockAndOrgMap.containsKey(orgNumber)) {
                    map = (Map)ImportingPlugin.this.stockAndOrgMap.get(orgNumber);
                    map.put(dynamicObject.getString("warehouse.number"), dynamicObject.getLong("warehouse.id"));
                    continue;
                }
                map = new HashMap<String, Long>(8);
                map.put(dynamicObject.getString("warehouse.number"), dynamicObject.getLong("warehouse.id"));
                ImportingPlugin.this.stockAndOrgMap.put(orgNumber, map);
            }
        }

        private void getStockPkId(String sign) {
            DynamicObjectCollection queryInvtype = QueryServiceHelper.query((String)sign, (String)"id,name,number", (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)});
            for (DynamicObject dynamicObject : queryInvtype) {
                if (sign.equals(ImportingPlugin.BD_INVTYPE)) {
                    ImportingPlugin.this.stockTypeMap.put(dynamicObject.getString("number"), dynamicObject.getLong(ImportingPlugin.ID));
                    continue;
                }
                ImportingPlugin.this.stockStatusMap.put(dynamicObject.getString("number"), dynamicObject.getLong(ImportingPlugin.ID));
            }
        }

        private void getAllMaterialNumber() {
            QFilter[] filters = new QFilter[]{new QFilter(ImportingPlugin.ID, "!=", (Object)0L)};
            try (DataSet dataSet = ORM.create().queryDataSet("import", "bd_material", "number,id", filters);){
                for (Row row : dataSet) {
                    ImportingPlugin.this.allMaterialNumberMap.put(row.getString("number"), row.getLong(ImportingPlugin.ID));
                }
            }
        }

        private void getAllSupplyOrgTypeNumber() {
            DynamicObjectCollection query = QueryServiceHelper.query((String)"mrp_orgtpy", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "!=", null)});
            if (query != null && query.size() != 0) {
                for (DynamicObject dynamicObject : query) {
                    ImportingPlugin.this.supplyOrgTypeNumberMap.put(dynamicObject.getString("number"), dynamicObject.getLong(ImportingPlugin.ID) + "," + dynamicObject.getString("name"));
                }
            }
        }

        private void getAllOrgNumber() {
            String selectFields = "org.number,org.id";
            QFilter viewFilter = new QFilter("view.number", "=", (Object)OrgViewTypeEnum.IS_ORGUNIT.getViewType());
            viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
            QFilter[] filters = new QFilter[]{viewFilter = viewFilter.and(new QFilter(ImportingPlugin.ENABLE, "=", (Object)Boolean.TRUE))};
            DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)selectFields, (QFilter[])filters, (String)"level");
            if (orgCol != null && orgCol.size() != 0) {
                for (DynamicObject org : orgCol) {
                    ImportingPlugin.this.allOrgNumberMap.put(org.getString("org.number"), org.getLong("org.id"));
                }
            }
        }

        private void getExitOrgNumberList() {
            String org = "id,demandorg.number,stockdemandorg.number";
            DynamicObjectCollection query = QueryServiceHelper.query((String)ImportingPlugin.NODEDETAILS, (String)org, (QFilter[])new QFilter[]{new QFilter(ImportingPlugin.ENABLE, "=", (Object)"1").and(ImportingPlugin.PARENTDNYID, "=", (Object)this.getDny())});
            for (DynamicObject dynamicObject : query) {
                if (dynamicObject.getString("demandorg.number") != null && !dynamicObject.getString("demandorg.number").isEmpty()) {
                    ImportingPlugin.this.demandOrgNumberMap.put(dynamicObject.getString("demandorg.number"), dynamicObject.getLong(ImportingPlugin.ID));
                }
                if (dynamicObject.getString("stockdemandorg.number") == null || dynamicObject.getString("stockdemandorg.number").isEmpty()) continue;
                ImportingPlugin.this.stockDemandOrgNumberMap.put(dynamicObject.getString("stockdemandorg.number"), dynamicObject.getLong(ImportingPlugin.ID));
            }
        }

        public String getSign() {
            return (String)this.view.getFormShowParameter().getCustomParam("sign");
        }

        public String getDny() {
            return (String)this.view.getFormShowParameter().getCustomParam(ImportingPlugin.PARENTDNYID);
        }

        public String getNodeMessage() {
            return (String)this.view.getFormShowParameter().getCustomParam("nodeMessage");
        }

        protected void setProgress(int progress) {
            ImportingPlugin.this.getPageCache().put(ImportingPlugin.CACHEKEY_PROGRESS, String.valueOf(progress));
        }

        private void changOrAndStockToShowentity(DynamicObject dataEntity, boolean isNew) {
            DynamicObjectCollection showentity = dataEntity.getDynamicObjectCollection("showentity");
            if ("override".equals(ImportingPlugin.this.IMPORTTYPE) || "overridenew".equals(ImportingPlugin.this.IMPORTTYPE) || !isNew) {
                showentity.clear();
            }
            HashMap<String, String> orgMap = new HashMap<String, String>(16);
            ArrayList<String> list = new ArrayList<String>(16);
            DynamicObjectCollection orgDynamicObjectCollection = dataEntity.getDynamicObjectCollection("stocksorgentrentryentity");
            DynamicObjectCollection stockDynamicObjectCollection = dataEntity.getDynamicObjectCollection("stocksetupentryentity");
            for (DynamicObject dynamicObject : orgDynamicObjectCollection) {
                String value = dynamicObject.getPkValue() + "|" + dynamicObject.getString("priority") + "|" + dynamicObject.getString("stockscale");
                String key = dynamicObject.getString("storageorg");
                orgMap.put(key, value);
            }
            for (DynamicObject dynamicObject : stockDynamicObjectCollection) {
                list.add(dynamicObject.getString("stockorg"));
            }
            if (stockDynamicObjectCollection.size() == 0 && orgDynamicObjectCollection.size() != 0) {
                for (Map.Entry<String, String> entry : orgMap.entrySet()) {
                    DynamicObject dynamicObject = showentity.addNew();
                    this.setShowEntityValue(entry, dynamicObject);
                }
            } else {
                for (Map.Entry<String, String> entry : orgMap.entrySet()) {
                    String key = (String)entry.getKey();
                    if (list.contains(key)) {
                        for (DynamicObject dynamicObject : stockDynamicObjectCollection) {
                            String orgId = dynamicObject.getString("stockorg");
                            if (!key.equals(orgId)) continue;
                            DynamicObject dynamicObject2 = showentity.addNew();
                            dynamicObject2.set("stocknumber1", dynamicObject.get("stocknumber"));
                            dynamicObject2.set("stockindex1", dynamicObject.get("stockindex"));
                            dynamicObject2.set("supplypriority1", (Object)new BigDecimal(dynamicObject.getString("supplypriority")));
                            dynamicObject2.set("wastewarehouse1", dynamicObject.get("wastewarehouse"));
                            this.setShowEntityValue(entry, dynamicObject2);
                            dynamicObject2.set("stocksetupentryentityid", dynamicObject.getPkValue());
                        }
                        continue;
                    }
                    DynamicObject dynamicObject = showentity.addNew();
                    this.setShowEntityValue(entry, dynamicObject);
                }
            }
        }

        private void setShowEntityValue(Map.Entry<String, String> mapEntry, DynamicObject dynamicObject) {
            String[] split = mapEntry.getValue().split("\\|");
            dynamicObject.set("storageorg1", (Object)mapEntry.getKey());
            dynamicObject.set("priority1", (Object)split[1]);
            dynamicObject.set("stockscale1", (Object)new BigDecimal(split[2]));
            dynamicObject.set("orgsetid", (Object)split[0]);
        }

        private InputStream getInputStream() {
            String fileUrl = (String)this.view.getFormShowParameter().getCustomParam("url");
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream in = service.getInputStream(fileUrl);
            return in;
        }

        private void setMuBaseData(DynamicObject dataEntity, Long[] muBases, String name, Boolean isNew) {
            Map bd_invtype = "stocktype".equals(name) ? BusinessDataServiceHelper.loadFromCache((Object[])muBases, (String)ImportingPlugin.BD_INVTYPE) : BusinessDataServiceHelper.loadFromCache((Object[])muBases, (String)ImportingPlugin.BD_INVSTATUS);
            MulBasedataDynamicObjectCollection dynamicObjects = (MulBasedataDynamicObjectCollection)dataEntity.get(name);
            if (bd_invtype == null) {
                return;
            }
            if (!isNew.booleanValue()) {
                dynamicObjects.clear();
            }
            long[] longs = DB.genGlobalLongIds((int)bd_invtype.size());
            int i = 0;
            for (Map.Entry basedataDynamicObject : bd_invtype.entrySet()) {
                DynamicObject dynamicObject = dynamicObjects.addNew();
                dynamicObject.set("pkid", (Object)longs[i]);
                dynamicObject.set("fbasedataid", basedataDynamicObject.getValue());
                dynamicObject.set("fbasedataid_id", basedataDynamicObject.getKey());
                ++i;
            }
        }
    }
}

