/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EventObject;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.TimeServiceHelper;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportlogPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"labelap1", "labelap3"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map message = (Map)formShowParameter.getCustomParam("message");
        this.getModel().setValue("from", (Object)"mrp_multiorgsupdem");
        this.getModel().setValue("creat", (Object)RequestContext.getOrCreate().getUserName());
        if (message.get("time") == null) {
            return;
        }
        String[] times = ((String)message.get("time")).split(",");
        long begin = Long.parseLong(times[0]);
        long end = Long.parseLong(times[1]);
        this.getModel().setValue("creattime", (Object)TimeServiceHelper.formatUserNow((Long)begin));
        this.getModel().setValue("endtime", (Object)TimeServiceHelper.formatUserNow((Long)end));
        long l = (end - begin) / 1000L;
        Map map = (Map)SerializationUtils.deSerializeFromBase64((String)((String)message.get("faile")));
        int sucess = Integer.parseInt((String)message.get("success"));
        int total = sucess + map.size();
        this.getModel().setValue("time1", (Object)String.valueOf(l));
        this.getModel().setValue("total", (Object)total);
        if (sucess < 0) {
            sucess = 0;
        }
        this.getModel().setValue("success", (Object)sucess);
        this.getModel().setValue("fali", (Object)map.size());
        String url = (String)message.get("url");
        this.getPageCache().put("url", url);
        String[] split = url.split("/");
        Label faillable = (Label)this.getControl("faillable");
        Label succusslable = (Label)this.getControl("succusslable");
        if (map != null) {
            int i = total - map.size();
            succusslable.setText(String.valueOf(i));
            faillable.setText(String.valueOf(map.size()));
        }
        Label labelap4 = (Label)this.getControl("labelap1");
        Label name = (Label)this.getControl("name");
        name.setText(split[split.length - 1]);
        labelap4.setText(split[split.length - 1]);
        StringBuilder fmessage = new StringBuilder();
        for (Map.Entry mapEntry : map.entrySet()) {
            fmessage.append(ResManager.loadKDString((String)"\u7b2c", (String)"ImportlogPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])).append((Integer)mapEntry.getKey() + 1).append(ResManager.loadKDString((String)"\u884c", (String)"ImportlogPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])).append((String)mapEntry.getValue()).append(System.lineSeparator());
        }
        this.getModel().setValue("textareafield", (Object)fmessage.toString());
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equals("labelap1")) {
            try {
                FileService service = FileServiceFactory.getAttachmentFileService();
                String url = this.getPageCache().get("url");
                String[] split = url.split("/");
                InputStream in = service.getInputStream(url);
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(in);
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.writeFile(xssFWorkbook, split[split.length - 1]));
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u4ef6\u3002", (String)"ImportlogPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
        }
        if (key.equals("labelap3")) {
            try {
                FileService service = FileServiceFactory.getAttachmentFileService();
                String url = this.getPageCache().get("url");
                InputStream in = service.getInputStream(url);
                XSSFWorkbook xssFWorkbook = new XSSFWorkbook(in);
                XSSFSheet firstSheet = xssFWorkbook.getSheetAt(0);
                XSSFWorkbook errorBook = new XSSFWorkbook();
                XSSFSheet errorSheet = errorBook.createSheet();
                for (int i = 0; i <= firstSheet.getLastRowNum(); ++i) {
                    XSSFRow row = firstSheet.getRow(i);
                    XSSFRow errorRow = errorSheet.createRow(i);
                    if (i == 2) {
                        errorRow.createCell(0).setCellValue(ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"ImportlogPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    }
                    this.copyRow(errorRow, row, errorSheet);
                }
                Map message = (Map)this.getView().getFormShowParameter().getCustomParam("message");
                Map map = (Map)SerializationUtils.deSerializeFromBase64((String)((String)message.get("faile")));
                XSSFCellStyle style = errorBook.createCellStyle();
                XSSFFont font = errorBook.createFont();
                font.setColor((short)10);
                style.setFont((Font)font);
                errorSheet.setColumnWidth(0, 5000);
                for (Map.Entry mapEntry : map.entrySet()) {
                    XSSFRow row = errorSheet.getRow(((Integer)mapEntry.getKey()).intValue());
                    XSSFCell cell = row.getCell(0);
                    if (cell == null) {
                        cell = row.createCell(0);
                    }
                    cell.setCellStyle((CellStyle)style);
                    row.getCell(0).setCellValue((String)mapEntry.getValue());
                }
                String title = String.format(ResManager.loadKDString((String)" \u9519\u8bef\u4fe1\u606f\u2014\u2014%s.xlsx", (String)"ImportlogPlugin_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getExcelName());
                ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.writeFile(errorBook, title));
            }
            catch (Exception ex) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20Excel\u683c\u5f0f\u7684\u6587\u4ef6\u3002", (String)"ImportlogPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private String getExcelName() {
        String url = this.getPageCache().get("url");
        if (url != null && !url.isEmpty()) {
            String[] split = url.split("/");
            return split[split.length - 1];
        }
        return "";
    }

    private void copyRow(XSSFRow errorxssfRow, XSSFRow row, XSSFSheet errorSheet) {
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            errorSheet.setColumnWidth(i, 5000);
            XSSFCell xssfCell = row.getCell(i);
            if (xssfCell == null) continue;
            XSSFCell newCell = errorxssfRow.createCell(i + 1);
            this.copyCell(xssfCell, newCell);
        }
    }

    private void copyCell(XSSFCell xssfCell, XSSFCell newCell) {
        if (CellType.STRING.equals((Object)xssfCell.getCellType()) || CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
            if (CellType.NUMERIC.equals((Object)xssfCell.getCellType())) {
                newCell.setCellValue(NumberToTextConverter.toText((double)xssfCell.getNumericCellValue()).trim());
            } else {
                newCell.setCellValue(xssfCell.getStringCellValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }
}

