/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.business.helper.MrpMaterialGroupStandardHelper;
import kd.mpscmm.msplan.business.inventory.InventoryDimensionEntry;
import kd.mpscmm.msplan.business.inventory.InventoryUtil;

public class InventoryLevelBasePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static String CONFIRM_DIMENSION = "confirm_dimension";
    public static final String DAILYCONSUME = "dailyconsume";
    public static final String SAFEINV = "safeinv";
    public static final String LEADTIME = "leadtime";
    public static final String CACHE_HASMATERIALGROUP = "cache_hasmaterialgroup";
    public static final String PLANTYPE = "plantype";

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String filedKey = beforeF7SelectEvent.getProperty().getName();
        String appId = this.getView().getFormShowParameter().getAppId();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if ("mrp".equalsIgnoreCase(appId) && "dimension".equals(filedKey)) {
            QFilter qFilter = new QFilter("id", "=", (Object)1311539656483019776L);
            showParameter.getListFilterParameter().setFilter(qFilter);
        } else if ("bd_materialgroupstandard".equals(filedKey)) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject bos_org = (DynamicObject)this.getModel().getValue("bos_org", rowIdx);
            if (bos_org != null) {
                QFilter standardFilter = MrpMaterialGroupStandardHelper.getGroupStandardFilter((String)"bd_material", (Long)bos_org.getLong("id"), (boolean)true);
                showParameter.getListFilterParameter().setFilter(standardFilter);
            } else {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("bd_materialgroup".equals(filedKey)) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject materialGroup_Standard = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard", rowIdx);
            if (materialGroup_Standard != null) {
                QFilter qFilter = new QFilter("standard", "=", (Object)materialGroup_Standard.getLong("id"));
                showParameter.getListFilterParameter().setFilter(qFilter);
                beforeF7SelectEvent.getFormShowParameter().setCustomParam("groupStandard", materialGroup_Standard.getPkValue());
            } else {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            }
        } else if ("bd_material".equals(filedKey) && "true".equals(this.getPageCache().get(CACHE_HASMATERIALGROUP))) {
            int rowIdx = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject materialGroup = (DynamicObject)this.getModel().getValue("bd_materialgroup", rowIdx);
            if (materialGroup == null) {
                QFilter qFilter = new QFilter("1", "!=", (Object)"1", true);
                showParameter.getListFilterParameter().setFilter(qFilter);
            } else {
                QFilter[] stdFilter = new QFilter[]{new QFilter("group", "=", materialGroup.getPkValue())};
                HashSet<Object> mts = new HashSet<Object>(64);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)"finish", (String)"bd_materialgroupdetail", (String)"material,group", (QFilter[])stdFilter, null);){
                    for (Row d : ds) {
                        Object mt = d.get("material");
                        mts.add(mt);
                    }
                }
                QFilter materialFilter = new QFilter("id", "in", mts);
                showParameter.getListFilterParameter().setFilter(materialFilter);
                DynamicObject std = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard", rowIdx);
                if (std != null) {
                    beforeF7SelectEvent.getFormShowParameter().setCustomParam("groupStandard", std.getPkValue());
                }
            }
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        String appId = this.getView().getFormShowParameter().getAppId();
        if ("mrp".equalsIgnoreCase(appId)) {
            this.getModel().setValue("type", (Object)"A");
        } else {
            this.getModel().setValue("type", (Object)"B");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opeatekey = afterDoOperationEventArgs.getOperateKey();
        if ("audit".equals(opeatekey)) {
            this.getModel().setValue("auditor", (Object)RequestContext.get().getCurrUserId());
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit basedataEdit;
        super.registerListener(e);
        if (this.getControl("dimension") != null) {
            basedataEdit = (BasedataEdit)this.getControl("dimension");
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("bd_materialgroupstandard") != null) {
            basedataEdit = (BasedataEdit)this.getControl("bd_materialgroupstandard");
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("bd_materialgroup") != null) {
            basedataEdit = (BasedataEdit)this.getControl("bd_materialgroup");
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("bd_material") != null) {
            basedataEdit = (BasedataEdit)this.getControl("bd_material");
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (this.getControl("bos_org") != null) {
            basedataEdit = (BasedataEdit)this.getControl("bos_org");
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public String[] hideDimensionFields() {
        return new String[]{"bos_org", "bd_warehouse", "bd_materialgroupstandard", "bd_materialgroup", "bd_material", "materialname"};
    }

    public String[] hideSpecialFields() {
        String appID = this.getView().getFormShowParameter().getAppId();
        if ("mrp".equals(appID)) {
            return new String[]{"datestart", "dateend"};
        }
        return new String[]{"materialattr", "operator", "reservedtype", "yield", "wastagerate", "wastagerateformula", "inspectionleadtime", "preprocessingtime", "postprocessingtime", "plantag"};
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initData();
        String appID = this.getView().getFormShowParameter().getAppId();
        if ("mrp".equals(appID)) {
            this.getModel().setValue("dimension", (Object)1311539656483019776L);
            this.getView().setEnable(Boolean.FALSE, new String[]{"dimension"});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        for (DynamicObject dynamicObject : entry) {
            DynamicObject bos_org = dynamicObject.getDynamicObject("bos_org");
            DynamicObject materialStandard = dynamicObject.getDynamicObject("bd_materialgroupstandard");
            if (bos_org == null || materialStandard == null) continue;
            String bosOrgId = String.valueOf(bos_org.getLong("id"));
            String materialStandardId = String.valueOf(materialStandard.getLong("id"));
            if (this.getPageCache().get(bosOrgId) != null) continue;
            this.getPageCache().put(bosOrgId, materialStandardId);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appID = this.getView().getFormShowParameter().getAppId();
        if ("mrp".equals(appID)) {
            this.getModel().setValue("type", (Object)Character.valueOf('A'));
        } else {
            this.getModel().setValue("type", (Object)Character.valueOf('B'));
        }
    }

    public void initData() {
        this.getView().setVisible(Boolean.FALSE, this.hideDimensionFields());
        this.getView().setVisible(Boolean.FALSE, this.hideSpecialFields());
        DynamicObject value = (DynamicObject)this.getModel().getValue("dimension");
        List entryList = InventoryUtil.getInventoryDimension((DynamicObject)value);
        for (InventoryDimensionEntry entry : entryList) {
            String entityNumber = entry.getAssociationobject();
            String fieldName = entry.getDimensionname();
            BasedataEdit basedataEdit = (BasedataEdit)this.getControl(entityNumber);
            if (basedataEdit == null) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u6c34\u4f4d\u4fe1\u606f\u4e0d\u652f\u6301%s\u7684\u7ef4\u5ea6\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"InventoryLevelBasePlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), fieldName));
                continue;
            }
            if (!"bd_material".equals(entityNumber)) {
                basedataEdit.setCaption(new LocaleString(fieldName));
            } else {
                basedataEdit.setCaption(new LocaleString(String.format(ResManager.loadKDString((String)"%s\u7f16\u7801", (String)"InventoryLevelBasePlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), fieldName)));
            }
            basedataEdit.setMustInput(true);
            this.getPageCache().put(CACHE_HASMATERIALGROUP, "false");
            if ("bd_materialgroup".equals(entityNumber)) {
                this.getPageCache().put(CACHE_HASMATERIALGROUP, "true");
            }
            if ("bd_material".equals(entityNumber)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"materialname"});
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{entityNumber});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (CONFIRM_DIMENSION.equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            this.getModel().deleteEntryData("entryentity");
            this.initData();
        } else if (CONFIRM_DIMENSION.equals(callBackId) && MessageBoxResult.Cancel == messageBoxClosedEvent.getResult()) {
            this.getModel().beginInit();
            if (this.getPageCache().get("oldValue") != null) {
                String oldValue = this.getPageCache().get("oldValue");
                this.getModel().setValue("dimension", (Object)Long.valueOf(oldValue));
                this.getView().updateView("dimension");
            }
            this.getModel().endInit();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        String appID = this.getView().getFormShowParameter().getAppId();
        switch (name) {
            case "dimension": {
                ChangeData changeData = e.getChangeSet()[0];
                if (changeData.getOldValue() != null) {
                    DynamicObject oldValue = (DynamicObject)changeData.getOldValue();
                    this.getPageCache().put("oldValue", String.valueOf(oldValue.getLong("id")));
                    this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5e93\u5b58\u6c34\u4f4d\u7ef4\u5ea6\u5c06\u6e05\u9664\u6c34\u4f4d\u4fe1\u606f\uff0c\u786e\u8ba4\u5207\u6362\uff1f\uff08\u5bf9\u5e94\u6309\u94ae\uff1a\u53d6\u6d88\u3001\u786e\u8ba4\uff09", (String)"InventoryLevelBasePlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DIMENSION));
                    break;
                }
                this.initData();
                break;
            }
            case "safeinv": 
            case "leadtime": 
            case "dailyconsume": {
                Object planType = this.getModel().getValue(PLANTYPE);
                if ("mrp".equals(appID) || "C".equals(planType)) break;
                BigDecimal s = (BigDecimal)model.getValue(SAFEINV);
                Integer l = (Integer)model.getValue(LEADTIME);
                BigDecimal d = (BigDecimal)model.getValue(DAILYCONSUME);
                Object val = e.getChangeSet()[0].getNewValue();
                if (name.equals(SAFEINV)) {
                    s = (BigDecimal)val;
                } else if (name.equals(LEADTIME)) {
                    l = (Integer)val;
                } else {
                    d = (BigDecimal)val;
                }
                if (s == null || l == null || d == null) break;
                BigDecimal add = d.multiply(new BigDecimal(l)).add(s);
                model.setValue("reorder", (Object)add);
                break;
            }
            case "bos_org": {
                model.setValue("bd_materialgroupstandard", null, rowIndex);
                DynamicObject org = (DynamicObject)this.getModel().getValue("bos_org", rowIndex);
                if (org == null) break;
                String org_id = String.valueOf(org.getLong("id"));
                if (this.getPageCache().get(org_id) == null) break;
                String standardId = this.getPageCache().get(org_id);
                this.getModel().setValue("bd_materialgroupstandard", (Object)Long.valueOf(standardId), rowIndex);
                break;
            }
            case "bd_materialgroupstandard": {
                model.setValue("bd_materialgroup", null, rowIndex);
                DynamicObject bos_org = (DynamicObject)this.getModel().getValue("bos_org", rowIndex);
                DynamicObject material_standard = (DynamicObject)this.getModel().getValue("bd_materialgroupstandard");
                if (bos_org == null || material_standard == null) break;
                Long orgId = bos_org.getLong("id");
                Long standard_id = material_standard.getLong("id");
                this.getPageCache().put(String.valueOf(orgId), String.valueOf(standard_id));
                break;
            }
            case "bd_materialgroup": {
                model.setValue("bd_material", null, rowIndex);
                break;
            }
        }
    }
}

