/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.mvc.base.BaseView;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.JSONUtils;
import kd.mpscmm.common.multiorgsupdem.OrgNode;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MultiorgsupdemPlugin
extends AbstractFormPlugin
implements TabSelectListener,
ListboxClickListener,
ItemClickListener,
HyperLinkClickListener {
    private static final Logger logger = Logger.getLogger(MultiorgsupdemPlugin.class);
    private static final String LISTBOXAP = "listboxap";
    private static final String FORMFLEX = "formflex";
    private static final String RELATIONFLEX = "relationflex";
    private static final String RELATIONID = "relationid";
    private static final String FROMID = "formid";
    private static final String CREATEORG = "createorg";
    private static final String MULTIORGSUPDEM = "mrp_multiorgsupdem";
    private static final String ORGID = "orgId";
    private static final String NODEDETAILS = "mrp_nodedetails";
    private static final String NODEDETAILS_LAYOUT = "mrp_nodedetails_layout";
    private static final String TABAP = "tabap";
    private static final String DEMANDORG = "demandorg";
    private static final String STOCKDEMANDORG = "stockdemandorg";
    private static final String STOCKTYPE = "stocktype";
    private static final String STOCKSTATUS = "stockstatus";
    private static final String SUPPLYORGGROUPTEXT = "supplyorggrouptext";
    private static final String PARENTDNYID = "parentdnyid";
    private static final String NEW = "new";
    private static final String IMPORTALL = "importall";
    private static final String EXPORTALL = "exportall";
    private static final String DELS = "del";
    private static final String DEL = "delete";
    private static final String IMP = "imp";
    private static final String IMPORT = "import";
    private static final String BEDIRECTEDID = "beDirectedId";
    private static final String POINTID = "pointId";
    private static final String EXP = "exp";
    private static final String EXPORT = "export";
    private static final String BILLLISTAP = "billlistap";
    private static final String BILLLISTAPS = "billlistap1";
    private static final String DNY = "dny";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLOSE = "bar_close";
    private static final String SAVE = "save";
    private static final String UNSUBMIT = "unsubmit";
    private static final String SUBMIT = "submit";
    private static final String AUDIT = "audit";
    private static final String TOOLBARAP = "tbmain";
    private static final String ADD = "add";
    private static final String ENABLE = "enable";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String TABPAGEAP = "tabpageap";
    private static final String SIGN = "sign";
    private static final String SUPPLYORG = "supplyorg";
    private static final String STOCKSUPPLY = "stocksupply";
    private static final String DEFAULTSUPPLY = "defaultsupply";
    private static final String MATERIALENTRYENTITY = "materialentryentity";
    private static final String SUPPLYORGENTRYENTITY = "supplyorgentryentity";
    private static final String STOCKSORGENTRENTRYENTITY = "stocksorgentrentryentity";
    private static final String STOCKSETUPENTRYENTITY = "stocksetupentryentity";
    private static final String MATERIALSETUP = "materialsetup";
    private static final String SHOWENTITY = "showentity";
    private static final String NODEMESSAGE = "nodeMessage";
    private static final String ISMOVE = "isMove";
    private static final String CLOSE_ST = "close_st";
    private static final String COPYID = "copyid";
    private static final String DELETESUPPLY = "deletesupply";
    private static final String DELETESTOCK = "deletestock";
    private static final String ALREADYCOPY = "alreadycopy";
    private static final String DATACHANGE = "datachange";
    private static final String ALL = "all";
    private static final String ADDNODE = "addNode";
    private static final String NODECLICK = "nodeClick";
    private static final String SELECTNODE = "selectNode";
    private static final String ADDTOP = "addTop";
    private static final String DELETETOP = "deleteTop";
    private static final String DEMAND = "demand";
    private static final String SUPPLY = "supply";
    private static final String TYPE = "type";
    private static final String EVENTARGS = "eventArgs";
    private static final String ALLDELETE = "allDelete";
    private static final String INITIMPORTPAGE = "msplan_initimportpage";
    private static final String NUMBER = "number";
    private List<String> ruleList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u9886\u6599", (String)"MultiorgsupdemPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u8c03\u62e8", (String)"MultiorgsupdemPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8de8\u7ec4\u7ec7\u5165\u5e93", (String)"MultiorgsupdemPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])});
    private List<String> stockList = Lists.newArrayList((Object[])new String[]{ResManager.loadKDString((String)"\u5168\u90e8\u4ed3\u5e93", (String)"MultiorgsupdemPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6307\u5b9a\u4ed3\u5e93", (String)"MultiorgsupdemPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6392\u9664\u6307\u5b9a\u4ed3\u5e93", (String)"MultiorgsupdemPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])});
    private boolean isxy = false;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox box = (Listbox)this.getControl(LISTBOXAP);
        box.addListboxClickListener((ListboxClickListener)this);
        Tab tab = (Tab)this.getControl(TABAP);
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener((TabSelectListener)this);
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        BillList billLists = (BillList)this.getControl(BILLLISTAPS);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billLists.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{TOOLBARAP});
        this.addClickListeners(new String[]{NEW, DELS, EXPORTALL, IMPORTALL});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setNumberEdit();
        this.setFlexCollSpase();
        this.setBillListFilter(BILLLISTAP);
        this.setBillListFilter(BILLLISTAPS);
        this.getView().setVisible(Boolean.FALSE, new String[]{RELATIONFLEX});
        this.initListBox();
        this.initRelationalView();
        this.setAddPageChache();
    }

    private void setFlexCollSpase() {
        Container fs_baseinfo = (Container)this.getControl("fs_baseinfo");
        fs_baseinfo.setCollapse(true);
        Container flexpanelap11 = (Container)this.getControl("flexpanelap11");
        flexpanelap11.setCollapse(true);
    }

    private void setNumberEdit() {
        String status = this.getModel().getDataEntity(true).getString("status");
        if ("A".equals(status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{NUMBER});
        }
    }

    public void listboxClick(ListboxEvent listboxEvent) {
        String itemId = listboxEvent.getItemId();
        if (FROMID.equals(itemId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{RELATIONFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{FORMFLEX});
        } else if (RELATIONID.equals(itemId)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{FORMFLEX});
            this.getView().setVisible(Boolean.TRUE, new String[]{RELATIONFLEX});
            this.initRelationalView();
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        if (ADDNODE.equals(eventName)) {
            this.openNodeDetailPage(null, ALL);
        } else if (NODECLICK.equals(eventName)) {
            String eventArgs = e.getEventArgs();
            try {
                Map cast = (Map)JSONUtils.cast((String)eventArgs, Map.class);
                this.getPageCache().put(ORGID, cast.get(ID).toString());
                if (DEMAND.equals(cast.get(TYPE))) {
                    DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)NODEDETAILS, (String)ID, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)this.getModel().getDataEntity().getPkValue().toString()).and(DEMANDORG, "=", (Object)Long.parseLong((String)cast.get(ID))).and(ENABLE, "=", (Object)"1")});
                    if (dynamicObject != null) {
                        this.openNodeDetailPage(dynamicObject.get(ID), ALL);
                    }
                } else {
                    List beDirectedId = (List)cast.get(BEDIRECTEDID);
                    if (beDirectedId != null && beDirectedId.size() != 0) {
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)NODEDETAILS, (String)ID, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)this.getModel().getDataEntity().getPkValue().toString()).and(DEMANDORG, "=", (Object)Long.parseLong((String)cast.get(ID))).and(ENABLE, "=", (Object)"1")});
                        if (dynamicObject != null) {
                            this.openNodeDetailPage(dynamicObject.get(ID), ALL);
                        }
                    } else if (cast.get(ID) != null) {
                        this.getPageCache().put(ORGID, cast.get(ID).toString());
                        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)NODEDETAILS, (String)ID, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)this.getModel().getDataEntity().getPkValue().toString()).and(STOCKDEMANDORG, "=", (Object)Long.parseLong((String)cast.get(ID))).and(ENABLE, "=", (Object)"1")});
                        if (dynamicObject != null) {
                            this.openNodeDetailPage(dynamicObject.get(ID), ALL);
                        } else {
                            this.openNodeDetailPage(null, ALL);
                        }
                    } else {
                        this.openNodeDetailPage(null, ALL);
                    }
                }
                this.getPageCache().put(EVENTARGS, eventArgs);
            }
            catch (Exception ex) {
                logger.error((Object)ex.toString());
                throw new KDBizException(ex.getMessage());
            }
        } else if (SELECTNODE.equals(eventName)) {
            String eventArgs = e.getEventArgs();
            this.getPageCache().put(EVENTARGS, eventArgs);
        } else if (ADDTOP.equals(eventName)) {
            this.openNodeDetailPage(null, ALL);
        } else if (DELETETOP.equals(eventName)) {
            this.confirmIsDel();
        } else if ("conserve".equals(eventName) || "CQconserve".equals(eventName)) {
            String eventArgs = e.getEventArgs();
            this.getPageCache().put("conserve", eventArgs);
            String sql = "update t_mrp_multiorgsupdem set fcussave_tag = ? where fid = ?";
            Object[] object = new Object[]{eventArgs, this.getModel().getDataEntity(true).getPkValue()};
            DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql, (Object[])object);
            this.getPageCache().remove(ISMOVE);
            if ("conserve".equals(eventName)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u89c6\u56fe\u6210\u529f\u3002", (String)"MultiorgsupdemPlugin_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            this.initRelationalView();
        } else if (ISMOVE.equals(eventName)) {
            this.getPageCache().put(ISMOVE, "1");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(NODEMESSAGE) != null) {
            e.setCancel(true);
            this.checkClose();
        } else if (this.getPageCache().get(ISMOVE) != null) {
            e.setCancel(true);
            this.checkClose();
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String operationKey = evt.getOperationKey();
        if (SAVE.equals(operationKey) || SUBMIT.equals(operationKey)) {
            this.savePosition();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String operationKey = evt.getOperationKey();
        String itemKey = evt.getItemKey();
        if (TABPAGEAP1.equals(itemKey)) {
            if (NEW.equals(operationKey)) {
                this.openNodeDetailPage(null, STOCKSUPPLY);
            } else if (DEL.equals(operationKey)) {
                this.billListConfirmIsDel(BILLLISTAPS, DELETESTOCK);
            } else if (IMPORT.equals(operationKey)) {
                this.openInitImportPage(operationKey);
            } else if (EXPORT.equals(operationKey)) {
                this.exportDataToExcel(operationKey);
            }
        } else if (TABPAGEAP.equals(itemKey)) {
            if (NEW.equals(operationKey)) {
                this.openNodeDetailPage(null, SUPPLYORG);
            } else if (DEL.equals(operationKey)) {
                this.billListConfirmIsDel(BILLLISTAP, DELETESUPPLY);
            } else if (IMP.equals(operationKey)) {
                this.openInitImportPage(operationKey);
            } else if (EXP.equals(operationKey)) {
                this.exportDataToExcel(operationKey);
            }
        } else if (CLOSE.equals(itemKey)) {
            this.checkClose();
        }
    }

    private void savePosition() {
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        if (control == null) {
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("action", SAVE);
        paramsMap.put("time", TimeServiceHelper.now().toString());
        paramsMap.put("CQsave", true);
        control.setData(paramsMap);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        OperationResult operationResult = e.getOperationResult();
        if ((SAVE.equals(operateKey) || SUBMIT.equals(operateKey) || AUDIT.equals(operateKey)) && operationResult.isSuccess()) {
            this.deletePerPageSaveDny();
            this.deleteDisableRows();
            this.getPageCache().remove(ISMOVE);
        } else if (DEL.equals(operateKey) && e.getOperationResult().isSuccess()) {
            this.deleteMulitAfterDeleteNode(e);
        } else if (UNSUBMIT.equals(operateKey) && e.getOperationResult().isSuccess()) {
            this.initRelationalView();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (NEW.equals(actionId)) {
            this.billLisrRef();
            this.initRelationalView();
            if (returnData != null) {
                this.getPageCache().put(NODEMESSAGE, returnData.toString());
            }
        } else if (INITIMPORTPAGE.equals(actionId)) {
            this.billLisrRef();
            if (returnData == null) {
                return;
            }
            Map returnData1 = (Map)returnData;
            this.getPageCache().put(NODEMESSAGE, (String)returnData1.get(NODEMESSAGE));
            if (returnData1.containsKey("url")) {
                this.openResultPage(returnData);
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        ListSelectedRow currentRow = ((BillListHyperLinkClickEvent)e).getCurrentRow();
        if (currentRow != null) {
            Object primaryKeyValue = currentRow.getPrimaryKeyValue();
            if (DEFAULTSUPPLY.equals(currentRow.getEntryEntityKey())) {
                this.openNodeDetailPage(primaryKeyValue, SUPPLYORG);
            } else {
                this.openNodeDetailPage(primaryKeyValue, STOCKSUPPLY);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "bar_close": {
                if (result != MessageBoxResult.Yes) break;
                this.deleteChangeDataAndSaveOldData();
                this.deleteDisableRows();
                this.getPageCache().remove(NODEMESSAGE);
                this.getPageCache().remove(ISMOVE);
                this.getView().close();
                break;
            }
            case "deletesupply": {
                if (result != MessageBoxResult.Yes) break;
                this.deleteSupplyData();
                this.setBillListFilter(BILLLISTAPS);
                break;
            }
            case "deletestock": {
                if (result != MessageBoxResult.Yes) break;
                this.deleteStockData();
                this.setBillListFilter(BILLLISTAP);
                break;
            }
            case "allDelete": {
                if (result != MessageBoxResult.Yes) break;
                this.deleteNode();
                this.setBillListFilter(BILLLISTAP);
                this.setBillListFilter(BILLLISTAPS);
                this.initRelationalView();
                break;
            }
            case "close_st": {
                if (result != MessageBoxResult.Yes) break;
                this.getPageCache().remove(ISMOVE);
                this.getView().close();
            }
        }
    }

    public void tabSelected(TabSelectEvent event) {
    }

    private void openResultPage(Object returnData) {
        if (returnData == null) {
            return;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("msplan_importlog");
        formShowParameter.setCustomParam("message", returnData);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(formShowParameter);
    }

    private void billListConfirmIsDel(String sign, String callBackSign) {
        BillList billLists = (BillList)this.getControl(sign);
        if (billLists.getSelectedRows().size() <= 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"MultiorgsupdemPlugin_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackSign, (IFormPlugin)this);
        String strs = String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"MultiorgsupdemPlugin_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[0]);
        this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private void deleteMulitAfterDeleteNode(AfterDoOperationEventArgs e) {
        List successPkIds = e.getOperationResult().getSuccessPkIds();
        ArrayList<String> idList = new ArrayList<String>(8);
        for (Object o : successPkIds) {
            idList.add(o.toString());
        }
        DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "in", idList)});
        this.getPageCache().remove(NODEMESSAGE);
        logger.info((Object)("deleteMulitAfterDeleteNode :" + ((Object)idList).toString()));
        this.getView().close();
    }

    private void deleteDisableRows() {
        int deleteNum = DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)this.getDnyId()).and(ENABLE, "=", (Object)"0")});
        logger.info((Object)("deleteDisableRows:" + deleteNum));
    }

    private void setAddPageChache() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(ADD);
        if (customParam != null) {
            String nodeMessage = this.getPageCache().get(NODEMESSAGE);
            List object = (List)SerializationUtils.deSerializeFromBase64((String)customParam.toString());
            if (nodeMessage == null) {
                HashMap pkIdMap = new HashMap();
                ArrayList longs = (ArrayList)pkIdMap.get(ADD);
                if (longs == null) {
                    longs = new ArrayList(8);
                    longs.addAll(object);
                }
                pkIdMap.put(ADD, longs);
                pkIdMap.put(DATACHANGE, longs);
                this.getPageCache().put(NODEMESSAGE, SerializationUtils.serializeToBase64(pkIdMap));
            }
        }
    }

    private void openInitImportPage(String operationKey) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(INITIMPORTPAGE);
        formShowParameter.setCustomParam(SIGN, (Object)this.getSign(operationKey));
        formShowParameter.setCustomParam(PARENTDNYID, (Object)this.getDnyId());
        formShowParameter.setCustomParam(NODEMESSAGE, (Object)this.getPageCache().get(NODEMESSAGE));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, INITIMPORTPAGE));
        this.getView().showForm(formShowParameter);
    }

    public String getSign(String operationKey) {
        if (IMP.equals(operationKey) || EXP.equals(operationKey)) {
            return SUPPLYORG;
        }
        if (IMPORT.equals(operationKey) || EXPORT.equals(operationKey)) {
            return STOCKSUPPLY;
        }
        return ALL;
    }

    private String getUrl(String operationKey) {
        String sign = this.getSign(operationKey);
        if (SUPPLYORG.equals(sign)) {
            if ("en-US".equals(Lang.get().getLangTag())) {
                return "multiorgsupdem/supply Network Template.xlsx";
            }
            return ResManager.loadKDString((String)"multiorgsupdem/\u4f9b\u5e94\u5173\u7cfb\u7f51\u7edc\u6a21\u677f.xlsx", (String)"MultiorgsupdemPlugin_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        }
        if (STOCKSUPPLY.equals(sign)) {
            if ("en-US".equals(Lang.get().getLangTag())) {
                return "multiorgsupdem/stock supply strategy import template.xlsx";
            }
            return ResManager.loadKDString((String)"multiorgsupdem/\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u5f15\u5165\u6a21\u677f.xlsx", (String)"MultiorgsupdemPlugin_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"multiorgsupdem/\u4f9b\u9700\u5173\u7cfb\u7f51\u7edc&\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u5f15\u5165\u6a21\u677f.xlsx", (String)"MultiorgsupdemPlugin_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
    }

    private void exportDataToExcel(String operationKey) {
        String url = this.getUrl(operationKey);
        try (InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(url);){
            String billListSign = this.getBillListSign(operationKey);
            XSSFWorkbook book = new XSSFWorkbook(in);
            String fileName = this.getFileName(operationKey);
            this.setExcelData(book, billListSign);
            ((IClientViewProxy)this.getView().getService(IClientViewProxy.class)).addAction("download", (Object)this.writeFile(book, fileName));
        }
        catch (Exception ex) {
            logger.info((Object)("exportDataToExcel:" + ex));
            throw new KDBizException(ex.getMessage());
        }
    }

    private String getFileName(String operationKey) {
        String sign = "";
        sign = EXP.equals(operationKey) ? ResManager.loadKDString((String)"\u4f9b\u5e94\u5173\u7cfb\u7f51\u7edc--\u5bfc\u51fa\u6570\u636e", (String)"MultiorgsupdemPlugin_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : (EXPORT.equals(operationKey) ? ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565--\u5bfc\u51fa\u6570\u636e", (String)"MultiorgsupdemPlugin_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f9b\u9700\u5173\u7cfb\u7f51\u7edc&\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565--\u5bfc\u51fa\u6570\u636e", (String)"MultiorgsupdemPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        return sign;
    }

    private String getBillListSign(String operationKey) {
        String sign = "";
        sign = EXP.equals(operationKey) ? BILLLISTAP : (EXPORT.equals(operationKey) ? BILLLISTAPS : ALL);
        return sign;
    }

    private void setExcelData(XSSFWorkbook book, String sign) {
        XSSFSheet firstSheet = book.getSheetAt(0);
        DynamicObject[] excelData = this.getExcelData(sign);
        if (excelData.length == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u53ef\u5bfc\u51fa\u3002", (String)"MultiorgsupdemPlugin_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        }
        if (BILLLISTAP.equals(sign)) {
            this.setSupplyOrgExcelDataToCell(firstSheet, excelData, sign);
        } else if (BILLLISTAPS.equals(sign)) {
            this.setStockSupplyExcelDataToCell(firstSheet, excelData, sign);
        } else {
            this.setAllExcelDataToCell(firstSheet, excelData, sign);
        }
    }

    private void setAllExcelDataToCell(XSSFSheet firstSheet, DynamicObject[] excelData, String sign) {
    }

    private void setStockSupplyExcelDataToCell(XSSFSheet firstSheet, DynamicObject[] excelData, String sign) {
        Map<Integer, String> map = this.getFiledMap(sign);
        int beginRow = 4;
        for (DynamicObject dynamicObject : excelData) {
            int size = this.getMaxSize(dynamicObject, STOCKSORGENTRENTRYENTITY, STOCKSETUPENTRYENTITY, MATERIALSETUP, 0);
            for (int i = beginRow; i < size + beginRow; ++i) {
                XSSFRow row = this.creatRow(firstSheet, i);
                for (int j = 0; j < map.size() + 1; ++j) {
                    this.creatCell(row, j);
                    if (j < 3) {
                        this.putBodtimeToExcel(i, beginRow, dynamicObject, map, j, row);
                        continue;
                    }
                    if (j < 7) {
                        this.putStockTypeAndStatusToExcel(i, beginRow, dynamicObject, map, j, row, false);
                        continue;
                    }
                    if (j < 11) {
                        this.putStockOrgToExcel(i, beginRow, dynamicObject, map, j, row, 9);
                        continue;
                    }
                    if (j < 12) {
                        this.putStockSetToExcel(i, beginRow, dynamicObject, map, j, row);
                        continue;
                    }
                    if (j < 21) {
                        this.putStockToExcel(i, beginRow, dynamicObject, map, j, row, 19);
                        continue;
                    }
                    if (j >= 33) continue;
                    this.putStockOrgToExcel(i, beginRow, dynamicObject, map, j, row, 31);
                }
            }
            beginRow += size;
        }
    }

    private void putBodtimeToExcel(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row) {
        if (rowNum == beginRow) {
            row.getCell(cellNum).setCellValue(dynamicObject.getString(map.get(cellNum)));
        }
    }

    private void putStockToExcel(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row, int dnyNum) {
        String[] split = map.get(cellNum).split("\\.");
        if (dynamicObject.getDynamicObjectCollection(split[0]).size() > rowNum - beginRow) {
            DynamicObject dynamicObject1 = (DynamicObject)dynamicObject.getDynamicObjectCollection(split[0]).get(rowNum - beginRow);
            if (cellNum < dnyNum) {
                DynamicObject dynamicObject2 = dynamicObject1.getDynamicObject(split[1]);
                if (dynamicObject2 != null) {
                    row.getCell(cellNum).setCellValue(dynamicObject2.getString(split[2]));
                }
            } else {
                row.getCell(cellNum).setCellValue(dynamicObject1.getString(split[1]));
            }
        }
    }

    private void putStockSetToExcel(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row) {
        if (rowNum == beginRow) {
            if (dynamicObject.getString(map.get(cellNum)).isEmpty()) {
                row.getCell(cellNum).setCellValue("");
            } else {
                row.getCell(cellNum).setCellValue(this.stockList.get(dynamicObject.getInt(map.get(cellNum)) - 1));
            }
        }
    }

    private void putStockOrgToExcel(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row, int dnyNum) {
        String[] split = map.get(cellNum).split("\\.");
        if (dynamicObject.getDynamicObjectCollection(split[0]).size() > rowNum - beginRow) {
            DynamicObject dynamicObject1 = (DynamicObject)dynamicObject.getDynamicObjectCollection(split[0]).get(rowNum - beginRow);
            if (cellNum < dnyNum) {
                DynamicObject dynamicObject2 = dynamicObject1.getDynamicObject(split[1]);
                if (dynamicObject2 != null) {
                    row.getCell(cellNum).setCellValue(dynamicObject2.getString(split[2]));
                }
            } else {
                row.getCell(cellNum).setCellValue(dynamicObject1.getString(split[1]));
            }
        }
    }

    private void putStockTypeAndStatusToExcel(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row, boolean isAll) {
        String[] split;
        DynamicObjectCollection dynamicObjectCollection;
        if (rowNum == beginRow && (dynamicObjectCollection = dynamicObject.getDynamicObjectCollection((split = map.get(cellNum).split("\\."))[0])).size() != 0) {
            String number = "";
            String name = "";
            int cellnum_n = cellNum;
            if (isAll) {
                cellnum_n = cellNum + 1;
            }
            for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                if (cellnum_n % 2 != 0) {
                    if (number.isEmpty()) {
                        number = dynamicObject1.getDynamicObject("fbasedataid").getString(NUMBER);
                        continue;
                    }
                    number = number + "," + dynamicObject1.getDynamicObject("fbasedataid").getString(NUMBER);
                    continue;
                }
                if (name.isEmpty()) {
                    name = dynamicObject1.getDynamicObject("fbasedataid").getString(NAME);
                    continue;
                }
                name = name + "," + dynamicObject1.getDynamicObject("fbasedataid").getString(NAME);
            }
            if (cellnum_n % 2 != 0) {
                row.getCell(cellNum).setCellValue(number);
            } else {
                row.getCell(cellNum).setCellValue(name);
            }
        }
    }

    private void setSupplyOrgExcelDataToCell(XSSFSheet firstSheet, DynamicObject[] excelData, String sign) {
        Map<Integer, String> map = this.getFiledMap(sign);
        int beginRow = 4;
        for (DynamicObject dynamicObject : excelData) {
            List<Map<String, String>> spcialList = this.getSpcialMap(dynamicObject);
            int size = this.getMaxSize(dynamicObject, DEFAULTSUPPLY, MATERIALENTRYENTITY, SUPPLYORGENTRYENTITY, 0);
            for (int i = beginRow; i < size + beginRow; ++i) {
                XSSFRow row = this.creatRow(firstSheet, i);
                for (int j = 0; j < map.size() + 1; ++j) {
                    this.creatCell(row, j);
                    if (j < 2) {
                        this.putDemandOrgToCell(i, beginRow, dynamicObject, map, j, row);
                        continue;
                    }
                    if (j < 6) {
                        this.putDefaultSupplyToCell(i, beginRow, dynamicObject, map, j, row);
                        continue;
                    }
                    if (j >= 15) continue;
                    this.putSpcialSupplyToCell(i, beginRow, map, j, row, spcialList);
                }
            }
            beginRow += size;
        }
    }

    private XSSFRow creatRow(XSSFSheet firstSheet, int rowNum) {
        XSSFRow row = firstSheet.getRow(rowNum);
        if (row == null) {
            row = firstSheet.createRow(rowNum);
        }
        return row;
    }

    private XSSFCell creatCell(XSSFRow row, int cellNum) {
        XSSFCell cell = row.getCell(cellNum);
        if (cell == null) {
            cell = row.createCell(cellNum);
        }
        return cell;
    }

    private void putSpcialSupplyToCell(int rowNum, int beginRow, Map<Integer, String> map, int cellNum, XSSFRow row, List<Map<String, String>> spcialList) {
        int i = rowNum - beginRow;
        int size = spcialList.size();
        if (size != 0 && size > i) {
            Map<String, String> map1 = spcialList.get(rowNum - beginRow);
            row.getCell(cellNum).setCellValue(map1.get(map.get(cellNum)));
        }
    }

    private void putDefaultSupplyToCell(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row) {
        String[] split = map.get(cellNum).split("\\.");
        if (dynamicObject.getDynamicObjectCollection(split[0]).size() > rowNum - beginRow) {
            DynamicObject dynamicObject1 = (DynamicObject)dynamicObject.getDynamicObjectCollection(split[0]).get(rowNum - beginRow);
            if (cellNum < 4) {
                DynamicObject dynamicObject2 = dynamicObject1.getDynamicObject(split[1]);
                if (dynamicObject2 != null) {
                    row.getCell(cellNum).setCellValue(dynamicObject2.getString(split[2]));
                }
            } else {
                row.getCell(cellNum).setCellValue(dynamicObject1.getString(split[1]));
                if (split[1].contains("rule")) {
                    String ruleValue = dynamicObject1.getString(split[1]);
                    String rule = "";
                    if (!ruleValue.isEmpty()) {
                        rule = this.ruleList.get(Integer.parseInt(ruleValue) - 1);
                    }
                    row.getCell(cellNum).setCellValue(rule);
                }
            }
        }
    }

    private void putDemandOrgToCell(int rowNum, int beginRow, DynamicObject dynamicObject, Map<Integer, String> map, int cellNum, XSSFRow row) {
        if (rowNum == beginRow) {
            String demandOrg = dynamicObject.getString(map.get(cellNum));
            if (demandOrg == null || demandOrg.isEmpty()) {
                demandOrg = cellNum == 0 ? dynamicObject.getString("stockdemandorg.number") : dynamicObject.getString("stockdemandorg.name");
            }
            row.getCell(cellNum).setCellValue(demandOrg);
        }
    }

    private List<Map<String, String>> getSpcialMap(DynamicObject dynamicObject) {
        Map<String, List<DynamicObject>> supplyBaseOrg_ma = this.getSupplyBaseOrg(dynamicObject, MATERIALENTRYENTITY, "msupplyorggroup");
        Map<String, List<DynamicObject>> supplyBaseOrg_su = this.getSupplyBaseOrg(dynamicObject, SUPPLYORGENTRYENTITY, "ssupplyorggroup");
        logger.info((Object)("getSpcialMap:" + supplyBaseOrg_ma.toString() + "supplyBaseOrg_su:" + supplyBaseOrg_su.toString()));
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>(8);
        for (Map.Entry<String, List<DynamicObject>> map : supplyBaseOrg_ma.entrySet()) {
            HashMap<String, String> valueMap;
            String key = map.getKey();
            List<DynamicObject> value = map.getValue();
            List<DynamicObject> list = supplyBaseOrg_su.get(key);
            int i = 0;
            if (list.size() > value.size()) {
                for (DynamicObject dynamicObject1 : list) {
                    valueMap = new HashMap<String, String>(8);
                    valueMap.put("supplyorg.number", dynamicObject1.getDynamicObject(SUPPLYORG).getString(NUMBER));
                    valueMap.put("supplyorg.name", dynamicObject1.getDynamicObject(SUPPLYORG).getString(NAME));
                    valueMap.put("supplyproportion", dynamicObject1.getString("supplyproportion"));
                    String ruleValue = dynamicObject1.getString("supplyrule");
                    if (!ruleValue.isEmpty()) {
                        ruleValue = this.ruleList.get(Integer.parseInt(ruleValue) - 1);
                    }
                    valueMap.put("supplyrule", ruleValue);
                    if (value.size() > i) {
                        DynamicObject dynamicObject2 = value.get(i);
                        valueMap.put("msupplyorggroup.number", dynamicObject2.getDynamicObject("msupplyorggroup").getString(NUMBER));
                        valueMap.put("msupplyorggroup.name", dynamicObject2.getDynamicObject("msupplyorggroup").getString(NAME));
                        valueMap.put("materialnumber.number", dynamicObject2.getDynamicObject("materialnumber").getString(NUMBER));
                        valueMap.put("materialnumber.name", dynamicObject2.getDynamicObject("materialnumber").getString(NAME));
                        valueMap.put("materialnumber.modelnum", dynamicObject2.getDynamicObject("materialnumber").getString("modelnum"));
                    }
                    ++i;
                    listMap.add(valueMap);
                }
                continue;
            }
            for (DynamicObject dynamicObject2 : value) {
                valueMap = new HashMap(8);
                valueMap.put("msupplyorggroup.number", dynamicObject2.getDynamicObject("msupplyorggroup").getString(NUMBER));
                valueMap.put("msupplyorggroup.name", dynamicObject2.getDynamicObject("msupplyorggroup").getString(NAME));
                valueMap.put("materialnumber.number", dynamicObject2.getDynamicObject("materialnumber").getString(NUMBER));
                valueMap.put("materialnumber.name", dynamicObject2.getDynamicObject("materialnumber").getString(NAME));
                valueMap.put("materialnumber.modelnum", dynamicObject2.getDynamicObject("materialnumber").getString("modelnum"));
                if (list.size() > i) {
                    DynamicObject dynamicObject1 = list.get(i);
                    valueMap.put("supplyorg.number", dynamicObject1.getDynamicObject(SUPPLYORG).getString(NUMBER));
                    valueMap.put("supplyorg.name", dynamicObject1.getDynamicObject(SUPPLYORG).getString(NAME));
                    valueMap.put("supplyproportion", dynamicObject1.getString("supplyproportion"));
                    String ruleValue = dynamicObject1.getString("supplyrule");
                    if (!ruleValue.isEmpty()) {
                        ruleValue = this.ruleList.get(Integer.parseInt(ruleValue) - 1);
                    }
                    valueMap.put("supplyrule", ruleValue);
                }
                ++i;
                listMap.add(valueMap);
            }
        }
        return listMap;
    }

    private Map<String, List<DynamicObject>> getSupplyBaseOrg(DynamicObject dynamicObject, String entitySign, String filedSign) {
        HashMap<String, List<DynamicObject>> map_su = new HashMap<String, List<DynamicObject>>(16);
        DynamicObjectCollection supplyorgentryentity = dynamicObject.getDynamicObjectCollection(entitySign);
        for (DynamicObject dynamicObject1 : supplyorgentryentity) {
            ArrayList<DynamicObject> list;
            DynamicObject ssupplyorggroup = dynamicObject1.getDynamicObject(filedSign);
            if (ssupplyorggroup == null) continue;
            String number = ssupplyorggroup.getString(NUMBER);
            if (map_su.containsKey(number)) {
                list = (ArrayList<DynamicObject>)map_su.get(number);
                list.add(dynamicObject1);
                continue;
            }
            list = new ArrayList<DynamicObject>(8);
            list.add(dynamicObject1);
            map_su.put(number, list);
        }
        return map_su;
    }

    private int getMaxSize(DynamicObject dynamicObject, String entity, String entity1, String entity2, int sizeValue) {
        int size = 0;
        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(entity);
        DynamicObjectCollection materialCollection = dynamicObject.getDynamicObjectCollection(entity1);
        DynamicObjectCollection supplyorgCollection = dynamicObject.getDynamicObjectCollection(entity2);
        size = dynamicObjectCollection.size() > materialCollection.size() ? dynamicObjectCollection.size() : materialCollection.size();
        if (size < supplyorgCollection.size()) {
            size = supplyorgCollection.size();
        }
        if (size < sizeValue) {
            size = sizeValue;
        }
        return size;
    }

    private Map<Integer, String> getFiledMap(String sign) {
        HashMap<Integer, String> map = new HashMap<Integer, String>(16);
        if (BILLLISTAP.equals(sign)) {
            map.put(0, "demandorg.number");
            map.put(1, "demandorg.name");
            map.put(2, "defaultsupply.defaultsupplyorg.number");
            map.put(3, "defaultsupply.defaultsupplyorg.name");
            map.put(4, "defaultsupply.supplyratio");
            map.put(5, "defaultsupply.defaultsupplyrule");
            map.put(6, "msupplyorggroup.number");
            map.put(7, "msupplyorggroup.name");
            map.put(8, "materialnumber.number");
            map.put(9, "materialnumber.name");
            map.put(10, "materialnumber.modelnum");
            map.put(11, "supplyorg.number");
            map.put(12, "supplyorg.name");
            map.put(13, "supplyproportion");
            map.put(14, "supplyrule");
        } else if (BILLLISTAPS.equals(sign)) {
            map.put(0, "stockdemandorg.number");
            map.put(1, "stockdemandorg.name");
            map.put(2, "bodtime");
            map.put(3, "stocktype.number");
            map.put(4, "stocktype.name");
            map.put(5, "stockstatus.number");
            map.put(6, "stockstatus.name");
            map.put(7, "stocksorgentrentryentity.storageorg.number");
            map.put(8, "stocksorgentrentryentity.storageorg.name");
            map.put(9, "stocksorgentrentryentity.priority");
            map.put(10, "stocksorgentrentryentity.stockscale");
            map.put(11, "stocksetup");
            map.put(12, "stocksetupentryentity.stockorg.number");
            map.put(13, "stocksetupentryentity.stockorg.name");
            map.put(14, "stocksetupentryentity.stocknumber.number");
            map.put(15, "stocksetupentryentity.stocknumber.name");
            map.put(16, "stocksetupentryentity.stockindex.number");
            map.put(17, "stocksetupentryentity.stockindex.name");
            map.put(18, "stocksetupentryentity.stocknumber.address");
            map.put(19, "stocksetupentryentity.supplypriority");
            map.put(20, "stocksetupentryentity.wastewarehouse");
            map.put(21, "materialsetup.materiel.number");
            map.put(22, "materialsetup.materiel.name");
            map.put(23, "materialsetup.materiel.modelnum");
            map.put(24, "materialsetup.materialorg.number");
            map.put(25, "materialsetup.materialorg.name");
            map.put(26, "materialsetup.stock.number");
            map.put(27, "materialsetup.stock.name");
            map.put(28, "materialsetup.stockindexs.number");
            map.put(29, "materialsetup.stockindexs.name");
            map.put(30, "materialsetup.stock.address");
            map.put(31, "materialsetup.prioritylevel");
            map.put(32, "materialsetup.stockratio");
        }
        return map;
    }

    private DynamicObject[] getExcelData(String sign) {
        ListSelectedRowCollection selectedRows = null;
        if (!ALL.equals(sign)) {
            BillList billList = (BillList)this.getControl(sign);
            selectedRows = billList.getSelectedRows();
        }
        String org = "";
        org = BILLLISTAP.equals(sign) ? DEMANDORG : STOCKDEMANDORG;
        String selectField = ID;
        ArrayList<Long> list = new ArrayList<Long>(8);
        if (selectedRows == null || selectedRows.size() == 0) {
            DynamicObjectCollection query = QueryServiceHelper.query((String)NODEDETAILS, (String)selectField, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)this.getDnyId()).and(ENABLE, "=", (Object)"1").and(org, "!=", (Object)0L)});
            for (DynamicObject dynamicObject : query) {
                list.add(dynamicObject.getLong(ID));
            }
        } else {
            for (ListSelectedRow selectedRow : selectedRows) {
                list.add((Long)selectedRow.getPrimaryKeyValue());
            }
        }
        return BusinessDataServiceHelper.load((Object[])list.toArray(), (DynamicObjectType)this.getNodeDnyType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeFile(XSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            String string = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName + ".xlsx", (InputStream)inStream, 10000);
            return string;
        }
        finally {
            if (outStream != null) {
                outStream.close();
            }
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    private Map<Long, Object> checkSelect(String sign, Map<Long, List<Long>> pkidMap, DynamicObject[] load) {
        HashMap<Long, Object> map = new HashMap<Long, Object>(8);
        boolean isUpdata = false;
        ArrayList<Long> list = new ArrayList<Long>(8);
        Map<Long, List<Long>> getplangram = this.getplangram();
        for (DynamicObject dynamicObject : load) {
            Long pkValue = (Long)dynamicObject.getPkValue();
            List<Long> longs = pkidMap.get(pkValue);
            DynamicObjectCollection defaultsupply = dynamicObject.getDynamicObjectCollection(DEFAULTSUPPLY);
            DynamicObjectCollection showentity = dynamicObject.getDynamicObjectCollection(SHOWENTITY);
            if (BILLLISTAP.equals(sign)) {
                if (longs == null || longs.size() != defaultsupply.size()) continue;
                if (showentity == null || showentity.size() == 0) {
                    map.put(pkValue, dynamicObject);
                    continue;
                }
                if (!this.isNeedSetNull(dynamicObject, getplangram, DEMANDORG)) {
                    isUpdata = true;
                    dynamicObject.set(DEMANDORG, null);
                    dynamicObject.set(SUPPLYORGGROUPTEXT, null);
                    continue;
                }
                map.put(pkValue, dynamicObject);
                continue;
            }
            if (longs == null || longs.size() != showentity.size()) continue;
            if (defaultsupply == null || defaultsupply.size() == 0) {
                map.put(pkValue, dynamicObject);
                continue;
            }
            if (!this.isNeedSetNull(dynamicObject, getplangram, STOCKDEMANDORG)) {
                isUpdata = true;
                dynamicObject.set(STOCKDEMANDORG, null);
                dynamicObject.set(STOCKTYPE, null);
                dynamicObject.set(STOCKSTATUS, null);
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(MATERIALSETUP);
                if (dynamicObjectCollection == null || dynamicObjectCollection.size() == 0) continue;
                for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                    list.add(dynamicObject1.getLong(ID));
                }
                pkidMap.put(-1L, list);
                continue;
            }
            map.put(pkValue, dynamicObject);
        }
        if (isUpdata) {
            SaveServiceHelper.update((DynamicObject[])load);
        }
        return map;
    }

    private boolean isNeedSetNull(DynamicObject dynamicObject, Map<Long, List<Long>> getplangram, String sign) {
        Long aLong = dynamicObject.getDynamicObject(sign).getLong(ID);
        List<Long> list1 = getplangram.get(this.getModel().getDataEntity().getLong(ID));
        return list1 != null && list1.size() != 0 && list1.contains(aLong);
    }

    private void deletePerPageSaveDny() {
        try {
            this.getPageCache().remove(ADD);
            String dny = this.getPageCache().get(NODEMESSAGE);
            if (dny == null) {
                return;
            }
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)dny);
            List copyid = (List)map.get(COPYID);
            if (copyid != null && copyid.size() != 0) {
                DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)copyid)});
                logger.info((Object)("deletePerPageSaveDny :" + copyid.toString()));
            }
            map.clear();
            this.getPageCache().remove(NODEMESSAGE);
        }
        catch (Exception ex) {
            logger.error((Object)("deletePerPageSaveDny:" + ex));
            throw new KDBizException(ex.getMessage());
        }
    }

    private void initRelationalView() {
        try {
            HashMap<String, String> idAndName = new HashMap<String, String>(8);
            Map<String, Set<String>> map = this.getSupplyAndDemandOrg(idAndName);
            Object cussave_tag = this.getModel().getValue("cussave_tag");
            if (cussave_tag != null && this.getPageCache().get("conserve") == null) {
                this.getPageCache().put("conserve", cussave_tag.toString());
            }
            String conserve = this.getPageCache().get("conserve");
            List cast = null;
            if (conserve != null && !conserve.toString().isEmpty()) {
                cast = (List)JSONUtils.cast((String)String.valueOf(conserve), List.class);
            }
            Map<String, OrgNode> orgDemandNodeMap = this.initOrgNode(map, idAndName, DEMAND, cast);
            Map<String, Set<String>> nodePointMap = this.initOrgNodePointId(map);
            Map<String, OrgNode> orgSupplyNodeMap = this.initOrgNode(nodePointMap, idAndName, SUPPLY, cast);
            this.pointMine(orgDemandNodeMap, orgSupplyNodeMap);
            OrgNode[] change = this.changeTpoArray(orgDemandNodeMap, orgSupplyNodeMap);
            this.initJsonData(change);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void pointMine(Map<String, OrgNode> orgDemandNodeMap, Map<String, OrgNode> orgSupplyNodeMap) {
        Iterator<Map.Entry<String, OrgNode>> iterator = orgDemandNodeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            OrgNode orgNode;
            String[] pointId;
            Map.Entry<String, OrgNode> next = iterator.next();
            String key = next.getKey();
            OrgNode orgNode_d = next.getValue();
            if (!orgSupplyNodeMap.containsKey(key) || (pointId = (orgNode = orgSupplyNodeMap.get(key)).getPointId()).length <= 0) continue;
            List<String> list = Arrays.asList(pointId);
            if (list.contains(key)) {
                if (list.size() == 1) {
                    orgSupplyNodeMap.remove(key);
                    ArrayList<String> list1 = new ArrayList<String>(8);
                    list1.addAll(list);
                    orgNode_d.setPointId(list1.toArray(new String[1]));
                    continue;
                }
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
    }

    private void confirmIsDel() {
        String eventArgs = this.getPageCache().get(EVENTARGS);
        if (eventArgs == null || eventArgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"MultiorgsupdemPlugin_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ALLDELETE, (IFormPlugin)this);
        String strs = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u5305\u542b\u591a\u7ec4\u4f9b\u9700\u5173\u7cfb\uff0c\u672c\u6b21\u64cd\u4f5c\u5c06\u5bf9\u8be5\u8282\u70b9\u7684\u6240\u6709\u4f9b\u9700\u5173\u7cfb\u751f\u6548\uff0c\u786e\u8ba4\u5220\u9664\uff1f\uff08\u5bf9\u5e94\u6309\u94ae\uff1a\u53d6\u6d88\u3001\u786e\u8ba4\uff09", (String)"MultiorgsupdemPlugin_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[0]);
        this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private void initJsonData(OrgNode[] orgNode) {
        CustomControl control = (CustomControl)this.getView().getControl("customcontrolap");
        if (control == null) {
            return;
        }
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("action", "init");
        paramsMap.put("time", TimeServiceHelper.now().toString());
        paramsMap.put("returnData", orgNode);
        paramsMap.put("isEnglish", false);
        paramsMap.put("isConserve", this.isxy);
        if ("en-US".equals(Lang.get().getLangTag())) {
            paramsMap.put("isEnglish", true);
        }
        paramsMap.put("hasSearch", true);
        if (!this.getSatus().booleanValue()) {
            paramsMap.put("isSubmit", true);
        } else {
            paramsMap.put("isSubmit", false);
        }
        control.setData(paramsMap);
    }

    private OrgNode[] changeTpoArray(Map<String, OrgNode> orgDemandNodeMap, Map<String, OrgNode> orgSupplyNodeMap) {
        OrgNode[] orgNodes = new OrgNode[orgDemandNodeMap.size() + orgSupplyNodeMap.size()];
        int i = 0;
        for (Map.Entry<String, OrgNode> mapEntry : orgDemandNodeMap.entrySet()) {
            orgNodes[i] = mapEntry.getValue();
            ++i;
        }
        for (Map.Entry<String, OrgNode> mapEntry : orgSupplyNodeMap.entrySet()) {
            orgNodes[i] = mapEntry.getValue();
            ++i;
        }
        return orgNodes;
    }

    private Map<String, OrgNode> initOrgNode(Map<String, Set<String>> nodePointMap, Map<String, String> idAndName, String sign, List<Map<String, Object>> cast) {
        HashMap<String, OrgNode> orgNodeMap = new HashMap<String, OrgNode>(8);
        for (Map.Entry<String, Set<String>> entry : nodePointMap.entrySet()) {
            String orgId = entry.getKey();
            Set<String> value = entry.getValue();
            OrgNode orgNode = new OrgNode(sign);
            orgNode.setId(String.valueOf(orgId));
            orgNode.setName(idAndName.get(orgId));
            String[] pointId = value.toArray(new String[value.size()]);
            if (SUPPLY.equals(sign)) {
                orgNode.setPointId(pointId);
            } else {
                orgNode.setBeDirectedId(pointId);
            }
            orgNodeMap.put(orgId, orgNode);
        }
        if (cast != null) {
            for (Map map : cast) {
                OrgNode orgNode;
                Object object = map.get(ID);
                if (object == null || object.toString().isEmpty() || (orgNode = (OrgNode)orgNodeMap.get(object.toString())) == null) continue;
                this.isxy = true;
                Map map1 = (Map)map.get("position");
                if (map1.get("x") instanceof Double) {
                    double x = (Double)map1.get("x");
                    orgNode.setX((int)x);
                } else if (map1.get("x") instanceof Integer) {
                    orgNode.setX(((Integer)map1.get("x")).intValue());
                }
                if (map1.get("y") instanceof Double) {
                    double y = (Double)map1.get("y");
                    orgNode.setY((int)y);
                    continue;
                }
                if (!(map1.get("y") instanceof Integer)) continue;
                orgNode.setY(((Integer)map1.get("y")).intValue());
            }
        }
        return orgNodeMap;
    }

    private Map<String, Set<String>> initOrgNodePointId(Map<String, Set<String>> map) {
        HashMap<String, Set<String>> nodePoint = new HashMap<String, Set<String>>(8);
        for (Map.Entry<String, Set<String>> mapEntry : map.entrySet()) {
            String orgId = mapEntry.getKey();
            Set<String> value = mapEntry.getValue();
            for (String id : value) {
                HashSet<String> list;
                if (nodePoint.containsKey(id)) {
                    list = (HashSet<String>)nodePoint.get(id);
                    list.add(orgId);
                    continue;
                }
                list = new HashSet<String>(8);
                list.add(orgId);
                nodePoint.put(id, list);
            }
        }
        return nodePoint;
    }

    private void deleteNode() {
        String eventArgs = this.getPageCache().get(EVENTARGS);
        try {
            if (eventArgs == null || eventArgs.isEmpty()) {
                return;
            }
            Map cast = (Map)JSONUtils.cast((String)eventArgs, Map.class);
            HashSet<Long> nodeIdList = new HashSet<Long>(16);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (DEMAND.equals(cast.get(TYPE))) {
                nodeIdList.add(Long.parseLong((String)cast.get(ID)));
                Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)NODEDETAILS, (String)"id,demandorg", (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkValue.toString()).and(DEMANDORG, "in", nodeIdList).and(ENABLE, "=", (Object)"1")});
                String number = objectDynamicObjectMap.values().toArray(new DynamicObject[objectDynamicObjectMap.size()])[0].getDynamicObject(DEMANDORG).getString(NUMBER);
                if (!this.isNeedDel((Long)pkValue, Long.parseLong((String)cast.get(ID)))) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s:\u7ec4\u7ec7\u5df2\u88ab\u201c\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u201d\u591a\u7ec4\u7ec7\u4f9b\u9700\u5173\u7cfb\u201c\u5b57\u6bb5\u5f15\u7528\u3002\n", (String)"MultiorgsupdemPlugin_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), number));
                    return;
                }
                Set<Long> longs = this.changeToSet(objectDynamicObjectMap.keySet());
                this.copyDny(longs);
                DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])longs.toArray());
            } else {
                ArrayList<String> tipMessage;
                List<Object> beDirectedIdCodesLong = new ArrayList(8);
                if (cast.get(BEDIRECTEDID) != null) {
                    List beDirectedId = (List)cast.get(BEDIRECTEDID);
                    beDirectedIdCodesLong = beDirectedId.stream().map(Long::parseLong).collect(Collectors.toList());
                }
                List<Object> pointIdCodesLong = new ArrayList(8);
                if (cast.get(POINTID) != null) {
                    List pointId = (List)cast.get(POINTID);
                    pointIdCodesLong = pointId.stream().map(Long::parseLong).collect(Collectors.toList());
                }
                if (beDirectedIdCodesLong.size() != 0) {
                    Map objectDynamicObjectMap_d = BusinessDataServiceHelper.loadFromCache((String)NODEDETAILS, (String)"id,demandorg", (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkValue.toString()).and(DEMANDORG, "=", (Object)Long.parseLong((String)cast.get(ID))).and(ENABLE, "=", (Object)"1")});
                    ArrayList<String> tipMessage2 = new ArrayList<String>(8);
                    HashMap<Long, Object> loads = new HashMap<Long, Object>(8);
                    for (Map.Entry entry : objectDynamicObjectMap_d.entrySet()) {
                        loads.put((Long)entry.getKey(), entry.getValue());
                    }
                    boolean status = this.checkmOrg(loads, tipMessage2, DEMANDORG);
                    if (!status) {
                        for (String s : tipMessage2) {
                            this.getView().showTipNotification(s);
                        }
                        return;
                    }
                    DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])objectDynamicObjectMap_d.keySet().toArray());
                    nodeIdList.add((Long)objectDynamicObjectMap_d.keySet().toArray()[0]);
                }
                Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)NODEDETAILS, (String)"id,defaultsupply,defaultsupply.defaultsupplyorg", (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkValue.toString()).and(DEMANDORG, "in", pointIdCodesLong).and(ENABLE, "=", (Object)"1").and("defaultsupply.defaultsupplyorg.id", "=", (Object)Long.parseLong((String)cast.get(ID)))});
                HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(8);
                ArrayList<Long> allNeedDele = new ArrayList<Long>(8);
                for (Map.Entry entry : objectDynamicObjectMap.entrySet()) {
                    Object entryPrimaryKeyValue;
                    DynamicObject value = (DynamicObject)entry.getValue();
                    Long primaryKeyValue = (Long)entry.getKey();
                    ArrayList longs = (ArrayList)map.get(primaryKeyValue);
                    if (longs == null) {
                        longs = new ArrayList(8);
                    }
                    if ((entryPrimaryKeyValue = value.get(DEFAULTSUPPLY)) != null) {
                        for (DynamicObject dynamicObject : (DynamicObjectCollection)entryPrimaryKeyValue) {
                            if (!cast.get(ID).toString().equals(dynamicObject.getDynamicObject("defaultsupplyorg").getString(ID))) continue;
                            allNeedDele.add(dynamicObject.getLong(ID));
                            longs.add(dynamicObject.getLong(ID));
                        }
                    }
                    map.put(primaryKeyValue, longs);
                    nodeIdList.add(primaryKeyValue);
                }
                DynamicObject[] load = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(), (DynamicObjectType)this.getNodeDnyType());
                Map<Long, Object> map2 = this.checkSelect(BILLLISTAP, map, load);
                boolean status = this.checkmOrg(map2, tipMessage = new ArrayList<String>(8), DEMANDORG);
                if (!status) {
                    for (String s : tipMessage) {
                        this.getView().showTipNotification(s);
                    }
                    return;
                }
                this.copyDny(nodeIdList);
                logger.info((Object)("deleteNode:" + map2.toString() + "allNeedDele:" + ((Object)allNeedDele).toString()));
                StringBuilder sql = new StringBuilder("delete from t_mrp_defaultsupply where FEntryID in (");
                for (Long s : allNeedDele) {
                    sql.append(s).append(",");
                }
                if (allNeedDele.size() != 0) {
                    sql.replace(sql.length() - 1, sql.length(), ")");
                    DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sql.toString());
                }
                DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])map2.keySet().toArray());
                this.getPageCache().remove(EVENTARGS);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.toString());
            throw new KDBizException(ex.getMessage());
        }
    }

    private boolean checkmOrg(Map<Long, Object> loads, List<String> tipMessage, String sign) {
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        boolean status = true;
        Collection<Object> load = loads.values();
        for (Object object : load) {
            long aLong = ((DynamicObject)object).getDynamicObject(sign).getLong(ID);
            if (this.isNeedDel((Long)pkValue, aLong)) continue;
            String number = ((DynamicObject)object).getDynamicObject(sign).getString(NUMBER);
            tipMessage.add(String.format(ResManager.loadKDString((String)"%s:\u7ec4\u7ec7\u5df2\u88ab\u201c\u8ba1\u5212\u65b9\u6848\u5b9a\u4e49\u201d\u591a\u7ec4\u7ec7\u4f9b\u9700\u5173\u7cfb\u201c\u5b57\u6bb5\u5f15\u7528\u3002\n", (String)"MultiorgsupdemPlugin_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), number));
            status = false;
        }
        return status;
    }

    private boolean isNeedDel(Long pkValue, Long orgId) {
        Map<Long, List<Long>> getplangram = this.getplangram();
        List<Long> list = getplangram.get(pkValue);
        if (list != null) {
            if (list.size() == 0) {
                return true;
            }
            if (list.contains(orgId)) {
                return false;
            }
        }
        return true;
    }

    private Set<Long> changeToSet(Set<Object> objects) {
        HashSet<Long> set = new HashSet<Long>(objects.size());
        for (Object object : objects) {
            set.add((Long)object);
        }
        return set;
    }

    private Map<String, Set<String>> getSupplyAndDemandOrg(Map<String, String> idAndName) {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(8);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        DynamicObjectCollection query = QueryServiceHelper.query((String)NODEDETAILS, (String)"id,demandorg,demandorg.id,demandorg.name,defaultsupply.defaultsupplyorg.id,defaultsupply.defaultsupplyorg.name,nodenumber", (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkValue.toString()).and(ENABLE, "=", (Object)"1")});
        for (DynamicObject dynamicObject : query) {
            HashSet<String> list;
            String demandorgid = dynamicObject.getString("demandorg.id");
            String demandorgName = dynamicObject.getString("demandorg.name");
            String defaultsupplyorgId = dynamicObject.getString("defaultsupply.defaultsupplyorg.id");
            String defaultsupplyorgName = dynamicObject.getString("defaultsupply.defaultsupplyorg.name");
            if (demandorgid == null || demandorgid.isEmpty() || "0".equals(demandorgid)) continue;
            idAndName.put(demandorgid, demandorgName);
            idAndName.put(defaultsupplyorgId, defaultsupplyorgName);
            if (map.containsKey(demandorgid)) {
                list = (HashSet<String>)map.get(demandorgid);
                list.add(defaultsupplyorgId);
                continue;
            }
            list = new HashSet<String>(8);
            if (defaultsupplyorgId != null && !defaultsupplyorgId.isEmpty()) {
                list.add(defaultsupplyorgId);
            }
            map.put(demandorgid, list);
        }
        return map;
    }

    private void deleteChangeDataAndSaveOldData() {
        try {
            List alreadycopy;
            List copyid;
            String dny = this.getPageCache().get(NODEMESSAGE);
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)dny);
            logger.info((Object)("nodeMessage:" + map.toString()));
            List add = (List)map.get(ADD);
            if (add != null && add.size() != 0) {
                DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)add)});
            }
            if ((copyid = (List)map.get(COPYID)) != null && copyid.size() != 0) {
                DynamicObject[] load;
                for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((Object[])copyid.toArray(), (DynamicObjectType)this.getNodeDnyType())) {
                    dynamicObject.set(ENABLE, (Object)1);
                }
                SaveServiceHelper.update((DynamicObject[])load);
            }
            if ((alreadycopy = (List)map.get(ALREADYCOPY)) != null && alreadycopy.size() != 0) {
                DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(ID, "in", (Object)alreadycopy)});
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.toString());
            throw new KDBizException(ex.getMessage());
        }
    }

    public DynamicObjectType getNodeDnyType() {
        return ORM.create().newDynamicObject(NODEDETAILS).getDynamicObjectType();
    }

    private void setBillListFilter(String sign) {
        ArrayList<QFilter> qFlist = new ArrayList<QFilter>(8);
        BillList billList = (BillList)this.getControl(sign);
        qFlist.add(new QFilter(PARENTDNYID, "=", (Object)this.getDnyId()).and(ENABLE, "=", (Object)"1"));
        if (BILLLISTAPS.equals(sign)) {
            qFlist.add(new QFilter(STOCKDEMANDORG, "!=", (Object)0));
        } else {
            qFlist.add(new QFilter(DEMANDORG, "!=", (Object)0));
        }
        billList.setDataPermQFilters(qFlist);
        billList.setClearSelection(true);
        billList.refresh();
    }

    private void checkClose() {
        String returnData = this.getPageCache().get(NODEMESSAGE);
        if (returnData == null) {
            if (!this.getIsMove()) {
                this.getView().close();
            }
        } else {
            Map map = (Map)SerializationUtils.deSerializeFromBase64((String)returnData);
            if (map.get(DATACHANGE) == null) {
                List copyid = (List)map.get(COPYID);
                if (copyid != null && copyid.size() != 0) {
                    DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])copyid.toArray());
                }
                this.getPageCache().remove(NODEMESSAGE);
                if (!this.getIsMove()) {
                    this.getView().close();
                }
            } else {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE, (IFormPlugin)this);
                String strs = String.format(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u4fdd\u5b58\u5f53\u524d\u8282\u70b9\uff0c\u76f4\u63a5\u9000\u51fa\u60a8\u7684\u4fee\u6539\u5c06\u4f1a\u88ab\u6e05\u9664\u3002", (String)"MultiorgsupdemPlugin_16", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
            }
        }
    }

    public boolean getIsMove() {
        String isMove = this.getPageCache().get(ISMOVE);
        if (isMove != null) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_ST, (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u60a8\u8fd8\u672a\u4fdd\u5b58\u5f53\u524d\u8282\u70b9\u89c6\u56fe\uff0c\u76f4\u63a5\u9000\u51fa\u60a8\u7684\u4fee\u6539\u5c06\u4f1a\u88ab\u6e05\u9664\u3002", (String)"MultiorgsupdemPlugin_28", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[0]);
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return false;
    }

    private void deleteSupplyData() {
        try {
            ArrayList<String> tipMessage;
            BillList billList = (BillList)this.getControl(BILLLISTAP);
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            HashSet<Long> nodeIdList = new HashSet<Long>(16);
            HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(8);
            Object[] ob = new Object[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                Object entryPrimaryKeyValue;
                if (selectedRows.get(i).getRowKey() < 0) continue;
                Long primaryKeyValue = (Long)selectedRows.get(i).getPrimaryKeyValue();
                ArrayList<Long> longs = (ArrayList<Long>)map.get(primaryKeyValue);
                if (longs == null) {
                    longs = new ArrayList<Long>(8);
                }
                if ((entryPrimaryKeyValue = selectedRows.get(i).getEntryPrimaryKeyValue()) != null && (Long)entryPrimaryKeyValue != 0L) {
                    longs.add((Long)entryPrimaryKeyValue);
                }
                map.put(primaryKeyValue, longs);
                ob[i] = selectedRows.get(i).getEntryPrimaryKeyValue();
                nodeIdList.add(primaryKeyValue);
            }
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(), (DynamicObjectType)this.getNodeDnyType());
            Map<Long, Object> longObjectMap = this.checkSelect(BILLLISTAP, map, load);
            boolean status = this.checkmOrg(longObjectMap, tipMessage = new ArrayList<String>(8), DEMANDORG);
            if (!status) {
                for (String s : tipMessage) {
                    this.getView().showTipNotification(s);
                }
                return;
            }
            this.copyDny(nodeIdList);
            DynamicObject dynamicObject = ORM.create().newDynamicObject("mrp_nodedetails.defaultsupply");
            logger.info((Object)("deleteSupplyData:" + Arrays.toString(ob) + ":" + longObjectMap.toString()));
            DeleteServiceHelper.delete((IDataEntityType)dynamicObject.getDataEntityType(), (Object[])ob);
            DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])longObjectMap.keySet().toArray());
            billList.refresh();
        }
        catch (Exception ex) {
            logger.error((Object)ex.toString());
            throw new KDBizException(ex.getMessage());
        }
    }

    public Map<Long, List<Long>> getplangram() {
        DynamicObject[] query;
        HashMap<Long, List<Long>> listMap = new HashMap<Long, List<Long>>(8);
        for (DynamicObject dynamicObject : query = BusinessDataServiceHelper.load((String)"mrp_planprogram", (String)"number,mul,orgrangid_tag", (QFilter[])new QFilter[]{new QFilter("mul", "!=", (Object)0L)})) {
            String orgrangid_tag;
            long mul = dynamicObject.getLong("mul_id");
            String number = dynamicObject.getString(NUMBER);
            List list = (ArrayList)listMap.get(mul);
            if (list == null) {
                list = new ArrayList(8);
            }
            if ((orgrangid_tag = dynamicObject.getString("orgrangid_tag")) != null && !orgrangid_tag.isEmpty()) {
                list = (List)SerializationUtils.deSerializeFromBase64((String)orgrangid_tag);
            }
            listMap.put(mul, list);
        }
        return listMap;
    }

    private void deleteStockData() {
        try {
            Map<Long, Object> longObjectMap;
            Throwable throwable;
            TXHandle h;
            DynamicObject dynamicObject_ma;
            DynamicObject dynamicObject_show;
            DynamicObject dynamicObject_stock;
            DynamicObject dynamicObject_org;
            Object[] ob_stock;
            Object[] ob_org;
            HashMap<Long, List<Long>> map;
            HashSet<Long> nodeIdList;
            Object[] ob;
            BillList billList;
            block26: {
                block27: {
                    block28: {
                        int i;
                        billList = (BillList)this.getControl(BILLLISTAPS);
                        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                        ob = new Object[selectedRows.size()];
                        nodeIdList = new HashSet<Long>(16);
                        HashSet<Long> showIdList = new HashSet<Long>(16);
                        ArrayList<Long> orgSetIdList = new ArrayList<Long>(16);
                        ArrayList<Long> stockSetIdList = new ArrayList<Long>(16);
                        map = new HashMap<Long, List<Long>>(8);
                        for (int i2 = 0; i2 < selectedRows.size(); ++i2) {
                            Object entryPrimaryKeyValue;
                            if (selectedRows.get(i2).getRowKey() < 0) continue;
                            Long primaryKeyValue = (Long)selectedRows.get(i2).getPrimaryKeyValue();
                            Long primaryEntryKeyValue = (Long)selectedRows.get(i2).getEntryPrimaryKeyValue();
                            ArrayList<Long> longs = (ArrayList<Long>)map.get(primaryKeyValue);
                            if (longs == null) {
                                longs = new ArrayList<Long>(8);
                            }
                            if ((entryPrimaryKeyValue = selectedRows.get(i2).getEntryPrimaryKeyValue()) != null && (Long)entryPrimaryKeyValue != 0L) {
                                longs.add((Long)entryPrimaryKeyValue);
                            }
                            map.put(primaryKeyValue, longs);
                            ob[i2] = selectedRows.get(i2).getEntryPrimaryKeyValue();
                            nodeIdList.add(primaryKeyValue);
                            showIdList.add(primaryEntryKeyValue);
                        }
                        this.querySaveEntity(showIdList, orgSetIdList, stockSetIdList, nodeIdList);
                        ob_org = new Object[orgSetIdList.size()];
                        ob_stock = new Object[stockSetIdList.size()];
                        for (i = 0; i < orgSetIdList.size(); ++i) {
                            ob_org[i] = orgSetIdList.get(i);
                        }
                        for (i = 0; i < stockSetIdList.size(); ++i) {
                            ob_stock[i] = stockSetIdList.get(i);
                        }
                        dynamicObject_org = ORM.create().newDynamicObject("mrp_nodedetails.stocksorgentrentryentity");
                        dynamicObject_stock = ORM.create().newDynamicObject("mrp_nodedetails.stocksetupentryentity");
                        dynamicObject_show = ORM.create().newDynamicObject("mrp_nodedetails.showentity");
                        dynamicObject_ma = ORM.create().newDynamicObject("mrp_nodedetails.materialsetup");
                        h = TX.requiresNew();
                        throwable = null;
                        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])map.keySet().toArray(), (DynamicObjectType)this.getNodeDnyType());
                        longObjectMap = this.checkSelect(BILLLISTAPS, map, load);
                        ArrayList<String> tipMessage = new ArrayList<String>(8);
                        boolean status = this.checkmOrg(longObjectMap, tipMessage, STOCKDEMANDORG);
                        if (status) break block26;
                        for (String s : tipMessage) {
                            this.getView().showTipNotification(s);
                        }
                        if (h == null) break block27;
                        if (throwable == null) break block28;
                        try {
                            h.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block27;
                    }
                    h.close();
                }
                return;
            }
            try {
                try {
                    this.copyDny(nodeIdList);
                    logger.info((Object)("deleteStockData:" + longObjectMap.toString() + "ob:" + Arrays.toString(ob) + "ob_stock:" + Arrays.toString(ob_stock) + "ob_org:" + Arrays.toString(ob_org)));
                    DeleteServiceHelper.delete((IDataEntityType)this.getNodeDnyType(), (Object[])longObjectMap.keySet().toArray());
                    DeleteServiceHelper.delete((IDataEntityType)dynamicObject_show.getDataEntityType(), (Object[])ob);
                    DeleteServiceHelper.delete((IDataEntityType)dynamicObject_stock.getDataEntityType(), (Object[])ob_stock);
                    DeleteServiceHelper.delete((IDataEntityType)dynamicObject_org.getDataEntityType(), (Object[])ob_org);
                    List list = (List)map.get(-1L);
                    if (list != null && list.size() != 0) {
                        DeleteServiceHelper.delete((IDataEntityType)dynamicObject_ma.getDataEntityType(), (Object[])list.toArray());
                    }
                    billList.refresh();
                }
                catch (Exception ex) {
                    h.markRollback();
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                throw throwable4;
            }
            finally {
                if (h != null) {
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        h.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)" MultiorgsupdemPlugin-delete ", (Throwable)ex);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565\u5220\u9664\u5931\u8d25:%s", (String)"MultiorgsupdemPlugin_17", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ex));
        }
    }

    private void copyDny(Set<Long> nodeList) {
        String returnId = this.getPageCache().get(NODEMESSAGE);
        Map pkIdMap = returnId == null ? new HashMap() : (Map)SerializationUtils.deSerializeFromBase64((String)returnId);
        this.saveOldDate(nodeList, pkIdMap);
        this.getPageCache().put(NODEMESSAGE, SerializationUtils.serializeToBase64(pkIdMap));
    }

    private void billLisrRef() {
        BillList billList = (BillList)this.getControl(BILLLISTAP);
        BillList billLists = (BillList)this.getControl(BILLLISTAPS);
        billLists.clearSelection();
        billList.clearSelection();
        billLists.refresh();
        billList.refresh();
    }

    private void saveOldDate(Set<Long> nodeList, Map<String, List<Long>> pkIdMap) {
        List<Long> alreadycopy;
        List<Long> add = pkIdMap.get(ADD);
        if (add == null) {
            add = new ArrayList<Long>(8);
        }
        if (nodeList.size() == 0) {
            return;
        }
        List<Long> copyid = pkIdMap.get(COPYID);
        if (copyid == null) {
            copyid = new ArrayList<Long>(8);
        }
        if ((alreadycopy = pkIdMap.get(ALREADYCOPY)) == null) {
            alreadycopy = new ArrayList<Long>(8);
        }
        Object[] objects = nodeList.toArray(new Object[nodeList.size()]);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)this.getNodeDnyType());
        CloneUtils cloneUtils = new CloneUtils(false, true);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(8);
        for (DynamicObject object : load) {
            DynamicObject dynamicObject = object;
            Long pkValue = (Long)dynamicObject.getPkValue();
            if (add.contains(pkValue) || alreadycopy.contains(pkValue)) continue;
            DynamicObject newDyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)dynamicObject);
            newDyn.set(ENABLE, (Object)0);
            list.add(newDyn);
            alreadycopy.add(pkValue);
        }
        if (list.size() != 0) {
            Object[] save;
            for (Object o : save = SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]))) {
                copyid.add(((DynamicObject)o).getLong(ID));
            }
        }
        for (Long s : nodeList) {
            if (add.contains(s)) continue;
            alreadycopy.add(s);
        }
        pkIdMap.put(DATACHANGE, add);
        pkIdMap.put(ADD, add);
        pkIdMap.put(COPYID, copyid);
        pkIdMap.put(ALREADYCOPY, alreadycopy);
    }

    private void querySaveEntity(Set<Long> showIdList, List<Long> orgSetidList, List<Long> stockSetIdList, Set<Long> nodeIdList) {
        HashMap<String, Integer> stringIntegerMap;
        Serializable stringIntegerMap2;
        DynamicObjectCollection query = QueryServiceHelper.query((String)NODEDETAILS, (String)"id,showentity.id,showentity.storageorg1.number,showentity.orgsetid,showentity.stocksetupentryentityid", (QFilter[])new QFilter[]{new QFilter("showentity.id", "in", showIdList)});
        HashMap map = new HashMap(8);
        HashMap map_select = new HashMap(8);
        Object[] objects = nodeIdList.toArray(new Object[nodeIdList.size()]);
        DynamicObject[] load = BusinessDataServiceHelper.load((Object[])objects, (DynamicObjectType)this.getNodeDnyType());
        for (DynamicObject dynamicObject : load) {
            Long id = dynamicObject.getLong(ID);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(SHOWENTITY);
            stringIntegerMap2 = (HashMap)map.get(id);
            if (stringIntegerMap2 == null) {
                stringIntegerMap2 = new HashMap(8);
            }
            for (DynamicObject dynamicObject1 : dynamicObjectCollection) {
                String storageorg1 = dynamicObject1.getString("storageorg1.number");
                Integer num = (Integer)stringIntegerMap2.get(storageorg1);
                if (num == null) {
                    num = 1;
                } else {
                    Integer n = num;
                    Integer n2 = num = Integer.valueOf(num + 1);
                }
                stringIntegerMap2.put(storageorg1, num);
            }
            map.put(id, stringIntegerMap2);
        }
        for (DynamicObject dynamicObject : query) {
            String storageorg1;
            Integer num;
            Long id = dynamicObject.getLong(ID);
            stringIntegerMap = (HashMap<String, Integer>)map_select.get(id);
            if (stringIntegerMap == null) {
                stringIntegerMap = new HashMap<String, Integer>(8);
            }
            if ((num = (Integer)stringIntegerMap.get(storageorg1 = dynamicObject.getString("showentity.storageorg1.number"))) == null) {
                num = 1;
            } else {
                stringIntegerMap2 = num;
                num = num + 1;
                Integer n = num;
            }
            stringIntegerMap.put(storageorg1, num);
            map_select.put(id, stringIntegerMap);
        }
        for (DynamicObject dynamicObject : query) {
            Long aLong;
            Long id = dynamicObject.getLong(ID);
            stringIntegerMap = (Map)map.get(id);
            Map stringIntegerMap_s = (Map)map_select.get(id);
            String storageorg1 = dynamicObject.getString("showentity.storageorg1.number");
            if (((Integer)stringIntegerMap.get(storageorg1)).compareTo((Integer)stringIntegerMap_s.get(storageorg1)) == 0) {
                orgSetidList.add(dynamicObject.getLong("showentity.orgsetid"));
            }
            if ((aLong = Long.valueOf(dynamicObject.getLong("showentity.stocksetupentryentityid"))) == null || aLong == 0L) continue;
            stockSetIdList.add(dynamicObject.getLong("showentity.stocksetupentryentityid"));
        }
    }

    public void pageRelease(EventObject e) {
        Object source = e.getSource();
        Object pkId = null;
        if (source instanceof BaseView) {
            BaseView source1 = (BaseView)source;
            BaseShowParameter formShowParameter = (BaseShowParameter)source1.getFormShowParameter();
            pkId = formShowParameter.getPkId();
        } else if (source instanceof BillView) {
            BillShowParameter formShowParameter = (BillShowParameter)((BillView)e.getSource()).getFormShowParameter();
            pkId = formShowParameter.getPkId();
        }
        if (pkId != null) {
            int deleteNum = DeleteServiceHelper.delete((String)NODEDETAILS, (QFilter[])new QFilter[]{new QFilter(PARENTDNYID, "=", (Object)pkId.toString()).and(ENABLE, "=", (Object)"0")});
            logger.info((Object)("deleteDisableRows:" + deleteNum));
        }
    }

    private void openNodeDetailPage(Object id, String sign) {
        BaseShowParameter formShowParameter = null;
        String nodeMessage = this.getPageCache().get(NODEMESSAGE);
        if (nodeMessage == null) {
            nodeMessage = this.getPkIdMap();
        }
        if (id == null) {
            formShowParameter = new BaseShowParameter();
            formShowParameter.setFormId(NODEDETAILS);
            formShowParameter.setCustomParam(NODEMESSAGE, (Object)nodeMessage);
            String add = this.getPageCache().get(ADD);
            if (add == null) {
                formShowParameter.setCustomParam(ADD, (Object)"1");
            }
            if (SUPPLYORG.equals(sign)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc", (String)"MultiorgsupdemPlugin_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if (STOCKSUPPLY.equals(sign)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565", (String)"MultiorgsupdemPlugin_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if (ALL.equals(sign)) {
                formShowParameter.setFormId(NODEDETAILS_LAYOUT);
                String orgId = this.getPageCache().get(ORGID);
                if (orgId != null) {
                    formShowParameter.setCustomParam(ORGID, (Object)orgId);
                    this.getPageCache().remove(ORGID);
                }
            }
        } else {
            formShowParameter = new BaseShowParameter();
            formShowParameter.setFormId(NODEDETAILS);
            if (ALL.equals(sign)) {
                formShowParameter.setFormId(NODEDETAILS_LAYOUT);
                String orgId = this.getPageCache().get(ORGID);
                if (orgId != null) {
                    formShowParameter.setCustomParam(ORGID, (Object)orgId);
                    this.getPageCache().remove(ORGID);
                }
            }
            String field = "demandorg.id";
            ((BillShowParameter)formShowParameter).setPkId(id);
            formShowParameter.setStatus(OperationStatus.EDIT);
            formShowParameter.setCustomParam(NODEMESSAGE, (Object)nodeMessage);
            if (SUPPLYORG.equals(sign)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u4f9b\u5e94\u7f51\u7edc", (String)"MultiorgsupdemPlugin_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if (STOCKSUPPLY.equals(sign)) {
                formShowParameter.setCaption(ResManager.loadKDString((String)"\u5e93\u5b58\u4f9b\u5e94\u7b56\u7565", (String)"MultiorgsupdemPlugin_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                field = "stockdemandorg.id";
            }
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)NODEDETAILS, (String)field, (QFilter[])new QFilter[]{new QFilter(ID, "=", id)});
            if (!this.isNeedDel(Long.parseLong(this.getDnyId()), dynamicObject.getLong(field))) {
                formShowParameter.setCustomParam("iseditorg", (Object)sign);
            }
        }
        formShowParameter.setCustomParam(SIGN, (Object)sign);
        formShowParameter.setCustomParam("status", (Object)this.getSatus());
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam(DNY, (Object)this.getDnyId());
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, NEW));
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private String getPkIdMap() {
        HashMap pkIdMap = new HashMap();
        return SerializationUtils.serializeToBase64(pkIdMap);
    }

    public String getDnyId() {
        return this.getModel().getDataEntity().getString(ID);
    }

    public Boolean getSatus() {
        if (OperationStatus.VIEW.name().equals(this.getView().getFormShowParameter().getStatus().name())) {
            return false;
        }
        if (!"A".equals(this.getModel().getValue("status"))) {
            return false;
        }
        return true;
    }

    private void initListBox() {
        Listbox listboxap = (Listbox)this.getControl(LISTBOXAP);
        ArrayList<ListboxItem> items = new ArrayList<ListboxItem>(8);
        ListboxItem listboxItem = new ListboxItem(FROMID, ResManager.loadKDString((String)"\u8868\u683c\u89c6\u56fe", (String)"MultiorgsupdemPlugin_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem1 = new ListboxItem(RELATIONID, ResManager.loadKDString((String)"\u5173\u7cfb\u89c6\u56fe", (String)"MultiorgsupdemPlugin_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        items.add(listboxItem);
        items.add(listboxItem1);
        listboxap.addItems(items);
    }
}

