/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PlanCalendarEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(PlanCalendarEdit.class);
    private static final int DEFAULT_YEAR_COUNT = 11;

    public void initialize() {
        this.initProperty();
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getParentView() == null || this.getView().getParentView().getFormShowParameter() == null) {
            return;
        }
        RequestContext requestContext = RequestContext.get();
        int flag = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)RequestContext.get().getOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)this.getView().getFormShowParameter().getFormId(), (String)"47156aff000000ac");
        if (flag == 0) {
            this.getModel().setValue("createorg", null);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7:[%s]\u7684\u65b0\u589e\u6743\u9650", (String)"PlanCalendarEdit_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue("createorg")).get("name")));
            this.getPageCache().put("create", "111");
        } else if (this.getView().getParentView().getFormShowParameter().getCustomParams().get("createorgid") != null && this.getPageCache().get("create") == null) {
            this.getModel().setValue("createorg", this.getView().getParentView().getFormShowParameter().getCustomParams().get("createorgid"));
            this.getPageCache().put("create", "111");
        }
        Calendar cal = Calendar.getInstance();
        this.getModel().setValue("expiringyearfrom", (Object)cal.get(1));
        this.getModel().setValue("expiringmonthfrom", (Object)(cal.get(2) + 1));
        this.getModel().setValue("expiringyearto", (Object)(cal.get(1) + 2));
    }

    private void initProperty() {
        Calendar cal = Calendar.getInstance();
        int currentYear = cal.get(1);
        this.genYearComboItems("expiringyearfrom", currentYear - 3);
        this.genYearComboItems("expiringyearto", currentYear);
    }

    private void genYearComboItems(String propertyName, int currentYear) {
        ComboEdit propertyField = (ComboEdit)this.getControl(propertyName);
        ArrayList<ComboItem> propertyItems = new ArrayList<ComboItem>(11);
        for (int i = 0; i < 11; ++i) {
            String year = String.valueOf(currentYear + i);
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(new LocaleString(year));
            comboItem.setValue(year);
            propertyItems.add(comboItem);
        }
        propertyField.setComboItems(propertyItems);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (!(source instanceof AbstractOperate)) {
            return;
        }
        AbstractOperate op = (AbstractOperate)source;
        if ("save".equalsIgnoreCase(op.getOperateKey())) {
            if (this.validate()) {
                log.debug("\u5f00\u59cb\u4fdd\u5b58\u6570\u636e");
                if (this.getModel().getDataEntity().getPkValue().equals(0L)) {
                    this.generateDate();
                } else {
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("issave");
                    if (this.getPageCache().get("is") == null && this.getPageCache().get("ischange") != null) {
                        this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u201c\u56fa\u5b9a\u4f11\u606f\u65e5\u201d\u3001\u201c\u534a\u5de5\u4f5c\u65e5\u201d\u6216\u201c\u6709\u6548\u671f\u95f4\u201d\u7684\u6570\u636e\u5c06\u6e05\u7a7a\u624b\u52a8\u6807\u8bb0\u7684\u65e5\u671f\uff0c\u662f\u5426\u4fdd\u5b58\uff1f", (String)"PlanCalendarEdit_4", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                        args.cancel = true;
                    }
                }
            } else {
                args.cancel = true;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!"number".equals(propertyName) && !"name".equals(propertyName)) {
            this.getPageCache().put("ischange", "true");
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("issave".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.getPageCache().put("is", "0");
            this.generateDate();
            this.getView().invokeOperation("save");
            this.getPageCache().remove("is");
            this.getPageCache().remove("ischange");
        }
    }

    private void generateDate() {
        IDataModel model = this.getModel();
        DynamicObject obj = model.getDataEntity();
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        Calendar curDate = Calendar.getInstance();
        curDate.set(yearFrom, 0, 0, 0, 0, 0);
        Calendar fromDate = Calendar.getInstance();
        fromDate.set(yearFrom, monthFrom - 1, 1, 0, 0, 0);
        if (curDate.after(fromDate)) {
            fromDate.setTime(curDate.getTime());
        }
        fromDate.clear(12);
        fromDate.clear(13);
        fromDate.clear(14);
        fromDate.clear(10);
        Calendar toDate = Calendar.getInstance();
        toDate.set(yearTo, monthTo - 1, 1, 0, 0, 0);
        toDate.set(yearTo, monthTo - 1, toDate.getActualMaximum(5), 0, 0, 0);
        boolean[] isRestDay = this.getRestDays(model);
        boolean[] isHalfWorkDay = this.getHalfWorkDays(model);
        int days = this.daysBetween(fromDate, toDate);
        model.deleteEntryData("dateEntry");
        AbstractFormDataModel modelData = (AbstractFormDataModel)this.getModel();
        modelData.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        for (int i = 0; i < days; ++i) {
            vs.set("workdate", (Object)fromDate.getTime(), i);
            if (isRestDay[fromDate.get(7) - 1]) {
                vs.set("datetype", (Object)"4", i);
            } else if (isHalfWorkDay[fromDate.get(7) - 1]) {
                vs.set("datetype", (Object)"2", i);
            } else {
                vs.set("datetype", (Object)"1", i);
            }
            fromDate.add(5, 1);
        }
        modelData.batchCreateNewEntryRow("dateEntry", vs);
        modelData.endInit();
        this.getView().updateView("dateEntry");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        BillList list = (BillList)this.getView().getParentView().getControl("billlistap");
        list.clearSelection();
        this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
    }

    private boolean validate() {
        if (!this.dateExclusionValidate()) {
            return false;
        }
        return this.expiringDateValidate();
    }

    private boolean expiringDateValidate() {
        DynamicObject obj = this.getDynamicObject();
        if (obj.get("expiringyearfrom") == null || obj.get("expiringmonthfrom") == null || obj.get("expiringyearto") == null || obj.get("expiringmonthto") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanCalendarEdit_5", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        int yearFrom = obj.getInt("expiringyearfrom");
        int monthFrom = obj.getInt("expiringmonthfrom");
        int yearTo = obj.getInt("expiringyearto");
        int monthTo = obj.getInt("expiringmonthto");
        if (yearTo < yearFrom || yearTo == yearFrom && monthTo < monthFrom) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanCalendarEdit_6", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject getDynamicObject() {
        IDataModel model = this.getModel();
        return model.getDataEntity();
    }

    private boolean dateExclusionValidate() {
        boolean[] isHalfWorkDay;
        boolean result = true;
        boolean[] isRestDay = this.getRestDays(this.getModel());
        if (isRestDay.length != (isHalfWorkDay = this.getHalfWorkDays(this.getModel())).length) {
            return result;
        }
        for (int i = 0; i < isRestDay.length; ++i) {
            if (!isRestDay[i] || !isHalfWorkDay[i]) continue;
            result = false;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u56fa\u5b9a\u4f11\u606f\u65e5\u548c\u534a\u5929\u5de5\u4f5c\u65e5\u4e0d\u80fd\u52fe\u9009\u540c\u4e00\u5929\u3002", (String)"PlanCalendarEdit_7", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            break;
        }
        return result;
    }

    private boolean[] getRestDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isRestDay = new boolean[]{obj.getBoolean("issunrest"), obj.getBoolean("ismonrest"), obj.getBoolean("istuerest"), obj.getBoolean("iswedrest"), obj.getBoolean("isthurest"), obj.getBoolean("isfrirest"), obj.getBoolean("issatrest")};
        return isRestDay;
    }

    private boolean[] getHalfWorkDays(IDataModel model) {
        DynamicObject obj = model.getDataEntity();
        boolean[] isHalfWorkDay = new boolean[]{obj.getBoolean("ishalfsunrest"), obj.getBoolean("ishalfmonrest"), obj.getBoolean("ishalftuerest"), obj.getBoolean("ishalfwedrest"), obj.getBoolean("ishalfthurest"), obj.getBoolean("ishalffrirest"), obj.getBoolean("ishalfsatrest")};
        return isHalfWorkDay;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit f7 = (BasedataEdit)this.getControl("createorg");
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        BasedataEdit basedataEdit = (BasedataEdit)e.getSource();
        String key = basedataEdit.getKey();
        if ("createorg".equals(key)) {
            QFilter filterTreetype = new QFilter("view.number", "=", (Object)"PlanSchemeDefault");
            QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
            QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
            freezeFilter = freezeFilter.or(freezeFilter1);
            DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"id, org.id org", (QFilter[])new QFilter[]{filterTreetype, freezeFilter}, (String)"level");
            HashSet<Object> set = new HashSet<Object>();
            for (DynamicObject obj : orgCol) {
                set.add(obj.get("org"));
            }
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", set));
        }
    }

    private int daysBetween(Calendar smallDate, Calendar bigDate) {
        long time1 = smallDate.getTimeInMillis();
        long time2 = bigDate.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days)) + 1;
    }
}

