/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.WorkCalendar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.AfterQueryOfExportEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeQueryOfExportEvent;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mpscmm.common.enums.PlanCalendarWeekEnum;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;

public class PlanCalendarerList
extends AbstractListPlugin
implements TreeNodeClickListener,
ListRowClickListener,
SelectRowsEventListener {
    private static final Log logger = LogFactory.getLog(PlanCalendarerList.class);
    private static final String ENTITY = "mrp_plancalendar";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static final List<String> attrList = new ArrayList<String>();
    private static final List<String> attrNameList = new ArrayList<String>();
    private static final ThreadLocal<List<DynamicObject>> threadLocalData = new ThreadLocal();

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qfliters = e.getQFilters();
        QFilter orgid = new QFilter("createorg", "in", this.setOrgFilter());
        qfliters.add(orgid);
    }

    private Set<Object> setOrgFilter() {
        RequestContext requestContext = RequestContext.get();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)requestContext.getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"47150e89000000ac");
        QFilter filterTreetype = new QFilter("view", "=", (Object)914427355726916608L);
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"id, org.id org", (QFilter[])new QFilter[]{filterTreetype, freezeFilter}, (String)"level");
        HashSet<Object> set = new HashSet<Object>();
        for (DynamicObject obj : orgCol) {
            if (!hasPermOrgResult.hasAllOrgPerm()) {
                if (!hasPermOrgResult.getHasPermOrgs().contains(obj.get("org"))) continue;
                set.add(obj.get("org"));
                continue;
            }
            set.add(obj.get("org"));
        }
        return set;
    }

    public void beforeQueryOfExport(BeforeQueryOfExportEvent e) {
        String selectfield = "expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto,number,name,issunrest,ismonrest,istuerest,iswedrest,isthurest,isfrirest,issatrest,createorg,dateentry.workdate,dateentry.datetype";
        e.setSelectFields(selectfield);
    }

    public void afterQueryOfExport(AfterQueryOfExportEvent e) {
        DynamicObject[] datas = e.getQueryValues();
        List<DynamicObject> list = threadLocalData.get();
        if (list == null) {
            list = new LinkedList<DynamicObject>();
            threadLocalData.set(list);
        }
        for (DynamicObject data : datas) {
            list.add(data);
        }
    }

    public void afterExportFile(ExportFileEvent e) {
        File file = e.getFile();
        List<DynamicObject> datas = threadLocalData.get();
        if (file != null && datas != null && !datas.isEmpty()) {
            try (SXSSFWorkbook newExcel = this.createExcelTemp();
                 FileOutputStream out = new FileOutputStream(file);){
                this.writeSheet(newExcel, datas);
                threadLocalData.remove();
                newExcel.write((OutputStream)out);
            }
            catch (Exception ex) {
                throw new KDBizException((Throwable)ex, new ErrorCode("PlanCalendarerList", ExceptionUtils.getExceptionStackTraceMessage((Exception)ex)), new Object[0]);
            }
        }
    }

    public void writeSheet(SXSSFWorkbook newExcel, List<DynamicObject> datas) {
        ArrayList overrideList = new ArrayList(datas.size());
        SXSSFSheet newSheet = newExcel.getSheetAt(0);
        for (DynamicObject data : datas) {
            ArrayList<String> overridedata = new ArrayList<String>(7);
            String number = data.getString("number");
            overridedata.add(number);
            String name = data.getLocaleString("name").getLocaleValue_zh_CN();
            overridedata.add(name);
            DynamicObject createorg = data.getDynamicObject("createorg");
            String orgnumber = createorg.getString("number");
            overridedata.add(orgnumber);
            HashMap weekFreeday = Maps.newHashMapWithExpectedSize((int)7);
            String orgname = createorg.getLocaleString("name").getLocaleValue_zh_CN();
            overridedata.add(orgname);
            StringBuilder datetype = new StringBuilder(ResManager.loadKDString((String)"\u4f11\u606f\u65e5=", (String)"PlanCalendarerList_49", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            boolean issun = data.getBoolean("issunrest");
            datetype = this.getDattype(issun, datetype, PlanCalendarWeekEnum.ISSUNREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISSUNREST.getName()), issun);
            boolean ismon = data.getBoolean("ismonrest");
            datetype = this.getDattype(ismon, datetype, PlanCalendarWeekEnum.ISMONREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISMONREST.getName()), ismon);
            boolean istue = data.getBoolean("istuerest");
            datetype = this.getDattype(istue, datetype, PlanCalendarWeekEnum.ISTUEREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISTUEREST.getName()), istue);
            boolean iswed = data.getBoolean("iswedrest");
            datetype = this.getDattype(iswed, datetype, PlanCalendarWeekEnum.ISWEDREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISWEDREST.getName()), iswed);
            boolean isthu = data.getBoolean("isthurest");
            datetype = this.getDattype(isthu, datetype, PlanCalendarWeekEnum.ISTHUREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISTHUREST.getName()), isthu);
            boolean isfri = data.getBoolean("isfrirest");
            datetype = this.getDattype(isfri, datetype, PlanCalendarWeekEnum.ISFRIREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISFRIREST.getName()), isfri);
            boolean issat = data.getBoolean("issatrest");
            datetype = this.getDattype(issat, datetype, PlanCalendarWeekEnum.ISSATREST.getValue());
            weekFreeday.put(Integer.valueOf(PlanCalendarWeekEnum.ISSATREST.getName()), issat);
            StringBuilder holiday = new StringBuilder(ResManager.loadKDString((String)"\u8282\u5047\u65e5=", (String)"PlanCalendarerList_50", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            StringBuilder freeday = new StringBuilder(ResManager.loadKDString((String)"\u4f11\u606f\u65e5=", (String)"PlanCalendarerList_49", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            DynamicObjectCollection dateentrys = data.getDynamicObjectCollection("dateentry");
            String startdate = "";
            String enddate = "";
            for (DynamicObject dateentry : dateentrys) {
                Date date = dateentry.getDate("workdate");
                String entrydatetype = dateentry.getString("datetype");
                String dateStr = sdf.format(date);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                int i = calendar.get(7);
                if ("3".equals(entrydatetype)) {
                    if (!holiday.toString().endsWith("=")) {
                        holiday.append(',');
                    }
                    holiday.append(dateStr);
                }
                if ("4".equals(entrydatetype) && weekFreeday.get(i) != null && !((Boolean)weekFreeday.get(i)).booleanValue()) {
                    if (!freeday.toString().endsWith("=")) {
                        freeday.append(',');
                    }
                    freeday.append(dateStr);
                }
                if (StringUtils.isBlank((CharSequence)startdate) || startdate.compareTo(dateStr) > 0) {
                    startdate = dateStr;
                }
                if (!StringUtils.isBlank((CharSequence)enddate) && enddate.compareTo(dateStr) >= 0) continue;
                enddate = dateStr;
            }
            StringBuilder datetypeStr = this.getDatetype(datetype, holiday);
            datetypeStr = this.getDatetype(datetypeStr, freeday);
            overridedata.add(datetypeStr.toString());
            overridedata.add(startdate);
            overridedata.add(enddate);
            overrideList.add(overridedata);
        }
        for (int i = 0; i < overrideList.size(); ++i) {
            int num = newSheet.getLastRowNum() + 1;
            Row newRow = newSheet.createRow(num);
            List sub_list = (List)overrideList.get(i);
            for (int j = 0; j < sub_list.size(); ++j) {
                String data = (String)sub_list.get(j);
                newRow.createCell(j).setCellValue(data);
                if (!data.contains("\r\n")) continue;
                CellStyle wrapTextstyle = newExcel.createCellStyle();
                wrapTextstyle.setWrapText(true);
                newRow.getCell(j).setCellStyle(wrapTextstyle);
            }
        }
    }

    public StringBuilder getDatetype(StringBuilder datetype, StringBuilder holiday) {
        StringBuilder result = new StringBuilder();
        if (!datetype.toString().endsWith("=")) {
            result.append((CharSequence)datetype);
        }
        if (StringUtils.isNotBlank((CharSequence)result.toString()) && !holiday.toString().endsWith("=")) {
            result.append("\r\n");
        }
        if (!holiday.toString().endsWith("=")) {
            result.append((CharSequence)holiday);
        }
        return result;
    }

    public StringBuilder getDattype(boolean isRestDay, StringBuilder datetype, String week) {
        if (isRestDay) {
            if (!datetype.toString().endsWith("=")) {
                datetype.append(',');
            }
            datetype.append(week);
        }
        return datetype;
    }

    public SXSSFWorkbook createExcelTemp() {
        SXSSFWorkbook newExcel = new SXSSFWorkbook();
        SXSSFSheet newExcelSheet = newExcel.createSheet();
        newExcelSheet.setColumnWidth(0, 10240);
        for (int i = 1; i < 7; ++i) {
            newExcelSheet.setColumnWidth(i, 5120);
        }
        SXSSFRow row1 = newExcelSheet.createRow(0);
        SXSSFRow row2 = newExcelSheet.createRow(1);
        SXSSFRow row3 = newExcelSheet.createRow(2);
        SXSSFRow row4 = newExcelSheet.createRow(3);
        row1.createCell(0).setCellValue(ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u5386 # mrp_plancalendar", (String)"PlanCalendarerList_51", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        row2.createCell(0).setCellValue(String.format(ResManager.loadKDString((String)"1\u3001\u8bf7\u5c06\u9f20\u6807\u79fb\u5230\u7070\u8272\u6807\u9898\u884c\u67e5\u770b\u5b57\u6bb5\u5f55\u5165\u8981\u6c42%1$s2\u3001\u7ea2\u8272\u5e26\u661f\u53f7\uff08*\uff09\u7684\u5b57\u6bb5\u4e3a\u5fc5\u5f55\u5b57\u6bb5%2$s3\u3001\u7b2c\u4e8c\u884c\u7b2c\u4e00\u4e2a\u5355\u5143\u683c\u8f93\u5165#SetNULL\uff0c\u542f\u7528\u5355\u5143\u683c\u8f93\u5165NULL\u6e05\u7a7a\u5b57\u6bb5%3$s#OverrideEntry", (String)"PlanCalendarerList_52", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), "\r\n", "\r\n", "\r\n"));
        CellStyle wrapTextstyle = newExcel.createCellStyle();
        wrapTextstyle.setWrapText(true);
        row2.getCell(0).setCellStyle(wrapTextstyle);
        CellStyle redstyle = this.getFontStyle(newExcel, IndexedColors.RED.getIndex());
        CellStyle blackstyle = this.getFontStyle(newExcel, IndexedColors.BLACK.getIndex());
        DataFormat format = newExcel.createDataFormat();
        CellStyle columnStyle = newExcel.createCellStyle();
        SXSSFDrawing p = newExcelSheet.createDrawingPatriarch();
        columnStyle.setDataFormat(format.getFormat("@"));
        this.addLineCell((Row)row3, attrList, null, null);
        this.addLineCell((Row)row4, attrNameList, redstyle, blackstyle);
        Comment temp = this.getCellComment(p, new XSSFRichTextString(String.format(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a%1$s\u4f11\u606f\u65e5=\u5468\u516d\uff0c\u5468\u65e5%2$s\u8282\u5047\u65e5=2020-10-10\uff0c2020-10-16%3$s\u540c\u4e00\u6761\u8ba1\u5212\u65e5\u5386\u53ef\u4ee5\u6dfb\u52a0\u591a\u884c\u4f11\u606f\u65e5\u7c7b\u578b", (String)"PlanCalendarerList_53", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), "\r\n", "\r\n", "\r\n")), (short)4, 3, (short)7, 9);
        row4.getCell(4).setCellComment(temp);
        CellStyle cellStyle = row4.getCell(4).getCellStyle();
        cellStyle.setWrapText(true);
        row4.getCell(4).setCellStyle(cellStyle);
        Comment temp2 = this.getCellComment(p, new XSSFRichTextString(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a2020-10-1", (String)"PlanCalendarerList_54", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), (short)5, 3, (short)6, 6);
        row4.getCell(5).setCellComment(temp2);
        Comment temp3 = this.getCellComment(p, new XSSFRichTextString(ResManager.loadKDString((String)"\u793a\u4f8b\uff1a2020-10-1", (String)"PlanCalendarerList_54", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), (short)6, 3, (short)7, 6);
        row4.getCell(6).setCellComment(temp3);
        return newExcel;
    }

    private CellStyle getFontStyle(SXSSFWorkbook newExcel, short index) {
        CellStyle style = newExcel.createCellStyle();
        Font font = newExcel.createFont();
        font.setColor(index);
        style.setFont(font);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        return style;
    }

    private Comment getCellComment(SXSSFDrawing p, XSSFRichTextString xssfRichTextString, short line, int column, short width, int height) {
        Comment temp = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)line, column, (int)width, height));
        temp.setString((RichTextString)xssfRichTextString);
        return temp;
    }

    private void addLineCell(Row row, List<String> attrlist, CellStyle redstyle, CellStyle blackstyle) {
        for (int i = 0; i < attrlist.size(); ++i) {
            String attr = attrlist.get(i);
            row.createCell(i).setCellValue(attr);
            if (redstyle == null || blackstyle == null) continue;
            if (attr.contains("*")) {
                row.getCell(i).setCellStyle(redstyle);
                continue;
            }
            row.getCell(i).setCellStyle(blackstyle);
        }
    }

    public void initialize() {
        FormShowParameter form = this.getView().getFormShowParameter();
        String f = form.getFormId();
        if ("bos_listf7".equals(f)) {
            return;
        }
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        if (orgtree != null) {
            orgtree.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        this.addClickListeners(new String[]{"setdefoultworkcalendar", "setworkcalendar", "preyear", "nextyear"});
        WorkCalendar workCalendar = (WorkCalendar)this.getView().getControl("workcalendarap");
        if (workCalendar != null) {
            workCalendar.addClickListener((ClickListener)this);
        }
        BillList list = (BillList)this.getControl("billlistap");
        list.addListRowDoubleClickListener((ListRowClickListener)this);
        list.addSelectRowsListener((SelectRowsEventListener)this);
        list.addClickListener((ClickListener)this);
        FilterContainer container = (FilterContainer)this.getControl("filtercontainerap");
        container.setBillFormId(ENTITY);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initOrgTree();
        FormDataModel source = (FormDataModel)e.getSource();
        if ("bos_listf7".equals(source.getDataEntityType().getName())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
        }
        this.getPageCache().put("selectorg", "0");
    }

    public void listRowDoubleClick(ListRowClickEvent evt) {
        ListSelectedRow row = evt.getCurrentListSelectedRow();
        Long id = (Long)row.getPrimaryKeyValue();
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", ENTITY);
        para.put("pkId", String.valueOf(id));
        para.put("status", (String)OperationStatus.EDIT);
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "reload");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject e) {
        FormShowParameter form = this.getView().getFormShowParameter();
        String f = form.getFormId();
        if ("bos_listf7".equals(f)) {
            return;
        }
        if (this.getModel().getValue("year") == null || String.valueOf(this.getModel().getDataEntity().get("year")).trim().length() == 0) {
            this.setCurYear(Calendar.getInstance().get(1));
        }
    }

    private void setCurYear(int year) {
        this.getModel().setValue("year", (Object)year);
        Label label = (Label)this.getControl("yearshow");
        label.setText(String.valueOf(year));
    }

    private void initOrgTree() {
        int i;
        FormShowParameter form = this.getView().getFormShowParameter();
        String f = form.getFormId();
        if ("bos_listf7".equals(f)) {
            return;
        }
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"PlanCalendarerList_64", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        root.setId("root");
        root.setChildren(new ArrayList());
        nodes.add(root);
        List<Map<String, String>> orgList = this.getAllPermissionOrgs("04");
        ArrayList<String> orgid = new ArrayList<String>(orgList.size());
        for (i = 0; i < orgList.size(); ++i) {
            orgid.add(orgList.get(i).get("id"));
        }
        for (i = 0; i < orgList.size(); ++i) {
            Map<String, String> map = orgList.get(i);
            TreeNode tr = this.changeMapToTreeOrgNode(map, orgid, root);
            if (tr == null) continue;
            nodes.add(tr);
        }
        orgtree.addNodes(nodes);
    }

    private TreeNode changeMapToTreeOrgNode(Map<String, String> map, List<String> list, TreeNode root) {
        String id;
        if (map.isEmpty() || "9999999999999".equals(map.get("id"))) {
            return null;
        }
        TreeNode node = new TreeNode();
        node.setId(map.get("id"));
        node.setText(map.get("name").replace("workcent", ""));
        String isleaf = map.get("isleaf");
        if (isleaf == null) {
            isleaf = "0";
        }
        if ("0".equals(isleaf)) {
            node.setChildren(new ArrayList());
        }
        if ((id = map.get("id")).contains("calendar")) {
            node.setColor("blue");
        }
        if ("0".equals(map.get("parentId")) || "9999999999999".equals(map.get("parentId"))) {
            root.addChild(node);
            return null;
        }
        if (!list.toString().contains(map.get("parentId"))) {
            root.addChild(node);
            return null;
        }
        node.setParentid(map.get("parentId"));
        return node;
    }

    private boolean isSetCalendarAtYear(int year) {
        String idr = this.getFocusId();
        if (idr == null) {
            return false;
        }
        if (idr.contains("calendar")) {
            String calendarId = idr.replaceAll("calendar", "").trim();
            QFilter idFilter = new QFilter("id", "=", (Object)Long.valueOf(calendarId));
            QFilter[] filters = new QFilter[]{idFilter};
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,name,expiringyearfrom,expiringyearto", (QFilter[])filters);
            DynamicObject calendarInfo = dynamicObjects[0];
            String start = (String)calendarInfo.get("expiringyearfrom");
            String end = (String)calendarInfo.get("expiringyearto");
            int startYear = Integer.parseInt(start);
            int endYear = Integer.parseInt(end);
            if (year >= startYear && year <= endYear) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void click(EventObject evt) {
        Control c;
        block14: {
            int lastyear;
            int year;
            block13: {
                c = (Control)evt.getSource();
                String focusid = this.getFocusId();
                if (focusid == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5386\u3002", (String)"PlanCalendarerList_56", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                if (focusid.contains("calendar")) {
                    String calendarId = focusid.replaceAll("calendar", "").trim();
                    try {
                        BusinessDataServiceHelper.loadSingle((Object)calendarId, (String)ENTITY);
                    }
                    catch (Exception e) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86", (String)"PlanCalendarerList_65", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                        return;
                    }
                }
                year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
                if (!c.getKey().toLowerCase().startsWith("preyear")) break block13;
                lastyear = year - 1;
                if (this.isSetCalendarAtYear(lastyear)) {
                    String idr = this.getFocusId();
                    if (idr.contains("calendar")) {
                        String id = idr.replace("calendar", "").trim();
                        this.loadCalendarData(lastyear, id);
                    }
                    break block14;
                } else {
                    if (this.getFocusId() != null && this.getFocusId().contains("calendar")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386\u3002", (String)"PlanCalendarerList_55", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), year - 1));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5386\u3002", (String)"PlanCalendarerList_56", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (c.getKey().toLowerCase().startsWith("nextyear")) {
                lastyear = year + 1;
                if (this.isSetCalendarAtYear(lastyear)) {
                    String idr = this.getFocusId();
                    if (idr.contains("calendar")) {
                        String id = idr.replace("calendar", "").trim();
                        this.loadCalendarData(lastyear, id);
                    }
                } else {
                    if (this.getFocusId() != null && this.getFocusId().contains("calendar")) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e%s\u5e74\u7684\u5de5\u4f5c\u65e5\u5386\u3002", (String)"PlanCalendarerList_55", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), year + 1));
                        return;
                    }
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u5386\u3002", (String)"PlanCalendarerList_56", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        if (this.getFocusId() == null) return;
        if (!workCalendar.equals(c)) return;
        this.markWorkCalendar(workCalendar, this.getFocusId());
    }

    private void markWorkCalendar(WorkCalendar workCalendar, String orgId) {
        if (!this.getFocusId().contains("calendar")) {
            return;
        }
        ArrayList dateList = workCalendar.getDateList();
        String calendarId = this.getFocusId().replaceAll("calendar", "").trim();
        QFilter calendarid = new QFilter("id", "=", (Object)Long.valueOf(calendarId));
        QFilter[] qfilters = new QFilter[]{calendarid};
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,name,createorg", (QFilter[])qfilters);
        if (dynamicObjects.length <= 0) {
            return;
        }
        this.recordMarkCalendar(dateList, calendarId, workCalendar);
    }

    private void recordMarkCalendar(List<String> dateList, String calendarId, WorkCalendar workCalendar) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(calendarId))};
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        ORM orm = ORM.create();
        DynamicObjectCollection workCalendarDb = orm.query(ENTITY, "id,status,enable ,dateentry.*", filters);
        DynamicObject calendarInfo = (DynamicObject)workCalendarDb.get(0);
        String status = (String)calendarInfo.get("status");
        if (!"A".equals(status)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u6807\u6ce8\u6682\u5b58\u7684\u65e5\u5386\u3002", (String)"PlanCalendarerList_57", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("2".equals(workCalendar.getDateType())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6807\u6ce8\u534a\u5de5\u4f5c\u65e5\u3002", (String)"PlanCalendarerList_58", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        if (workCalendarDb.size() == 1) {
            DynamicObjectCollection dateentry = ((DynamicObject)workCalendarDb.get(0)).getDynamicObjectCollection("dateentry");
            block2: for (int i = 0; i < dateList.size(); ++i) {
                if (dateentry.toString().indexOf(dateList.get(i)) == -1) {
                    DynamicObject entry = dateentry.addNew();
                    try {
                        entry.set("workdate", (Object)SDF.parse(dateList.get(i)));
                    }
                    catch (ParseException e) {
                        logger.debug(e.getMessage());
                    }
                    entry.set("datetype", (Object)workCalendar.getDateType());
                    continue;
                }
                for (int j = 0; j < dateentry.size(); ++j) {
                    DynamicObject dateEntryInfo = (DynamicObject)dateentry.get(j);
                    Date date = (Date)dateEntryInfo.get("workdate");
                    String dateString = SDF.format(date);
                    if (!dateString.equals(dateList.get(i))) continue;
                    dateEntryInfo.set("datetype", (Object)workCalendar.getDateType());
                    continue block2;
                }
            }
            orm.update(new DynamicObject[]{(DynamicObject)workCalendarDb.get(0)});
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6807\u6ce8\u6210\u529f\u3002", (String)"PlanCalendarerList_59", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
        workCalendar.setDateTypeCallBack(dateList, workCalendar.getDateType());
    }

    public void treeNodeClick(TreeNodeEvent arg0) {
        QFilter orgid;
        String calendarId = (String)arg0.getNodeId();
        if (calendarId == null) {
            return;
        }
        BillList list = (BillList)this.getControl("billlistap");
        if (calendarId.contains("calendar")) {
            String calendar = calendarId.replaceAll("calendar", "");
            QFilter IdFilter = new QFilter("id", "=", (Object)Long.valueOf(calendar));
            FilterParameter qr = new FilterParameter(IdFilter, "");
            list.setQueryFilterParameter(qr);
            list.clearSelection();
            int year = Integer.parseInt(String.valueOf(this.getModel().getValue("year")));
            this.loadCalendarData(year, calendar);
        } else if (!calendarId.contains("root")) {
            orgid = new QFilter("createorg", "=", (Object)Long.valueOf(calendarId));
            FilterParameter qr = new FilterParameter(orgid, "");
            this.getView().getFormShowParameter().setCustomParam("createorgid", (Object)Long.valueOf(calendarId));
            this.getView().cacheFormShowParameter();
            list.setQueryFilterParameter(qr);
            list.refresh();
            list.clearSelection();
            this.getPageCache().put("selectorg", calendarId);
        } else if (calendarId.contains("root")) {
            orgid = new QFilter("createorg", "in", this.setOrgFilter());
            FilterParameter qr = new FilterParameter(orgid, "");
            list.setQueryFilterParameter(qr);
            list.refresh();
            list.clearSelection();
            this.getView().getFormShowParameter().setCustomParam("createorgid", null);
            this.getView().cacheFormShowParameter();
            this.getPageCache().put("selectorg", "0");
        }
        TreeView orgtree = (TreeView)this.getControl("orgtree");
        orgtree.showNode(arg0.getNodeId().toString());
    }

    private void loadCalendarData(int year, String calendarId) {
        DynamicObject dynamicObjects = BusinessDataServiceHelper.loadSingle((Object)calendarId, (String)ENTITY);
        WorkCalendar workCalendar = (WorkCalendar)this.getControl("workcalendarap");
        ArrayList workDataList = new ArrayList(16);
        workCalendar.setYear(year);
        SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < dynamicObjects.getDynamicObjectCollection("dateEntry").size(); ++i) {
            HashMap<String, String> markDateMap = new HashMap<String, String>(16);
            DynamicObject obj = (DynamicObject)dynamicObjects.getDynamicObjectCollection("dateEntry").get(i);
            String dateKey = SDF.format(obj.getDate("workdate"));
            markDateMap.put("workDate", dateKey);
            markDateMap.put("dateType", obj.getString("datetype"));
            workDataList.add(markDateMap);
        }
        workCalendar.setWorkDataList(workDataList);
        workCalendar.setData();
        this.setCurYear(year);
    }

    private void refshList() {
        BillList list = (BillList)this.getControl("billlistap");
        list.refresh();
    }

    public static Map<String, Object> getMarkDateMap(String orgId, String dateFrom, String dateTo) {
        HashMap<String, Object> markDateMap = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)dateFrom) || StringUtils.isBlank((CharSequence)dateTo)) {
            return markDateMap;
        }
        PlanCalendarerList.findAllMarkDate(markDateMap, orgId, dateFrom, dateTo);
        return markDateMap;
    }

    private static void findAllMarkDate(Map<String, Object> markDateMap, String orgId, String dateFromStr, String dateToStr) {
        String parentOrgId;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date dateFrom = null;
        Date dateTo = null;
        try {
            dateFrom = dateFormat.parse(dateFromStr);
            dateTo = dateFormat.parse(dateToStr);
        }
        catch (ParseException px) {
            logger.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38\u3002" + px);
        }
        QFilter[] filters = new QFilter[4];
        filters[0] = new QFilter("createorg.id", "=", (Object)Long.valueOf(orgId));
        filters[1] = new QFilter("dateentry.workdate", ">=", (Object)dateFrom);
        filters[2] = new QFilter("dateentry.workdate", "<=", (Object)dateTo);
        DynamicObjectCollection entityList = QueryServiceHelper.query((String)ENTITY, (String)"id, dateentry.workdate, dateentry.datetype", (QFilter[])filters, null);
        if (entityList != null && entityList.size() > 0) {
            SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd");
            for (DynamicObject date : entityList) {
                String dateKey = SDF.format(date.getDate(1));
                if (markDateMap.containsKey(dateKey)) continue;
                markDateMap.put(dateKey, date.getInt(2));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(parentOrgId = PlanCalendarerList.getOrgPrentId(orgId))) && !"0".equals(parentOrgId)) {
            PlanCalendarerList.findAllMarkDate(markDateMap, parentOrgId, dateFromStr, dateToStr);
        }
    }

    public static String getOrgPrentId(String id) {
        String parentId = "";
        QFilter[] qf = new QFilter[]{new QFilter("view.isdefault", "=", (Object)"1"), new QFilter("view.treetype", "=", (Object)"01"), new QFilter("org", "=", (Object)Long.valueOf(id))};
        DynamicObject parentObj = QueryServiceHelper.queryOne((String)"bos_org_structure", (String)"id,parent", (QFilter[])qf);
        if (parentObj == null) {
            return parentId;
        }
        return parentObj.getString("parent");
    }

    public String getFocusId() {
        BillList bill = (BillList)this.getControl("billlistap");
        String id = bill.getFocusRowPkId() + "calendar";
        if (!id.equals("nullcalendar")) {
            return id;
        }
        return this.getPageCache().get("calendar");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op = (AbstractOperate)e.getSource();
        if ("new".equals(op.getOperateKey())) {
            if (this.getPageCache().get("selectorg") == null || "0".equals(this.getPageCache().get("selectorg"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u5de6\u4fa7\u6811\u5f62\u8282\u70b9", (String)"PlanCalendarerList_66", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                RequestContext requestContext = RequestContext.get();
                Long orgId = Long.valueOf(this.getPageCache().get("selectorg"));
                int flag = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)orgId, (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"47156aff000000ac");
                if (flag == 0) {
                    DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgId)});
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u7ec4\u7ec7:[%s]\u7684\u65b0\u589e\u6743\u9650", (String)"PlanCalendarerList_67", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), org == null ? "" : org.get("name")));
                    e.setCancel(true);
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if ("submit1".equals(operateKey)) {
            if (!e.getOperationResult().isSuccess()) {
                return;
            }
            this.submitOperate(selectedRows);
        } else if ("enable1".equals(operateKey)) {
            if (!e.getOperationResult().isSuccess()) {
                return;
            }
            this.enableOperate(selectedRows);
        } else if ("default".equals(operateKey)) {
            this.defaultOperate(selectedRows);
        } else {
            if ("delete".equals(operateKey)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
                return;
            }
            if ("importdownload".equals(operateKey)) {
                ByteArrayOutputStream outStream = null;
                ByteArrayInputStream inStream = null;
                SXSSFWorkbook newExcel = null;
                try {
                    newExcel = this.createExcelTemp();
                    outStream = new ByteArrayOutputStream();
                    newExcel.write((OutputStream)outStream);
                    inStream = new ByteArrayInputStream(outStream.toByteArray());
                    TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                    int timeout = 7200;
                    String tempUrl = cache.saveAsUrl(ResManager.loadKDString((String)"\u8ba1\u5212\u65e5\u5386\u5f15\u5165\u6a21\u677f.xlsx", (String)"PlanCalendarerList_63", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), (InputStream)inStream, timeout);
                    this.getView().download(tempUrl);
                }
                catch (IOException ex) {
                    throw new KDBizException(ex.getMessage());
                }
                finally {
                    try {
                        if (outStream != null) {
                            outStream.close();
                        }
                        if (newExcel != null) {
                            newExcel.close();
                        }
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.error("\u4e0b\u8f7d\u8ba1\u5212\u65e5\u5386\u5f15\u5165\u6a21\u677f\u5f02\u5e38", (Throwable)ioe);
                    }
                }
            }
        }
    }

    private void defaultOperate(ListSelectedRowCollection selectedRows) {
        QFilter enableFilter;
        QFilter statusFilter;
        ListSelectedRow row;
        int i;
        StringBuilder error = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        boolean flag = true;
        if (selectedRows.size() == 1) {
            ListSelectedRow row2 = selectedRows.get(0);
            if (!"C".equals(row2.getBillStatus())) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_78", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u5931\u8d25", (String)"PlanCalendarerList_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row2.getPrimaryKeyValue(), (String)ENTITY);
            int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row2.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"0=O4NDUXIQPR");
            if (hasPer == 0) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_80", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u5931\u8d25", (String)"PlanCalendarerList_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            if ("0".equals(obj.getString("enable"))) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_81", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u5931\u8d25", (String)"PlanCalendarerList_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
        }
        for (i = 0; i < selectedRows.size(); ++i) {
            row = selectedRows.get(i);
            QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
            QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
            QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
            statusFilter = new QFilter("status", "=", (Object)"C");
            enableFilter = new QFilter("enable", "=", (Object)"1");
            if (!QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter, enableFilter})) continue;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("default");
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)row.getMainOrgId(), (String)"bos_org", (String)"id,name");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a[%s]\u5df2\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\uff0c\u662f\u5426\u9700\u8981\u8bbe\u7f6e\u65b0\u7684\u9ed8\u8ba4\u65e5\u5386\uff1f", (String)"PlanCalendarerList_82", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), org.get("name")), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < selectedRows.size(); ++i) {
                row = selectedRows.get(i);
                if (!"C".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_78", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                QFilter idFilter = new QFilter("id", "=", row.getPrimaryKeyValue());
                QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
                QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                statusFilter = new QFilter("status", "=", (Object)"C");
                enableFilter = new QFilter("enable", "=", (Object)"1");
                idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter, enableFilter})) continue;
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY);
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"0=O4NDUXIQPR");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_80", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if ("0".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_81", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                obj.set("isfault", (Object)"1");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
            if (flag) {
                if (error.length() > 0) {
                    this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u5931\u8d25", (String)"PlanCalendarerList_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u6210\u529f\u3002", (String)"PlanCalendarerList_62", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                }
                this.refshList();
            }
        }
    }

    private void enableOperate(ListSelectedRowCollection selectedRows) {
        QFilter defaultFilter;
        ListSelectedRow row;
        int i;
        StringBuilder error = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        boolean flag = true;
        if (selectedRows.size() == 1) {
            ListSelectedRow row2 = selectedRows.get(0);
            if (!"C".equals(row2.getBillStatus())) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u542f\u7528\u3002%2$s", (String)"PlanCalendarerList_73", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"PlanCalendarerList_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row2.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
            if ("1".equals(obj.getString("enable"))) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\u3002%2$s", (String)"PlanCalendarerList_75", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"PlanCalendarerList_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row2.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"4730fc5d000000ac");
            if (hasPer == 0) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s],\u60a8\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_76", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"PlanCalendarerList_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
        }
        for (i = 0; i < selectedRows.size(); ++i) {
            QFilter enableFilter;
            QFilter statusFilter;
            QFilter orgFilter;
            QFilter idFilter;
            DynamicObject obj;
            row = selectedRows.get(i);
            if (!"C".equals(row.getBillStatus()) || "1".equals((obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status")).getString("enable")) || !obj.getBoolean("isfault") || !QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue()), orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId()), defaultFilter = new QFilter("isfault", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("enable1");
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)row.getMainOrgId(), (String)"bos_org", (String)"id,name");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a[%s]\u5df2\u5b58\u5728\u542f\u7528\u7684\u9ed8\u8ba4\u65e5\u5386\uff0c\u662f\u5426\u542f\u7528\u5e76\u66ff\u6362\u539f\u6709\u9ed8\u8ba4\u65e5\u5386\uff1f", (String)"PlanCalendarerList_77", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), org.get("name")), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < selectedRows.size(); ++i) {
                row = selectedRows.get(i);
                if (!"C".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u542f\u7528\u3002%2$s", (String)"PlanCalendarerList_73", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("1".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\u3002%2$s", (String)"PlanCalendarerList_75", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"4730fc5d000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s],\u60a8\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_76", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
                    obj.set("enable", (Object)"1");
                } else {
                    obj.set("enable", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        if (flag) {
            if (error.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"PlanCalendarerList_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f\u3002", (String)"PlanCalendarerList_61", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            this.refshList();
        }
    }

    private void submitOperate(ListSelectedRowCollection selectedRows) {
        QFilter defaultFilter;
        ListSelectedRow row;
        int i;
        StringBuilder error = new StringBuilder();
        RequestContext requestContext = RequestContext.get();
        boolean flag = true;
        if (selectedRows.size() == 1) {
            ListSelectedRow row2 = selectedRows.get(0);
            if (!"A".equals(row2.getBillStatus())) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_68", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row2.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
            if ("0".equals(obj.getString("enable"))) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7981\u7528\u6570\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_70", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
            int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row2.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"804f6478000000ac");
            if (hasPer == 0) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s],\u60a8\u6ca1\u6709\u63d0\u4ea4\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_71", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row2.getNumber(), "\n"));
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                return;
            }
        }
        for (i = 0; i < selectedRows.size(); ++i) {
            QFilter enableFilter;
            QFilter statusFilter;
            QFilter orgFilter;
            QFilter idFilter;
            DynamicObject obj;
            row = selectedRows.get(i);
            if (!"A".equals(row.getBillStatus()) || "0".equals((obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status")).getString("enable")) || !obj.getBoolean("isfault") || !QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue()), orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId()), defaultFilter = new QFilter("isfault", "=", (Object)"1"), statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("submit1");
            DynamicObject org = BusinessDataServiceHelper.loadSingle((Object)row.getMainOrgId(), (String)"bos_org", (String)"id,name");
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\uff1a[%s]\u5b58\u5728\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u9ed8\u8ba4\u65e5\u5386\uff0c\u662f\u5426\u63d0\u4ea4\u5e76\u66ff\u6362\u539f\u6709\u9ed8\u8ba4\u65e5\u5386\uff1f", (String)"PlanCalendarerList_72", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), org.get("name")), MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < selectedRows.size(); ++i) {
                row = selectedRows.get(i);
                if (!"A".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_68", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("0".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7981\u7528\u6570\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_70", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"804f6478000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s],\u60a8\u6ca1\u6709\u63d0\u4ea4\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_71", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
                    return;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
                    obj.set("status", (Object)"C");
                } else {
                    obj.set("status", (Object)"C");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        if (flag) {
            if (error.length() > 0) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"PlanCalendarerList_60", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            this.refshList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        RequestContext requestContext = RequestContext.get();
        boolean flag = false;
        boolean success = false;
        if ("default".equals(messageBoxClosedEvent.getCallBackId()) & messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.defaultConfirm(selectedRows);
        } else if ("enable1".equals(messageBoxClosedEvent.getCallBackId())) {
            this.enableConfirm(messageBoxClosedEvent, selectedRows);
        } else if ("submit1".equals(messageBoxClosedEvent.getCallBackId())) {
            this.submitConfirm(messageBoxClosedEvent, selectedRows);
        }
        this.refshList();
    }

    private void submitConfirm(MessageBoxClosedEvent messageBoxClosedEvent, ListSelectedRowCollection selectedRows) {
        RequestContext requestContext = RequestContext.get();
        int success = 0;
        boolean flag = false;
        StringBuilder error = new StringBuilder();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow row = selectedRows.get(i);
                if (!"A".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_88", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("0".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7981\u7528\u6570\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_70", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"804f6478000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u63d0\u4ea4\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_89", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) {
                        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,enable,isfault", (QFilter[])new QFilter[]{idFilter, defaultFilter, statusFilter, orgFilter, enableFilter});
                        for (int j = 0; j < objArr.length; ++j) {
                            objArr[j].set("isfault", (Object)"0");
                        }
                        SaveServiceHelper.save((DynamicObject[])objArr);
                        ++success;
                        obj.set("status", (Object)"C");
                    } else {
                        ++success;
                        obj.set("status", (Object)"C");
                    }
                } else {
                    ++success;
                    obj.set("status", (Object)"C");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        } else {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow row = selectedRows.get(i);
                if (!"A".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u6682\u5b58\u72b6\u6001\u7684\u6570\u636e\u624d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_88", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("0".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801:[%1$s]\uff0c\u5df2\u7981\u7528\u6570\u636e\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002%2$s", (String)"PlanCalendarerList_70", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"804f6478000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u63d0\u4ea4\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_89", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
                    ++success;
                    obj.set("status", (Object)"C");
                } else {
                    ++success;
                    obj.set("status", (Object)"C");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u4ea4\u5931\u8d25", (String)"PlanCalendarerList_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
        } else if (!flag && success > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f", (String)"PlanCalendarerList_90", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    private void enableConfirm(MessageBoxClosedEvent messageBoxClosedEvent, ListSelectedRowCollection selectedRows) {
        RequestContext requestContext = RequestContext.get();
        int success = 0;
        boolean flag = false;
        StringBuilder error = new StringBuilder();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow row = selectedRows.get(i);
                if (!"C".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u542f\u7528\u3002%2$s", (String)"PlanCalendarerList_84", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("1".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\u3002%2$s", (String)"PlanCalendarerList_85", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"4730fc5d000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_86", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) {
                        DynamicObject[] objArr = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,enable,isfault", (QFilter[])new QFilter[]{idFilter, defaultFilter, statusFilter, orgFilter, enableFilter});
                        for (int j = 0; j < objArr.length; ++j) {
                            objArr[j].set("isfault", (Object)"0");
                        }
                        SaveServiceHelper.save((DynamicObject[])objArr);
                        ++success;
                        obj.set("enable", (Object)"1");
                    } else {
                        ++success;
                        obj.set("enable", (Object)"1");
                    }
                } else {
                    ++success;
                    obj.set("enable", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        } else {
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow row = selectedRows.get(i);
                if (!"C".equals(row.getBillStatus())) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u542f\u7528\u3002%2$s", (String)"PlanCalendarerList_84", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY, (String)"id,isfault,enable,status");
                if ("1".equals(obj.getString("enable"))) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\u3002%2$s", (String)"PlanCalendarerList_85", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"4730fc5d000000ac");
                if (hasPer == 0) {
                    error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u542f\u7528\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_86", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                    continue;
                }
                if (obj.getBoolean("isfault")) {
                    QFilter enableFilter;
                    QFilter statusFilter;
                    QFilter idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
                    QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
                    QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
                    if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter = new QFilter("status", "=", (Object)"C"), enableFilter = new QFilter("enable", "=", (Object)"1")})) continue;
                    ++success;
                    obj.set("enable", (Object)"1");
                } else {
                    ++success;
                    obj.set("enable", (Object)"1");
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
            }
        }
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25", (String)"PlanCalendarerList_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
        } else if (!flag && success > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u542f\u7528\u6210\u529f", (String)"PlanCalendarerList_87", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    private void defaultConfirm(ListSelectedRowCollection selectedRows) {
        RequestContext requestContext = RequestContext.get();
        int success = 0;
        boolean flag = false;
        StringBuilder error = new StringBuilder();
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow row = selectedRows.get(i);
            if (!"C".equals(row.getBillStatus())) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u53ea\u6709\u5df2\u5ba1\u6838\u7684\u6570\u636e\u624d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_78", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                continue;
            }
            QFilter idFilter = new QFilter("id", "=", row.getPrimaryKeyValue());
            QFilter defaultFilter = new QFilter("isfault", "=", (Object)"1");
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)ENTITY);
            if ("0".equals(obj.getString("enable"))) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u3002%2$s", (String)"PlanCalendarerList_81", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                continue;
            }
            int hasPer = PermissionServiceHelper.checkPermission((Long)requestContext.getCurrUserId(), (Long)row.getMainOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"0=O4NDUXIQPR");
            if (hasPer == 0) {
                error.append(String.format(ResManager.loadKDString((String)"\u65e5\u5386\u7f16\u7801\uff1a[%1$s]\uff0c\u60a8\u6ca1\u6709\u8bbe\u7f6e\u9ed8\u8ba4\u65e5\u5386\u6743\u9650\u3002%2$s", (String)"PlanCalendarerList_80", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), row.getNumber(), "\n"));
                continue;
            }
            obj.set("isfault", (Object)"1");
            QFilter orgFilter = new QFilter("createorg.id", "=", (Object)row.getMainOrgId());
            idFilter = new QFilter("id", "!=", row.getPrimaryKeyValue());
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            if (QueryServiceHelper.exists((String)ENTITY, (QFilter[])new QFilter[]{orgFilter, defaultFilter})) {
                DynamicObject[] objArr = BusinessDataServiceHelper.load((String)ENTITY, (String)"id,isfault", (QFilter[])new QFilter[]{idFilter, orgFilter, defaultFilter, statusFilter, enableFilter});
                for (int j = 0; j < objArr.length; ++j) {
                    objArr[j].set("isfault", (Object)"0");
                }
                SaveServiceHelper.save((DynamicObject[])objArr);
            }
            ++success;
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
        if (error.length() > 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u5931\u8d25", (String)"PlanCalendarerList_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), error.toString(), MessageTypes.Default);
        } else if (!flag && success > 0) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9ed8\u8ba4\u65e5\u5386\u8bbe\u7f6e\u6210\u529f\u3002", (String)"PlanCalendarerList_62", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        BillList bill = (BillList)evt.getSource();
        Long id = (Long)bill.getFocusRowPkId();
        if (evt.getNewRows().size() == 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
            return;
        }
        if (evt.getNewRows().size() > 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanelap1", "flexpanelap11"});
            return;
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"flexpanelap1", "flexpanelap11"});
        DynamicObject dyObj = null;
        try {
            dyObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY);
        }
        catch (Exception e) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u88ab\u5176\u4ed6\u4eba\u5220\u9664\u4e86", (String)"PlanCalendarerList_65", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put("calendar", bill.getFocusRowPkId() + "calendar");
        int year = dyObj.getInt("expiringyearfrom");
        this.loadCalendarData(year, id.toString());
    }

    private List<Map<String, String>> getAllPermissionOrgs(String orgViewType) {
        RequestContext requestContext = RequestContext.get();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((Long)requestContext.getCurrUserId(), (String)this.getView().getFormShowParameter().getAppId(), (String)ENTITY, (String)"47150e89000000ac");
        QFilter filterTreetype = new QFilter("view", "=", (Object)914427355726916608L);
        if (!hasPermOrgResult.hasAllOrgPerm()) {
            QFilter filterOrg = new QFilter("org.id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            filterTreetype = filterTreetype.and(filterOrg);
        }
        QFilter freezeFilter = new QFilter("isfreeze", "=", (Object)"0");
        QFilter freezeFilter1 = new QFilter("isfreeze", "is null", null);
        freezeFilter = freezeFilter.or(freezeFilter1);
        QFilter[] filterOrgs = new QFilter[]{filterTreetype, freezeFilter};
        return PlanCalendarerList.rebuildPermissionOrgTree(filterOrgs);
    }

    public static List<Map<String, String>> rebuildPermissionOrgTree(QFilter[] filters) {
        if (filters == null) {
            return new ArrayList<Map<String, String>>(0);
        }
        DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bos_org_structure", (String)"id, org.id org, org.number number,org.name name,longnumber,parent", (QFilter[])filters, (String)"level");
        if (orgCol.isEmpty()) {
            return new ArrayList<Map<String, String>>(0);
        }
        ArrayList<Map<String, String>> treeList = new ArrayList<Map<String, String>>(1);
        HashMap orgLongToOrg = new HashMap(1);
        ArrayList<String> rootList = new ArrayList<String>();
        HashSet<String> hasChildList = new HashSet<String>();
        ArrayList<String> idList = new ArrayList<String>();
        for (DynamicObject orgView : orgCol) {
            if (orgView.getString("name") == null || "".equals(orgView.getString("name")) || idList.contains(orgView.getString("org"))) continue;
            idList.add(orgView.getString("org"));
            String longnumber = orgView.getString("longnumber");
            HashMap<String, String> org = new HashMap<String, String>();
            org.put("id", orgView.getString("org"));
            org.put("number", orgView.getString("number"));
            org.put("name", orgView.getString("name"));
            org.put("longnumber", longnumber);
            org.put("parentId", orgView.getString("parent"));
            org.put("isleaf", "1");
            if (OrgUnitServiceHelper.getRootOrgId() == orgView.getLong("org")) {
                rootList.add(longnumber);
            } else {
                String parentLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)"!");
                Map parent = (Map)orgLongToOrg.get(parentLongnumber);
                if (parent == null) {
                    rootList.add(longnumber);
                } else {
                    parent.put("isleaf", "0");
                    hasChildList.add(parentLongnumber);
                }
            }
            treeList.add(org);
            orgLongToOrg.put(longnumber, org);
        }
        if (rootList.size() > 1) {
            HashMap<String, String> orgRoot = new HashMap<String, String>();
            orgRoot.put("id", "9999999999999");
            orgRoot.put("number", "0");
            orgRoot.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"PlanCalendarerList_64", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            orgRoot.put("longnumber", "0");
            orgRoot.put("parentId", "0");
            orgRoot.put("isleaf", "0");
            treeList.add(orgRoot);
            for (String longnumber : rootList) {
                Map org = (Map)orgLongToOrg.get(longnumber);
                if (org == null) continue;
                org.put("parentId", "9999999999999");
                if (hasChildList.contains(longnumber)) {
                    org.put("isleaf", "0");
                    continue;
                }
                org.put("isleaf", "1");
            }
        }
        return treeList;
    }

    static {
        attrList.add("number");
        attrList.add("name.zh_CN");
        attrList.add("createorg.number");
        attrList.add("createorg.name");
        attrList.add("datetype");
        attrList.add("startdate");
        attrList.add("enddate");
        attrNameList.add(ResManager.loadKDString((String)"*\u65e5\u5386\u7f16\u7801", (String)"PlanCalendarerList_42", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u65e5\u5386\u540d\u79f0.\u7b80\u4f53\u4e2d\u6587", (String)"PlanCalendarerList_43", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u521b\u5efa\u7ec4\u7ec7.\u7f16\u7801", (String)"PlanCalendarerList_44", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7.\u540d\u79f0", (String)"PlanCalendarerList_45", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u4f11\u606f\u65e5\u7c7b\u578b", (String)"PlanCalendarerList_46", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u5f00\u59cb\u65e5\u671f", (String)"PlanCalendarerList_47", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        attrNameList.add(ResManager.loadKDString((String)"*\u7ed3\u675f\u65e5\u671f", (String)"PlanCalendarerList_48", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
    }
}

