/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.mpscmm.common.consts.PlanScopeInitConst;
import kd.mpscmm.common.enums.PlanScopeInitStatusEnum;

public class PlanScopeInitFormPlugin
extends AbstractFormPlugin {
    private static final String KEY_INIT = "init";
    private static final String KEY_UN_INIT = "uninit";
    private static final String KEY_TB_MAIN = "tbmain";
    private static final String KEY_SHORT_CUTS_KEY = "ctrl+alt+o";
    private static final String KEY_SHORT_CUTS_VALUE = "[17,18,79]";
    private static final String CUS_EVT_SHORT_CUTS = "shortCuts";
    private static final String CALL_BACK_INIT = "callBackInit";
    private static final String LOCK_KEY_INIT = "mpscmm/msplan/msplan_planscopeinit/init";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{KEY_TB_MAIN});
    }

    public void createNewData(BizDataEventArgs e) {
        super.createNewData(e);
        DynamicObject planScopeInit = BusinessDataServiceHelper.loadSingle((Object)PlanScopeInitConst.PRE_INS_ID, (String)"msplan_planscopeinit");
        e.setDataEntity((Object)planScopeInit);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_UN_INIT});
        this.setShortCuts();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof Donothing) {
            Donothing operate = (Donothing)source;
            String operateKey = operate.getOperateKey();
            if (!KEY_INIT.equals(operateKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8303\u56f4\u53c2\u6570\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u6269\u5c55\u4fee\u6539\u3002", (String)"PlanScopeInitFormPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u8303\u56f4\u53c2\u6570\u521d\u59cb\u5316\u4e0d\u5141\u8bb8\u6269\u5c55\u4fee\u6539\u3002", (String)"PlanScopeInitFormPlugin_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if (KEY_INIT.equals(operateKey)) {
            String initStatusFromDb = this.getInitStatusFromDb();
            String initStatus = (String)this.getModel().getValue("initstatus");
            if (PlanScopeInitStatusEnum.INIT.getValue().equals(initStatusFromDb)) {
                if (initStatusFromDb.equals(initStatus)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8ba1\u5212\u8303\u56f4\u53c2\u6570\u5df2\u521d\u59cb\u5316\u3002", (String)"PlanScopeInitFormPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5176\u4ed6\u7528\u6237\u5df2\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PlanScopeInitFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            String initConfirmMsg = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u540e\uff0c\u8ba1\u5212\u8303\u56f4\u53c2\u6570\u5c06\u5f00\u542f\uff0c\u5236\u9020\u76f8\u5173\u5e94\u7528\u5c06\u542f\u7528\u8ba1\u5212\u8303\u56f4\uff0cMRP\u8ba1\u7b97\u5c06\u6309\u8ba1\u5212\u8303\u56f4\u8fdb\u884c\u4f9b\u9700\u5e73\u8861\uff0c\u76f8\u5173\u5355\u636e\u548c\u57fa\u7840\u8d44\u6599\u4e2d\u8ba1\u5212\u8303\u56f4\u5fc5\u5f55\uff0c\u8ba1\u5212\u8ba2\u5355\u3001\u751f\u4ea7\u5de5\u5355\u3001\u751f\u4ea7\u7ec4\u4ef6\u6e05\u5355\u3001\u59d4\u5916\u5de5\u5355\u3001\u59d4\u5916\u7ec4\u4ef6\u6e05\u5355\u3001\u534f\u540c\u8ba1\u5212\u5355\u7b49\u5355\u636e\u5165\u5e93\u4ed3\u5e93\u548c\u4f9b\u8d27\u4ed3\u5e93\u5c06\u6309\u8ba1\u5212\u8303\u56f4\u53d6\u503c\uff1b\u521d\u59cb\u5316\u540e\u65e0\u6cd5\u518d\u56de\u9000\u5230\u975e\u521d\u59cb\u5316\u72b6\u6001\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u521d\u59cb\u5316\uff1f", (String)"PlanScopeInitFormPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(initConfirmMsg, MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CALL_BACK_INIT, (IFormPlugin)this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (CALL_BACK_INIT.equals(callBackId) && MessageBoxResult.Yes == result) {
            boolean initSuccess;
            DLock lock = DLock.create((String)LOCK_KEY_INIT).fastMode();
            boolean tryLock = lock.tryLock();
            if (!tryLock) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PlanScopeInitFormPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            try {
                initSuccess = this.executeInit();
            }
            finally {
                lock.unlock();
            }
            if (initSuccess) {
                DynamicObject planScopeInit = BusinessDataServiceHelper.loadSingle((Object)PlanScopeInitConst.PRE_INS_ID, (String)"msplan_planscopeinit");
                this.getModel().createNewData((Object)planScopeInit);
                this.getView().updateView();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u6210\u529f\u3002", (String)"PlanScopeInitFormPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (KEY_UN_INIT.equals(itemKey)) {
            this.unInit();
        }
    }

    public void customEvent(CustomEventArgs e) {
        String key;
        super.customEvent(e);
        String eventName = e.getEventName();
        if (CUS_EVT_SHORT_CUTS.equalsIgnoreCase(eventName) && KEY_SHORT_CUTS_VALUE.equals(key = e.getEventArgs())) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_UN_INIT});
        }
    }

    private void setShortCuts() {
        JSONArray arrayItem = new JSONArray();
        JSONObject item = new JSONObject();
        item.put("type", (Object)"keyDown");
        item.put(CUS_EVT_SHORT_CUTS, (Object)KEY_SHORT_CUTS_KEY);
        arrayItem.add((Object)item);
        IFormView formView = this.getView();
        IClientViewProxy clientViewProxy = (IClientViewProxy)formView.getService(IClientViewProxy.class);
        JSONArray action = new JSONArray();
        action.add((Object)arrayItem);
        clientViewProxy.addAction("setShortCuts", (Object)action);
    }

    private void unInit() {
        DynamicObject planScopeInit = BusinessDataServiceHelper.loadSingle((Object)PlanScopeInitConst.PRE_INS_ID, (String)"msplan_planscopeinit");
        planScopeInit.set("enableplanscope", (Object)false);
        planScopeInit.set("initstatus", (Object)PlanScopeInitStatusEnum.NOT_INIT.getValue());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planScopeInit});
        this.getModel().createNewData((Object)planScopeInit);
        this.getView().updateView();
    }

    private boolean executeInit() {
        String initStatusFromDb = this.getInitStatusFromDb();
        if (PlanScopeInitStatusEnum.INIT.getValue().equals(initStatusFromDb)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u5176\u4ed6\u7528\u6237\u5df2\u8fdb\u884c\u521d\u59cb\u5316\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"PlanScopeInitFormPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.init();
        this.generatePlanScope();
        return true;
    }

    private void init() {
        DynamicObject planScopeInit = BusinessDataServiceHelper.loadSingle((Object)PlanScopeInitConst.PRE_INS_ID, (String)"msplan_planscopeinit");
        planScopeInit.set("enableplanscope", (Object)true);
        planScopeInit.set("initstatus", (Object)PlanScopeInitStatusEnum.INIT.getValue());
        planScopeInit.set("inituser_id", (Object)RequestContext.get().getCurrUserId());
        planScopeInit.set("initdate", (Object)new Date());
        List<String> ctrlScopeEntityList = this.getCtrlScopeEntityList();
        DynamicObjectCollection ctrlScopeEntry = planScopeInit.getDynamicObjectCollection("ctrlscopeentry");
        ctrlScopeEntry.clear();
        int seq = 1;
        for (String entity : ctrlScopeEntityList) {
            DynamicObject row = ctrlScopeEntry.addNew();
            row.set("seq", (Object)seq++);
            row.set("entity_id", (Object)entity);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{planScopeInit});
    }

    private List<String> getCtrlScopeEntityList() {
        ArrayList<String> ctrlScopeEntityList = new ArrayList<String>();
        ctrlScopeEntityList.add("msplan_planscope");
        ctrlScopeEntityList.add("msplan_planscope_whs");
        ctrlScopeEntityList.add("msplan_matplanscop");
        ctrlScopeEntityList.add("mds_mdsplandata");
        ctrlScopeEntityList.add("mds_safetystock");
        ctrlScopeEntityList.add("mrp_planprogram");
        ctrlScopeEntityList.add("mrp_cps_planpro");
        ctrlScopeEntityList.add("mrp_planorder");
        ctrlScopeEntityList.add("pom_mftorder");
        ctrlScopeEntityList.add("om_mftorder");
        ctrlScopeEntityList.add("pom_mftstock");
        ctrlScopeEntityList.add("om_mftstock");
        ctrlScopeEntityList.add("mrp_collaborativeorder");
        return ctrlScopeEntityList;
    }

    private void generatePlanScope() {
        QFilter produceFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"04");
        QFilter inventoryFilter = OrgUnitServiceHelper.getBizOrgFilter((String)"05");
        QFilter[] orgFilters = new QFilter[]{produceFilter.or(inventoryFilter)};
        DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bos_org", (String)"id, number, name", (QFilter[])orgFilters);
        Set orgIdSet = orgList.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        QFilter[] planScopeFilters = new QFilter[]{new QFilter("type", "=", (Object)"A")};
        DynamicObjectCollection planScopeList = QueryServiceHelper.query((String)"msplan_planscope", (String)"createorg", (QFilter[])planScopeFilters);
        Set planScopeOrgIdSet = planScopeList.stream().map(v -> v.getLong("createorg")).collect(Collectors.toSet());
        orgIdSet.removeAll(planScopeOrgIdSet);
        if (orgIdSet.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> orgMap = orgList.stream().collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        ArrayList<DynamicObject> newPlanScopeList = new ArrayList<DynamicObject>(orgIdSet.size());
        long[] planScopeIds = ID.genLongIds((int)orgIdSet.size());
        int idIdx = 0;
        Iterator iterator = orgIdSet.iterator();
        while (iterator.hasNext()) {
            String orgName;
            long orgId = (Long)iterator.next();
            DynamicObject org = orgMap.get(orgId);
            String orgNumber = org.getString("number");
            if (orgNumber.length() > 60) {
                orgNumber = orgNumber.substring(0, 60);
            }
            if ((orgName = org.getString("name")).length() > 155) {
                orgName = orgName.substring(0, 155);
            }
            DynamicObject planScope = BusinessDataServiceHelper.newDynamicObject((String)"msplan_planscope");
            planScope.set("id", (Object)planScopeIds[idIdx]);
            planScope.set("masterid", (Object)planScopeIds[idIdx]);
            planScope.set("createorg_id", (Object)orgId);
            planScope.set("number", (Object)orgNumber);
            planScope.set("name", (Object)orgName);
            planScope.set("type", (Object)"A");
            planScope.set("status", (Object)"C");
            planScope.set("enable", (Object)"1");
            planScope.set("creator_id", (Object)RequestContext.get().getCurrUserId());
            planScope.set("modifier_id", (Object)RequestContext.get().getCurrUserId());
            planScope.set("createtime", (Object)new Date());
            planScope.set("modifytime", (Object)new Date());
            ++idIdx;
            newPlanScopeList.add(planScope);
        }
        SaveServiceHelper.save((DynamicObject[])newPlanScopeList.toArray(new DynamicObject[0]));
    }

    private String getInitStatusFromDb() {
        QFilter idFilter = new QFilter("id", "=", (Object)PlanScopeInitConst.PRE_INS_ID);
        DynamicObject planScopeFromDb = QueryServiceHelper.queryOne((String)"msplan_planscopeinit", (String)"initstatus", (QFilter[])idFilter.toArray());
        return planScopeFromDb.getString("initstatus");
    }
}

