/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.batchupd;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateTimeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.QtyEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.mpscmm.msplan.formplugin.batchupd.BatchUpdateFactory;

public class BatchUpdateBasePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(BatchUpdateBasePlugin.class);
    private static final String BATCHUPDFIELD = "batchupdfield";
    private static final String MSPLAN_BATCHUPD = "msplan_batchupd";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String BATCHOPERA = "batchopera";
    private static final String NEWVALUE = "newvalue";
    private String progressPluginClass;

    public void initialize() {
        String pluginType = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        this.progressPluginClass = BatchUpdateFactory.getProgressPlugin(pluginType);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit handlersEdit = (BasedataEdit)this.getControl(BATCHOPERA);
        handlersEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit updatevaluetracknumber = (BasedataEdit)this.getControl("updatevaluetracknumber");
        updatevaluetracknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"updatevaluecombo", "updatevaluemulcombo", "updatevaluecheckbox", "measureunit", "updatevalueqty", "updatevaluetext", "updatevaluetracknumber", "updatevaluelongdate", "updatevaluedecimal", "updatevaluedate"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.toString(), (CharSequence)BATCHOPERA)) {
            DynamicObject batchopera;
            String hide = this.getPageCache().get("currentField");
            if (hide != null) {
                this.getView().setVisible(Boolean.FALSE, new String[]{hide});
                this.getModel().setValue(hide, null);
            }
            if ((batchopera = (DynamicObject)model.getValue(BATCHOPERA)) == null) {
                return;
            }
            String field = batchopera.getString("field");
            String mapping = batchopera.getString("mapping");
            String name = batchopera.getLocaleString("name").getLocaleValue();
            String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entitynumber);
            this.getView().setVisible(Boolean.TRUE, new String[]{mapping});
            Control control = this.getControl(mapping);
            if (control instanceof DecimalEdit) {
                DecimalEdit edit = (DecimalEdit)control;
                edit.setCaption(new LocaleString(name));
            } else if (control instanceof TextEdit) {
                TextEdit edit = (TextEdit)control;
                edit.setCaption(new LocaleString(name));
            } else if (control instanceof DateTimeEdit) {
                DateTimeEdit edit = (DateTimeEdit)control;
                edit.setCaption(new LocaleString(name));
            } else if (control instanceof DateEdit) {
                DateEdit edit = (DateEdit)control;
                edit.setCaption(new LocaleString(name));
            } else if (control instanceof MulComboEdit) {
                MulComboEdit edit = (MulComboEdit)control;
                edit.setCaption(new LocaleString(name));
                ComboProp comboProp = (ComboProp)dataEntityType.getProperty(field);
                List comboItems = comboProp.getComboItems();
                this.setComboValue((ComboEdit)edit, comboItems);
            } else if (control instanceof ComboEdit) {
                ComboEdit edit = (ComboEdit)control;
                edit.setCaption(new LocaleString(name));
                ComboProp comboProp = (ComboProp)dataEntityType.getProperty(field);
                List comboItems = comboProp.getComboItems();
                this.setComboValue(edit, comboItems);
            } else if (control instanceof QtyEdit) {
                QtyEdit edit = (QtyEdit)control;
                edit.setCaption(new LocaleString(name));
            } else if (control instanceof FieldEdit) {
                FieldEdit edit = (FieldEdit)control;
                edit.setCaption(new LocaleString(name));
            }
            this.getPageCache().put("currentField", mapping);
        }
    }

    private void setComboValue(ComboEdit comboEdit, List<ValueMapItem> comboItems2) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(comboItems2.size());
        for (ValueMapItem entry : comboItems2) {
            if (!entry.isItemVisible()) continue;
            ComboItem item = new ComboItem();
            item.setValue(entry.getValue());
            item.setCaption(entry.getName());
            item.setItemVisible(entry.isItemVisible());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String key = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)BATCHUPDFIELD, (CharSequence)key) && closedCallBackEvent.getReturnData() != null) {
            this.getView().returnDataToParent((Object)"success");
            this.getView().invokeOperation("close");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        logger.info("batch operation save start......");
        if (operateKey.equals("batchupdate")) {
            Map idBillnoMap = (Map)this.getView().getFormShowParameter().getCustomParam(BATCHUPDFIELD);
            String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
            DynamicObject batchopera = (DynamicObject)this.getModel().getValue(BATCHOPERA);
            if (batchopera == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7f16\u8f91\u5b57\u6bb5\u3002", (String)"BatchUpdateBasePlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            String modelField = batchopera.getString("mapping");
            Object newValue = this.getModel().getValue(modelField);
            this.batchUpdFieldData(idBillnoMap, entitynumber, batchopera, newValue);
        }
    }

    private void batchUpdFieldData(Map<Long, String> idBillnoMap, String entitynumber, DynamicObject batchopera, Object newValue) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        customParams.put(BATCHUPDFIELD, idBillnoMap);
        customParams.put(ENTITYNUMBER, entitynumber);
        customParams.put(BATCHOPERA, batchopera.getLong("id"));
        customParams.put(NEWVALUE, newValue);
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(MSPLAN_BATCHUPD);
        showParameter.setCustomParams(customParams);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.addCustPlugin(this.progressPluginClass);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, BATCHUPDFIELD));
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        String entitynumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        List filters = ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters();
        filters.add(new QFilter("enable", "=", (Object)"1"));
        if (StringUtils.equals((CharSequence)BATCHOPERA, (CharSequence)name)) {
            filters.add(new QFilter("source", "=", (Object)entitynumber));
        }
    }
}

