/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.dataconfig;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillTypeControlInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BillTypeDifferentialHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.billtype.BillTypeServiceHelper;

public class DataConfigEditPlugin
extends AbstractBillPlugIn {
    private static final String KEY_BILLFORMID = "billformid";
    private static final String KEY_ENTRYENTITY = "entryentity";
    private static final String KEY_LAYOUTSOLUTION = "layoutsolution";
    private static final String CACHE_KEY_LAYOUTS = "cache_layouts";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_FIELDKEY = "fieldkey";
    private static final String KEY_ALLFIELDKEY = "allfieldkey";
    private static final String KEY_FIELD_NAME = "fieldname";
    private static final String KEY_DEFAULTFUNCPARAM = "defaultfuncparam";
    private static final String KEY_MUSTINPUT_D = "mustinput";
    private static Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    private static Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    private static final List<String> UNSUPPORT_MUSTINPUT_FIELDS = Arrays.asList("BasedataPropField", "FlexField");

    public void afterLoadData(EventObject e) {
        String formId = this.getCurrentFormId();
        this.bindLayout(formId);
        this.lockLimitEditCell();
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (KEY_BILLFORMID.equals(key)) {
            this.drawPage();
        } else if (KEY_LAYOUTSOLUTION.equals(key)) {
            this.drawPage();
        }
    }

    private void drawPage() {
        String formId = this.getCurrentFormId();
        if (StringUtils.isNotBlank((CharSequence)formId)) {
            String layoutFormId = this.bindLayout(formId);
            this.buildDisplayFieldControlEntry(layoutFormId, formId);
            this.lockLimitEditCell();
        } else {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
            this.getModel().setValue(KEY_LAYOUTSOLUTION, null);
        }
    }

    private void lockLimitEditCell() {
        String formId = this.getCurrentFormId();
        String layoutFormId = this.getCurrentLayoutFormId();
        if (StringUtils.isBlank((CharSequence)formId) || StringUtils.isBlank((CharSequence)layoutFormId)) {
            return;
        }
        Map<String, BillTypeControlInfo> ctlInfos = this.getFieldControlInfos(layoutFormId, formId);
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> entry : ctlInfos.entrySet()) {
            BillTypeControlInfo ctlInfo = entry.getValue();
            int rowIndex = i++;
            if (ctlInfo.isMustInput()) {
                this.lockCell(KEY_MUSTINPUT_D, rowIndex);
            }
            LOCK2STATUS.forEach((statusKey, status) -> {
                if (ctlInfo.isLock(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            VISIBLE2STATUS.forEach((statusKey, status) -> {
                if (!ctlInfo.isVisible(status)) {
                    this.lockCell((String)statusKey, rowIndex);
                }
            });
            if (!UNSUPPORT_MUSTINPUT_FIELDS.contains(ctlInfo.getFieldType())) continue;
            this.lockCell(KEY_MUSTINPUT_D, rowIndex);
        }
    }

    private String getCurrentLayoutFormId() {
        String id = (String)this.getModel().getValue(KEY_LAYOUTSOLUTION);
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        String layoutCache = this.getPageCache().get(CACHE_KEY_LAYOUTS);
        List layouts = SerializationUtils.fromJsonStringToList((String)layoutCache, Map.class);
        Optional<Map> op = layouts.stream().filter(item -> item.get("id").equals(id)).findFirst();
        return op.isPresent() ? (String)op.get().get(KEY_NUMBER) : null;
    }

    private void lockCell(String key, int row) {
        FieldEdit cellEdit = (FieldEdit)this.getView().getControl(key);
        cellEdit.setEntryKey(KEY_ENTRYENTITY);
        cellEdit.setEnable("", false, row);
    }

    private void buildDisplayFieldControlEntry(String formId, String orginalFormId) {
        this.getModel().beginInit();
        Map<String, BillTypeControlInfo> ctlInfos = this.getFieldControlInfos(formId, orginalFormId);
        int size = ctlInfos.size();
        if (this.getModel().getEntryRowCount(KEY_ENTRYENTITY) > 0) {
            this.getModel().deleteEntryData(KEY_ENTRYENTITY);
        }
        if (size > 0) {
            this.getModel().batchCreateNewEntryRow(KEY_ENTRYENTITY, size);
        }
        HashMap<String, String> nameMap = new HashMap<String, String>(ctlInfos.size());
        Map<String, String> allFields = this.getAllFields(orginalFormId, nameMap);
        int i = 0;
        for (Map.Entry<String, BillTypeControlInfo> ctlInfo : ctlInfos.entrySet()) {
            this.buildDisplayFieldControlRow(ctlInfo.getValue(), i++, allFields, nameMap);
        }
        this.getModel().endInit();
        this.getView().updateView(KEY_ENTRYENTITY);
    }

    private Map<String, String> getAllFields(String orginalFormId, Map<String, String> nameMap) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)orginalFormId);
        Map allFields = dataEntityType.getAllFields();
        HashMap<String, String> map = new HashMap<String, String>(allFields.size());
        allFields.values().forEach(e -> {
            if (e.getDisplayName() != null) {
                if (e.getParent() instanceof SubEntryType) {
                    nameMap.put(e.getName(), e.getParent().getParent().getDisplayName().getLocaleValue().replace(".", "") + '.' + e.getParent().getDisplayName().getLocaleValue().replace(".", "") + '.' + e.getDisplayName().getLocaleValue().replace(".", ""));
                } else if (e.getParent() instanceof EntryType) {
                    nameMap.put(e.getName(), e.getParent().getDisplayName().getLocaleValue().replace(".", "") + '.' + e.getDisplayName().getLocaleValue().replace(".", ""));
                } else {
                    nameMap.put(e.getName(), e.getDisplayName().getLocaleValue().replace(".", ""));
                }
                if (!"".equals(e.getAlias())) {
                    if (e.getParent() instanceof SubEntryType) {
                        map.put(e.getName(), e.getParent().getParent().getName() + '.' + e.getParent().getName() + '.' + e.getName());
                    } else if (e.getParent() instanceof EntryType) {
                        map.put(e.getName(), e.getParent().getName() + '.' + e.getName());
                    } else {
                        map.put(e.getName(), e.getName());
                    }
                }
            }
        });
        return map;
    }

    private void buildDisplayFieldControlRow(BillTypeControlInfo ctlInfo, int i, Map<String, String> allFields, Map<String, String> nameMap) {
        IDataModel model = this.getModel();
        model.setValue(KEY_FIELDKEY, (Object)ctlInfo.getFieldKey(), i);
        model.setValue(KEY_ALLFIELDKEY, (Object)allFields.get(ctlInfo.getFieldKey()), i);
        model.setValue("isdatabase", (Object)allFields.containsKey(ctlInfo.getFieldKey()), i);
        model.setValue(KEY_FIELD_NAME, (Object)(nameMap.get(ctlInfo.getFieldKey()) == null ? ctlInfo.getFieldName() : nameMap.get(ctlInfo.getFieldKey())), i);
        model.setValue(KEY_DEFAULTFUNCPARAM, (Object)ctlInfo.getFieldType(), i);
        model.setValue("sysmustinput", (Object)ctlInfo.isMustInput(), i);
        model.setValue(KEY_MUSTINPUT_D, (Object)ctlInfo.isMustInput(), i);
        LOCK2STATUS.forEach((statusKey, status) -> model.setValue(statusKey, (Object)ctlInfo.isLock(status), i));
        VISIBLE2STATUS.forEach((statusKey, status) -> model.setValue(statusKey, (Object)ctlInfo.isVisible(status), i));
    }

    private String bindLayout(String formId) {
        Optional<Map> op;
        List layouts = null;
        layouts = QueryServiceHelper.exists((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter(KEY_NUMBER, "=", (Object)formId), new QFilter("modeltype", "=", (Object)"BaseFormModel")}) ? BillTypeServiceHelper.getBillLayoutByFormId((String)formId, (String)"BaseFormModel") : BillTypeServiceHelper.getBillLayoutByFormId((String)formId);
        ComboEdit edit = (ComboEdit)this.getControl(KEY_LAYOUTSOLUTION);
        List items = layouts.stream().map(item -> {
            ILocaleString v = (ILocaleString)item.get("name");
            return new ComboItem(new LocaleString(v.getLocaleValue()), (String)item.get("id"));
        }).collect(Collectors.toList());
        this.getPageCache().put(CACHE_KEY_LAYOUTS, SerializationUtils.toJsonString((Object)layouts));
        edit.setComboItems(items);
        Object val = this.getModel().getValue(KEY_LAYOUTSOLUTION);
        if (StringUtils.isBlank((Object)val)) {
            this.getModel().setValue(KEY_LAYOUTSOLUTION, ((Map)layouts.get(0)).get("id"));
        }
        return (op = layouts.stream().filter(item -> item.get("id").equals(this.getModel().getValue(KEY_LAYOUTSOLUTION))).findFirst()).isPresent() ? (String)op.get().get(KEY_NUMBER) : formId;
    }

    private Map<String, BillTypeControlInfo> getFieldControlInfos(String formId, String orginalFormId) {
        Map ctlInfos = BillTypeDifferentialHelper.getFullControlInfos((String)formId, (String)orginalFormId);
        return ctlInfos;
    }

    private String getCurrentFormId() {
        DynamicObject curBill = (DynamicObject)this.getModel().getValue(KEY_BILLFORMID);
        if (curBill == null) {
            return null;
        }
        RefEntityType rdType = (RefEntityType)curBill.getDataEntityType();
        return curBill.get(rdType.getNumberProperty()).toString();
    }

    static {
        VISIBLE2STATUS.put("vinit", "init");
        VISIBLE2STATUS.put("vnew", "new");
        VISIBLE2STATUS.put("vedit", "edit");
        VISIBLE2STATUS.put("vview", "view");
        VISIBLE2STATUS.put("vsubmit", "submit");
        VISIBLE2STATUS.put("vaudit", "audit");
        LOCK2STATUS.put("enabled", "new");
        LOCK2STATUS.put("editenabled", "edit");
        LOCK2STATUS.put("submitenabled", "submit");
        LOCK2STATUS.put("auditenabled", "audit");
    }
}

