/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.fetchdata;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.JSONUtils;
import kd.mpscmm.common.dynamic.BaseMeta;
import kd.mpscmm.common.dynamic.EntryEntityMeta;
import kd.mpscmm.common.dynamic.TextMeta;

public class MsplanFetchDataQueryPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static Log log = LogFactory.getLog(MsplanFetchDataQueryPlugin.class);
    private static final String ENTRYENTITY = "entryentity";
    private List<BaseMeta> metaList;

    public void initialize() {
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"previous", "next", "first", "last", "selectall", "cancelselect"});
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        List dataList = (List)SerializationUtils.deSerializeFromBase64((String)this.getCache("datalist"));
        int currentPage = (Integer)this.getModel().getValue("page");
        int pageRow = 100;
        if (this.getModel().getValue("pagerow") != null) {
            pageRow = Integer.parseInt((String)this.getModel().getValue("pagerow"));
        }
        if ("page".equals(fieldName)) {
            int page = (Integer)this.getModel().getValue("page");
            this.fillEntryEntityData(dataList, pageRow, page);
            this.getModel().setDataChanged(false);
        } else if ("pagerow".equals(fieldName)) {
            this.getModel().setValue("page", (Object)1);
            this.setPageCountCache(dataList.size(), pageRow);
            if (currentPage == 1) {
                this.fillEntryEntityData(dataList, pageRow, 1);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        int currentPage = (Integer)this.getModel().getValue("page");
        if ("next".equals(key)) {
            int nextPage = currentPage + 1;
            this.getModel().setValue("page", (Object)nextPage);
        } else if ("previous".equals(key)) {
            if (currentPage <= 1) {
                return;
            }
            this.getModel().setValue("page", (Object)(currentPage - 1));
        } else if ("last".equals(key)) {
            int pageCount = 1;
            if (this.getPageCache().get("pagecount") != null) {
                pageCount = Integer.parseInt(this.getPageCache().get("pagecount"));
            }
            this.getModel().setValue("page", (Object)pageCount);
        } else if ("first".equals(key)) {
            this.getModel().setValue("page", (Object)1);
        }
    }

    private void setPageCountCache(int counts, int pageSize) {
        int pageCount = 1;
        pageCount = counts % pageSize != 0 ? counts / pageSize + 1 : counts / pageSize;
        this.setPageCount(pageCount);
    }

    private void getDataCounts(HashMap<String, Object> dataMap) {
        ArrayList dataList = new ArrayList(dataMap.size());
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            ArrayList list = (ArrayList)entry.getValue();
            dataList.addAll(list);
        }
        String ds = SerializationUtils.serializeToBase64(dataList);
        this.getPageCache().put("datalist", ds);
    }

    private void initEntryView() {
        List<BaseMeta> baseMetaList = this.getMetaList();
        this.cacheEntryElement(baseMetaList);
        this.getEntryElement().loadView(this.getView());
    }

    private void setPageCount(int pageCount) {
        Label label = (Label)this.getControl("pagecount");
        String pageCountText = String.valueOf(pageCount);
        label.setText(pageCountText);
        this.getPageCache().put("pagecount", pageCountText);
    }

    private void clearEntryData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        int rowCount = entryEntity.getRowCount();
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        model.deleteEntryRows(ENTRYENTITY, rows);
    }

    private void fillEntryEntityData(List dataList, int pageSize, int page) {
        this.clearEntryData();
        this.getView().setEnable(Boolean.TRUE, new String[]{"first", "previous", "next", "last"});
        int pageCount = Integer.parseInt(this.getPageCache().get("pagecount"));
        if (page > pageCount) {
            this.getModel().setValue("page", (Object)pageCount);
            return;
        }
        int startIndex = (page - 1) * pageSize;
        int endIndex = page * pageSize;
        if (page == pageCount) {
            endIndex = dataList.size();
            this.getView().setEnable(Boolean.FALSE, new String[]{"next", "last"});
        }
        if (page == 1) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"previous", "first"});
        }
        List<BaseMeta> metaList = this.getMetaList();
        EntryGrid entryGrid = this.getEntryElement().getControl(this.getView());
        this.getModel().beginInit();
        for (int i = startIndex; i < endIndex; ++i) {
            ArrayList values = (ArrayList)dataList.get(i);
            int rowIndex = this.getModel().createNewEntryRow(ENTRYENTITY);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
            for (int k = 0; k < metaList.size(); ++k) {
                BaseMeta baseMeta = metaList.get(k);
                entryRowEntity.set(baseMeta.getName(), (Object)String.valueOf(values.get(k)));
            }
            BindingContext bindCtx = new BindingContext(entryRowEntity.getDataEntityType(), entryRowEntity, rowIndex);
            List rowValues = entryGrid.getRowBindValue(bindCtx);
            IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            proxy.appendRow(ENTRYENTITY, rowValues);
        }
        this.getModel().endInit();
    }

    public void afterCreateNewData(EventObject e) {
        if (this.getView().getFormShowParameter().getCustomParam("dataMap") != null) {
            HashMap<String, Object> dataMap = this.getDataMap();
            this.initEntryView();
            this.getDataCounts(dataMap);
            List dataList = (List)SerializationUtils.deSerializeFromBase64((String)this.getCache("datalist"));
            this.setPageCountCache(dataList.size(), 100);
            this.fillEntryEntityData(dataList, 100, 1);
        }
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private EntryEntityMeta getEntryElement() {
        String elements = this.getCache("entry_element");
        if (elements == null) {
            ArrayList<BaseMeta> elementList = new ArrayList<BaseMeta>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryEntityMeta)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private EntryEntityMeta cacheEntryElement(List<BaseMeta> elementList) {
        EntryEntityMeta entryElement = new EntryEntityMeta(ENTRYENTITY);
        entryElement.setItems(elementList);
        String s = SerializationUtils.serializeToBase64((Object)entryElement);
        this.putCache("entry_element", s);
        return (EntryEntityMeta)SerializationUtils.deSerializeFromBase64((String)this.getCache("entry_element"));
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryEntityMeta entryEntityMeta = this.getEntryElement();
        List baseMetaList = entryEntityMeta.getItems();
        Optional<BaseMeta> first = baseMetaList.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            BaseMeta element = first.get();
            Control control = element.getControl(this.getView());
            e.setControl(control);
        }
    }

    private HashMap<String, Object> getDataMap() {
        HashMap dataMap = new HashMap();
        JSONObject jsonObject = (JSONObject)this.getView().getFormShowParameter().getCustomParam("dataMap");
        try {
            dataMap = (HashMap)JSONUtils.cast((String)jsonObject.toJSONString(), HashMap.class);
        }
        catch (IOException ioException) {
            log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)ioException));
        }
        dataMap.remove("MetaCols");
        return dataMap;
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        if (this.getCache("isExist") == null) {
            List<BaseMeta> baseMetaList = this.getMetaList();
            this.cacheEntryElement(baseMetaList);
            this.getPageCache().put("isExist", "true");
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        EntryEntityMeta entryEntityMeta = this.getEntryElement();
        entryEntityMeta.registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
        entryEntityMeta.registerEntryEdit((EntryGrid)this.getControl(ENTRYENTITY), this.getView());
    }

    private List<BaseMeta> getMetaList() {
        if (this.metaList != null) {
            return this.metaList;
        }
        if (this.getView().getFormShowParameter().getCustomParam("MetaCols") != null) {
            String fieldString = (String)this.getView().getFormShowParameter().getCustomParam("MetaCols");
            String[] fields = fieldString.split("[,]");
            this.metaList = new ArrayList<BaseMeta>(fields.length);
            for (String field : fields) {
                String fieldName = field.toString();
                if (field.toString().contains(".")) {
                    fieldName = field.toString().split("[.]")[1];
                }
                TextMeta textMeta = new TextMeta(fieldName, field.toString(), ENTRYENTITY);
                this.metaList.add((BaseMeta)textMeta);
            }
            return this.metaList;
        }
        this.metaList = new ArrayList<BaseMeta>();
        return this.metaList;
    }
}

