/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.flexmetric;

import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MRPFlexMetricDefinePlugin
extends AbstractFormPlugin
implements AfterF7SelectListener,
RowClickEventListener,
BeforeF7SelectListener {
    private static final String SOURCEENTITY = "sourceentity";
    private static final String TARGETENTITY = "targetentity";
    private static final String EntryEntity = "entryentity";
    private static final String Sub_EntryEntity = "subentryentity";
    private static final String PRIORITY = "priority";
    private static final String SOURCE_BD = "source_bd";
    private static final String TARGET_BD = "target_bd";

    public void initialize() {
        this.getView().addCustomControls(new String[]{EntryEntity});
        this.getView().addCustomControls(new String[]{Sub_EntryEntity});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"issys"});
    }

    public void registerListener(EventObject e) {
        BasedataEdit srcEntity = (BasedataEdit)this.getControl(SOURCEENTITY);
        srcEntity.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit target_bd = (BasedataEdit)this.getControl(TARGET_BD);
        target_bd.addAfterF7SelectListener((AfterF7SelectListener)this);
        target_bd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit source_bd = (BasedataEdit)this.getControl(SOURCE_BD);
        source_bd.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit targetEntity = (BasedataEdit)this.getControl(TARGETENTITY);
        targetEntity.addAfterF7SelectListener((AfterF7SelectListener)this);
        EntryGrid eg = (EntryGrid)this.getControl(EntryEntity);
        eg.addRowClickListener((RowClickEventListener)this);
    }

    private void setEnableByFieldValue(String fieldName) {
        String[] entryField = new String[3];
        if (SOURCEENTITY.equals(fieldName)) {
            entryField[0] = EntryEntity;
            entryField[1] = "addrow";
            entryField[2] = "delrow";
        } else {
            entryField[0] = Sub_EntryEntity;
            entryField[1] = "addsubrow";
            entryField[2] = "delsubrow";
        }
        if (this.getModel().getValue(fieldName) != null) {
            this.getView().setEnable(Boolean.valueOf(true), entryField);
        } else {
            this.getView().setEnable(Boolean.valueOf(false), entryField);
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Object src = e.getSource();
        if (!(src instanceof BasedataEdit)) {
            return;
        }
        BasedataEdit bd = (BasedataEdit)src;
        if (SOURCEENTITY.equals(bd.getKey())) {
            this.getModel().deleteEntryData(EntryEntity);
            this.getModel().deleteEntryData(Sub_EntryEntity);
            this.setEnableByFieldValue(SOURCEENTITY);
        } else if (TARGETENTITY.equals(bd.getKey())) {
            this.getModel().deleteEntryData(Sub_EntryEntity);
            this.setEnableByFieldValue(TARGETENTITY);
        } else if (TARGET_BD.equals(bd.getKey())) {
            int rowIndex;
            IDataModel entryOperate = this.getModel();
            int parentIndex = entryOperate.getEntryCurrentRowIndex(EntryEntity);
            DynamicObject billObj = this.getModel().getDataEntity(true);
            DynamicObjectCollection parentObjs = billObj.getDynamicObjectCollection(EntryEntity);
            if (parentObjs.isEmpty()) {
                return;
            }
            DynamicObject parentObj = (DynamicObject)parentObjs.get(parentIndex);
            DynamicObjectCollection replaceObjs = parentObj.getDynamicObjectCollection(Sub_EntryEntity);
            for (int i = rowIndex = entryOperate.getEntryCurrentRowIndex(Sub_EntryEntity); i < replaceObjs.size(); ++i) {
                int priority;
                if (i <= 0 || (priority = ((Integer)this.getModel().getValue(PRIORITY, i)).intValue()) > 0 && priority != 99) continue;
                DynamicObject preObj = (DynamicObject)replaceObjs.get(i - 1);
                int prePriority = 0;
                if (preObj.get(PRIORITY) != null) {
                    prePriority = preObj.getInt(PRIORITY);
                }
                prePriority = prePriority - 1 <= 0 ? 0 : prePriority - 1;
                this.getModel().setValue(PRIORITY, (Object)prePriority, i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        if (SOURCEENTITY.equals(fieldName) || TARGETENTITY.equals(fieldName)) {
            this.setEnableByFieldValue(fieldName);
        }
    }

    public void createNewData(BizDataEventArgs e) {
        DynamicObject data = new DynamicObject((DynamicObjectType)this.getModel().getDataEntityType());
        data.set("enable", (Object)1);
        data.set("status", (Object)"A");
        e.setDataEntity((Object)data);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setEnableByFieldValue(SOURCEENTITY);
        this.setEnableByFieldValue(TARGETENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(EntryEntity);
        int rowCount = this.getModel().getEntryRowCount(EntryEntity);
        if (rowCount > 0) {
            entryGrid.selectRows(0);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getModel().setValue("creator", (Object)RequestContext.get().getCurrUserId());
        if (this.getView().getFormShowParameter().getCustomParam("createOrg") != null) {
            String createOrg = (String)this.getView().getFormShowParameter().getCustomParam("createOrg");
            this.getModel().setValue("createorg", (Object)Long.valueOf(createOrg));
        } else {
            Long orgId = RequestContext.get().getOrgId();
            this.getModel().setValue("createorg", (Object)orgId);
        }
        this.getView().updateView();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity();
        this.refreshBDRef(data);
        this.getModel().updateEntryCache(data.getDynamicObjectCollection(EntryEntity));
    }

    public void entryRowClick(RowClickEvent evt) {
        DynamicObject data = this.getModel().getDataEntity();
        this.refreshBDRef(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        try {
            if (!this.getModel().isDataLoaded()) {
                return;
            }
            this.refreshEntityType(newMainType);
        }
        finally {
            e.setNewEntityType(newMainType);
        }
    }

    private void refreshEntityType(MainEntityType newMainType) {
        DynamicObject targetET;
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject sourceET = data.getDynamicObject(SOURCEENTITY);
        if (sourceET != null) {
            EntryType entryType = (EntryType)newMainType.getAllEntities().get(EntryEntity);
            BasedataProp bp = (BasedataProp)entryType.getProperty(SOURCE_BD);
            String number = sourceET.getString("id");
            bp.setBaseEntityId(number);
            bp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)number));
        }
        if ((targetET = data.getDynamicObject(TARGETENTITY)) != null) {
            EntryType subEntryType = (EntryType)((SubEntryProp)((EntryType)newMainType.getAllEntities().get(EntryEntity)).getProperties().get((Object)Sub_EntryEntity)).getDynamicCollectionItemPropertyType();
            BasedataProp bp = (BasedataProp)subEntryType.getProperty(TARGET_BD);
            String number = targetET.getString("id");
            bp.setBaseEntityId(number);
            bp.setComplexType((IDataEntityType)EntityMetadataCache.getDataEntityType((String)number));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("newreplaceentry".equals(operateKey)) {
            IDataModel entryOperate = this.getModel();
            int parentIndex = entryOperate.getEntryCurrentRowIndex(EntryEntity);
            DynamicObject billObj = this.getModel().getDataEntity(true);
            DynamicObjectCollection parentObjs = billObj.getDynamicObjectCollection(EntryEntity);
            if (parentObjs.isEmpty()) {
                return;
            }
            DynamicObject parentObj = (DynamicObject)parentObjs.get(parentIndex);
            int currentRePlaceIndex = entryOperate.getEntryCurrentRowIndex(Sub_EntryEntity);
            DynamicObjectCollection replaceObjs = parentObj.getDynamicObjectCollection(Sub_EntryEntity);
            int minPriority = 99;
            for (int index = 0; index < replaceObjs.size(); ++index) {
                DynamicObject dynamicObject = (DynamicObject)replaceObjs.get(index);
                minPriority = Math.min(minPriority, dynamicObject.getInt(PRIORITY));
            }
            if (currentRePlaceIndex > 0) {
                int priority = minPriority - 1;
                if (priority <= 0) {
                    priority = 0;
                }
                this.getModel().setValue(PRIORITY, (Object)priority, currentRePlaceIndex);
            }
        }
    }

    private void refreshBDRef(DynamicObject data) {
        this.refreshEntityType((MainEntityType)data.getDataEntityType());
        HashSet<Object> sourceIds = new HashSet<Object>();
        HashSet<Object> targetIds = new HashSet<Object>();
        DynamicObjectCollection entrys = data.getDynamicObjectCollection(EntryEntity);
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(Sub_EntryEntity);
            sourceIds.add(entry.get("source_bd_id"));
            for (DynamicObject subEntry : subEntrys) {
                targetIds.add(subEntry.get("target_bd_id"));
            }
        }
        DynamicObject sourceET = data.getDynamicObject(SOURCEENTITY);
        DynamicObject targetET = data.getDynamicObject(TARGETENTITY);
        Map sources = sourceET != null ? BusinessDataServiceHelper.loadFromCache((Object[])sourceIds.toArray(), (String)sourceET.getString("id")) : new HashMap();
        Map targets = targetET != null ? BusinessDataServiceHelper.loadFromCache((Object[])targetIds.toArray(), (String)targetET.getString("id")) : new HashMap();
        for (DynamicObject entry : entrys) {
            entry.set(SOURCE_BD, sources.get(entry.get("source_bd_id")));
            DynamicObjectCollection subEntrys = entry.getDynamicObjectCollection(Sub_EntryEntity);
            for (DynamicObject subEntry : subEntrys) {
                subEntry.set(TARGET_BD, targets.get(subEntry.get("target_bd_id")));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String operate = op.getOperateKey();
        if ("newreplaceentry".equals(operate)) {
            if (this.isNotSelectEntryEntity()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6e90\u8bbe\u7f6e\u5206\u5f55\u6570\u636e\uff0c\u518d\u8fdb\u884c\u65b0\u589e\u3002", (String)"MRPFlexMetricDefinePlugin_1", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
        } else if ("deletereplaceentry".equals(operate) && this.isNotSelectEntryEntity()) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u884c\u6e90\u8bbe\u7f6e\u5206\u5f55\u6570\u636e\uff0c\u518d\u8fdb\u884c\u5220\u9664\u3002", (String)"MRPFlexMetricDefinePlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isNotSelectEntryEntity() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(EntryEntity);
        int[] rows = entryGrid.getSelectRows();
        return rows.length == 0;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if (SOURCE_BD.equals(propertyName)) {
            DynamicObjectCollection source_bdColl = this.getModel().getEntryEntity(EntryEntity);
            if (source_bdColl == null || source_bdColl.isEmpty()) {
                return;
            }
            HashSet<Long> idSet = new HashSet<Long>(source_bdColl.size());
            for (DynamicObject dynamicObject : source_bdColl) {
                if (dynamicObject.get("source_bd_id") == null || dynamicObject.getLong("source_bd_id") <= 0L) continue;
                idSet.add(dynamicObject.getLong("source_bd_id"));
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", idSet));
            beforeF7SelectEvent.addCustomQFilter(QFilter.isNotNull((String)"number"));
            QFilter numberFilter = new QFilter("number", "!=", (Object)" ");
            beforeF7SelectEvent.addCustomQFilter(numberFilter);
        } else if (TARGET_BD.equals(propertyName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(EntryEntity);
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(EntryEntity, rowIndex);
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(Sub_EntryEntity);
            if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
                return;
            }
            HashSet<Long> idSet = new HashSet<Long>(dynamicObjectCollection.size());
            for (DynamicObject target : dynamicObjectCollection) {
                if (target.get("target_bd_id") == null || target.getLong("target_bd_id") <= 0L) continue;
                idSet.add(target.getLong("target_bd_id"));
            }
            beforeF7SelectEvent.addCustomQFilter(new QFilter("id", "not in", idSet));
            beforeF7SelectEvent.addCustomQFilter(QFilter.isNotNull((String)"number"));
            QFilter numberFilter = new QFilter("number", "!=", (Object)" ");
            beforeF7SelectEvent.addCustomQFilter(numberFilter);
        }
    }
}

