/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.gantt;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.StringJoiner;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillModel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mpscmm.gantt.model.FiledLabel;
import kd.mpscmm.msplan.formplugin.gantt.OpenBillFieldUtil;

public class CustomerDataSoureEdit
extends AbstractBasePlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldcontent"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entityNumber = (String)formShowParameter.getCustomParam("entityNumber");
        Long dataId = (Long)formShowParameter.getCustomParam("dataId");
        Long dataSourceId = (Long)formShowParameter.getCustomParam("dataSourceId");
        QFilter qFilter = new QFilter("taskentity", "=", (Object)entityNumber);
        qFilter.and(new QFilter("dataid", "=", (Object)dataId));
        List primaryKeys = QueryServiceHelper.queryPrimaryKeys((String)"msplan_custom_ganttsource", (QFilter[])qFilter.toArray(), null, (int)1);
        if (!CollectionUtils.isEmpty((Collection)primaryKeys)) {
            BillModel model = (BillModel)this.getModel();
            model.load(primaryKeys.get(0));
        } else {
            this.getModel().setValue("taskentity", (Object)entityNumber);
            this.getModel().setValue("dataid", (Object)dataId);
        }
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"msplan_gantt_source", (String)"crossobj, crosstype");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection crossSetColl = dataSource.getDynamicObjectCollection("crossset");
        TableValueSetter tableValueSetter = new TableValueSetter(new String[]{"crossobj", "crosstype"});
        for (DynamicObject dynamicObject : crossSetColl) {
            String crossObj = dynamicObject.getString("crossobj");
            DynamicObject crossType = dynamicObject.getDynamicObject("crosstype");
            long crossTypeId = 0L;
            if (crossType != null) {
                crossTypeId = crossType.getLong("id");
            }
            boolean isExists = false;
            for (DynamicObject entity : entryEntity) {
                String existCrossObj = entity.getString("crossobj");
                long existCrossTypeId = entity.getLong("crosstype_id");
                if (!StringUtils.equals((CharSequence)existCrossObj, (CharSequence)crossObj) || crossTypeId != existCrossTypeId) continue;
                isExists = true;
            }
            if (isExists) continue;
            tableValueSetter.addRow(new Object[]{crossObj, crossTypeId});
        }
        AbstractFormDataModel dataModel = (AbstractFormDataModel)this.getModel();
        if (tableValueSetter.getCount() > 0) {
            dataModel.beginInit();
            dataModel.batchCreateNewEntryRow("entryentity", tableValueSetter);
            dataModel.endInit();
            this.getView().updateView("entryentity");
        }
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"fieldcontent", (CharSequence)key)) {
            int row = this.getModel().getEntryCurrentRowIndex("subentryentity");
            String selectValue = (String)this.getModel().getValue("fieldcontentdesc", row);
            String labelType = (String)this.getModel().getValue("lbltype", row);
            String labelFormat = (String)this.getModel().getValue("lblformat", row);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key);
            OpenBillFieldUtil.openBillFieldListEntry("entryentity", "taskentity", this.getView(), closeCallBack, selectValue, labelType, labelFormat);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (returnData != null && StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"fieldcontent")) {
            this.setFiledLabel(returnData, "fieldcontentdesc", "fieldcontent", "lblformat", "lbltype");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataEntityProperty property = e.getProperty();
        if (StringUtils.equals((CharSequence)property.getName(), (CharSequence)"contentlocation")) {
            ChangeData changeData = e.getChangeSet()[0];
            String newValue = (String)changeData.getNewValue();
            int rowIndex = changeData.getRowIndex();
            if (StringUtils.isNotBlank((CharSequence)newValue)) {
                DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("subentryentity");
                for (int i = 0; i < entryEntity.size(); ++i) {
                    String value;
                    if (i == rowIndex || !StringUtils.equals((CharSequence)(value = (String)this.getModel().getValue("contentlocation", i)), (CharSequence)newValue)) continue;
                    this.getModel().setValue("contentlocation", null, rowIndex);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u540c\u4e00\u6a2a\u9053\u5185\u5b58\u5728\u76f8\u540c\u7684\u6a2a\u9053\u4f4d\u7f6e\u3002", (String)"CustomerDataSoureEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs eventArgs) {
        super.afterDoOperation(eventArgs);
        String opKey = eventArgs.getOperateKey();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"save") && eventArgs.getOperationResult().isSuccess()) {
            List successPkIds = eventArgs.getOperationResult().getSuccessPkIds();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(successPkIds.get(0), (String)"msplan_custom_ganttsource");
            DynamicObjectCollection entryColl = dynamicObject.getDynamicObjectCollection("entryentity");
            boolean hasSubEntry = false;
            for (DynamicObject entryDyn : entryColl) {
                DynamicObjectCollection dynamicObjectCollection = entryDyn.getDynamicObjectCollection("subentryentity");
                if (dynamicObjectCollection.size() <= 0) continue;
                hasSubEntry = true;
            }
            if (!hasSubEntry) {
                DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"msplan_custom_ganttsource"), (Object[])successPkIds.toArray());
            }
            this.getView().returnDataToParent((Object)"sucess");
            this.getView().close();
        }
    }

    private void setFiledLabel(Object returnData, String value, String name, String format, String type) {
        if (ObjectUtils.isEmpty((Object)returnData)) {
            this.getModel().setValue(value, null);
            this.getModel().setValue(name, null);
            this.getModel().setValue(format, null);
            this.getModel().setValue(type, null);
        } else {
            List labels = (List)returnData;
            StringJoiner joinerName = new StringJoiner(",");
            StringJoiner joinerKey = new StringJoiner(",");
            StringJoiner joinerLabeltype = new StringJoiner(",");
            StringJoiner joinerlabelformat = new StringJoiner(",");
            for (FiledLabel label : labels) {
                joinerName.add(label.getFname());
                joinerKey.add(label.getFkey());
                joinerLabeltype.add(label.getLabeltype());
                joinerlabelformat.add(label.getLabelformat());
            }
            this.getModel().setValue(value, (Object)joinerKey.toString());
            this.getModel().setValue(name, (Object)joinerName.toString());
            this.getModel().setValue(format, (Object)joinerlabelformat.toString());
            this.getModel().setValue(type, (Object)joinerLabeltype.toString());
        }
    }
}

