/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.gantt;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.MrpEntityTypeUtil;

public class DataFilterEditPlugin
extends AbstractBillPlugIn {
    private static final String BTNOK = "btnok";
    private static final String FILTERGRIDAP = "filtergridap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        String entityobj = (String)parameter.getCustomParam("entityobj");
        String billfilterstr = (String)parameter.getCustomParam("billfilterstr");
        if (StringUtils.isNotEmpty((CharSequence)entityobj)) {
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
            this.setFilterByDestBillType(entityobj);
            if (StringUtils.isNotBlank((CharSequence)billfilterstr)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
                FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
                filterGrid.SetValue(filterCondition);
            }
        }
    }

    private void setFilterByDestBillType(String number) {
        if (number != null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String srcCtrlKey = con.getKey().toLowerCase();
        if (BTNOK.equals(srcCtrlKey)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
            String entityNumber = filterGrid.getEntityNumber();
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put("number", entityNumber);
            valueMap.put("filterString", filterString);
            this.getView().returnDataToParent(valueMap);
            this.getView().close();
        }
    }
}

