/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.gantt;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.mpscmm.common.util.GanttSourceUtil;

public class JobViewSchemPlugin
extends AbstractBasePlugIn
implements TabSelectListener {
    private static final String CACHE_GTENTITY_TREE = "cache_gtentity_tree";
    private static final String TAB_SCHEMINFO = "tab_scheminfo";
    private static final String TABPAGEAP_CROSS = "tabpageap_cross";
    private static final String TABPAGEAP_COLOR = "tabpageap_color";
    private static final String TABPAGEAP_DATALINE = "tabpageap_dataline";
    private static final String CALLBACK_COLOR = "callback_color";
    public static final String COLOR_SELECT = "msplan_color_select";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("colfieldflag");
        fields.add("colfieldname");
        fields.add("sortfieldname");
        fields.add("groupfieldname");
        fields.add("crosscolorval");
        fields.add("combofield");
        fields.add("fcolorvalue");
        fields.add("linecolorvalue");
        this.addClickListeners(fields.toArray(new String[fields.size()]));
        Tab tab = (Tab)this.getControl(TAB_SCHEMINFO);
        if (tab != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.getModel().setValue("planarea", (Object)true);
        this.getModel().setDataChanged(false);
    }

    public void tabSelected(TabSelectEvent evt) {
        String tabKey;
        this.clearGtEntityCache();
        switch (tabKey = evt.getTabKey()) {
            case "tabpageap_cross": {
                this.updateColorFieldGrid("entryentity_cross", "crosscolor", "crosscolorval");
                break;
            }
            case "tabpageap_color": {
                this.updateColorFieldGrid("holidayentry", "fcolor", "fcolorvalue");
                break;
            }
            case "tabpageap_dataline": {
                this.updateColorFieldGrid("datalineset", "linecolor", "linecolorvalue");
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (key = c.getKey()) {
            case "linecolorvalue": 
            case "fcolorvalue": 
            case "crosscolorval": {
                this.openColorForm(key);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs evt) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(evt);
        if (evt == null) {
            return;
        }
        super.propertyChanged(evt);
        IDataEntityProperty dataEntityProperty = evt.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (GanttSourceUtil.isEmptyString((String)propertyName)) {
            return;
        }
        for (ChangeData changeSet : changeDatas = evt.getChangeSet()) {
            this.propertyChanged(propertyName, changeSet);
        }
    }

    protected void propertyChanged(String propertyName, ChangeData changeSet) {
        switch (propertyName) {
            case "crossobj": {
                this.setFixedHightByGroupOrMilepost(changeSet);
                break;
            }
            case "crosscolorval": {
                this.updateCrossColorVal();
                break;
            }
            case "crosstype": {
                this.setTargetCrossIsNotLine(changeSet);
                break;
            }
            case "isline": {
                this.updateIsLineValue(changeSet);
                break;
            }
            case "fcolorvalue": {
                this.updateColorFieldGrid("holidayentry", "fcolor", "fcolorvalue");
                break;
            }
            case "linecolorvalue": {
                this.updateColorFieldGrid("datalineset", "linecolor", "linecolorvalue");
                break;
            }
            case "datalinetype": {
                this.setDataLine(changeSet);
            }
        }
    }

    private void setDataLine(ChangeData changeSet) {
        String newValue = (String)changeSet.getNewValue();
        if (StringUtils.equals((CharSequence)newValue, (CharSequence)"0") || StringUtils.equals((CharSequence)newValue, (CharSequence)"1")) {
            this.getView().setEnable(Boolean.valueOf(false), changeSet.getRowIndex(), new String[]{"isshowcurrent"});
            this.getModel().setValue("isshowcurrent", (Object)false, changeSet.getRowIndex());
        } else {
            DynamicObject rowObject = changeSet.getDataEntity();
            if (rowObject.getBoolean("isshow")) {
                this.getModel().setValue("isshowcurrent", (Object)true, changeSet.getRowIndex());
                this.getView().setEnable(Boolean.valueOf(true), changeSet.getRowIndex(), new String[]{"isshowcurrent"});
            }
        }
    }

    private void setFixedHightByGroupOrMilepost(ChangeData changeSet) {
        DynamicObject rowObject = changeSet.getDataEntity();
        String crossobj = rowObject.getString("crossobj");
        if (StringUtils.equals((CharSequence)crossobj, (CharSequence)"2") || StringUtils.equals((CharSequence)crossobj, (CharSequence)"4")) {
            this.getModel().setValue("height", (Object)20, changeSet.getRowIndex());
            this.getView().setEnable(Boolean.valueOf(false), changeSet.getRowIndex(), new String[]{"height"});
            if (StringUtils.equals((CharSequence)crossobj, (CharSequence)"4")) {
                this.getView().setEnable(Boolean.valueOf(false), changeSet.getRowIndex(), new String[]{"isline"});
            }
        } else {
            this.getModel().setValue("height", null, changeSet.getRowIndex());
            this.getView().setEnable(Boolean.valueOf(true), changeSet.getRowIndex(), new String[]{"height"});
        }
        if (StringUtils.equals((CharSequence)crossobj, (CharSequence)"2")) {
            this.getModel().setValue("crossshap", (Object)2, changeSet.getRowIndex());
        } else {
            this.getModel().setValue("crossshap", (Object)3, changeSet.getRowIndex());
        }
    }

    private void setTargetCrossIsNotLine(ChangeData changeSet) {
        DynamicObject newValue = (DynamicObject)changeSet.getNewValue();
        if (newValue != null && StringUtils.equals((CharSequence)newValue.getString("crosstype"), (CharSequence)"6")) {
            this.getModel().setValue("isline", (Object)Boolean.FALSE, changeSet.getRowIndex());
        }
    }

    private void updateIsLineValue(ChangeData changeSet) {
        Boolean newValue = (Boolean)changeSet.getNewValue();
        DynamicObject rowObject = changeSet.getDataEntity();
        if (newValue.booleanValue()) {
            String crossobj = rowObject.getString("crossobj");
            int count = this.getIsLineCount(changeSet.getRowIndex());
            if (count > 0 && !StringUtils.equals((CharSequence)crossobj, (CharSequence)"2") && !StringUtils.equals((CharSequence)crossobj, (CharSequence)"4")) {
                this.getModel().setValue("isline", (Object)Boolean.FALSE, changeSet.getRowIndex());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u4e00\u4e2a\u6a2a\u9053\u7c7b\u578b\u8fdb\u884c\u8fde\u7ebf\u3002", (String)"JobViewSchemPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject crosstype = rowObject.getDynamicObject("crosstype");
            if (crosstype != null && StringUtils.equals((CharSequence)crosstype.getString("crosstype"), (CharSequence)"6")) {
                this.getModel().setValue("isline", (Object)Boolean.FALSE, changeSet.getRowIndex());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u76ee\u6807\u6a2a\u9053\u4e0d\u80fd\u8bbe\u7f6e\u6a2a\u9053\u8fde\u7ebf\u3002", (String)"JobViewSchemPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            if (StringUtils.equals((CharSequence)crossobj, (CharSequence)"4")) {
                this.getModel().setValue("isline", (Object)Boolean.FALSE, changeSet.getRowIndex());
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6c47\u603b\u6a2a\u9053\u4e0d\u80fd\u8bbe\u7f6e\u6a2a\u9053\u8fde\u7ebf\u3002", (String)"JobViewSchemPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private int getIsLineCount(int rownum) {
        DynamicObjectCollection crossEntrys = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity_cross");
        int count = 0;
        for (int i = 0; i < crossEntrys.size(); ++i) {
            boolean flag;
            DynamicObject crossEntry = (DynamicObject)crossEntrys.get(i);
            String crossObj = crossEntry.getString("crossobj");
            boolean isLine = crossEntry.getBoolean("isline");
            boolean bl = flag = (StringUtils.equals((CharSequence)crossObj, (CharSequence)"1") || StringUtils.equals((CharSequence)crossObj, (CharSequence)"3") || StringUtils.equals((CharSequence)crossObj, (CharSequence)"6")) && isLine && i != rownum;
            if (!flag) continue;
            ++count;
        }
        return count;
    }

    private void updateCrossColorVal() {
        this.updateColorFieldGrid("entryentity_cross", "crosscolor", "crosscolorval");
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        Object returnData = evt.getReturnData();
        if (actionId.startsWith("callback_color_") && returnData != null) {
            this.callBackFieldColorProp(actionId, String.valueOf(returnData));
        }
    }

    private void callBackFieldColorProp(String actionId, String fieldId) {
        String fieldname = actionId.replace("callback_color_", "");
        this.setFieldColorProp(fieldId, fieldname);
    }

    private void setFieldColorProp(String reData, String fieldname) {
        String entity = this.getEntityName(fieldname);
        int row = this.getModel().getEntryCurrentRowIndex(entity);
        IDataModel md = this.getModel();
        switch (fieldname) {
            case "fcolorvalue": 
            case "linecolorvalue": 
            case "crosscolorval": {
                md.setValue(fieldname, (Object)reData, row);
                break;
            }
        }
    }

    private String getEntityName(String fieldname) {
        String entity = "";
        switch (fieldname) {
            case "crosscolorval": {
                entity = "entryentity_cross";
                break;
            }
            case "fcolorvalue": {
                entity = "holidayentry";
                break;
            }
            case "linecolorvalue": {
                entity = "datalineset";
                break;
            }
        }
        return entity;
    }

    private void clearGtEntityCache() {
        this.getPageCache().remove(CACHE_GTENTITY_TREE);
    }

    private void openColorForm(String key) {
        String entity = this.getEntityName(key);
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entity);
        String fieldName = GanttSourceUtil.getDataModelStringData((IDataModel)this.getModel(), (String)key, (int)rowIndex);
        HashMap<String, String> customParams = new HashMap<String, String>(2);
        customParams.put("color", fieldName);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, this.getCallColorKey(key));
        FormShowParameter formShowParameter = GanttSourceUtil.assembleShowFormParam((String)COLOR_SELECT, customParams, (CloseCallBack)closeCallBack, (ShowType)ShowType.Modal);
        formShowParameter.setShowTitle(Boolean.FALSE.booleanValue());
        formShowParameter.setShowClose(Boolean.FALSE.booleanValue());
        this.getView().showForm(formShowParameter);
    }

    private String getCallColorKey(String fieldname) {
        return "callback_color_" + fieldname;
    }

    public void updateColorFieldGrid(String entryKey, String colorField, String colorValField) {
        IFormView fv = this.getView();
        IDataModel dm = fv.getModel();
        EntryGrid entryGrid = (EntryGrid)fv.getControl(entryKey);
        if (entryGrid == null) {
            return;
        }
        DynamicObjectCollection colls = dm.getEntryEntity(entryKey);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>(colls.size());
        String defForceColor = "#ffffff";
        String defBackColor = "#ffffff";
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject rowObj = (DynamicObject)colls.get(i);
            Object colorVal = rowObj.get(colorValField);
            CellStyle cell = this.getCellStyle(i, colorField);
            if (colorVal instanceof String && !StringUtils.equals((CharSequence)String.valueOf(colorVal), (CharSequence)"")) {
                cell.setBackColor((String)colorVal);
                cell.setForeColor((String)colorVal);
            } else {
                cell.setBackColor(defForceColor);
                cell.setForeColor(defBackColor);
            }
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
        }
    }

    private CellStyle getCellStyle(int rowIndex, String fieldKey) {
        CellStyle cell = new CellStyle();
        cell.setFieldKey(fieldKey);
        cell.setRow(rowIndex);
        return cell;
    }
}

