/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.gantt;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.common.consts.SyncDataSourceConst;
import kd.mpscmm.common.util.FiledSetUtil;

public class SyncDataSourceEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        BasedataEdit datasource = (BasedataEdit)this.getControl("datasource");
        if (datasource != null) {
            datasource.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"btnok"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"datasource")) {
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        boolean isOpen = (Boolean)changeData[0].getNewValue();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"crossset")) {
            this.getView().setVisible(Boolean.valueOf(isOpen), new String[]{"crosscontententry", "crossmoveentry", "crossiconset"});
        } else if (StringUtils.equals((CharSequence)name, (CharSequence)"entityfilter")) {
            this.getView().setVisible(Boolean.valueOf(isOpen), new String[]{"subentryentity"});
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"crosscontententry", "crossmoveentry", "crossiconset", "subentryentity"});
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String sourceID = evt.getProperty().getName();
        if (sourceID.equals("datasource")) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject taskEntity = (DynamicObject)this.getView().getParentView().getModel().getValue("taskentity");
            showParameter.setShowApproved(false);
            showParameter.setCustomParam("taskEntity", (Object)taskEntity.getString("number"));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)key)) {
            MulBasedataDynamicObjectCollection datasource = (MulBasedataDynamicObjectCollection)this.getModel().getValue("datasource");
            if (datasource == null || datasource.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u6e90\u3002", (String)"SyncDataSourceEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            boolean isopen = false;
            for (String entryName : SyncDataSourceConst.ENTRYNAMELIST) {
                isopen = (Boolean)this.getModel().getValue(entryName);
                if (!isopen) continue;
                break;
            }
            if (!isopen) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u6e90\u9875\u7b7e\u3002", (String)"SyncDataSourceEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            String message = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u540c\u6b65\u5c06\u4ee5\u5f53\u524d\u6570\u636e\u6e90\u7684\u914d\u7f6e\u8986\u76d6\u6240\u9009\u6570\u636e\u6e90\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SyncDataSourceEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("syncDataSource", (IFormPlugin)this);
            this.getView().showConfirm(message, MessageBoxOptions.OKCancel, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (messageBoxClosedEvent.getCallBackId().equals("syncDataSource") && messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
            MulBasedataDynamicObjectCollection datasource = (MulBasedataDynamicObjectCollection)this.getModel().getValue("datasource");
            ArrayList<String> newEntryNameList = new ArrayList<String>(10);
            HashMap<String, Object> subEntryMap = new HashMap<String, Object>();
            for (String entryName : SyncDataSourceConst.ENTRYNAMELIST) {
                boolean isopen = (Boolean)this.getModel().getValue(entryName);
                if (!isopen) continue;
                newEntryNameList.add(entryName);
                List subEntries = (List)SyncDataSourceConst.map.get(entryName);
                if (subEntries == null) continue;
                ArrayList subEntryNames = new ArrayList(subEntries.size());
                for (String subEntry : subEntries) {
                    isopen = (Boolean)this.getModel().getValue(subEntry);
                    if (!isopen) continue;
                    subEntryNames.add(subEntry);
                }
                if (subEntryNames.size() <= 0) continue;
                subEntryMap.put(entryName, subEntryNames);
            }
            Date date = new Date();
            int size = datasource.size();
            ArrayList<Long> idlist = new ArrayList<Long>(size);
            for (DynamicObject object : datasource) {
                DynamicObject ganttDataSource = object.getDynamicObject("fbasedataid");
                idlist.add(ganttDataSource.getLong("id"));
            }
            DynamicObject[] ganttDataSources = (DynamicObject[])BusinessDataServiceHelper.load((Object[])idlist.toArray(), (IDataEntityType)BusinessDataServiceHelper.newDynamicObject((String)"msplan_gantt_source").getDataEntityType());
            try (TXHandle h0 = TX.required((String)"syncDataSource");){
                try {
                    for (DynamicObject ganttDataSource : ganttDataSources) {
                        for (String entryName : newEntryNameList) {
                            DynamicObjectCollection presentEntrys = this.getView().getParentView().getModel().getEntryEntity(entryName);
                            DynamicObjectCollection newEntrys = ganttDataSource.getDynamicObjectCollection(entryName);
                            List fields = (List)SyncDataSourceConst.filedMap.get(entryName);
                            for (DynamicObject presentEntry : presentEntrys) {
                                boolean flag = false;
                                for (DynamicObject newEntry : newEntrys) {
                                    int index = 0;
                                    for (String field : fields) {
                                        if (newEntry.get(field) == null && presentEntry.get(field) == null) {
                                            ++index;
                                            continue;
                                        }
                                        if (newEntry.get(field) == null || presentEntry.get(field) == null) continue;
                                        if (newEntry.get(field) instanceof DynamicObject && presentEntry.get(field) instanceof DynamicObject) {
                                            if (!newEntry.getDynamicObject(field).getString("number").equals(presentEntry.getDynamicObject(field).getString("number"))) continue;
                                            ++index;
                                            continue;
                                        }
                                        if (!newEntry.getString(field).equals(presentEntry.getString(field))) continue;
                                        ++index;
                                    }
                                    if (index != fields.size()) continue;
                                    FiledSetUtil.setFiledData((DynamicObject)presentEntry, (DynamicObject)newEntry, (List)SyncDataSourceConst.noSetFileds);
                                    this.setSubEntryData(newEntry, (List)subEntryMap.get(entryName), SyncDataSourceConst.noSetFileds, presentEntry);
                                    flag = true;
                                }
                                if (flag) continue;
                                DynamicObject newRow = newEntrys.addNew();
                                FiledSetUtil.setFiledData((DynamicObject)presentEntry, (DynamicObject)newRow, (List)SyncDataSourceConst.noSetFileds);
                                newRow.set("seq", (Object)newEntrys.size());
                                this.setSubEntryData(newRow, (List)SyncDataSourceConst.map.get(entryName), SyncDataSourceConst.noSetFileds, presentEntry);
                            }
                            ganttDataSource.set(entryName, (Object)newEntrys);
                        }
                        ganttDataSource.set("modifier", (Object)RequestContext.get().getCurrUserId());
                        ganttDataSource.set("modifytime", (Object)date);
                        if (newEntryNameList.contains("highlightgroupentry")) {
                            ganttDataSource.set("highcolorvalue", this.getView().getParentView().getModel().getValue("highcolorvalue"));
                            continue;
                        }
                        if (!newEntryNameList.contains("colorentryentity")) continue;
                        DynamicObjectCollection colorentrycolls = (DynamicObjectCollection)this.getView().getParentView().getModel().getValue("colorentryentity");
                        DynamicObjectCollection colls = ganttDataSource.getDynamicObjectCollection("colorentryentity");
                        colls.clear();
                        for (DynamicObject obj : colorentrycolls) {
                            obj.setParent(ganttDataSource.getPkValue());
                            obj.set("id", null);
                        }
                        for (DynamicObject obj : colorentrycolls) {
                            DynamicObject newObj = colls.addNew();
                            newObj.set("colorconditon", obj.get("colorconditon"));
                            newObj.set("colorvalue", obj.get("colorvalue"));
                            newObj.set("color", obj.get("color"));
                            newObj.set("remark", obj.get("remark"));
                            newObj.set("colorcondfilter", obj.get("colorcondfilter"));
                            newObj.set("colorcondfilter_tag", obj.get("colorcondfilter_tag"));
                        }
                    }
                    SaveServiceHelper.save((DynamicObject[])ganttDataSources);
                }
                catch (Throwable throwable) {
                    h0.markRollback();
                    throw throwable;
                }
                this.getView().invokeOperation("syncdatasource");
                this.getView().returnDataToParent((Object)ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"SyncDataSourceEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                this.getView().close();
            }
        }
    }

    private void setSubEntryData(DynamicObject newEntry, List<String> subEntryNameList, List<String> noSetFileds, DynamicObject presentEntry) {
        if (subEntryNameList == null) {
            return;
        }
        for (String subEntryName : subEntryNameList) {
            DynamicObjectCollection subPresentEntrys = presentEntry.getDynamicObjectCollection(subEntryName);
            DynamicObjectCollection subNewEntrys = newEntry.getDynamicObjectCollection(subEntryName);
            subNewEntrys.clear();
            FiledSetUtil.setEntryDatas((DynamicObjectCollection)subPresentEntrys, (DynamicObjectCollection)subNewEntrys, noSetFileds);
            newEntry.set(subEntryName, (Object)subNewEntrys);
        }
    }
}

