/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.mrp.business.helper.BOTPHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanOrderAllDropBatchDrop
extends AbstractFormPlugin
implements ProgresssListener {
    public static final String ALLDROPSTATUSSELECT = "alldropstatusselect";
    private static final Log logger = LogFactory.getLog(PlanOrderAllDropBatchDrop.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String ONETOONE = "OneToOne";
    private static final String CACHEKEY_TIP = "tip";
    private static final String CACHEKEY_PROGRESS = "progress";
    private static final String DROP_COUNT = "dropcount";
    private static final String DROP_SUM = "dropnumber";
    private static final String DROP_SUCCESS_COUNT = "dropsuccesscount";
    private static final String DROP_SUCCESS_BIllNO = "dropsuccessbillno";
    private static final String DROP_FAILD_COUNT = "dropfaildcount";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMSG = "errorMsg";
    private String dropstatus;

    public String getDropstatus() {
        return this.dropstatus;
    }

    public void setDropstatus(String dropstatus) {
        this.dropstatus = dropstatus;
    }

    private String getTip() {
        String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6295\u653e%1$d/%2$d\u6761", (String)"PlanOrderAllDropBatchDrop_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getDropCount(), this.getDropSum());
        return tip;
    }

    private int getProgress() {
        int sum;
        int count = StringUtils.isBlank((Object)this.getDropCount()) ? 0 : this.getDropCount();
        int n = sum = StringUtils.isBlank((Object)this.getDropSum()) ? 0 : this.getDropSum();
        if (sum == 0) {
            return 0;
        }
        return count * 100 / sum;
    }

    private synchronized void setDropCount(int dropcount) {
        int olddropcount = this.getDropCount();
        int oldcount = StringUtils.isBlank((Object)olddropcount) ? 0 : olddropcount;
        this.getPageCache().put(DROP_COUNT, String.valueOf(oldcount + dropcount));
    }

    private synchronized int getDropCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(DROP_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(DROP_COUNT));
    }

    private void setDropSum(int dropsum) {
        this.getPageCache().put(DROP_SUM, String.valueOf(dropsum));
    }

    private int getDropSum() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(DROP_SUM)) ? 0 : Integer.parseInt(this.getPageCache().get(DROP_SUM));
    }

    private synchronized void setDropSuccessCount(int dropsuccesscount, String dropSuccessBillno) {
        int olddropsuccesscount = this.getDropSuccessCount();
        int oldsuccesscount = StringUtils.isBlank((Object)olddropsuccesscount) ? 0 : olddropsuccesscount;
        this.getPageCache().put(DROP_SUCCESS_COUNT, String.valueOf(dropsuccesscount + oldsuccesscount));
        String billno = this.getDropSuccessBillno();
        if (StringUtils.isBlank((CharSequence)billno)) {
            this.getPageCache().put(DROP_SUCCESS_BIllNO, dropSuccessBillno);
        } else {
            this.getPageCache().put(DROP_SUCCESS_BIllNO, String.valueOf(billno + "###" + dropSuccessBillno));
        }
    }

    private String getDropSuccessBillno() {
        return this.getPageCache().get(DROP_SUCCESS_BIllNO);
    }

    private int getDropSuccessCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(DROP_SUCCESS_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(DROP_SUCCESS_COUNT));
    }

    private synchronized void setDropFaildCount(int dropfaildcount) {
        int olddropfaildcount = this.getDropFaildCount();
        int oldfaildcount = StringUtils.isBlank((Object)olddropfaildcount) ? 0 : olddropfaildcount;
        this.getPageCache().put(DROP_FAILD_COUNT, String.valueOf(dropfaildcount + oldfaildcount));
    }

    private synchronized int getDropFaildCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(DROP_FAILD_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(DROP_FAILD_COUNT));
    }

    private synchronized void setError(String errorMsg) {
        this.getPageCache().put(CACHEKEY_ERROR, String.valueOf(true));
        if (this.getPageCache().get(CACHEKEY_ERRORMSG) != null) {
            String error = this.getPageCache().get(CACHEKEY_ERRORMSG);
            StringBuilder sb = new StringBuilder();
            sb.append(error);
            sb.append("###");
            sb.append(errorMsg);
            this.getPageCache().put(CACHEKEY_ERRORMSG, sb.toString());
        } else {
            this.getPageCache().put(CACHEKEY_ERRORMSG, errorMsg);
        }
    }

    private void settaskid(String taskid) {
        this.getPageCache().put("taskid", taskid);
    }

    private String gettaskid() {
        return this.getPageCache().get("taskid");
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    private void execute(List<Map<String, Object>> allDropList, ConvertRuleElement loadRule, DynamicObject dropConfigure, List<Long> planorderIds) {
        String threadname = Thread.currentThread().getName();
        if (allDropList != null) {
            logger.info(String.format("\u5f00\u59cb\u5904\u7406\u8ba1\u5212\u8ba2\u5355\u6570\u636e\uff0c\u6570\u636e\u91cf\u4e3a%s", allDropList.size()));
        }
        long starttime = System.currentTimeMillis();
        String targetEntity = null;
        String entityNumber = this.getEntityNumber();
        if (loadRule != null) {
            targetEntity = loadRule.getTargetEntityNumber();
        }
        if (allDropList != null && allDropList.size() > 0) {
            this.settaskid(String.valueOf(allDropList.size()));
            HashMap planOrderIdQtyMap = Maps.newHashMapWithExpectedSize((int)allDropList.size());
            HashMap planOrderIdBillNo = Maps.newHashMapWithExpectedSize((int)allDropList.size());
            for (Map<String, Object> map : allDropList) {
                Long id = Long.valueOf(map.get("id").toString());
                if (!planorderIds.contains(id)) continue;
                planOrderIdBillNo.put(id, map.get("billno").toString());
                Object qtyOjb = map.get("qty");
                if (qtyOjb == null) continue;
                BigDecimal qty = new BigDecimal(qtyOjb.toString());
                planOrderIdQtyMap.put(id, qty);
            }
            try {
                Map result = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IPlanOrderDropService", (String)"dropPlanOrder", (Object[])new Object[]{planorderIds, entityNumber, dropConfigure, planOrderIdQtyMap, loadRule});
                Map errorMap = (Map)result.get(CACHEKEY_ERROR);
                List successIds = (List)result.get("success");
                for (Long planOrderId : planorderIds) {
                    if (errorMap.containsKey(planOrderId)) {
                        String error = (String)errorMap.get(planOrderId);
                        this.setError(error);
                        this.setDropFaildCount(1);
                        this.setDropCount(1);
                        continue;
                    }
                    if (successIds.contains(planOrderId)) {
                        this.setDropCount(1);
                        this.setDropSuccessCount(1, (String)planOrderIdBillNo.get(planOrderId));
                        continue;
                    }
                    this.setDropFaildCount(1);
                    this.setDropCount(1);
                }
            }
            catch (Exception ex) {
                int size = planorderIds.size();
                this.setError(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u5931\u8d25%s\u3002", (String)"PlanOrderAllDropBatchDrop_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ex.getMessage()));
                this.setDropFaildCount(size);
                this.setDropCount(size);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        long endtime = System.currentTimeMillis();
        logger.info("\u8ba1\u5212\u8ba2\u5355\u4fdd\u5b58\u6210\u529f" + targetEntity + "\u8017\u65f6" + (endtime - starttime) + "ms");
        logger.info("\u7ebf\u7a0b" + threadname + "\u7684\u7ed3\u675f\u65f6\u95f4\u4e3a" + new Date());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u5f00\u59cb\u65f6\u95f4%s", System.currentTimeMillis()));
        List selectDatas = (List)formShowParameter.getCustomParam(ALLDROPSTATUSSELECT);
        String jsonStr = SerializationUtils.toJsonString((Object)selectDatas);
        this.getPageCache().put("alldroplist", jsonStr);
        logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u7b2c\u4e8c\u6b21\u5e8f\u5217\u5316\u65f6\u95f4%s", System.currentTimeMillis()));
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        this.settaskid("-1");
        progressBar.start();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        Label lblTip;
        int progress = this.getProgress();
        if (progress == 0) {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(ResManager.loadKDString((String)"\u51c6\u5907\u6295\u653e...", (String)"PlanOrderAllDropBatchDrop_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            paramProgressEvent.setProgress(0);
            logger.info("\u8ba1\u5212\u8ba2\u5355\u6295\u653e");
        } else {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(this.getTip());
            paramProgressEvent.setProgress(this.getProgress());
        }
        if ("0".equals(this.gettaskid())) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.stop();
        } else if ("-1".equals(this.gettaskid())) {
            this.settaskid("-2");
            logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u5f00\u59cb\u65f6\u95f4%s", System.currentTimeMillis()));
            String jsonStr = this.getPageCache().get("alldroplist");
            long starttime = System.currentTimeMillis();
            List list = SerializationUtils.fromJsonStringToList((String)jsonStr, Map.class);
            logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u7b2c\u4e09\u6b21\u5e8f\u5217\u5316\u65f6\u95f4%s", System.currentTimeMillis()));
            long endtime = System.currentTimeMillis();
            if (list != null && list.size() > 0) {
                logger.info("\u5904\u7406\u8ba1\u5212\u8ba2\u5355\u96c6\u5408\u8f6c\u6362\u8017\u65f6" + (endtime - starttime) + "ms");
                this.setDropSum(list.size());
                String targetEntity = null;
                FormShowParameter formShowParameter = this.getView().getFormShowParameter();
                String billtoconfig = (String)formShowParameter.getCustomParam("billtoconfig");
                String dropconf = (String)formShowParameter.getCustomParam("dropconf");
                String entityNumber = this.getEntityNumber();
                ConvertRuleElement loadRule = null;
                DynamicObject dropConfigure = null;
                if (billtoconfig != null) {
                    loadRule = ConvertMetaServiceHelper.loadRule((String)billtoconfig);
                    targetEntity = loadRule.getTargetEntityNumber();
                    dropConfigure = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(dropconf), (String)"msplan_dropconfigure");
                } else {
                    String ordertype = (String)formShowParameter.getCustomParam("ordertype");
                    String purorg = (String)formShowParameter.getCustomParam("proorpurorg");
                    dropConfigure = PlanOrderHelper.getDropConfigure((Long)Long.valueOf(purorg), (IPageCache)this.getPageCache());
                    targetEntity = PlanOrderHelper.getTargetEntityByorderType((String)ordertype, (DynamicObject)dropConfigure);
                    List rules = BOTPHelper.getRules((String)entityNumber, (String)targetEntity);
                    if ((rules = BOTPHelper.excludeConvertRuleByOrdertype((List)rules, (String)ordertype)) != null && rules.size() > 0) {
                        for (ConvertRuleElement loadrule : rules) {
                            billtoconfig = loadrule.getId();
                            loadRule = loadrule;
                            targetEntity = loadRule.getTargetEntityNumber();
                        }
                    }
                }
                if (loadRule == null || loadRule.getGroupByPolicy() == null) {
                    this.runPool(list, loadRule, dropConfigure);
                    return;
                }
                String groupMode = loadRule.getGroupByPolicy().getGroupMode();
                String groupMode2 = loadRule.getGroupByPolicy().getGroupMode();
                String groupMode3 = loadRule.getGroupByPolicy().getGroupMode();
                if (!(ONETOONE.equals(groupMode) && ONETOONE.equals(groupMode2) && ONETOONE.equals(groupMode3))) {
                    this.runPool(list, loadRule, dropConfigure);
                } else {
                    this.runAssignPool(list, loadRule, dropConfigure);
                }
            }
        }
        int count = this.getDropCount();
        int sum = this.getDropSum();
        if (count != 0 && sum != 0 && count == sum) {
            Label lblTip2 = (Label)this.getControl("labelap");
            lblTip2.setText(String.format(ResManager.loadKDString((String)"\u6295\u653e\u603b\u6570\uff1a%1$s\uff0c\u5df2\u6295\u653e\uff1a%2$s\uff0c\u6295\u653e\u5931\u8d25\uff1a%3$s\u3002", (String)"PlanOrderAllDropBatchDrop_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getDropSum(), this.getDropSuccessCount(), this.getDropFaildCount()));
            String error = this.getPageCache().get(CACHEKEY_ERROR);
            if (Boolean.parseBoolean(error)) {
                this.errorMsg();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u6295\u653e\u3002", (String)"PlanOrderAllDropBatchDrop_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            this.settaskid("0");
        }
    }

    private void runAssignPool(List<Map<String, Object>> list, ConvertRuleElement loadRule, DynamicObject dropConfigure) {
        int batchQty = dropConfigure.getInt("batchqty");
        int threadCount = dropConfigure.getInt("threadcount");
        String targetEntity = loadRule.getTargetEntityNumber();
        int batchSaveQty = PlanOrderHelper.getBatchSaveQty((String)targetEntity, (DynamicObject)dropConfigure);
        if (batchSaveQty > 0) {
            batchQty = batchSaveQty;
        }
        ArrayList<Long> planOrderIds = new ArrayList<Long>(list.size());
        for (Map<String, Object> map : list) {
            Long id = Long.valueOf(map.get("id").toString());
            planOrderIds.add(id);
        }
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)("PlanOrder-dropbatch-onProgress-" + UUID.randomUUID()), (int)Integer.getInteger("paln.order.dropbatch.poolsize", threadCount));
        int averageNum = list.size() % batchQty == 0 ? list.size() / batchQty : list.size() / batchQty + 1;
        List averagelist = PlanOrderAllDropBatchDrop.averageAssign(planOrderIds, averageNum);
        for (List average : averagelist) {
            pool.execute(() -> this.execute(list, loadRule, dropConfigure, average));
        }
        pool.close();
    }

    private void runPool(List<Map<String, Object>> list, ConvertRuleElement loadRule, DynamicObject defDropConfigure) {
        int threadCount = 1;
        if (defDropConfigure != null) {
            threadCount = defDropConfigure.getInt("threadcount");
        }
        String entityNumber = this.getEntityNumber();
        ArrayList<Long> planOrderIds = new ArrayList<Long>(list.size());
        HashMap planOrderIdQtyMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Map<String, Object> map : list) {
            Long id = Long.valueOf(map.get("id").toString());
            planOrderIds.add(id);
            Object qtyObj = map.get("qty");
            if (qtyObj == null) continue;
            BigDecimal qty = new BigDecimal(qtyObj.toString());
            planOrderIdQtyMap.put(id, qty);
        }
        StringBuilder selectfield = new StringBuilder("id,billno,ordertype,proorpurorg,dropqty,orderqty,billtype,billstatus,org,planscope,material,unit,configuredcode,supplier,planoperatenum,tracknumber,ordertype");
        DynamicObject[] orders = BusinessDataServiceHelper.load((String)entityNumber, (String)selectfield.toString(), (QFilter[])new QFilter[]{new QFilter("id", "in", planOrderIds)});
        HashMap orgOrderIdByTypeMaps = Maps.newHashMapWithExpectedSize((int)orders.length);
        HashMap orderIdByTypeMaps = Maps.newHashMapWithExpectedSize((int)orders.length);
        HashMap orderIdBillNoMap = Maps.newHashMapWithExpectedSize((int)orders.length);
        HashMap orderIdloadRuleMap = Maps.newHashMapWithExpectedSize((int)orders.length);
        Map<Long, DynamicObject> orderMap = Arrays.stream(orders).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        Long defOrg = 0L;
        for (DynamicObject order : orders) {
            String ordertype = order.getString("ordertype");
            if (StringUtils.isBlank((CharSequence)ordertype)) continue;
            Long orderId = order.getLong("id");
            List orderIds = orderIdByTypeMaps.computeIfAbsent(ordertype, k -> new ArrayList());
            orderIds.add(orderId);
            Long proorpurorg = order.getDynamicObject("proorpurorg").getLong("id");
            Map map = orgOrderIdByTypeMaps.computeIfAbsent(proorpurorg, k -> new HashMap());
            List orderIdLists = map.computeIfAbsent(ordertype, k -> new ArrayList());
            orderIdLists.add(orderId);
            map.put(ordertype, orderIdLists);
            orgOrderIdByTypeMaps.put(proorpurorg, map);
            if (loadRule != null) {
                orderIdloadRuleMap.put(ordertype, loadRule);
            }
            defOrg = proorpurorg;
            orderIdBillNoMap.put(orderId, order.getString("billno"));
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = new QFilter("createorg", "in", orgOrderIdByTypeMaps.keySet());
        QFilter qFilterCtrlstrategy = new QFilter("ctrlstrategy", "=", (Object)"7");
        if (orgOrderIdByTypeMaps.size() > 1 && QueryServiceHelper.exists((String)"msplan_dropconfigure", (QFilter[])new QFilter[]{qFilterOrg, qFilterStatus, qFilterEnable, qFilterCtrlstrategy})) {
            for (Map.Entry map : orgOrderIdByTypeMaps.entrySet()) {
                Long proorpurorg = (Long)map.getKey();
                for (Map.Entry entry : ((Map)map.getValue()).entrySet()) {
                    String ordertype = (String)entry.getKey();
                    List orderIdsList = (List)entry.getValue();
                    this.poolPlanOrderData(proorpurorg, ordertype, orderIdsList, defDropConfigure, threadCount, orderIdBillNoMap, orderMap, entityNumber, planOrderIdQtyMap, orderIdloadRuleMap, list, loadRule);
                }
            }
        } else {
            for (Map.Entry entry : orderIdByTypeMaps.entrySet()) {
                String ordertype = (String)entry.getKey();
                List orderIdsList = (List)entry.getValue();
                this.poolPlanOrderData(defOrg, ordertype, orderIdsList, defDropConfigure, threadCount, orderIdBillNoMap, orderMap, entityNumber, planOrderIdQtyMap, orderIdloadRuleMap, list, loadRule);
            }
        }
    }

    private void poolPlanOrderData(Long proorpurorg, String ordertype, List<Long> orderIdsList, DynamicObject defDropConfigure, int threadCount, Map<Long, String> orderIdBillNoMap, Map<Long, DynamicObject> orderMap, String entityNumber, Map<Long, BigDecimal> planOrderIdQtyMap, Map<String, ConvertRuleElement> orderIdloadRuleMap, List<Map<String, Object>> list, ConvertRuleElement loadRule) {
        ThreadPool pool = ThreadPools.newFixedThreadPool((String)("PlanOrder-dropbatch-onProgress-" + UUID.randomUUID()), (int)Integer.getInteger("paln.order.dropbatch.poolsize", threadCount));
        pool.execute(() -> {
            DynamicObject dropConfigure = null;
            dropConfigure = defDropConfigure == null ? PlanOrderHelper.getDropConfigure((Long)proorpurorg, null) : defDropConfigure;
            HashMap errorMap = Maps.newHashMapWithExpectedSize((int)orderIdsList.size());
            if (dropConfigure == null) {
                String error = ResManager.loadKDString((String)"\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u672a\u5339\u914d\u5230\u76f8\u5e94\u7684\u6295\u653e\u914d\u7f6e\u3002", (String)"PlanOrderAllDropBatchDrop_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                for (Long planorderId : orderIdsList) {
                    String errorStr = String.format(error, orderIdBillNoMap.get(planorderId));
                    this.setError(errorStr);
                    this.setDropFaildCount(1);
                    this.setDropCount(1);
                    errorMap.put(planorderId, errorStr);
                }
                PlanOrderHelper.recordDropFailLog((List)orderIdsList, (Map)errorMap, (Map)orderMap, (String)entityNumber, (Map)planOrderIdQtyMap);
                return;
            }
            String targetEntity = PlanOrderHelper.getTargetEntityByorderType((String)ordertype, (DynamicObject)dropConfigure);
            int batchQty = dropConfigure.getInt("batchqty");
            if (orderIdloadRuleMap.get(ordertype) == null) {
                List rules = BOTPHelper.getRules((String)entityNumber, (String)targetEntity);
                Map ruleIds = BOTPHelper.excludeConvertRule((List)rules, (List)orderIdsList, (String)entityNumber);
                if (orderIdsList != null && orderIdsList.size() > 0) {
                    String error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e\u4e0b\u6e38\u5355\u636e\u65f6\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u4e0d\u5b58\u5728\u5339\u914d\u7684\u8f6c\u6362\u89c4\u5219\uff0c\u6216\u8005\u539f\u59cb\u8f6c\u6362\u89c4\u5219\u88ab\u7981\u7528\u3002", (String)"PlanOrderAllDropBatchDrop_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    for (Long planorderId : orderIdsList) {
                        String errorStr = String.format(error, orderIdBillNoMap.get(planorderId));
                        this.setError(errorStr);
                        this.setDropFaildCount(1);
                        this.setDropCount(1);
                        errorMap.put(planorderId, errorStr);
                    }
                    PlanOrderHelper.recordDropFailLog((List)orderIdsList, (Map)errorMap, (Map)orderMap, (String)entityNumber, (Map)planOrderIdQtyMap);
                }
                for (Map.Entry rule : ruleIds.entrySet()) {
                    ConvertRuleElement key = (ConvertRuleElement)rule.getKey();
                    ArrayList<Long> planorderIds = new ArrayList<Long>((Collection)rule.getValue());
                    this.dealPlanOrderData(key, targetEntity, dropConfigure, list, batchQty, planorderIds);
                }
            } else {
                this.dealPlanOrderData(loadRule, targetEntity, dropConfigure, list, batchQty, orderIdsList);
            }
        });
        pool.close();
    }

    private void dealPlanOrderData(ConvertRuleElement loadRule, String targetEntity, DynamicObject dropConfigure, List<Map<String, Object>> list, int batchQty, List<Long> planorderIds) {
        boolean isBatchDrop = true;
        if (loadRule.getGroupByPolicy() != null) {
            String groupMode = loadRule.getGroupByPolicy().getGroupMode();
            String groupMode2 = loadRule.getGroupByPolicy().getGroupMode();
            String groupMode3 = loadRule.getGroupByPolicy().getGroupMode();
            if (!(ONETOONE.equals(groupMode) && ONETOONE.equals(groupMode2) && ONETOONE.equals(groupMode3))) {
                isBatchDrop = false;
            }
        }
        if (isBatchDrop) {
            int batchSaveQty = PlanOrderHelper.getBatchSaveQty((String)targetEntity, (DynamicObject)dropConfigure);
            if (batchSaveQty > 0) {
                batchQty = batchSaveQty;
            }
            int averageNum = list.size() % batchQty == 0 ? list.size() / batchQty : list.size() / batchQty + 1;
            List<List<Long>> averagelist = PlanOrderAllDropBatchDrop.averageAssign(planorderIds, averageNum);
            for (List<Long> average : averagelist) {
                this.execute(list, loadRule, dropConfigure, average);
            }
        } else {
            this.execute(list, loadRule, dropConfigure, planorderIds);
        }
    }

    private void errorMsg() {
        int i;
        int dropSum = this.getDropSum();
        if (dropSum == 0) {
            return;
        }
        String errormsgs = this.getPageCache().get(CACHEKEY_ERRORMSG);
        String successBillNO = this.getDropSuccessBillno();
        IFormView entryView = this.getView();
        OperationResult operationResult = new OperationResult();
        String operateName = ResManager.loadKDString((String)"\u5df2\u6295\u653e\u7ed3\u679c\uff1a", (String)"PlanOrderAllDropBatchDrop_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        operationResult.setBillCount(dropSum);
        ArrayList<String> successIndexs = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)successBillNO)) {
            String[] successBillNOs = successBillNO.split("###");
            for (i = 0; i < successBillNOs.length; ++i) {
                successIndexs.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u201c%s\u201d\u5df2\u6295\u653e\u3002", (String)"PlanOrderAllDropBatchDrop_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), successBillNOs[i]));
            }
        }
        operationResult.setSuccessPkIds(successIndexs);
        if (errormsgs == null) {
            return;
        }
        String[] errormsg = errormsgs.split("###");
        for (i = 0; i < errormsg.length; ++i) {
            String error = errormsg[i];
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, (Object)i);
            operateErrorInfo.setMessage(error);
            operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6295\u653e", (String)"PlanOrderAllDropBatchDrop_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"PlanOrderAllDropBatchDrop_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        entryView.showOperationResult(operationResult, operateName);
    }

    private String getEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entitynumber = (String)formShowParameter.getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            entitynumber = "mrp_planorder";
        }
        return entitynumber;
    }
}

