/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.mpscmm.msplan.formplugin.batchupd.BatchUpdateFactory;
import kd.mpscmm.msplan.formplugin.batchupd.BatchUpdateService;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanOrderBatchUpdPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log logger = LogFactory.getLog(PlanOrderBatchUpdPlugin.class);
    private static final String PROGRESSBARAP = "progressbarap";
    private static final String BATCHUPDFIELD = "batchupdfield";
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private final int count = 200;
    private static final String BATCHUPD_COUNT = "batchupdcount";
    private static final String BATCHUPD_SUM = "batchupdnumber";
    private static final String BATCHUPD_SUCCESS_COUNT = "batchupdsuccesscount";
    private static final String BATCHUPD_SUCCESS_BIllNO = "batchupdsuccessbillno";
    private static final String BATCHUPD_FAILD_COUNT = "batchupdfaildcount";
    private static final String BATCHOPERA = "batchopera";
    private static final String NEWVALUE = "newvalue";
    private static final String ENTITYNUMBER = "entitynumber";
    private static final String MSPLAN_BATCH_EDIT = "msplan_batch_edit";
    private static final String MSPLAN_BATCHUPDFIELD = "msplan_batchupdfield";
    private static final String CACHEKEY_ERROR = "error";
    private static final String CACHEKEY_ERRORMSG = "errorMsg";
    private BatchUpdateService batchUpdateService;

    public void initialize() {
        String pluginType = (String)this.getView().getFormShowParameter().getCustomParam(ENTITYNUMBER);
        this.batchUpdateService = BatchUpdateFactory.buildPlugin(pluginType);
    }

    private String getTip() {
        String tip = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6279\u91cf\u4fee\u6539%1$d/%2$d\u6761", (String)"PlanOrderBatchUpdPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getDropCount(), this.getDropSum());
        return tip;
    }

    private int getProgress() {
        int sum;
        int count = StringUtils.isBlank((Object)this.getDropCount()) ? 0 : this.getDropCount();
        int n = sum = StringUtils.isBlank((Object)this.getDropSum()) ? 0 : this.getDropSum();
        if (sum == 0) {
            return 0;
        }
        return count * 100 / sum;
    }

    private synchronized void setDropCount(int batchupdcount) {
        int oldbatchupdcount = this.getDropCount();
        int oldcount = StringUtils.isBlank((Object)oldbatchupdcount) ? 0 : oldbatchupdcount;
        this.getPageCache().put(BATCHUPD_COUNT, String.valueOf(oldcount + batchupdcount));
    }

    private synchronized int getDropCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_COUNT));
    }

    private void setDropSum(int batchupdsum) {
        this.getPageCache().put(BATCHUPD_SUM, String.valueOf(batchupdsum));
    }

    private int getDropSum() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_SUM)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_SUM));
    }

    private synchronized void setDropSuccessCount(int batchupdsuccesscount, String batchupdSuccessBillno) {
        int oldbatchupdsuccesscount = this.getDropSuccessCount();
        int oldsuccesscount = StringUtils.isBlank((Object)oldbatchupdsuccesscount) ? 0 : oldbatchupdsuccesscount;
        this.getPageCache().put(BATCHUPD_SUCCESS_COUNT, String.valueOf(batchupdsuccesscount + oldsuccesscount));
        String billno = this.getDropSuccessBillno();
        if (StringUtils.isBlank((CharSequence)billno)) {
            this.getPageCache().put(BATCHUPD_SUCCESS_BIllNO, batchupdSuccessBillno);
        } else {
            this.getPageCache().put(BATCHUPD_SUCCESS_BIllNO, String.valueOf(billno + "###" + batchupdSuccessBillno));
        }
    }

    private String getDropSuccessBillno() {
        return this.getPageCache().get(BATCHUPD_SUCCESS_BIllNO);
    }

    private int getDropSuccessCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_SUCCESS_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_SUCCESS_COUNT));
    }

    private synchronized void setDropFaildCount(int batchupdfaildcount) {
        int oldbatchupdfaildcount = this.getDropFaildCount();
        int oldfaildcount = StringUtils.isBlank((Object)oldbatchupdfaildcount) ? 0 : oldbatchupdfaildcount;
        this.getPageCache().put(BATCHUPD_FAILD_COUNT, String.valueOf(batchupdfaildcount + oldfaildcount));
    }

    private synchronized int getDropFaildCount() {
        return StringUtils.isBlank((CharSequence)this.getPageCache().get(BATCHUPD_FAILD_COUNT)) ? 0 : Integer.parseInt(this.getPageCache().get(BATCHUPD_FAILD_COUNT));
    }

    private synchronized void setError(String errorMsg) {
        this.getPageCache().put(CACHEKEY_ERROR, String.valueOf(true));
        if (this.getPageCache().get(CACHEKEY_ERRORMSG) != null) {
            String error = this.getPageCache().get(CACHEKEY_ERRORMSG);
            StringBuilder sb = new StringBuilder();
            sb.append(error);
            sb.append("###");
            sb.append(errorMsg);
            this.getPageCache().put(CACHEKEY_ERRORMSG, sb.toString());
        } else {
            this.getPageCache().put(CACHEKEY_ERRORMSG, errorMsg);
        }
    }

    private void settaskid(String taskid) {
        this.getPageCache().put("taskid", taskid);
    }

    private String gettaskid() {
        return this.getPageCache().get("taskid");
    }

    public static <T> List<List<T>> averageAssign(List<T> source, int n) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        int remainder = source.size() % n;
        int number = source.size() / n;
        int offset = 0;
        for (int i = 0; i < n; ++i) {
            List<T> value = null;
            if (remainder > 0) {
                value = source.subList(i * number + offset, (i + 1) * number + offset + 1);
                --remainder;
                ++offset;
            } else {
                value = source.subList(i * number + offset, (i + 1) * number + offset);
            }
            if (value == null || value.size() <= 0) continue;
            result.add(value);
        }
        return result;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    private void execute(List<Long> planorders, DynamicObject batchopera, Object newValue, String entitynumber, Map<Long, String> idBillnoMap) {
        String threadname = Thread.currentThread().getName();
        if (planorders != null && planorders.size() > 0) {
            this.settaskid(String.valueOf(planorders.size()));
            try {
                HashMap planOrderIdBillNo = Maps.newHashMapWithExpectedSize((int)planorders.size());
                HashMap<Long, String> errors = new HashMap<Long, String>(planorders.size());
                for (Long planorderId : planorders) {
                    DynamicObject[] billno = idBillnoMap.get(planorderId);
                    planOrderIdBillNo.put(planorderId, billno);
                    errors.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u3010%s\u3011\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PlanOrderBatchUpdPlugin_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[]{billno}));
                }
                DynamicObject[] updates = BusinessDataServiceHelper.load((String)entitynumber, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", planorders)});
                ArrayList<Long> planorderIds = new ArrayList<Long>(updates.length);
                for (DynamicObject update : updates) {
                    Long planorderId = update.getLong("id");
                    planorderIds.add(planorderId);
                    if (!errors.containsKey(planorderId)) continue;
                    errors.remove(planorderId);
                }
                Map<String, Object> result = this.batchUpdateService.batchUpdate(planorderIds, entitynumber, batchopera, newValue);
                Map errorMap = (Map)result.get(CACHEKEY_ERROR);
                List successIds = (List)result.get("success");
                errorMap.putAll(errors);
                for (Map.Entry entry : planOrderIdBillNo.entrySet()) {
                    Long planOrderId = (Long)entry.getKey();
                    String error = (String)errorMap.get(planOrderId);
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        this.setError(error);
                        this.setDropFaildCount(1);
                        this.setDropCount(1);
                        continue;
                    }
                    if (successIds.contains(planOrderId)) {
                        this.setDropCount(1);
                        this.setDropSuccessCount(1, (String)entry.getValue());
                        continue;
                    }
                    this.setDropFaildCount(1);
                    this.setDropCount(1);
                }
            }
            catch (Exception ex) {
                int size = planorders.size();
                this.setError(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25%s", (String)"PlanOrderBatchUpdPlugin_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ex.getMessage()));
                this.setDropFaildCount(size);
                this.setDropCount(size);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        logger.info("\u7ebf\u7a0b" + threadname + "\u7684\u7ed3\u675f\u65f6\u95f4\u4e3a" + new Date());
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
        this.settaskid("-1");
        progressBar.start();
    }

    public void onProgress(ProgressEvent paramProgressEvent) {
        Label lblTip;
        int progress = this.getProgress();
        if (progress == 0) {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(ResManager.loadKDString((String)"\u51c6\u5907\u6279\u91cf\u4fee\u6539...", (String)"PlanOrderBatchUpdPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            paramProgressEvent.setProgress(0);
            logger.info("\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539");
        } else {
            lblTip = (Label)this.getControl("labelap");
            lblTip.setText(this.getTip());
            paramProgressEvent.setProgress(this.getProgress());
        }
        if ("0".equals(this.gettaskid())) {
            ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESSBARAP);
            progressBar.stop();
        } else if ("-1".equals(this.gettaskid())) {
            this.settaskid("-2");
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Map idBillnoMap = (Map)formShowParameter.getCustomParam(BATCHUPDFIELD);
            ArrayList<Long> ids = new ArrayList<Long>(idBillnoMap.size());
            for (Object id : idBillnoMap.keySet()) {
                ids.add(Long.valueOf(id.toString()));
            }
            String entitynumber = (String)formShowParameter.getCustomParam(ENTITYNUMBER);
            Long batchoperaId = (Long)formShowParameter.getCustomParam(BATCHOPERA);
            DynamicObject batchopera = BusinessDataServiceHelper.loadSingleFromCache((Object)batchoperaId, (String)MSPLAN_BATCH_EDIT);
            String mapping = batchopera.getString("mapping");
            String entityNumber = batchopera.getString("datasource");
            Object newValue = this.dealNewValue(formShowParameter, mapping, entityNumber);
            long starttime = System.currentTimeMillis();
            long endtime = System.currentTimeMillis();
            if (ids != null && ids.size() > 0) {
                logger.info("\u5904\u7406\u8ba1\u5212\u8ba2\u5355\u96c6\u5408\u8f6c\u6362\u8017\u65f6" + (endtime - starttime) + "ms");
                this.setDropSum(ids.size());
                ThreadPool pool = ThreadPools.newFixedThreadPool((String)("PlanOrder-batchupdate-onProgress-" + UUID.randomUUID()), (int)Integer.getInteger("plan.order.batchupdate.poolsize", 1));
                int averageNum = ids.size() % 200 == 0 ? ids.size() / 200 : ids.size() / 200 + 1;
                List averagelist = PlanOrderBatchUpdPlugin.averageAssign(ids, averageNum);
                for (List planorders : averagelist) {
                    pool.execute(() -> this.execute(planorders, batchopera, newValue, entitynumber, idBillnoMap));
                }
                pool.close();
            }
        }
        int count = this.getDropCount();
        int sum = this.getDropSum();
        if (count != 0 && sum != 0 && count == sum) {
            Label lblTip2 = (Label)this.getControl("labelap");
            lblTip2.setText(String.format(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u603b\u6570\uff1a%1$s,\u5df2\u6279\u91cf\u4fee\u6539\uff1a%2$s,\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a%3$s", (String)"PlanOrderBatchUpdPlugin_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), this.getDropSum(), this.getDropSuccessCount(), this.getDropFaildCount()));
            String error = this.getPageCache().get(CACHEKEY_ERROR);
            if (Boolean.parseBoolean(error)) {
                this.errorMsg();
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u6210\u529f\u3002", (String)"PlanOrderBatchUpdPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                this.getView().returnDataToParent((Object)"success");
                this.getView().invokeOperation("close");
            }
            this.settaskid("0");
        }
    }

    private Object dealNewValue(FormShowParameter formShowParameter, String mapping, String entityNumber) {
        Object newValue = formShowParameter.getCustomParam(NEWVALUE);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)MSPLAN_BATCHUPDFIELD);
        IDataEntityProperty property = dataEntityType.findProperty(mapping);
        if (property instanceof DateTimeProp) {
            try {
                newValue = DATETIME.get().parse(newValue.toString());
                newValue = PlanOrderHelper.getCompDate((Date)((Date)newValue));
            }
            catch (ParseException e) {
                logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
            }
        } else if (property instanceof BasedataProp && StringUtils.isNotBlank((CharSequence)entityNumber) && newValue instanceof JSONObject) {
            Long newValueId = 0L;
            JSONObject jobj = (JSONObject)newValue;
            newValueId = jobj.getLong("id");
            newValue = newValueId == 0L ? null : BusinessDataServiceHelper.loadSingleFromCache((Object)newValueId, (String)entityNumber);
        }
        return newValue;
    }

    private void errorMsg() {
        int i;
        int batchupdSum = this.getDropSum();
        if (batchupdSum == 0) {
            return;
        }
        String errormsgs = this.getPageCache().get(CACHEKEY_ERRORMSG);
        String successBillNO = this.getDropSuccessBillno();
        IFormView entryView = this.getView();
        OperationResult operationResult = new OperationResult();
        String operateName = ResManager.loadKDString((String)"\u5df2\u6279\u91cf\u4fee\u6539\u7ed3\u679c\uff1a", (String)"PlanOrderBatchUpdPlugin_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
        operationResult.setBillCount(batchupdSum);
        ArrayList<String> successIndexs = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)successBillNO)) {
            String[] successBillNOs = successBillNO.split("###");
            for (i = 0; i < successBillNOs.length; ++i) {
                successIndexs.add(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u3010%s\u3011\u5df2\u6279\u91cf\u4fee\u6539", (String)"PlanOrderBatchUpdPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), successBillNOs[i]));
            }
        }
        operationResult.setSuccessPkIds(successIndexs);
        if (errormsgs == null) {
            return;
        }
        String[] errormsg = errormsgs.split("###");
        for (i = 0; i < errormsg.length; ++i) {
            String error = errormsg[i];
            OperateErrorInfo operateErrorInfo = new OperateErrorInfo("errorcode_001", ErrorLevel.Error, (Object)i);
            operateErrorInfo.setMessage(error);
            operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539", (String)"PlanOrderBatchUpdPlugin_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            operationResult.addErrorInfo(operateErrorInfo);
        }
        operationResult.setMessage(ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u53d1\u73b0\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdPlugin_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        entryView.showOperationResult(operationResult, operateName);
    }
}

