/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.mpscmm.common.entity.planorder.WorkDayResult;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.formplugin.batchupd.BatchUpdateService;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;

public class PlanOrderBatchUpdateService
extends BatchUpdateService {
    private static final Log logger = LogFactory.getLog(PlanOrderBatchUpdateService.class);
    public static final String UNIT_PRECISION = "precision";
    public static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    @Override
    public Map<String, Object> batchUpdate(List<Long> dataIds, String entityNumber, DynamicObject property, Object newValue) {
        DynamicObject[] datas;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String dbField = property.getString("field");
        HashMap errorMap = Maps.newHashMapWithExpectedSize((int)100);
        result.put("error", errorMap);
        ArrayList<Long> successIds = new ArrayList<Long>(dataIds.size());
        result.put("success", successIds);
        HashMap<Long, List> orgDataMap = new HashMap<Long, List>(100);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        DynamicProperty pro = dataEntityType.getProperty(dbField);
        if (pro == null) {
            for (Long dataId : dataIds) {
                errorMap.put(dataId, ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u9009\u62e9\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728\u3002", (String)"PlanOrderBatchUpdateService_27", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            return result;
        }
        String selectFields = PlanOrderHelper.getPlanOrderSelectFields();
        String newSelectFields = this.getNewSelectFields(selectFields, dbField, (DynamicObjectType)dataEntityType);
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)entityNumber, (String)newSelectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", dataIds)})) {
            String billstatus = data.getString("billstatus");
            if (!"A".equals(billstatus)) {
                errorMap.put(data.getLong("id"), ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u5355\u636e\u72b6\u6001\u8981\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"PlanOrderBatchUpdateService_30", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject org = data.getDynamicObject("proorpurorg");
            Long orgId = org.getLong("id");
            orgDataMap.computeIfAbsent(orgId, k -> new ArrayList()).add(data);
        }
        ArrayList<DynamicObject> updateOrders = new ArrayList<DynamicObject>();
        for (Map.Entry orgDatas : orgDataMap.entrySet()) {
            Long orgId = (Long)orgDatas.getKey();
            List orderDatas = (List)orgDatas.getValue();
            WorkDayResult workDate = PlanOrderHelper.getWorkDate((Long)orgId);
            Date startdate = workDate.getStartDate();
            Date enddate = workDate.getEndDate();
            block23: for (DynamicObject data : orderDatas) {
                Object ordValue = data.get(dbField);
                Long planorderId = data.getLong("id");
                String billno = data.getString("billno");
                DynamicObject materialPlan = data.getDynamicObject("materialplanid");
                switch (dbField) {
                    case "ordertype": {
                        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(ordValue) && (MaterialAttrEnum.EXTERNALPROCESSINPART.getValue().equals(newValue) || MaterialAttrEnum.FABRICATEDPART.getValue().equals(newValue))) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba2\u5355\u7c7b\u578b\u4e0d\u652f\u6301\u4ece\u5916\u8d2d\u4fee\u6539\u6210\u81ea\u5236\u3001\u5916\u534f\u3002", (String)"PlanOrderBatchUpdateService_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(newValue) && (MaterialAttrEnum.EXTERNALPROCESSINPART.getValue().equals(ordValue) || MaterialAttrEnum.FABRICATEDPART.getValue().equals(ordValue))) {
                            data.set(dbField, newValue);
                            this.dealDataAfterOrderType(data);
                        } else {
                            data.set(dbField, newValue);
                        }
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "yield": {
                        data.set(dbField, newValue);
                        this.dealDataAfterYield(data);
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "tracknumber": {
                        String datasource = data.getString("datasource");
                        if ("B".equals(datasource)) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u6570\u636e\u6765\u6e90\u4e3a\u8ba1\u7b97\u4ea7\u751f\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PlanOrderBatchUpdateService_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        data.set(dbField, newValue);
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "enddate": {
                        Date startDate = data.getDate("startdate");
                        if (!(newValue instanceof Date)) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u7c7b\u578b\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        if (startDate == null || startDate.compareTo((Date)newValue) > 0) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        if (startdate == null || startdate.compareTo((Date)newValue) > 0 || enddate == null || enddate.compareTo((Date)newValue) < 0) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        String error = this.dealDataAfterEndDate(data, newValue, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        data.set(dbField, newValue);
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "startdate": {
                        Date orderDate = data.getDate("orderdate");
                        if (!(newValue instanceof Date)) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u7c7b\u578b\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        if (orderDate == null || orderDate.compareTo((Date)newValue) > 0) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        if (startdate == null || startdate.compareTo((Date)newValue) > 0 || enddate == null || enddate.compareTo((Date)newValue) < 0) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        String error = this.dealDataAfterStartDate(data, newValue, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        Date endDate = data.getDate("enddate");
                        error = this.dealDataAfterEndDate(data, endDate, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        data.set(dbField, newValue);
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "orderdate": {
                        if (!(newValue instanceof Date)) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u7c7b\u578b\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        String error = this.dealDataAfterOrderDate(data, newValue, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        Date startDate = data.getDate("startdate");
                        error = this.dealDataAfterStartDate(data, startDate, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        Date endDate = data.getDate("enddate");
                        error = this.dealDataAfterEndDate(data, endDate, materialPlan, workDate);
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            errorMap.put(planorderId, String.format(error, billno));
                            continue block23;
                        }
                        data.set(dbField, newValue);
                        updateOrders.add(data);
                        continue block23;
                    }
                    case "orderqty": {
                        if (!(newValue instanceof BigDecimal)) {
                            errorMap.put(planorderId, String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba2\u5355\u6570\u91cf\u7c7b\u578b\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                            continue block23;
                        }
                        BigDecimal oldOrderQty = data.getBigDecimal("orderqty");
                        BigDecimal orderQty = (BigDecimal)newValue;
                        DynamicObject unit = data.getDynamicObject("unit");
                        orderQty = orderQty.setScale(unit.getInt(UNIT_PRECISION), 4);
                        data.set(dbField, (Object)orderQty);
                        this.dealDataAfterOrderQty(data, oldOrderQty, workDate);
                        this.dealDataAfterYield(data);
                        updateOrders.add(data);
                        continue block23;
                    }
                }
                data.set(dbField, newValue);
                updateOrders.add(data);
            }
        }
        HashMap<Object, DynamicObject> updateOrderMap = new HashMap<Object, DynamicObject>(updateOrders.size());
        for (DynamicObject updateOrder : updateOrders) {
            updateOrderMap.put(updateOrder.getPkValue(), updateOrder);
        }
        OperateOption option = OperateOption.create();
        OperationResult operationResult = null;
        option.setVariableValue("batchUpdate", "batchUpdate");
        option.setVariableValue("islog", "islog");
        try {
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])updateOrders.toArray(new DynamicObject[0]), (OperateOption)option);
            List successPkIds = operationResult.getSuccessPkIds();
            for (Object successPkId : successPkIds) {
                successIds.add(Long.valueOf(successPkId.toString()));
            }
            if (!operationResult.isSuccess()) {
                List allErrors;
                StringBuilder error = new StringBuilder();
                error.append(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\uff1a%s", (String)"PlanOrderBatchUpdateService_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                if (StringUtils.isNotBlank((CharSequence)operationResult.getMessage())) {
                    error.append(operationResult.getMessage());
                }
                if ((allErrors = operationResult.getAllErrorOrValidateInfo()) == null || allErrors.size() == 0) {
                    this.failInfoUpdate(error.toString(), updateOrders, errorMap);
                } else {
                    for (IOperateInfo info : allErrors) {
                        StringBuilder infoerror;
                        Object pkValue = info.getPkValue();
                        if (successIds.contains(pkValue) || pkValue == null) continue;
                        Long errorOrderId = Long.valueOf(pkValue.toString());
                        DynamicObject errorOrder = (DynamicObject)updateOrderMap.get(pkValue);
                        String errorStr = (String)errorMap.get(errorOrderId);
                        if (StringUtils.isBlank((CharSequence)errorStr)) {
                            infoerror = new StringBuilder();
                            errorStr = String.format(infoerror.append((CharSequence)error).append(info.getMessage()).append("\n\r").toString(), errorOrder.getString("billno"));
                        } else {
                            infoerror = new StringBuilder();
                            errorStr = infoerror.append(errorStr).append(info.getMessage()).append("\n\r").toString();
                        }
                        errorMap.put(errorOrderId, errorStr);
                    }
                }
            }
            return result;
        }
        catch (Exception e) {
            String errorStr = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u4fdd\u5b58\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u5f02\u5e38\u4fe1\u606f\u4e3a", (String)"PlanOrderBatchUpdateService_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            StringBuilder error = new StringBuilder();
            error.append(errorStr);
            error.append(String.format(ResManager.loadKDString((String)"%s\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"PlanOrderBatchUpdateService_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), e.getMessage()));
            this.failInfoUpdate(error.toString(), updateOrders, errorMap);
            return result;
        }
    }

    private String getNewSelectFields(String selectFields, String dbField, DynamicObjectType dataEntityType) {
        StringBuilder str = new StringBuilder(selectFields);
        if (!selectFields.contains(dbField)) {
            str.append(',').append(dbField);
        }
        switch (dbField) {
            case "ordertype": {
                str.append(',').append("ecnversion");
                break;
            }
            case "tracknumber": {
                str.append(',').append("datasource");
                break;
            }
            case "enddate": 
            case "startdate": 
            case "yield": 
            case "orderdate": {
                break;
            }
            case "orderqty": {
                str.append(',').append("copentry").append('.').append("copentryallqty");
                str.append(',').append("copentry").append('.').append("copentryqty");
                str.append(',').append("entryentity").append('.').append("wastagerateformula");
                str.append(',').append("entryentity").append('.').append("entryqtytype");
                str.append(',').append("entryentity").append('.').append("entryfixscrap");
                str.append(',').append("entryentity").append('.').append("entryqtynumerator");
                str.append(',').append("entryentity").append('.').append("entryqtydenominator");
                str.append(',').append("entryentity").append('.').append("entryrepmaterials");
                str.append(',').append("entryentity").append('.').append("entryrepqty");
                str.append(',').append("entryentity").append('.').append("entrylossqty");
                break;
            }
        }
        return str.toString();
    }

    private void failInfoUpdate(String error, List<DynamicObject> updateOrders, Map<Long, String> errorMap) {
        for (DynamicObject planorder : updateOrders) {
            String errorStr = error;
            if (error == null) continue;
            if (error.split("%s").length == 2) {
                errorStr = String.format(error, planorder.getString("billno"));
            }
            Long orderId = planorder.getLong("id");
            if (errorStr.length() > 450) {
                errorStr = errorStr.substring(0, 450);
            }
            errorMap.put(orderId, errorStr);
        }
    }

    private void dealDataAfterOrderQty(DynamicObject newPlanOrder, BigDecimal oldOrderQty, WorkDayResult workDate) {
        String materialattr = newPlanOrder.getString("ordertype");
        BigDecimal newOrderQty = newPlanOrder.getBigDecimal("orderqty");
        BigDecimal yield = newPlanOrder.getBigDecimal("yield");
        newPlanOrder.set("endproqty", (Object)newOrderQty.multiply(yield));
        DynamicObjectCollection planOrderEntrys = newPlanOrder.getDynamicObjectCollection("entryentity");
        Boolean materiallock = newPlanOrder.getBoolean("materiallock");
        if (!materiallock.booleanValue()) {
            this.dealMaterialEntry(planOrderEntrys, newPlanOrder, materialattr, workDate, newOrderQty, oldOrderQty);
        }
        DynamicObjectCollection copEntrys = newPlanOrder.getDynamicObjectCollection("copentry");
        PlanOrderHelper.recalCulationCopentrysQty((DynamicObjectCollection)copEntrys, (BigDecimal)newOrderQty);
    }

    private void dealMaterialEntry(DynamicObjectCollection planOrderEntrys, DynamicObject newPlanOrder, String materialattr, WorkDayResult workDate, BigDecimal newOrderQty, BigDecimal oldOrderQty) {
        Date startDate = newPlanOrder.getDate("startdate");
        if (planOrderEntrys == null || planOrderEntrys.isEmpty()) {
            return;
        }
        for (int j = 0; j < planOrderEntrys.size(); ++j) {
            DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
            this.recalCulationDate(planOrderEntry, startDate, materialattr, workDate);
            DynamicObject entryreplaceplan = planOrderEntry.getDynamicObject("entryreplaceplan");
            BigDecimal entryrequireqty = planOrderEntry.getBigDecimal("entryrequireqty");
            if (entryreplaceplan != null && BigDecimal.ZERO.compareTo(entryrequireqty) == 0) continue;
            PlanOrderHelper.recalCulationQty((DynamicObject)planOrderEntry, (DynamicObject)newPlanOrder, (DynamicObject)planOrderEntry, (int)j, (BigDecimal)newOrderQty, (BigDecimal)oldOrderQty);
        }
    }

    private void recalCulationDate(DynamicObject planOrderEntry, Date startDate, String materialattr, WorkDayResult workDate) {
        planOrderEntry.set("entryrequiredate", (Object)startDate);
        Integer leadtime = planOrderEntry.getInt("entryleadtime");
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            Date reqDate = PlanOrderHelper.getDate((Date)startDate, (int)leadtime);
            planOrderEntry.set("entryrequiredate", (Object)reqDate);
            return;
        }
        Map dateIndexMap = workDate.getDateIndexMap();
        Map indexdateMap = workDate.getIndexdateMap();
        if (dateIndexMap == null) {
            return;
        }
        Integer index = this.getIndex(dateIndexMap, startDate, workDate);
        if (index == null) {
            return;
        }
        Integer newIndex = index + leadtime;
        String reqDateStr = (String)indexdateMap.get(newIndex);
        if (reqDateStr == null) {
            return;
        }
        Date reqDate = PlanOrderBatchUpdateService.parseDate(reqDateStr);
        if (reqDate == null) {
            return;
        }
        planOrderEntry.set("entryrequiredate", (Object)reqDate);
    }

    private static Date parseDate(String reqDateStr) {
        Date reqDate = null;
        try {
            reqDate = DATETIME.get().parse(reqDateStr);
        }
        catch (ParseException e) {
            logger.error("\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (Throwable)e);
        }
        return reqDate;
    }

    private String dealDataAfterOrderDate(DynamicObject data, Object newValue, DynamicObject materialPlan, WorkDayResult workDate) {
        String error = "";
        if (materialPlan == null) {
            data.set("startdate", newValue);
            return error;
        }
        String materialattr = materialPlan.getString("materialattr");
        BigDecimal preprocessingtime = materialPlan.getBigDecimal("preprocessingtime");
        int days = preprocessingtime.setScale(0, 0).intValue();
        Date orderDate = (Date)newValue;
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            Date startDate = PlanOrderHelper.getDate((Date)orderDate, (int)days);
            data.set("startdate", (Object)startDate);
            return error;
        }
        Map dateIndexMap = workDate.getDateIndexMap();
        Map indexdateMap = workDate.getIndexdateMap();
        if (dateIndexMap == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u672a\u8bbe\u7f6e\u3002", (String)"PlanOrderBatchUpdateService_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Integer index = this.getIndex(dateIndexMap, orderDate, workDate);
        if (index == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Integer newIndex = index + days;
        String startDateStr = (String)indexdateMap.get(newIndex);
        if (startDateStr == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Date startDate = PlanOrderBatchUpdateService.parseDate(startDateStr);
        if (startDate == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_24", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        data.set("startdate", (Object)startDate);
        return error;
    }

    private String dealDataAfterStartDate(DynamicObject data, Object newValue, DynamicObject materialPlan, WorkDayResult workDate) {
        String error = "";
        if (materialPlan == null) {
            data.set("enddate", newValue);
            DynamicObjectCollection planOrderEntrys = data.getDynamicObjectCollection("entryentity");
            for (int j = 0; j < planOrderEntrys.size(); ++j) {
                DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
                planOrderEntry.set("entryrequiredate", newValue);
            }
            return error;
        }
        Date startDate = (Date)newValue;
        Map dateIndexMap = workDate.getDateIndexMap();
        Map indexdateMap = workDate.getIndexdateMap();
        if (dateIndexMap == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u672a\u8bbe\u7f6e\u3002", (String)"PlanOrderBatchUpdateService_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Integer index = this.getIndex(dateIndexMap, startDate, workDate);
        if (index == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        String materialattr = materialPlan.getString("materialattr");
        String leadtimetype = materialPlan.getString("leadtimetype");
        BigDecimal fixedleadtime = materialPlan.getBigDecimal("fixedleadtime");
        BigDecimal changeleadtime = materialPlan.getBigDecimal("changeleadtime");
        BigDecimal changebatchqty = materialPlan.getBigDecimal("changebatch");
        BigDecimal leadtime = BigDecimal.ZERO;
        if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)leadtimetype)) {
            leadtime = fixedleadtime;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)leadtimetype)) {
            BigDecimal orderqty = data.getBigDecimal("orderqty");
            if (orderqty.compareTo(BigDecimal.ZERO) <= 0) {
                error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u5f53\u7269\u6599\u6709\u53d8\u52a8\u63d0\u524d\u671f\uff0c\u8bf7\u5148\u5f55\u5165\u8ba2\u5355\u6570\u91cf\u3002", (String)"PlanOrderBatchUpdateService_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                return error;
            }
            leadtime = orderqty.multiply(changeleadtime).divide(changebatchqty, 10, RoundingMode.UP);
        }
        int days = leadtime.setScale(0, 0).intValue();
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            Date endDate = PlanOrderHelper.getDate((Date)startDate, (int)days);
            data.set("enddate", (Object)endDate);
            return error;
        }
        Integer newIndex = index + days;
        String endDateStr = (String)indexdateMap.get(newIndex);
        if (endDateStr == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Date endDate = PlanOrderBatchUpdateService.parseDate(endDateStr);
        if (endDate == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        data.set("enddate", (Object)endDate);
        DynamicObjectCollection planOrderEntrys = data.getDynamicObjectCollection("entryentity");
        for (int j = 0; j < planOrderEntrys.size(); ++j) {
            DynamicObject planOrderEntry = (DynamicObject)planOrderEntrys.get(j);
            this.recalCulationDate(planOrderEntry, startDate, materialattr, workDate);
        }
        return error;
    }

    private Integer getIndex(Map<String, Integer> dateIndexMap, Date date, WorkDayResult workDate) {
        Date endDate = workDate.getEndDate();
        String dateStr = PlanOrderHelper.formatDateTime((Date)date);
        Integer index = dateIndexMap.get(dateStr);
        if (index == null) {
            Long endDateLong = endDate.getTime();
            Long dateLong = date.getTime();
            long days = (endDateLong - dateLong) / 24L / 60L / 60L / 1000L;
            int i = 1;
            while ((long)i < days) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                calendar.add(5, i);
                Date newdate = calendar.getTime();
                String newDateStr = PlanOrderHelper.formatDateTime((Date)newdate);
                index = dateIndexMap.get(newDateStr);
                if (index != null) break;
                ++i;
            }
        }
        return index;
    }

    private String dealDataAfterEndDate(DynamicObject data, Object newValue, DynamicObject materialPlan, WorkDayResult workDate) {
        String error = "";
        if (materialPlan == null) {
            data.set("availabledate", newValue);
            return error;
        }
        String materialattr = materialPlan.getString("materialattr");
        BigDecimal testleadtime = materialPlan.getBigDecimal("inspectionleadtime");
        BigDecimal postprocessingtime = materialPlan.getBigDecimal("postprocessingtime");
        Integer days = testleadtime.add(postprocessingtime).setScale(0, 0).intValue();
        Date endDate = (Date)newValue;
        if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            Date availableDate = PlanOrderHelper.getDate((Date)endDate, (int)days);
            data.set("availabledate", (Object)availableDate);
            return error;
        }
        Map dateIndexMap = workDate.getDateIndexMap();
        Map indexdateMap = workDate.getIndexdateMap();
        if (dateIndexMap == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u672a\u8bbe\u7f6e\u3002", (String)"PlanOrderBatchUpdateService_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Integer index = this.getIndex(dateIndexMap, endDate, workDate);
        if (index == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u53ef\u7528\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_17", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Integer newIndex = index + days;
        String availableDateStr = (String)indexdateMap.get(newIndex);
        if (availableDateStr == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u53ef\u7528\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderBatchUpdateService_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        Date availableDate = PlanOrderBatchUpdateService.parseDate(availableDateStr);
        if (availableDate == null) {
            error = ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355\u6279\u91cf\u4fee\u6539\u5931\u8d25\uff1a\u8ba1\u5212\u8ba2\u5355\u7f16\u7801\u201c%s\u201d\u8ba1\u5212\u53ef\u7528\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u9519\u8bef\u3002", (String)"PlanOrderBatchUpdateService_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            return error;
        }
        data.set("availabledate", (Object)availableDate);
        return error;
    }

    private void dealDataAfterYield(DynamicObject data) {
        data.set("endproqty", (Object)data.getBigDecimal("orderqty").multiply(data.getBigDecimal("yield")));
    }

    private void dealDataAfterOrderType(DynamicObject data) {
        data.set("ecnversion", null);
        data.set("bom", null);
        data.set("unfoldbomdate", null);
        DynamicObjectCollection dynamicObjectCollection = data.getDynamicObjectCollection("entryentity");
        if (!dynamicObjectCollection.isEmpty()) {
            dynamicObjectCollection.clear();
        }
    }
}

