/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.validate.BillStatus;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class PlanOrderCompenEditPlugin
extends AbstractFormPlugin {
    private static String ID = "id";
    private static String ORDERID = "orderid";
    private static String PLANORDERNO = "planorderno";
    private static String BILLNO = "billno";
    private static String PLANORDERSTATUS = "planorderstatus";
    private static String BILLSTATUS = "billstatus";
    private static String DROPSTATUS = "dropstatus";
    private static String BILLTYPE = "billtype";
    private static String MATERIALNUMBER = "material.number";
    private static String MATERIALNAME = "material.name";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String entityNumber = this.getEntityNumber();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List bizorgs = (List)formShowParameter.getCustomParam("bizorg");
        List planorderids = (List)formShowParameter.getCustomParam("planorderid");
        Map<Object, DynamicObject> dropConfigures = PlanOrderCompenEditPlugin.getDropConfigures(bizorgs);
        Set<String> billtypes = this.getBillTypes(dropConfigures);
        JSONArray planorders = new JSONArray();
        DataSet botpAllDataSet = null;
        try (DataSet ds = this.queryBotpDataSet(entityNumber);){
            for (String billtype : billtypes) {
                if (billtype == null) continue;
                Long billtypeTableId = this.getTableDefineId(billtype);
                DataSet billDataSet = QueryServiceHelper.queryDataSet((String)PlanOrderCompenEditPlugin.class.getName(), (String)billtype, (String)"id bizorderid ,billno bizbillno, billstatus bizbillstatus", null, null);
                DataSet dataSet = ds.copy();
                dataSet = dataSet.join(billDataSet, JoinType.INNER).on("FTBillId", "bizorderid").select(dataSet.getRowMeta().getFieldNames(), billDataSet.getRowMeta().getFieldNames()).finish();
                HashMap<String, Long> tableIdParam = new HashMap<String, Long>(16);
                tableIdParam.put("tableId", billtypeTableId);
                dataSet = dataSet.filter("FTTableId = tableId", tableIdParam);
                dataSet = dataSet.addField("'" + billtype + "'", "botpbilltype");
                botpAllDataSet = botpAllDataSet == null ? dataSet : botpAllDataSet.union(dataSet);
                billDataSet.close();
            }
        }
        if (botpAllDataSet == null) {
            return;
        }
        DataSet planOrderDs = this.queryPlanOrder(entityNumber, planorderids);
        DataSet ds = planOrderDs.join(botpAllDataSet, JoinType.LEFT).on("id", "FSBillId").select(planOrderDs.getRowMeta().getFieldNames(), botpAllDataSet.getRowMeta().getFieldNames()).finish();
        try (DataSet dataSet = ds.filter("bizorderid=null");){
            while (dataSet.hasNext()) {
                Row obj = dataSet.next();
                JSONObject resObjLeft = new JSONObject();
                resObjLeft.put(PLANORDERNO, (Object)obj.getString(PLANORDERNO));
                resObjLeft.put(PLANORDERSTATUS, (Object)obj.getString(PLANORDERSTATUS));
                resObjLeft.put(DROPSTATUS, (Object)obj.getString(DROPSTATUS));
                resObjLeft.put(ID, (Object)obj.getString(ID));
                resObjLeft.put(BILLTYPE, obj.get("botpbilltype"));
                resObjLeft.put(BILLNO, (Object)obj.getString("bizbillno"));
                resObjLeft.put(BILLSTATUS, (Object)obj.getString("bizbillstatus"));
                resObjLeft.put(ORDERID, (Object)obj.getString("bizorderid"));
                resObjLeft.put(MATERIALNUMBER, (Object)obj.getString(MATERIALNUMBER));
                resObjLeft.put(MATERIALNAME, (Object)obj.getString(MATERIALNAME));
                planorders.add((Object)resObjLeft);
            }
        }
        planOrderDs.close();
        ds.close();
        botpAllDataSet.close();
        this.buildShowTable(planorders);
    }

    private DataSet queryBotpDataSet(String entityNumber) {
        Long planorderTableId = this.getTableDefineId(entityNumber);
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append("SELECT FTTableId, FTBillId,FSBillId,fcreatetime ");
        sBuilder.append("FROM T_BOTP_BillTracker ");
        sBuilder.append("WHERE FSTableId = ? ");
        params.add(new SqlParameter(":FSTableId", -5, (Object)planorderTableId));
        DataSet botpBillDataSet = DB.queryDataSet((String)PlanOrderCompenEditPlugin.class.getName(), (DBRoute)DBRoute.basedata, (String)sBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]));
        return botpBillDataSet;
    }

    private DataSet queryPlanOrder(String entityNumber, List<Long> planorderids) {
        String selectFields = "id,billno planorderno,billstatus planorderstatus,ordertype,dropstatus,material.number,material.name";
        ArrayList<String> dropstatuses = new ArrayList<String>(2);
        dropstatuses.add("C");
        dropstatuses.add("D");
        QFilter qFilter = new QFilter("billstatus", "=", (Object)BillStatus.C.name()).and(new QFilter("dropstatus", "in", dropstatuses));
        if (planorderids != null && !planorderids.isEmpty()) {
            qFilter.and(new QFilter("id", "in", planorderids));
        }
        DataSet planorderDataSet = QueryServiceHelper.queryDataSet((String)PlanOrderCompenEditPlugin.class.getName(), (String)entityNumber, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, null);
        return planorderDataSet;
    }

    private Set<String> getBillTypes(Map<Object, DynamicObject> dropConfigures) {
        HashSet<String> billTypeMap = new HashSet<String>(16);
        for (DynamicObject dropConfigure : dropConfigures.values()) {
            DynamicObjectCollection entryentity = dropConfigure.getDynamicObjectCollection("entryentity");
            if (entryentity == null || entryentity.isEmpty()) continue;
            for (DynamicObject entry : entryentity) {
                String billType = entry.getString("targetbill.number");
                billTypeMap.add(billType);
            }
        }
        return billTypeMap;
    }

    public void afterBindData(EventObject e) {
    }

    public static Map<Object, DynamicObject> getDropConfigures(List<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            orgIds = new ArrayList<Long>();
            orgIds.add(OrgUnitServiceHelper.getRootOrgId());
        }
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter qFilterOrg = BaseDataServiceHelper.getBaseDataFilter((String)"msplan_dropconfigure", orgIds, (boolean)false);
        Map data = BusinessDataServiceHelper.loadFromCache((String)"msplan_dropconfigure", (QFilter[])new QFilter[]{qFilterStatus, qFilterOrg, qFilterEnable});
        return data;
    }

    private Long getTableDefineId(String entityNumber) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(entityNumber, entityNumber);
        Long myMainTableId = mainTableDefine.getTableId();
        return myMainTableId;
    }

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if (key.equals("confirm")) {
            EntryGrid list = (EntryGrid)this.getView().getControl("entryentity");
            int[] rows = list.getSelectRows();
            if (rows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderCompenEditPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap<String, String[]> params = new HashMap<String, String[]>(rows.length);
            for (int n : rows) {
                String planorderbillid = (String)this.getModel().getValue("planorderid", n);
                String otherbillid = (String)this.getModel().getValue("orderid", n);
                String billtype = (String)this.getModel().getValue("billtype", n);
                params.put(planorderbillid, new String[]{billtype, otherbillid});
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void buildShowTable(JSONArray sourceObj) {
        this.getModel().beginInit();
        TableValueSetter mftordervs = new TableValueSetter(new String[0]);
        int row = 0;
        for (int n = 0; n < sourceObj.size(); ++n) {
            JSONObject obj = sourceObj.getJSONObject(n);
            mftordervs.set("planorderno", (Object)obj.getString(PLANORDERNO), row);
            mftordervs.set("planorderstatus", (Object)obj.getString(PLANORDERSTATUS), row);
            mftordervs.set("dropstatus", (Object)obj.getString(DROPSTATUS), row);
            mftordervs.set("planorderid", (Object)obj.getString(ID), row);
            mftordervs.set("billtype", (Object)obj.getString(BILLTYPE), row);
            mftordervs.set("billno", (Object)obj.getString(BILLNO), row);
            mftordervs.set("billstatus", (Object)obj.getString(BILLSTATUS), row);
            mftordervs.set("orderid", (Object)obj.getString(ORDERID), row);
            mftordervs.set("materialnumber", (Object)obj.getString(MATERIALNUMBER), row);
            mftordervs.set("materialname", (Object)obj.getString(MATERIALNAME), row);
            ++row;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", mftordervs);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private String getEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entitynumber = (String)formShowParameter.getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            entitynumber = "mrp_planorder";
        }
        return entitynumber;
    }
}

