/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.BOTPHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;

public class PlanOrderDropPlugin
extends AbstractFormPlugin {
    private static final String DROP = "drop";
    private static final String BILLTOCONFIG = "billtoconfig";
    private static final String DROPCONF = "dropconf";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final Log logger = LogFactory.getLog(PlanOrderDropPlugin.class);
    private static final String ALLDROPSTATUSSELECT = "alldropstatusselect";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)DROP)) {
            int[] selects;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] nArray = selects = entryGrid == null ? null : entryGrid.getSelectRows();
            if (selects == null || selects.length == 0) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderDropPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            String billrule = (String)this.getModel().getValue(BILLTOCONFIG);
            if (StringUtils.isBlank((CharSequence)billrule)) {
                args.cancel = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u5355\u636e\u8f6c\u6362\u914d\u7f6e\u3002", (String)"PlanOrderDropPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setDataEntry(selects);
            this.allDropData(selects, args);
        }
    }

    private void allDropData(int[] selects, BeforeDoOperationEventArgs args) {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        ArrayList<HashMap> planorders = new ArrayList<HashMap>(selects.length);
        for (int i : selects) {
            HashMap planorder = Maps.newHashMapWithExpectedSize((int)3);
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            planorder.put("id", entryRowEntity.get("id"));
            planorder.put("billno", entryRowEntity.get("billno"));
            BigDecimal qty = entryRowEntity.getBigDecimal("qty");
            if (BigDecimal.ZERO.compareTo(qty) >= 0) {
                args.cancel = true;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u672c\u6b21\u6295\u653e\u6570\u91cf,\u6295\u653e\u6570\u91cf\u5927\u4e8e0\u3002", (String)"PlanOrderDropPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), i + 1));
                return;
            }
            planorder.put("qty", entryRowEntity.get("qty"));
            planorders.add(planorder);
        }
        String ruleId = (String)this.getModel().getValue(BILLTOCONFIG);
        String dropConfId = this.getPageCache().get(ruleId);
        String status = "B";
        if (planorders != null && planorders.size() > 0) {
            customParams.put(ALLDROPSTATUSSELECT, planorders);
            customParams.put("dropstatus", status);
            customParams.put(BILLTOCONFIG, ruleId);
            customParams.put(DROPCONF, dropConfId);
            customParams.put("entitynumber", this.getEntityNumber());
            this.showView("mrp_planorderbatchdrop", customParams, "jindu", ShowType.Modal, null);
            return;
        }
    }

    private void showView(String formId, Map<String, Object> customParams, String callBackKey, ShowType type, String CALLBACK) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        showParameter.getOpenStyle().setShowType(type);
        if (CALLBACK != null) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK));
        }
        this.getView().showForm(showParameter);
    }

    private void setDataEntry(int[] selects) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData("entryentity1");
        TableValueSetter vsdate = new TableValueSetter(new String[0]);
        vsdate.addField("seq", new Object[0]);
        vsdate.addField("id1", new Object[0]);
        vsdate.addField("ordertype1", new Object[0]);
        vsdate.addField("billstatus1", new Object[0]);
        vsdate.addField("qty1", new Object[0]);
        vsdate.addField("orderqty1", new Object[0]);
        vsdate.addField("dropqty1", new Object[0]);
        vsdate.addField("endproqty1", new Object[0]);
        for (int i : selects) {
            DynamicObject date = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
            vsdate.addRow(new Object[]{date.get("seq"), date.get("id"), date.get("ordertype"), date.get("billstatus"), date.get("qty"), date.get("orderqty"), date.get("dropqty"), date.get("endproqty")});
        }
        model.batchCreateNewEntryRow("entryentity1", vsdate);
        model.endInit();
        this.getView().updateView("entryentity1");
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    public void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"startdate")) {
            this.startDateChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"enddate")) {
            this.endDateChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"availabledate")) {
            this.availableDateChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        }
    }

    private void startDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (!(newObject instanceof Date)) {
            this.getModel().setValue("enddate", null, rowIndex);
            this.getModel().setValue("availabledate", null, rowIndex);
            return;
        }
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        Date orderdate = entryRowEntity.getDate("orderdate");
        Date date = (Date)newObject;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getModel().setValue("enddate", (Object)date, rowIndex);
            return;
        }
        DynamicObject entryMaterialPlan = entryRowEntity.getDynamicObject("materialplanid");
        DynamicObject proorpurorg = entryRowEntity.getDynamicObject("proorpurorg");
        if (entryMaterialPlan == null) {
            this.getModel().setValue("enddate", (Object)date, rowIndex);
            return;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(date);
        }
        if (date == null) {
            date = (Date)newObject;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), proorpurorg));
            this.getModel().setValue("enddate", null, rowIndex);
            this.getModel().setValue("availabledate", null, rowIndex);
        } else if (orderdate == null || orderdate.compareTo(date) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_16", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"startdate", (Object)oldObject, (int)rowIndex);
        } else {
            String leadtimetype = entryMaterialPlan.getString("leadtimetype");
            BigDecimal fixedleadtime = entryMaterialPlan.getBigDecimal("fixedleadtime");
            BigDecimal changeleadtime = entryMaterialPlan.getBigDecimal("changeleadtime");
            BigDecimal changebatchqty = entryMaterialPlan.getBigDecimal("changebatch");
            BigDecimal leadtime = BigDecimal.ZERO;
            if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)leadtimetype)) {
                leadtime = fixedleadtime;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)leadtimetype)) {
                BigDecimal orderqty = entryRowEntity.getBigDecimal("orderqty");
                if (orderqty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u7269\u6599\u6709\u53d8\u52a8\u63d0\u524d\u671f\uff0c\u8bf7\u5148\u5f55\u5165\u8ba2\u5355\u6570\u91cf\u3002", (String)"PlanOrderDropPlugin_29", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"startdate", (Object)oldObject, (int)rowIndex);
                    return;
                }
                leadtime = orderqty.multiply(changeleadtime).divide(changebatchqty, RoundingMode.UP);
            }
            int days = leadtime.setScale(0, 0).intValue();
            Date enddate = PlanOrderHelper.getToWorkDateToDate((int)days, (Date)date, (Long)(proorpurorg == null ? 0L : proorpurorg.getLong("id")), (String)materialattr);
            if (enddate == null) {
                this.getModel().setValue("enddate", null, rowIndex);
                this.getModel().setValue("availabledate", null, rowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("enddate", (Object)enddate, rowIndex);
            }
        }
    }

    private void endDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        Date startDate = entryRowEntity.getDate("startdate");
        if (!(newObject instanceof Date)) {
            if (newObject == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)newObject, (int)rowIndex);
            } else if (startDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)oldObject, (int)rowIndex);
            }
            return;
        }
        Date endDate = (Date)newObject;
        DynamicObject entryMaterialPlan = entryRowEntity.getDynamicObject("materialplanid");
        DynamicObject proorpurorg = entryRowEntity.getDynamicObject("proorpurorg");
        if (startDate == null || startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            if (oldObject == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)oldObject, (int)rowIndex);
            }
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)oldObject, (int)rowIndex);
        } else {
            DynamicObject material = entryRowEntity.getDynamicObject("material");
            if (material == null) {
                this.getModel().setValue("availabledate", (Object)endDate, rowIndex);
                return;
            }
            if (entryMaterialPlan == null) {
                this.getModel().setValue("availabledate", (Object)endDate, rowIndex);
                return;
            }
            String materialattr = entryMaterialPlan.getString("materialattr");
            if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
                endDate = this.getRecentWorkDate(endDate);
            }
            StringBuilder errorsb = new StringBuilder();
            boolean errorboolean = false;
            if (endDate == null) {
                errorsb.append(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"PlanOrderDropPlugin_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                errorboolean = true;
                endDate = (Date)newObject;
            }
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)endDate, (int)rowIndex);
            BigDecimal testleadtime = entryMaterialPlan.getBigDecimal("inspectionleadtime");
            BigDecimal postprocessingtime = entryMaterialPlan.getBigDecimal("postprocessingtime");
            int days = testleadtime.add(postprocessingtime).setScale(0, 0).intValue();
            Date inspectionleadtime = PlanOrderHelper.getToWorkDateToLastDate((int)days, (Date)endDate, (Long)(proorpurorg == null ? 0L : proorpurorg.getLong("id")), (String)materialattr);
            if (inspectionleadtime == null) {
                errorboolean = true;
                if (errorsb != null && errorsb.length() > 0) {
                    errorsb.append(String.format(ResManager.loadKDString((String)"%s\u53ef\u7528\u65e5\u671f\u7b49", (String)"PlanOrderDropPlugin_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), "\u3001"));
                } else {
                    errorsb.append(ResManager.loadKDString((String)"\u53ef\u7528\u65e5\u671f", (String)"PlanOrderDropPlugin_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                }
                Date lastDate = PlanOrderHelper.getLastDateToDate((Long)(proorpurorg == null ? 0L : proorpurorg.getLong("id")));
                if (lastDate != null && endDate.compareTo(lastDate) < 0) {
                    this.getModel().setValue("availabledate", (Object)PlanOrderHelper.getDate((Date)lastDate, (int)days), rowIndex);
                } else {
                    this.getModel().setValue("availabledate", (Object)PlanOrderHelper.getDate((Date)endDate, (int)days), rowIndex);
                }
            } else {
                this.getModel().setValue("availabledate", (Object)inspectionleadtime, rowIndex);
            }
            if (errorboolean) {
                errorsb.append(ResManager.loadKDString((String)"\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderDropPlugin_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(String.format(errorsb.toString(), proorpurorg));
            }
        }
    }

    private void availableDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (!(newObject instanceof Date)) {
            return;
        }
        Date date = (Date)newObject;
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex);
        DynamicObject material = entryRowEntity.getDynamicObject("material");
        if (material == null) {
            return;
        }
        DynamicObject entryMaterialPlan = entryRowEntity.getDynamicObject("materialplanid");
        if (entryMaterialPlan == null) {
            return;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(date);
        }
        if (date != null) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)date, (int)rowIndex);
        }
    }

    private Date getRecentWorkDate(Date date) {
        if (date == null) {
            return null;
        }
        DynamicObject dept = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (dept == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderDropPlugin_30", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return null;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)dept.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u3002", (String)"PlanOrderDropPlugin_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), dept.getString("name")));
            return null;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)dept.getLong("id"));
        return workDate;
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String jsonStr = (String)formShowParameter.getCustomParam(DROP);
        String ordertype = (String)formShowParameter.getCustomParam("ordertype");
        String purorg = (String)formShowParameter.getCustomParam("proorpurorg");
        DynamicObject dropConfigure = PlanOrderHelper.getDropConfigure((Long)Long.valueOf(purorg), (IPageCache)this.getPageCache());
        String targetEntity = PlanOrderHelper.getTargetEntityByorderType((String)ordertype, (DynamicObject)dropConfigure);
        String entityNumber = this.getEntityNumber();
        List loadRules = BOTPHelper.getRules((String)entityNumber, (String)targetEntity);
        loadRules = BOTPHelper.excludeConvertRuleByOrdertype((List)loadRules, (String)ordertype);
        String msg = (String)formShowParameter.getCustomParam("msg");
        if (StringUtils.isNotBlank((CharSequence)jsonStr) && StringUtils.isNotBlank((CharSequence)ordertype)) {
            Map planorderIdBillNo = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            model.deleteEntryData(ENTRY_ENTITY);
            model.deleteEntryData("entryentity1");
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField("seq", new Object[0]);
            vs.addField("id", new Object[0]);
            vs.addField("billno", new Object[0]);
            vs.addField("ordertype", new Object[0]);
            vs.addField("material", new Object[0]);
            vs.addField("billstatus", new Object[0]);
            vs.addField("org", new Object[0]);
            vs.addField("proorpurorg", new Object[0]);
            vs.addField("orderdate", new Object[0]);
            vs.addField("startdate", new Object[0]);
            vs.addField("enddate", new Object[0]);
            vs.addField("availabledate", new Object[0]);
            vs.addField("materialplanid", new Object[0]);
            vs.addField("qty", new Object[0]);
            vs.addField("orderqty", new Object[0]);
            vs.addField("dropqty", new Object[0]);
            vs.addField("endproqty", new Object[0]);
            vs.addField("unit", new Object[0]);
            HashSet<Long> planorderIds = new HashSet<Long>(planorderIdBillNo.size());
            for (Object planorderid : planorderIdBillNo.keySet()) {
                planorderIds.add(Long.valueOf(planorderid.toString()));
            }
            QFilter qFilter = new QFilter("id", "in", planorderIds);
            String selectField = "id,billno,ordertype,material,billstatus,org,proorpurorg,orderdate,startdate,enddate,availabledate,materialplanid,orderqty,dropqty,endproqty,unit,qty,dropstatus";
            DynamicObjectCollection datas = QueryServiceHelper.query((String)this.getEntityNumber(), (String)selectField, (QFilter[])new QFilter[]{qFilter});
            int seq = 1;
            for (DynamicObject map : datas) {
                Long id = Long.valueOf(map.get("id").toString());
                String billno = (String)map.get("billno");
                Object material = map.get("material");
                String billstatus = (String)map.get("billstatus");
                Object org = map.get("org");
                Object proorpurorg = map.get("proorpurorg");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date orderdate = map.getDate("orderdate") == null ? new Date() : map.getDate("orderdate");
                Date startdate = map.getDate("startdate") == null ? new Date() : map.getDate("startdate");
                Date enddate = map.getDate("enddate") == null ? new Date() : map.getDate("enddate");
                Date availabledate = map.getDate("availabledate") == null ? new Date() : map.getDate("availabledate");
                try {
                    orderdate = sdf.parse(orderdate.toString());
                    startdate = sdf.parse(startdate.toString());
                    enddate = sdf.parse(enddate.toString());
                    availabledate = sdf.parse(availabledate.toString());
                }
                catch (ParseException e1) {
                    logger.error("PlanOrderDropPlugin", (Throwable)e1);
                }
                Object materialplanid = map.get("materialplanid");
                BigDecimal orderqty = new BigDecimal(map.get("orderqty").toString());
                BigDecimal dropqty = new BigDecimal(map.get("dropqty").toString());
                BigDecimal qty = orderqty.subtract(dropqty);
                BigDecimal endproqty = new BigDecimal(map.get("endproqty").toString());
                Object unit = map.get("unit");
                vs.addRow(new Object[]{seq++, id, billno, ordertype, material, billstatus, org, proorpurorg, orderdate, startdate, enddate, availabledate, materialplanid, qty, orderqty, dropqty, endproqty, unit});
            }
            model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRY_ENTITY);
            List<Map<String, Object>> date = this.getDate(ordertype, Long.valueOf(purorg));
            this.setComboEdit(date);
            if (StringUtils.isNotBlank((CharSequence)msg)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u63d0\u793a\u4fe1\u606f", (String)"PlanOrderDropPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), msg, MessageTypes.Default);
            }
            if (loadRules != null && loadRules.size() > 0) {
                String ruleId = null;
                for (ConvertRuleElement loadRule : loadRules) {
                    ruleId = loadRule.getId();
                }
                this.getModel().setValue(BILLTOCONFIG, ruleId);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)DROP)) {
            int[] selects;
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] nArray = selects = entryGrid == null ? null : entryGrid.getSelectRows();
            if (selects == null || selects.length == 0) {
                return;
            }
            String entityNumber = this.getEntityNumber();
            for (int i : selects) {
                DynamicObject entry = this.getModel().getEntryRowEntity(ENTRY_ENTITY, i);
                Long id = entry.getLong("id");
                DynamicObject planOrder = QueryServiceHelper.queryOne((String)entityNumber, (String)"orderqty,dropqty,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
                if (planOrder == null) continue;
                BigDecimal dropqty = planOrder.getBigDecimal("dropqty");
                BigDecimal orderqty = planOrder.getBigDecimal("orderqty");
                String billstatus = planOrder.getString("billstatus");
                this.getModel().setValue("dropqty", (Object)dropqty, i);
                this.getModel().setValue("orderqty", (Object)orderqty, i);
                this.getModel().setValue("billstatus", (Object)billstatus, i);
            }
        }
    }

    private List<Map<String, Object>> getDate(String orderType, Long purorg) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map dropConfigures = PlanOrderHelper.getDropConfigures((Long)purorg);
        String entityNumber = this.getEntityNumber();
        HashMap ruleByDropConfigureMap = Maps.newHashMapWithExpectedSize((int)dropConfigures.size());
        for (DynamicObject dropConfigure : dropConfigures.values()) {
            DynamicObjectCollection entrys = dropConfigure.getDynamicObjectCollection(ENTRY_ENTITY);
            for (DynamicObject entry : entrys) {
                String dataorderType = entry.getString("ordertype");
                if (!dataorderType.equals(orderType)) continue;
                String targetEntity = entry.getDynamicObject("targetbill").getPkValue().toString();
                List loadRules = BOTPHelper.getRules((String)entityNumber, (String)targetEntity);
                if ((loadRules = BOTPHelper.excludeConvertRuleByOrdertype((List)loadRules, (String)orderType)) == null || loadRules.isEmpty()) continue;
                for (ConvertRuleElement rule : loadRules) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String id = rule.getId();
                    ruleByDropConfigureMap.put(id, dropConfigure.getPkValue().toString());
                    String name = rule.getName().getLocaleValue();
                    map.put("id", id);
                    map.put("name", name);
                    list.add(map);
                }
            }
        }
        this.getPageCache().put((Map)ruleByDropConfigureMap);
        return list;
    }

    private void setComboEdit(List<Map<String, Object>> dataList) {
        ComboEdit combo = (ComboEdit)this.getView().getControl(BILLTOCONFIG);
        this.setComboValue(combo, this.setComboItems(dataList));
    }

    private void setComboValue(ComboEdit comboEdit, Map<String, LocaleString> value) {
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(value.size());
        for (Map.Entry<String, LocaleString> entry : value.entrySet()) {
            ComboItem item = new ComboItem();
            item.setValue(entry.getKey());
            item.setCaption(entry.getValue());
            comboItems.add(item);
        }
        comboEdit.setComboItems(comboItems);
    }

    private Map<String, LocaleString> setComboItems(List<Map<String, Object>> list) {
        HashMap<String, LocaleString> comboItems = new HashMap<String, LocaleString>();
        if (list != null) {
            for (Map<String, Object> map : list) {
                String id = (String)map.get("id");
                String fName = (String)map.get("name");
                comboItems.put(id, new LocaleString(fName));
            }
        }
        return comboItems;
    }

    private String getEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entitynumber = (String)formShowParameter.getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            entitynumber = "mrp_planorder";
        }
        return entitynumber;
    }
}

