/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.EntryProp;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.common.enums.SupplyRuleEnum;
import kd.mpscmm.msplan.business.custom.ext.IIsCheckBomAndMaterialMustInput;
import kd.mpscmm.msplan.business.custom.ext.IsCheckBomAndMaterialMustInputImpl;
import kd.mpscmm.msplan.business.helper.PlanOperatorGroupHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanScopeHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanViewOrgHelper;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;
import kd.mpscmm.msplan.mrp.common.util.DynamicObjDataUtil;

public class PlanOrderEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String BOM_KEY = "pdm_mftbom";
    private static final String MPDM_MATERIAL_PLAN = "mpdm_materialplan";
    private static final String TABAP = "tabap";
    private static final String ADVCONAP = "advconap";
    private static final String TABPAGEAP1 = "tabpageap1";
    private static final String OLDORDERQTY = "oldorderqty";
    private static final String NEWORDERQTY = "neworderqty";
    private static final String CONFIGPROPERTIES = "configproperties";
    private static final String CONFIGURATION = "2";
    private static final String INWAREHOUSECONFIRMCALLBACK = "inwareHouseconfirmCallBack";
    private static final String DEFPLANSCOPE = "defPlanscope";
    private static final String CACHE_ENABLE_PLAN_SCOPE = "cacheEnablePlanScope";
    private static final String CACHE_NEED_FIND_CONFIG_BOM = "cacheNeedFindConfigBom";
    private static final String CACHE_SUPPLY_CHANGE_BEF_VAL = "cacheSupplyChangeBefVal";
    private static final String CONFIRM_ID_SUPPLY_RULE_CHANGED = "confirmIdSupplyRuleChanged";
    private static final String CACHE_MANUVERSION_FILTER = "cacheManuVersionFilter";
    private static final Log log = LogFactory.getLog(PlanOrderEdit.class);

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        log.info("\u8fdb\u5165propertyChanged\uff0cpropName\uff1a{}", (Object)propertyName);
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            this.propertyChanged(changeData, propertyName);
        }
    }

    private String getMaterialPlanSelectFields() {
        return "id,createorg,masterid,wastagerateformula,yield,plangroup,materialattr,operator,plantags,wastagerate,leadtimetype,materialattr,fixedleadtime,changeleadtime,changebatch,preprocessingtime,inspectionleadtime,postprocessingtime,supplynetwork";
    }

    public void propertyChanged(ChangeData changeData, String propertyName) {
        Object oldObject = changeData.getOldValue();
        Object newObject = changeData.getNewValue();
        DynamicObject propertyValueCDDE = changeData.getDataEntity();
        if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) {
            return;
        }
        int rowIndex = changeData.getRowIndex();
        if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"ordertype")) {
            this.orderTypeChange(newObject);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"material")) {
            this.materialChange(newObject, oldObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"bom")) {
            this.bomChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"unfoldbomdate")) {
            this.unfoldBomDateChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"orderdate")) {
            this.orderDateChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"startdate")) {
            this.startDateChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"enddate")) {
            this.endDateChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrymode")) {
            this.setOrderMaterialEnable(rowIndex, (String)newObject);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrymaterial")) {
            this.entryMaterialChange(newObject, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"orderqty")) {
            this.orderQtyChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"proorpurorg")) {
            this.proOrPurOrgChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"manuversion")) {
            this.manuVersionChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"org")) {
            this.orgChange();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"availabledate")) {
            this.availableDateChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"configuredcode")) {
            this.configuredcodeChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"auxproperty")) {
            this.auxpropertyChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryrequiredate")) {
            this.requireDateChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryrequireqty")) {
            this.requireQtyChange(oldObject, newObject, propertyValueCDDE, rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryfixscrap")) {
            this.qtyChange(propertyValueCDDE, rowIndex, false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryscraprate")) {
            if (newObject instanceof BigDecimal && BigDecimal.ONE.compareTo((BigDecimal)newObject) <= 0) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53d8\u52a8\u635f\u8017\u7387\u8d85\u51fa\u5927\u4e8e\u7b49\u4e8e0\u5c0f\u4e8e1\u7684\u8303\u56f4\u3002", (String)"PlanOrderEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"entryscraprate")));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryscraprate", (Object)oldObject, (int)rowIndex);
            } else {
                this.qtyChange(propertyValueCDDE, rowIndex, false);
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryqtynumerator") || StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryqtydenominator")) {
            this.qtyChange(propertyValueCDDE, rowIndex, true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entryqtytype")) {
            this.qtyChange(propertyValueCDDE, rowIndex, true);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"planscope")) {
            this.planScopeChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"inwarehouse")) {
            this.inwareHouseChange(oldObject, newObject, propertyValueCDDE);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"supplyrule")) {
            this.supplyRuleChange(oldObject, newObject);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"inwarorg")) {
            this.inWareOrgChanged();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrysupplyorgunitid")) {
            this.entrySupplyOrgUnitChanged(rowIndex);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)propertyName, (CharSequence)"entrywarehouse")) {
            this.entryWareHouseChanged(rowIndex);
        }
    }

    private void entrySupplyOrgUnitChanged(int rowIndex) {
        this.getModel().setValue("entrywarehouse", null, rowIndex);
    }

    private void entryWareHouseChanged(int rowIndex) {
        this.getModel().setValue("entrylocation", null, rowIndex);
    }

    private void inWareOrgChanged() {
        this.getModel().setValue("inwarehouse", null);
    }

    private void manuVersionChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof DynamicObject)) {
            this.getModel().setValue("bom", null);
            return;
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        DynamicObject bom = this.getBom(supplyOrg, material, unfoldBomDate, null);
        this.setBomByBackGround(bom);
    }

    private void proOrPurOrgChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        this.getModel().setValue("material", null);
        if (!(newObject instanceof DynamicObject)) {
            this.getModel().setValue("planscope", null);
            this.getModel().setValue("inwarorg", null);
            this.getModel().setValue("inwarelocation", null);
            return;
        }
        DynamicObject proOrPurOrg = (DynamicObject)newObject;
        Long planScopeId = PlanScopeHelper.getPlanScope((Long)proOrPurOrg.getLong("id"));
        this.getModel().setValue("planscope", (Object)planScopeId);
        this.getPageCache().put(DEFPLANSCOPE, planScopeId.toString());
    }

    private void orgChange() {
        this.setDefSupplyRule();
        this.getModel().setValue("material", null);
        this.getModel().setValue("inwarelocation", null);
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule) && org != null) {
            this.getModel().setValue("inwarorg", org.getPkValue());
        } else {
            this.getModel().setValue("inwarorg", null);
        }
        this.setDefPlanScope();
    }

    private void setDefSupplyRule() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject proOrPurOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (org != null && proOrPurOrg != null) {
            long proOrPurOrgId;
            long orgId = org.getLong("id");
            if (orgId != (proOrPurOrgId = proOrPurOrg.getLong("id"))) {
                this.getModel().setValue("supplyrule", (Object)SupplyRuleEnum.ACROSS_ORG_STORE.getValue());
                ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"supplyrule", (String)"", (boolean)true);
            } else {
                ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"supplyrule", (String)"", (boolean)false);
            }
        }
    }

    private void supplyRuleChange(Object oldObject, Object newObject) {
        if (oldObject != null && newObject != null && (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(oldObject) || SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(newObject))) {
            this.getPageCache().put(CACHE_SUPPLY_CHANGE_BEF_VAL, String.valueOf(oldObject));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u82e5\u4f9b\u5e94\u89c4\u5219\u5728\u8de8\u7ec4\u7ec7\u5165\u5e93\u6216\u975e\u8de8\u7ec4\u7ec7\u5165\u5e93\u4e4b\u95f4\u5207\u6362\uff0c\u4f1a\u6e05\u7a7a\u7269\u6599\u3001\u8ba1\u5212\u8303\u56f4\u3001\u5165\u5e93\u7ec4\u7ec7\u3001\u5165\u5e93\u4ed3\u5e93\u3001\u5165\u5e93\u4ed3\u4f4d\u7b49\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6e05\u7a7a\uff1f", (String)"PlanOrderEdit_47", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_ID_SUPPLY_RULE_CHANGED, (IFormPlugin)this));
        } else {
            this.supplyRuleChange(false);
        }
    }

    private void supplyRuleChange(boolean clearMaterial) {
        if (clearMaterial) {
            this.getModel().setValue("material", null);
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
            this.getModel().setValue("inwarorg", (Object)org);
        } else {
            this.getModel().setValue("inwarorg", (Object)supplyOrg);
        }
        this.setDefPlanScope();
    }

    private void inwareHouseChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        this.getModel().setValue("inwarelocation", null);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if (INWAREHOUSECONFIRMCALLBACK.equals(callBackId) && result == MessageBoxResult.Yes) {
            String inwarOrgStr = this.getPageCache().get("inwarOrg");
            String planScopeStr = this.getPageCache().get("planScope");
            String inwareHouseStr = this.getPageCache().get("inwareHouse");
            this.getModel().beginInit();
            this.getModel().setValue("inwarehouse", (Object)Long.valueOf(inwareHouseStr));
            this.getModel().setValue("inwarorg", (Object)Long.valueOf(inwarOrgStr));
            this.getModel().setValue("planscope", (Object)Long.valueOf(planScopeStr));
            this.getModel().endInit();
            this.getView().updateView("inwarehouse");
            this.getView().updateView("inwarorg");
            this.getView().updateView("planscope");
        } else if (CONFIRM_ID_SUPPLY_RULE_CHANGED.equals(callBackId)) {
            String oldValue = this.getPageCache().get(CACHE_SUPPLY_CHANGE_BEF_VAL);
            this.getPageCache().remove(CACHE_SUPPLY_CHANGE_BEF_VAL);
            if (result == MessageBoxResult.Yes) {
                this.supplyRuleChange(true);
            } else {
                this.getModel().beginInit();
                this.getModel().setValue("supplyrule", (Object)oldValue);
                this.getModel().endInit();
                this.getView().updateView("supplyrule");
            }
        }
    }

    private void planScopeChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        this.setInWareInfo();
    }

    private void auxpropertyChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        QFilter auxptyqfilter;
        boolean isaCarryBom;
        if (!(newObject instanceof DynamicObject)) {
            this.getModel().setValue("bom", null);
            return;
        }
        DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"material");
        if (material == null) {
            return;
        }
        boolean isAffectPlan = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, null);
        if (!isAffectPlan) {
            return;
        }
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        DynamicObject bom = null;
        DynamicObject auxpty = (DynamicObject)newObject;
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        if (unfoldBomDate == null) {
            unfoldBomDate = new Date();
        }
        if (!(isaCarryBom = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, (DynamicObject)auxpty)) && (bom = this.getBom(supplyOrg, material, unfoldBomDate, auxptyqfilter = new QFilter("auxproperty", "=", auxpty.getPkValue()))) == null) {
            List auxptyEntryMust = PlanOrderHelper.getAuxptyEntryMust((DynamicObject)material);
            auxptyqfilter = null;
            if (auxpty != null && isAffectPlan) {
                String json = auxpty.getString("value");
                Map values = (Map)JSON.parseObject((String)json, Map.class);
                for (Map.Entry value : values.entrySet()) {
                    Object key = value.getKey();
                    if (!auxptyEntryMust.contains(key)) continue;
                    StringBuilder str = new StringBuilder();
                    str.append("%\"").append(key).append("\":");
                    Object val = value.getValue();
                    if (val instanceof String) {
                        str.append("\"").append(val).append("\"%");
                    } else if (val instanceof Integer || val instanceof Long) {
                        str.append(val).append("%");
                    }
                    QFilter auxpropertyqfilter = new QFilter("auxproperty.value", "like", (Object)str.toString());
                    if (auxptyqfilter == null) {
                        auxptyqfilter = auxpropertyqfilter;
                        continue;
                    }
                    auxptyqfilter.and(auxpropertyqfilter);
                }
            }
            bom = this.getBom(supplyOrg, material, unfoldBomDate, auxptyqfilter);
        }
        String materialAttr = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"ordertype");
        if ((MaterialAttrEnum.FABRICATEDPART.getValue().equals(materialAttr) || MaterialAttrEnum.EXTERNALPROCESSINPART.getValue().equals(materialAttr)) && this.getModel().getValue("unfoldbomdate") == null) {
            this.getModel().beginInit();
            this.getModel().setValue("unfoldbomdate", (Object)new Date());
            this.getModel().endInit();
            this.getView().updateView("unfoldbomdate");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)materialAttr) && StringUtils.isNotBlank((CharSequence)materialAttr)) {
            this.setBomByBackGround(bom);
        }
    }

    private void configuredcodeChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof DynamicObject)) {
            this.getModel().setValue("bom", null);
            return;
        }
        DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"material");
        if (material == null) {
            return;
        }
        Boolean isExistManuversion = this.isExistProperties("manuversion");
        String configproperties = material.getString(CONFIGPROPERTIES);
        if (!CONFIGURATION.equals(configproperties)) {
            return;
        }
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        DynamicObject configuredcode = (DynamicObject)newObject;
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        if (unfoldBomDate == null) {
            unfoldBomDate = new Date();
        }
        QFilter configuredcodeqfilter = new QFilter("configuredcode", "=", configuredcode.getPkValue());
        DynamicObject bom = null;
        String materialAttr = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"materialattr");
        if ((MaterialAttrEnum.FABRICATEDPART.getValue().equals(materialAttr) || MaterialAttrEnum.EXTERNALPROCESSINPART.getValue().equals(materialAttr)) && this.getModel().getValue("unfoldbomdate") == null) {
            this.getModel().beginInit();
            this.getModel().setValue("unfoldbomdate", (Object)new Date());
            this.getModel().endInit();
            this.getView().updateView("unfoldbomdate");
        }
        bom = this.getBom(supplyOrg, material, unfoldBomDate, configuredcodeqfilter);
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)materialAttr) && StringUtils.isNotBlank((CharSequence)materialAttr)) {
            this.setBomByBackGround(bom);
        }
    }

    private DynamicObject getManuVersion(long materialId, long supplyOrgId, Date unfoldBomDate, BigDecimal orderQty, Long configuredcodeId, Long auxpropertyId) {
        if (supplyOrgId == 0L || unfoldBomDate == null || orderQty == null) {
            return null;
        }
        ArrayList params = new ArrayList(16);
        HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>(16);
        map.put("bizorg", Long.valueOf(supplyOrgId));
        map.put("material", Long.valueOf(materialId));
        map.put("bomdate", unfoldBomDate);
        map.put("workcenter", Long.valueOf(0L));
        map.put("qty", orderQty);
        map.put("configure", configuredcodeId);
        map.put("auxproperty", auxpropertyId);
        params.add(map);
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        if (resMap == null || resMap.isEmpty()) {
            return null;
        }
        DynamicObject manuVersion = null;
        for (Map matmanuVersion : resMap.values()) {
            for (Map.Entry dataEntry : matmanuVersion.entrySet()) {
                Long material = Long.valueOf(dataEntry.getKey().toString());
                if (materialId != material) continue;
                Iterator iterator = ((Set)dataEntry.getValue()).iterator();
                while (iterator.hasNext()) {
                    DynamicObject data;
                    manuVersion = data = (DynamicObject)iterator.next();
                }
            }
        }
        return manuVersion;
    }

    private void setBomByBackGround(DynamicObject bom) {
        DynamicObject oldBom = (DynamicObject)this.getModel().getValue("bom");
        this.getModel().setValue("bom", (Object)bom);
        if (oldBom == null && bom == null) {
            this.bomChange(null, null, null);
        }
    }

    private DynamicObject getBom(DynamicObject supplyOrg, DynamicObject material, Date unfoldBomDate, QFilter qfilter) {
        String configProperties;
        if (supplyOrg == null || material == null || unfoldBomDate == null) {
            return null;
        }
        DynamicObject manuVersion = null;
        Boolean existManuVersion = this.isExistProperties("manuversion");
        if (existManuVersion.booleanValue()) {
            long supplyOrgId = supplyOrg.getLong("id");
            BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
            DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
            DynamicObject auxproperty = (DynamicObject)this.getModel().getValue("auxproperty");
            Long configuredcodeId = 0L;
            if (configuredcode != null) {
                configuredcodeId = configuredcode.getLong("id");
            }
            Long auxpropertyId = 0L;
            if (auxproperty != null) {
                auxpropertyId = auxproperty.getLong("id");
            }
            StringBuilder sb = new StringBuilder();
            String cacheValue = sb.append(material.getLong("id")).append(supplyOrgId).append(unfoldBomDate).append(orderQty).append(configuredcodeId).append(auxpropertyId).toString();
            String cacheManuversionFilter = this.getPageCache().get(CACHE_MANUVERSION_FILTER);
            if (cacheManuversionFilter != null && cacheManuversionFilter.equals(cacheValue)) {
                manuVersion = (DynamicObject)this.getModel().getValue("manuversion");
            } else {
                this.getPageCache().put(CACHE_MANUVERSION_FILTER, cacheValue);
                manuVersion = this.getManuVersion(material.getLong("id"), supplyOrgId, unfoldBomDate, orderQty, configuredcodeId, auxpropertyId);
                this.getModel().beginInit();
                if (manuVersion == null) {
                    this.getModel().setValue("manuversion", null);
                } else {
                    this.getModel().setValue("manuversion", (Object)manuVersion.getLong("id"));
                }
                this.getModel().endInit();
                this.getView().updateView("manuversion");
            }
        }
        if (CONFIGURATION.equals(configProperties = material.getString(CONFIGPROPERTIES))) {
            return this.getBomIsConfig(supplyOrg, material, unfoldBomDate, manuVersion);
        }
        return this.getBomIsNotConfig(supplyOrg, material, unfoldBomDate, manuVersion);
    }

    private DynamicObject getBomIsNotConfig(DynamicObject supplyOrg, DynamicObject material, Date unfoldBomDate, DynamicObject manuVersion) {
        String purpose;
        DynamicObject bom;
        DynamicObject bomType;
        Long bomId;
        if (supplyOrg == null || material == null || unfoldBomDate == null) {
            return null;
        }
        if (manuVersion != null && (bomId = PlanScopeHelper.getDataId((Object)manuVersion.get("bom"))) != null && bomId != 0L && (bomType = (bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)BOM_KEY)).getDynamicObject("type")) != null && "A".equals(purpose = (bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)"mpdm_bomtype")).getString("purpose"))) {
            log.info("\u975e\u914d\u7f6e\u4ef6\u53d6BOM\uff1a\u4ece\u751f\u4ea7\u7248\u672c\u4e2d\u627e\u5230bom[{}]", bom.getPkValue());
            return bom;
        }
        DynamicObject auxProperty = (DynamicObject)this.getModel().getValue("auxproperty");
        Long auxPropertyId = null;
        if (auxProperty != null) {
            auxPropertyId = auxProperty.getLong("id");
        }
        return this.getBomGeneral(supplyOrg, material, unfoldBomDate, "", null, auxPropertyId);
    }

    private DynamicObject getBomIsConfig(DynamicObject supplyOrg, DynamicObject material, Date unfoldBomDate, DynamicObject manuVersion) {
        String purpose;
        DynamicObject bom;
        DynamicObject bomType;
        Long bomId;
        DynamicObject configuredCode = (DynamicObject)this.getModel().getValue("configuredcode");
        if (supplyOrg == null || material == null || unfoldBomDate == null || configuredCode == null) {
            return null;
        }
        if (manuVersion != null && (bomId = PlanScopeHelper.getDataId((Object)manuVersion.get("bom"))) != null && bomId != 0L && (bomType = (bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)BOM_KEY)).getDynamicObject("type")) != null && ("B".equals(purpose = (bomType = BusinessDataServiceHelper.loadSingleFromCache((Object)bomType.getPkValue(), (String)"mpdm_bomtype")).getString("purpose")) || "C".equals(purpose))) {
            log.info("\u914d\u7f6e\u4ef6\u53d6BOM\uff1a\u4ece\u751f\u4ea7\u7248\u672c\u4e2d\u627e\u5230bom[{}]", (Object)bomId);
            return bom;
        }
        long configuredCodeId = configuredCode.getLong("id");
        DynamicObject bom2 = this.getBomGeneral(supplyOrg, material, unfoldBomDate, "C", configuredCodeId, null);
        if (bom2 == null) {
            this.getPageCache().put(CACHE_NEED_FIND_CONFIG_BOM, "true");
            log.info("\u914d\u7f6e\u4ef6\u53d6BOM\uff1a\u4ece\u751f\u4ea7\u7248\u672c\u4e2d\u672a\u627e\u5230bom\uff0c\u9700\u8981\u901a\u8fc7\u5c55BOM\u670d\u52a1\u627eBOM");
        }
        return bom2;
    }

    private void orderDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof Date)) {
            return;
        }
        Date date = (Date)newObject;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getModel().setValue("orderdate", (Object)date);
            return;
        }
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        Long supplyOrgid = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)supplyOrgid, (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache());
        if (entryMaterialPlan == null) {
            this.getModel().setValue("orderdate", (Object)date);
            return;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(date);
        }
        if (date == null) {
            date = (Date)newObject;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg")));
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            this.getModel().setValue("availabledate", null);
        } else {
            BigDecimal preprocessingtime = entryMaterialPlan.getBigDecimal("preprocessingtime");
            int days = preprocessingtime.setScale(0, 0).intValue();
            Date startdate = PlanOrderHelper.getToWorkDateToDate((int)days, (Date)date, (Long)supplyOrgid, (String)materialattr);
            Date oldStartDate = (Date)this.getModel().getValue("startdate");
            if (startdate != null) {
                if (oldStartDate != null && startdate.compareTo(oldStartDate) == 0) {
                    this.startDateChange(oldStartDate, startdate, null);
                } else {
                    this.getModel().setValue("startdate", (Object)startdate);
                }
            }
        }
    }

    private DynamicObject getBomGeneral(DynamicObject supplyOrg, DynamicObject material, Date unfoldBomDate, String bomType, Long configuredCodeId, Long auxPropertyId) {
        DynamicObjectCollection col;
        QFilter masteridQF;
        QFilter bomTypeFilter = null;
        if (StringUtils.isNotBlank((CharSequence)bomType)) {
            QFilter purposeFilter = new QFilter("purpose", "=", (Object)bomType);
            DynamicObjectCollection bomTypeList = QueryServiceHelper.query((String)"mpdm_bomtype", (String)"id", (QFilter[])purposeFilter.toArray());
            List bomTypeIdList = bomTypeList.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
            bomTypeFilter = new QFilter("type", "in", bomTypeIdList);
        }
        QFilter statusQF = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableQF = new QFilter("enable", "=", (Object)"1");
        QFilter materialQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", (Long)Long.valueOf(supplyOrg.getPkValue().toString()));
        DynamicObjectCollection materialInfos = QueryServiceHelper.query((String)"bd_materialmftinfo", (String)"id", (QFilter[])new QFilter[]{materialQfilter, masteridQF = new QFilter("masterid", "=", (Object)material.getLong("id")), statusQF, enableQF});
        if (materialInfos.isEmpty()) {
            return null;
        }
        HashSet materialInfoIds = new HashSet(materialInfos.size());
        materialInfos.forEach(s -> materialInfoIds.add(s.getLong("id")));
        QFilter basedataQfilter = BaseDataServiceHelper.getBaseDataFilter((String)BOM_KEY, (Long)Long.valueOf(supplyOrg.getPkValue().toString()));
        QFilter materialQF = new QFilter("material", "in", materialInfoIds);
        QFilter materialQF2 = new QFilter("materialid", "=", (Object)material.getLong("id"));
        materialQF.or(materialQF2);
        ArrayList<QFilter> bomFilterList = new ArrayList<QFilter>();
        bomFilterList.add(basedataQfilter);
        bomFilterList.add(materialQF);
        bomFilterList.add(statusQF);
        bomFilterList.add(enableQF);
        if (bomTypeFilter != null) {
            bomFilterList.add(bomTypeFilter);
        }
        if (configuredCodeId != null) {
            bomFilterList.add(new QFilter("configuredcode", "=", (Object)configuredCodeId));
        }
        if (auxPropertyId != null) {
            bomFilterList.add(new QFilter("auxproperty", "=", (Object)auxPropertyId));
        }
        if ((col = QueryServiceHelper.query((String)BOM_KEY, (String)"id,version,ecn", (QFilter[])bomFilterList.toArray(new QFilter[0]))).isEmpty()) {
            return null;
        }
        HashSet verSet = new HashSet(col.size());
        col.forEach(s -> verSet.add(s.getLong("version")));
        DynamicObjectCollection verCol = QueryServiceHelper.query((String)"bd_bomversion", (String)"id,effectdate,invaliddate", (QFilter[])new QFilter[]{new QFilter("id", "in", verSet)});
        Date date = null;
        long versionId = 0L;
        for (DynamicObject obj : verCol) {
            if (unfoldBomDate.before(obj.getDate("effectdate")) || unfoldBomDate.after(obj.getDate("invaliddate")) || date != null && !date.before(obj.getDate("effectdate"))) continue;
            date = obj.getDate("effectdate");
            versionId = obj.getLong("id");
        }
        if (versionId == 0L) {
            for (DynamicObject obj : col) {
                if (obj.getLong("version") != 0L) continue;
                long bomId = obj.getLong("id");
                return BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)BOM_KEY, (String)"id");
            }
        } else {
            for (DynamicObject obj : col) {
                if (obj.getLong("version") != versionId) continue;
                long bomId = obj.getLong("id");
                return BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)BOM_KEY, (String)"id");
            }
        }
        return null;
    }

    private void qtyChange(DynamicObject propertyValueCDDE, int rowIndex, boolean isRecalculationStandQty) {
        if (rowIndex < 0) {
            return;
        }
        BigDecimal orderQty = DynamicObjDataUtil.getDataModelBigDecimalData((IDataModel)this.getModel(), (String)"orderqty");
        this.recalCulationQty(propertyValueCDDE, this.getModel().getEntryRowEntity("entryentity", rowIndex), rowIndex, orderQty, isRecalculationStandQty);
    }

    private void requireQtyChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        if (!(newObject instanceof BigDecimal) || !(oldObject instanceof BigDecimal)) {
            return;
        }
        BigDecimal reqQty = (BigDecimal)newObject;
        BigDecimal oldreqQty = (BigDecimal)oldObject;
        DynamicObject entryreplaceplan = propertyValueCDDE.getDynamicObject("entryreplaceplan");
        if (entryreplaceplan == null && reqQty.compareTo(BigDecimal.ZERO) <= 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u9700\u6c42\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0", (String)"PlanOrderEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex + 1));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequireqty", (Object)oldreqQty, (int)rowIndex);
            return;
        }
        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryscraprate", (Object)BigDecimal.ZERO, (int)rowIndex);
        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryfixscrap", (Object)BigDecimal.ZERO, (int)rowIndex);
        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entrylossqty", (Object)BigDecimal.ZERO, (int)rowIndex);
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        FormShowParameter formParamter = (FormShowParameter)e.getSource();
        Map customerParam = formParamter.getCustomParams();
        if (customerParam.get("orderType") != null) {
            String orderType = (String)customerParam.get("orderType");
            if ("10030".equals(orderType)) {
                formParamter.setCaption(ResManager.loadKDString((String)"\u81ea\u5236\u8ba1\u5212\u8ba2\u5355", (String)"PlanOrderEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if ("10040".equals(orderType)) {
                formParamter.setCaption(ResManager.loadKDString((String)"\u5916\u8d2d\u8ba1\u5212\u8ba2\u5355", (String)"PlanOrderEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if ("10050".equals(orderType)) {
                formParamter.setCaption(ResManager.loadKDString((String)"\u59d4\u5916\u8ba1\u5212\u8ba2\u5355", (String)"PlanOrderEdit_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        String orderType = PlanOrderHelper.getMenuParams((IFormView)parentView, (String)"orderType");
        if (!StringUtils.isEmpty((CharSequence)orderType)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"ordertype"});
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefPlanScope();
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView == null) {
            return;
        }
        String orderType = PlanOrderHelper.getMenuParams((IFormView)parentView, (String)"orderType");
        if (!StringUtils.isEmpty((CharSequence)orderType)) {
            this.getModel().setValue("ordertype", (Object)orderType);
        }
        this.orderTypeChange(null);
        this.materialChange(null, null, null);
        this.bomChange(null, null, null);
    }

    private void setDefPlanScope() {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        boolean enablePlanScope = this.isEnablePlanScope();
        if (supplyOrg == null || !enablePlanScope) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        long orgId = org.getLong("id");
        long supplyOrgId = supplyOrg.getLong("id");
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        Long planScopeId = orgId != supplyOrgId && SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule) ? PlanScopeHelper.getPlanScope((Long)orgId) : PlanScopeHelper.getPlanScope((Long)supplyOrgId);
        this.getPageCache().put(DEFPLANSCOPE, planScopeId.toString());
        if (planScopeId == 0L) {
            this.getModel().setValue("planscope", null);
        } else {
            this.getModel().setValue("planscope", (Object)planScopeId);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String key;
        EntryProp prop = e.getEntryProp();
        String string = key = prop == null ? "" : prop.getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entryentity")) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity row : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = row.getRowIndex();
                Date startDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)this.getModel(), (String)"startdate");
                if (startDate != null) {
                    this.getModel().setValue("entryrequiredate", (Object)startDate, rowIndex);
                    continue;
                }
                this.getModel().setValue("entryrequiredate", (Object)new Date(), rowIndex);
            }
        }
    }

    private long getDefaultEntrySupplyOrgUnitId(DynamicObject entryMaterialPlan) {
        DynamicObject supplyNetwork;
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        long defaultEntrySupplyOrgUnitId = supplyOrg.getLong("id");
        if (entryMaterialPlan == null) {
            log.info("\u8ba2\u5355\u7269\u6599\u589e\u884c\uff0c\u672a\u627e\u5230\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u4f9b\u8d27\u7ec4\u7ec7\u9ed8\u8ba4\u53d6\u4f9b\u5e94\u7ec4\u7ec7");
            return defaultEntrySupplyOrgUnitId;
        }
        String materialAttr = entryMaterialPlan.getString("materialattr");
        if (MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr) && (supplyNetwork = entryMaterialPlan.getDynamicObject("supplynetwork")) != null) {
            supplyNetwork = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyNetwork.getPkValue(), (String)"mrp_definitionsupply");
            long defSupplyTypeId = supplyNetwork.getLong("defsupplytype_id");
            DynamicObjectCollection orgEntry = supplyNetwork.getDynamicObjectCollection("orgentry");
            String entrySupplyRule = "";
            long entrySupplyOrgId = 0L;
            for (DynamicObject row : orgEntry) {
                long supplyOrgTypeId = row.getLong("supplyorgtype_id");
                if (supplyOrgTypeId != defSupplyTypeId) continue;
                entrySupplyRule = row.getString("supplyrule");
                entrySupplyOrgId = row.getLong("supplyorg_id");
            }
            if (SupplyRuleEnum.ACROSS_ORG_REQ.getValue().equals(entrySupplyRule)) {
                defaultEntrySupplyOrgUnitId = entrySupplyOrgId;
            }
        }
        return defaultEntrySupplyOrgUnitId;
    }

    public void afterBindData(EventObject e) {
        boolean isAffectPlan;
        super.afterBindData(e);
        String billstatus = (String)this.getModel().getValue("billstatus");
        if (StringUtils.equalsIgnoreCase((CharSequence)"D", (CharSequence)billstatus)) {
            this.getView().setStatus(OperationStatus.VIEW);
            this.getView().setEnable(Boolean.FALSE, new String[]{"contentpanelflex"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_new", "bar_del", "bar_save", "bar_submit", "bar_audit", "bar_submitandnew"});
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)billstatus)) {
            String orderType = (String)this.getModel().getValue("ordertype");
            this.loadDate(orderType);
        }
        int size = this.getModel().getEntryRowCount("entryentity");
        for (int i = 0; i < size; ++i) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
            String entryMode = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entrymode");
            this.setOrderMaterialEnable(i, entryMode);
        }
        this.loadCopEntry();
        DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"material");
        if (material == null) {
            return;
        }
        String configproperties = material.getString(CONFIGPROPERTIES);
        if (CONFIGURATION.equals(configproperties)) {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"configuredcode", (String)"", (boolean)true);
        }
        if (isAffectPlan = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, null)) {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"auxproperty", (String)"", (boolean)true);
        }
    }

    private void loadCopEntry() {
        int rowIndex = this.getModel().getEntryRowCount("copentry");
        boolean isVisible = false;
        if (rowIndex > 0) {
            isVisible = true;
        }
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{ADVCONAP});
    }

    private Boolean isExistProperties(String propertie) {
        String isExist = this.getPageCache().get(propertie);
        if (isExist != null) {
            if (isExist.equals("true")) {
                return Boolean.TRUE;
            }
            if (isExist.equals("false")) {
                return Boolean.FALSE;
            }
        }
        String name = this.getModel().getDataEntityType().getName();
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)name);
        DataEntityPropertyCollection properties = obj.getDataEntityType().getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!propertie.equals(pro.getName())) continue;
            this.getPageCache().put(propertie, "true");
            return Boolean.TRUE;
        }
        this.getPageCache().put(propertie, "false");
        return Boolean.FALSE;
    }

    private void loadDate(String orderType) {
        if (StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)orderType) || StringUtils.isBlank((CharSequence)orderType)) {
            Boolean isExist;
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setValue("bom", null);
            this.getModel().setValue("unfoldbomdate", null);
            if (this.isExistProperties("manuversion").booleanValue()) {
                this.getModel().setValue("manuversion", null);
                this.getView().setEnable(Boolean.FALSE, new String[]{"manuversion"});
            }
            if ((isExist = this.isExistProperties("ecnversion")).booleanValue()) {
                this.getModel().setValue("ecnversion", null);
                this.setControlEnable(Boolean.FALSE, "ecnversion", -1);
            }
            this.setControlEnable(Boolean.FALSE, "bom", -1);
            this.setControlEnable(Boolean.FALSE, "unfoldbomdate", -1);
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"bom", (String)"", (boolean)false);
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"unfoldbomdate", (String)"", (boolean)false);
        } else {
            this.setControlEnable(Boolean.TRUE, "bom", -1);
            this.setControlEnable(Boolean.TRUE, "unfoldbomdate", -1);
            if (this.isExistProperties("manuversion").booleanValue()) {
                this.getView().setEnable(Boolean.TRUE, new String[]{"manuversion"});
            }
            IsCheckBomAndMaterialMustInputImpl defXXXSubPlugin = new IsCheckBomAndMaterialMustInputImpl();
            PluginProxy pluginProxy = PluginProxy.create((Object)defXXXSubPlugin, IIsCheckBomAndMaterialMustInput.class, (String)"MRP_CHECK_BOM_MATERIAL_MUSTINPUT", null);
            List results = pluginProxy.callReplaceIfPresent(p -> p.isCheckBomMustInput());
            boolean isCheckBom = true;
            for (Boolean result : results) {
                if (result.booleanValue()) continue;
                isCheckBom = result;
            }
            if (isCheckBom) {
                ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"bom", (String)"", (boolean)true);
                ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"unfoldbomdate", (String)"", (boolean)true);
            }
        }
    }

    private void requireDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        if (!(newObject instanceof Date)) {
            return;
        }
        Date requireDate = (Date)newObject;
        Date startDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)this.getModel(), (String)"startdate");
        Date endDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)this.getModel(), (String)"enddate");
        if (startDate == null) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequiredate", (Object)oldObject, (int)rowIndex);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderEdit_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex));
        } else if (endDate == null) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequiredate", (Object)oldObject, (int)rowIndex);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderEdit_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex));
        } else if (requireDate.compareTo(endDate) > 0 || requireDate.compareTo(startDate) < 0) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequiredate", (Object)oldObject, (int)rowIndex);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u9700\u6c42\u65e5\u671f\u4e0d\u5728\u8ba1\u5212\u5f00\u59cb\u65f6\u95f4\u548c\u8ba1\u5212\u5b8c\u6210\u65f6\u95f4\u4e4b\u95f4\u3002", (String)"PlanOrderEdit_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex));
        } else {
            Date date = (Date)newObject;
            if ((date = this.getRecentWorkDate(date)) == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequiredate", (Object)newObject, (int)rowIndex);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u9700\u6c42\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderEdit_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex));
            } else {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"entryrequiredate", (Object)date, (int)rowIndex);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("newentry".equals(e.getOperateKey())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            this.qtyChange(null, rowIndex, true);
        }
    }

    private void orderQtyChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        Boolean materiallock;
        if (!(newObject instanceof BigDecimal) || !(oldObject instanceof BigDecimal)) {
            return;
        }
        BigDecimal oldorderQty = (BigDecimal)oldObject;
        DynamicObjectCollection entrys = this.getModel().getEntryEntity("entryentity");
        DynamicObjectCollection copentrys = this.getModel().getEntryEntity("copentry");
        BigDecimal orderQty = (BigDecimal)newObject;
        if (BigDecimal.ZERO.compareTo(oldorderQty) < 0) {
            this.getPageCache().put(OLDORDERQTY, oldorderQty.toString());
            this.getPageCache().put(NEWORDERQTY, orderQty.toString());
        }
        if (!(materiallock = (Boolean)this.getModel().getValue("materiallock")).booleanValue()) {
            this.orderDateChange(this.getModel().getValue("orderdate"), this.getModel().getValue("orderdate"), null);
            if (entrys != null && !entrys.isEmpty()) {
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    String entryMode = entry.getString("entrymode");
                    if (StringUtils.equalsIgnoreCase((CharSequence)entryMode, (CharSequence)"B")) continue;
                    this.recalCulationQty(entry, entry, i, orderQty, true);
                }
            }
        } else {
            if (entrys != null && !entrys.isEmpty()) {
                for (int i = 0; i < entrys.size(); ++i) {
                    DynamicObject entry = (DynamicObject)entrys.get(i);
                    DynamicObject entryreplaceplan = entry.getDynamicObject("entryreplaceplan");
                    BigDecimal entryrequireqty = entry.getBigDecimal("entryrequireqty");
                    if (entryreplaceplan != null && BigDecimal.ZERO.compareTo(entryrequireqty) == 0) continue;
                    this.recalCulationQty(entry, entry, i, orderQty, true);
                }
                this.getPageCache().remove(NEWORDERQTY);
                this.getPageCache().remove(OLDORDERQTY);
            }
            if (copentrys != null && !copentrys.isEmpty()) {
                this.recalCulationCopentrysQty(copentrys, orderQty);
            }
        }
        this.setManuVersion();
    }

    private void setManuVersion() {
        Boolean isExistManuversion = this.isExistProperties("manuversion");
        if (!isExistManuversion.booleanValue()) {
            return;
        }
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        if (supplyOrg == null || material == null || unfoldBomDate == null) {
            return;
        }
        long supplyOrgId = supplyOrg.getLong("id");
        long materialId = material.getLong("id");
        BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
        DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
        DynamicObject auxproperty = (DynamicObject)this.getModel().getValue("auxproperty");
        Long configuredcodeId = 0L;
        if (configuredcode != null) {
            configuredcodeId = configuredcode.getLong("id");
        }
        Long auxpropertyId = 0L;
        if (auxproperty != null) {
            auxpropertyId = auxproperty.getLong("id");
        }
        StringBuilder sb = new StringBuilder();
        String cacheValue = sb.append(material.getLong("id")).append(supplyOrgId).append(unfoldBomDate).append(orderQty).append(configuredcodeId).append(auxpropertyId).toString();
        String cacheManuversionFilter = this.getPageCache().get(CACHE_MANUVERSION_FILTER);
        if (cacheManuversionFilter != null && cacheManuversionFilter.equals(cacheValue)) {
            return;
        }
        this.getPageCache().put(CACHE_MANUVERSION_FILTER, cacheValue);
        DynamicObject manuVersion = this.getManuVersion(material.getLong("id"), supplyOrgId, unfoldBomDate, orderQty, configuredcodeId, auxpropertyId);
        if (manuVersion == null) {
            return;
        }
        this.getModel().setValue("manuversion", (Object)manuVersion.getLong("id"));
    }

    private void recalCulationCopentrysQty(DynamicObjectCollection copentrys, BigDecimal orderQty) {
        this.getModel().beginInit();
        for (int i = 0; i < copentrys.size(); ++i) {
            DynamicObject copentry = (DynamicObject)copentrys.get(i);
            BigDecimal copentryqty = copentry.getBigDecimal("copentryqty");
            BigDecimal copentryallqty = copentryqty.multiply(orderQty);
            this.getModel().setValue("copentryallqty", (Object)copentryallqty, i);
        }
        this.getModel().endInit();
        this.getView().updateView("copentry");
    }

    private void recalCulationQty(DynamicObject propertyValueCDDE, DynamicObject entry, int i, BigDecimal orderQty, boolean isRecalculationStandQty) {
        String wastagerateformula = entry.getString("wastagerateformula");
        int precision = 2;
        if (entry.getDynamicObject("entryunit") != null) {
            precision = entry.getDynamicObject("entryunit").get("precision") == null ? 2 : entry.getDynamicObject("entryunit").getInt("precision");
        }
        String entryqtytype = entry.getString("entryqtytype");
        BigDecimal useratio = new BigDecimal("100").divide(BigDecimal.valueOf(100L), 4, 4);
        BigDecimal entryscraprate = entry.getBigDecimal("entryscraprate");
        BigDecimal entryfixscrap = entry.getBigDecimal("entryfixscrap");
        BigDecimal entryqtynumerator = entry.getBigDecimal("entryqtynumerator");
        BigDecimal entryqtydenominator = entry.getBigDecimal("entryqtydenominator");
        BigDecimal entrystandqty = entry.getBigDecimal("entrystandqty");
        if (isRecalculationStandQty) {
            BigDecimal oldentrystandqty = entry.getBigDecimal("entrystandqty");
            entrystandqty = PlanOrderHelper.calculateStandQty((int)precision, (String)entryqtytype, (BigDecimal)useratio, (BigDecimal)orderQty, (BigDecimal)entryqtynumerator, (BigDecimal)entryqtydenominator);
            DynamicObject entryreplaceplan = entry.getDynamicObject("entryreplaceplan");
            if (entryreplaceplan != null) {
                String newOrderQtyStr = this.getPageCache().get(NEWORDERQTY);
                String oldOrderQtyStr = this.getPageCache().get(OLDORDERQTY);
                if (StringUtils.isNotBlank((CharSequence)newOrderQtyStr) && StringUtils.isNotBlank((CharSequence)oldOrderQtyStr)) {
                    BigDecimal newOrderQty = new BigDecimal(newOrderQtyStr);
                    BigDecimal oldOrderQty = new BigDecimal(oldOrderQtyStr);
                    entrystandqty = oldentrystandqty.multiply(newOrderQty).divide(oldOrderQty, precision, 4);
                }
            }
        }
        BigDecimal entryrequireqty = PlanOrderHelper.calculateDemadQty((String)wastagerateformula, (int)precision, (boolean)true, (BigDecimal)entrystandqty, (BigDecimal)entryscraprate, (BigDecimal)entryfixscrap);
        String entryrepmaterials = entry.getString("entryrepmaterials");
        BigDecimal entryrepqty = entry.getBigDecimal("entryrepqty");
        if (StringUtils.isNotBlank((CharSequence)entryrepmaterials) && BigDecimal.ZERO.compareTo(entryrepqty) < 0) {
            entryrequireqty = BigDecimal.ZERO;
        }
        BigDecimal entrylossqty = entryrequireqty.subtract(entrystandqty);
        this.getModel().beginInit();
        this.getModel().setValue("entrystandqty", (Object)entrystandqty, i);
        this.getModel().setValue("entryrequireqty", (Object)entryrequireqty, i);
        this.getModel().setValue("entrylossqty", (Object)entrylossqty, i);
        this.getModel().endInit();
        this.getView().updateView("entrystandqty", i);
        this.getView().updateView("entryrequireqty", i);
        this.getView().updateView("entrylossqty", i);
    }

    public void entryMaterialChange(Object newObject, int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        String entryMode = (String)this.getModel().getValue("entrymode", rowIndex);
        if (!(newObject instanceof DynamicObject)) {
            this.getModel().setValue("entryunit", null, rowIndex);
            this.getModel().setValue("entryversion", null, rowIndex);
            this.getModel().setValue("entryconfiguredcode", null, rowIndex);
            return;
        }
        DynamicObject entrymaterial = (DynamicObject)newObject;
        if (!StringUtils.equalsIgnoreCase((CharSequence)entryMode, (CharSequence)"B")) {
            this.addNewEntryMaterialChange(entrymaterial, rowIndex);
        }
    }

    private void addNewEntryMaterialChange(DynamicObject entrymaterial, int rowIndex) {
        long entryMaterialId = entrymaterial.getLong("id");
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)entryMaterialId, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), null, null, (boolean)false);
        DynamicObject entryMaterialMft = PlanOrderHelper.getMaterialMftInfo((Long)entryMaterialId, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), null);
        DynamicObject unit = entrymaterial.getDynamicObject("baseunit");
        String entrysupplytype = "";
        DynamicObject entrysupplyorg = null;
        String attr = "";
        BigDecimal wastagerate = BigDecimal.ZERO;
        String wastagerateformula = "";
        boolean entryisstockallot = false;
        Boolean entryIskeypart = false;
        if (entryMaterialMft != null) {
            entryisstockallot = entryMaterialMft.getBoolean("isstockallot");
            entryIskeypart = entryMaterialMft.getBoolean("iskeypart");
        }
        if (entryMaterialPlan == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u540e\u518d\u65b0\u589e\u3002", (String)"PlanOrderEdit_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getModel().setValue("entrymaterial", null, rowIndex);
            return;
        }
        attr = entryMaterialPlan.getString("materialattr");
        wastagerate = entryMaterialPlan.getBigDecimal("wastagerate");
        wastagerateformula = entryMaterialPlan.getString("wastagerateformula");
        this.getModel().setValue("entrymaterialplanid", entryMaterialPlan.getPkValue());
        Long entrysupplyorgunitid = 0L;
        Long entrywarehouseId = 0L;
        Long entrylocationId = 0L;
        boolean enablePlanScope = this.isEnablePlanScope();
        if (enablePlanScope) {
            Map<String, Long> supplyInfoMap = this.getDefSupplerInfo(entryMaterialPlan, entrymaterial, entrymaterial, null, entryMaterialMft, supplyOrg);
            entrysupplyorgunitid = supplyInfoMap.get("entrysupplyorgunitid");
            entrywarehouseId = supplyInfoMap.get("entrywarehouse");
            entrylocationId = supplyInfoMap.get("entrylocation");
        } else {
            entrysupplyorgunitid = this.getDefaultEntrySupplyOrgUnitId(entryMaterialPlan);
        }
        this.getModel().setValue("entrysupplyorgunitid", (Object)entrysupplyorgunitid, rowIndex);
        this.getModel().setValue("entrywarehouse", (Object)entrywarehouseId, rowIndex);
        this.getModel().setValue("entrylocation", (Object)entrylocationId, rowIndex);
        this.getModel().setValue("entryisstockallot", (Object)entryisstockallot, rowIndex);
        this.getModel().setValue("wastagerateformula", (Object)wastagerateformula, rowIndex);
        this.getModel().setValue("entryunit", unit == null ? null : unit.getPkValue(), rowIndex);
        this.getModel().setValue("entrysupplytype", (Object)entrysupplytype, rowIndex);
        this.getModel().setValue("entryscraprate", (Object)wastagerate, rowIndex);
        this.getModel().setValue("iskeypart", (Object)entryIskeypart, rowIndex);
        DynamicObject proOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (proOrg != null && proOrg.getBoolean("fisinventory")) {
            entrysupplyorg = proOrg;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)attr)) {
            this.setControlEnable(Boolean.TRUE, "entryversion", rowIndex);
        } else {
            this.setControlEnable(Boolean.FALSE, "entryversion", rowIndex);
        }
        this.getModel().setValue("entryversion", null, rowIndex);
        this.getModel().setValue("entrysupplyorg", entrysupplyorg == null ? null : entrysupplyorg.getPkValue(), rowIndex);
        this.getModel().setValue("entryconfiguredcode", null, rowIndex);
    }

    private void orderTypeChange(Object newObject) {
        if (!(newObject instanceof String)) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().setValue("bom", null);
            this.getModel().setValue("unfoldbomdate", null);
            this.setControlEnable(Boolean.FALSE, "bom", -1);
            this.setControlEnable(Boolean.FALSE, "unfoldbomdate", -1);
            return;
        }
        String orderType = (String)newObject;
        this.loadDate(orderType);
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)orderType) && StringUtils.isNotBlank((CharSequence)orderType)) {
            this.getModel().setValue("unfoldbomdate", (Object)new Date());
        } else {
            Tab tab = (Tab)this.getView().getControl(TABAP);
            tab.activeTab("tabpageap");
        }
    }

    public void materialChange(Object newObject, Object oldObject, DynamicObject propertyValueCDDE) {
        Date OrderDate;
        log.info("planorder-insert-materialChange-start");
        long starttime1 = System.currentTimeMillis();
        Boolean isExistManuversion = this.isExistProperties("manuversion");
        this.getPageCache().remove(MPDM_MATERIAL_PLAN);
        if (!(newObject instanceof DynamicObject)) {
            this.setControlEnable(Boolean.FALSE, "bom", -1);
            this.setControlEnable(Boolean.FALSE, "startdate", -1);
            this.setControlEnable(Boolean.FALSE, "enddate", -1);
            this.setControlEnable(Boolean.FALSE, "orderdate", -1);
            this.getModel().setValue("startdate", null);
            this.getModel().setValue("enddate", null);
            this.getModel().setValue("materialattr", null);
            this.getModel().setValue("orderdate", null);
            this.getModel().setValue("configuredcode", null);
            this.getModel().setValue("bom", null);
            this.getModel().setValue("unfoldbomdate", null);
            this.getModel().setValue("auxproperty", null);
            if (isExistManuversion.booleanValue()) {
                this.getModel().setValue("manuversion", null);
            }
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"configuredcode", (String)"", (boolean)false);
            this.getModel().setValue("inwarorg", null);
            this.getModel().setValue("inwarehouse", null);
            this.getModel().setValue("inwarelocation", null);
            return;
        }
        DynamicObject material = (DynamicObject)newObject;
        long materialId = material.getLong("id");
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        long supplyOrgId = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        String listParamsOrderType = null;
        if (parentView != null) {
            listParamsOrderType = PlanOrderHelper.getMenuParams((IFormView)parentView, (String)"orderType");
        }
        long starttime = System.currentTimeMillis();
        DynamicObject materialPlan = PlanOrderHelper.getMaterialInfo((Long)materialId, (Long)supplyOrgId, (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache(), (String)listParamsOrderType, (boolean)false);
        long endtime = System.currentTimeMillis();
        log.info("planorder-insert-materialChange,\u83b7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u5171\u4eab\u7ec4\u7ec7\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        boolean validateResult = this.validateAfterMaterialChanged(oldObject, listParamsOrderType, propertyValueCDDE, materialPlan);
        if (!validateResult) {
            return;
        }
        if (materialPlan == null) {
            return;
        }
        boolean enablePlanScope = this.isEnablePlanScope();
        if (!enablePlanScope) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            long orgId = org == null ? 0L : org.getLong("id");
            String supplyRule = (String)this.getModel().getValue("supplyrule");
            if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
                this.setInWarInfo(orgId, materialId);
            } else {
                this.setInWarInfo(supplyOrgId, materialId);
            }
        } else {
            this.setInWareInfo();
        }
        BigDecimal yield = materialPlan.getBigDecimal("yield");
        String materialAttr = materialPlan.getString("materialattr");
        DynamicObject plan = materialPlan.getDynamicObject("operator");
        this.getModel().setValue("plantags", materialPlan.get("plantags"));
        this.getModel().setValue("materialplanid", materialPlan.getPkValue());
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        if (unfoldBomDate == null) {
            unfoldBomDate = new Date();
        }
        starttime = System.currentTimeMillis();
        DynamicObject bom = this.getBom(supplyOrg, material, unfoldBomDate, null);
        endtime = System.currentTimeMillis();
        log.info("planorder-insert-materialChange,\u83b7\u53d6bom\uff0c\u8017\u65f6" + (endtime - starttime) + "ms");
        DynamicObject baseunit = material.getDynamicObject("baseunit");
        if (yield != null && yield.compareTo(BigDecimal.ZERO) > 0 && yield.compareTo(new BigDecimal("1")) <= 0) {
            this.getModel().setValue("yield", (Object)yield);
        } else {
            this.getModel().setValue("yield", (Object)0);
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String orderdate = sdf.format(new Date());
        Date oldOrderDate = (Date)this.getModel().getValue("orderdate");
        this.getModel().setValue("orderdate", (Object)orderdate);
        if (oldOrderDate != null && (OrderDate = (Date)this.getModel().getValue("orderdate")).compareTo(oldOrderDate) == 0) {
            this.orderDateChange(oldOrderDate, OrderDate, null);
        }
        this.getModel().setValue("materialattr", (Object)materialAttr);
        if (MaterialAttrEnum.PHANTOMPART.getValue().equals(materialAttr)) {
            this.getModel().setValue("ordertype", (Object)MaterialAttrEnum.FABRICATEDPART.getValue());
        } else {
            this.getModel().setValue("ordertype", (Object)materialAttr);
        }
        this.getModel().setValue("planpersonid", plan == null ? null : plan.getPkValue());
        this.getModel().setValue("unit", baseunit == null ? null : baseunit.getPkValue());
        this.setControlEnable(Boolean.TRUE, "startdate", -1);
        this.setControlEnable(Boolean.TRUE, "enddate", -1);
        this.setControlEnable(Boolean.TRUE, "orderdate", -1);
        this.getModel().setValue("configuredcode", null);
        boolean isAffectPlan = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, null);
        if (isAffectPlan) {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"auxproperty", (String)"", (boolean)true);
        }
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"auxproperty", (String)"", (boolean)false);
        String configproperties = material.getString(CONFIGPROPERTIES);
        if (CONFIGURATION.equals(configproperties)) {
            ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"configuredcode", (String)"", (boolean)true);
        }
        String orderType = (String)this.getModel().getValue("ordertype");
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)orderType) && StringUtils.isNotBlank((CharSequence)orderType)) {
            this.setControlEnable(Boolean.TRUE, "bom", -1);
        }
        ControlUtil.setControlMustInput((IFormView)this.getView(), (String)"configuredcode", (String)"", (boolean)false);
        if ((MaterialAttrEnum.FABRICATEDPART.getValue().equals(materialAttr) || MaterialAttrEnum.EXTERNALPROCESSINPART.getValue().equals(materialAttr)) && this.getModel().getValue("unfoldbomdate") == null) {
            this.getModel().beginInit();
            this.getModel().setValue("unfoldbomdate", (Object)new Date());
            this.getModel().endInit();
            this.getView().updateView("unfoldbomdate");
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)materialAttr) && StringUtils.isNotBlank((CharSequence)materialAttr)) {
            this.setBomByBackGround(bom);
        }
        endtime = System.currentTimeMillis();
        log.info("planorder-insert-materialChange-end\uff0c\u8017\u65f6" + (endtime - starttime1) + "ms");
    }

    private boolean validateAfterMaterialChanged(Object oldObject, String listParamsOrderType, DynamicObject propertyValueCDDE, DynamicObject materialPlan) {
        if (materialPlan == null) {
            if (StringUtils.isNotBlank((CharSequence)listParamsOrderType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e0e\u8ba2\u5355\u7c7b\u578b\u4e00\u81f4\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7269\u6599\u5bf9\u5e94\u7684\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_39", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"material", (Object)oldObject);
            this.getView().updateView("materialname");
            return false;
        }
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        long materialId = material.getLong("id");
        String materialName = material.getString("name");
        String materialAttr = materialPlan.getString("materialattr");
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org == null ? 0L : org.getLong("id");
        DynamicObject materialPlanByOrg = PlanOrderHelper.getMaterialInfo((Long)materialId, (Long)orgId, (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache(), (String)listParamsOrderType, (boolean)false);
        boolean enablePlanScope = this.isEnablePlanScope();
        if (!enablePlanScope) {
            return this.validateAfterMaterialChangedIfDisablePlanScope(materialName, materialAttr, supplyRule, materialPlanByOrg, propertyValueCDDE, oldObject);
        }
        return this.validateAfterMaterialChangedIfEnablePlanScope(materialId, materialName, materialAttr, supplyRule, materialPlan, materialPlanByOrg, propertyValueCDDE, oldObject);
    }

    private boolean validateAfterMaterialChangedIfDisablePlanScope(String materialName, String materialAttr, String supplyRule, DynamicObject materialPlanByOrg, DynamicObject dataEntity, Object oldObject) {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        long supplyOrgId = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        String supplyOrgName = supplyOrg == null ? "" : supplyOrg.getString("name");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org == null ? 0L : org.getLong("id");
        String orgName = org == null ? "" : org.getString("name");
        log.info("planorder-insert-materialChange,\u8fdb\u5165\u672a\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u7269\u6599\u5c5e\u6027={}\uff0c\u4f9b\u5e94\u89c4\u5219={}\uff0c\u4f9b\u5e94\u7ec4\u7ec7={}\uff0c\u9700\u6c42\u7ec4\u7ec7={}", new Object[]{materialAttr, supplyRule, supplyOrgId, orgId});
        if (supplyOrgId == orgId) {
            if (MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u81ea\u5236\u4ef6\u3001\u5916\u8d2d\u4ef6\u6216\u5916\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_40", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
        } else {
            if ((SupplyRuleEnum.ACROSS_ORG_REQ.getValue().equals(supplyRule) || SupplyRuleEnum.ACROSS_ORG_TRANSFER.getValue().equals(supplyRule)) && MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u81ea\u5236\u4ef6\u3001\u5916\u8d2d\u4ef6\u6216\u5916\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_40", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
            if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
                DynamicObject supplyNetwork;
                String materialAttrByOrg = materialPlanByOrg == null ? "" : materialPlanByOrg.getString("materialattr");
                log.info("planorder-insert-materialChange,\u8fdb\u5165\u672a\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u6309\u9700\u6c42\u7ec4\u7ec7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u4e2d\u7684\u7269\u6599\u5c5e\u6027={}", (Object)materialAttrByOrg);
                if (!MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttrByOrg)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u5185\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_41", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                    this.getView().updateView("materialname");
                    this.getView().updateView("materialmodule");
                    return false;
                }
                DynamicObject dynamicObject = supplyNetwork = materialPlanByOrg == null ? null : materialPlanByOrg.getDynamicObject("supplynetwork");
                if (supplyNetwork != null) {
                    supplyNetwork = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyNetwork.getPkValue(), (String)"mrp_definitionsupply");
                    DynamicObject defSupplyType = supplyNetwork.getDynamicObject("defsupplytype");
                    long defSupplyTypeId = defSupplyType.getLong("id");
                    DynamicObjectCollection orgEntry = supplyNetwork.getDynamicObjectCollection("orgentry");
                    String supplyRuleFromSupplyNetwork = "";
                    boolean matchSupplyOrg = false;
                    ArrayList<String> supplyOrgNameList = new ArrayList<String>();
                    for (DynamicObject row : orgEntry) {
                        DynamicObject supplyOrgFromSupplyNetwork;
                        long supplyOrgIdFromSupplyNetwork;
                        DynamicObject supplyOrgType = row.getDynamicObject("supplyorgtype");
                        long supplyOrgTypeId = supplyOrgType.getLong("id");
                        if (supplyOrgTypeId != defSupplyTypeId) continue;
                        if ("".equals(supplyRuleFromSupplyNetwork)) {
                            supplyRuleFromSupplyNetwork = row.getString("supplyrule");
                        }
                        if ((supplyOrgIdFromSupplyNetwork = (supplyOrgFromSupplyNetwork = row.getDynamicObject("supplyorg")).getLong("id")) == supplyOrgId) {
                            matchSupplyOrg = true;
                        }
                        supplyOrgNameList.add(supplyOrgFromSupplyNetwork.getString("name"));
                    }
                    log.info("planorder-insert-materialChange,\u8fdb\u5165\u672a\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u4ece\u4f9b\u5e94\u7f51\u7edc\u4e2d\u53d6\u5230\u4f9b\u5e94\u89c4\u5219={}\uff0c\u5339\u914d\u4f9b\u5e94\u7ec4\u7ec7={}", (Object)supplyRuleFromSupplyNetwork, (Object)matchSupplyOrg);
                    if (!SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRuleFromSupplyNetwork)) {
                        SupplyRuleEnum supplyRuleEnum = SupplyRuleEnum.matchByValue((String)supplyRuleFromSupplyNetwork);
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4f9b\u5e94\u7f51\u7edc\u5b9a\u4e49\u4f9b\u5e94\u89c4\u5219\u4e3a\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderEdit_48", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName, supplyRuleEnum.getName()));
                        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                        this.getView().updateView("materialname");
                        this.getView().updateView("materialmodule");
                        return false;
                    }
                    if (!matchSupplyOrg) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\u4e3a\u5185\u534f\u4ef6\uff0c\u4f9b\u5e94\u7f51\u7edc\u5b9a\u4e49\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\uff1a%3$s\uff0c\u8bf7\u4fee\u6539\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_42", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName, String.join((CharSequence)", ", supplyOrgNameList)));
                        ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                        this.getView().updateView("materialname");
                        this.getView().updateView("materialmodule");
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean validateAfterMaterialChangedIfEnablePlanScope(long materialId, String materialName, String materialAttr, String supplyRule, DynamicObject materialPlan, DynamicObject materialPlanByOrg, DynamicObject dataEntity, Object oldObject) {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        long supplyOrgId = supplyOrg == null ? 0L : supplyOrg.getLong("id");
        String supplyOrgName = supplyOrg == null ? "" : supplyOrg.getString("name");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        long orgId = org == null ? 0L : org.getLong("id");
        String orgName = org == null ? "" : org.getString("name");
        log.info("planorder-insert-materialChange,\u8fdb\u5165\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u7269\u6599\u5c5e\u6027={}\uff0c\u4f9b\u5e94\u89c4\u5219={}\uff0c\u4f9b\u5e94\u7ec4\u7ec7={}\uff0c\u9700\u6c42\u7ec4\u7ec7={}", new Object[]{materialAttr, supplyRule, supplyOrgId, orgId});
        if (orgId == supplyOrgId) {
            List planScopeIdList;
            String planScopeType;
            DynamicObject planScope = (DynamicObject)this.getModel().getValue("planscope");
            if (!(planScope == null || "A".equals(planScopeType = planScope.getString("type")) || (planScopeIdList = PlanScopeHelper.getPlanScopes((Long)supplyOrgId, (Long)materialId)) != null && !planScopeIdList.isEmpty() && planScopeIdList.contains(planScope.getLong("id")))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u672a\u5b9a\u4e49\u8ba1\u5212\u8303\u56f4%3$s\u3002", (String)"PlanOrderEdit_43", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName, planScope.getString("name")));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
            if (MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u81ea\u5236\u4ef6\u3001\u5916\u8d2d\u4ef6\u6216\u5916\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_40", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
        } else if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
            List planScopeIdList;
            String planScopeType;
            DynamicObject planScope;
            DynamicObject supplyNetwork;
            String materialAttrByOrg = materialPlanByOrg == null ? "" : materialPlanByOrg.getString("materialattr");
            log.info("planorder-insert-materialChange,\u8fdb\u5165\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u6309\u9700\u6c42\u7ec4\u7ec7\u53d6\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u4e2d\u7684\u7269\u6599\u5c5e\u6027={}", (Object)materialAttrByOrg);
            if (!MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttrByOrg)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u5185\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_41", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
            DynamicObject dynamicObject = supplyNetwork = materialPlanByOrg == null ? null : materialPlanByOrg.getDynamicObject("supplynetwork");
            if (supplyNetwork != null) {
                supplyNetwork = BusinessDataServiceHelper.loadSingleFromCache((Object)supplyNetwork.getPkValue(), (String)"mrp_definitionsupply");
                DynamicObject defSupplyType = supplyNetwork.getDynamicObject("defsupplytype");
                long defSupplyTypeId = defSupplyType.getLong("id");
                DynamicObjectCollection orgEntry = supplyNetwork.getDynamicObjectCollection("orgentry");
                String supplyRuleFromSupplyNetwork = "";
                boolean matchSupplyOrg = false;
                ArrayList<String> supplyOrgNameList = new ArrayList<String>();
                for (DynamicObject row : orgEntry) {
                    DynamicObject supplyOrgFromSupplyNetwork;
                    long supplyOrgIdFromSupplyNetwork;
                    DynamicObject supplyOrgType = row.getDynamicObject("supplyorgtype");
                    long supplyOrgTypeId = supplyOrgType.getLong("id");
                    if (supplyOrgTypeId != defSupplyTypeId) continue;
                    if ("".equals(supplyRuleFromSupplyNetwork)) {
                        supplyRuleFromSupplyNetwork = row.getString("supplyrule");
                    }
                    if ((supplyOrgIdFromSupplyNetwork = (supplyOrgFromSupplyNetwork = row.getDynamicObject("supplyorg")).getLong("id")) == supplyOrgId) {
                        matchSupplyOrg = true;
                    }
                    supplyOrgNameList.add(supplyOrgFromSupplyNetwork.getString("name"));
                }
                log.info("planorder-insert-materialChange,\u8fdb\u5165\u542f\u7528\u8ba1\u5212\u8303\u56f4\u7684\u6821\u9a8c\uff0c\u4ece\u4f9b\u5e94\u7f51\u7edc\u4e2d\u53d6\u5230\u4f9b\u5e94\u89c4\u5219={}\uff0c\u5339\u914d\u4f9b\u5e94\u7ec4\u7ec7={}", (Object)supplyRuleFromSupplyNetwork, (Object)matchSupplyOrg);
                if (!SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRuleFromSupplyNetwork)) {
                    SupplyRuleEnum supplyRuleEnum = SupplyRuleEnum.matchByValue((String)supplyRuleFromSupplyNetwork);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4f9b\u5e94\u7f51\u7edc\u5b9a\u4e49\u4f9b\u5e94\u89c4\u5219\u4e3a\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanOrderEdit_48", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName, supplyRuleEnum.getName()));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                    this.getView().updateView("materialname");
                    this.getView().updateView("materialmodule");
                    return false;
                }
                if (!matchSupplyOrg) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\u4e3a\u5185\u534f\u4ef6\uff0c\u4f9b\u5e94\u7f51\u7edc\u5b9a\u4e49\u7684\u4f9b\u5e94\u7ec4\u7ec7\u4e3a\uff1a\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u4f9b\u5e94\u7ec4\u7ec7\u6216\u5207\u6362\u8ba1\u5212\u8303\u56f4\u3002", (String)"PlanOrderEdit_44", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName, String.join((CharSequence)", ", supplyOrgNameList)));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                    this.getView().updateView("materialname");
                    this.getView().updateView("materialmodule");
                    return false;
                }
            }
            if (!((planScope = (DynamicObject)this.getModel().getValue("planscope")) == null || "A".equals(planScopeType = planScope.getString("type")) || (planScopeIdList = PlanScopeHelper.getPlanScopes((Long)orgId, (Long)materialId)) != null && !planScopeIdList.isEmpty() && planScopeIdList.contains(planScope.getLong("id")))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u672a\u5b9a\u4e49\u8ba1\u5212\u8303\u56f4\u201c%3$s\u201d\u3002", (String)"PlanOrderEdit_45", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), orgName, materialName, planScope.getString("name")));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
        } else {
            List planScopeIdList;
            String planScopeType;
            if (MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u4e0d\u5b58\u5728\u7269\u6599\u5c5e\u6027\u4e3a\u81ea\u5236\u4ef6\u3001\u5916\u8d2d\u4ef6\u6216\u5916\u534f\u4ef6\u7684\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u3002", (String)"PlanOrderEdit_40", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
            DynamicObject planScope = (DynamicObject)this.getModel().getValue("planscope");
            if (!(planScope == null || "A".equals(planScopeType = planScope.getString("type")) || (planScopeIdList = PlanScopeHelper.getPlanScopes((Long)supplyOrgId, (Long)materialId)) != null && !planScopeIdList.isEmpty() && planScopeIdList.contains(planScope.getLong("id")))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\uff1a\u201c%1$s\u201d\uff0c\u7269\u6599\uff1a\u201c%2$s\u201d\uff0c\u672a\u5b9a\u4e49\u8ba1\u5212\u8303\u56f4%3$s\u3002", (String)"PlanOrderEdit_43", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), supplyOrgName, materialName, planScope.getString("name")));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)dataEntity, (String)"material", (Object)oldObject);
                this.getView().updateView("materialname");
                this.getView().updateView("materialmodule");
                return false;
            }
        }
        return true;
    }

    private void setInWarInfo(long orgId, long materialId) {
        String selectFields = "inwarorg, inwarehouse, inwarelocation";
        QFilter[] materialMftFilter = new QFilter[]{new QFilter("createorg", "=", (Object)orgId), new QFilter("masterid", "=", (Object)materialId), new QFilter("status", "=", (Object)"C"), new QFilter("enable", "=", (Object)"1")};
        DynamicObject materialMftInfo = QueryServiceHelper.queryOne((String)"bd_materialmftinfo", (String)selectFields, (QFilter[])materialMftFilter);
        if (materialMftInfo != null) {
            long inWareOrgId = materialMftInfo.getLong("inwarorg");
            if (inWareOrgId == 0L) {
                log.info("\u7269\u6599[{}]\uff0c\u7ec4\u7ec7[{}]\uff0c\u5bf9\u5e94\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u672a\u7ef4\u62a4\u5165\u5e93\u7ec4\u7ec7\uff0c\u5165\u5e93\u7ec4\u7ec7\u53d6\u9ed8\u8ba4\u503c\u3002", (Object)materialId, (Object)orgId);
                DynamicObject defaultInWareOrg = this.getDefaultInWareOrg();
                inWareOrgId = defaultInWareOrg.getLong("id");
            }
            this.getModel().setValue("inwarorg", (Object)inWareOrgId);
            this.getModel().setValue("inwarehouse", (Object)materialMftInfo.getLong("inwarehouse"));
            this.getModel().setValue("inwarelocation", (Object)materialMftInfo.getLong("inwarelocation"));
        } else {
            this.getModel().setValue("inwarorg", (Object)orgId);
            this.getModel().setValue("inwarehouse", null);
            this.getModel().setValue("inwarelocation", null);
        }
    }

    private void setInWareInfo() {
        DynamicObject planScope = (DynamicObject)this.getModel().getValue("planscope");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (planScope == null || material == null) {
            this.getModel().beginInit();
            this.getModel().setValue("inwarorg", null);
            this.getModel().setValue("inwarehouse", null);
            this.getModel().setValue("inwarelocation", null);
            this.getModel().endInit();
            this.getView().updateView("inwarorg");
            this.getView().updateView("inwarehouse");
            this.getView().updateView("inwarelocation");
            return;
        }
        DynamicObject bizOrg = planScope.getDynamicObject("createorg");
        String type = planScope.getString("type");
        Long planScopeId = planScope.getLong("id");
        Long bizOrgId = bizOrg.getLong("id");
        Long materialId = material.getLong("id");
        this.getModel().beginInit();
        if ("A".equals(type)) {
            DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)bizOrgId, (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
            if (materialMftInfo != null) {
                DynamicObject inWareOrg = materialMftInfo.getDynamicObject("inwarorg");
                if (inWareOrg == null) {
                    log.info("\u7269\u6599[{}]\uff0c\u7ec4\u7ec7[{}]\uff0c\u5bf9\u5e94\u7684\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u672a\u7ef4\u62a4\u5165\u5e93\u7ec4\u7ec7\uff0c\u5165\u5e93\u7ec4\u7ec7\u53d6\u9ed8\u8ba4\u503c\u3002", (Object)materialId, (Object)bizOrgId);
                    inWareOrg = this.getDefaultInWareOrg();
                }
                this.getModel().setValue("inwarorg", (Object)inWareOrg);
                this.getModel().setValue("inwarehouse", (Object)materialMftInfo.getDynamicObject("inwarehouse"));
                this.getModel().setValue("inwarelocation", (Object)materialMftInfo.getDynamicObject("inwarelocation"));
            } else {
                this.getModel().setValue("inwarorg", (Object)bizOrg);
                this.getModel().setValue("inwarehouse", null);
                this.getModel().setValue("inwarelocation", null);
            }
            this.getModel().endInit();
            this.getView().updateView("inwarorg");
            this.getView().updateView("inwarehouse");
            this.getView().updateView("inwarelocation");
        } else if ("B".equals(type)) {
            Map inWareInfo = PlanScopeHelper.getInwareInfo((Long)planScopeId, (Long)bizOrgId, (Long)materialId);
            if (inWareInfo == null || (Long)inWareInfo.get("inwarehouse") == 0L) {
                inWareInfo = PlanScopeHelper.getInwareInfoByPlanscope((Long)planScopeId, (Long)bizOrgId, (Boolean)true);
            }
            if (inWareInfo == null) {
                this.getModel().setValue("inwarorg", null);
                this.getModel().setValue("inwarehouse", null);
                this.getModel().setValue("inwarelocation", null);
            } else {
                Long inWareOrgId = (Long)inWareInfo.get("inwarorg");
                Long inWareHouseId = (Long)inWareInfo.get("inwarehouse");
                Long inWareLocationId = (Long)inWareInfo.get("inwarelocation");
                this.getModel().setValue("inwarorg", (Object)(inWareOrgId == 0L ? null : inWareOrgId));
                this.getModel().setValue("inwarehouse", (Object)(inWareHouseId == 0L ? null : inWareHouseId));
                this.getModel().setValue("inwarelocation", (Object)(inWareLocationId == 0L ? null : inWareLocationId));
            }
            this.getModel().endInit();
            this.getView().updateView("inwarorg");
            this.getView().updateView("inwarehouse");
            this.getView().updateView("inwarelocation");
        }
    }

    private DynamicObject getDefaultInWareOrg() {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
            return org;
        }
        return supplyOrg;
    }

    private String getMaterialMftSelectFields() {
        StringBuilder selectFields = new StringBuilder("id,createorg,masterid,inwarorg,inwarehouse,inwarelocation,supplyorgunitid,warehouse,location,isstockallot,invinfosrc,iskeypart");
        return selectFields.toString();
    }

    private void bomChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof DynamicObject)) {
            String needFinConfigBom = this.getPageCache().get(CACHE_NEED_FIND_CONFIG_BOM);
            if ("true".equals(needFinConfigBom)) {
                this.findConfigBomAndUnfold();
                this.getPageCache().remove(CACHE_NEED_FIND_CONFIG_BOM);
            } else {
                Boolean isExist = this.isExistProperties("ecnversion");
                if (isExist.booleanValue()) {
                    this.setControlEnable(Boolean.FALSE, "ecnversion", -1);
                    this.getModel().setValue("ecnversion", null);
                }
                this.deleteBOMEntryData(null);
                this.deleteCopEntryData();
            }
        } else {
            DynamicObject bom = (DynamicObject)newObject;
            bom = BusinessDataServiceHelper.loadSingle((Object)bom.getLong("id"), (String)BOM_KEY, (String)PlanOrderHelper.selectBOMPropertites());
            Boolean isExist = this.isExistProperties("ecnversion");
            if (isExist.booleanValue()) {
                this.setControlEnable(Boolean.TRUE, "ecnversion", -1);
                this.getModel().setValue("ecnversion", bom.get("ecn"));
            }
            BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
            Date date = (Date)this.getModel().getValue("unfoldbomdate");
            Date startDate = DynamicObjDataUtil.getDataModelDateData((IDataModel)this.getModel(), (String)"startdate");
            DynamicObject dept = (DynamicObject)this.getModel().getValue("proorpurorg");
            if (startDate == null) {
                startDate = this.getRecentWorkDate(new Date());
            }
            if (startDate == null) {
                startDate = new Date();
            }
            HashMap<String, Date> requireDateMap = new HashMap<String, Date>();
            requireDateMap.put(bom.getPkValue().toString(), startDate);
            DynamicObject material = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"material");
            if (material == null) {
                return;
            }
            DynamicObject palnorder = this.getModel().getDataEntity();
            HashMap<Long, BigDecimal> standQtyMap = new HashMap<Long, BigDecimal>(16);
            HashMap<Long, BigDecimal> requireQtyMap = new HashMap<Long, BigDecimal>(16);
            List bomEntrys = PlanOrderHelper.getBomChildEntryInfo((DynamicObject)bom, (DynamicObject)palnorder, (BigDecimal)orderQty, (Date)date, (Long)(dept == null ? 0L : dept.getLong("id")), requireDateMap, standQtyMap, requireQtyMap);
            this.createNewEntry(bom, bomEntrys, orderQty, requireDateMap, standQtyMap, requireQtyMap);
            DynamicObjectCollection copentrys = bom.getDynamicObjectCollection("copentry");
            this.createCopEntry(copentrys, orderQty, date);
        }
        this.loadCopEntry();
    }

    private void findConfigBomAndUnfold() {
        DynamicObject planOrder = this.getModel().getDataEntity();
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        long supplyOrgId = supplyOrg.getLong("id");
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null) {
            startDate = this.getRecentWorkDate(new Date());
        }
        if (startDate == null) {
            startDate = new Date();
        }
        HashMap<String, Date> requireDateMap = new HashMap<String, Date>();
        HashMap<Long, BigDecimal> standQtyMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> requireQtyMap = new HashMap<Long, BigDecimal>(16);
        Tuple bomAndChildEntryInfo = PlanOrderHelper.getBomAndChildEntryInfo((DynamicObject)planOrder, (Long)supplyOrgId, requireDateMap, (Date)startDate, standQtyMap, requireQtyMap);
        Long bomId = (Long)bomAndChildEntryInfo.item1;
        if (bomId == null || bomId == 0L) {
            log.info("\u901a\u8fc7\u5c55BOM\u670d\u52a1\u672a\u627e\u5230BOM");
            return;
        }
        DynamicObject bom = BusinessDataServiceHelper.loadSingleFromCache((Object)bomId, (String)BOM_KEY);
        this.getModel().beginInit();
        this.getModel().setValue("bom", (Object)bom);
        this.getModel().endInit();
        this.getView().updateView("bom");
        this.getView().updateView("bomversion");
        Boolean isExist = this.isExistProperties("ecnversion");
        if (isExist.booleanValue()) {
            this.setControlEnable(Boolean.TRUE, "ecnversion", -1);
            this.getModel().setValue("ecnversion", bom.get("ecn"));
        }
        BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        this.createNewEntry(bom, (List)bomAndChildEntryInfo.item2, orderQty, requireDateMap, standQtyMap, requireQtyMap);
        DynamicObjectCollection copentrys = bom.getDynamicObjectCollection("copentry");
        this.createCopEntry(copentrys, orderQty, unfoldBomDate);
    }

    private void createCopEntry(DynamicObjectCollection bomCopentrys, BigDecimal orderQty, Date date) {
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.deleteCopEntryData();
        model.beginInit();
        TableValueSetter vs = this.getCopEntryTv();
        int seq = 1;
        for (DynamicObject bomCopentry : bomCopentrys) {
            this.setCopEntryVs(vs, bomCopentry, seq, orderQty, date);
        }
        model.batchCreateNewEntryRow("copentry", vs);
        model.endInit();
        this.getView().updateView("copentry");
    }

    private void setCopEntryVs(TableValueSetter vs, DynamicObject bomCopentry, int seq, BigDecimal orderQty, Date date) {
        String copentrytype = bomCopentry.getString("copentrytype");
        DynamicObject copentrymaterial = bomCopentry.getDynamicObject("copentrymaterial");
        DynamicObject copentryversion = bomCopentry.getDynamicObject("copentryversion");
        DynamicObject copentryunit = bomCopentry.getDynamicObject("copentryunit");
        BigDecimal copentryqty = bomCopentry.getBigDecimal("copentryqty");
        BigDecimal copentryallqty = copentryqty.multiply(orderQty);
        DynamicObject copentryoperation = bomCopentry.getDynamicObject("copentryoperation");
        Date copentryvaliddate = bomCopentry.getDate("copentryvaliddate");
        Date copentryinvaliddate = bomCopentry.getDate("copentryinvaliddate");
        if (copentryvaliddate == null || copentryinvaliddate == null) {
            return;
        }
        if (copentryvaliddate.compareTo(date) > 0 || copentryinvaliddate.compareTo(date) < 0) {
            return;
        }
        DynamicObject copentryauxproperty = bomCopentry.getDynamicObject("copentryauxproperty");
        Boolean isExist = this.isExistProperties("copentryremark");
        DynamicObject material = copentrymaterial.getDynamicObject("masterid");
        Object[] params = new Object[]{seq, copentrytype, material.getPkValue(), copentryversion == null ? Integer.valueOf(0) : copentryversion.getPkValue(), copentryunit == null ? Integer.valueOf(0) : copentryunit.getPkValue(), copentryqty, copentryallqty, copentryoperation == null ? Integer.valueOf(0) : copentryoperation.getPkValue(), copentryvaliddate, copentryinvaliddate, copentryauxproperty == null ? Integer.valueOf(0) : copentryauxproperty.getPkValue()};
        if (isExist.booleanValue()) {
            String copentryremark = bomCopentry.getLocaleString("copentryremark").getLocaleValue();
            ArrayList<Object> paramsList = new ArrayList<Object>(Arrays.asList(params));
            paramsList.add(copentryremark);
            params = paramsList.toArray(new Object[0]);
        }
        vs.addRow(params);
    }

    private TableValueSetter getCopEntryTv() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("copentrytype", new Object[0]);
        vs.addField("copentrymaterial", new Object[0]);
        vs.addField("copentryversion", new Object[0]);
        vs.addField("copentryunit", new Object[0]);
        vs.addField("copentryqty", new Object[0]);
        vs.addField("copentryallqty", new Object[0]);
        vs.addField("copentryoperation", new Object[0]);
        vs.addField("copentryvaliddate", new Object[0]);
        vs.addField("copentryinvaliddate", new Object[0]);
        vs.addField("copentryauxproperty", new Object[0]);
        Boolean isExist = this.isExistProperties("copentryremark");
        if (isExist.booleanValue()) {
            vs.addField("copentryremark", new Object[0]);
        }
        return vs;
    }

    private void deleteCopEntryData() {
        this.getModel().deleteEntryData("copentry");
    }

    private TableValueSetter getTv() {
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entrymode", new Object[0]);
        vs.addField("entrytype", new Object[0]);
        vs.addField("entrymaterial", new Object[0]);
        vs.addField("entryversion", new Object[0]);
        vs.addField("entryunit", new Object[0]);
        vs.addField("entryqtytype", new Object[0]);
        vs.addField("entryqtynumerator", new Object[0]);
        vs.addField("entryqtydenominator", new Object[0]);
        vs.addField("entrystandqty", new Object[0]);
        vs.addField("entryrequireqty", new Object[0]);
        vs.addField("entryrequiredate", new Object[0]);
        vs.addField("entryfixscrap", new Object[0]);
        vs.addField("entryscraprate", new Object[0]);
        vs.addField("entrylossqty", new Object[0]);
        vs.addField("entrysupplytype", new Object[0]);
        vs.addField("entrysupplyorg", new Object[0]);
        vs.addField("entrybomid", new Object[0]);
        vs.addField("entrybomentryid", new Object[0]);
        vs.addField("entrymaterialplanid", new Object[0]);
        vs.addField("entryreplaceplan", new Object[0]);
        vs.addField("entryisreplace", new Object[0]);
        vs.addField("entryreplacestra", new Object[0]);
        vs.addField("entryreplacemethod", new Object[0]);
        vs.addField("entryreplacematerial", new Object[0]);
        vs.addField("entryreplacepriority", new Object[0]);
        vs.addField("wastagerateformula", new Object[0]);
        vs.addField("entryleadtime", new Object[0]);
        vs.addField("entryconfiguredcode", new Object[0]);
        vs.addField("entryauxproperty", new Object[0]);
        vs.addField("entrysupplyorgunitid", new Object[0]);
        vs.addField("entrywarehouse", new Object[0]);
        vs.addField("entrylocation", new Object[0]);
        vs.addField("entryisstockallot", new Object[0]);
        vs.addField("entryisjumplevel", new Object[0]);
        vs.addField("entryparentmaterial", new Object[0]);
        vs.addField("entryuseratio", new Object[0]);
        vs.addField("iskeypart", new Object[0]);
        return vs;
    }

    private String getIskeypartSource(Long orgId) {
        String iskeypartsourceStr = this.getPageCache().get("iskeypartsource");
        if (iskeypartsourceStr == null) {
            String iskeypartsource = "A";
            AppParam appParam = new AppParam("0MBBBZ1L5IAW", orgId);
            Map mrpParam = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
            if (mrpParam.get("iskeypartsource") != null) {
                iskeypartsource = mrpParam.get("iskeypartsource").toString();
            }
            this.getPageCache().put("iskeypartsource", iskeypartsource);
            return iskeypartsource;
        }
        return iskeypartsourceStr;
    }

    private void setVs(TableValueSetter vs, DynamicObject bom, DynamicObject bomEntry, int seq, BigDecimal orderQty, Map<String, Date> requireDateMap, Map<Object, DynamicObject> materialEntry, Map<Object, DynamicObject> materialmftMap, Map<Object, DynamicObject> entryMaterialPlans, Map<Object, DynamicObject> entryMaterialMfts, Map<String, Long> supplyInfoMap, Map<Object, DynamicObject> materialMap, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap, Map<Long, Map<String, BigDecimal>> replaceplanReplacepriorityUseratio) {
        Long materialId = bomEntry.getLong("entry.entrymaterialid");
        if (materialId == null || materialId == 0L) {
            return;
        }
        DynamicObject masterid = materialMap.get(materialId);
        DynamicObject entryMaterialPlan = entryMaterialPlans.get(materialId);
        DynamicObject entryMaterialMft = entryMaterialMfts.get(materialId);
        Long entryConfiguredcodeId = bomEntry.getLong("entry.entryconfiguredcode");
        Long entryAuxpropertyId = bomEntry.getLong("entry.entryauxproperty");
        Long entryId = bomEntry.getLong("entry.id");
        String wastagerateformula = "";
        if (entryMaterialPlan != null) {
            wastagerateformula = entryMaterialPlan.getString("wastagerateformula");
        }
        if (StringUtils.isBlank((CharSequence)wastagerateformula)) {
            wastagerateformula = "B";
        }
        Integer leadtime = bomEntry.getInt("entry.entryleadtime");
        Long entryunitId = bomEntry.getLong("entry.entryunit");
        Long entryversionId = bomEntry.getLong("entry.entryversion");
        String entryqtytype = bomEntry.getString("entry.entryqtytype");
        BigDecimal entryqtynumerator = bomEntry.getBigDecimal("entry.entryqtynumerator");
        BigDecimal entryqtydenominator = bomEntry.getBigDecimal("entry.entryqtydenominator");
        int precision = 2;
        if (bomEntry.get("entry.entryunit.precision") != null) {
            precision = bomEntry.getInt("entry.entryunit.precision");
        }
        int roundMode = 4;
        if (bomEntry.get("entry.entryunit.precisionaccount") != null) {
            String precisionAccount = bomEntry.getString("entry.entryunit.precisionaccount");
            if (CONFIGURATION.equals(precisionAccount)) {
                roundMode = 1;
            } else if ("3".equals(precisionAccount)) {
                roundMode = 0;
            }
        }
        BigDecimal entryscraprate = bomEntry.getBigDecimal("entry.entryscraprate");
        BigDecimal entryfixscrap = bomEntry.getBigDecimal("entry.entryfixscrap");
        BigDecimal entrystandqty = standQtyMap.getOrDefault(entryId, BigDecimal.ZERO);
        Long entryreplaceplanId = bomEntry.getLong("entry.entryreplaceplan");
        String entryreplacestra = "";
        String entryreplacemethod = "";
        DynamicObject oldEntry = null;
        if (materialId != null && materialId != 0L) {
            oldEntry = materialEntry.get(materialId);
        }
        BigDecimal qty = BigDecimal.ZERO;
        if (entryreplaceplanId != null && entryreplaceplanId != 0L) {
            entryreplacemethod = bomEntry.getString("entry.entryreplaceplan.replacemethod");
            entryreplacestra = bomEntry.getString("entry.entryreplaceplan.replacestra");
            if (oldEntry != null) {
                String newOrderQtyStr = this.getPageCache().get(NEWORDERQTY);
                String oldOrderQtyStr = this.getPageCache().get(OLDORDERQTY);
                if (StringUtils.isNotBlank((CharSequence)newOrderQtyStr) && StringUtils.isNotBlank((CharSequence)oldOrderQtyStr)) {
                    BigDecimal newOrderQty = new BigDecimal(newOrderQtyStr);
                    BigDecimal oldOrderQty = new BigDecimal(oldOrderQtyStr);
                    BigDecimal oldentrystandqty = oldEntry.getBigDecimal("entrystandqty");
                    entrystandqty = oldentrystandqty.multiply(newOrderQty).divide(oldOrderQty, precision, 4);
                }
            }
        }
        BigDecimal entryrequireqty = requireQtyMap.get(entryId);
        Date date = requireDateMap.get(entryId.toString());
        if (date == null) {
            date = new Date();
        }
        String entrysupplytype = bomEntry.getString("entry.entrysupplytype");
        DynamicObject mtfOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        Long entrysupplyorgId = mtfOrg.getLong("id");
        String entryisreplace = bomEntry.getString("entry.entryisreplace");
        if ("true".equals(entryisreplace)) {
            entryrequireqty = BigDecimal.ZERO;
            entrystandqty = BigDecimal.ZERO;
        }
        BigDecimal entrylossqty = entryrequireqty.subtract(entrystandqty);
        boolean entryisstockallot = false;
        if (entryMaterialMft != null) {
            entryisstockallot = entryMaterialMft.getBoolean("isstockallot");
        }
        String iskeypartSource = this.getIskeypartSource(entrysupplyorgId);
        Boolean entryIskeypart = null;
        if ("A".equals(iskeypartSource) && entryMaterialMft != null) {
            entryIskeypart = entryMaterialMft.getBoolean("iskeypart");
        } else if ("B".equals(iskeypartSource) && bomEntry != null) {
            entryIskeypart = bomEntry.getBoolean("entry.entryiskey");
        }
        boolean enablePlanScope = this.isEnablePlanScope();
        Long entrysupplyorgunitid = enablePlanScope ? supplyInfoMap.get("entrysupplyorg") : Long.valueOf(this.getDefaultEntrySupplyOrgUnitId(entryMaterialPlan));
        Long entrywarehouseId = enablePlanScope ? supplyInfoMap.get("entrywarehouse") : Long.valueOf(0L);
        Long entrylocationId = enablePlanScope ? supplyInfoMap.get("entrylocation") : Long.valueOf(0L);
        int reppriority = bomEntry.getInt("entry.reppriority");
        String entryisreplaceplanmm = bomEntry.getString("entry.entryisreplaceplanmm");
        String entryMode = "B";
        String entrytype = "A";
        BigDecimal entryUseratio = BigDecimal.valueOf(100.0);
        entryUseratio = entryreplaceplanId == null || entryreplaceplanId == 0L ? BigDecimal.valueOf(100.0) : (qty == null || BigDecimal.ZERO.compareTo(qty) == 0 ? BigDecimal.ZERO : entryrequireqty.multiply(BigDecimal.valueOf(100L)).divide(qty, 4, 4));
        if (entryreplaceplanId == null || entryreplaceplanId <= 0L) {
            entryUseratio = BigDecimal.valueOf(100.0);
        } else {
            Map<String, BigDecimal> replacepriorityUseratio = replaceplanReplacepriorityUseratio.get(entryreplaceplanId);
            String replacepriority = bomEntry.getString("entry.reppriority");
            entryUseratio = replacepriorityUseratio == null ? BigDecimal.ZERO : replacepriorityUseratio.getOrDefault(replacepriority, BigDecimal.ZERO);
        }
        boolean entryisjumplevel = bomEntry.getBoolean("entry.entryisjumplevel");
        Long entryparentmaterialId = bomEntry.getLong("materialid");
        vs.addRow(new Object[]{seq, entryMode, entrytype, masterid.getPkValue(), entryversionId, entryunitId, entryqtytype, entryqtynumerator, entryqtydenominator, entrystandqty, entryrequireqty, date, entryfixscrap, entryscraprate, entrylossqty, entrysupplytype, entrysupplyorgId, bom == null ? Integer.valueOf(0) : bom.getPkValue(), entryId, entryMaterialPlan == null ? Integer.valueOf(0) : entryMaterialPlan.getPkValue(), entryreplaceplanId, entryisreplace, entryreplacestra, entryreplacemethod, entryisreplaceplanmm, reppriority, wastagerateformula, leadtime, entryConfiguredcodeId, entryAuxpropertyId, entrysupplyorgunitid, entrywarehouseId, entrylocationId, entryisstockallot, entryisjumplevel, entryparentmaterialId, entryUseratio, entryIskeypart});
    }

    private Map<String, Long> getDefSupplerInfo(DynamicObject entryMaterialPlan, DynamicObject material, DynamicObject entrymaterial, DynamicObject bomEntry, DynamicObject entryMaterialMft, DynamicObject mtfOrg) {
        Long entrysupplyorgunitid = 0L;
        Long entrywarehouseId = 0L;
        Long entrylocationId = 0L;
        Long materialId = material.getLong("id");
        HashMap<String, Long> supplyInfoMap = new HashMap<String, Long>(3);
        supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
        supplyInfoMap.put("entrywarehouse", entrywarehouseId);
        supplyInfoMap.put("entrylocation", entrylocationId);
        String invinfosrc = entryMaterialMft == null ? "A" : entryMaterialMft.getString("invinfosrc");
        Long entrysupplyorgId = mtfOrg == null ? 0L : mtfOrg.getLong("id");
        if ("A".equals(invinfosrc)) {
            if (bomEntry != null) {
                DynamicObject entrysupplyorgunit = bomEntry.getDynamicObject("entrysupplyorg");
                entrysupplyorgunitid = entrysupplyorgunit == null ? 0L : entrysupplyorgunit.getLong("id");
                DynamicObject entrywarehouse = bomEntry.getDynamicObject("entrywarehouse");
                entrywarehouseId = entrywarehouse == null ? 0L : entrywarehouse.getLong("id");
                DynamicObject entrylocation = bomEntry.getDynamicObject("entrylocation");
                entrylocationId = entrylocation == null ? 0L : entrylocation.getLong("id");
                supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
                supplyInfoMap.put("entrywarehouse", entrywarehouseId);
                supplyInfoMap.put("entrylocation", entrylocationId);
                this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
            }
            supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
            supplyInfoMap.put("entrywarehouse", entrywarehouseId);
            supplyInfoMap.put("entrylocation", entrylocationId);
        } else if ("B".equals(invinfosrc)) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entryMaterialMft, entrysupplyorgId, materialId);
        } else if ("C".equals(invinfosrc)) {
            DynamicObject manuVersiontInfo;
            Boolean isExistManuversion = this.isExistProperties("manuversion");
            if (isExistManuversion.booleanValue() && (manuVersiontInfo = (DynamicObject)this.getModel().getValue("manuversion")) != null) {
                DynamicObject supplyorgunitid = manuVersiontInfo.getDynamicObject("supstockorgid");
                entrysupplyorgunitid = supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id");
                DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
                entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
                DynamicObject location = manuVersiontInfo.getDynamicObject("suplocationid");
                entrylocationId = location == null ? 0L : location.getLong("id");
                supplyInfoMap.put("entrysupplyorgunitid", entrysupplyorgunitid);
                supplyInfoMap.put("entrywarehouse", entrywarehouseId);
                supplyInfoMap.put("entrylocation", entrylocationId);
                this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
            }
        } else if ("D".equals(invinfosrc)) {
            this.dealManuversionForD(supplyInfoMap, entryMaterialMft, entrysupplyorgId, materialId);
        }
        return supplyInfoMap;
    }

    private void dealManuversionForD(Map<String, Long> supplyInfoMap, DynamicObject entrymaterial, Long entrysupplyorgId, Long materialId) {
        Boolean isExistManuversion = this.isExistProperties("manuversion");
        if (!isExistManuversion.booleanValue()) {
            return;
        }
        Long entrywarehouseId = supplyInfoMap.get("entrywarehouse");
        DynamicObject manuVersiontInfo = (DynamicObject)this.getModel().getValue("manuversion");
        if (manuVersiontInfo == null) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
            return;
        }
        DynamicObject warehouse = manuVersiontInfo.getDynamicObject("supwarehouseid");
        entrywarehouseId = warehouse == null ? 0L : warehouse.getLong("id");
        log.info("\u8bb0\u5f55\u751f\u4ea7\u7248\u672c\u4ed3\u5e93id:", (Object)entrywarehouseId);
        if (entrywarehouseId == 0L) {
            this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
        } else {
            supplyInfoMap.put("entrywarehouse", entrywarehouseId);
            boolean isdiscover = this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
            if (!isdiscover) {
                isdiscover = this.dealMftInfoSupplyInfo(supplyInfoMap, entrymaterial, entrysupplyorgId, materialId);
            }
        }
    }

    private boolean dealMftInfoSupplyInfo(Map<String, Long> supplyInfoMap, DynamicObject entrymaterial, Long entrysupplyorgId, Long materialId) {
        if (entrymaterial == null) {
            return false;
        }
        DynamicObject supplyorgunitid = entrymaterial.getDynamicObject("supplyorgunitid");
        DynamicObject warehouse = entrymaterial.getDynamicObject("warehouse");
        DynamicObject location = entrymaterial.getDynamicObject("location");
        supplyInfoMap.put("entrysupplyorgunitid", supplyorgunitid == null ? 0L : supplyorgunitid.getLong("id"));
        supplyInfoMap.put("entrywarehouse", warehouse == null ? 0L : warehouse.getLong("id"));
        supplyInfoMap.put("entrylocation", location == null ? 0L : location.getLong("id"));
        boolean issupplerinfo = this.dealPlanScopeSupplerInfo(supplyInfoMap, entrysupplyorgId, materialId);
        if (issupplerinfo) {
            return true;
        }
        return supplyInfoMap.get("entrywarehouse") != 0L;
    }

    private boolean dealPlanScopeSupplerInfo(Map<String, Long> supplyInfoMap, Long entrysupplyorg, Long materialId) {
        Long entrywarehouseId = supplyInfoMap.get("entrywarehouse");
        log.info("\u83b7\u53d6\u751f\u4ea7\u7248\u672c\u4ed3\u5e93id\uff1a", (Object)entrywarehouseId.toString());
        Map supplierInfo = PlanScopeHelper.getSupplierInfo((Long)entrywarehouseId, (Long)entrysupplyorg, (Long)materialId);
        if (supplierInfo == null || supplierInfo.isEmpty()) {
            return false;
        }
        supplyInfoMap.put("entrysupplyorgunitid", (Long)supplierInfo.get("entrysupplyorgunitid"));
        supplyInfoMap.put("entrywarehouse", (Long)supplierInfo.get("entrywarehouse"));
        supplyInfoMap.put("entrylocation", (Long)supplierInfo.get("entrylocation"));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void createNewEntry(DynamicObject bom, List<DynamicObject> bomEntrys, BigDecimal orderQty, Map<String, Date> requireDateMap, Map<Long, BigDecimal> standQtyMap, Map<Long, BigDecimal> requireQtyMap) {
        void var29_42;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        HashMap materialEntry = Maps.newHashMapWithExpectedSize((int)16);
        this.deleteBOMEntryData(materialEntry);
        model.beginInit();
        TableValueSetter vs = this.getTv();
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        ArrayList<Long> materialMftInfoIds = new ArrayList<Long>(bomEntrys.size());
        ArrayList<Long> materialIds = new ArrayList<Long>(bomEntrys.size());
        LinkedHashMap<String, DynamicObject> bomEntryMaps = new LinkedHashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> entrymaterialMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> entrymaterialInfoMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, Object> interAssistTypeMap = new HashMap<String, Object>(16);
        DynamicObject manuVersiontInfo = null;
        if (this.isExistProperties("manuversion").booleanValue()) {
            manuVersiontInfo = (DynamicObject)this.getModel().getValue("manuversion");
        }
        for (DynamicObject bomEntry : bomEntrys) {
            Long materialId = bomEntry.getLong("entry.entrymaterialid");
            if (materialId == null || materialId == 0L) continue;
            materialIds.add(materialId);
            Long materialInfoId = bomEntry.getLong("entry.entrymaterial");
            if (materialInfoId == null || materialInfoId == 0L) continue;
            materialMftInfoIds.add(materialInfoId);
        }
        Map materialMap = BusinessDataServiceHelper.loadFromCache((Object[])materialIds.toArray(new Long[0]), (String)"bd_material");
        Map materialmftMap = BusinessDataServiceHelper.loadFromCache((Object[])materialMftInfoIds.toArray(new Long[0]), (String)"bd_materialmftinfo");
        Map entryMaterialPlanMap = PlanOrderHelper.getMaterialInfos(materialIds, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (boolean)false);
        Map entryMaterialMft = PlanOrderHelper.getMaterialMftInfos(materialIds, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields());
        long[] genLongIds = DB.genLongIds((String)"t_mrp_planorderentry", (int)bomEntrys.size());
        for (int i = 0; i < bomEntrys.size(); ++i) {
            DynamicObject entrymaterial;
            Long planorderentryId = genLongIds[i];
            DynamicObject bomEntry = bomEntrys.get(i);
            Long materialId = bomEntry.getLong("entry.entrymaterialid");
            if (materialId == null || materialId == 0L || (entrymaterial = (DynamicObject)materialMap.get(materialId)) == null) continue;
            DynamicObject dynamicObject = (DynamicObject)entryMaterialMft.get(materialId);
            DynamicObject dynamicObject2 = (DynamicObject)entryMaterialPlanMap.get(materialId);
            entrymaterialInfoMap.put(planorderentryId.toString(), dynamicObject);
            bomEntryMaps.put(planorderentryId.toString(), bomEntry);
            entrymaterialMap.put(planorderentryId.toString(), entrymaterial);
            Object interAssistType = null;
            interAssistTypeMap.put(planorderentryId.toString(), interAssistType);
        }
        Map batchDefSupplierInfo = PlanScopeHelper.getBatchDefSupplierInfoConsiderInterAssist(bomEntryMaps, entrymaterialMap, entrymaterialInfoMap, interAssistTypeMap, (DynamicObject)supplyOrg, (DynamicObject)manuVersiontInfo);
        int seq = 1;
        HashMap<Object, BigDecimal> replaceplanQty = new HashMap<Object, BigDecimal>(16);
        HashMap<Long, Map<String, BigDecimal>> replaceplanReplacepriorityQty = new HashMap<Long, Map<String, BigDecimal>>(16);
        for (DynamicObject dynamicObject : bomEntrys) {
            this.getReplaceplanQty(dynamicObject, materialEntry, replaceplanQty, requireQtyMap, replaceplanReplacepriorityQty);
        }
        HashMap<Long, Map<String, BigDecimal>> replaceplanReplacepriorityUseratio = new HashMap<Long, Map<String, BigDecimal>>();
        for (Map.Entry entry : replaceplanReplacepriorityQty.entrySet()) {
            Long replaceplan = (Long)entry.getKey();
            BigDecimal qtysum = replaceplanQty.getOrDefault(replaceplan, BigDecimal.ZERO);
            Map replacepriorityQty = (Map)entry.getValue();
            Map replacepriorityUseratio = replaceplanReplacepriorityUseratio.computeIfAbsent(replaceplan, k -> new HashMap(16));
            for (Map.Entry replacepriorityEntry : replacepriorityQty.entrySet()) {
                String replacepriority = (String)replacepriorityEntry.getKey();
                BigDecimal qty = (BigDecimal)replacepriorityEntry.getValue();
                BigDecimal useratio = (BigDecimal)replacepriorityUseratio.get(replacepriority);
                useratio = qty == null || BigDecimal.ZERO.compareTo(qtysum) == 0 ? BigDecimal.valueOf(0L) : qty.multiply(BigDecimal.valueOf(100L)).divide(qtysum, 4, 4);
                replacepriorityUseratio.put(replacepriority, useratio);
            }
        }
        for (Map.Entry entry : bomEntryMaps.entrySet()) {
            String key = (String)entry.getKey();
            DynamicObject bomEntry = (DynamicObject)entry.getValue();
            Map supplyInfoMap = (Map)batchDefSupplierInfo.get(key);
            this.setVs(vs, bom, bomEntry, seq, orderQty, requireDateMap, materialEntry, materialmftMap, entryMaterialPlanMap, entryMaterialMft, supplyInfoMap, materialMap, standQtyMap, requireQtyMap, replaceplanReplacepriorityUseratio);
        }
        this.getPageCache().remove(NEWORDERQTY);
        this.getPageCache().remove(OLDORDERQTY);
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        this.getView().updateView("entryentity");
        int n = this.getModel().getEntryRowCount("entryentity");
        boolean bl = false;
        while (var29_42 < n) {
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", (int)var29_42);
            String entryMode = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entrymode");
            this.setOrderMaterialEnable((int)var29_42, entryMode);
            ++var29_42;
        }
    }

    private void getReplaceplanQty(DynamicObject bomEntry, Map<Object, DynamicObject> materialEntry, Map<Object, BigDecimal> replaceplanQty, Map<Long, BigDecimal> requireQtyMap, Map<Long, Map<String, BigDecimal>> replaceplanReplacepriorityQty) {
        Long materialId = bomEntry.getLong("entry.entrymaterialid");
        if (materialId == null || materialId == 0L) {
            return;
        }
        Long entryId = bomEntry.getLong("entry.id");
        Long entryreplaceplanId = bomEntry.getLong("entry.entryreplaceplan");
        if (entryreplaceplanId == 0L) {
            return;
        }
        BigDecimal entryrequireqty = requireQtyMap.get(entryId);
        String entryisreplace = bomEntry.getString("entry.entryisreplace");
        if ("true".equals(entryisreplace)) {
            entryrequireqty = BigDecimal.ZERO;
        }
        String entryisreplaceplanmm = bomEntry.getString("entry.entryisreplaceplanmm");
        if (entryreplaceplanId > 0L && "true".equals(entryisreplaceplanmm)) {
            BigDecimal priorityQty;
            String reppriority = bomEntry.getString("entry.reppriority");
            Map replacepriorityQty = replaceplanReplacepriorityQty.computeIfAbsent(entryreplaceplanId, k -> new HashMap());
            BigDecimal qty = replaceplanQty.getOrDefault(entryreplaceplanId, BigDecimal.ZERO);
            if (qty == null) {
                qty = BigDecimal.ZERO;
            }
            if ((priorityQty = (BigDecimal)replacepriorityQty.get(reppriority)) == null) {
                priorityQty = BigDecimal.ZERO;
            }
            priorityQty = priorityQty.add(entryrequireqty);
            qty = qty.add(entryrequireqty);
            replaceplanQty.put(entryreplaceplanId, qty);
            replacepriorityQty.put(reppriority, priorityQty);
        }
    }

    private void deleteBOMEntryData(Map<Object, DynamicObject> materialEntry) {
        int size = this.getModel().getEntryRowCount("entryentity");
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        for (int i = 0; i < size; ++i) {
            DynamicObject entrymaterial;
            DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
            String entrymode = DynamicObjDataUtil.getDynamicObjectStringData((DynamicObject)entry, (String)"entrymode");
            if (StringUtils.equalsIgnoreCase((CharSequence)entrymode, (CharSequence)"B")) {
                indexs.add(i);
            }
            if (materialEntry == null || (entrymaterial = entry.getDynamicObject("entrymaterial")) == null) continue;
            materialEntry.put(entrymaterial.getPkValue(), entry);
        }
        int[] d = indexs.stream().mapToInt(Integer::intValue).toArray();
        this.getModel().deleteEntryRows("entryentity", d);
    }

    private void unfoldBomDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bom");
        if (newObject == null || !(newObject instanceof Date)) {
            String orderType = (String)this.getModel().getValue("ordertype");
            if (!StringUtils.equalsIgnoreCase((CharSequence)MaterialAttrEnum.PURCHASEDPART.getValue(), (CharSequence)orderType) && StringUtils.isNotBlank((CharSequence)orderType) && bom != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55BOM\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderEdit_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"unfoldbomdate", (Object)oldObject);
            }
            this.deleteCopEntryData();
            return;
        }
        Date date = (Date)newObject;
        if (bom != null) {
            DynamicObject version = bom.getDynamicObject("version");
            if (version != null) {
                version = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_bomversion", (QFilter[])new QFilter[]{new QFilter("id", "=", version.getPkValue())});
                Date effectdate = version.getDate("effectdate");
                Date invaliddate = version.getDate("invaliddate");
                if (date.compareTo(effectdate) < 0 || date.compareTo(invaliddate) >= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55BOM\u65f6\u95f4\u4e0d\u5728\u6709\u6548\u671f\u5185\u3002", (String)"PlanOrderEdit_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"unfoldbomdate", (Object)oldObject);
                    return;
                }
            }
            BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
            DynamicObjectCollection copentrys = bom.getDynamicObjectCollection("copentry");
            this.createCopEntry(copentrys, orderQty, date);
            this.loadCopEntry();
        }
        this.setManuVersion();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        if (op == null) {
            return;
        }
        String key = op.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"save") || StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"submit")) {
            op.getOption().setVariableValue("islog", "islog");
        }
    }

    private void startDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        Number leadtime;
        if (!(newObject instanceof Date)) {
            this.getModel().setValue("enddate", null);
            this.getModel().setValue("availabledate", null);
            return;
        }
        Date orderdate = (Date)this.getModel().getValue("orderdate");
        Date date = (Date)newObject;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getModel().setValue("enddate", (Object)date);
            return;
        }
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache());
        if (entryMaterialPlan == null) {
            this.getModel().setValue("enddate", (Object)date);
            return;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(date);
        }
        if (date == null) {
            date = (Date)newObject;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderEdit_15", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg")));
            this.getModel().setValue("enddate", null);
            this.getModel().setValue("availabledate", null);
        } else if (orderdate == null || orderdate.compareTo(date) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u51c6\u5907\u65e5\u671f\u3002", (String)"PlanOrderEdit_16", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"startdate", (Object)oldObject);
        } else {
            String leadtimetype = entryMaterialPlan.getString("leadtimetype");
            BigDecimal fixedleadtime = entryMaterialPlan.getBigDecimal("fixedleadtime");
            BigDecimal changeleadtime = entryMaterialPlan.getBigDecimal("changeleadtime");
            BigDecimal changebatchqty = entryMaterialPlan.getBigDecimal("changebatch");
            leadtime = BigDecimal.ZERO;
            if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)leadtimetype)) {
                leadtime = fixedleadtime;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)leadtimetype)) {
                BigDecimal orderqty = (BigDecimal)this.getModel().getValue("orderqty");
                if (orderqty.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"", (String)"PlanOrderEdit_17", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"startdate", (Object)oldObject);
                    return;
                }
                leadtime = orderqty.multiply(changeleadtime).divide(changebatchqty, RoundingMode.UP);
            }
            int days = leadtime.setScale(0, 0).intValue();
            Date enddate = PlanOrderHelper.getToWorkDateToDate((int)days, (Date)date, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)materialattr);
            if (enddate == null) {
                this.getModel().setValue("enddate", null);
                this.getModel().setValue("availabledate", null);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderEdit_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else {
                this.getModel().setValue("enddate", (Object)enddate);
            }
        }
        Boolean materiallock = (Boolean)this.getModel().getValue("materiallock");
        if (!materiallock.booleanValue()) {
            this.bomChange(this.getModel().getValue("bom"), this.getModel().getValue("bom"), null);
        } else {
            int entryRowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObject entry = this.getModel().getEntryRowEntity("entryentity", i);
                leadtime = entry.getInt("entryleadtime");
                Date reqDate = PlanOrderHelper.getReqDate((Date)date, (Integer)leadtime, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)materialattr);
                this.getModel().setValue("entryrequiredate", (Object)reqDate, i);
            }
        }
    }

    private void endDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof Date)) {
            Date startDate = (Date)this.getModel().getValue("startdate");
            if (newObject == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)newObject);
            } else if (startDate != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanOrderEdit_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)oldObject);
            }
            return;
        }
        Date endDate = (Date)newObject;
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate == null || startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u8ba1\u5212\u5f00\u59cb\u65e5\u671f\u3002", (String)"PlanOrderEdit_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            if (oldObject == null) {
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)oldObject);
            }
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)oldObject);
        } else {
            DynamicObject material = (DynamicObject)this.getModel().getValue("material");
            if (material == null) {
                this.getModel().setValue("availabledate", (Object)endDate);
                return;
            }
            DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
            DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache());
            if (entryMaterialPlan == null) {
                this.getModel().setValue("availabledate", (Object)endDate);
                return;
            }
            String materialattr = entryMaterialPlan.getString("materialattr");
            if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
                endDate = this.getRecentWorkDate(endDate);
            }
            StringBuilder errorsb = new StringBuilder();
            boolean errorboolean = false;
            if (endDate == null) {
                errorsb.append(ResManager.loadKDString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"PlanOrderEdit_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                errorboolean = true;
                endDate = (Date)newObject;
            }
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"enddate", (Object)endDate);
            BigDecimal testleadtime = entryMaterialPlan.getBigDecimal("inspectionleadtime");
            BigDecimal postprocessingtime = entryMaterialPlan.getBigDecimal("postprocessingtime");
            int days = testleadtime.add(postprocessingtime).setScale(0, 0).intValue();
            Date inspectionleadtime = PlanOrderHelper.getToWorkDateToLastDate((int)days, (Date)endDate, (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)materialattr);
            if (inspectionleadtime == null) {
                errorboolean = true;
                if (errorsb != null && errorsb.length() > 0) {
                    errorsb.append(String.format(ResManager.loadKDString((String)"%s\u53ef\u7528\u65e5\u671f\u7b49", (String)"PlanOrderEdit_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), "\u3001"));
                } else {
                    errorsb.append(ResManager.loadKDString((String)"\u53ef\u7528\u65e5\u671f", (String)"PlanOrderEdit_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                }
                Date lastDate = PlanOrderHelper.getLastDateToDate((Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")));
                if (lastDate != null && endDate.compareTo(lastDate) < 0) {
                    this.getModel().setValue("availabledate", (Object)PlanOrderHelper.getDate((Date)lastDate, (int)days));
                } else {
                    this.getModel().setValue("availabledate", (Object)PlanOrderHelper.getDate((Date)endDate, (int)days));
                }
            } else {
                this.getModel().setValue("availabledate", (Object)inspectionleadtime);
            }
            if (errorboolean) {
                errorsb.append(ResManager.loadKDString((String)"\u662f\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u4e4b\u5916\u7684\u65e5\u671f\u3002", (String)"PlanOrderEdit_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                this.getView().showTipNotification(String.format(errorsb.toString(), DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg")));
            }
        }
    }

    private void availableDateChange(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (!(newObject instanceof Date)) {
            return;
        }
        Date date = (Date)newObject;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            return;
        }
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)(supplyOrg == null ? 0L : supplyOrg.getLong("id")), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache());
        if (entryMaterialPlan == null) {
            return;
        }
        String materialattr = entryMaterialPlan.getString("materialattr");
        if (!MaterialAttrEnum.PURCHASEDPART.getValue().equals(materialattr)) {
            date = this.getRecentWorkDate(date);
        }
        if (date != null) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"availabledate", (Object)date);
        }
    }

    public void setControlEnable(Boolean isEnable, String parm, int rowIndex) {
        IFormView fv = this.getView();
        if (rowIndex >= 0) {
            fv.setEnable(isEnable, rowIndex, new String[]{parm});
        } else {
            fv.setEnable(isEnable, new String[]{parm});
        }
    }

    public void registerListener(EventObject e) {
        OrgEdit entrySupplyOrgUnit;
        Tab tab;
        BasedataEdit manuversion;
        BasedataEdit entrylocation;
        BasedataEdit entrywarehouse;
        BasedataEdit inwarelocation;
        BasedataEdit inwarehouse;
        BasedataEdit planscope;
        BasedataEdit entryConfiguredcode;
        BasedataEdit configuredcode;
        BasedataEdit planperson;
        BasedataEdit entrymaterial;
        BasedataEdit entryversion;
        BasedataEdit martial;
        BasedataEdit entrysupplyorg;
        BasedataEdit ecn;
        BasedataEdit unit;
        BasedataEdit proOrPurOrg;
        super.registerListener(e);
        BasedataEdit bom = (BasedataEdit)this.getControl("bom");
        if (bom != null) {
            bom.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((proOrPurOrg = (BasedataEdit)this.getControl("proorpurorg")) != null) {
            proOrPurOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ecn = (BasedataEdit)this.getControl("ecnversion")) != null) {
            ecn.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entrysupplyorg = (BasedataEdit)this.getControl("entrysupplyorg")) != null) {
            entrysupplyorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((martial = (BasedataEdit)this.getControl("material")) != null) {
            martial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryversion = (BasedataEdit)this.getControl("entryversion")) != null) {
            entryversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entrymaterial = (BasedataEdit)this.getControl("entrymaterial")) != null) {
            entrymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((planperson = (BasedataEdit)this.getControl("planpersonid")) != null) {
            planperson.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredcode = (BasedataEdit)this.getControl("configuredcode")) != null) {
            configuredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryConfiguredcode = (BasedataEdit)this.getControl("entryconfiguredcode")) != null) {
            entryConfiguredcode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((planscope = (BasedataEdit)this.getControl("planscope")) != null) {
            planscope.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarehouse = (BasedataEdit)this.getControl("inwarehouse")) != null) {
            inwarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((inwarelocation = (BasedataEdit)this.getControl("inwarelocation")) != null) {
            inwarelocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entrywarehouse = (BasedataEdit)this.getControl("entrywarehouse")) != null) {
            entrywarehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entrylocation = (BasedataEdit)this.getControl("entrylocation")) != null) {
            entrylocation.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((manuversion = (BasedataEdit)this.getControl("manuversion")) != null) {
            manuversion.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tab = (Tab)this.getControl(TABAP)) != null) {
            tab.addTabSelectListener((TabSelectListener)this);
        }
        if ((entrySupplyOrgUnit = (OrgEdit)this.getControl("entrysupplyorgunitid")) != null) {
            entrySupplyOrgUnit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>();
        ListShowParameter listShowParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"bom")) {
            this.beforeBomSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"proorpurorg")) {
            this.beforeProOrgSelect(qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"ecnversion")) {
            this.beforeECNSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entrysupplyorg")) {
            this.beforeSupplyOrgSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"material")) {
            this.beforeMaterialSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entryversion")) {
            this.beforeVersionSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"planpersonid")) {
            this.beforePlanpersonSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"configuredcode")) {
            this.beforeConfiguredcodeSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entryconfiguredcode")) {
            this.beforeEntryConfiguredcodeSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"planscope")) {
            this.beforePlanScopeSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"inwarehouse")) {
            this.beforeInwareHouseSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"inwarelocation")) {
            this.beforeInwareLocationSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entrysupplyorgunitid")) {
            this.beforeEntrySupplyOrgUnitSelect(evt);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entrywarehouse")) {
            this.beforeEntryWarehouseSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"entrylocation")) {
            this.beforeEntryLocationSelect(evt, qfilters);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"manuversion")) {
            this.beforeManuversionSelect(evt, qfilters);
        }
        if (!qfilters.isEmpty()) {
            listShowParameter.getListFilterParameter().getQFilters().addAll(qfilters);
        }
    }

    private void beforeManuversionSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject supplyOrg;
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PlanOrderEdit_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long materialId = Long.valueOf(material.getPkValue().toString());
        DynamicObject materialMftInfo = PlanOrderHelper.getMaterialMftInfo((Long)materialId, (Long)((supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg")) == null ? 0L : supplyOrg.getLong("id")), (String)"bd_materialmftinfo", (String)this.getMaterialMftSelectFields(), (IPageCache)this.getPageCache());
        if (materialMftInfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PlanOrderEdit_33", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        BigDecimal orderQty = (BigDecimal)this.getModel().getValue("orderqty");
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        QFilter qFilter = new QFilter("material", "=", (Object)materialMftInfo.getLong("id"));
        qfilters.add(qFilter);
        if (orderQty != null && BigDecimal.ZERO.compareTo(orderQty) != 0) {
            qfilters.add(new QFilter("beginqty", "<=", (Object)orderQty));
            qfilters.add(new QFilter("endqty", ">=", (Object)orderQty));
        }
        if (unfoldBomDate != null) {
            qfilters.add(new QFilter("begindate", "<=", (Object)unfoldBomDate));
            qfilters.add(new QFilter("enddate", ">=", (Object)unfoldBomDate));
        }
    }

    private void beforeEntryLocationSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (row < 0) {
            evt.setCancel(true);
            return;
        }
        DynamicObject entryWarehouse = (DynamicObject)this.getModel().getValue("entrywarehouse", row);
        if (entryWarehouse == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (String)"PlanOrderEdit_36", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), row + 1));
            evt.setCancel(true);
            return;
        }
        QFilter stockfilter = new QFilter("id", "=", (Object)entryWarehouse.getLong("id"));
        DynamicObjectCollection stocks = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.*,entryentity.location.*", (QFilter[])new QFilter[]{stockfilter});
        ArrayList<Long> idlists = new ArrayList<Long>();
        for (int i = 0; i < stocks.size(); ++i) {
            DynamicObject object = (DynamicObject)stocks.get(i);
            if (object.get("entryentity.location.id") == null) continue;
            idlists.add((Long)object.get("entryentity.location.id"));
        }
        QFilter indexfilter = new QFilter("id", "in", idlists);
        qfilters.add(indexfilter);
    }

    private void beforeEntrySupplyOrgUnitSelect(BeforeF7SelectEvent evt) {
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.setMultiSelect(false);
    }

    private void beforeEntryWarehouseSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (row < 0) {
            evt.setCancel(true);
            return;
        }
        DynamicObject entrysupplyorg = (DynamicObject)this.getModel().getValue("entrysupplyorgunitid", row);
        if (entrysupplyorg == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8bf7\u5148\u5f55\u5165\u4f9b\u8d27\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_49", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), row + 1));
            evt.setCancel(true);
            return;
        }
        Long proorpurorgId = Long.valueOf(entrysupplyorg.getPkValue().toString());
        QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
        QFilter storageflt = new QFilter("org", "=", (Object)proorpurorgId);
        QFilter startStatusFilter = new QFilter("startstatus", "=", (Object)"B");
        QFilter[] qFilters = new QFilter[]{isinit, storageflt, startStatusFilter};
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"im_warehousesetup", (String)"warehouse.id", (QFilter[])qFilters);
        Iterator it = coll.iterator();
        ArrayList<Long> entryWarehouses = new ArrayList<Long>(coll.size());
        while (it.hasNext()) {
            DynamicObject obj = (DynamicObject)it.next();
            entryWarehouses.add(obj.getLong("warehouse.id"));
        }
        QFilter qFilter = new QFilter("id", "in", entryWarehouses);
        qfilters.add(qFilter);
    }

    private void beforePlanScopeSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        DynamicObject purorg = (DynamicObject)this.getModel().getValue("proorpurorg");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_37", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long orgId = org.getLong("id");
        long purOrgId = purorg.getLong("id");
        ArrayList<Long> orgIds = new ArrayList<Long>(2);
        orgIds.add(orgId);
        orgIds.add(purOrgId);
        List defPlanScopeIds = PlanScopeHelper.getPlanScopes(orgIds, (QFilter)null);
        qfilters.add(new QFilter("id", "in", (Object)defPlanScopeIds));
        if (material == null) {
            return;
        }
        long materialId = material.getLong("id");
        DynamicObject materialPlan = this.getMaterialPlanByOrgAndMaterial(purOrgId, materialId);
        String materialAttr = materialPlan.getString("materialattr");
        if (orgId == purOrgId) {
            if (!MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                List planScopeIdsByRelation = PlanScopeHelper.getPlanScopes(Collections.singletonList(purOrgId), (Long)materialId);
                List planScopeIdsByType = PlanScopeHelper.getPlanScopes(Collections.singletonList(purOrgId));
                planScopeIdsByRelation.addAll(planScopeIdsByType);
                qfilters.add(new QFilter("id", "in", (Object)planScopeIdsByRelation));
            }
        } else {
            String supplyRule = (String)this.getModel().getValue("supplyrule");
            if (SupplyRuleEnum.ACROSS_ORG_STORE.getValue().equals(supplyRule)) {
                List planScopeIdsByRelation = PlanScopeHelper.getPlanScopes(Collections.singletonList(orgId), (Long)materialId);
                List planScopeIdsByType = PlanScopeHelper.getPlanScopes(Collections.singletonList(orgId));
                planScopeIdsByRelation.addAll(planScopeIdsByType);
                qfilters.add(new QFilter("id", "in", (Object)planScopeIdsByRelation));
            } else if (!MaterialAttrEnum.COLLABORATIVEPART.getValue().equals(materialAttr)) {
                List planScopeIdsByRelation = PlanScopeHelper.getPlanScopes(Collections.singletonList(purOrgId), (Long)materialId);
                List planScopeIdsByType = PlanScopeHelper.getPlanScopes(Collections.singletonList(purOrgId));
                planScopeIdsByRelation.addAll(planScopeIdsByType);
                qfilters.add(new QFilter("id", "in", (Object)planScopeIdsByRelation));
            }
        }
    }

    private DynamicObject getMaterialPlanByOrgAndMaterial(long orgId, long materialId) {
        return PlanOrderHelper.getMaterialInfo((Long)materialId, (Long)orgId, (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache(), null, (boolean)false);
    }

    private void beforeInwareHouseSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PlanOrderEdit_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject inWarOrg = (DynamicObject)this.getModel().getValue("inwarorg");
        if (inWarOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5165\u5e93\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_46", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long inWarOrgId = inWarOrg.getLong("id");
        List inWareHouses = PlanScopeHelper.getInwareHouses((Long)inWarOrgId);
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().clear();
        parameter.setUseOrgId(inWarOrgId);
        QFilter qFilter = new QFilter("id", "in", (Object)inWareHouses);
        qfilters.add(qFilter);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_warehouse", (Long)inWarOrgId);
        qfilters.add(baseDataFilter);
    }

    private void beforeInwareLocationSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject inwareHouse = (DynamicObject)this.getModel().getValue("inwarehouse");
        if (inwareHouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4ed3\u5e93\u3002", (String)"PlanOrderEdit_34", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter stockfilter = new QFilter("id", "=", (Object)inwareHouse.getLong("id"));
        DynamicObjectCollection stocks = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.*,entryentity.location.*", (QFilter[])new QFilter[]{stockfilter});
        ArrayList<Long> idlists = new ArrayList<Long>();
        for (int i = 0; i < stocks.size(); ++i) {
            DynamicObject object = (DynamicObject)stocks.get(i);
            if (object.get("entryentity.location.id") == null) continue;
            idlists.add((Long)object.get("entryentity.location.id"));
        }
        QFilter indexfilter = new QFilter("id", "in", idlists);
        qfilters.add(indexfilter);
    }

    private void beforeConfiguredcodeSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PlanOrderEdit_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Long materialId = Long.valueOf(material.getPkValue().toString());
        qfilters.add(new QFilter("material", "=", (Object)materialId));
    }

    private void beforeEntryConfiguredcodeSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (row < 0) {
            evt.setCancel(true);
            return;
        }
        DynamicObject entrymaterial = (DynamicObject)this.getModel().getValue("entrymaterial", row);
        if (entrymaterial == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"PlanOrderEdit_26", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), row + 1));
            evt.setCancel(true);
            return;
        }
        Long materialId = Long.valueOf(entrymaterial.getPkValue().toString());
        qfilters.add(new QFilter("material", "=", (Object)materialId));
    }

    public void beforeProOrgSelect(List<QFilter> qfilters) {
        Set orgIDSet = PlanViewOrgHelper.getOrgIdsByPlanView();
        QFilter idFilter = new QFilter("id", "in", (Object)orgIDSet);
        qfilters.add(idFilter);
    }

    public void tabSelected(TabSelectEvent tabEvent) {
        String tabKey = tabEvent.getTabKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)tabKey, (CharSequence)TABPAGEAP1)) {
            this.materialLock();
        }
    }

    private void materialLock() {
        DynamicObject bom;
        String billstatus = (String)this.getModel().getValue("billstatus");
        boolean materiallock = (Boolean)this.getModel().getValue("materiallock");
        if (!materiallock && "A".equals(billstatus) && (bom = (DynamicObject)this.getModel().getValue("bom")) != null) {
            this.bomChange(bom, bom, null);
        }
    }

    private void beforePlanpersonSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        DynamicObject supplyOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"proorpurorg");
        if (supplyOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_27", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PlanOrderEdit_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)material.getLong("id"), (Long)supplyOrg.getLong("id"), (String)MPDM_MATERIAL_PLAN, (String)this.getMaterialPlanSelectFields(), (IPageCache)this.getPageCache());
        if (entryMaterialPlan != null) {
            DynamicObject plangroup = entryMaterialPlan.getDynamicObject("plangroup");
            if (plangroup != null) {
                QFilter qFilter = new QFilter("id", "=", plangroup.getPkValue());
                QFilter qFilter1 = new QFilter("entryentity.businessarea", "=", (Object)"MRP");
                DynamicObjectCollection plans = QueryServiceHelper.query((String)"mpdm_demandgroup", (String)"entryentity.operator operator", (QFilter[])new QFilter[]{qFilter, qFilter1});
                ArrayList<Long> ids = new ArrayList<Long>(plans.size());
                if (plans != null) {
                    for (DynamicObject plan : plans) {
                        ids.add(plan.getLong("operator"));
                    }
                    qfilters.add(new QFilter("id", "in", ids));
                }
            } else {
                Set ids = PlanOperatorGroupHelper.getOperatorUserByGroup((Long)supplyOrg.getLong("id"));
                qfilters.add(new QFilter("id", "in", (Object)ids));
            }
        }
    }

    private void beforeVersionSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        if (row < 0) {
            evt.setCancel(true);
            return;
        }
        DynamicObject entrymaterial = (DynamicObject)this.getModel().getValue("entrymaterial", row);
        if (entrymaterial == null) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8ba2\u5355\u7269\u6599\u7b2c%s\u884c\uff0c\u8bf7\u5148\u5f55\u5165\u7ec4\u4ef6\u7f16\u7801\u3002", (String)"PlanOrderEdit_26", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), row + 1));
            evt.setCancel(true);
            return;
        }
        Object material = entrymaterial.get("masterid");
        if (material instanceof DynamicObject) {
            entrymaterial = (DynamicObject)material;
        }
        QFilter qFilter = new QFilter("material", "=", entrymaterial.getPkValue());
        qfilters.add(qFilter);
    }

    public void beforeMaterialSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject proOrPurOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (org == null && proOrPurOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_30", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_37", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        long orgId = org.getLong("id");
        long proOrPurOrgId = proOrPurOrg.getLong("id");
        String supplyRule = (String)this.getModel().getValue("supplyrule");
        if (orgId != proOrPurOrgId && StringUtils.isBlank((CharSequence)supplyRule)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u4f9b\u5e94\u89c4\u5219\u3002", (String)"PlanOrderEdit_38", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    public long getCurrentBillId() {
        DynamicObject billType = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)"billtype");
        if (billType != null) {
            return billType.getLong("id");
        }
        return 0L;
    }

    private void beforeSupplyOrgSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (supplyOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_27", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
    }

    private void beforeECNSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject bom = (DynamicObject)this.getModel().getValue("bom");
        if (bom == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165BOM", (String)"PlanOrderEdit_28", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        QFilter qfilter = new QFilter("number", "=", (Object)"ECN00");
        DynamicObject ecn = BusinessDataServiceHelper.loadSingle((String)"pdm_ecnversion", (String)"id", (QFilter[])new QFilter[]{qfilter});
        QFilter qfilter1 = null;
        qfilter1 = ecn != null ? new QFilter("bom.id", "=", bom.getPkValue()).or("id", "=", ecn.getPkValue()) : new QFilter("bom.id", "=", bom.getPkValue());
        qfilters.add(qfilter1);
    }

    private void beforeBomSelect(BeforeF7SelectEvent evt, List<QFilter> qfilters) {
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        if (material == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u7269\u6599\u3002", (String)"PlanOrderEdit_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Date date = (Date)this.getModel().getValue("unfoldbomdate");
        if (date == null) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5c55BOM\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlanOrderEdit_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        String configproperties = material.getString(CONFIGPROPERTIES);
        DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
        if (configuredcode == null && CONFIGURATION.equals(configproperties)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u914d\u7f6e\u53f7\u3002", (String)"PlanOrderEdit_29", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        Object masterid = material.get("masterid");
        Object materId = material.getPkValue();
        if (masterid instanceof DynamicObject) {
            materId = ((DynamicObject)masterid).getPkValue();
        }
        QFilter qFilter1 = new QFilter("material.masterid", "=", materId);
        QFilter qFilter2 = new QFilter("materialid", "=", materId);
        qFilter1.or(qFilter2);
        qfilters.add(qFilter1);
        if (CONFIGURATION.equals(configproperties)) {
            QFilter configuredcodeqfilter = new QFilter("configuredcode", "=", (Object)configuredcode.getLong("id"));
            qfilters.add(configuredcodeqfilter);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        Date unfoldBomDate = (Date)this.getModel().getValue("unfoldbomdate");
        DynamicObject material = (DynamicObject)this.getModel().getValue("material");
        DynamicObject configuredcode = (DynamicObject)this.getModel().getValue("configuredcode");
        DynamicObject oldBom = (DynamicObject)this.getModel().getValue("bom");
        DynamicObject supplyOrg = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (unfoldBomDate == null || material == null || supplyOrg == null) {
            return;
        }
        this.setDefPlanScope();
        unfoldBomDate = new Date();
        QFilter qfilter = null;
        String configproperties = material.getString(CONFIGPROPERTIES);
        if (CONFIGURATION.equals(configproperties)) {
            if (configuredcode == null) {
                this.getModel().setValue("unfoldbomdate", null);
                this.getModel().setValue("bom", null);
                this.bomChange(oldBom, null, null);
                return;
            }
            qfilter = new QFilter("configuredcode", "=", configuredcode.getPkValue());
        }
        DynamicObject auxproperty = (DynamicObject)this.getModel().getValue("auxproperty");
        boolean isaCarryBom = PlanOrderHelper.dealAuxptyEntry((DynamicObject)material, null);
        DynamicObject bom = null;
        if (isaCarryBom) {
            List auxptyEntryMust = PlanOrderHelper.getAuxptyEntryMust((DynamicObject)material);
            if (auxproperty != null) {
                String json = auxproperty.getString("value");
                Map values = (Map)JSON.parseObject((String)json, Map.class);
                for (Map.Entry value : values.entrySet()) {
                    Object key = value.getKey();
                    if (!auxptyEntryMust.contains(key)) continue;
                    StringBuilder str = new StringBuilder();
                    str.append("%\"").append(key).append("\":");
                    Object val = value.getValue();
                    if (val instanceof String) {
                        str.append("\"").append(val).append("\"%");
                    } else if (val instanceof Integer || val instanceof Long) {
                        str.append(val).append("%");
                    }
                    if (qfilter == null) {
                        qfilter = new QFilter("auxproperty.value", "like", (Object)str.toString());
                        continue;
                    }
                    QFilter auxpropertyqfilter = new QFilter("auxproperty.value", "like", (Object)str.toString());
                    qfilter.and(auxpropertyqfilter);
                }
            }
            if ((bom = this.getBom(supplyOrg, material, unfoldBomDate, qfilter)) == null) {
                this.getModel().setValue("unfoldbomdate", (Object)unfoldBomDate);
                this.getModel().setValue("bom", (Object)bom);
                this.bomChange(oldBom, null, null);
                return;
            }
        } else {
            bom = this.getBom(supplyOrg, material, unfoldBomDate, qfilter);
            if (bom == null) {
                return;
            }
        }
        this.getModel().setValue("unfoldbomdate", (Object)unfoldBomDate);
        this.getModel().setValue("bom", bom == null ? null : Long.valueOf(bom.getLong("id")));
        Boolean materiallock = (Boolean)this.getModel().getValue("materiallock");
        if (materiallock.booleanValue() && oldBom != null && oldBom.getPkValue().toString().equals(bom.getString("id"))) {
            return;
        }
        this.bomChange(oldBom, bom, null);
    }

    private Date getRecentWorkDate(Date date) {
        if (date == null) {
            return null;
        }
        DynamicObject dept = (DynamicObject)this.getModel().getValue("proorpurorg");
        if (dept == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u4f9b\u5e94\u7ec4\u7ec7\u3002", (String)"PlanOrderEdit_30", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return null;
        }
        Set calendarIds = PlanOrderHelper.getCalendarIds((Long)dept.getLong("id"));
        if (calendarIds == null || calendarIds.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u201c%s\u201d\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\uff0c\u8bf7\u5148\u8bbe\u7f6e\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u3002", (String)"PlanOrderEdit_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), dept.getString("name")));
            return null;
        }
        Date workDate = PlanOrderHelper.getRecentWorkDate((Date)date, (Long)dept.getLong("id"));
        return workDate;
    }

    private void setOrderMaterialEnable(int rowIndex, String entryMode) {
        if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)entryMode)) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"entrymaterial", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entrystandqty", "entrysupplytype", "entryversion", "entryauxproperty"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"entrymaterial", "entryqtytype", "entryqtynumerator", "entryqtydenominator", "entrystandqty", "entrysupplytype", "entryversion", "entryauxproperty"});
        }
    }

    private boolean isEnablePlanScope() {
        String enablePlanScopeStr = this.getPageCache().get(CACHE_ENABLE_PLAN_SCOPE);
        if (StringUtils.isBlank((CharSequence)enablePlanScopeStr)) {
            boolean enablePlanScope = PlanScopeHelper.isEnablePlanScope();
            this.getPageCache().put(CACHE_ENABLE_PLAN_SCOPE, String.valueOf(enablePlanScope));
            return enablePlanScope;
        }
        return Boolean.parseBoolean(enablePlanScopeStr);
    }
}

