/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.BillStatus;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.common.cache.PlanOrderCacheMrg;
import kd.mpscmm.common.consts.PlanOrderConst;
import kd.mpscmm.common.enums.MaterialAttrEnum;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanViewOrgHelper;

public class PlanOrderList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PlanOrderList.class);
    private static final String ALLDROP = "alldrop";
    private static final String DROP = "drop";
    private static final String SPLIT = "split";
    private static final String MRP_PLANORDERDROP = "mrp_planorderdrop";
    private static final String MRP_PLANORDERSPLIT = "mrp_planordersplit";
    private static final String MRP_COMPENSATE = "mrp_compensate";
    private static final String MSPLAN_BATCHUPDFIELD = "msplan_batchupdfield";
    private static final String ALLDROPSTATUSSELECT = "alldropstatusselect";
    private static final String ALLDROPSELECT = "alldropselect";
    private static final String DROPSTATUSSELECT = "dropstatusselect";
    private static final String COMPENSATE = "compensate";
    private static final String BATCHUPDFIELD = "batchupdfield";
    private static final String UPDATELOG = "updatelog";
    private static final String UPDATEDESC = "updatedesc";

    public void filterContainerInit(FilterContainerInitArgs args) {
        String entityNumber = this.getEntityNumber();
        super.filterContainerInit(args);
        CommonFilterColumn orderTypeFilter = null;
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (columnFilter.getFieldName().startsWith("proorpurorg")) {
                PlanViewOrgHelper.setPlanViewOrgFilter((CommonFilterColumn)columnFilter, (String)entityNumber, (String)"mrp");
                continue;
            }
            if (!"ordertype".equals(columnFilter.getFieldName())) continue;
            orderTypeFilter = (CommonFilterColumn)filterColumn;
        }
        if (orderTypeFilter != null && PlanOrderHelper.getMenuParams((IFormView)this.getView(), (String)"orderType") != null) {
            args.getCommonFilterColumns().remove(orderTypeFilter);
        }
    }

    private String getEntityNumber() {
        BillList billList = (BillList)this.getControl("billlistap");
        String billFormId = billList.getEntityId();
        if (StringUtils.isBlank((CharSequence)billFormId)) {
            billFormId = "mrp_planorder";
        }
        return billFormId;
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String field = args.getFieldName();
        if (field != null && field.contains("proorpurorg")) {
            Set orgIds = PlanViewOrgHelper.getOrgIdsByPlanView();
            QFilter orgFilter = new QFilter("id", "in", (Object)orgIds);
            args.addCustomQFilter(orgFilter);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)DROP, (CharSequence)key) && result != null && result.isSuccess()) {
            String jsonStr = this.getPageCache().get(DROP);
            String msg = this.getPageCache().get("msg");
            String orderType = this.getPageCache().get("ordertype");
            String org = this.getPageCache().get("proorpurorg");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put(DROP, jsonStr);
            customParams.put("ordertype", orderType);
            customParams.put("proorpurorg", org);
            customParams.put("msg", msg);
            customParams.put("entitynumber", this.getEntityNumber());
            this.showView(MRP_PLANORDERDROP, customParams, DROP, ShowType.MainNewTabPage, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)SPLIT, (CharSequence)key)) {
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            String jsonStr = this.getPageCache().get(SPLIT);
            customParams.put(SPLIT, jsonStr);
            customParams.put("entitynumber", this.getEntityNumber());
            this.showView(MRP_PLANORDERSPLIT, customParams, SPLIT, ShowType.Modal, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ALLDROPSTATUSSELECT, (CharSequence)key) && result != null && result.isSuccess()) {
            this.allDropData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BATCHUPDFIELD, (CharSequence)key) && result != null && result.isSuccess()) {
            this.batchUpdFieldData();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ALLDROP, (CharSequence)key) && result != null && result.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void allDropData() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String jsonStr = this.getPageCache().get(ALLDROPSTATUSSELECT);
        customParams.put(ALLDROPSTATUSSELECT, jsonStr);
        String status = "B";
        String orderType = this.getPageCache().get("ordertype");
        String org = this.getPageCache().get("proorpurorg");
        ArrayList<HashMap> planorders = new ArrayList<HashMap>(100);
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            Map planorderBillnoMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
            for (Map.Entry data : planorderBillnoMap.entrySet()) {
                HashMap planorder = Maps.newHashMapWithExpectedSize((int)2);
                planorder.put("id", data.getKey());
                planorder.put("billno", data.getValue());
                planorders.add(planorder);
            }
        }
        if (planorders != null && planorders.size() > 0) {
            customParams.put(ALLDROPSTATUSSELECT, planorders);
            customParams.put("dropstatus", status);
            customParams.put("ordertype", orderType);
            customParams.put("proorpurorg", org);
            customParams.put("entitynumber", this.getEntityNumber());
            this.showView("mrp_planorderbatchdrop", customParams, "jindu", ShowType.Modal, null);
            return;
        }
    }

    private void showView(String formId, Map<String, Object> customParams, String callBackKey, ShowType type, String CALLBACK) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(formId);
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackKey));
        showParameter.getOpenStyle().setShowType(type);
        if (CALLBACK != null) {
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK));
        }
        this.getView().showForm(showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        if (op == null) {
            return;
        }
        String key = op.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)DROP)) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            this.beforeDrop(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)SPLIT)) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            this.beforeSplit(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)ALLDROPSTATUSSELECT)) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            this.beforeAllDrop(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)COMPENSATE)) {
            FormShowParameter showParameter = new FormShowParameter();
            ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
            if (!listSelectedRows.isEmpty()) {
                ArrayList<Long> ids = new ArrayList<Long>(listSelectedRows.size());
                for (ListSelectedRow listSelectedRow : listSelectedRows) {
                    Object id = listSelectedRow.getPrimaryKeyValue();
                    ids.add(Long.valueOf(id.toString()));
                }
                showParameter.setCustomParam("planorderid", ids);
            }
            List mainOrgIds = this.getSelectedMainOrgIds();
            showParameter.setCustomParam("bizorg", (Object)mainOrgIds);
            showParameter.setFormId(MRP_COMPENSATE);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COMPENSATE));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("entitynumber", (Object)this.getEntityNumber());
            this.getView().showForm(showParameter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)BATCHUPDFIELD)) {
            op.getOption().setVariableValue("batchop_batchsize", String.valueOf(0));
            this.beforeBatchUpdField(e);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)UPDATELOG)) {
            this.beforeUpdateLog(e);
        }
    }

    private void beforeUpdateLog(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        List filters = listShowParameter.getListFilterParameter().getQFilters();
        IFormView view = this.getView();
        ArrayList<Long> planorderIds = new ArrayList<Long>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            planorderIds.add(Long.valueOf(listSelectedRow.getPrimaryKeyValue().toString()));
        }
        filters.add(new QFilter("planorderid", "in", planorderIds));
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId("msplan_planupdatelog");
        view.showForm((FormShowParameter)listShowParameter);
    }

    private void beforeBatchUpdField(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errmsg = new ArrayList<String>();
        StringBuilder errStr = new StringBuilder();
        HashMap<Long, String> idBillnoMap = new HashMap<Long, String>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            String billNo = listSelectedRow.getBillNo();
            String billStatus = listSelectedRow.getBillStatus();
            if (!billStatus.equals(BillStatus.A.name())) {
                e.cancel = true;
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u72b6\u6001\u8981\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\u3002", (String)"PlanOrderList_27", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billNo);
                errmsg.add(msg);
                errStr.append(msg).append("\r\n");
                continue;
            }
            Object id = listSelectedRow.getPrimaryKeyValue();
            idBillnoMap.put(Long.valueOf(id.toString()), billNo);
        }
        String idBillnoStr = SerializationUtils.toJsonString(idBillnoMap);
        this.getPageCache().put(BATCHUPDFIELD, idBillnoStr);
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() <= 1) {
            this.getView().showErrorNotification((String)errmsg.get(0));
            return;
        }
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u5931\u8d25", (String)"PlanOrderList_28", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return;
        }
        if (errmsg.size() != listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u72b6\u6001\u4e0d\u4e3a\u6682\u5b58\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6279\u91cf\u4fee\u6539\uff0c\u662f\u5426\u7ee7\u7eed\u6279\u91cf\u4fee\u6539\u5176\u4ed6\u6570\u636e?", (String)"PlanOrderList_29", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errmsg.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(BATCHUPDFIELD, (IFormPlugin)this));
            return;
        }
    }

    private void beforeAllDrop(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errmsg = new ArrayList<String>();
        StringBuilder errStr = new StringBuilder();
        HashSet orgs = Sets.newHashSetWithExpectedSize((int)listSelectedRows.size());
        Long org = 0L;
        HashMap<Long, String> idBillnoMap = new HashMap<Long, String>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            String billNo = listSelectedRow.getBillNo();
            String billStatus = listSelectedRow.getBillStatus();
            if (!billStatus.equals(BillStatus.C.name())) {
                e.cancel = true;
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u72b6\u6001\u8981\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u76f4\u63a5\u6295\u653e\u3002", (String)"PlanOrderList_24", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billNo);
                errmsg.add(msg);
                errStr.append(msg).append("\r\n");
                continue;
            }
            org = listSelectedRow.getMainOrgId();
            orgs.add(org);
            Object id = listSelectedRow.getPrimaryKeyValue();
            idBillnoMap.put(Long.valueOf(id.toString()), billNo);
        }
        boolean isPass = this.checkData(idBillnoMap, orgs);
        if (!isPass) {
            e.cancel = true;
            return;
        }
        String jsonStr = SerializationUtils.toJsonString(idBillnoMap);
        this.getPageCache().put(ALLDROPSTATUSSELECT, jsonStr);
        this.getPageCache().put("ordertype", null);
        this.getPageCache().put("proorpurorg", org.toString());
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() <= 1) {
            this.getView().showErrorNotification((String)errmsg.get(0));
            return;
        }
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u76f4\u63a5\u6295\u653e\u5931\u8d25", (String)"PlanOrderList_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return;
        }
        if (errmsg.size() != listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6295\u653e\uff0c\u662f\u5426\u7ee7\u7eed\u6295\u653e\u5176\u4ed6\u6570\u636e?", (String)"PlanOrderList_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errmsg.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(ALLDROPSTATUSSELECT, (IFormPlugin)this));
            return;
        }
    }

    private boolean checkData(Map<Long, String> idBillnoMap, Set<Long> orgs) {
        if (idBillnoMap == null || idBillnoMap.isEmpty() || orgs == null || orgs.isEmpty()) {
            return true;
        }
        ArrayList<String> errmsg = new ArrayList<String>();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        filters.add(new QFilter("id", "in", idBillnoMap.keySet()));
        filters.add(new QFilter("materialspread", "=", (Object)false));
        DataSet dataset = QueryServiceHelper.queryDataSet((String)PlanOrderList.class.getName(), (String)"mrp_planorder", (String)"id,ordertype,proorpurorg,entryentity.entrymaterial,entryentity.entrymaterial.number", (QFilter[])filters.toArray(new QFilter[0]), null);
        QFilter qFilterStatus = new QFilter("status", "=", (Object)"C");
        QFilter qFilterEnable = new QFilter("enable", "=", (Object)"1");
        QFilter basedataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialmftinfo", new ArrayList<Long>(orgs), (boolean)false);
        QFilter[] matfilters = new QFilter[]{qFilterStatus, qFilterEnable, basedataFilter};
        DataSet matdataset = QueryServiceHelper.queryDataSet((String)PlanOrderHelper.class.getName(), (String)"bd_materialmftinfo", (String)"id materialplanid,masterid", (QFilter[])matfilters, null);
        StringBuilder errStr = new StringBuilder();
        try (DataSet dataSet = dataset.leftJoin(matdataset).on("entryentity.entrymaterial", "masterid").select(dataset.getRowMeta().getFieldNames(), matdataset.getRowMeta().getFieldNames()).finish();){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long id = row.getLong("id");
                String ordertype = row.getString("ordertype");
                if (MaterialAttrEnum.PURCHASEDPART.getValue().equals(ordertype)) continue;
                Long materialplanid = row.getLong("materialplanid");
                String materialNumber = row.getString("entryentity.entrymaterial.number");
                if (!StringUtils.isBlank((Object)materialplanid) && materialplanid != 0L) continue;
                String msg = String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u8ba2\u5355%1$s\uff1a\u7ec4\u4ef6\u7269\u6599\u7f16\u7801\uff1a%2$s\u672a\u67e5\u8be2\u5230\u751f\u4ea7\u4fe1\u606f\u3002", (String)"PlanOrderList_31", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), idBillnoMap.get(id), materialNumber);
                errmsg.add(msg);
                errStr.append(msg).append("\r\n");
            }
            dataset.close();
        }
        if (errmsg.size() == 1) {
            this.getView().showErrorNotification((String)errmsg.get(0));
            return false;
        }
        if (errmsg.size() >= 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6295\u653e\u5931\u8d25", (String)"PlanOrderList_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return false;
        }
        return true;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (ALLDROPSTATUSSELECT.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.allDropData();
        } else if (DROPSTATUSSELECT.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String idsStr = this.getPageCache().get(ALLDROPSELECT);
            List ids = (List)SerializationUtils.fromJsonString((String)idsStr, List.class);
            HashMap<Long, String> idBillnoMap = new HashMap<Long, String>(ids.size());
            ArrayList<String> errormsg = new ArrayList<String>();
            String orderType = this.getOrderType(idBillnoMap, ids, errormsg, true);
            if (errormsg.size() > 0) {
                if (errormsg.size() == 1) {
                    this.getView().showTipNotification((String)errormsg.get(0));
                } else if (errormsg.size() > 1) {
                    this.showOperationResultMulti(errormsg.size(), errormsg, ResManager.loadKDString((String)"\u5206\u6279\u6295\u653e", (String)"PlanOrderList_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                }
                return;
            }
            String jsonStr = SerializationUtils.toJsonString(idBillnoMap);
            String org = this.getPageCache().get("proorpurorg");
            String msg = this.getPageCache().get("msg");
            HashMap<String, Object> customParams = new HashMap<String, Object>();
            customParams.put(DROP, jsonStr);
            customParams.put("ordertype", orderType);
            customParams.put("proorpurorg", org);
            customParams.put("msg", msg);
            customParams.put("entitynumber", this.getEntityNumber());
            this.showView(MRP_PLANORDERDROP, customParams, DROP, ShowType.MainNewTabPage, null);
        } else if (BATCHUPDFIELD.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.batchUpdFieldData();
        }
    }

    private void batchUpdFieldData() {
        HashMap<String, Object> customParams = new HashMap<String, Object>();
        String jsonStr = this.getPageCache().get(BATCHUPDFIELD);
        if (StringUtils.isBlank((CharSequence)jsonStr)) {
            return;
        }
        Map idbillnoMap = (Map)SerializationUtils.fromJsonString((String)jsonStr, Map.class);
        customParams.put(BATCHUPDFIELD, idbillnoMap);
        customParams.put("entitynumber", this.getEntityNumber());
        this.showView(MSPLAN_BATCHUPDFIELD, customParams, BATCHUPDFIELD, ShowType.Modal, null);
    }

    private void beforeDrop(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList<String> errormsg = new ArrayList<String>();
        ArrayList<String> errmsg = new ArrayList<String>();
        StringBuilder errStr = new StringBuilder();
        ArrayList<Long> ids = new ArrayList<Long>(listSelectedRows.size());
        HashSet orgs = Sets.newHashSetWithExpectedSize((int)listSelectedRows.size());
        Long org = 0L;
        HashMap<Long, String> idBillnoMap = new HashMap<Long, String>(listSelectedRows.size());
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            String billNo = listSelectedRow.getBillNo();
            String billStatus = listSelectedRow.getBillStatus();
            if (!billStatus.equals(BillStatus.C.name())) {
                e.cancel = true;
                String msg = String.format(ResManager.loadKDString((String)"%s\uff1a\u5355\u636e\u72b6\u6001\u8981\u4e3a\u5df2\u5ba1\u6838\u72b6\u6001\uff0c\u624d\u5141\u8bb8\u5206\u6279\u6295\u653e\u3002", (String)"PlanOrderList_25", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billNo);
                errmsg.add(msg);
                errStr.append(msg).append("\r\n");
                continue;
            }
            org = listSelectedRow.getMainOrgId();
            orgs.add(org);
            Object id = listSelectedRow.getPrimaryKeyValue();
            ids.add(Long.valueOf(id.toString()));
            idBillnoMap.put(Long.valueOf(id.toString()), billNo);
        }
        if (orgs != null && orgs.size() > 1) {
            e.cancel = true;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u7ec4\u7ec7\u76f8\u540c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_23", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        boolean isPass = this.checkData(idBillnoMap, orgs);
        if (!isPass) {
            e.cancel = true;
            return;
        }
        String idsStr = SerializationUtils.toJsonString(ids);
        this.getPageCache().put(ALLDROPSELECT, idsStr);
        this.getPageCache().put("proorpurorg", org.toString());
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() <= 1) {
            this.getView().showErrorNotification((String)errmsg.get(0));
            return;
        }
        if (errmsg.size() == listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u5206\u6279\u6295\u653e\u5931\u8d25", (String)"PlanOrderList_7", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errStr.toString(), MessageTypes.Default);
            return;
        }
        if (errmsg.size() != listSelectedRows.size() && errmsg.size() >= 1) {
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u5b58\u5728%s\u6761\u72b6\u6001\u4e0d\u4e3a\u5df2\u5ba1\u6838\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u6295\u653e\uff0c\u662f\u5426\u7ee7\u7eed\u6295\u653e\u5176\u4ed6\u6570\u636e?", (String)"PlanOrderList_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errmsg.size()), MessageBoxOptions.YesNo, new ConfirmCallBackListener(DROPSTATUSSELECT, (IFormPlugin)this));
            return;
        }
        listSelectedRows.sort((o1, o2) -> {
            int row1 = o1.getRowKey();
            int row2 = o2.getRowKey();
            return row1 - row2;
        });
        String orderType = this.getOrderType(idBillnoMap, ids, errormsg, true);
        if (errormsg.size() > 0) {
            e.cancel = true;
            if (errormsg.size() == 1) {
                this.getView().showTipNotification((String)errormsg.get(0));
            } else if (errormsg.size() > 1) {
                this.showOperationResultMulti(errormsg.size(), errormsg, ResManager.loadKDString((String)"\u5206\u6279\u6295\u653e", (String)"PlanOrderList_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u6570\u636e\u91cf:%s,\u5f00\u59cb\u65f6\u95f4%s", idBillnoMap.size(), System.currentTimeMillis()));
        String jsonStr = SerializationUtils.toJsonString(idBillnoMap);
        logger.info(String.format("\u8ba1\u5212\u8ba2\u5355\u6295\u653e:\u7b2c\u4e00\u6b21\u5e8f\u5217\u5316\u65f6\u95f4%s", System.currentTimeMillis()));
        this.getPageCache().put("ordertype", orderType);
        this.getPageCache().put(DROP, jsonStr);
    }

    private String getOrderType(Map<Long, String> idBillnoMap, List<Long> ids, List<String> errors, boolean ischeck) {
        String msg = "";
        String orderType = "";
        String billno = "";
        QFilter qFilter = new QFilter("id", "in", ids);
        String selectField = "id,billno,ordertype,material,billstatus,org,proorpurorg,startdate,enddate,orderqty,dropqty,endproqty,unit,qty,dropstatus";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)this.getEntityNumber(), (String)selectField, (QFilter[])new QFilter[]{qFilter});
        if (datas == null || datas.size() <= 0) {
            return orderType;
        }
        orderType = ((DynamicObject)datas.get(0)).getString("ordertype");
        for (DynamicObject data : datas) {
            String type = data.getString("ordertype");
            if (StringUtils.equalsIgnoreCase((CharSequence)type, (CharSequence)orderType) || !ischeck) continue;
            errors.add(ResManager.loadKDString((String)"\u53ea\u80fd\u540c\u65f6\u6295\u653e\u8ba2\u5355\u7c7b\u578b\u76f8\u540c\u7684\u8ba1\u5212\u8ba2\u5355\u3002", (String)"PlanOrderList_8", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return orderType;
        }
        for (DynamicObject data : datas) {
            String billstatus = data.getString("billstatus");
            if (!BillStatus.C.name().equals(billstatus)) continue;
            billno = data.getString("billno");
            String dropstatus = data.getString("dropstatus");
            if ("B".equals(dropstatus)) {
                errors.add(String.format(ResManager.loadKDString((String)"%s\uff1a\u6295\u653e\u4e2d\u7684\u6570\u636e\u76ee\u524d\u6b63\u5728\u6295\u653e\uff0c\u8bf7\u7a0d\u540e\u518d\u6295\u653e\u3002", (String)"PlanOrderList_9", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), billno));
                continue;
            }
            idBillnoMap.put(data.getLong("id"), billno);
        }
        this.getPageCache().put("msg", msg);
        return orderType;
    }

    private void beforeSplit(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelectedRows = e.getListSelectedData();
        if (listSelectedRows == null || listSelectedRows.isEmpty()) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlanOrderList_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        if (listSelectedRows.size() > 1) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u5355\u6761\u6570\u636e\u62c6\u5355\u3002", (String)"PlanOrderList_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = listSelectedRows.get(0);
        DynamicObject planOrder = QueryServiceHelper.queryOne((String)this.getEntityNumber(), (String)"billstatus,proorpurorg", (QFilter[])new QFilter[]{new QFilter("id", "=", row.getPrimaryKeyValue())});
        if (planOrder == null) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PlanOrderList_32", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        String billStatus = planOrder.getString("billstatus");
        if (!StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)billStatus) && !StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)billStatus)) {
            e.cancel = true;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u6682\u5b58\u6216\u5df2\u63d0\u4ea4\u624d\u5141\u8bb8\u62c6\u5206\u3002", (String)"PlanOrderList_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(SPLIT, row.getPrimaryKeyValue().toString());
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object obj;
        super.closedCallBack(event);
        String key = event.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)DROP, (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)SPLIT, (CharSequence)key) || StringUtils.equalsIgnoreCase((CharSequence)"jindu", (CharSequence)key)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.getView().invokeOperation("refresh");
            BillList list = (BillList)this.getView().getControl("billlistap");
            list.putSelectedRows(selectedRows);
            list.activeView(this.getView().getPageId());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)BATCHUPDFIELD, (CharSequence)key)) {
            if (event.getReturnData() != null && "success".equals(event.getReturnData())) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u6210\u529f\u3002", (String)"PlanOrderList_33", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            this.getView().invokeOperation("refresh");
            BillList list = (BillList)this.getView().getControl("billlistap");
            list.putSelectedRows(selectedRows);
            list.activeView(this.getView().getPageId());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)COMPENSATE, (CharSequence)key) && (obj = event.getReturnData()) != null) {
            Map returnData = (Map)event.getReturnData();
            Iterator iter = returnData.entrySet().iterator();
            ArrayList<String> errorinfos = new ArrayList<String>();
            while (iter.hasNext()) {
                Map.Entry dealObj = iter.next();
                String planOrderId = (String)dealObj.getKey();
                String[] value = (String[])dealObj.getValue();
                String billtype = value[0];
                this.repairData(billtype, planOrderId, value[1], errorinfos);
            }
            if (errorinfos.size() == 1) {
                this.getView().showErrorNotification((String)errorinfos.get(0));
            } else if (errorinfos.size() > 1) {
                this.showOperationResultMulti(returnData.size(), errorinfos, ResManager.loadKDString((String)"\u5f02\u5e38\u6295\u653e\u6821\u6b63", (String)"PlanOrderList_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else if (errorinfos.size() == 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fee\u590d\u6210\u529f\u3002", (String)"PlanOrderList_14", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void showOperationResultMulti(int count, List<String> errorinfos, String operateName) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("bos_operationresult");
        parameters.setShowTitle(false);
        parameters.setCustomParam("operateName", (Object)operateName);
        HashMap<Integer, Integer> pkNumbers = new HashMap<Integer, Integer>();
        pkNumbers.put(0, 0);
        parameters.setCustomParam("pkNumbers", pkNumbers);
        int successCount = count - errorinfos.size();
        String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c%2$s\u6210\u529f%3$s\u5f20\uff0c\u5931\u8d25%4$s\u5f20\u3002", (String)"PlanOrderList_26", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), count, StringUtils.isBlank((CharSequence)operateName) ? "" : operateName, successCount, errorinfos.size());
        parameters.setCustomParam("title", (Object)title);
        ArrayList<String> list = new ArrayList<String>();
        int len = errorinfos.size();
        for (int i = 0; i < 5 && i < len; ++i) {
            list.add(errorinfos.get(i));
        }
        parameters.setCustomParam("hasMore", (Object)(errorinfos.size() > 5 ? 1 : 0));
        parameters.setCustomParam("errorMsg", list);
        this.getView().showForm(parameters);
    }

    private void repairData(String billtype, String leftkey, String rightkey, List<String> errorinfos) {
        DynamicObject obj = null;
        QFilter filter = null;
        try {
            if (StringUtils.isNotBlank((CharSequence)rightkey)) {
                filter = new QFilter("id", "=", (Object)Long.valueOf(rightkey));
                obj = BusinessDataServiceHelper.loadSingle((Object)rightkey, (String)billtype);
            }
            filter = new QFilter("id", "=", (Object)Long.valueOf(leftkey));
            DynamicObject data = BusinessDataServiceHelper.loadSingle((String)this.getEntityNumber(), (String)"qty,dropqty,billstatus,dropstatus,schedule,orderqty", (QFilter[])new QFilter[]{filter});
            this.checkDataQtyAndAepair(data, obj, errorinfos, leftkey);
        }
        catch (Exception ex) {
            logger.error("\u5f02\u5e38\u6295\u653e\u6821\u6b63\u5931\u8d25", (Throwable)ex);
            this.getView().showErrMessage(ResManager.loadKDString((String)"\u5f02\u5e38\u6295\u653e\u6821\u6b63\u5931\u8d25\u3002", (String)"PlanOrderList_16", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ex.getMessage());
        }
    }

    private void checkDataQtyAndAepair(DynamicObject data, DynamicObject obj, List<String> errorinfos, String leftkey) {
        StringBuilder sBuilder = new StringBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(this.getEntityNumber(), this.getEntityNumber());
        Long myMainTableId = mainTableDefine.getTableId();
        BigDecimal orderQty = data.getBigDecimal("orderqty");
        BigDecimal dropQty = data.getBigDecimal("dropqty");
        BigDecimal qtySubmit = new BigDecimal(0);
        BigDecimal qtyAudit = new BigDecimal(0);
        String orderbillstatus = null;
        sBuilder.append("SELECT FTBillId,FTTableId ");
        sBuilder.append(" FROM T_BOTP_BillTracker ");
        sBuilder.append(" WHERE FSTableId = ? ");
        params.add(new SqlParameter(":FSTableId", -5, (Object)myMainTableId));
        sBuilder.append(" AND FSBillId = ? ");
        params.add(new SqlParameter(":FSBillId", -5, data.getPkValue()));
        ResultSetHandler<Map<Long, List<Long>>> action = new ResultSetHandler<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> handle(ResultSet rs) throws Exception {
                HashMap<Long, List<Long>> idsMap = new HashMap<Long, List<Long>>(rs.getRow());
                while (rs.next()) {
                    Long tBillId = rs.getLong(1);
                    Long tTableId = rs.getLong(2);
                    ArrayList<Long> tBillIds = (ArrayList<Long>)idsMap.get(tTableId);
                    if (tBillIds == null) {
                        tBillIds = new ArrayList<Long>();
                    }
                    tBillIds.add(tBillId);
                    idsMap.put(tTableId, tBillIds);
                }
                return idsMap;
            }
        };
        Map orderIdsMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sBuilder.toString(), (Object[])params.toArray(new SqlParameter[params.size()]), (ResultSetHandler)action);
        if (orderIdsMap != null && orderIdsMap.size() > 0) {
            DynamicObject[] orders;
            String billtype = null;
            List ids = new ArrayList(orderIdsMap.size());
            for (Map.Entry entry : orderIdsMap.entrySet()) {
                billtype = reader.loadTableDefine((Long)entry.getKey()).getEntityNumber();
                ids = (List)entry.getValue();
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType(billtype);
            for (DynamicObject order : orders = BusinessDataServiceHelper.load((Object[])ids.toArray(new Long[0]), (DynamicObjectType)dataEntityType)) {
                if (obj != null && order.getPkValue().equals(obj.getPkValue())) continue;
                qtySubmit = this.getDownOrderQty(order, billtype, qtySubmit, BillStatus.B.name(), data.getPkValue());
            }
            if (obj != null) {
                boolean issuccess;
                OperateOption option = OperateOption.create();
                option.setVariableValue("ignorewarn", String.valueOf(true));
                option.setVariableValue("ignoreinteraction", String.valueOf(true));
                option.setVariableValue("strictvalidation", String.valueOf(true));
                OperationResult result = null;
                String billno = obj.getString("billno");
                String entityName = obj.getDynamicObjectType().getDisplayName().getLocaleValue();
                orderbillstatus = obj.getString("billstatus");
                if (BillStatus.A.name().equals(orderbillstatus) && !(issuccess = this.isFailInfo(result = OperationServiceHelper.executeOperate((String)"delete", (String)billtype, (DynamicObject[])new DynamicObject[]{obj}, (OperateOption)option), ResManager.loadKDString((String)"\u5220\u9664", (String)"PlanOrderList_18", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), errorinfos, billno, entityName))) {
                    return;
                }
            }
        }
        String writeBackStatus = BillStatus.B.name();
        if (qtySubmit.compareTo(dropQty) == 0) {
            writeBackStatus = BillStatus.B.name();
        } else if (qtyAudit.compareTo(dropQty) == 0) {
            writeBackStatus = BillStatus.C.name();
        } else if (obj != null && dropQty.compareTo(this.getDownOrderQty(obj, obj.getDynamicObjectType().getName(), qtySubmit, BillStatus.B.name(), data.getPkValue())) >= 0) {
            writeBackStatus = BillStatus.B.name();
        } else if (obj != null && dropQty.compareTo(this.getDownOrderQty(obj, obj.getDynamicObjectType().getName(), qtyAudit, BillStatus.C.name(), data.getPkValue())) >= 0) {
            writeBackStatus = BillStatus.C.name();
        }
        BigDecimal qty = new BigDecimal(0);
        if (BillStatus.B.name().equals(writeBackStatus)) {
            if (obj != null && StringUtils.isNotBlank(orderbillstatus) && !BillStatus.A.name().equals(orderbillstatus)) {
                qtySubmit = this.getDownOrderQty(obj, obj.getDynamicObjectType().getName(), qtySubmit, BillStatus.B.name(), data.getPkValue());
            }
            qty = qtySubmit;
        } else if (BillStatus.C.name().equals(writeBackStatus)) {
            if (obj != null && StringUtils.isNotBlank(orderbillstatus) && BillStatus.C.name().equals(orderbillstatus)) {
                qtyAudit = this.getDownOrderQty(obj, obj.getDynamicObjectType().getName(), qtySubmit, BillStatus.C.name(), data.getPkValue());
            }
            qty = qtyAudit;
        }
        String dropstatus = PlanOrderConst.DropStatusEnum.A.name();
        String billStatus = BillStatus.C.name();
        if (qty.compareTo(BigDecimal.ZERO) > 0 && orderQty.compareTo(qty) > 0) {
            dropstatus = PlanOrderConst.DropStatusEnum.C.name();
        } else if (orderQty.compareTo(qty) < 0) {
            dropstatus = PlanOrderConst.DropStatusEnum.B.name();
        } else if (orderQty.compareTo(qty) == 0 && orderQty.compareTo(dropQty) <= 0) {
            billStatus = "D";
            dropstatus = PlanOrderConst.DropStatusEnum.D.name();
        }
        this.updatePlanOrderData(leftkey, BigDecimal.ZERO, qty, dropstatus, billStatus);
    }

    public BigDecimal getDownOrderQty(DynamicObject order, String name, BigDecimal qty, String billStatus, Object srcId) {
        block3: {
            block2: {
                if (!"pm_purapplybill".equals(name)) break block2;
                DynamicObjectCollection collections = order.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : collections) {
                    String orderStatus = order.getString("billstatus");
                    Long srcBillId = entry.getLong("srcbillid");
                    if (!srcId.toString().equals(srcBillId.toString()) || (BillStatus.B.name().equals(orderStatus) || BillStatus.A.name().equals(orderStatus)) && BillStatus.C.name().equals(billStatus) || BillStatus.A.name().equals(orderStatus) && BillStatus.B.name().equals(billStatus)) continue;
                    qty = qty.add(entry.getBigDecimal("applyqty"));
                }
                break block3;
            }
            if (!"pom_mftorder".equals(name) && !"om_mftorder".equals(name)) break block3;
            DynamicObjectCollection collections = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject entry : collections) {
                String orderStatus = order.getString("billstatus");
                String srcBillId = entry.getString("sourceentryseq");
                if (!srcId.toString().equals(srcBillId) || (BillStatus.B.name().equals(orderStatus) || BillStatus.A.name().equals(orderStatus)) && BillStatus.C.name().equals(billStatus) || BillStatus.A.name().equals(orderStatus) && BillStatus.B.name().equals(billStatus)) continue;
                qty = qty.add(entry.getBigDecimal("qty"));
            }
        }
        return qty;
    }

    private void updatePlanOrderData(String leftkey, BigDecimal qty, BigDecimal dropqty, String dropstatus, String billstatus) {
        DynamicObject[] datas;
        QFilter filter = new QFilter("id", "=", (Object)Long.valueOf(leftkey));
        for (DynamicObject data : datas = BusinessDataServiceHelper.load((String)this.getEntityNumber(), (String)"qty,dropqty,billstatus,dropstatus,schedule,surplusdropqty,orderqty", (QFilter[])new QFilter[]{filter})) {
            data.set("qty", (Object)qty);
            data.set("dropqty", (Object)dropqty);
            data.set("surplusdropqty", (Object)data.getBigDecimal("orderqty").subtract(dropqty));
            data.set("dropstatus", (Object)dropstatus);
            data.set("billstatus", (Object)billstatus);
            data.set("schedule", (Object)"");
        }
        SaveServiceHelper.save((DynamicObject[])datas);
        String type = PlanOrderCacheMrg.getType4PlanOrderDropStatus();
        PlanOrderCacheMrg.clearCache((String)type, (String)leftkey);
    }

    public boolean isFailInfo(OperationResult result, String action, List<String> errorinfos, String billno, String entityName) {
        if (!result.isSuccess()) {
            StringBuilder error = new StringBuilder();
            error.append(ResManager.loadKDString((String)"\u4e0b\u6e38", (String)"PlanOrderList_19", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])).append(entityName).append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a\uff1a", (String)"PlanOrderList_20", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0])).append(billno).append(action).append(ResManager.loadKDString((String)"\u5931\u8d25\uff1a", (String)"PlanOrderList_21", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                error.append(info.getMessage());
            }
            error.append(ResManager.loadKDString((String)"\u4fee\u590d\u5931\u8d25,\u8bf7\u81ea\u884c\u5220\u9664\u4e0b\u6e38\u5355\u636e\u3002", (String)"PlanOrderList_22", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            errorinfos.add(error.toString());
        }
        return result.isSuccess();
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String orderType = PlanOrderHelper.getMenuParams((IFormView)this.getView(), (String)"orderType");
        if (!StringUtils.isEmpty((CharSequence)orderType)) {
            e.addCustomQFilter(new QFilter("ordertype", "=", (Object)orderType));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        super.beforeShowBill(e);
        String orderType = PlanOrderHelper.getMenuParams((IFormView)this.getView(), (String)"orderType");
        e.getParameter().getCustomParams().put("orderType", orderType);
    }
}

