/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.planexecute;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.PlanOrderHelper;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;

public class PlanOrderSplitPlugin
extends AbstractFormPlugin {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String MPDM_MATERIAL_PLAN = "mpdm_materialplan";

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String jsonStr = (String)formShowParameter.getCustomParam("split");
        String entitynumber = this.getEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)jsonStr)) {
            String selectField = "id,billno,ordertype,orderqty,unit,startdate,enddate,orderdate,availabledate";
            DynamicObject planOrder = QueryServiceHelper.queryOne((String)entitynumber, (String)selectField, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(jsonStr))});
            if (planOrder == null) {
                return;
            }
            IDataModel dm = this.getModel();
            dm.setValue("oldbillid", planOrder.get("id"));
            dm.setValue("oldbillno", planOrder.get("billno"));
            dm.setValue("oldorderqty", planOrder.get("orderqty"));
            dm.setValue("oldordertype", planOrder.get("ordertype"));
            dm.setValue("unit", planOrder.get("unit"));
            dm.setValue("oldstartdate", planOrder.get("startdate"));
            dm.setValue("oldenddate", planOrder.get("enddate"));
            dm.setValue("orderdate", planOrder.get("orderdate"));
            dm.setValue("availabledate", planOrder.get("availabledate"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("sure".equals(operateKey)) {
            operate.getOption().setVariableValue("entitynumber", this.getEntityNumber());
        }
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isBlank((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) continue;
            int rowIndex = changeData.getRowIndex();
            if (StringUtils.equalsIgnoreCase((CharSequence)"orderqty", (CharSequence)propertyName)) {
                this.orderqtyChange(oldObject, newObject);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)"startdate", (CharSequence)propertyName)) continue;
            this.startdateChange(oldObject, newObject, this.getModel().getEntryRowEntity(ENTRY_ENTITY, rowIndex), rowIndex);
        }
    }

    private void orderqtyChange(Object oldObject, Object newObject) {
        BigDecimal oldQty = oldObject instanceof BigDecimal ? (BigDecimal)oldObject : BigDecimal.ZERO;
        BigDecimal newQty = newObject instanceof BigDecimal ? (BigDecimal)newObject : BigDecimal.ZERO;
        BigDecimal differQty = newQty.subtract(oldQty);
        BigDecimal sumQty = (BigDecimal)this.getModel().getValue("sumqty");
        sumQty = sumQty.add(differQty);
        this.getModel().setValue("sumqty", (Object)sumQty);
    }

    private void startdateChange(Object oldObject, Object newObject, DynamicObject EntryRowEntity, int row) {
        if (!(newObject instanceof Date) || !(oldObject instanceof Date)) {
            return;
        }
        String oldbillno = (String)this.getModel().getValue("oldbillno");
        String selectField = "id,billno,material,proorpurorg";
        String entitynumber = this.getEntityNumber();
        DynamicObject planOrder = QueryServiceHelper.queryOne((String)entitynumber, (String)selectField, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oldbillno)});
        if (planOrder == null) {
            return;
        }
        Long proorpurorg = planOrder.getLong("proorpurorg");
        DynamicObject entryMaterialPlan = PlanOrderHelper.getMaterialInfo((Long)planOrder.getLong("material"), (Long)proorpurorg, (String)MPDM_MATERIAL_PLAN, (String)"createorg,leadtimetype,fixedleadtime,changeleadtime,inspectionleadtime,preprocessingtime", (IPageCache)null);
        if (entryMaterialPlan != null) {
            String leadtimetype = entryMaterialPlan.getString("leadtimetype");
            Integer fixedleadtime = entryMaterialPlan.getInt("fixedleadtime");
            Integer changeleadtime = entryMaterialPlan.getInt("changeleadtime");
            Integer changebatchqty = entryMaterialPlan.getInt("inspectionleadtime");
            Integer preprocessingtime = entryMaterialPlan.getInt("preprocessingtime");
            Integer leadtime = 0;
            if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)leadtimetype)) {
                leadtime = leadtime + fixedleadtime + changebatchqty + preprocessingtime;
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"B", (CharSequence)leadtimetype)) {
                leadtime = leadtime + changeleadtime + changebatchqty + preprocessingtime;
            } else {
                return;
            }
            Date enddate = (Date)newObject;
            Date workDate = PlanOrderHelper.getRecentWorkDate((Date)enddate, (Long)proorpurorg);
            if (workDate == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u7ed3\u675f\u65e5\u671f\u5e94\u5728\u9ed8\u8ba4\u8ba1\u5212\u65e5\u5386\u8303\u56f4\u5185\u3002", (String)"PlanOrderSplitPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), new Object[0]));
                ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)EntryRowEntity, (String)"startdate", (Object)oldObject, (int)row);
                return;
            }
            Calendar cd = Calendar.getInstance();
            cd.setTime(enddate);
            cd.add(7, leadtime);
            enddate = cd.getTime();
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)EntryRowEntity, (String)"enddate", (Object)PlanOrderHelper.getToWorkDate((int)leadtime, (Date)workDate, (Long)proorpurorg), (int)row);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)"split", (CharSequence)key)) {
            this.splitPreview();
            Container t = (Container)this.getControl("flexpanelap1");
            t.setCollapse(false);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"sure", (CharSequence)key) && result != null && result.isSuccess()) {
            this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u62c6\u5206\u6210\u529f", (String)"PlanOrderSplitPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().close();
        }
    }

    private void splitPreview() {
        Integer qty = (Integer)this.getModel().getValue("qty");
        if (qty <= 0) {
            qty = 1;
            this.getModel().setValue("qty", (Object)qty);
        }
        String entityNumber = this.getEntityNumber();
        boolean isavgsplit = (Boolean)this.getModel().getValue("isavgsplit");
        BigDecimal oldorderqty = (BigDecimal)this.getModel().getValue("oldorderqty");
        BigDecimal ceilQty = BigDecimal.ZERO;
        BigDecimal floorQty = BigDecimal.ZERO;
        int precision = 2;
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit");
        if (unit != null) {
            int n = precision = unit.get("precision") == null ? 2 : unit.getInt("precision");
        }
        if (isavgsplit) {
            ceilQty = oldorderqty.divide(new BigDecimal(qty.toString()), precision, RoundingMode.CEILING);
            floorQty = oldorderqty.divide(new BigDecimal(qty.toString()), precision, RoundingMode.FLOOR);
            this.getModel().setValue("sumqty", (Object)oldorderqty);
        } else {
            this.getModel().setValue("sumqty", (Object)BigDecimal.ZERO);
        }
        String oldbillno = (String)this.getModel().getValue("oldbillno");
        Date startDate = (Date)this.getModel().getValue("oldstartdate");
        String oldordertype = (String)this.getModel().getValue("oldordertype");
        Date enddate = (Date)this.getModel().getValue("oldenddate");
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.deleteEntryData(ENTRY_ENTITY);
        TableValueSetter vsdate = new TableValueSetter(new String[0]);
        vsdate.addField("seq", new Object[0]);
        vsdate.addField("billno", new Object[0]);
        vsdate.addField("ordertype", new Object[0]);
        vsdate.addField("orderqty", new Object[0]);
        vsdate.addField("startdate", new Object[0]);
        vsdate.addField("enddate", new Object[0]);
        vsdate.addField("id", new Object[0]);
        DynamicObject planorder = ORM.create().newDynamicObject(entityNumber);
        String selectField = "id,billno,material,proorpurorg";
        DynamicObject planOrder = QueryServiceHelper.queryOne((String)entityNumber, (String)selectField, (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)oldbillno)});
        if (planOrder == null) {
            return;
        }
        boolean flag = false;
        long[] ids = DB.genLongIds((String)planorder.getDataEntityType().getAlias(), (int)qty);
        String[] billnos = CodeRuleServiceHelper.getBatchNumber((String)entityNumber, (DynamicObject)planorder, (String)planOrder.getString("proorpurorg"), (int)qty);
        for (int i = 0; i < qty; ++i) {
            String bill = null;
            if (billnos.length > i) {
                bill = billnos[i];
            }
            if (bill == null || bill.length() == 0) {
                bill = Long.valueOf(ids[i]).toString();
            }
            if (isavgsplit) {
                BigDecimal bigDecimal;
                if (flag) {
                    vsdate.addRow(new Object[]{i + 1, bill, oldordertype, floorQty, startDate, enddate, ids[i]});
                    continue;
                }
                BigDecimal bigDecimal1 = oldorderqty.subtract(ceilQty);
                if (bigDecimal1.compareTo(bigDecimal = floorQty.multiply(new BigDecimal(qty - i - 1 + ""))) >= 0) {
                    vsdate.addRow(new Object[]{i + 1, bill, oldordertype, ceilQty, startDate, enddate, ids[i]});
                    oldorderqty = oldorderqty.subtract(ceilQty);
                    continue;
                }
                vsdate.addRow(new Object[]{i + 1, bill, oldordertype, floorQty, startDate, enddate, ids[i]});
                flag = true;
                continue;
            }
            vsdate.addRow(new Object[]{i + 1, bill, oldordertype, ceilQty, startDate, enddate, ids[i]});
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vsdate);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
    }

    private String getEntityNumber() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String entitynumber = (String)formShowParameter.getCustomParam("entitynumber");
        if (StringUtils.isBlank((CharSequence)entitynumber)) {
            entitynumber = "mrp_planorder";
        }
        return entitynumber;
    }
}

