/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.prioritymodel;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueTextItem;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.F7SelectedList;
import kd.bos.list.events.F7SelectedListRemoveEvent;
import kd.bos.list.events.F7SelectedListRemoveListener;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class FieldDimensionSelectPlugin
extends AbstractFormPlugin
implements F7SelectedListRemoveListener,
RowClickEventListener,
SearchEnterListener {
    public static final String BTNOK = "btnok";
    public static final String F7SELECTEDLISTAP = "f7selectedlistap";
    public static final String ENTRYENTITY = "entryentity";
    public static final String SEARCHAP = "searchap";
    private static DynamicObjectCollection entrys;

    public void registerListener(EventObject e) {
        Search serach;
        EntryGrid entryentity;
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl(F7SELECTEDLISTAP);
        if (f7SelectedList != null) {
            f7SelectedList.addF7SelectedListRemoveListener((F7SelectedListRemoveListener)this);
            f7SelectedList.addF7SelectedListRemoveAllListener((F7SelectedListRemoveListener)this);
        }
        if ((entryentity = (EntryGrid)this.getControl(ENTRYENTITY)) != null) {
            entryentity.addRowClickListener((RowClickEventListener)this);
        }
        if ((serach = (Search)this.getControl(SEARCHAP)) != null) {
            serach.addEnterListener((SearchEnterListener)this);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            String values = this.getPageCache().get("valueTextItems");
            if (StringUtils.isNotEmpty((CharSequence)values)) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                for (ValueTextItem valueTextItem : valueTextItems) {
                    params.put(valueTextItem.getValue(), valueTextItem.getText());
                }
            }
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    public void afterBindData(EventObject e) {
        String fieldKeyValues;
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object entityId = parameterParams.get("entityId");
        if (entityId != null) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache(entityId, (String)"bos_entityobject");
            this.initEntryentity(dynamicObject);
        }
        if (StringUtils.isNotBlank((CharSequence)(fieldKeyValues = (String)parameterParams.get("fieldKeyValues")))) {
            this.selectEntryentityRows(fieldKeyValues);
        }
    }

    public void search(SearchEnterEvent searchEnterEvent) {
        String searchText = searchEnterEvent.getText();
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            HashSet<String> set = new HashSet<String>(16);
            for (DynamicObject dy : entrys) {
                String fieldname = dy.getString("fieldname");
                String fieldid = dy.getString("fieldid");
                Pattern pattern = Pattern.compile(searchText);
                Matcher matcherFieldname = pattern.matcher(fieldname);
                Matcher matcherFieldid = pattern.matcher(fieldid);
                if (!matcherFieldname.find() && !matcherFieldid.find()) continue;
                set.add(fieldid);
            }
            this.buildEntryentity(entrys, set);
        } else {
            this.buildEntryentity(entrys, null);
        }
    }

    private void buildEntryentity(DynamicObjectCollection entrys, Set<String> set) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        if (entrys != null && !entrys.isEmpty()) {
            EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
            AbstractFormDataModel model = (AbstractFormDataModel)entryGrid.getModel();
            model.beginInit();
            TableValueSetter vs = new TableValueSetter(new String[]{"fieldid", "fieldname", "fieldtype", "billnumber", "billname"});
            for (int i = 0; i < entrys.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entrys.get(i);
                String fieldid = dynamicObject.getString("fieldid");
                if (set != null && !set.contains(fieldid)) continue;
                String fieldname = dynamicObject.getString("fieldname");
                String fieldtype = dynamicObject.getString("fieldtype");
                String billnumber = dynamicObject.getString("billnumber");
                String billname = dynamicObject.getString("billname");
                vs.addRow(new Object[]{fieldid, fieldname, fieldtype, billnumber, billname});
            }
            model.batchCreateNewEntryRow(ENTRYENTITY, vs);
            model.endInit();
            this.getView().updateView(ENTRYENTITY);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        this.initF7selectedlistap();
    }

    private void initEntryentity(DynamicObject entity) {
        this.getModel().deleteEntryData(ENTRYENTITY);
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)((String)entity.getPkValue()));
        if (dataEntityType != null) {
            Map allFields = dataEntityType.getAllEntities();
            HashSet<String> fieldSet = new HashSet<String>(allFields.size());
            for (Map.Entry entry : allFields.entrySet()) {
                EntityType mainEntity = (EntityType)entry.getValue();
                if (!(mainEntity instanceof MainEntityType)) continue;
                Collection propertyColl = ((MainEntityType)mainEntity).getFields().values();
                for (IDataEntityProperty property : propertyColl) {
                    if (property instanceof BasedataProp || !StringUtils.isNotBlank((CharSequence)property.getAlias()) || "number".equals(property.getName()) || "name".equals(property.getName())) continue;
                    fieldSet.add(property.getName());
                }
            }
            if (fieldSet.size() > 0) {
                this.getModel().batchCreateNewEntryRow(ENTRYENTITY, fieldSet.size());
                int rowIndex = 0;
                for (String field : fieldSet) {
                    this.buildRow(dataEntityType, rowIndex++, field, entity);
                }
            }
            entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            this.getView().updateView(ENTRYENTITY);
        }
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String field, DynamicObject entity) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(field);
        this.getModel().setValue("fieldid", (Object)field, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue("fieldid", (Object)(entry.getName() + '.' + field), rowIndex);
        } else {
            this.getModel().setValue("fieldid", (Object)field, rowIndex);
        }
        LocaleString displayName = findProperty.getDisplayName();
        this.getModel().setValue("fieldname", (Object)displayName, rowIndex);
        String dataType = BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)findProperty);
        this.getModel().setValue("fieldtype", (Object)dataType, rowIndex);
        this.getModel().setValue("billnumber", (Object)entity.getString("number"), rowIndex);
        this.getModel().setValue("billname", (Object)entity.getString("name"), rowIndex);
    }

    private void selectEntryentityRows(String fieldKeyValues) {
        String[] values = fieldKeyValues.split(",");
        List<String> list = Arrays.asList(values);
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Integer> selectRows = new ArrayList<Integer>();
        for (DynamicObject entry : entrys) {
            if (!list.contains(entry.getString("fieldid"))) continue;
            selectRows.add(entry.getInt("seq") - 1);
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        entryGrid.selectRows(selectRows.stream().mapToInt(Integer::valueOf).toArray(), 0);
        this.initF7selectedlistap();
    }

    public List<ValueTextItem> getCurrentValueItems() {
        String values = this.getPageCache().get("valueTextItems");
        List<Object> valueTextItems = new ArrayList<ValueTextItem>(16);
        if (StringUtils.isNotEmpty((CharSequence)values)) {
            valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
        }
        return valueTextItems;
    }

    private void initF7selectedlistap() {
        List<ValueTextItem> valueTextItems = this.getCurrentValueItems();
        DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        F7SelectedList f7SelectedList = (F7SelectedList)this.getView().getControl(F7SELECTEDLISTAP);
        int[] rows = entryGrid.getSelectRows();
        for (int index = 0; index < rows.length; ++index) {
            int i = rows[index];
            String fileldis = ((DynamicObject)entrys.get(i)).getString("fieldid");
            boolean isMatch = valueTextItems.stream().anyMatch(t -> StringUtils.equals((CharSequence)t.getValue(), (CharSequence)fileldis));
            if (isMatch) continue;
            ValueTextItem item = new ValueTextItem(((DynamicObject)entrys.get(i)).getString("fieldid"), ((DynamicObject)entrys.get(i)).getString("fieldname"));
            valueTextItems.add(item);
        }
        f7SelectedList.addItems(valueTextItems);
        this.getPageCache().put("valueTextItems", JSON.toJSONString(valueTextItems));
    }

    public void RemoveClick(F7SelectedListRemoveEvent f7SelectedListRemoveEvent) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
        if (f7SelectedListRemoveEvent.getParam() == null) {
            entryGrid.clearEntryState();
            this.getPageCache().remove("valueTextItems");
        } else {
            String values;
            String param = (String)f7SelectedListRemoveEvent.getParam();
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entry : entrys) {
                if (!StringUtils.equals((CharSequence)entry.getString("fieldid"), (CharSequence)param)) continue;
                List rows = Arrays.stream(entryGrid.getSelectRows()).boxed().collect(Collectors.toList());
                rows = rows.stream().filter(f -> entry.getInt("seq") - 1 != f).collect(Collectors.toList());
                entryGrid.selectRows(rows.stream().mapToInt(Integer::valueOf).toArray(), 0);
                break;
            }
            if (StringUtils.isNotEmpty((CharSequence)(values = this.getPageCache().get("valueTextItems")))) {
                List valueTextItems = JSON.parseArray((String)values, ValueTextItem.class);
                valueTextItems.removeIf(f -> StringUtils.equals((CharSequence)param, (CharSequence)f.getValue()));
                this.getPageCache().put("valueTextItems", JSON.toJSONString((Object)valueTextItems));
            }
        }
    }
}

