/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.prioritymodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.common.colsAssist.DemandSelectStrategy;
import kd.mpscmm.common.colsAssist.IColsSelectStrategy;
import kd.mpscmm.common.colsAssist.MetaHelper;
import kd.mpscmm.common.enums.ElementTypeEnum;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;
import kd.mpscmm.msplan.mrp.formplugin.ResourceRigisterConfigEdit;

public class MsplanPriorityModelEditPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String FORMID_SELECTFIELD = "msplan_billfieldselect";
    public static final String CUSTPARAM_TREENODES = "treenodes";
    public static final String CALLBACK_TREENODES = "callback_treenodes";
    public static final String CALLBACK_CONDITION = "callback_condition";
    public static final String FIELDTYPE = "fieldtype";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldflag", "conditiondesc"});
        BasedataEdit demandBill = (BasedataEdit)this.getControl("demandbill");
        demandBill.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String name = control.getKey();
        int currentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
        if ("fieldflag".equals(name) && this.getModel().getValue("demandbill") != null) {
            DynamicObject demandBill = (DynamicObject)this.getModel().getValue("demandbill");
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)demandBill.getString("id"));
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(mainEntityType);
            parameter.setIncludePKField(true);
            parameter.setOnlyPhysicsField(true);
            String elementType = (String)this.getModel().getValue("elementtype", currentIndex);
            if ("0".equals(elementType)) {
                this.showFieldForm(parameter, (IDataEntityProperty)new IntegerProp());
            } else if ("1".equals(elementType)) {
                this.showFieldForm(parameter, (IDataEntityProperty)new DateProp());
            } else if ("2".equals(elementType) && this.getModel().getValue("elementobject", currentIndex) != null) {
                DynamicObject elementObj = (DynamicObject)this.getModel().getValue("elementobject", currentIndex);
                BasedataProp basedataProp = new BasedataProp();
                basedataProp.setBaseEntityId(elementObj.getString("id"));
                this.showFieldForm(parameter, (IDataEntityProperty)basedataProp);
            }
        } else if ("fieldflag".equals(name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9700\u6c42\u5355\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u9700\u6c42\u5355\u636e\u3002", (String)"MsplanPriorityModelEditPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        } else if ("conditiondesc".equals(name) && this.getModel().getValue("demandbill") != null) {
            DynamicObject entity = (DynamicObject)this.getModel().getValue("demandbill");
            MainEntityType mainType = ControlUtil.getMainEntityType((DynamicObject)entity);
            String conditionJson = "";
            if (this.getModel().getValue("pentryfruncondition_tag", currentIndex) != null) {
                conditionJson = (String)this.getModel().getValue("pentryfruncondition_tag", currentIndex);
            }
            if (mainType != null) {
                TreeNode billTreeNode = this.getRequireBillCols("", mainType);
                String fldNodes = SerializationUtils.toJsonString((Object)billTreeNode);
                this.showConditionForm(conditionJson, mainType.getName(), false, fldNodes, CALLBACK_CONDITION);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("unsubmit".equals(operateKey)) {
            Object prioritytype = this.getModel().getValue("prioritytype");
            if (prioritytype != null) {
                HashMap<Long, DynamicObject> exsitEntry = new HashMap<Long, DynamicObject>(16);
                ArrayList<DynamicObject> removeIds = new ArrayList<DynamicObject>(16);
                DynamicObject mrp_priority_type = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)prioritytype).getPkValue(), (String)"mrp_priority_type");
                DynamicObjectCollection entryentity = mrp_priority_type.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    exsitEntry.put(dynamicObject.getLong("id"), dynamicObject);
                }
                DynamicObjectCollection entryentity1 = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject dynamicObject : entryentity1) {
                    Long elementid = dynamicObject.getLong("elementid");
                    if (exsitEntry.containsKey(elementid)) {
                        DynamicObject dynamicObject1 = (DynamicObject)exsitEntry.get(elementid);
                        String elementtype = dynamicObject.getString("elementtype");
                        String elementtype1 = dynamicObject1.getString("elementtype");
                        dynamicObject.set("elementname", dynamicObject1.get("elementname"));
                        dynamicObject.set("elementtype", dynamicObject1.get("elementtype"));
                        dynamicObject.set("elementobject", dynamicObject1.get("elementobject"));
                        dynamicObject.set("sort", dynamicObject1.get("sort"));
                        if (!elementtype.equals(elementtype1)) {
                            dynamicObject.set("fieldflag", (Object)"");
                            dynamicObject.set("fieldname", (Object)"");
                        }
                    } else {
                        removeIds.add(dynamicObject);
                    }
                    exsitEntry.remove(elementid);
                }
                for (DynamicObject dynamicObject : removeIds) {
                    entryentity1.remove((Object)dynamicObject);
                }
                for (Map.Entry entry : exsitEntry.entrySet()) {
                    DynamicObject dynamicObject1 = (DynamicObject)entry.getValue();
                    DynamicObject dynamicObject = entryentity1.addNew();
                    dynamicObject.set("elementname", dynamicObject1.get("elementname"));
                    dynamicObject.set("elementtype", dynamicObject1.get("elementtype"));
                    dynamicObject.set("elementobject", dynamicObject1.get("elementobject"));
                    dynamicObject.set("elementid", dynamicObject1.get("id"));
                    dynamicObject.set("sort", dynamicObject1.get("sort"));
                }
            }
            this.getView().updateView();
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, boolean onlyHeadFields, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.getCustomParams().put("onlyheadfield", String.valueOf(onlyHeadFields));
        showParameter.getCustomParams().put(CUSTPARAM_TREENODES, fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode getRequireBillCols(String elementType, MainEntityType mainEntityType) {
        DemandSelectStrategy strategy = new DemandSelectStrategy();
        if (StringUtils.isBlank((CharSequence)elementType)) {
            return new MetaHelper((IColsSelectStrategy)strategy, mainEntityType).buildTree("");
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)ElementTypeEnum.QTY.getValue(), (CharSequence)elementType)) {
            strategy = new QtyColStrategy();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ElementTypeEnum.DATE.getValue(), (CharSequence)elementType)) {
            strategy = new DateColStrategy();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)ElementTypeEnum.ENTITY.getValue(), (CharSequence)elementType)) {
            strategy = new EntityColStrategy();
        }
        return new MetaHelper((IColsSelectStrategy)strategy, mainEntityType).buildTree("");
    }

    private void showFieldForm(BillTreeBuildParameter parameter, IDataEntityProperty property) {
        TreeNode srcBillNode = this.buildBillTreeNodes(parameter, property);
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        this.showBillFieldForm(nodesJson, CALLBACK_TREENODES);
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        showParameter.getCustomParams().put(CUSTPARAM_TREENODES, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter, IDataEntityProperty property) {
        MainEntityType mainType = parameter.getMainType();
        parameter.setMatchedProperty(property);
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fldNodes = BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fieldType = "";
        if (this.getModel().getValue(FIELDTYPE) != null) {
            fieldType = (String)this.getModel().getValue(FIELDTYPE);
        }
        if (StringUtils.isBlank((CharSequence)fieldType)) {
            this.setAppIdParam(this.getView().getFormShowParameter().getAppId());
        }
    }

    public void afterCopyData(EventObject e) {
        this.setAppIdParam(this.getView().getFormShowParameter().getAppId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        if ("prioritytype".equals(propertyName) && this.getModel().getValue("prioritytype") != null) {
            this.getModel().deleteEntryData("entryentity");
            DynamicObject priorityType = (DynamicObject)this.getModel().getValue("prioritytype");
            DynamicObjectCollection dynamicObjectCollection = priorityType.getDynamicObjectCollection("entryentity");
            HashSet<String> elementIds = new HashSet<String>(16);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                DynamicObject elementObject = dynamicObject.getDynamicObject("elementobject");
                if (elementObject == null) continue;
                elementIds.add(elementObject.getString("id"));
            }
            HashMap<String, Long> defineMap = new HashMap<String, Long>(16);
            QFilter typeFilter = new QFilter("prioritytype", "=", (Object)priorityType.getLong("id"));
            QFilter entityFilter = new QFilter("elementobject", "in", elementIds);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MsplanPriorityModelEditPlugin.class.getName(), (String)"msplan_priority_define", (String)"id, elementobject", (QFilter[])new QFilter[]{typeFilter, entityFilter}, null);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    defineMap.put(row.getString("elementobject"), row.getLong("id"));
                }
            }
            int rowIndex = 0;
            this.getModel().beginInit();
            TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                long elementEntryId = dynamicObject.getLong("id");
                tableValueSetter.set("elementid", (Object)elementEntryId, rowIndex);
                String elementname = dynamicObject.getString("elementname");
                tableValueSetter.set("elementname", (Object)elementname, rowIndex);
                String elementType = dynamicObject.getString("elementtype");
                tableValueSetter.set("elementtype", (Object)elementType, rowIndex);
                String sort = dynamicObject.getString("sort");
                tableValueSetter.set("sort", (Object)sort, rowIndex);
                String elementObject = "";
                if (dynamicObject.get("elementobject") != null) {
                    DynamicObject entity = dynamicObject.getDynamicObject("elementobject");
                    elementObject = entity.getString("id");
                    tableValueSetter.set("elementobject", (Object)elementObject, rowIndex);
                    if (defineMap.get(elementObject) != null) {
                        tableValueSetter.set("prioritydefine", defineMap.get(elementObject), rowIndex);
                    }
                }
                ++rowIndex;
            }
            ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", tableValueSetter);
            this.getView().updateView("entryentity");
        } else if ("prioritytype".equals(propertyName)) {
            this.getModel().deleteEntryData("entryentity");
        } else if ("demandbill".equals(propertyName)) {
            int rowCount = this.getModel().getEntryRowCount("entryentity");
            for (int i = 0; i < rowCount; ++i) {
                this.getModel().setValue("fieldflag", (Object)"", i);
                this.getModel().setValue("fieldname", (Object)"", i);
            }
        } else if ("fieldflag".equals(propertyName)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            String fieldflag = "";
            if (this.getModel().getValue("fieldflag", rowIndex) != null) {
                fieldflag = (String)this.getModel().getValue("fieldflag", rowIndex);
            }
            if (StringUtils.isBlank((CharSequence)fieldflag)) {
                this.getModel().setValue("fieldflag", (Object)"", rowIndex);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (CALLBACK_TREENODES.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            String fieldId = (String)closedCallBackEvent.getReturnData();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject demanbill = (DynamicObject)this.getModel().getValue("demandbill");
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)demanbill.getString("id"));
            String fieldCaption = BillFieldEntityHelper.buildPropFullCaption((EntityType)mainEntityType, (String)fieldId);
            this.getModel().setValue("fieldname", (Object)fieldCaption, rowIndex);
            this.getModel().setValue("fieldflag", (Object)fieldId, rowIndex);
        } else if (CALLBACK_CONDITION.equals(actionId) && closedCallBackEvent.getReturnData() != null) {
            this.closedCallBackByFunction(closedCallBackEvent.getReturnData());
        }
    }

    private void closedCallBackByFunction(Object returnData) {
        String json = String.valueOf(returnData);
        int row = this.getModel().getEntryCurrentRowIndex("entryentity");
        CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
        if (row >= 0) {
            this.getModel().setValue("pentryfruncondition_tag", (Object)json, row);
            this.getModel().setValue("conditiondesc", (Object)condition.getExprDesc(), row);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String propertyName = beforeF7SelectEvent.getProperty().getName();
        if ("demandbill".equals(propertyName)) {
            List<String> entityList = this.getEntityList("0P89LIWGDWP7");
            entityList.add("mrp_pls_order");
            entityList.add("mps_pls_order");
            beforeF7SelectEvent.getCustomQFilters().add(new QFilter("number", "in", entityList));
        }
    }

    private List<String> getEntityList(String typeId) {
        String oql = "select fnumber from T_META_ENTITYDESIGN where fparentid = '" + typeId + "'";
        try (DataSet dataSet = DB.queryDataSet((String)ResourceRigisterConfigEdit.class.getName(), (DBRoute)DBRoute.meta, (String)oql);){
            ArrayList<String> list = new ArrayList<String>(16);
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String fid = (String)row.get("fnumber");
                list.add(fid);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
    }

    private void setAppIdParam(String param) {
        if ("mds".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('A'));
        } else if ("sfc".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('C'));
        } else if ("mrp".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('B'));
        } else if ("msplan".equals(param) || "msmpmm".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('D'));
        } else {
            this.getModel().setValue(FIELDTYPE, (Object)param);
        }
    }

    private static class EntityColStrategy
    extends DemandSelectStrategy {
        private EntityColStrategy() {
        }

        public boolean filterPro(IDataEntityProperty pro) {
            return pro instanceof BasedataProp;
        }

        public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
            return Collections.emptySet();
        }
    }

    private static class DateColStrategy
    extends DemandSelectStrategy {
        private DateColStrategy() {
        }

        public boolean filterPro(IDataEntityProperty pro) {
            return pro instanceof DateProp || pro instanceof DateTimeProp;
        }

        public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
            return Collections.emptySet();
        }
    }

    private static class QtyColStrategy
    extends DemandSelectStrategy {
        private QtyColStrategy() {
        }

        public boolean filterPro(IDataEntityProperty pro) {
            return pro instanceof QtyProp;
        }

        public Set<String> getNeedColsOfBaseData(String baseDataNo, BasedataProp basedataProp) {
            return Collections.emptySet();
        }
    }
}

