/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.prioritymodel;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.MetadataServiceHelper;

public class MsplanPriorityTypeEditPlugin
extends AbstractFormPlugin {
    public static final String ENTRYENTITY = "entryentity";
    public static final String FIELDTYPE = "fieldtype";
    private static final String SPSELECTDIMENSION_CALLBACK = "spselectdimension_callback";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"elementfield"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String fieldType = "";
        if (this.getModel().getValue(FIELDTYPE) != null) {
            fieldType = (String)this.getModel().getValue(FIELDTYPE);
        }
        if (StringUtils.isBlank((CharSequence)fieldType)) {
            this.setAppIdParam(this.getView().getFormShowParameter().getAppId());
        }
    }

    public void afterCopyData(EventObject e) {
        this.setAppIdParam(this.getView().getFormShowParameter().getAppId());
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldName = e.getProperty().getName();
        int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
        if ("elementtype".equals(fieldName)) {
            String elementType = "";
            if (this.getModel().getValue("elementtype", rowIndex) != null) {
                elementType = (String)this.getModel().getValue("elementtype", rowIndex);
            }
            if (StringUtils.isNotBlank((CharSequence)elementType) && "2".equals(elementType)) {
                this.getModel().setValue("prioritydefine", (Object)"0", rowIndex);
            } else {
                this.getModel().setValue("prioritydefine", (Object)"1", rowIndex);
            }
        } else if ("elementobject".equals(fieldName) && this.getModel().getValue("elementobject", rowIndex) != null) {
            DynamicObject elementObj = (DynamicObject)this.getModel().getValue("elementobject", rowIndex);
            String entityId = elementObj.getString("id");
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            this.getModel().setValue("elementfield", null, rowIndex);
            this.getModel().setValue("elementval", (Object)"", rowIndex);
            if (mainEntityType.findProperty("number") == null || mainEntityType.findProperty("name") == null) {
                String message = String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d%1$s\u884c\u8981\u7d20\u5bf9\u8c61\u4e0d\u5305\u542b\u7f16\u7801(number)\uff0c\u540d\u79f0(name)\u5b57\u6bb5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002\n", (String)"MsplanPriorityTypeEditPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex + 1);
                this.getView().showTipNotification(message);
                this.getModel().setValue("elementobject", null, rowIndex);
            }
        } else if ("elementfield".equals(fieldName) && (this.getModel().getValue("elementfield", rowIndex) == null || StringUtils.isBlank((Object)this.getModel().getValue("elementfield", rowIndex)))) {
            this.getModel().setValue("elementval", (Object)"", rowIndex);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String name = control.getKey();
        if ("elementfield".equals(name)) {
            int row = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            if (this.getModel().getValue("elementobject") != null) {
                DynamicObject elementObject = (DynamicObject)this.getModel().getValue("elementobject");
                String billNumber = elementObject.getString("number");
                String selectField = "";
                if (this.getModel().getValue("elementval", row) != null) {
                    selectField = (String)this.getModel().getValue("elementval", row);
                }
                this.openSelectDimensionView(billNumber, selectField, SPSELECTDIMENSION_CALLBACK);
            } else {
                String message = String.format(ResManager.loadKDString((String)"\u8be6\u7ec6\u4fe1\u606f\u4e2d%1$s\u884c\u8981\u7d20\u5bf9\u8c61\u4e3a\u7a7a\uff0c\u8bf7\u5148\u7ef4\u62a4\u8981\u7d20\u5bf9\u8c61\u6570\u636e\u3002\n", (String)"MsplanPriorityTypeEditPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), row + 1);
                this.getView().showTipNotification(message);
            }
        }
    }

    private void openSelectDimensionView(String billNumber, String selectField, String callBackActionId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_fielddimension");
        showParameter.getCustomParams().put("entityId", billNumber);
        showParameter.getCustomParams().put("fieldKeyValues", selectField);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, callBackActionId));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        if (!StringUtils.isBlank((Object)returnData) && returnData instanceof Map && SPSELECTDIMENSION_CALLBACK.equals(actionId = closedCallBackEvent.getActionId())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRYENTITY);
            Map data = (Map)returnData;
            String keys = String.join((CharSequence)",", data.keySet());
            String jsonData = String.join((CharSequence)"\uff1b", data.values());
            this.getModel().setValue("elementval", (Object)keys, rowIndex);
            this.getModel().setValue("elementfield", (Object)jsonData, rowIndex);
        }
    }

    private void setAppIdParam(String param) {
        if ("mds".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('A'));
        } else if ("sfc".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('C'));
        } else if ("mrp".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('B'));
        } else if ("msplan".equals(param) || "msmpmm".equals(param)) {
            this.getModel().setValue(FIELDTYPE, (Object)Character.valueOf('D'));
        } else {
            this.getModel().setValue(FIELDTYPE, (Object)param);
        }
    }
}

