/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.reportext;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ReportExtRefPropEditPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
TreeNodeCheckListener {
    private TreeNode root;

    public void afterCreateNewData(EventObject e) {
        FormShowParameter param = this.getView().getFormShowParameter();
        TreeNode treeNode = this.getTreeNode();
        if (treeNode == null) {
            return;
        }
        String refPropsStr = (String)param.getCustomParam("refProps");
        List checkNodeIds = refPropsStr == null ? Collections.emptyList() : (List)SerializationUtils.fromJsonString((String)refPropsStr, List.class);
        TreeView tree = (TreeView)this.getView().getControl("coltree");
        tree.addNode(treeNode);
        ArrayList<TreeNode> checkNodes = new ArrayList<TreeNode>(checkNodeIds.size());
        for (String nodeId : checkNodeIds) {
            checkNodes.add(treeNode.getTreeNode(nodeId, 16));
        }
        this.initRefProps(treeNode, checkNodeIds);
        tree.checkNodes(checkNodes);
        this.getPageCache().put("selected_nodes", SerializationUtils.toJsonString((Object)checkNodeIds));
    }

    private void initRefProps(TreeNode treeData, List<String> checkNodeIds) {
        IDataModel model = this.getModel();
        model.deleteEntryData("collist");
        TreeNode treeNode = null;
        int rowindex = 0;
        for (String nodeId : checkNodeIds) {
            treeNode = treeData.getTreeNode(nodeId);
            if (treeNode == null) continue;
            rowindex = model.createNewEntryRow("collist");
            model.setValue("col", (Object)treeNode.getId(), rowindex);
            model.setValue("col_name", (Object)(treeNode.getText() + "(" + treeNode.getId() + ")"), rowindex);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"removecol", "ok"});
        TreeView fieldtree = (TreeView)this.getView().getControl("coltree");
        fieldtree.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        EntryGrid grid = (EntryGrid)this.getControl("collist");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "removecol": {
                this.removeCol();
                break;
            }
            case "ok": {
                this.returnData();
                break;
            }
        }
    }

    private void removeCol() {
        EntryGrid grid = (EntryGrid)this.getView().getControl("collist");
        int[] rows = grid.getEntryState().getSelectedRows();
        if (rows != null && rows.length != 0) {
            IDataModel model = this.getModel();
            ArrayList<String> nodeIds = new ArrayList<String>();
            for (int i : rows) {
                if (i < 0) continue;
                nodeIds.add((String)model.getValue("col", i));
            }
            model.deleteEntryRows("collist", rows);
            TreeView tree = (TreeView)this.getView().getControl("coltree");
            tree.uncheckNodes(nodeIds);
            this.getPageCache().put("selected_nodes", SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
        }
    }

    private TreeNode getTreeNode() {
        FormShowParameter param;
        String treeDataStr;
        if (this.root == null && StringUtils.isNotBlank((CharSequence)(treeDataStr = (String)(param = this.getView().getFormShowParameter()).getCustomParam("treeData")))) {
            this.root = (TreeNode)SerializationUtils.fromJsonString((String)treeDataStr, TreeNode.class);
        }
        return this.root;
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeNode root = this.getTreeNode();
        TreeView tree = (TreeView)this.getView().getControl("coltree");
        List currChecks = tree.getTreeState().getCheckedNodeIds();
        List checkNodes = (List)SerializationUtils.fromJsonString((String)this.getPageCache().get("selected_nodes"), List.class);
        IDataModel model = this.getModel();
        if (evt.getChecked().booleanValue()) {
            if (checkNodes.isEmpty() || currChecks.removeAll(checkNodes)) {
                for (String id : currChecks) {
                    TreeNode node = root.getTreeNode(id, 16);
                    if (node == null || node.getChildren() != null) continue;
                    int row = model.createNewEntryRow("collist");
                    model.setValue("col", (Object)node.getId(), row);
                    model.setValue("col_name", (Object)(node.getText() + "(" + node.getId() + ")"), row);
                }
            }
        } else if (currChecks.isEmpty() || checkNodes.removeAll(currChecks)) {
            for (int i = 0; i < checkNodes.size(); ++i) {
                TreeNode node = root.getTreeNode((String)checkNodes.get(i), 16);
                if (node == null || node.getChildren() == null) continue;
                checkNodes.remove(i);
            }
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int j = model.getEntryRowCount("collist") - 1; j >= 0; --j) {
                if (!checkNodes.contains(model.getValue("col", j))) continue;
                list.add(j);
            }
            int[] rows = list.stream().mapToInt(Integer::valueOf).toArray();
            model.deleteEntryRows("collist", rows);
        }
        this.getPageCache().put("selected_nodes", SerializationUtils.toJsonString((Object)tree.getTreeState().getCheckedNodeIds()));
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Control source = (Control)evt.getSource();
        if ("collist".equals(source.getKey())) {
            this.removeCol();
        }
    }

    private void returnData() {
        DynamicObjectCollection colList = this.getModel().getEntryEntity("collist");
        HashMap<String, String> params = new HashMap<String, String>();
        ArrayList<String> cols = new ArrayList<String>(colList.size());
        for (DynamicObject row : colList) {
            cols.add(row.getString("col"));
        }
        params.put("refProps", SerializationUtils.toJsonString(cols));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString(params));
        this.getView().close();
    }
}

