/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.reportext;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.UnitProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.mpscmm.common.util.ReportExtUtils;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class ReportExtSetFieldFormPlugin
extends AbstractFormPlugin
implements ClickListener {
    public static final String APPNUMBER = "mpscmm-msplan-formplugin";
    private static final String BTNOK = "btnok";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"displayprop"});
        this.addClickListeners(new String[]{"refbasedataprop"});
        this.addClickListeners(new String[]{"refprop"});
        this.addClickListeners(new String[]{"measureunitfield"});
        this.addClickListeners(new String[]{BTNOK});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        Object newValue;
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        if (Objects.equals(oldValue, newValue = changeSet[0].getNewValue())) {
            return;
        }
        if ("entityobject".equals(proName)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            this.getModel().setValue("displayprop", (Object)"");
            this.getModel().setValue("refprop", (Object)"");
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
        if ("refbasedataprop".equals(proName)) {
            this.getPageCache().put("isIgnoreChangeListener", "true");
            this.getModel().setValue("entityobject", null);
            this.getModel().setValue("displayprop", null);
            this.getPageCache().put("isIgnoreChangeListener", "false");
        }
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map param = parameter.getCustomParams();
        IDataModel model = this.getModel();
        String fieldParam = param.get("fieldparam").toString();
        if (!StringUtils.isEmpty((String)fieldParam)) {
            JSONObject dataParam = JSON.parseObject((String)fieldParam);
            model.setValue("fieldtype", (Object)dataParam.getString("fieldtype"));
            model.setValue("entityobject", (Object)dataParam.getString("entityobject"));
            model.setValue("displayprop", (Object)dataParam.getString("displayprop"));
            model.setValue("refbasedataprop", (Object)dataParam.getString("refbasedataprop"));
            model.setValue("refprop", (Object)dataParam.getString("refprop"));
            model.setValue("zeroshow", (Object)dataParam.getBoolean("zeroshow"));
            model.setValue("bigdecimalscale", (Object)dataParam.getInteger("bigdecimalscale"));
            model.setValue("measureunitfield", (Object)dataParam.getString("measureunitfield"));
            model.setValue("dateformatmask", (Object)dataParam.getString("dateformatmask"));
            JSONArray js = dataParam.getJSONArray("statusentryentity");
            if (js != null && !js.isEmpty()) {
                this.getModel().batchCreateNewEntryRow("statusentryentity", js.size());
                for (int i = 0; i < js.size(); ++i) {
                    JSONObject combItem = js.getJSONObject(i);
                    model.setValue("combstatusvalue", (Object)combItem.getString("combstatusvalue"), i);
                    model.setValue("combstatusname", (Object)combItem.getString("combstatusname"), i);
                }
            }
        }
        if (!"addnew".equals(param.get("opentype").toString())) {
            model.setValue("fieldnumer", (Object)param.get("fieldnumber").toString());
            model.setValue("fieldname", (Object)param.get("fieldname").toString());
        }
        model.setValue("isdynamicfield", (Object)"true".equals(param.get("isdynamicfield").toString()));
        model.setValue("islock", (Object)"false".equals(param.get("status").toString()));
        model.setValue("reportentity", (Object)param.get("reportEntityNumber").toString());
        this.getPageCache().put("dynamicfields", param.get("dynamicfields").toString());
    }

    public DynamicObject getBaseDataObject() {
        return (DynamicObject)this.getModel().getValue("entityobject");
    }

    public String getRefBaseDataObject() {
        return (String)this.getModel().getValue("refbasedataprop");
    }

    public void click(EventObject evt) {
        super.click(evt);
        if (evt == null) {
            return;
        }
        Object srcObj = evt.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (srcKey == null) {
            return;
        }
        switch (srcKey) {
            case "displayprop": {
                this.openBaseDataFieldF7(srcKey);
                break;
            }
            case "refbasedataprop": {
                this.openBaseDataFieldF7(srcKey);
                break;
            }
            case "refprop": {
                DynamicObject objectentity = this.getBaseDataObject();
                if (objectentity == null) {
                    return;
                }
                String refProps = (String)this.getModel().getValue("refprop");
                this.openBaseDataRefCol((String)objectentity.getPkValue(), refProps);
                break;
            }
            case "measureunitfield": {
                this.openBaseDataFieldF7(srcKey);
                break;
            }
            case "btnok": {
                if (!this.checkData()) break;
                FormShowParameter showParam = this.getView().getFormShowParameter();
                Map param = showParam.getCustomParams();
                param.put("fieldparam", this.buildFieldParams());
                param.put("fieldtypedesc", this.getFieldTypeDesc());
                this.getView().returnDataToParent((Object)param);
                this.getView().close();
                break;
            }
        }
    }

    private void openBaseDataRefCol(String baseEntityNumber, String refProps) {
        TreeNode treeNode = ReportExtUtils.buildRefColTree((String)baseEntityNumber);
        if (treeNode == null) {
            return;
        }
        List selectedProps = ReportExtUtils.splitCombColToList((String)refProps);
        FormShowParameter show = new FormShowParameter();
        show.setFormId("msplan_reportextref_col");
        show.getCustomParams().put("treeData", SerializationUtils.toJsonString((Object)treeNode));
        show.getCustomParams().put("refProps", SerializationUtils.toJsonString((Object)selectedProps));
        show.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "openBaseDataRefCol"));
        show.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(show);
    }

    private void openBaseDataFieldF7(String opFieldNumber) {
        List<Map<String, Object>> list = this.getFieldList(opFieldNumber);
        if (list == null || list.isEmpty()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("list", list);
        params.put("formId", "msplan_select_repfields");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(params);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, opFieldNumber));
        showParameter.setCaption(this.getOpF7Name(opFieldNumber));
        this.getView().showForm(showParameter);
    }

    private String getOpF7Name(String opFieldNumber) {
        if ("displayprop".equals(opFieldNumber)) {
            return ResManager.loadKDString((String)"\u663e\u793a\u5c5e\u6027\u5b57\u6bb5", (String)"ReportExtSetFieldFormPlugin_12", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("refbasedataprop".equals(opFieldNumber)) {
            return ResManager.loadKDString((String)"\u5173\u8054\u57fa\u7840\u8d44\u6599\u5b57\u6bb5", (String)"ReportExtSetFieldFormPlugin_13", (String)APPNUMBER, (Object[])new Object[0]);
        }
        if ("measureunitfield".equals(opFieldNumber)) {
            return ResManager.loadKDString((String)"\u5173\u8054\u8ba1\u91cf\u5355\u4f4d\u5b57\u6bb5", (String)"ReportExtSetFieldFormPlugin_14", (String)APPNUMBER, (Object[])new Object[0]);
        }
        return "";
    }

    public void addToList(List<Map<String, Object>> list, String fieldNumber, IDataEntityProperty prop) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("fieldnumber", fieldNumber);
        map.put("fieldname", prop.getDisplayName().getLocaleValue());
        map.put("fieldtype", BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)((DynamicProperty)prop)));
        if (prop instanceof BasedataProp) {
            map.put("fieldbasedata", ((BasedataProp)prop).getBaseEntityId());
        }
        list.add(map);
    }

    public String getBaseDataEntity(String opFieldNumber) {
        if ("displayprop".equalsIgnoreCase(opFieldNumber)) {
            DynamicObject objectentity = this.getBaseDataObject();
            return objectentity == null ? "" : (String)objectentity.getPkValue();
        }
        return (String)this.getModel().getValue("reportentity");
    }

    public String getBaseDataFieldRefProp(String refBaseDataProp) {
        String refProps = "";
        String entityNumber = (String)this.getModel().getValue("reportentity");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map allFields = mainType.getAllFields();
        IDataEntityProperty prop = (IDataEntityProperty)allFields.get(refBaseDataProp);
        if (prop instanceof BasedataProp) {
            refProps = ReportExtUtils.getRefFields((BasedataProp)((BasedataProp)prop));
        } else {
            String dynamicObjectFields = this.getPageCache().get("dynamicfields");
            if (dynamicObjectFields != null && !"".equals(dynamicObjectFields)) {
                JSONArray dataJs = JSON.parseArray((String)dynamicObjectFields);
                for (int i = 0; i < dataJs.size(); ++i) {
                    JSONObject fieldParamJs;
                    JSONObject data = dataJs.getJSONObject(i);
                    String fieldParam = data.getString("fieldparam_tag");
                    if (fieldParam == null || "".equals(fieldParam) || !refBaseDataProp.equalsIgnoreCase(data.getString("fieldnumber")) || !"G".equals((fieldParamJs = JSON.parseObject((String)fieldParam)).getString("fieldtype"))) continue;
                    refProps = fieldParamJs.getString("refprop");
                }
            }
        }
        return refProps;
    }

    public List<Map<String, Object>> getFieldList(String opFieldNumber) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(16);
        String reportEntity = this.getBaseDataEntity(opFieldNumber);
        if (reportEntity == null || "".equals(reportEntity)) {
            return list;
        }
        String fieldType = (String)this.getModel().getValue("fieldtype");
        if ("H".equals(fieldType) && "displayprop".equalsIgnoreCase(opFieldNumber)) {
            String refProps;
            String refBaseDataProp = (String)this.getModel().getValue("refbasedataprop");
            if (!StringUtils.isEmpty((String)refBaseDataProp) && (refProps = this.getBaseDataFieldRefProp(refBaseDataProp)) != null && !"".equals(refProps)) {
                String[] keys = refProps.split(",");
                DynamicObject entityObject = this.getBaseDataObject();
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)((String)entityObject.getPkValue()));
                for (String refField : keys) {
                    if (StringUtils.isEmpty((String)refField)) continue;
                    HashMap<String, String> map = new HashMap<String, String>(16);
                    map.put("fieldnumber", refField);
                    map.put("fieldname", refField);
                    DynamicProperty findProperty = (DynamicProperty)mainType.findProperty(refField);
                    if (findProperty != null) {
                        map.put("fieldname", findProperty.getDisplayName() == null ? refField : findProperty.getDisplayName().getLocaleValue());
                        map.put("fieldtype", BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)findProperty));
                    }
                    list.add(map);
                }
            }
            return list;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)reportEntity);
        Map allFields = mainType.getAllFields();
        for (Map.Entry fieldentrys : allFields.entrySet()) {
            String fieldNumber = (String)fieldentrys.getKey();
            IDataEntityProperty prop = (IDataEntityProperty)fieldentrys.getValue();
            if ("displayprop".equalsIgnoreCase(opFieldNumber)) {
                if (!(prop instanceof TextProp)) continue;
                this.addToList(list, fieldNumber, prop);
                continue;
            }
            if ("refbasedataprop".equalsIgnoreCase(opFieldNumber)) {
                if (!(prop instanceof BasedataProp)) continue;
                this.addToList(list, fieldNumber, prop);
                continue;
            }
            if (!"measureunitfield".equalsIgnoreCase(opFieldNumber) || !(prop instanceof UnitProp)) continue;
            this.addToList(list, fieldNumber, prop);
        }
        String dynamicObjectFields = this.getPageCache().get("dynamicfields");
        if (dynamicObjectFields != null && !"".equals(dynamicObjectFields)) {
            JSONArray dataJs = JSON.parseArray((String)dynamicObjectFields);
            for (int i = 0; i < dataJs.size(); ++i) {
                JSONObject data = dataJs.getJSONObject(i);
                String fieldParam = data.getString("fieldparam_tag");
                if (fieldParam == null || "".equals(fieldParam)) continue;
                JSONObject fieldParamJs = JSON.parseObject((String)fieldParam);
                if ("refbasedataprop".equalsIgnoreCase(opFieldNumber)) {
                    if (!"G".equals(fieldParamJs.getString("fieldtype"))) continue;
                    this.addToList(list, data);
                    continue;
                }
                if (!"measureunitfield".equalsIgnoreCase(opFieldNumber)) continue;
                String baseDataId = fieldParamJs.getString("entityobject");
                if (!"G".equals(fieldParamJs.getString("fieldtype")) || !"bd_measureunits".equals(baseDataId)) continue;
                this.addToList(list, data);
            }
        }
        return list;
    }

    public void addToList(List<Map<String, Object>> list, JSONObject data) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("fieldnumber", data.getString("fieldnumber"));
        map.put("fieldname", data.getString("fieldname"));
        map.put("fieldtype", ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"ReportExtSetFieldFormPlugin_01", (String)APPNUMBER, (Object[])new Object[0]));
        list.add(map);
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnData;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("displayprop".equals(actionId) || "refbasedataprop".equals(actionId) || "measureunitfield".equals(actionId)) {
            Object returnData2 = event.getReturnData();
            if (returnData2 != null) {
                Map result = (Map)returnData2;
                String fieldNumber = (String)result.get("fieldnumber");
                this.getModel().setValue(actionId, (Object)fieldNumber);
                if ("refbasedataprop".equals(actionId) || "measureunitfield".equals(actionId)) {
                    String fieldbasedata = (String)result.get("fieldbasedata");
                    this.getModel().setValue("entityobject", (Object)fieldbasedata);
                }
            }
        } else if ("openBaseDataRefCol".equals(actionId) && (returnData = event.getReturnData()) != null) {
            Map params = (Map)SerializationUtils.fromJsonString((String)((String)returnData), Map.class);
            String colStr = (String)params.get("refProps");
            List refProps = (List)SerializationUtils.fromJsonString((String)colStr, List.class);
            this.getModel().setValue("refprop", (Object)String.join((CharSequence)",", refProps));
        }
    }

    private String getStringValue(Object data) {
        return data == null ? "" : (String)data;
    }

    private String buildFieldParams() {
        IDataModel model = this.getModel();
        JSONObject dataJsonObject = new JSONObject(16);
        String fieldtype = this.getStringValue(model.getValue("fieldtype"));
        dataJsonObject.put("fieldnumer", (Object)this.getStringValue(model.getValue("fieldnumer")));
        dataJsonObject.put("fieldname", (Object)this.getStringValue(model.getValue("fieldname")));
        dataJsonObject.put("fieldtype", (Object)fieldtype);
        if ("E".equals(fieldtype)) {
            dataJsonObject.put("dateformatmask", (Object)this.getStringValue(model.getValue("dateformatmask")));
        }
        if ("B".equals(fieldtype)) {
            dataJsonObject.put("dateformatmask", (Object)this.getStringValue(model.getValue("dateformatmask")));
            dataJsonObject.put("fieldtype", (Object)"B");
            dataJsonObject.put("zeroshow", model.getValue("zeroshow"));
            dataJsonObject.put("bigdecimalscale", (Object)Integer.parseInt(model.getValue("bigdecimalscale").toString()));
            dataJsonObject.put("measureunitfield", (Object)this.getStringValue(model.getValue("measureunitfield")));
        }
        if ("F".equals(fieldtype)) {
            JSONArray itemJs = new JSONArray(16);
            DynamicObjectCollection coll = model.getDataEntity(true).getDynamicObjectCollection("statusentryentity");
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject entry = (DynamicObject)coll.get(i);
                String combValue = entry.getString("combstatusvalue");
                String combName = entry.getString("combstatusname");
                JSONObject itemObject = new JSONObject();
                itemObject.put("combstatusvalue", (Object)combValue);
                itemObject.put("combstatusname", (Object)combName);
                itemJs.add((Object)itemObject);
            }
            dataJsonObject.put("statusentryentity", (Object)itemJs);
        }
        if ("G".equals(fieldtype)) {
            DynamicObject baseData = this.getBaseDataObject();
            dataJsonObject.put("entityobject", baseData.getPkValue());
            dataJsonObject.put("displayprop", (Object)this.getStringValue(model.getValue("displayprop")));
            dataJsonObject.put("refprop", (Object)this.getStringValue(model.getValue("refprop")));
        }
        if ("H".equals(fieldtype)) {
            dataJsonObject.put("refbasedataprop", (Object)this.getRefBaseDataObject());
            dataJsonObject.put("displayprop", (Object)this.getStringValue(model.getValue("displayprop")));
        }
        return dataJsonObject.toJSONString();
    }

    private boolean checkData() {
        FormShowParameter showParam;
        Map param;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String fieldtype = (String)model.getValue("fieldtype");
        String fieldnumer = (String)model.getValue("fieldnumer");
        String fieldname = (String)model.getValue("fieldname");
        if (StringUtils.isEmpty((String)fieldtype)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u5b57\u6bb5\u7c7b\u578b\u3002", (String)"ReportExtSetFieldFormPlugin_02", (String)APPNUMBER, (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isEmpty((String)fieldnumer) || StringUtils.isEmpty((String)fieldname)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u4e0e\u5b57\u6bb5\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ReportExtSetFieldFormPlugin_03", (String)APPNUMBER, (Object[])new Object[0]));
            return false;
        }
        boolean isDynamicField = (Boolean)model.getValue("isdynamicfield");
        if (isDynamicField && "addnew".equals((param = (showParam = view.getFormShowParameter()).getCustomParams()).get("opentype").toString())) {
            DynamicObject baseData;
            String formatMask;
            if (!this.checkNumberUnquie(fieldnumer)) {
                return false;
            }
            if ("E".equals(fieldtype) && ((formatMask = (String)model.getValue("dateformatmask")) == null || "".equals(formatMask))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u65e5\u671f\u683c\u5f0f\u3002", (String)"ReportExtSetFieldFormPlugin_05", (String)APPNUMBER, (Object[])new Object[0]));
                return false;
            }
            if ("F".equals(fieldtype)) {
                DynamicObjectCollection coll = model.getDataEntity(true).getDynamicObjectCollection("statusentryentity");
                if (coll == null || coll.isEmpty()) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u72b6\u6001\u5217\u8868\u6570\u636e\u3002", (String)"ReportExtSetFieldFormPlugin_06", (String)APPNUMBER, (Object[])new Object[0]));
                    return false;
                }
                HashSet<String> valueSet = new HashSet<String>(16);
                for (int i = 0; i < coll.size(); ++i) {
                    DynamicObject entry = (DynamicObject)coll.get(i);
                    String combValue = entry.getString("combstatusvalue");
                    String combName = entry.getString("combstatusname");
                    if (StringUtils.isEmpty((String)combValue) || StringUtils.isEmpty((String)combName)) {
                        view.showTipNotification(String.format(ResManager.loadKDString((String)"\u72b6\u6001\u5217\u8868\u6570\u636e\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u72b6\u6001\u540d\u79f0\u4e0e\u72b6\u6001\u503c\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"ReportExtSetFieldFormPlugin_07", (String)APPNUMBER, (Object[])new Object[0]), i + 1));
                        return false;
                    }
                    if (valueSet.add(combValue)) continue;
                    view.showTipNotification(String.format(ResManager.loadKDString((String)"\u72b6\u6001\u5217\u8868\u6570\u636e\u5206\u5f55\u7b2c%1$s\u884c\uff1a\u72b6\u6001\u503c\u5b58\u5728\u91cd\u590d\u6570\u636e\u3002", (String)"ReportExtSetFieldFormPlugin_08", (String)APPNUMBER, (Object[])new Object[0]), i + 1));
                    return false;
                }
            }
            if ("G".equals(fieldtype) && (baseData = this.getBaseDataObject()) == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u57fa\u7840\u8d44\u6599\u5bf9\u8c61\u3002", (String)"ReportExtSetFieldFormPlugin_09", (String)APPNUMBER, (Object[])new Object[0]));
                return false;
            }
            if ("H".equals(fieldtype)) {
                String refBaseData = this.getRefBaseDataObject();
                if (StringUtils.isEmpty((String)refBaseData)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u5173\u8054\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u3002", (String)"ReportExtSetFieldFormPlugin_10", (String)APPNUMBER, (Object[])new Object[0]));
                    return false;
                }
                String displayProp = (String)model.getValue("displayprop");
                if (StringUtils.isEmpty((String)displayProp)) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5f55\u5165\u663e\u793a\u5c5e\u6027\u5b57\u6bb5\u3002", (String)"ReportExtSetFieldFormPlugin_11", (String)APPNUMBER, (Object[])new Object[0]));
                    return false;
                }
            }
        }
        return true;
    }

    private String getFieldTypeDesc() {
        String fieldtype = (String)this.getModel().getValue("fieldtype");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"msplan_fieldparamset");
        Map allFields = mainType.getAllFields();
        ComboProp prop = (ComboProp)allFields.get("fieldtype");
        List itemList = prop.getComboItems();
        for (ValueMapItem vi : itemList) {
            if (vi == null || !fieldtype.equals(vi.getValue())) continue;
            return vi.getName().getLocaleValue();
        }
        return "";
    }

    private boolean checkNumberUnquie(String fieldnumer) {
        String reportEntity = (String)this.getModel().getValue("reportentity");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)reportEntity);
        Map allFields = mainType.getAllFields();
        if (allFields.containsKey(fieldnumer)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"ReportExtSetFieldFormPlugin_04", (String)APPNUMBER, (Object[])new Object[0]), fieldnumer));
            return false;
        }
        String dynamicObjectFields = this.getPageCache().get("dynamicfields");
        if (dynamicObjectFields != null && !"".equals(dynamicObjectFields)) {
            JSONArray dataJs = JSON.parseArray((String)dynamicObjectFields);
            for (int i = 0; i < dataJs.size(); ++i) {
                JSONObject data = dataJs.getJSONObject(i);
                String fieldNumber2 = data.getString("fieldnumber");
                if (!fieldNumber2.equalsIgnoreCase(fieldnumer)) continue;
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5\u7f16\u7801\u201c%1$s\u201d\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u521b\u5efa\u3002", (String)"ReportExtSetFieldFormPlugin_04", (String)APPNUMBER, (Object[])new Object[0]), fieldnumer));
                return false;
            }
        }
        return true;
    }
}

