/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.formplugin.reserve;

import java.math.BigDecimal;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class NetChangeRecordListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        args.setCancel(true);
        BillListHyperLinkClickEvent hyperLinkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = hyperLinkClickEvent.getCurrentRow();
        BillList list = (BillList)this.getControl("billlistap");
        Long pkId = (Long)currentRow.getPrimaryKeyValue();
        switch (fieldName) {
            case "bill_no": {
                this.showSrcBill(pkId, list);
                break;
            }
            case "s_billnum": {
                this.showSupplyBill(pkId, list);
                break;
            }
        }
    }

    private void showSrcBill(Long pkId, BillList list) {
        DynamicObject selectRowEntry = null;
        if (pkId != null) {
            selectRowEntry = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)list.getBillFormId(), (String)"bill_obj,bill_id");
        }
        if (selectRowEntry != null) {
            String billName = selectRowEntry.getDynamicObject("bill_obj").getString("number");
            long bill_id = selectRowEntry.getLong("bill_id");
            this.openBillInfoShowPage(billName, bill_id);
        }
    }

    private void showSupplyBill(Long pkId, BillList list) {
        DynamicObject selectRowEntry = null;
        if (pkId != null) {
            selectRowEntry = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)list.getBillFormId(), (String)"bal_obj,bal_id");
        }
        if (selectRowEntry != null) {
            String billName = selectRowEntry.getDynamicObject("bal_obj").getString("number");
            long bill_id = selectRowEntry.getLong("bal_id");
            this.openBillInfoShowPage(billName, bill_id);
        }
    }

    private void openBillInfoShowPage(String billNumber, Long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(billNumber);
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.getQFilters().add(new QFilter("base_qty", ">", (Object)BigDecimal.ZERO));
    }
}

