/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;
import kd.mpscmm.msplan.mrp.common.util.DynamicObjDataUtil;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class BusinessPlanEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btn_btn", "btn_save", "btn_savecell", "btn_delete", "btn_clean"});
        BasedataEdit algoModel = (BasedataEdit)this.getControl("algomodel");
        if (algoModel != null) {
            algoModel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate formOperate = (FormOperate)e.getSource();
        String key = formOperate.getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            String rootXml = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"xml_tag");
            if (StringUtils.isBlank((CharSequence)rootXml)) {
                return;
            }
            Document document = null;
            try {
                document = DocumentHelper.parseText((String)rootXml);
            }
            catch (DocumentException e1) {
                throw new KDBizException(e1.getMessage());
            }
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            this.removeRepeatCellData(mxCellElements);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"new")) {
            this.cleanGraph();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.cleanGraph();
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        if (e == null) {
            return;
        }
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        if ("xmlData".equalsIgnoreCase(eventName)) {
            this.setXmlData(eventArgs);
        } else if ("selectCell".equalsIgnoreCase(eventName) || "afterAddPHMNode".equalsIgnoreCase(eventName)) {
            this.selectCell(eventArgs);
        } else if ("initxmlData".equalsIgnoreCase(eventName)) {
            this.initXmlData();
        } else if ("ClearControlData".equalsIgnoreCase(eventName)) {
            this.clearControlData();
        } else if ("cleanFlexData".equalsIgnoreCase(eventName)) {
            this.cleanFlexData();
        }
    }

    private void cleanFlexData() {
        this.getModel().setValue("selectid", null);
    }

    private void clearControlData() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        control.setData(null);
    }

    private void initXmlData() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        String xml = (String)this.getModel().getValue("xml_tag");
        if (StringUtils.isNotBlank((CharSequence)xml)) {
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("Action", "addxml");
            paramsMap.put("xml", xml);
            control.setData(paramsMap);
        }
    }

    private void setXmlData(String eventArgs) {
        try {
            int indexOf = eventArgs.indexOf("<root>");
            int lastIndexOf = eventArgs.lastIndexOf("</root>");
            String rootXml = eventArgs.substring(indexOf, lastIndexOf + 7);
            Document document = DocumentHelper.parseText((String)rootXml);
            Element root = document.getRootElement();
            List mxCellElements = root.elements();
            Iterator iterator = mxCellElements.iterator();
            while (iterator.hasNext()) {
                Element mxCell = (Element)iterator.next();
                String vertex = mxCell.attributeValue("vertex");
                String edge = mxCell.attributeValue("edge");
                if ("1".equals(vertex) || "1".equals(edge)) continue;
                iterator.remove();
            }
            this.getModel().setValue("xml_tag", (Object)document.asXML());
        }
        catch (DocumentException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void removeRepeatCellData(List<Element> mxCellElements) {
        if (mxCellElements == null) {
            return;
        }
        if (mxCellElements.isEmpty()) {
            this.getModel().setValue("cellsdata_tag", null);
            this.getModel().deleteEntryData("entryentity");
            return;
        }
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        if (cellsdataObj == null || StringUtils.isEmpty((CharSequence)cellsdataObj.toString())) {
            return;
        }
        String cellData = cellsdataObj.toString();
        Map cellsDataMap = (Map)JSON.parse((String)cellData);
        HashMap<String, Map> newCellsDataMap = new HashMap<String, Map>();
        boolean isExist = false;
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().deleteEntryData("entryentity");
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("seq", new Object[0]);
        vs.addField("entryalgomodel", new Object[0]);
        int seq = 1;
        for (Map.Entry entry : cellsDataMap.entrySet()) {
            String algoModel;
            String key = (String)entry.getKey();
            Map value = (Map)entry.getValue();
            isExist = false;
            for (Element cell : mxCellElements) {
                String id = cell.attributeValue("id");
                if (!StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)id)) continue;
                isExist = true;
                break;
            }
            if (!isExist) continue;
            newCellsDataMap.put(key, value);
            if (value == null || !StringUtils.isNotBlank((CharSequence)(algoModel = (String)value.get("algomodel")))) continue;
            vs.addRow(new Object[]{seq++, algoModel});
        }
        model.batchCreateNewEntryRow("entryentity", vs);
        model.endInit();
        String jsonString = JSON.toJSONString(newCellsDataMap);
        this.getModel().setValue("cellsdata_tag", (Object)jsonString);
    }

    public void click(EventObject evt) {
        Control srcCtrl;
        super.click(evt);
        Object srcCtrlObj = evt.getSource();
        Control control = srcCtrl = srcCtrlObj instanceof Control ? (Control)srcCtrlObj : null;
        if (srcCtrl == null) {
            return;
        }
        String srcCtrlKey = srcCtrl.getKey();
        if ("btn_save".equals(srcCtrlKey)) {
            this.saveMxgraph();
        } else if ("btn_savecell".equals(srcCtrlKey)) {
            this.saveCellData();
        } else if ("btn_btn".equals(srcCtrlKey)) {
            this.addNewNode();
        } else if ("btn_delete".equalsIgnoreCase(srcCtrlKey)) {
            this.deleteNode();
        } else if ("btn_clean".equalsIgnoreCase(srcCtrlKey)) {
            this.cleanGraph();
        }
    }

    private void saveMxgraph() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "saveMxgraph");
        control.setData(paramsMap);
    }

    private void addNewNode() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "addPHMNode");
        paramsMap.put("nodeId", this.getUUID());
        paramsMap.put("name", "");
        control.setData(paramsMap);
    }

    private void deleteNode() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "deleteCells");
        control.setData(paramsMap);
    }

    private void cleanGraph() {
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        if (control == null) {
            return;
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "cleanGraph");
        control.setData(paramsMap);
    }

    private void selectCell(String cellId) {
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        this.getModel().setValue("selectid", (Object)cellId);
        if (cellsdataObj != null && StringUtils.isNotEmpty((CharSequence)cellsdataObj.toString())) {
            String cellsdata = (String)cellsdataObj;
            Map cellsDataMap = (Map)JSON.parse((String)cellsdata);
            Map cellData = (Map)cellsDataMap.get(cellId);
            if (cellData != null) {
                if (!((String)cellData.get("algomodel")).isEmpty()) {
                    this.getModel().setValue("algomodel", cellData.get("algomodel"));
                } else {
                    this.getModel().setValue("algomodel", null);
                }
                this.getModel().setValue("selectname", cellData.get("selectname"));
            } else {
                this.getModel().setValue("algomodel", null);
                this.getModel().setValue("selectname", null);
            }
        } else {
            this.getModel().setValue("algomodel", null);
            this.getModel().setValue("selectname", null);
        }
    }

    private boolean saveCellData() {
        Object cellsdataObj = this.getModel().getValue("cellsdata_tag");
        Object upSelectid = this.getModel().getValue("selectid");
        if (upSelectid != null && StringUtils.isNotEmpty((CharSequence)upSelectid.toString())) {
            Map<String, Map> cellsDataMap;
            String upSelectidstr = (String)upSelectid;
            String selectname = (String)this.getModel().getValue("selectname");
            if (cellsdataObj != null && StringUtils.isNotEmpty((CharSequence)cellsdataObj.toString())) {
                String cellsdata = (String)cellsdataObj;
                cellsDataMap = (Map)JSON.parse((String)cellsdata);
            } else {
                cellsDataMap = new HashMap();
            }
            Map cellData = cellsDataMap.getOrDefault(upSelectidstr, new HashMap());
            DynamicObject algomodel = (DynamicObject)this.getModel().getValue("algomodel");
            if (algomodel != null && StringUtils.isBlank((CharSequence)selectname)) {
                selectname = algomodel.getString("name");
            }
            cellData.put("algomodel", algomodel == null ? "" : algomodel.getPkValue().toString());
            cellData.put("selectname", selectname);
            cellsDataMap.put(upSelectidstr, cellData);
            String jsonString = JSON.toJSONString(cellsDataMap);
            this.getModel().setValue("cellsdata_tag", (Object)jsonString);
            this.getModel().setValue("selectname", (Object)selectname);
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9ID\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"BusinessPlanEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        return false;
    }

    public void propertyChanged(PropertyChangedArgs event) {
        ChangeData[] changeDatas;
        String propertyName;
        if (event == null) {
            return;
        }
        super.propertyChanged(event);
        IDataEntityProperty dataEntityProperty = event.getProperty();
        String string = propertyName = dataEntityProperty == null ? null : dataEntityProperty.getName();
        if (StringUtils.isEmpty((CharSequence)propertyName)) {
            return;
        }
        for (ChangeData changeData : changeDatas = event.getChangeSet()) {
            Object oldObject = changeData.getOldValue();
            Object newObject = changeData.getNewValue();
            DynamicObject propertyValueCDDE = changeData.getDataEntity();
            if (oldObject != null && newObject != null && oldObject.toString().equalsIgnoreCase(newObject.toString())) continue;
            if ("algomodel".equalsIgnoreCase(propertyName)) {
                this.alogoModelChanged(oldObject, newObject, propertyValueCDDE);
                continue;
            }
            if ("selectname".equalsIgnoreCase(propertyName)) {
                this.selectNameChanged(oldObject, newObject, propertyValueCDDE);
                continue;
            }
            if ("selectid".equalsIgnoreCase(propertyName)) {
                this.selectIdChanged(oldObject, newObject, propertyValueCDDE);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"useorg", (CharSequence)propertyName) || StringUtils.equalsIgnoreCase((CharSequence)"xml_tag", (CharSequence)propertyName)) continue;
            this.getPageCache().put("checkDataChange", "true");
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String checkDataChange = this.getPageCache().get("checkDataChange");
        String status = DynamicObjDataUtil.getDataModelStringData((IDataModel)this.getModel(), (String)"status");
        if ("true".equalsIgnoreCase(checkDataChange) && "A".equalsIgnoreCase(status)) {
            e.setCheckDataChange(true);
        } else {
            e.setCheckDataChange(false);
        }
    }

    private void selectIdChanged(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        if (newObject == null) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"algomodel", null);
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"selectname", null);
        }
    }

    private void alogoModelChanged(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        boolean isSuccess = this.saveCellData();
        if (!isSuccess) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"algomodel", (Object)oldObject);
        }
    }

    private void selectNameChanged(Object oldObject, Object newObject, DynamicObject propertyValueCDDE) {
        String value = newObject instanceof String ? (String)newObject : "";
        this.setCellValue(value);
        boolean isSuccess = this.saveCellData();
        if (!isSuccess) {
            ControlUtil.setOldValue((IFormView)this.getView(), (IDataModel)this.getModel(), (DynamicObject)propertyValueCDDE, (String)"selectname", (Object)oldObject);
        }
    }

    private void setCellValue(String value) {
        Object nodeId = this.getModel().getValue("selectid");
        if (StringUtils.isBlank((Object)nodeId)) {
            return;
        }
        CustomControl control = (CustomControl)this.getView().getControl("cc_mgdesigner");
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("Action", "setMxValue");
        paramsMap.put("value", value);
        paramsMap.put("nodeId", nodeId.toString());
        control.setData(paramsMap);
    }

    private String getUUID() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString().replace("-", "");
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String selectId;
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"algomodel") && StringUtils.isBlank((CharSequence)(selectId = (String)this.getModel().getValue("selectid")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8282\u70b9ID\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u8282\u70b9\u3002", (String)"BusinessPlanEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }
}

