/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.LinkQueryPkId;
import kd.bos.list.LinkQueryPkIdCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.common.enums.ResultEnum;
import kd.mpscmm.msplan.mrp.common.util.ControlUtil;
import kd.mpscmm.msplan.mrp.common.util.DynamicObjDataUtil;
import kd.mpscmm.msplan.mrp.common.util.MrpEntrySeqComparotor;

public class CaculateLogEdit
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final String PROGRESS_BARAP = "progressbarap";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String SUM_MIN = "summin";
    private static final String CALCULATE_STATUS = "calculatestatus";
    private static final String CALCULATE_PRO = "calculatepro";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String USEORG = "useorg";
    private static final String CREATEORG = "createorg";
    private static final String STOP = "stop";
    private static final String ID = "id";
    private static final String PLANTYPE = "plantype";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String PLANPROGRAM = "plangram";
    private static final String ISLLC = "isllc";
    private static final String BOMCHECK_OPR = "isbomcheck_opr";
    private static final String BOMCHECK = "isbomcheck";
    private static final String ALLOWDATE = "isallowdateinpast";
    private static final String NUMBER = "number";
    private static final String LABELAP = "labelap";
    private static final String IMAGE_FAIL = "image_fail";
    private static final String IMAGE_SUCCESS = "image_success";
    private static int INSERTIONSORT_THRESHOLD = 7;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        this.addItemClickListeners(new String[]{"titleapanel"});
        EntryGrid entryEntity = (EntryGrid)this.getControl(ENTRY_ENTITY);
        entryEntity.addHyperClickListener(this::showAssociateForm);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_showerrorinfo".equals(itemKey)) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"msplan_mrpcalc_errorlog", (boolean)true, (int)0, (boolean)false);
            listShowParameter.getListFilterParameter().getQFilters().add(new QFilter("runlogno", "=", this.getModel().getValue(NUMBER)));
            if ("B".equals(this.getModel().getValue("runtype"))) {
                listShowParameter.setCaption(ResManager.loadKDString((String)"\u9f50\u5957\u5206\u6790\u5f02\u5e38\u65e5\u5fd7\u8bb0\u5f55", (String)"CaculateLogEdit_5", (String)"mmc-mrp-report", (Object[])new Object[0]));
            }
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideShowErrorInfoBar();
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            String calculatestatus = (String)this.getModel().getValue(CALCULATE_STATUS);
            if (StringUtils.equalsIgnoreCase((CharSequence)calculatestatus, (CharSequence)"D")) {
                progressBar.start();
            } else {
                this.sortEntryByResultSeq(this.getView());
            }
            BigDecimal calculatepro = (BigDecimal)this.getModel().getValue(CALCULATE_PRO);
            progressBar.setPercent(calculatepro.intValue());
            this.setProgressBarColorAndStatus(calculatestatus);
        }
        ControlUtil.setCellColor((IFormView)this.getView(), (String)ENTRY_ENTITY, (String)"entryresult", (Object)ResultEnum.SUCCESS.getValue(), (String)"#1BA854", (String)"", (String)"rgba(255,0,0,0.7)", (String)"");
        DynamicObject useOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)USEORG);
        if (useOrg == null) {
            this.getModel().setValue(USEORG, this.getModel().getValue(CREATEORG));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"dataversion"});
        FormShowParameter showParam = this.getView().getFormShowParameter();
        if (showParam != null && "pdm".equals(showParam.getAppId())) {
            Object operatmode = this.getModel().getValue("operatmode");
            Object numbers = this.getModel().getValue(NUMBER);
            if (operatmode != null) {
                this.setFormTitle(new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u8fd0\u7b97\u65e5\u5fd7-%2$s", (String)"CaculateLogEdit_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), operatmode, numbers == null ? "" : numbers.toString())));
            }
        }
    }

    private void hideShowErrorInfoBar() {
        String number = (String)this.getModel().getValue(NUMBER);
        QFilter qFilter = new QFilter("runlogno", "=", (Object)number);
        if (QueryServiceHelper.exists((String)"msplan_mrpcalc_errorlog", (QFilter[])new QFilter[]{qFilter})) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_showerrorinfo"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_showerrorinfo"});
        }
    }

    private void setProgressBarColorAndStatus(String cStatus) {
        String color = "#1BA854";
        Label lab = (Label)this.getControl(LABELAP);
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"D")) {
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d...", (String)"CaculateLogEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL, IMAGE_SUCCESS});
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"B") || StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"C")) {
            color = "rgba(255,0,0,0.7)";
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u5931\u8d25", (String)"CaculateLogEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_SUCCESS});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_FAIL});
        } else {
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u6210\u529f", (String)"CaculateLogEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_SUCCESS});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata(PROGRESS_BARAP, fieldMap);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (key.equals(STOP)) {
            this.updateData(this.getView());
        }
    }

    public int updateData(IFormView fv) {
        ProgressBar progressBar = (ProgressBar)fv.getControl(PROGRESS_BARAP);
        String status = this.sortEntryByResultSeq(this.getView());
        if (status != null) {
            fv.getModel().setValue(CALCULATE_STATUS, (Object)status);
        } else {
            status = (String)fv.getModel().getValue(CALCULATE_STATUS);
        }
        if ("A".equals(status) && "mrp_cps_runner".equals(this.getModel().getValue("operatmodekey"))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"bar_query"});
        }
        BigDecimal percent = (BigDecimal)fv.getModel().getValue(CALCULATE_PRO);
        int newPercent = percent.intValue();
        progressBar.setPercent(newPercent);
        if (!"D".equalsIgnoreCase(status)) {
            this.endCalculat(progressBar);
        }
        return newPercent;
    }

    public void onProgress(ProgressEvent progressEvent) {
        progressEvent.setProgress(this.updateData(this.getView()));
    }

    private String sortEntryByResultSeq(IFormView fv) {
        QFilter qfilter = new QFilter(ID, "=", fv.getModel().getValue(ID));
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)MRP_CACULATE_LOG, (String)"calculatepro,calculatestatus,entryentity.*", (QFilter[])new QFilter[]{qfilter});
        ArrayList list = new ArrayList(16);
        Iterator lits = dyn.iterator();
        while (lits.hasNext()) {
            list.add(lits.next());
        }
        DynamicObject[] a = list.toArray(new DynamicObject[0]);
        CaculateLogEdit.legacyMergeSort(a, new MrpEntrySeqComparotor());
        for (int i = 0; i < a.length; ++i) {
            list.set(i, a[i]);
        }
        AbstractFormDataModel model = (AbstractFormDataModel)fv.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Iterator its = list.iterator();
        String status = null;
        BigDecimal calculatepro = BigDecimal.ZERO;
        while (its.hasNext()) {
            DynamicObject it = (DynamicObject)its.next();
            vs.addField("seq", new Object[0]);
            vs.addField("entryresult", new Object[0]);
            vs.addField("entrystepseq", new Object[0]);
            vs.addField("entrystepname", new Object[0]);
            vs.addField("entryprocessdata", new Object[0]);
            vs.addField("entryoperatmin", new Object[0]);
            vs.addField("entrydetailmsg", new Object[0]);
            vs.addField("entrydetailmsg_tag", new Object[0]);
            vs.addField("associatedatalink", new Object[0]);
            vs.addField("associateform", new Object[0]);
            String associateForm = it.getString("entryentity.associateform");
            String associateDataLink = StringUtils.isBlank((CharSequence)associateForm) ? "" : ResManager.loadKDString((String)"\u67e5\u770b\u8be6\u7ec6\u6570\u636e", (String)"CaculateLogEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
            vs.addRow(new Object[]{it.get("entryentity.seq"), it.get("entryentity.entryresult"), it.get("entryentity.entrystepseq"), it.get("entryentity.entrystepname"), it.get("entryentity.entryprocessdata"), it.get("entryentity.entryoperatmin"), it.get("entryentity.entrydetailmsg"), it.get("entryentity.entrydetailmsg_tag"), associateDataLink, associateForm});
            status = it.getString(CALCULATE_STATUS);
            calculatepro = it.getBigDecimal(CALCULATE_PRO);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        fv.updateView(ENTRY_ENTITY);
        if (StringUtils.equalsIgnoreCase(status, (CharSequence)"D") && new BigDecimal("100").compareTo(calculatepro) <= 0) {
            calculatepro = new BigDecimal("99");
        }
        fv.getModel().setValue(CALCULATE_PRO, (Object)calculatepro);
        return status;
    }

    private static <T> void legacyMergeSort(T[] a, Comparator<? super T> c) {
        Object[] aux = (Object[])a.clone();
        if (c != null) {
            CaculateLogEdit.mergeSort(aux, a, 0, a.length, 0, c);
        }
    }

    private static void mergeSort(Object[] src, Object[] dest, int low, int high, int off, Comparator c) {
        int length = high - low;
        if (length < INSERTIONSORT_THRESHOLD) {
            for (int i = low; i < high; ++i) {
                for (int j = i; j > low && c.compare(dest[j - 1], dest[j]) > 0; --j) {
                    CaculateLogEdit.swap(dest, j, j - 1);
                }
            }
            return;
        }
        int destLow = low;
        int destHigh = high;
        int mid = (low += off) + (high += off) >>> 1;
        CaculateLogEdit.mergeSort(dest, src, low, mid, -off, c);
        CaculateLogEdit.mergeSort(dest, src, mid, high, -off, c);
        if (c.compare(src[mid - 1], src[mid]) <= 0) {
            System.arraycopy(src, low, dest, destLow, length);
            return;
        }
        int p = low;
        int q = mid;
        for (int i = destLow; i < destHigh; ++i) {
            dest[i] = q >= high || p < mid && c.compare(src[p], src[q]) <= 0 ? src[p++] : src[q++];
        }
    }

    private static void swap(Object[] x, int a, int b) {
        Object t = x[a];
        x[a] = x[b];
        x[b] = t;
    }

    private void endCalculat(ProgressBar progressBar) {
        progressBar.stop();
        QFilter qfilter = new QFilter(ID, "=", this.getModel().getValue(ID));
        DynamicObject calLog = QueryServiceHelper.queryOne((String)MRP_CACULATE_LOG, (String)"startdate,enddate,summin", (QFilter[])new QFilter[]{qfilter});
        if (calLog != null) {
            this.getModel().setValue(START_DATE, calLog.get(START_DATE));
            this.getModel().setValue(END_DATE, calLog.get(END_DATE));
            this.getModel().setValue(SUM_MIN, calLog.get(SUM_MIN));
        }
        this.setProgressBarColorAndStatus((String)this.getModel().getValue(CALCULATE_STATUS));
        ControlUtil.setCellColor((IFormView)this.getView(), (String)ENTRY_ENTITY, (String)"entryresult", (Object)ResultEnum.SUCCESS.getValue(), (String)"#1BA854", (String)"", (String)"rgba(255,0,0,0.7)", (String)"");
        this.hideShowErrorInfoBar();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)STOP) && result != null && result.isSuccess()) {
            this.afterUpdateData(this.getView());
        }
    }

    public void afterUpdateData(IFormView fv) {
        ProgressBar progressBar = (ProgressBar)fv.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            fv.getModel().deleteEntryData(ENTRY_ENTITY);
            progressBar.stop();
            DynamicObject calLog = BusinessDataServiceHelper.loadSingle((Object)fv.getModel().getValue(ID), (DynamicObjectType)this.getModel().getDataEntityType());
            calLog.set(CALCULATE_PRO, (Object)progressBar.getPercent());
            SaveServiceHelper.update((DynamicObject)calLog);
            BaseDataServiceHelper.clearCache((DynamicObject)calLog);
        }
    }

    private void showAssociateForm(HyperLinkClickEvent evt) {
        int rowIndex = evt.getRowIndex();
        String associateForm = (String)this.getModel().getValue("associateform", rowIndex);
        if (StringUtils.isBlank((CharSequence)associateForm)) {
            return;
        }
        long logId = (Long)this.getModel().getValue(ID);
        String number = (String)this.getModel().getValue(NUMBER);
        DynamicObject entityObject = BusinessDataServiceHelper.loadSingleFromCache((Object)associateForm, (String)"bos_entityobject", (String)"modeltype");
        String modelType = entityObject.getString("modeltype");
        if ("BillFormModel".equals(modelType)) {
            ListShowParameter parameter = new ListShowParameter();
            parameter.setFormId("bos_list");
            parameter.setBillFormId(associateForm);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            LinkQueryPkIdCollection linkQueryPkIds = this.getLinkQueryPkIdCollection(associateForm, number);
            if (linkQueryPkIds.isEmpty()) {
                linkQueryPkIds.add((Object)new LinkQueryPkId((Object)0L));
                parameter.setLinkQueryDescription(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5173\u8054\u6570\u636e\u3002", (String)"CaculateLogEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            parameter.setLinkQueryPkIdCollection(linkQueryPkIds);
            this.getView().showForm((FormShowParameter)parameter);
        } else if ("ReportFormModel".equals(modelType)) {
            ReportShowParameter parameter = new ReportShowParameter();
            parameter.setFormId(associateForm);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ReportQueryParam queryParam = this.getReportQueryParam(associateForm, logId, number);
            parameter.setQueryParam(queryParam);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private LinkQueryPkIdCollection getLinkQueryPkIdCollection(String entityName, String logNumber) {
        LinkQueryPkIdCollection linkQueryPkIds = new LinkQueryPkIdCollection();
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if ("mrp_calcdetail".equals(entityName)) {
            filters.add(new QFilter("caculatelog", "=", (Object)logNumber));
        } else if ("mrp_planorder".equals(entityName)) {
            filters.add(new QFilter("planoperatenum", "=", (Object)logNumber));
        } else {
            filters.add(new QFilter("1", "!=", (Object)1));
        }
        DynamicObjectCollection billList = QueryServiceHelper.query((String)entityName, (String)ID, (QFilter[])filters.toArray(new QFilter[0]));
        List idList = billList.stream().map(v -> new LinkQueryPkId((Object)v.getLong(ID))).collect(Collectors.toList());
        linkQueryPkIds.addAll(idList);
        return linkQueryPkIds;
    }

    private ReportQueryParam getReportQueryParam(String entityName, long logId, String logNumber) {
        ReportQueryParam param = new ReportQueryParam();
        if ("mrp_peginfo".equals(entityName)) {
            param.getFilter().addFilterItem(NUMBER, (Object)logId);
        } else if ("mrp_adjust_view".equals(entityName)) {
            param.getFilter().addFilterItem("planno", (Object)logId);
        } else if ("mrp_pur_forecast_rpt".equals(entityName)) {
            param.getFilter().addFilterItem("caculatelogid", (Object)logId);
            param.getFilter().addFilterItem("caculatelog", (Object)logNumber);
        } else if ("mrp_grossdemand_source".equals(entityName)) {
            param.getFilter().addFilterItem("caculatelogs", (Object)logId);
        }
        return param;
    }

    public void initialize() {
        super.initialize();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void setFormTitle(LocaleString title) {
        HashMap<String, String> paraMap = new HashMap<String, String>();
        ArrayList<HashMap<String, String>> paraList = new ArrayList<HashMap<String, String>>();
        paraMap.put("formTitle", title.toString());
        paraList.add(paraMap);
        IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.addAction("setFormTitle", paraList);
    }
}

