/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Consumer;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.GetEntityTypeEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.BindingContext;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.Vector;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.common.page.BaseDataElement;
import kd.mpscmm.common.page.ComboElement;
import kd.mpscmm.common.page.DecimalElement;
import kd.mpscmm.common.page.Element;
import kd.mpscmm.common.page.EntryElement;
import kd.mpscmm.common.page.IntegerElement;
import kd.mpscmm.common.page.LongElement;
import kd.mpscmm.msplan.mrp.business.helper.PlanViewOrgHelper;

public class DemandPriorityListPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener,
TreeNodeClickListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final String ENTRYENTITY = "entryentity";
    private static final String TYPE = "prioritytype";
    private static final String TYPE_ID = "prioritytype_id";
    private static final String TYPE_ENTITY = "mrp_priority_type";
    private static final String DEMANDORG = "demandorg";
    private static final String DEMAND_GROUP = "mrp_demandpriority_group";
    private static final String DEMAND = "mrp_demandpriority";
    private static final String ID = "id";
    private static final String CUSTOM_PRIORITY_ID = "priority_id";
    private static final String TREE_VIEW = "treeview";
    private static final String NAME = "name";
    private static final String PARENT = "parent";
    private static final String CALLBACK_GROUPADD = "group_add";
    private static final String CALLBACK_GROUPEDIT = "group_bar_edit";
    private static final String CONFIRM_DELETE = "group_bar_del";
    private static final String OPERATE = "operate";
    private static final String WEIGHT = "weight";
    private static final String GROUPID = "groupid";
    private static final String Confirm_TreeNode = "isTreeNodeexists";
    private static final String Confirm_Refresh = "isRefresh";
    private static final String Confirm_Exist = "isexists";
    private static final String CACHE_PRENODE = "previousnode";
    private static final String CACHE_DELROWS = "delete_rows";
    private static final String CACHE_ROOT = "cache_root_tree";
    private static final String REFRESH = "refresh";

    public void initialize() {
        this.getView().addCustomControls(new String[]{ENTRYENTITY});
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String treeNodeId = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
        if (treeNodeId == null || treeNodeId.equals("all")) {
            return;
        }
        long grpId = Long.parseLong(treeNodeId);
        Object weight = this.getWeightByGrpId(grpId);
        IDataModel model = this.getModel();
        for (RowDataEntity entity : e.getRowDataEntities()) {
            int rowIndex = entity.getRowIndex();
            model.setValue(GROUPID, (Object)grpId, rowIndex);
            model.setValue(WEIGHT, weight, rowIndex);
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit priorityEdit = (BasedataEdit)this.getControl(TYPE);
        priorityEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit demandorgEdit = (BasedataEdit)this.getControl(DEMANDORG);
        demandorgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getView().getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getView().getControl(TREE_VIEW);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnnew", "btnedit", "btndel"});
        this.addItemClickListeners(new String[]{"toolbarap", "bartool"});
    }

    public void showConfirmTreeNodes() {
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u8fdb\u884c\u6811\u5f62\u8282\u70b9\u7684\u5207\u6362\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DemandPriorityListPlugin_67", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(Confirm_TreeNode, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DemandPriorityListPlugin_100", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u5207\u6362", (String)"DemandPriorityListPlugin_101", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        boolean dataChanged = this.getModel().getDataChanged();
        if (dataChanged) {
            this.showConfirmTreeNodes();
        } else {
            long value = (Long)this.getModel().getValue(TYPE_ID);
            if (value == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f18\u5148\u7ea7\u7c7b\u578b\u3002", (String)"DemandPriorityListPlugin_68", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.clearEntryData();
            this.setEntryRowData(value, this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW)));
            this.clearDataChanged();
            this.putCache(CACHE_PRENODE, this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW)));
        }
    }

    private void clearDataChanged() {
        this.getModel().setDataChanged(false);
    }

    private void putCache(String key, String value) {
        this.getPageCache().put(key, value);
    }

    private String getCache(String key) {
        return this.getPageCache().get(key);
    }

    private void clearEntryData() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        int rowCount = entryEntity.getRowCount();
        int[] rows = new int[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            rows[i] = i;
        }
        model.deleteEntryRows(ENTRYENTITY, rows);
    }

    public void click(EventObject e) {
        if (e.getSource() instanceof Vector) {
            Vector vec = (Vector)e.getSource();
            String key = vec.getKey();
            if ("btnnew".equals(key)) {
                RequestContext request = RequestContext.get();
                int flag = PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (Long)this.getDemandOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND_GROUP, (String)"47156aff000000ac");
                if (flag == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u3010\u9700\u6c42\u4f18\u5148\u7ea7\u7ec4\u3011\u7684\u3010\u65b0\u589e\u3011\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"DemandPriorityListPlugin_69", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.addNewTree();
            } else if ("btnedit".equals(key)) {
                RequestContext request = RequestContext.get();
                int flag = PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (Long)this.getDemandOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND_GROUP, (String)"4715a0df000000ac");
                if (flag == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u3010\u9700\u6c42\u4f18\u5148\u7ea7\u7ec4\u3011\u7684\u3010\u4fee\u6539\u3011\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"DemandPriorityListPlugin_70", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                String id = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
                if (this.checkTreeNode(id, false, this.getView(), this.getModel())) {
                    this.editGroupNode(id, (TreeView)this.getControl(TREE_VIEW), this.getView(), this.getModel());
                }
            } else if ("btndel".equals(key)) {
                RequestContext request = RequestContext.get();
                int flag = PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (Long)this.getDemandOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND_GROUP, (String)"4715e1f1000000ac");
                if (flag == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u5bf9\u8c61\u3010\u9700\u6c42\u4f18\u5148\u7ea7\u7ec4\u3011\u7684\u3010\u5220\u9664\u3011\u64cd\u4f5c\u7684\u529f\u80fd\u6743\u9650\u3002", (String)"DemandPriorityListPlugin_71", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    return;
                }
                String id = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
                if (this.checkTreeNode(id, true, this.getView(), this.getModel())) {
                    this.deleteTreeNode(id, this.getView());
                }
            }
        }
    }

    public DynamicObject getDemandGroupByTreeNodeId(String treeNodeId) {
        QFilter qfilter = new QFilter(ID, "=", (Object)Long.valueOf(treeNodeId));
        return QueryServiceHelper.queryOne((String)DEMAND_GROUP, (String)NAME, (QFilter[])new QFilter[]{qfilter});
    }

    public void deleteTreeNode(String id, IFormView view) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CONFIRM_DELETE, (IFormPlugin)this);
        DynamicObject demand = this.getDemandGroupByTreeNodeId(id);
        if (demand == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u4e2d\u7684\u6570\u636e\u5df2\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5de6\u6811\u3002", (String)"DemandPriorityListPlugin_72", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        String strs = String.format(ResManager.loadKDString((String)"\u60a8\u786e\u8ba4\u5220\u9664\u9700\u6c42\u4f18\u5148\u7ea7\u5206\u7ec4[%s]\u5417\uff1f", (String)"DemandPriorityListPlugin_26", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), demand.getString(NAME));
        view.showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void delTreeNode(String nodeId) {
        TreeView tree = (TreeView)this.getControl(TREE_VIEW);
        tree.deleteNode(nodeId);
        String cache = this.getCache(CACHE_ROOT);
        if (cache != null) {
            RefObject ref = new RefObject();
            TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)cache);
            this.dfs(null, root, (iter, n) -> {
                if (iter != null && n.getId().equals(nodeId)) {
                    iter.remove();
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }, (RefObject<TreeNode>)ref);
            this.putCache(CACHE_ROOT, SerializationUtils.serializeToBase64((Object)root));
            if (ref.argvalue != null) {
                tree.updateNode((TreeNode)ref.argvalue);
            }
        }
    }

    private boolean isExistDataByGroup(long id, String groupid) {
        String checkSql = "select top 1 fid from t_mrp_" + id + " where fgroupid = '" + groupid + "' ";
        try (DataSet checkset = DB.queryDataSet((String)DemandPriorityListPlugin.class.getName(), (DBRoute)new DBRoute("scm"), (String)checkSql);){
            boolean bl = checkset.hasNext();
            return bl;
        }
    }

    public void confirmDeleteTreeNode(String currentTreeNodeId) {
        long pid = (Long)this.getModel().getValue(TYPE_ID);
        QFilter qfilter = new QFilter(PARENT, "=", (Object)Long.valueOf(currentTreeNodeId));
        DynamicObjectCollection demandColl = QueryServiceHelper.query((String)DEMAND_GROUP, (String)ID, (QFilter[])new QFilter[]{qfilter});
        if (!demandColl.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5f53\u524d\u9700\u6c42\u4f18\u5148\u7ea7\u5206\u7ec4\u8282\u70b9\u5b58\u5728\u4e0b\u7ea7\u8282\u70b9\uff0c\u6b64\u5904\u4e0d\u5141\u8bb8\u76f4\u63a5\u5220\u9664\u3002", (String)"DemandPriorityListPlugin_73", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        } else {
            QFilter filter = new QFilter(ID, "=", (Object)Long.valueOf(currentTreeNodeId));
            DeleteServiceHelper.delete((String)DEMAND_GROUP, (QFilter[])new QFilter[]{filter});
            DB.execute((DBRoute)new DBRoute("scm"), (String)("delete T_MRP_" + pid + " where fgroupid = '" + currentTreeNodeId + "'"));
            this.delTreeNode(currentTreeNodeId);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u5206\u7ec4\u8282\u70b9\u6210\u529f\u3002", (String)"DemandPriorityListPlugin_74", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            this.clearEntryData();
            this.clearDataChanged();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String currentTreeNodeId = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        switch (callBackId) {
            case "group_bar_del": {
                if (result != MessageBoxResult.Yes) break;
                this.confirmDeleteTreeNode(currentTreeNodeId);
                break;
            }
            case "isTreeNodeexists": {
                String oldNode;
                if (result == MessageBoxResult.Yes) {
                    this.putCache(CACHE_PRENODE, currentTreeNodeId);
                    this.getModel().setDataChanged(false);
                    this.clickTreeRoot(currentTreeNodeId);
                    break;
                }
                if (result != MessageBoxResult.Cancel || (oldNode = this.getPageCache().get(CACHE_PRENODE)) == null) break;
                TreeNode node = new TreeNode();
                node.setId(oldNode);
                TreeView view = (TreeView)this.getControl(TREE_VIEW);
                view.focusNode(node);
                break;
            }
            case "isexists": {
                if (result != MessageBoxResult.Yes) break;
                this.getView().close();
                break;
            }
            case "isRefresh": {
                if (result != MessageBoxResult.Yes) break;
                this.getModel().setDataChanged(false);
                this.clickTreeRoot(currentTreeNodeId);
            }
        }
    }

    public boolean checkTreeNode(String id, boolean flag, IFormView formView, IDataModel model) {
        long pid = (Long)model.getValue(TYPE_ID);
        if ("all".equals(id)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5bf9\u6839\u8282\u70b9\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"DemandPriorityListPlugin_75", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (StringUtils.isBlank((String)id) || id == null) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4e00\u4e2a\u6709\u6548\u7684\u6811\u5f62\u8282\u70b9\u3002", (String)"DemandPriorityListPlugin_76", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        if (flag && this.isExistDataByGroup(pid, id)) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u68c0\u6d4b\u5230\u5f53\u524d\u9700\u6c42\u4f18\u5148\u7ea7\u5206\u7ec4\u8282\u70b9\u5b58\u5728\u6709\u5bf9\u5e94\u7684\u9700\u6c42\u4f18\u5148\u7ea7\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"DemandPriorityListPlugin_77", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void editGroupNode(String currentNodeId, TreeView treeView, IFormView view, IDataModel model) {
        BillShowParameter formShowParameter = this.createFormShowParameter(currentNodeId);
        formShowParameter.setPkId((Object)this.getCurrentTreeNodeId(treeView));
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setCustomParam(OPERATE, (Object)"edit");
        DynamicObject obj = (DynamicObject)model.getValue(TYPE);
        formShowParameter.setCustomParam(CUSTOM_PRIORITY_ID, obj.get(ID));
        HashMap<String, String> parentInfo = new HashMap<String, String>(2);
        parentInfo.put("value", currentNodeId);
        formShowParameter.setCustomParam("tree_curr_id", parentInfo);
        try {
            view.showForm((FormShowParameter)formShowParameter);
        }
        catch (Exception e) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u9519\u8bef\u3002", (String)"DemandPriorityListPlugin_78", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    private BillShowParameter createFormShowParameter(String currentNodeId) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId(DEMAND_GROUP);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, CALLBACK_GROUPEDIT);
        formShowParameter.setCloseCallBack(callBack);
        formShowParameter.setCustomParam(ID, (Object)currentNodeId);
        return formShowParameter;
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String key = e.getItemKey();
        boolean dataChanged = this.getModel().getDataChanged();
        if (REFRESH.equals(key)) {
            if (this.getModel().getValue(TYPE) == null) {
                return;
            }
            if (dataChanged) {
                this.soutUnRefreshMessage(this.getView());
            } else {
                this.clickTreeRoot(this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW)));
            }
        } else if (dataChanged && "exit".equals(key)) {
            this.soutUnSaveMessage(this.getView());
        } else if ("exit".equals(key)) {
            this.getView().close();
        }
    }

    public void soutUnSaveMessage(IFormView view) {
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u5462\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DemandPriorityListPlugin_79", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(Confirm_Exist, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DemandPriorityListPlugin_100", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"DemandPriorityListPlugin_102", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        view.showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void soutUnRefreshMessage(IFormView view) {
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u7ee7\u7eed\u8fdb\u884c\u5237\u65b0\u7684\u64cd\u4f5c\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"DemandPriorityListPlugin_80", (String)"mmc-mrp-formplugin", (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(Confirm_Refresh, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"DemandPriorityListPlugin_100", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u7ee7\u7eed\u5237\u65b0", (String)"DemandPriorityListPlugin_103", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        view.showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private long getDemandOrgId() {
        if (this.getModel().getValue(DEMANDORG) != null) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(DEMANDORG);
            return org.getLong(ID);
        }
        return RequestContext.get().getOrgId();
    }

    private void addNewTree() {
        TreeView view = (TreeView)this.getControl(TREE_VIEW);
        TreeView.TreeState treeState = view.getTreeState();
        String selectNodeIds = treeState.getFocusNodeId();
        if (selectNodeIds == null) {
            selectNodeIds = "all";
        }
        String currentId = selectNodeIds;
        this.showDemandGroup(currentId);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CALLBACK_GROUPADD.equals(actionId) || CALLBACK_GROUPEDIT.equals(actionId)) {
            this.bindTreeByType();
        }
    }

    private void setEntryRowData(long id, String groupId) {
        String selectSql = this.getDataSetString(id, groupId);
        try (DataSet set = DB.queryDataSet((String)DemandPriorityListPlugin.class.getName(), (DBRoute)new DBRoute("scm"), (String)selectSql);){
            IDataModel model = this.getModel();
            EntryGrid gg = this.getEntryElement().getControl(this.getView());
            EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get(ENTRYENTITY);
            Map fields = entityType.getFields();
            String[] fieldNames = set.getRowMeta().getFieldNames();
            model.beginInit();
            for (Row row : set) {
                int ridx = model.createNewEntryRow(ENTRYENTITY);
                DynamicObject entryRowEntity = model.getEntryRowEntity(ENTRYENTITY, ridx);
                for (String fieldName : fieldNames) {
                    String name = fieldName.substring(1);
                    IDataEntityProperty prop = (IDataEntityProperty)fields.get(name);
                    if (prop instanceof BasedataProp) {
                        entryRowEntity.set(name + "_id", row.get(fieldName));
                        continue;
                    }
                    entryRowEntity.set(name, row.get(fieldName));
                }
                BusinessDataServiceHelper.loadRefence((Object[])new Object[]{entryRowEntity}, (IDataEntityType)entryRowEntity.getDataEntityType());
                BindingContext bindCtx = new BindingContext(entryRowEntity.getDataEntityType(), entryRowEntity, ridx);
                List rowValues = gg.getRowBindValue(bindCtx);
                IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
                proxy.appendRow(ENTRYENTITY, rowValues);
            }
            model.endInit();
        }
    }

    private String getDataSetString(long typeId, String groupId) {
        StringBuilder selectSql = new StringBuilder("select fid,fweight,fgroupid");
        QFilter qfilter = new QFilter(ID, "=", (Object)typeId);
        DynamicObjectCollection pricoll = QueryServiceHelper.query((String)TYPE_ENTITY, (String)"entryentity.*,entryentity.elementobject.*", (QFilter[])new QFilter[]{qfilter}, (String)"entryentity.seq asc");
        Iterator priIts = pricoll.iterator();
        int i = 0;
        while (priIts.hasNext()) {
            DynamicObject priority = (DynamicObject)priIts.next();
            String type = priority.getString("entryentity.elementtype");
            if ("0".equals(type)) {
                selectSql.append(",fstartnumber").append(i);
                selectSql.append(",fendnumber").append(i);
                selectSql.append(",fmaterial").append(i);
            } else if ("1".equals(type)) {
                selectSql.append(",fstartdate").append(i);
                selectSql.append(",fenddate").append(i);
                selectSql.append(",fcombounit").append(i);
            } else if ("2".equals(type)) {
                selectSql.append(",fpriority").append(i);
            }
            ++i;
        }
        selectSql.append(" from T_MRP_").append(typeId);
        if (groupId != null && !"all".equals(groupId)) {
            selectSql.append(" where fgroupid = '").append(groupId).append("' order by fweight asc");
        } else {
            selectSql.append(" order by fweight asc");
        }
        return selectSql.toString();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultOrg();
    }

    private void setDefaultOrg() {
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        Set planViewOrgs = PlanViewOrgHelper.getOrgIdsByPlanView();
        long orgid = RequestContext.get().getOrgId();
        if (!orgIds.isEmpty()) {
            RequestContext request = RequestContext.get();
            int flag = PermissionServiceHelper.checkPermission((Long)request.getCurrUserId(), (Long)request.getOrgId(), (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND, (String)"47150e89000000ac");
            if (flag != 0 && planViewOrgs.contains(orgid)) {
                this.getModel().setValue(DEMANDORG, (Object)orgid);
            } else {
                this.getModel().setValue(DEMANDORG, orgIds.get(0));
            }
        } else if (result.hasAllOrgPerm() && planViewOrgs.contains(orgid)) {
            this.getModel().setValue(DEMANDORG, (Object)orgid);
        }
    }

    private void showDemandGroup(String currentNodeId) {
        BillShowParameter form = new BillShowParameter();
        form.setFormId(DEMAND_GROUP);
        form.getOpenStyle().setShowType(ShowType.Modal);
        if (this.getModel().getValue(TYPE) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f18\u5148\u7ea7\u7c7b\u578b\u3002", (String)"DemandPriorityListPlugin_81", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject obj = (DynamicObject)this.getModel().getValue(TYPE);
        form.setCustomParam(CUSTOM_PRIORITY_ID, obj.get(ID));
        if (!"all".equals(currentNodeId)) {
            form.setCustomParam(ID, (Object)currentNodeId);
        } else {
            form.setCustomParam(ID, (Object)0);
        }
        form.setCustomParam(OPERATE, (Object)"addnew");
        form.setCustomParam("createorg", (Object)this.getDemandOrgId());
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_GROUPADD));
        this.getView().showForm((FormShowParameter)form);
    }

    public void getEntityType(GetEntityTypeEventArgs e) {
        MainEntityType newMainType;
        MainEntityType oldMainType = e.getOriginalEntityType();
        try {
            newMainType = (MainEntityType)oldMainType.clone();
        }
        catch (CloneNotSupportedException exp) {
            throw new KDException((Throwable)exp, new ErrorCode("LoadCustomControlMetasSample", exp.getMessage()), new Object[0]);
        }
        EntryType entryType = (EntryType)newMainType.getAllEntities().get(ENTRYENTITY);
        this.getEntryElement().registerEntryProp(entryType);
        e.setNewEntityType(newMainType);
    }

    public void onGetControl(OnGetControlArgs e) {
        EntryElement entryElement = this.getEntryElement();
        ArrayList<EntryElement> items = new ArrayList<EntryElement>(entryElement.getItems());
        items.add(entryElement);
        Optional<Element> first = items.stream().filter(x -> x.getName().equals(e.getKey())).findFirst();
        if (first.isPresent()) {
            Element element = first.get();
            Control control = element.getControl(this.getView());
            if (control instanceof BasedataEdit && this.isTreeRoot()) {
                ((BasedataEdit)control).setF7MultipleSelect(false);
            }
            e.setControl(control);
        }
    }

    private boolean isTreeRoot() {
        String treeNodeId = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
        return treeNodeId == null || treeNodeId.equals("") || treeNodeId.equals("all");
    }

    private List<Element> getElementList(Object typeId) {
        ArrayList<Element> result = new ArrayList<Element>();
        QFilter qfilter = new QFilter(ID, "=", typeId);
        DynamicObjectCollection pricoll = QueryServiceHelper.query((String)TYPE_ENTITY, (String)"entryentity.*,entryentity.elementobject.*", (QFilter[])new QFilter[]{qfilter}, (String)"entryentity.seq asc");
        if (pricoll.size() == 0) {
            return result;
        }
        LongElement grp = new LongElement(GROUPID, ResManager.loadKDString((String)"\u9700\u6c42\u4f18\u5148\u7ea7\u7ec4", (String)"DemandPriorityListPlugin_82", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ENTRYENTITY);
        FieldAp fieldAp = grp.getFieldAp();
        fieldAp.setLock("new,edit");
        fieldAp.setHidden(true);
        DecimalElement wtEle = new DecimalElement(WEIGHT, ResManager.loadKDString((String)"\u6743\u91cd", (String)"DemandPriorityListPlugin_104", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ENTRYENTITY);
        result.add((Element)grp);
        result.add((Element)wtEle);
        block10: for (int i = 0; i < pricoll.size(); ++i) {
            DynamicObject pri = (DynamicObject)pricoll.get(i);
            String elementname = pri.getString("entryentity.elementname");
            String type = pri.getString("entryentity.elementtype");
            String entityId = null;
            if (pri.get("entryentity.elementobject.id") != null) {
                entityId = pri.getString("entryentity.elementobject.id");
            }
            switch (type) {
                case "0": {
                    result.add((Element)new BaseDataElement("material" + i, String.format(ResManager.loadKDString((String)"%s_\u7269\u6599", (String)"DemandPriorityListPlugin_105", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname), "bd_material"));
                    result.add((Element)new DecimalElement("startnumber" + i, String.format(ResManager.loadKDString((String)"%s_\u5f00\u59cb\u6570\u91cf", (String)"DemandPriorityListPlugin_106", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname)));
                    result.add((Element)new DecimalElement("endnumber" + i, String.format(ResManager.loadKDString((String)"%s_\u7ed3\u675f\u6570\u91cf", (String)"DemandPriorityListPlugin_107", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname)));
                    continue block10;
                }
                case "1": {
                    result.add((Element)this.getComboEle(i, elementname));
                    result.add((Element)new IntegerElement("startdate" + i, String.format(ResManager.loadKDString((String)"%s_\u5f00\u59cb\u5468\u671f", (String)"DemandPriorityListPlugin_108", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname)));
                    result.add((Element)new IntegerElement("enddate" + i, String.format(ResManager.loadKDString((String)"%s_\u7ed3\u675f\u5468\u671f", (String)"DemandPriorityListPlugin_109", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname)));
                    continue block10;
                }
                case "2": {
                    result.add((Element)new BaseDataElement("priority" + i, elementname, entityId));
                }
            }
        }
        return result;
    }

    private ComboElement getComboEle(int i, String elementname) {
        ComboElement ele = new ComboElement("combounit" + i, String.format(ResManager.loadKDString((String)"%s_\u5468\u671f\u5355\u4f4d", (String)"DemandPriorityListPlugin_110", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), elementname), ENTRYENTITY);
        ComboField field = ele.getField();
        this.addDefaultEnums(field);
        ComboProp prop = ele.getProperty();
        this.setEnumList(prop);
        return ele;
    }

    private void addDefaultEnums(ComboField combo) {
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(3);
        list.add(new ComboItem(1, new LocaleString(ResManager.loadKDString((String)"\u5929", (String)"DemandPriorityListPlugin_111", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), "day"));
        list.add(new ComboItem(2, new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"DemandPriorityListPlugin_112", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), "month"));
        list.add(new ComboItem(3, new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"DemandPriorityListPlugin_113", (String)"mmc-mrp-formplugin", (Object[])new Object[0])), "year"));
        combo.setItems(list);
    }

    private void setEnumList(ComboProp unit) {
        ArrayList<ValueMapItem> list = new ArrayList<ValueMapItem>(3);
        list.add(new ValueMapItem(null, "day", new LocaleString(ResManager.loadKDString((String)"\u5929", (String)"DemandPriorityListPlugin_111", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))));
        list.add(new ValueMapItem(null, "month", new LocaleString(ResManager.loadKDString((String)"\u6708", (String)"DemandPriorityListPlugin_112", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))));
        list.add(new ValueMapItem(null, "year", new LocaleString(ResManager.loadKDString((String)"\u5e74", (String)"DemandPriorityListPlugin_113", (String)"mmc-mrp-formplugin", (Object[])new Object[0]))));
        unit.setComboItems(list);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (TYPE.equals(name)) {
            this.clearEntryData();
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            long id = newValue == null ? 0L : newValue.getLong(ID);
            List<Element> elementList = this.getElementList(id);
            this.cacheEntryElement(elementList);
            this.build();
            this.bindTreeByType();
            this.clearDataChanged();
        } else if (DEMANDORG.equals(name)) {
            this.getModel().setValue(TYPE, null);
        }
    }

    public void clickTreeRoot(String nodeId) {
        TreeView view = (TreeView)this.getControl(TREE_VIEW);
        view.addTreeNodeClickListener((TreeNodeClickListener)this);
        view.treeNodeClick("all", nodeId);
    }

    public void build() {
        this.getEntryElement().build(this.getView());
    }

    private EntryElement cacheEntryElement(List<Element> elementList) {
        EntryElement entryElement = new EntryElement(ENTRYENTITY);
        entryElement.setItems(elementList);
        String s = SerializationUtils.serializeToBase64((Object)entryElement);
        this.putCache("entry_element", s);
        return entryElement;
    }

    private EntryElement getEntryElement() {
        String elements = this.getCache("entry_element");
        if (elements == null) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            return this.cacheEntryElement(elementList);
        }
        return (EntryElement)SerializationUtils.deSerializeFromBase64((String)elements);
    }

    private void bindTreeByType() {
        if (this.getModel().getValue(TYPE) != null) {
            long id = (Long)this.getModel().getValue(TYPE_ID);
            TreeView tree = (TreeView)this.getControl(TREE_VIEW);
            tree.deleteAllNodes();
            TreeNode root = this.createRoot(tree);
            this.genRootChildren(id, root);
            this.putCache(CACHE_ROOT, SerializationUtils.serializeToBase64((Object)root));
            String preNodeId = this.getCache(CACHE_PRENODE);
            if (preNodeId == null) {
                tree.expand(root.getId());
            } else {
                TreeNode node = new TreeNode();
                node.setId(preNodeId);
                tree.focusNode(node);
                List<String> parentIds = this.getParentIds(root, preNodeId);
                for (String parentId : parentIds) {
                    tree.expand(parentId);
                }
            }
        } else {
            TreeView tree = (TreeView)this.getControl(TREE_VIEW);
            tree.deleteAllNodes();
        }
    }

    private List<String> getParentIds(TreeNode root, String nodeId) {
        ArrayList<String> result = new ArrayList<String>(5);
        boolean[] b = new boolean[]{true};
        this._getParentIds(root, nodeId, result, b);
        return result;
    }

    private void _getParentIds(TreeNode root, String nodeId, List<String> result, boolean[] flag) {
        String id = root.getId();
        if (nodeId.equals(id)) {
            flag[0] = false;
            return;
        }
        result.add(id);
        List children = root.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this._getParentIds(child, nodeId, result, flag);
            }
        }
        if (flag[0]) {
            result.remove(id);
        }
    }

    private void genRootChildren(long type, TreeNode root) {
        DynamicObjectCollection treeGrp = this.getTreeGrpByType(type);
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)treeGrp.size());
        for (DynamicObject dyn : treeGrp) {
            TreeNode node = new TreeNode();
            node.setId(dyn.getString(ID));
            node.setText(dyn.getString(NAME));
            node.setParentid(dyn.getLong(PARENT) == 0L ? root.getId() : dyn.getString(PARENT));
            idMap.put(node.getId(), node);
        }
        for (TreeNode node : idMap.values()) {
            String pid = node.getParentid();
            TreeNode pnode = (TreeNode)idMap.get(pid);
            if (pnode == null) {
                root.addChild(node);
                continue;
            }
            pnode.addChild(node);
        }
    }

    private DynamicObjectCollection getTreeGrpByType(long id) {
        QFilter filter = new QFilter("prioritytype.id", "=", (Object)id);
        return QueryServiceHelper.query((String)DEMAND_GROUP, (String)"id,level,name,parent,parent.name,prioritytype", (QFilter[])new QFilter[]{filter}, (String)"level asc");
    }

    private TreeNode createRoot(TreeView tree) {
        TreeNode root = new TreeNode();
        root.setId("all");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"DemandPriorityListPlugin_10", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        tree.addNode(root);
        tree.setMulti(false);
        return root;
    }

    private String listToSql(List<Long> list) {
        StringBuilder sql = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                sql.append(list.get(i));
                continue;
            }
            sql.append(',').append(list.get(i));
        }
        return sql.toString();
    }

    private long autoGenId() {
        return ORM.create().genLongId(DEMAND);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        Object source = e.getSource();
        if (source instanceof DeleteEntry) {
            IDataModel model = this.getModel();
            EntryGrid entry = (EntryGrid)this.getView().getControl(ENTRYENTITY);
            int[] rows = entry.getSelectRows();
            ArrayList<Long> dels = new ArrayList<Long>();
            DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
            for (int row : rows) {
                DynamicObject dyn = (DynamicObject)entryEntity.get(row);
                long id = dyn.getLong(ID);
                if (id == 0L) continue;
                dels.add(id);
            }
            this.cacheDelRows(dels);
        } else if (source instanceof NewEntry && this.isTreeRoot()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f18\u5148\u7ea7\u5206\u7ec4\u3002", (String)"DemandPriorityListPlugin_83", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    private void cacheDelRows(List<Long> dels) {
        if (dels.isEmpty()) {
            return;
        }
        String cache = this.getCache(CACHE_DELROWS);
        if (cache != null) {
            List rmvs = (List)SerializationUtils.deSerializeFromBase64((String)cache);
            dels.addAll(rmvs);
        }
        this.putCache(CACHE_DELROWS, SerializationUtils.serializeToBase64(dels));
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("save".equals(operateKey)) {
            if (e.getOperationResult().isSuccess()) {
                this.saveData();
            }
        } else if ("newentry".equals(operateKey)) {
            DynamicObject dynamicObject = this.getModel().getEntryRowEntity(ENTRYENTITY, this.getModel().getEntryCurrentRowIndex(ENTRYENTITY));
            dynamicObject.getDataEntityState().setBizChanged(true);
        }
    }

    private Object getWeightByGrpId(long grpId) {
        QFilter qfilter = new QFilter(ID, "=", (Object)grpId);
        DynamicObject demand = BusinessDataServiceHelper.loadSingleFromCache((String)DEMAND_GROUP, (QFilter[])new QFilter[]{qfilter});
        return demand.get(WEIGHT);
    }

    private void saveData() {
        long value = (Long)this.getModel().getValue(TYPE_ID);
        if (value == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f18\u5148\u7ea7\u7c7b\u578b\u3002", (String)"DemandPriorityListPlugin_68", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        long typeId = (Long)this.getModel().getValue(TYPE_ID);
        String table = "T_MRP_" + typeId;
        IDataModel model = this.getModel();
        EntityType entityType = (EntityType)model.getDataEntityType().getAllEntities().get(ENTRYENTITY);
        DataEntityPropertyCollection properties = entityType.getProperties();
        DynamicObjectCollection entryEntity = model.getEntryEntity(ENTRYENTITY);
        if (!this.checkSaveData(entryEntity)) {
            return;
        }
        StringBuilder sb = new StringBuilder("insert into ");
        sb.append(table).append(" (");
        StringBuilder params = new StringBuilder("(");
        int len = 0;
        for (IDataEntityProperty prop : properties) {
            String name = prop.getName();
            if (name.equals("seq") || name.endsWith("_id")) continue;
            if (len == 0) {
                sb.append('f').append(name);
                params.append('?');
                ++len;
                continue;
            }
            sb.append(",f").append(name);
            params.append(",?");
            ++len;
        }
        params.append(')');
        sb.append(')').append(" values ").append((CharSequence)params);
        String sql = sb.toString();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        ArrayList<Long> rmvIds = new ArrayList<Long>();
        for (DynamicObject dyn : entryEntity) {
            if (!dyn.getDataEntityState().isChanged()) continue;
            Object[] values = new Object[len];
            int i = 0;
            for (IDataEntityProperty prop : properties) {
                String name = prop.getName();
                if (name.equals("seq") || name.endsWith("_id")) continue;
                Object val = prop.getValueFast((Object)dyn);
                if (ID.equals(name)) {
                    if (val == null || (Long)val == 0L) {
                        val = this.autoGenId();
                        prop.setValue((Object)dyn, val);
                    } else {
                        rmvIds.add((Long)val);
                    }
                } else if (prop instanceof BasedataProp) {
                    val = val == null ? Long.valueOf(0L) : ((DynamicObject)val).getPkValue();
                }
                values[i++] = val;
            }
            list.add(values);
        }
        try (TXHandle h = TX.required();){
            try {
                rmvIds.addAll(this.getDeletedIds());
                if (!rmvIds.isEmpty()) {
                    String deleteSql = "delete T_MRP_" + typeId + " where fid in(" + this.listToSql(rmvIds) + ')';
                    DB.execute((DBRoute)new DBRoute("scm"), (String)deleteSql);
                }
                if (!list.isEmpty()) {
                    DB.executeBatch((DBRoute)new DBRoute("scm"), (String)sql, list);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.putCache(CACHE_DELROWS, null);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"DemandPriorityListPlugin_84", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        this.getModel().setDataChanged(false);
    }

    private List<Long> getDeletedIds() {
        String cache = this.getCache(CACHE_DELROWS);
        List<Long> dels = new ArrayList<Long>(8);
        if (cache != null) {
            dels = (List)SerializationUtils.deSerializeFromBase64((String)cache);
        }
        return dels;
    }

    private boolean checkSaveData(DynamicObjectCollection entity) {
        Object result;
        String[] fieldNames;
        long value = (Long)this.getModel().getValue(TYPE_ID);
        String selectSql = this.getDataSetString(value, "all");
        HashMap<List, List> oldDataMap = new HashMap<List, List>();
        List<Long> deletedIds = this.getDeletedIds();
        String srcCombo = null;
        List changedDyns = entity.stream().filter(x -> x.getDataEntityState().isChanged()).collect(Collectors.toList());
        List changedIds = changedDyns.stream().map(x -> x.getLong(ID)).collect(Collectors.toList());
        DataSet ds = DB.queryDataSet((String)DemandPriorityListPlugin.class.getName(), (DBRoute)new DBRoute("scm"), (String)selectSql);
        Object object = null;
        try {
            fieldNames = ds.getRowMeta().getFieldNames();
            for (Row row : ds) {
                Long id = row.getLong("fid");
                if (deletedIds.contains(id) || changedIds.contains(id)) continue;
                Range range = new Range();
                range.id = id;
                range.grp = row.getLong("fgroupid");
                ArrayList grps = new ArrayList();
                for (String fieldName : fieldNames) {
                    if (fieldName.contains("material")) {
                        range.material = row.getLong(fieldName);
                        range.startNum = row.getBigDecimal(fieldName.replace("material", "startnumber"));
                        range.endNum = row.getBigDecimal(fieldName.replace("material", "endnumber"));
                        grps.add(range.material);
                        continue;
                    }
                    if (fieldName.contains("combounit")) {
                        range.combo = row.getString(fieldName);
                        range.startDate = row.getInteger(fieldName.replace("combounit", "startdate"));
                        range.endDate = row.getInteger(fieldName.replace("combounit", "enddate"));
                        if (srcCombo != null) continue;
                        srcCombo = range.combo;
                        continue;
                    }
                    if (!fieldName.contains("priority")) continue;
                    grps.add(row.getLong(fieldName));
                }
                oldDataMap.computeIfAbsent(grps, k -> new ArrayList(2)).add(range);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        Map idToDyns = entity.stream().collect(Collectors.toMap(x -> x.getLong(ID), Function.identity(), (a, b) -> a));
        for (List ranges : oldDataMap.values()) {
            for (Range range : ranges) {
                range.dyn = (DynamicObject)idToDyns.get(range.id);
            }
        }
        HashMap<List, List> newDataMap = new HashMap<List, List>();
        long fakeId = 1L;
        boolean hasMaterial = false;
        boolean hasDate = false;
        for (Object dyn : changedDyns) {
            long l;
            long l2 = dyn.getLong(ID);
            Range range = new Range();
            range.dyn = (DynamicObject)dyn;
            if (l2 == 0L) {
                long l3 = fakeId;
                l = l3;
                fakeId = l3 + 1L;
            } else {
                l = l2;
            }
            range.id = l;
            ArrayList<Long> grps = new ArrayList<Long>();
            for (String fieldName : fieldNames) {
                if ((fieldName = fieldName.substring(1)).contains("material")) {
                    range.material = dyn.getLong(fieldName + "_id");
                    range.startNum = dyn.getBigDecimal(fieldName.replace("material", "startnumber"));
                    range.endNum = dyn.getBigDecimal(fieldName.replace("material", "endnumber"));
                    grps.add(range.material);
                    hasMaterial = true;
                    continue;
                }
                if (fieldName.contains("combounit")) {
                    range.combo = dyn.getString(fieldName);
                    range.startDate = dyn.getInt(fieldName.replace("combounit", "startdate"));
                    range.endDate = dyn.getInt(fieldName.replace("combounit", "enddate"));
                    hasDate = true;
                    if (srcCombo != null) continue;
                    srcCombo = range.combo;
                    continue;
                }
                if (fieldName.contains(GROUPID)) {
                    range.grp = dyn.getLong(fieldName);
                    continue;
                }
                if (!fieldName.contains("priority")) continue;
                grps.add(dyn.getLong(fieldName + "_id"));
            }
            newDataMap.computeIfAbsent(grps, k -> new ArrayList(2)).add(range);
        }
        ArrayList<Range> errList = new ArrayList<Range>(4);
        for (List list : newDataMap.values()) {
            for (Range range : list) {
                int seq = range.dyn.getInt("seq");
                StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u5206\u5f55\u884c", (String)"DemandPriorityListPlugin_85", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                sb.append(seq).append('\uff1a');
                int length = sb.length();
                if (hasDate) {
                    if (!range.combo.equals(srcCombo)) {
                        sb.append(ResManager.loadKDString((String)"\u5468\u671f\u5355\u4f4d\u4e0d\u4e00\u81f4\u3002", (String)"DemandPriorityListPlugin_86", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                    if (range.startDate > range.endDate) {
                        sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u5468\u671f\u5927\u4e8e\u7ed3\u675f\u5468\u671f\u3002", (String)"DemandPriorityListPlugin_87", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                    }
                }
                if (hasMaterial && range.startNum.compareTo(range.endNum) > 0) {
                    sb.append(ResManager.loadKDString((String)"\u5f00\u59cb\u6570\u91cf\u5927\u4e8e\u7ed3\u675f\u6570\u91cf\u3002", (String)"DemandPriorityListPlugin_88", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                }
                if (sb.length() <= length) continue;
                range.errInfo = sb.toString();
                errList.add(range);
            }
        }
        if (!errList.isEmpty()) {
            result = this.getOpResult(errList);
            this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u6570\u636e\u6821\u9a8c\u9519\u8bef\u3002", (String)"DemandPriorityListPlugin_89", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (List list : newDataMap.values()) {
            int size = list.size();
            for (int i = 0; i < size - 1; ++i) {
                Range range = (Range)list.get(i);
                List<Range> subRanges = list.subList(i + 1, size);
                errList.addAll(this.checkRanges(Collections.singletonList(range), subRanges, hasMaterial, hasDate));
            }
        }
        if (!errList.isEmpty()) {
            result = this.getOpResult(errList);
            this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u6539\u52a8\u6570\u636e\u91cd\u590d\u3002", (String)"DemandPriorityListPlugin_90", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        for (Map.Entry entry : newDataMap.entrySet()) {
            List key = (List)entry.getKey();
            List ranges = (List)entry.getValue();
            List destRanges = (List)oldDataMap.get(key);
            if (destRanges == null) continue;
            errList.addAll(this.checkRanges(ranges, destRanges, hasMaterial, hasDate));
        }
        if (!errList.isEmpty()) {
            result = this.getOpResult(errList);
            this.getView().showOperationResult((OperationResult)result, ResManager.loadKDString((String)"\u539f\u59cb\u6570\u636e\u91cd\u590d\u3002", (String)"DemandPriorityListPlugin_91", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private OperationResult getOpResult(List<Range> errList) {
        OperationResult result = new OperationResult();
        ArrayList<OperateErrorInfo> errInfos = new ArrayList<OperateErrorInfo>(errList.size());
        for (Range range : errList) {
            OperateErrorInfo info = new OperateErrorInfo();
            info.setMessage(range.errInfo);
            info.setErrorLevel(ErrorLevel.Error.name());
            errInfos.add(info);
        }
        result.setAllErrorInfo(errInfos);
        return result;
    }

    private List<Range> checkRanges(List<Range> srcRange, List<Range> destRange, boolean hasMaterial, boolean hasDate) {
        ArrayList<Range> list = new ArrayList<Range>(4);
        for (Range src : srcRange) {
            StringBuilder msb = new StringBuilder();
            ArrayList<Range> mlist = new ArrayList<Range>(destRange.size());
            for (Range dest : destRange) {
                if (src.id == dest.id || hasMaterial && !this.isIntersect(src.startNum, src.endNum, dest.startNum, dest.endNum) || hasDate && !this.isIntersect(src.startDate, src.endDate, dest.startDate, dest.endDate)) continue;
                mlist.add(dest);
            }
            if (mlist.isEmpty()) continue;
            int seq = src.dyn.getInt("seq");
            ArrayList<Integer> seqLst = new ArrayList<Integer>(8);
            ArrayList<Long> grpLst = new ArrayList<Long>(8);
            for (Range range : mlist) {
                if (range.dyn != null) {
                    seqLst.add(range.dyn.getInt("seq"));
                    continue;
                }
                grpLst.add(range.grp);
            }
            msb.append(ResManager.loadKDString((String)"\u5206\u5f55", (String)"DemandPriorityListPlugin_92", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(seq).append(ResManager.loadKDString((String)"\u884c\uff1a", (String)"DemandPriorityListPlugin_93", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            if (!seqLst.isEmpty()) {
                msb.append(ResManager.loadKDString((String)"\u4e0e\u5206\u5f55\u884c", (String)"DemandPriorityListPlugin_94", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(this.wrapList(seqLst)).append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u91cd\u53e0\u3002", (String)"DemandPriorityListPlugin_95", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            if (!grpLst.isEmpty()) {
                LinkedHashSet<Long> ids = new LinkedHashSet<Long>(grpLst);
                List<Object> grpNames = this.getGrpNames(ids, this.getModel());
                msb.append(ResManager.loadKDString((String)"\u4e0e\u4f18\u5148\u7ea7\u5206\u7ec4", (String)"DemandPriorityListPlugin_96", (String)"mmc-mrp-formplugin", (Object[])new Object[0])).append(this.wrapList(grpNames)).append(ResManager.loadKDString((String)"\u6570\u636e\u8303\u56f4\u91cd\u53e0\u3002", (String)"DemandPriorityListPlugin_95", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            }
            src.errInfo = msb.toString();
            list.add(src);
        }
        return list;
    }

    public List<Object> getGrpNames(Collection<Long> grpIds, IDataModel model) {
        long value = (Long)model.getValue(TYPE_ID);
        Map idToName = (Map)ThreadCache.get((Object)value, () -> {
            DynamicObjectCollection treeGrpByType = this.getTreeGrpByType(value);
            HashMap<Long, String> map = new HashMap<Long, String>(8);
            for (DynamicObject dyn : treeGrpByType) {
                long id = dyn.getLong(ID);
                String name = dyn.getString(NAME);
                map.put(id, name);
            }
            return map;
        });
        return grpIds.stream().map(x -> idToName.get(x) == null ? x.toString() : (String)idToName.get(x)).collect(Collectors.toList());
    }

    private <T> String wrapList(List<T> list) {
        String s = list.toString();
        return s.replace('[', '\u3010').replaceAll("]", "\u3011");
    }

    private <T extends Comparable<T>> boolean isIntersect(T s1, T e1, T s2, T e2) {
        if (s1.compareTo(s2) >= 0 && s1.compareTo(e2) <= 0) {
            return true;
        }
        if (e1.compareTo(s2) >= 0 && e1.compareTo(e2) <= 0) {
            return true;
        }
        return s1.compareTo(s2) < 0 && e1.compareTo(e2) > 0;
    }

    private String getCurrentTreeNodeId(TreeView view) {
        TreeView.TreeState treeState = view.getTreeState();
        return treeState.getFocusNodeId();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if (TYPE.equals(key)) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(DEMANDORG);
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u6c42\u7ec4\u7ec7\u3002", (String)"DemandPriorityListPlugin_97", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            } else {
                QFilter filter = new QFilter("createorg.id", "=", (Object)org.getLong(ID));
                ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
                indexParameter.getListFilterParameter().setFilter(filter);
            }
        } else if (DEMANDORG.equals(key)) {
            QFilter filter = new QFilter(ID, "in", (Object)PlanViewOrgHelper.getOrgIdsByPlanView());
            Long userid = RequestContext.get().getCurrUserId();
            HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userid, (String)this.getView().getFormShowParameter().getAppId(), (String)DEMAND, (String)"47150e89000000ac");
            if (!result.hasAllOrgPerm()) {
                filter.and(new QFilter(ID, "in", (Object)result.getHasPermOrgs()));
            }
            ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
            indexParameter.getListFilterParameter().setFilter(filter);
        }
    }

    public void search(SearchEnterEvent e) {
        String text = e.getText();
        TreeView view = (TreeView)this.getControl(TREE_VIEW);
        String curNodeId = this.getCurrentTreeNodeId((TreeView)this.getControl(TREE_VIEW));
        String cache = this.getCache(CACHE_ROOT);
        if (cache == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f13\u5b58\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u5de6\u6811\u3002", (String)"DemandPriorityListPlugin_98", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = (TreeNode)SerializationUtils.deSerializeFromBase64((String)cache);
        boolean[] start = new boolean[]{false};
        TreeNode[] result = new TreeNode[]{null};
        TreeNode[] first = new TreeNode[]{null};
        if (curNodeId == null) {
            start[0] = true;
        }
        this.dfs(root, (Consumer<TreeNode>)((Consumer)t -> {
            Boolean meet = null;
            if (first[0] == null && (meet = Boolean.valueOf(t.getText().toLowerCase().contains(text.toLowerCase()))).booleanValue()) {
                first[0] = t;
            }
            if (start[0] && result[0] == null) {
                if (meet == null) {
                    meet = t.getText().toLowerCase().contains(text.toLowerCase());
                }
                if (meet.booleanValue()) {
                    result[0] = t;
                }
            }
            if (t.getId().equals(curNodeId)) {
                start[0] = true;
            }
        }));
        TreeNode t2 = result[0];
        if (t2 != null || (t2 = first[0]) != null) {
            view.showNode(t2.getId());
            view.focusNode(t2);
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u641c\u7d22\u9879\u3002", (String)"DemandPriorityListPlugin_99", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
        }
    }

    private void dfs(TreeNode root, Consumer<TreeNode> consumer) {
        consumer.accept((Object)root);
        List children = root.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                this.dfs(child, consumer);
            }
        }
    }

    private void dfs(Iterator iter, TreeNode node, BiFunction<Iterator, TreeNode, Boolean> consumer, RefObject<TreeNode> ref) {
        List children;
        Boolean apply = consumer.apply(iter, node);
        if (apply.booleanValue() && (children = node.getChildren()) != null) {
            Iterator iterator = children.iterator();
            while (iterator.hasNext()) {
                TreeNode child = (TreeNode)iterator.next();
                this.dfs(iterator, child, consumer, ref);
            }
            if (node.getChildren().size() == 0) {
                node.setLeaf(true);
                node.setChildren(null);
                ref.argvalue = node;
            }
        }
    }

    private static class Range {
        private long id = 0L;
        private long grp = 0L;
        private Long material = 0L;
        private BigDecimal startNum;
        private BigDecimal endNum;
        private String combo;
        private int startDate = 0;
        private int endDate = 0;
        private DynamicObject dyn;
        private String errInfo;

        private Range() {
        }
    }
}

