/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.mpscmm.msplan.mrp.business.helper.ResourceFieldHelper;

public class FiledSetPlugin
extends AbstractBasePlugIn {
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String CONDITIONS = "conditions";
    private static final String BTNOK = "btnok";
    private static final String CLOSE = "btncancel";
    private static final String CAST = "cast";
    private static final String SRCBILLANDDESTBILLID = "srcbillAndDestbillId";
    private static final String CALLBACK_SOURCEFIELD = "sourcefieldcallback";
    private static final String FORMID_SELECTFIELD = "msplan_billfieldselect";
    private static final String CUSTPARAM_TREENODES = "treenodes";
    private static final String CACHE_SRCBILL_CAL = "cache_srcbilltree_cal";
    private static final String CALLBACK_CALTEXT = "caltextcallback";
    public static final String FormId_Formula = "botp_formula";
    public static final String CustParamKey_Formula = "formula";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String FIELD = "field";
    private static final String ISFLEXMETRIC = "isflexmetric";
    private static final String CALLBACK_FLEXMETRICDEFINE = "callback_flexmetricdefine";
    private static final String FLEX_TARGET = "flex_target";
    private String[] supportMethod = new String[]{"ROUND", "ABS", "INT", "STRING", "LEFT", "RIGHT", "LOWER", "UPPER", "CONCAT", "REPLACE", "LEN", "NOW", "TO_DATE", "DATE", "YMDDATE", "YEAR", "MONTH", "DAY", "QUARTER", "DATEDIF", "DATEADD", "TO_CHAR"};

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{NAME, CONDITIONS, BTNOK, CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Map<String, Object> cast = this.getCast();
        Object formula = cast.get(CustParamKey_Formula);
        Object formula_save = cast.get("formula_save");
        Object source = cast.get("source");
        if (formula_save != null || source != null) {
            if (formula != null && source != null) {
                if (formula_save != null) {
                    this.getPageCache().put(CONDITIONS, formula_save.toString());
                    this.getPageCache().put("conditions_old", formula_save.toString());
                }
                this.getModel().setValue(CONDITIONS, formula);
                String sources = source.toString();
                if (sources.contains(" ")) {
                    String[] split_e = sources.split(" ");
                    this.getModel().setValue(NAME, (Object)split_e[0]);
                    this.getModel().setValue(NUMBER, (Object)split_e[1]);
                    this.getPageCache().put(FIELD, sources);
                    this.getPageCache().put("field_old", sources);
                }
            } else if (formula_save == null) {
                String sources = source.toString();
                this.getPageCache().put(FIELD, sources);
                this.getPageCache().put("field_old", sources);
                if (sources.contains(" ")) {
                    String[] split_e = sources.split(" ");
                    this.getModel().setValue(NAME, (Object)split_e[0]);
                    this.getModel().setValue(NUMBER, (Object)split_e[1]);
                }
            } else if (formula_save != null) {
                this.getModel().setValue(CONDITIONS, source);
                this.getPageCache().put(CONDITIONS, formula_save.toString());
                this.getPageCache().put("conditions_old", formula_save.toString());
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if (NAME.equals(key)) {
            this.openFiledPage();
        } else if (CONDITIONS.equals(key)) {
            String formula = this.getPageCache().get(CONDITIONS);
            if (formula == null) {
                formula = "";
            }
            if (this.getView().getFormShowParameter().getCustomParam(ISFLEXMETRIC) != null) {
                if (this.getModel().getValue(NUMBER) == null || StringUtils.isBlank((Object)this.getModel().getValue(NUMBER))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u751f\u6548\u6761\u4ef6\u3002", (String)"FiledSetPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    return;
                }
                ListShowParameter para = ShowFormHelper.createShowListForm((String)"msplan_flexmetricdefine", (boolean)true);
                para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_FLEXMETRICDEFINE));
                this.getView().showForm((FormShowParameter)para);
            } else {
                this.openConditionsPage(formula);
            }
        } else if (BTNOK.equals(key)) {
            HashMap<String, String> returnMap = new HashMap<String, String>(8);
            String field = this.getPageCache().get(FIELD);
            String conditions = this.getPageCache().get(CONDITIONS);
            if (conditions == null || conditions.isEmpty()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FiledSetPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            }
            if (conditions != null) {
                returnMap.put(FIELD, field);
                returnMap.put(CONDITIONS, conditions);
                this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(returnMap));
            }
            this.getPageCache().put(CLOSE, "1");
            this.getView().close();
        } else if (CLOSE.equals(key)) {
            this.getView().close();
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        if (this.getPageCache().get(CLOSE) == null) {
            HashMap<String, String> returnMap = new HashMap<String, String>(8);
            String field = this.getPageCache().get("field_old");
            String conditions = this.getPageCache().get("conditions_old");
            returnMap.put(FIELD, field);
            returnMap.put(CONDITIONS, conditions);
            this.getView().returnDataToParent((Object)SerializationUtils.serializeToBase64(returnMap));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        String name = e.getProperty().getName();
        if (NAME.equals(name)) {
            if (newValue == null || newValue.toString().isEmpty()) {
                this.getModel().setValue(NUMBER, null);
                this.getPageCache().remove(FIELD);
            }
            if (this.getView().getFormShowParameter().getCustomParam(ISFLEXMETRIC) != null) {
                this.getModel().setValue(CONDITIONS, null);
                this.getPageCache().remove(CONDITIONS);
            }
        } else if (CONDITIONS.equals(name) && (newValue == null || newValue.toString().isEmpty())) {
            this.getPageCache().put("conditions_old", this.getPageCache().get(CONDITIONS));
            this.getPageCache().remove(CONDITIONS);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if (CALLBACK_SOURCEFIELD.equals(actionId)) {
            if (returnData != null && !StringUtils.isBlank((Object)returnData)) {
                String fieldId = (String)returnData;
                MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)this.getSrcbillAndDestbillId().split(",")[0]);
                String fieldCaption = BillFieldEntityHelper.buildPropFullCaption((EntityType)srcbillMainType, (String)fieldId);
                String name = fieldCaption + " " + fieldId;
                this.getPageCache().put(FIELD, name);
                this.getModel().setValue(NAME, (Object)fieldCaption);
                this.getModel().setValue(NUMBER, (Object)fieldId);
            }
        } else if (CALLBACK_CALTEXT.equals(actionId)) {
            if (returnData != null && !StringUtils.isBlank((Object)returnData)) {
                String fieldId = (String)returnData;
                CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)fieldId, CRFormula.class);
                this.getPageCache().put(CONDITIONS, fieldId);
                this.getModel().setValue(CONDITIONS, (Object)formula.getExprTran());
            }
        } else if (CALLBACK_FLEXMETRICDEFINE.equals(actionId) && returnData != null && ((ListSelectedRowCollection)returnData).size() > 0) {
            String[] entityFields;
            String entityField;
            String number = "flexmetricid";
            if (this.getModel().getValue(NUMBER) != null) {
                number = (String)this.getModel().getValue(NUMBER);
            }
            if (number.contains(".")) {
                String[] numbers = number.split("[.]");
                number = numbers[numbers.length - 1];
            }
            String target = "flexmetricid";
            if (this.getView().getFormShowParameter().getCustomParam(FLEX_TARGET) != null && StringUtils.isNotBlank((CharSequence)(target = (String)this.getView().getFormShowParameter().getCustomParam(FLEX_TARGET))) && (entityField = (entityFields = target.split(" "))[entityFields.length - 1]) != null && entityField.contains(".")) {
                String[] targets = entityField.split("[.]");
                target = targets[targets.length - 1];
            }
            CRFormula formula = new CRFormula();
            StringBuilder expr = new StringBuilder("\"ElasticMetricCmp(@requireData.");
            expr.append('#').append(number).append(", @supplyData.").append('#').append(target).append(", [");
            ListSelectedRowCollection datas = (ListSelectedRowCollection)returnData;
            for (int index = 0; index < datas.size(); ++index) {
                String billNo = datas.get(index).getNumber();
                if (index < datas.size() - 1) {
                    expr.append("'").append(billNo).append("'").append(',');
                    continue;
                }
                expr.append("'").append(billNo).append("'");
            }
            expr.append("], '-')\"");
            formula.setExprTran(expr.toString());
            formula.setExpression(expr.toString());
            formula.setDescription(new LocaleString(expr.toString()));
            String json = SerializationUtils.toJsonString((Object)formula);
            this.getModel().setValue(CONDITIONS, (Object)formula.getExprTran());
            this.getPageCache().put(CONDITIONS, json);
        }
    }

    public String getSrcbillAndDestbillId() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(SRCBILLANDDESTBILLID);
        if (customParam != null) {
            return customParam.toString();
        }
        return "";
    }

    public Map<String, Object> getCast() {
        Object customParam = this.getView().getFormShowParameter().getCustomParam(CAST);
        Map cast = null;
        if (customParam != null) {
            cast = (Map)SerializationUtils.deSerializeFromBase64((String)customParam.toString());
        }
        return cast;
    }

    private void openFiledPage() {
        this.openSrcBillFieldList(this.getCast());
    }

    private void openConditionsPage(String formula) {
        String nodesJson = this.getPageCache().get(CACHE_SRCBILL_CAL);
        String srcbillAndDestbillId = this.getSrcbillAndDestbillId();
        MainEntityType sourceMainType = MetadataServiceHelper.getDataEntityType((String)srcbillAndDestbillId.split(",")[0]);
        if (StringUtils.isBlank((CharSequence)nodesJson)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
            parameter.setIncludePKField(true);
            TreeNode billTreeNode = ResourceFieldHelper.buildCalTreeNodes((BillTreeBuildParameter)parameter);
            nodesJson = SerializationUtils.toJsonString((Object)billTreeNode);
            this.getPageCache().put(CACHE_SRCBILL_CAL, nodesJson);
            if (StringUtils.isBlank((CharSequence)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, sourceMainType.getName(), nodesJson, CALLBACK_CALTEXT);
        } else {
            if (StringUtils.isBlank((CharSequence)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, sourceMainType.getName(), nodesJson, CALLBACK_CALTEXT);
        }
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_Formula);
        showParameter.getCustomParams().put(CustParamKey_Formula, formulaJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = ResourceFieldHelper.getFuncsXML((String[])this.supportMethod);
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void openSrcBillFieldList(Map<String, Object> cast) {
        String srcbillAndDestbillId = this.getSrcbillAndDestbillId();
        if (!srcbillAndDestbillId.contains(",")) {
            return;
        }
        MainEntityType srcbillMainType = MetadataServiceHelper.getDataEntityType((String)srcbillAndDestbillId.split(",")[0]);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(srcbillMainType);
        parameter.setIncludePKField(true);
        parameter.setOnlyPhysicsField(true);
        String destfield = "";
        String source = cast.get("target").toString();
        String id = cast.get("id").toString();
        if (source != null) {
            destfield = source;
        }
        if (StringUtils.isBlank((CharSequence)destfield)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u76ee\u6807\u5b57\u6bb5\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u7f16\u8f91\u6e90\u5355\u5b57\u6bb5\u3002", (String)"FiledSetPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!StringUtils.isBlank((CharSequence)destfield)) {
            MainEntityType destbillMainType = MetadataServiceHelper.getDataEntityType((String)srcbillAndDestbillId.split(",")[1]);
            if (destfield.contains(".") && destfield.contains(" ")) {
                String[] split = destfield.split(" ");
                destfield = split[split.length - 1];
                String[] split_e = destfield.split("[.]");
                destfield = split_e[split_e.length - 1];
            }
            IDataEntityProperty property = destbillMainType.findProperty(destfield);
            parameter.setMatchedProperty(property);
        }
        TreeNode srcBillNode = BillFieldEntityHelper.buildBillTreeNodes((BillTreeBuildParameter)parameter, (String)srcbillMainType.getName());
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        this.showBillFieldForm(nodesJson, CALLBACK_SOURCEFIELD);
    }

    public void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FORMID_SELECTFIELD);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }
}

