/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.log4j.Logger;

public class PlanProgramShowBasePlugin
extends AbstractFormPlugin {
    private static final Logger logger = Logger.getLogger(PlanProgramShowBasePlugin.class);
    private static final String MRP_PLANPROGRAM = "mrp_planprogram";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String ORG = "org";
    private static final String NEWORGVALUE = "newOrgValue";
    private static final String CREATEORG = "createOrg";
    private static final String CTRLSTRATEGY = "ctrlstrategy";
    private static final String ISMPS = "ismps";
    private static final String ISMRP = "ismrp";
    private static final String ISREORDERPOINT = "isreorderpoint";
    private static final String HILOINV = "hiloinv";
    private static final String PLANTYPE = "plantype";
    private static final String BTNOK = "btnok";
    private static final String ID = "id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNOK});
    }

    public void afterCreateNewData(EventObject e) {
        Object message = this.getView().getFormShowParameter().getCustomParam("message");
        if (message != null) {
            this.setEditValue(message);
        } else {
            this.setOrgValue();
        }
    }

    private void setEditValue(Object message) {
        Map o = (Map)SerializationUtils.deSerializeFromBase64((String)message.toString());
        Object id = o.get(ID);
        if (id != null) {
            DynamicObject dyn = BusinessDataServiceHelper.loadSingle(id, (String)MRP_PLANPROGRAM);
            if (o.get("iscopy") != null && ((Boolean)o.get("iscopy")).booleanValue()) {
                dyn.set(NAME, null);
                dyn.set(NUMBER, null);
            }
            this.getModel().setValue(NAME, dyn.get(NAME));
            this.getModel().setValue(NUMBER, dyn.get(NUMBER));
            this.getModel().setValue(ORG, dyn.get(ORG));
            this.getModel().setValue(CTRLSTRATEGY, dyn.get(CTRLSTRATEGY));
            this.getModel().setValue(ISMPS, dyn.get(ISMPS));
            this.getModel().setValue(ISMRP, dyn.get(ISMRP));
            this.getModel().setValue(ISREORDERPOINT, dyn.get(ISREORDERPOINT));
            this.getModel().setValue(HILOINV, dyn.get(HILOINV));
            this.getModel().setValue("issimulation", dyn.get("issimulation"));
            this.getModel().setValue(PLANTYPE, (Object)PLANTYPE);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control con = (Control)evt.getSource();
        String key = con.getKey();
        if (BTNOK.equals(key)) {
            try {
                DynamicObject dyn = null;
                Object message = this.getView().getFormShowParameter().getCustomParam("message");
                if (message != null) {
                    Map o = (Map)SerializationUtils.deSerializeFromBase64((String)message.toString());
                    Object id = o.get(ID);
                    dyn = BusinessDataServiceHelper.loadSingle(id, (String)MRP_PLANPROGRAM);
                    if (id != null) {
                        if (o.get("iscopy") != null && ((Boolean)o.get("iscopy")).booleanValue()) {
                            CloneUtils cloneUtils = new CloneUtils(false, true);
                            dyn = (DynamicObject)cloneUtils.clone((IDataEntityBase)dyn);
                            if (!this.checkOnlyNumber(null)) {
                                return;
                            }
                            dyn.set(ID, (Object)DB.genGlobalLongId());
                            dyn.set("status", (Object)"A");
                        } else if (!this.checkOnlyNumber(id)) {
                            return;
                        }
                        this.setPlantypeValue();
                        dyn.set(NUMBER, this.getModel().getValue(NUMBER));
                        dyn.set(NAME, this.getModel().getValue(NAME));
                        dyn.set(ISMPS, this.getModel().getValue(ISMPS));
                        dyn.set(ISMRP, this.getModel().getValue(ISMRP));
                        dyn.set(ISREORDERPOINT, this.getModel().getValue(ISREORDERPOINT));
                        dyn.set(HILOINV, this.getModel().getValue(HILOINV));
                        dyn.set("issimulation", this.getModel().getValue("issimulation"));
                    }
                } else {
                    if (!this.checkOnlyNumber(null)) {
                        return;
                    }
                    dyn = this.newPlanprogram();
                }
                Object object = this.saveDny(dyn);
                if (object == null) {
                    return;
                }
                this.getView().returnDataToParent(object);
                this.getView().close();
            }
            catch (Exception ex) {
                logger.error((Object)("BTNOK" + ex));
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8ba1\u5212\u65b9\u6848\u4fdd\u5b58\u5931\u8d25:%s", (String)"PlanProgramShowBasePlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), ex.getMessage()));
            }
        }
    }

    private Object saveDny(DynamicObject dynamicObject) {
        Object[] save = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        return ((DynamicObject)save[0]).getPkValue();
    }

    private boolean checkOnlyNumber(Object id) {
        String number = (String)this.getModel().getValue(NUMBER);
        QFilter qFilter = new QFilter(NUMBER, "=", (Object)number);
        if (id != null) {
            qFilter.and(new QFilter(ID, "!=", id));
        }
        if (QueryServiceHelper.exists((String)MRP_PLANPROGRAM, (QFilter[])new QFilter[]{qFilter})) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7f16\u7801\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"PlanProgramShowBasePlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private DynamicObject newPlanprogram() {
        DynamicObject dyn = this.getDyn();
        long id = DB.genGlobalLongId();
        dyn.set(ID, (Object)id);
        dyn.set("masterid", (Object)id);
        dyn.set(NUMBER, this.getModel().getValue(NUMBER));
        dyn.set(NAME, this.getModel().getValue(NAME));
        Object org = this.getModel().getValue(ORG);
        dyn.set("createorg", org);
        dyn.set(ORG, org);
        dyn.set("planoutlook", (Object)0);
        dyn.set(ISMPS, this.getModel().getValue(ISMPS));
        dyn.set(ISMRP, this.getModel().getValue(ISMRP));
        dyn.set(ISREORDERPOINT, this.getModel().getValue(ISREORDERPOINT));
        dyn.set(HILOINV, this.getModel().getValue(HILOINV));
        dyn.set("issimulation", this.getModel().getValue("issimulation"));
        dyn.set("status", (Object)Character.valueOf('A'));
        dyn.set("enable", (Object)1);
        dyn.set(CTRLSTRATEGY, this.getModel().getValue(CTRLSTRATEGY));
        String userId = RequestContext.getOrCreate().getUserId();
        dyn.set("creator", (Object)userId);
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        dyn.set("modifier", (Object)userId);
        dyn.set("modifytime", (Object)TimeServiceHelper.now());
        dyn.set("type", (Object)Character.valueOf('A'));
        dyn.set("outofrange", (Object)Character.valueOf('A'));
        dyn.set("isnew", (Object)Boolean.TRUE);
        dyn.set("appmode", (Object)Character.valueOf('A'));
        dyn.set("computemode", (Object)Character.valueOf('A'));
        dyn.set("safestockeffectset", (Object)Character.valueOf('C'));
        dyn.set("scoutofdate", (Object)Character.valueOf('1'));
        dyn.set("outofdate", (Object)Character.valueOf('1'));
        dyn.set("adjusteffectset", (Object)Character.valueOf('A'));
        return dyn;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (ISMPS.equals(propertyName) || ISMRP.equals(propertyName) || ISREORDERPOINT.equals(propertyName) || HILOINV.equals(propertyName)) {
            this.setPlantypeValue();
        }
    }

    private void setPlantypeValue() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        boolean ismps = dataEntity.getBoolean(ISMPS);
        boolean ismrp = dataEntity.getBoolean(ISMRP);
        boolean isreorderpoint = dataEntity.getBoolean(ISREORDERPOINT);
        boolean hiloinv = dataEntity.getBoolean(HILOINV);
        if (ismps || ismrp || isreorderpoint || hiloinv) {
            this.getModel().setValue(PLANTYPE, (Object)PLANTYPE);
        } else {
            this.getModel().setValue(PLANTYPE, null);
        }
    }

    private void setCodeNumber(String useorg) {
        DynamicObject dyn = this.getDyn();
        String codeRuleNumber = CodeRuleServiceHelper.getNumber((String)MRP_PLANPROGRAM, (DynamicObject)dyn, (String)useorg);
        if (codeRuleNumber != null && !codeRuleNumber.isEmpty()) {
            this.getModel().setValue(NUMBER, (Object)codeRuleNumber);
        }
    }

    public DynamicObject getDyn() {
        return ORM.create().newDynamicObject(MRP_PLANPROGRAM);
    }

    private void setOrgValue() {
        String ctrlStrategy;
        String createOrg = null;
        String useorg = null;
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            String newOrgValue = this.getPageCache().get(NEWORGVALUE);
            if (StringUtils.isEmpty((CharSequence)newOrgValue)) {
                IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
                useorg = createOrg = pageCache.get(CREATEORG);
            } else {
                createOrg = newOrgValue;
                useorg = newOrgValue;
            }
        } else {
            useorg = createOrg = Long.toString(RequestContext.getOrCreate().getOrgId());
        }
        if (useorg != null) {
            this.setCodeNumber(useorg);
            this.getModel().setValue(ORG, (Object)useorg);
        }
        if (createOrg != null && createOrg.length() > 0 && StringUtils.isNotBlank((CharSequence)(ctrlStrategy = BaseDataServiceHelper.getBdCtrlStrgy((String)MRP_PLANPROGRAM, (String)createOrg)))) {
            this.setCtrlStrtgy(ctrlStrategy);
        }
    }

    private void setCtrlStrtgy(String ctrlStrategy) {
        String[] ctrlStrategyArr = ctrlStrategy.split(",");
        if (ctrlStrategyArr.length <= 1) {
            this.getModel().setValue(CTRLSTRATEGY, (Object)ctrlStrategy);
        } else {
            for (String ctr : ctrlStrategyArr) {
                if (!StringUtils.isNotEmpty((CharSequence)ctr)) continue;
                this.getModel().setValue(CTRLSTRATEGY, (Object)ctr);
                return;
            }
        }
    }
}

