/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PriorityGroupPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String CUSTOM_PRIORITY_ID = "priority_id";
    private static final String PRIORITYTYPE = "prioritytype";
    private static final String ID = "id";
    private static final String PARENT = "parent";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        if (this.getView().getFormShowParameter().getCustomParam(CUSTOM_PRIORITY_ID) != null) {
            Object id = this.getView().getFormShowParameter().getCustomParam(CUSTOM_PRIORITY_ID);
            Object groupid = this.getView().getFormShowParameter().getCustomParam(ID);
            Object orgid = this.getView().getFormShowParameter().getCustomParam("createorg");
            this.getModel().setValue(PARENT, groupid);
            this.getModel().setValue(PRIORITYTYPE, id);
            this.getModel().setValue("createorg", orgid);
            this.getView().setEnable(Boolean.FALSE, new String[]{PARENT});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl(PARENT);
        if (edit != null) {
            edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String propertyName = e.getProperty().getName();
        if (PARENT.equals(propertyName) && this.getView().getFormShowParameter().getCustomParam(CUSTOM_PRIORITY_ID) != null) {
            Object id = this.getView().getFormShowParameter().getCustomParam(CUSTOM_PRIORITY_ID);
            QFilter idfilter = new QFilter("prioritytype.id", "=", id);
            if (this.getView().getFormShowParameter().getCustomParam("tree_curr_id") != null) {
                Map map = (Map)this.getView().getFormShowParameter().getCustomParam("tree_curr_id");
                Long currentId = Long.valueOf((String)map.get("value"));
                QFilter currentFilter = new QFilter(ID, "!=", (Object)currentId);
                idfilter = idfilter.and(currentFilter);
                QFilter parentFiler = this.getParentFilter(id, currentId);
                if (parentFiler != null) {
                    idfilter = idfilter.and(parentFiler);
                }
            }
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().setFilter(idfilter);
        }
    }

    private QFilter getParentFilter(Object priorityId, Long currentId) {
        QFilter idfilter = new QFilter(PRIORITYTYPE, "=", priorityId);
        HashMap<Object, Node> map = new HashMap<Object, Node>(8);
        Throwable throwable = null;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"getParentFilter", (String)"mrp_demandpriority_group", (String)"id,parent", (QFilter[])new QFilter[]{idfilter}, null);){
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row d = (Row)iterator.next();
                Object id = d.get(ID);
                Object parent = d.get(PARENT);
                map.put(id, new Node(id, parent));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        for (Map.Entry entry : map.entrySet()) {
            Node node = (Node)entry.getValue();
            Node parent = (Node)map.get(node.parent);
            if (parent == null) continue;
            parent.addChild(node);
        }
        Node node = (Node)map.get(currentId);
        Set<Object> set = this.getAllChildren(node);
        if (set.isEmpty()) {
            return null;
        }
        return new QFilter(ID, "not in", set);
    }

    private Set<Object> getAllChildren(Node node) {
        HashSet<Object> result = new HashSet<Object>(2);
        if (node == null) {
            return result;
        }
        Set collect = node.children.stream().map(x -> x.id).collect(Collectors.toSet());
        result.addAll(collect);
        for (Node child : node.children) {
            result.addAll(this.getAllChildren(child));
        }
        return result;
    }

    private static class Node {
        Object id;
        Object parent;
        List<Node> children;

        Node(Object id, Object parent) {
            this.id = id;
            this.parent = parent;
            this.children = new ArrayList<Node>(4);
        }

        void addChild(Node node) {
            this.children.add(node);
        }
    }
}

