/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.SaveAndNew;
import kd.bos.entity.operate.Submit;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.MrpEntityTypeUtil;
import org.apache.log4j.Logger;

public class ResouceDataPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    protected static final String SOURCETYPE = "sourcetype";
    protected static final String DATA_CONFIG = "dataconfig";
    protected static final String CGNUMBER = "cgnumber";
    protected static final String TRANSFER = "billfieldtransfer";
    protected static final String STATUS = "status";
    protected static final String FILTERGRIDAP = "filtergridap";
    protected static final String FILTER = "filter_tag";
    protected static final String DESTBILL = "destbill";
    protected static final String BILLFIELD_TRANSFER = "billfieldtransfer";
    private static final Logger logger = Logger.getLogger(ResouceDataPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit billtransfer = (BasedataEdit)this.getControl("billfieldtransfer");
        billtransfer.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String dataId = (String)this.getView().getFormShowParameter().getCustomParam(DATA_CONFIG);
        if (StringUtils.isNotBlank((CharSequence)dataId)) {
            this.getModel().setValue(CGNUMBER, (Object)dataId);
        }
    }

    public void afterBindData(EventObject e) {
        String pageId;
        super.afterBindData(e);
        DynamicObject bill = (DynamicObject)this.getModel().getValue("billfieldtransfer");
        if (bill != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
            String number = bill.getString("srcbill.number");
            this.setFilterByDestBillType(number);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
        }
        String billfilterstr = (String)this.getModel().getDataEntity().get(FILTER);
        if (StringUtils.isNotBlank((CharSequence)billfilterstr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(filterCondition);
        }
        if ("mrp_resource_dataconf_rgt".equals(pageId = this.getView().getFormShowParameter().getFormId())) {
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        OperationResult re;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Audit || e.getSource() instanceof Submit || e.getSource() instanceof Save) {
            String param = this.getView().getFormShowParameter().getAppId();
            if (param == null || "".equals(param)) {
                this.getModel().setValue(SOURCETYPE, (Object)"mrp");
            } else {
                this.getModel().setValue(SOURCETYPE, (Object)param);
            }
            String pageId = this.getView().getFormShowParameter().getFormId();
            if ("mrp_resource_dataconf_rgt".equals(pageId)) {
                this.beforeSave(e);
                return;
            }
            this.beforeSave(e);
            this.getModel().setValue(STATUS, (Object)"C");
        }
        if (e.getSource() instanceof Submit && this.getModel().getDataChanged() && !(re = this.getView().invokeOperation("save")).isSuccess()) {
            e.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof SaveAndNew) {
            this.setFilterByDestBillType("mrp_resource_dataconfig");
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(new FilterCondition());
        }
    }

    protected void beforeSave(BeforeDoOperationEventArgs e) {
        String number = "";
        if (this.getModel().getValue("number") != null) {
            number = (String)this.getModel().getValue("number");
        }
        logger.info((Object)("\u6570\u636e\u6e90\u914d\u7f6e" + number + "\u5f00\u59cb\u8fdb\u884c\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c\u4fdd\u5b58"));
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        logger.info((Object)("\u6570\u636e\u6e90\u914d\u7f6e" + number + "\u9700\u8981\u4fdd\u5b58\u7684\u8fc7\u6ee4\u6761\u4ef6\u7684JSON\u5b57\u7b26\u4e32\u7684\u503c\u4e3a:" + filterString));
        this.getModel().setValue(FILTER, (Object)filterString);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("billfieldtransfer".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(new FilterCondition());
            DynamicObject bill = (DynamicObject)this.getModel().getValue("billfieldtransfer");
            if (bill != null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
                String number = bill.getString("srcbill.number");
                this.setFilterByDestBillType(number);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
            }
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    protected void setFilterByDestBillType(String number) {
        if (number != null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        if ("billfieldtransfer".equals(key) && this.getModel().getValue(CGNUMBER) != null) {
            DynamicObject dest = (DynamicObject)this.getModel().getValue(CGNUMBER);
            QFilter qfFilter = new QFilter(DESTBILL, "=", dest.get("businessentity.id"));
            QFilter orgfFilter = new QFilter("createorg.id", "=", dest.get("createorg.id"));
            QFilter ctrlfFilter = new QFilter("ctrlstrategy", "=", (Object)Character.valueOf('5'));
            QFilter orgOrCtrl = orgfFilter.or(ctrlfFilter);
            QFilter qfAndOrg = qfFilter.and(orgOrCtrl);
            ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
            indexParameter.getListFilterParameter().setFilter(qfAndOrg);
        }
    }
}

