/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class ResourceDataManagerPlugin
extends AbstractFormPlugin
implements ItemClickListener,
HyperLinkClickListener {
    private static final String RESOURCENUMID = "resourcenumid";
    private static final String RESOUECENUM = "resourcenum";
    private static final String RESOURCEDATABILLLIST = "resoucedatabilllist";
    private static final String BARNEWDS = "barnewds";
    private static final String BARDELDS = "bardelds";
    private static final String FORMID = "msplan_resource_dataconf";
    private static final String RESOURCEID = "mrp_resourceregister_cf";
    private static final String DATA_CONFIG = "dataconfig";
    private static final String CALLBACK_DATA = "callbackdata";
    private static final String CONFIRM_DATA = "confirmdata";
    private static final String toolbarap = "toolbarap";
    private static final String CALLBACK_MODIFYSRCBILL = "modifybillcallback";
    private static final String FORM_ID = "msplan_resource_dataconf";
    private static final String ID = "id";
    private static final String STATUS = "status";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{BARNEWDS, toolbarap});
        BillList grid = (BillList)this.getControl(RESOURCEDATABILLLIST);
        grid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void itemClick(ItemClickEvent e) {
        String key;
        switch (key = e.getItemKey()) {
            case "barnewds": {
                this.openNewResourceData();
                break;
            }
            case "bardelds": {
                this.delResourceData();
                break;
            }
        }
    }

    private void openNewResourceData() {
        if (this.isaudit()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u8d44\u6e90\u6ce8\u518c\u914d\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u65b0\u589e\u6570\u636e\u6e90\u3002", (String)"ResourceDataManagerPlugin_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        String resourceId = this.getPageCache().get(RESOURCENUMID);
        BillShowParameter form = new BillShowParameter();
        form.setFormId("msplan_resource_dataconf");
        form.setCustomParam(DATA_CONFIG, (Object)resourceId);
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_DATA));
        this.getView().showForm((FormShowParameter)form);
    }

    private void delResourceData() {
        if (this.isaudit()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u72b6\u6001\u7684\u8d44\u6e90\u6ce8\u518c\u914d\u7f6e\u6570\u636e\u4e0d\u5141\u8bb8\u5220\u9664\u6570\u636e\u6e90\u3002", (String)"ResourceDataManagerPlugin_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        BillList control = (BillList)this.getView().getControl(RESOURCEDATABILLLIST);
        ListSelectedRowCollection selectedRows = control.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e\u884c\u4e0d\u80fd\u5c0f\u4e8e1\u3002", (String)"ResourceDataManagerPlugin_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u5b9a\u8981\u5220\u9664\u6240\u9009\u6570\u636e\u884c\u5417\uff1f", (String)"ResourceDataManagerPlugin_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(CONFIRM_DATA, (IFormPlugin)this));
    }

    private boolean isaudit() {
        String resourceId = this.getPageCache().get(RESOURCENUMID);
        QFilter qfilter = new QFilter(ID, "=", (Object)Long.valueOf(resourceId));
        DynamicObject dyn = QueryServiceHelper.queryOne((String)RESOURCEID, (String)STATUS, (QFilter[])new QFilter[]{qfilter});
        return dyn != null && "C".equals(dyn.getString(STATUS));
    }

    public void afterCreateNewData(EventObject e) {
        String resourcenumId = (String)this.getView().getFormShowParameter().getCustomParam(RESOURCENUMID);
        this.getModel().setValue(RESOUECENUM, (Object)resourcenumId);
        this.getPageCache().put(RESOURCENUMID, resourcenumId);
        this.refreshDSBillList();
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "callbackdata": 
            case "modifybillcallback": {
                this.refreshDSBillList();
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String key;
        switch (key = e.getCallBackId()) {
            case "confirmdata": {
                MessageBoxResult result = e.getResult();
                if (result == null || !MessageBoxResult.Yes.equals((Object)result)) break;
                BillList list = (BillList)this.getControl(RESOURCEDATABILLLIST);
                ListSelectedRowCollection rows = list.getSelectedRows();
                Object[] primarys = rows.getPrimaryKeyValues();
                OperationResult results = OperationServiceHelper.executeOperate((String)"delete", (String)"mrp_resource_dataconfig", (Object[])primarys, (OperateOption)OperateOption.create());
                if (!results.isSuccess() && !results.getValidateResult().isSuccess()) {
                    String message = ((OperateErrorInfo)((ValidateResult)results.getValidateResult().getValidateErrors().get(0)).getAllErrorInfo().get(0)).getMessage();
                    this.getView().showErrorNotification(message);
                }
                this.refreshDSBillList();
                break;
            }
        }
    }

    private void refreshDSBillList() {
        String resourcenumId = this.getPageCache().get(RESOURCENUMID);
        if (resourcenumId == null) {
            return;
        }
        QFilter qFilter = new QFilter("cgnumber", "=", (Object)Long.valueOf(resourcenumId));
        BillList control = (BillList)this.getView().getControl(RESOURCEDATABILLLIST);
        control.setMainOrgQFilter(qFilter);
        control.refresh();
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        BillList billList = (BillList)e.getSource();
        Object focusRowPkId = billList.getFocusRowPkId();
        this.openEditData(focusRowPkId);
    }

    private void openEditData(Object focusRowPkId) {
        BillShowParameter fsp = new BillShowParameter();
        fsp.setFormId("msplan_resource_dataconf");
        fsp.setPkId(focusRowPkId);
        fsp.setStatus(OperationStatus.EDIT);
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Long id = this.getModel().getValue(RESOUECENUM) == null ? 0L : ((DynamicObject)this.getModel().getValue(RESOUECENUM)).getLong(ID);
        if (id != 0L) {
            fsp.setCustomParam(DATA_CONFIG, (Object)String.valueOf(id));
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_MODIFYSRCBILL));
        this.getView().showForm((FormShowParameter)fsp);
    }
}

