/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class ResourceRegisterListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(ResourceRegisterListPlugin.class);
    private static final String BTN_EXPORT = "btnexport";
    private static final String KINGDEEDOWNLOAD = "KINGDEEDOWNLOAD";
    private static final String REFRESH = "refresh";
    private static final String TITLE = "title";
    private static final String FORMID = "msplan_verify_tips";
    private static final String ERRORMESSAGE = "errorMsg";
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String BUSINESSTYPE = "businesstype";
    private static final String MRP_APPHOME = "mrp_apphome";

    public void setFilter(SetFilterEvent e) {
        List qFilters;
        super.setFilter(e);
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        if (MRP_APPHOME.equalsIgnoreCase(parentFormId) && (qFilters = e.getCustomQFilters()) != null) {
            ArrayList<String> list = new ArrayList<String>(4);
            list.add("01");
            list.add("04");
            list.add("12");
            list.add("");
            qFilters.add(new QFilter(BUSINESSTYPE, "in", list));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String type = (String)this.getView().getFormShowParameter().getCustomParam("type");
        BillShowParameter billShowParameter = e.getParameter();
        billShowParameter.getCustomParams().put("type", type);
        Boolean iscopy = (Boolean)billShowParameter.getCustomParam("iscopy");
        if (iscopy != null && iscopy.booleanValue()) {
            billShowParameter.getCustomParams().put("copyId", e.getParameter().getPkId());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        ListSelectedRowCollection listSelect;
        Set pkValueSet;
        QFilter cgnumberfilter;
        DynamicObjectCollection resourceDataconfigs;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Delete && (resourceDataconfigs = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"id,number", (QFilter[])new QFilter[]{cgnumberfilter = new QFilter("cgnumber", "in", pkValueSet = (listSelect = e.getListSelectedData()).stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet()))})) != null && !resourceDataconfigs.isEmpty()) {
            Map<Object, String> mapObj = resourceDataconfigs.stream().collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getString("number")));
            String message = this.baseDataCheckRefrence(mapObj);
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                this.getView().showTipNotification(message);
                e.setCancel(true);
            } else {
                DeleteServiceHelper.delete((String)MRP_RESOURCE_DATACONFIG, (QFilter[])new QFilter[]{cgnumberfilter});
            }
        }
    }

    protected String baseDataCheckRefrence(Map<Object, String> objmap) {
        if (objmap == null || objmap.isEmpty()) {
            return null;
        }
        BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
        checker.setDraftValidReference(true);
        BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)MRP_RESOURCE_DATACONFIG);
        Map map = checker.checkRef(entityType, objmap.keySet().toArray());
        StringBuilder message = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
            MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
            String billName = refMainType.getDisplayName().toString();
            String fieldName = refrenceResult.getRefenceKey().getRefCol();
            for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                    fieldName = ((IFieldHandle)property).getDisplayName().toString();
                    break;
                }
                if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)property.getAlias())) continue;
                fieldName = property.getDisplayName().toString();
                break;
            }
            String str = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c%2$s\u201d\u7684\u5b57\u6bb5\u201c%3$s\u201d\u5f15\u7528\u4e86\u6b64\u6570\u636e\u3002\n", (String)"ResourceRigisterConfigEdit_19", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), objmap.get(entry.getKey()), billName, fieldName);
            message.append(str);
        }
        return message.toString();
    }
}

