/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Delete;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.formplugin.ResourceRigisterConfigEdit;
import kd.mpscmm.msplan.mrp.formplugin.pojo.ResourceDataPOJO;

public class ResourceRigisterConfigNewEdit
extends ResourceRigisterConfigEdit {
    private static final String MRP_RESOURCE_DATACONFIG = "mrp_resource_dataconfig";
    private static final String MRP_TARGETENTITY_DETAIL = "mrp_targetentity_detail";
    private static final String MRP_RESOURCE_DATASET = "mrp_resource_dataset";
    private static final String BUSINESSTYPE = "businesstype";
    private static final String TYPE = "type";
    private static final String BUSINESSENTITY = "businessentity";
    private static final String CUSTOMCONTROL = "customcontrol";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam(TYPE);
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            this.getModel().setValue(BUSINESSTYPE, (Object)"01");
            this.getModel().setValue(TYPE, (Object)type);
            this.getView().setEnable(Boolean.FALSE, new String[]{BUSINESSTYPE, TYPE});
            int ordinal = this.getModel().getProperty(TYPE).getOrdinal();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(ordinal, false);
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        CustomControl control = (CustomControl)this.getView().getControl(CUSTOMCONTROL);
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put("action", "init");
        DynamicObject businessentity = (DynamicObject)this.getModel().getValue(BUSINESSENTITY);
        JSONObject targetEntity = new JSONObject();
        if (businessentity != null) {
            targetEntity = this.initTargetentity(businessentity);
            paramsMap.put("targetEntity", targetEntity);
        } else {
            targetEntity.put("title", (Object)"");
            paramsMap.put("targetEntity", targetEntity);
            paramsMap.put("isHide", Boolean.TRUE);
        }
        List<ResourceDataPOJO> billData = this.initResourceData();
        if (billData != null) {
            paramsMap.put("billData", billData);
        } else {
            paramsMap.put("billData", new ArrayList(1));
        }
        paramsMap.put("isEnglish", Boolean.FALSE);
        if ("en-US".equals(Lang.get().getLangTag())) {
            paramsMap.put("isEnglish", Boolean.TRUE);
        }
        control.setData(paramsMap);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String type = (String)formShowParameter.getCustomParam(TYPE);
        if (StringUtils.isNotEmpty((CharSequence)type)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{BUSINESSTYPE, TYPE});
        }
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String eventName = e.getEventName();
        String eventArgs = e.getEventArgs();
        String status = (String)this.getModel().getValue("status");
        switch (eventName) {
            case "add": {
                if (!"A".equals(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u6570\u636e\u6e90\u3002", (String)"ResourceRigisterConfigNewEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openResourceDataSet(eventArgs, eventName);
                break;
            }
            case "handleSource": {
                this.openResourceDataSet(eventArgs, eventName);
                break;
            }
            case "handleTarget": {
                this.openResourceDataSet(eventArgs, eventName);
                break;
            }
            case "isDelete": {
                if (!"A".equals(status)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u5df2\u7ecf\u63d0\u4ea4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u6570\u636e\u6e90\u3002", (String)"ResourceRigisterConfigNewEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.delResourceData(eventArgs);
                break;
            }
            case "details": {
                this.openTargetentityDetail();
                break;
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (name) {
            case "businessentity": {
                if (this.checkBillDatasIsNotEmpty()) {
                    return;
                }
                CustomControl control = (CustomControl)this.getView().getControl(CUSTOMCONTROL);
                HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
                paramsMap.put("action", "inittargetEntity");
                paramsMap.put("isEnglish", Boolean.FALSE);
                if ("en-US".equals(Lang.get().getLangTag())) {
                    paramsMap.put("isEnglish", Boolean.TRUE);
                }
                JSONObject targetEntity = new JSONObject();
                if (newValue != null) {
                    DynamicObject businessentity = (DynamicObject)newValue;
                    targetEntity = this.initTargetentity(businessentity);
                    paramsMap.put("isHide", Boolean.FALSE);
                } else {
                    targetEntity.put("title", (Object)"");
                    paramsMap.put("isHide", Boolean.TRUE);
                }
                paramsMap.put("targetEntity", targetEntity);
                control.setData(paramsMap);
                break;
            }
        }
    }

    private void validateResourceData(BeforeDoOperationEventArgs e) {
        List<ResourceDataPOJO> listData = this.getBillDatasPageCache();
        if (listData != null && !listData.isEmpty()) {
            QFilter numberfilter;
            DynamicObjectCollection resources;
            List resultList;
            HashSet<Long> entryIds = new HashSet<Long>(16);
            ArrayList<String> numbers = new ArrayList<String>(16);
            ArrayList<String> addNumbers = new ArrayList<String>(16);
            ArrayList<String> updateNumbers = new ArrayList<String>(16);
            for (ResourceDataPOJO data : listData) {
                String id = data.getId();
                String numberds = data.getCode();
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    entryIds.add(Long.valueOf(id));
                    updateNumbers.add(numberds);
                } else {
                    addNumbers.add(numberds);
                }
                numbers.add(numberds);
            }
            if (!numbers.isEmpty() && !(resultList = numbers.stream().collect(Collectors.groupingBy(m -> m, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList())).isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u6e90\u7f16\u7801\u5b58\u5728\u91cd\u590d\u3002", (String)"ResourceRigisterConfigNewEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), resultList));
                e.setCancel(true);
                return;
            }
            if (!addNumbers.isEmpty() && (resources = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"number", (QFilter[])new QFilter[]{numberfilter = new QFilter("number", "in", addNumbers)})) != null && !resources.isEmpty()) {
                List addList = resources.stream().map(m -> m.getString("number")).collect(Collectors.toList());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u6e90\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"ResourceRigisterConfigNewEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), addList));
                e.setCancel(true);
                return;
            }
            if (!updateNumbers.isEmpty()) {
                numberfilter = new QFilter("number", "in", updateNumbers);
                numberfilter.and(new QFilter("id", "not in", entryIds));
                resources = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"id,number", (QFilter[])new QFilter[]{numberfilter});
                if (resources != null && !resources.isEmpty()) {
                    List updateList = resources.stream().map(m -> m.getString("number")).collect(Collectors.toList());
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u6e90\u7f16\u7801\u5df2\u7ecf\u5b58\u5728\u3002", (String)"ResourceRigisterConfigNewEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), updateList));
                    e.setCancel(true);
                    return;
                }
            }
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            this.validateResourceData(e);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs e) {
        if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            if (e.getOperationResult().isSuccess()) {
                this.syncResourceDataconfigData();
                List<ResourceDataPOJO> billData = this.initResourceData();
                CustomControl control = (CustomControl)this.getView().getControl(CUSTOMCONTROL);
                HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
                paramsMap.put("action", "initBillData");
                paramsMap.put("billData", billData);
                paramsMap.put("isEnglish", Boolean.FALSE);
                if ("en-US".equals(Lang.get().getLangTag())) {
                    paramsMap.put("isEnglish", Boolean.TRUE);
                }
                control.setData(paramsMap);
            }
        } else if (e.getSource() instanceof Delete && e.getOperationResult().isSuccess()) {
            this.getPageCache().remove("delSourceIds");
            this.getPageCache().remove("billDatas");
        }
    }

    private void syncResourceDataconfigData() {
        String idsStr;
        List<ResourceDataPOJO> listData = this.getBillDatasPageCache();
        if (listData != null && !listData.isEmpty()) {
            ArrayList<DynamicObject> addDynamicObject = new ArrayList<DynamicObject>(16);
            ArrayList<DynamicObject> updateDynamicObject = new ArrayList<DynamicObject>(16);
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            QFilter cgnumberfilter = new QFilter("cgnumber", "=", pkValue);
            Map dataMap = BusinessDataServiceHelper.loadFromCache((String)MRP_RESOURCE_DATACONFIG, (String)"id,number,name,billfieldtransfer,sourcetype,filter_tag,modifier,modifytime,status", (QFilter[])new QFilter[]{cgnumberfilter});
            for (ResourceDataPOJO resourceData : listData) {
                DynamicObject dynamicObject;
                String id = resourceData.getId();
                String number = resourceData.getCode();
                String name = resourceData.getName();
                String conditionValue = resourceData.getConditionValue();
                String billfieldtransfer = resourceData.getBillfieldtransfer();
                if (StringUtils.isNotEmpty((CharSequence)id)) {
                    dynamicObject = (DynamicObject)dataMap.get(Long.valueOf(id));
                    if (dynamicObject == null) continue;
                    String numbersd = dynamicObject.getString("number");
                    String namesd = dynamicObject.getString("name");
                    DynamicObject billfieldtransfersd = dynamicObject.getDynamicObject("billfieldtransfer");
                    String filter_tag = dynamicObject.getString("filter_tag");
                    boolean isChange = false;
                    if (!Objects.equals(numbersd, number)) {
                        dynamicObject.set("number", (Object)number);
                        isChange = true;
                    }
                    if (!Objects.equals(namesd, name)) {
                        dynamicObject.set("name", (Object)name);
                        isChange = true;
                    }
                    if (billfieldtransfer != null && billfieldtransfersd != null && !Objects.equals(billfieldtransfer, billfieldtransfersd.getPkValue())) {
                        DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(billfieldtransfer), (String)"mrp_billfieldtransfer");
                        dynamicObject.set("billfieldtransfer", (Object)bill);
                        isChange = true;
                    }
                    if (!Objects.equals(filter_tag, conditionValue)) {
                        dynamicObject.set("filter_tag", (Object)conditionValue);
                        isChange = true;
                    }
                    if (!isChange) continue;
                    dynamicObject.set("status", (Object)"C");
                    updateDynamicObject.add(dynamicObject);
                    continue;
                }
                dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)MRP_RESOURCE_DATACONFIG);
                dynamicObject.set("number", (Object)number);
                dynamicObject.set("name", (Object)name);
                dynamicObject.set("cgnumber", (Object)this.getModel().getDataEntity());
                if (StringUtils.isNotEmpty((CharSequence)billfieldtransfer)) {
                    DynamicObject bill = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.valueOf(billfieldtransfer), (String)"mrp_billfieldtransfer");
                    dynamicObject.set("billfieldtransfer", (Object)bill);
                }
                dynamicObject.set("filter_tag", (Object)conditionValue);
                dynamicObject.set("enable", (Object)"1");
                dynamicObject.set("status", (Object)"C");
                dynamicObject.set("sourcetype", (Object)"mrp");
                dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("createtime", (Object)Calendar.getInstance().getTime());
                addDynamicObject.add(dynamicObject);
            }
            if (!addDynamicObject.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])addDynamicObject.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
            if (!updateDynamicObject.isEmpty()) {
                SaveServiceHelper.update((DynamicObject[])updateDynamicObject.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(idsStr = this.getPageCache().get("delSourceIds")))) {
            Set delSourceIds = (Set)SerializationUtils.fromJsonString((String)idsStr, HashSet.class);
            if (delSourceIds != null && !delSourceIds.isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", (Object)delSourceIds);
                DeleteServiceHelper.delete((String)MRP_RESOURCE_DATACONFIG, (QFilter[])new QFilter[]{qFilter});
            }
            this.getPageCache().remove("delSourceIds");
        }
        this.getPageCache().remove("billDatas");
    }

    private JSONObject initTargetentity(DynamicObject businessentity) {
        if (businessentity == null) {
            return null;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)businessentity.getPkValue().toString());
        Map allFields = dataEntityType.getAllFields();
        JSONObject targetEntity = new JSONObject(16);
        ArrayList listData = new ArrayList(16);
        Long row = 1L;
        for (String field : allFields.keySet()) {
            DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(field);
            String displayName = findProperty.getDisplayName() == null ? "" : findProperty.getDisplayName().toString();
            String str = displayName.concat("(").concat(field).concat(")");
            HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
            Long l = row;
            Long l2 = row = Long.valueOf(row + 1L);
            dataMap.put("id", l);
            dataMap.put("bill", str);
            listData.add(dataMap);
        }
        targetEntity.put("title", (Object)businessentity.getString("name"));
        targetEntity.put("data", listData);
        return targetEntity;
    }

    private void openResourceDataSet(String args, String type) {
        DynamicObject businessentity = (DynamicObject)this.getModel().getValue(BUSINESSENTITY);
        if (businessentity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u3002", (String)"ResourceRigisterConfigNewEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(MRP_RESOURCE_DATASET);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "resourcedatacallback"));
        if (StringUtils.isNotEmpty((CharSequence)args)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
            map.put(TYPE, type);
            fsp.setCustomParams(map);
        }
        this.getView().showForm(fsp);
    }

    private void openTargetentityDetail() {
        DynamicObject businessentity = (DynamicObject)this.getModel().getValue(BUSINESSENTITY);
        if (businessentity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u76ee\u6807\u5b9e\u4f53\u3002", (String)"ResourceRigisterConfigNewEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            return;
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setCaption(String.format(ResManager.loadKDString((String)"%s\u8be6\u60c5", (String)"ResourceRigisterConfigNewEdit_5", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), businessentity.getString("name")));
        fsp.setFormId(MRP_TARGETENTITY_DETAIL);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "detailscallback"));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("targetentity", businessentity.getPkValue());
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    private void delResourceData(String args) {
        Map map = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        List<ResourceDataPOJO> listData = this.getBillDatasPageCache();
        if (map == null || listData == null) {
            return;
        }
        String id = (String)map.get("id");
        String rowId = (String)map.get("rowId");
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            String code = (String)map.get("code");
            HashMap<Object, String> objmap = new HashMap<Object, String>(16);
            objmap.put(Long.valueOf(id), code);
            String message = this.baseDataCheckRefrence(objmap);
            if (StringUtils.isNotEmpty((CharSequence)message)) {
                this.getView().showTipNotification(message);
                return;
            }
            HashSet<Long> delSourceIds = null;
            String idsStr = this.getPageCache().get("delSourceIds");
            if (StringUtils.isNotEmpty((CharSequence)idsStr)) {
                delSourceIds = (HashSet<Long>)SerializationUtils.fromJsonString((String)idsStr, HashSet.class);
            }
            if (delSourceIds == null) {
                delSourceIds = new HashSet<Long>(16);
            }
            delSourceIds.add(Long.valueOf(id));
            this.getPageCache().put("delSourceIds", SerializationUtils.toJsonString(delSourceIds));
        }
        listData.removeIf(p -> Objects.equals(rowId, p.getRowId()));
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put("isEnglish", Boolean.FALSE);
        if ("en-US".equals(Lang.get().getLangTag())) {
            paramsMap.put("isEnglish", Boolean.TRUE);
        }
        paramsMap.put("action", "initBillData");
        paramsMap.put("billData", listData);
        this.getPageCache().put("billDatas", JSON.toJSONString(listData));
        CustomControl control = (CustomControl)this.getView().getControl(CUSTOMCONTROL);
        control.setData(paramsMap);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        Map data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("resourcedatacallback".equals(actionId) && (data = (Map)event.getReturnData()) != null) {
            DynamicObject billfieldtransfer;
            List<ResourceDataPOJO> listData = this.getBillDatasPageCache();
            if (listData == null) {
                listData = new ArrayList<ResourceDataPOJO>(16);
            }
            String filter = (String)data.get("filter");
            String id = (String)data.get("id");
            String rowId = (String)data.get("rowId");
            String number = (String)data.get("number");
            String name = (String)data.get("name");
            String type = (String)data.get(TYPE);
            ResourceDataPOJO resourceDataPOJO = null;
            if ("edit".equals(type)) {
                List list = listData.stream().filter(f -> Objects.equals(rowId, f.getRowId())).collect(Collectors.toList());
                if (list.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6570\u636e\u884c\uff0c\u7f16\u8f91\u6570\u636e\u5931\u8d25\u3002", (String)"ResourceRigisterConfigNewEdit_6", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    return;
                }
                resourceDataPOJO = (ResourceDataPOJO)list.get(0);
            } else {
                resourceDataPOJO = new ResourceDataPOJO();
            }
            if ((billfieldtransfer = (DynamicObject)data.get("billfieldtransfer")) != null) {
                resourceDataPOJO.setBillfieldtransfer(String.valueOf(billfieldtransfer.getPkValue()));
                resourceDataPOJO.setSource(billfieldtransfer.getString("srcbill.id"));
                resourceDataPOJO.setCondition(super.translateJsonString(filter, billfieldtransfer.getString("srcbill.number")));
            }
            resourceDataPOJO.setId(id);
            resourceDataPOJO.setRowId(rowId);
            resourceDataPOJO.setCode(number);
            resourceDataPOJO.setName(name);
            resourceDataPOJO.setConditionValue(filter);
            if (!listData.contains(resourceDataPOJO)) {
                listData.add(resourceDataPOJO);
            }
            HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
            paramsMap.put("action", "initBillData");
            paramsMap.put("billData", listData);
            paramsMap.put("isEnglish", Boolean.FALSE);
            if ("en-US".equals(Lang.get().getLangTag())) {
                paramsMap.put("isEnglish", Boolean.TRUE);
            }
            this.getPageCache().put("billDatas", JSON.toJSONString(listData));
            CustomControl control = (CustomControl)this.getView().getControl(CUSTOMCONTROL);
            control.setData(paramsMap);
        }
    }

    private List<ResourceDataPOJO> initResourceData() {
        Long id;
        Long cgnumberId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Long copyId = (Long)formShowParameter.getCustomParam("copyId");
        if (copyId != null && copyId != 0L) {
            cgnumberId = copyId;
        }
        if ((id = (Long)this.getModel().getDataEntity().getPkValue()) != null && id != 0L) {
            cgnumberId = id;
        }
        if (cgnumberId == 0L) {
            return null;
        }
        QFilter cgnumberfilter = new QFilter("cgnumber", "=", (Object)cgnumberId);
        DynamicObjectCollection resourceDataconfig = QueryServiceHelper.query((String)MRP_RESOURCE_DATACONFIG, (String)"id,number,name,billfieldtransfer,billfieldtransfer.srcbill.id,billfieldtransfer.srcbill.number,filter_tag,creator.id,createtime,modifier.id,modifytime", (QFilter[])new QFilter[]{cgnumberfilter}, (String)"number");
        ArrayList<ResourceDataPOJO> listData = new ArrayList<ResourceDataPOJO>(16);
        if (resourceDataconfig != null && !resourceDataconfig.isEmpty()) {
            for (DynamicObject dynamicObject : resourceDataconfig) {
                Long idds = dynamicObject.getLong("id");
                String number = dynamicObject.getString("number");
                String name = dynamicObject.getString("name");
                Long billfieldtransfer = dynamicObject.getLong("billfieldtransfer");
                String filter = dynamicObject.getString("filter_tag");
                String srcbillId = dynamicObject.getString("billfieldtransfer.srcbill.id");
                String srcbillNumber = dynamicObject.getString("billfieldtransfer.srcbill.number");
                ResourceDataPOJO resourceDataPOJO = new ResourceDataPOJO();
                resourceDataPOJO.setRowId(String.valueOf(UUID.randomUUID()));
                resourceDataPOJO.setId(String.valueOf(idds));
                resourceDataPOJO.setCode(number);
                resourceDataPOJO.setName(name);
                resourceDataPOJO.setCondition(super.translateJsonString(filter, srcbillNumber));
                resourceDataPOJO.setConditionValue(filter);
                resourceDataPOJO.setBillfieldtransfer(String.valueOf(billfieldtransfer));
                resourceDataPOJO.setSource(srcbillId);
                if (copyId != null && copyId != 0L) {
                    resourceDataPOJO.setId("");
                    resourceDataPOJO.setCode(this.getDataSourceNumber());
                }
                listData.add(resourceDataPOJO);
            }
        }
        this.getPageCache().put("billDatas", JSON.toJSONString(listData));
        return listData;
    }

    private List<ResourceDataPOJO> getBillDatasPageCache() {
        String billDatas = this.getPageCache().get("billDatas");
        if (StringUtils.isNotEmpty((CharSequence)billDatas)) {
            return JSON.parseArray((String)billDatas, ResourceDataPOJO.class);
        }
        return null;
    }
}

