/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class StockSupplyPolicyPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String STORAGEORG = "storageorg";
    private static final String STOCKORG = "stockorg";
    private static final String ENTRYENTITY = "entryentity";
    private static final String STOCKSETUPENTRY = "stocksetupentry";
    private static final String STOCKSETUP = "stocksetup";
    private static final String STOCKNUMBER = "stocknumber";
    private static final String STOCKINDEX = "stockindex";
    private static final String NEWSTOCKSETUP = "newstocksetup";
    private static final String NEWMATERIAL = "newmaterial";
    private static final String MATERIALSETUP = "materialsetup";
    private static final String MATERIEL = "materiel";
    private static final String MATERIELORG = "materialorg";
    private static final String STOCKINDEXS = "stockindexs";
    private static final String STOCK = "stock";
    private static final String PRIORITY = "priority";
    private static final String STOCKRATIO = "stockratio";
    private static final String SUPPLYPRIORITY = "supplypriority";
    private static final String TITLE = "title";
    private static final String FORMID = "msplan_verify_tips";
    private static final String ERRORMESSAGE = "errorMsg";
    private static final String INVTYPE = "bd_invtype";
    private static final String INVSTATUS = "bd_invstatus";
    private static final String TYPEENTITY = "stockstypeentity";
    private static final String STATUSENTITY = "entryentity2";
    private static final String STOCKTYPE = "stocktype";
    private static final String STATUSTYPE = "stocktype1";
    private static final String WAREHOUSE_SETUP = "im_warehousesetup";
    private static final String ID = "id";
    private static final String SELEFENTITY = "mrp_stocksupply_policy";
    private static final String SEQ = "seq";
    private static final String WAREHOUSE = "warehousetext";
    private static final String STOADDRESS_TEXT = "stoaddresstext";
    private static final String ADDRESS = "fullname";
    private static final String INCLUDCHILD = "isIncludeAllSub";
    private static final String[] Materialname = new String[]{"materiel", "materialorg", "stock", "stockindexs", "prioritylevel"};
    private static final String[] Stockname = new String[]{"stockorg", "stocknumber", "stockindex", "supplypriority"};

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (e.getSource() instanceof NewEntry) {
            NewEntry es = (NewEntry)e.getSource();
            String actionkey = es.getOperateKey();
            if (NEWSTOCKSETUP.equals(actionkey)) {
                EntryGrid grid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
                IFormView view = grid.getView();
                int rowindex = this.getModel().getEntryRowCount(STOCKSETUPENTRY) - 1;
                String value = (String)this.getModel().getValue(STOCKSETUP);
                if ("2".equals(value) || "3".equals(value)) {
                    view.setEnable(Boolean.TRUE, rowindex, new String[]{STOCKNUMBER});
                    this.setORGbyPre(rowindex);
                } else {
                    view.setEnable(Boolean.FALSE, rowindex, new String[]{STOCKNUMBER});
                }
                view.setEnable(Boolean.FALSE, rowindex, new String[]{STOCKINDEX});
            } else if (NEWMATERIAL.equals(actionkey)) {
                EntryGrid grid = (EntryGrid)this.getControl(MATERIALSETUP);
                IFormView view = grid.getView();
                int rowindex = this.getModel().getEntryRowCount(MATERIALSETUP) - 1;
                view.setEnable(Boolean.FALSE, rowindex, new String[]{STOCKINDEXS});
            }
        } else if (e.getSource() instanceof DeleteEntry) {
            this.afterdeleteOrgEntry();
        }
    }

    private void setORGbyPre(int rowIndex) {
        if (rowIndex != 0 && this.getModel().getValue(STOCKORG, rowIndex - 1) != null) {
            this.getModel().setValue(STOCKORG, this.getModel().getValue(STOCKORG, rowIndex - 1), rowIndex);
        }
    }

    public void afterdeleteOrgEntry() {
        Set<Long> set = this.getOrgSet();
        Set<Integer> seqset = set.size() > 0 ? this.getSeqSet(set) : this.getNoSeqSet(set);
        if (seqset.size() > 0) {
            int[] deleterows = this.getArraysBySet(seqset);
            this.getModel().deleteEntryRows(STOCKSETUPENTRY, deleterows);
        }
    }

    private Set<Integer> getSeqSet(Set<Long> set) {
        DynamicObjectCollection setcoll = this.getModel().getEntryEntity(STOCKSETUPENTRY);
        Iterator sits = setcoll.iterator();
        HashSet<Integer> seqset = new HashSet<Integer>();
        while (sits.hasNext()) {
            DynamicObject sit = (DynamicObject)sits.next();
            if (sit.get(STOCKORG) == null || set.contains(((DynamicObject)sit.get(STOCKORG)).getLong(ID))) continue;
            seqset.add(sit.getInt(SEQ) - 1);
        }
        return seqset;
    }

    private Set<Integer> getNoSeqSet(Set<Long> set) {
        DynamicObjectCollection setcoll = this.getModel().getEntryEntity(STOCKSETUPENTRY);
        Iterator sits = setcoll.iterator();
        HashSet<Integer> seqset = new HashSet<Integer>();
        while (sits.hasNext()) {
            DynamicObject sit = (DynamicObject)sits.next();
            if (sit.get(STOCKORG) == null) continue;
            seqset.add(sit.getInt(SEQ) - 1);
        }
        return seqset;
    }

    private Set<Long> getOrgSet() {
        HashSet<Long> set = new HashSet<Long>();
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject it : coll) {
            if (it.get(STORAGEORG) == null) continue;
            set.add(((DynamicObject)it.get(STORAGEORG)).getLong(ID));
        }
        return set;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initStockEnable();
        this.initControlEnable();
        this.initWareText();
        this.initStockText();
    }

    private void initStockEnable() {
        EntryGrid grid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
        int rowcount = this.getModel().getEntryRowCount(STOCKSETUPENTRY);
        IFormView view = grid.getView();
        for (int i = 0; i < rowcount; ++i) {
            view.setEnable(Boolean.FALSE, i, new String[]{STOCKNUMBER});
            view.setEnable(Boolean.FALSE, i, new String[]{STOCKINDEX});
        }
    }

    private void initControlEnable() {
        EntryGrid materialgrid = (EntryGrid)this.getControl(MATERIALSETUP);
        int materialcount = this.getModel().getEntryRowCount(MATERIALSETUP);
        IFormView sview = materialgrid.getView();
        for (int i = 0; i < materialcount; ++i) {
            sview.setEnable(Boolean.FALSE, i, new String[]{STOCKINDEXS});
        }
    }

    private void initInvBase() {
        if (this.getModel().getValue(ID) == null || 0L == (Long)this.getModel().getValue(ID)) {
            DynamicObjectCollection stockstype = QueryServiceHelper.query((String)INVTYPE, (String)"id,number", (QFilter[])new QFilter[]{null}, (String)"number asc");
            DynamicObjectCollection statustype = QueryServiceHelper.query((String)INVSTATUS, (String)"id,number", (QFilter[])new QFilter[]{null}, (String)"number asc");
            EntryGrid statusgrid = (EntryGrid)this.getView().getControl(STATUSENTITY);
            EntryGrid typegrid = (EntryGrid)this.getView().getControl(TYPEENTITY);
            this.batchCreateEntryRows(statusgrid, typegrid, stockstype, statustype);
            this.setEntryValue(statusgrid, typegrid, stockstype, statustype);
        }
    }

    private void batchCreateEntryRows(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        int statussize = this.getModel().getEntryRowCount(STATUSENTITY);
        int typesize = this.getModel().getEntryRowCount(TYPEENTITY);
        if (statussize < statustype.size()) {
            statusgrid.getModel().batchCreateNewEntryRow(STATUSENTITY, statustype.size() - statussize);
        }
        if (typesize < stockstype.size()) {
            typegrid.getModel().batchCreateNewEntryRow(TYPEENTITY, stockstype.size() - typesize);
        }
    }

    private void setEntryValue(EntryGrid statusgrid, EntryGrid typegrid, DynamicObjectCollection stockstype, DynamicObjectCollection statustype) {
        this.setEntryGridValue(statusgrid, STOCKTYPE, stockstype);
        this.setEntryGridValue(typegrid, STATUSTYPE, statustype);
        statusgrid.setPageIndex(1);
        typegrid.setPageIndex(1);
    }

    private void setEntryGridValue(EntryGrid grid, String dyncolumn, DynamicObjectCollection collection) {
        Iterator its = collection.iterator();
        int row = 0;
        while (its.hasNext()) {
            Object id = ((DynamicObject)its.next()).get(ID);
            grid.getModel().setValue(dyncolumn, id, row++);
        }
    }

    public void setStockEnable() {
        EntryGrid grid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
        String value = (String)this.getModel().getValue(STOCKSETUP);
        if ("2".equals(value) || "3".equals(value)) {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, true);
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKORG, true);
            this.getModel().deleteEntryData(STOCKSETUPENTRY);
            this.getModel().createNewEntryRow(STOCKSETUPENTRY);
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{STOCKINDEX});
        } else {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, false);
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKORG, false);
            this.getModel().deleteEntryData(STOCKSETUPENTRY);
        }
    }

    public void initStockMust() {
        EntryGrid grid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
        String value = (String)this.getModel().getValue(STOCKSETUP);
        if ("2".equals(value) || "3".equals(value)) {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, true);
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKORG, true);
        } else {
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKNUMBER, false);
            this.setStockIsMust(grid, STOCKSETUPENTRY, STOCKORG, false);
        }
    }

    private void setStockIsMust(EntryGrid grid, String entityname, String fieldname, boolean flag) {
        IFormView view = grid.getView();
        int rowcount = this.getModel().getEntryRowCount(entityname);
        for (int i = 0; i < rowcount; ++i) {
            view.setEnable(Boolean.valueOf(flag), i, new String[]{fieldname});
        }
        grid.setMustInput(fieldname, flag);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initInvBase();
        this.initWareText();
        this.initStockText();
        this.initStockMust();
        if (this.getModel().getDataEntity().getLong(ID) > 0L) {
            this.getModel().setDataChanged(false);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(STORAGEORG);
        BasedataEdit stockorg = (BasedataEdit)this.getView().getControl(STOCKORG);
        BasedataEdit stockindex = (BasedataEdit)this.getView().getControl(STOCKINDEX);
        BasedataEdit stockindexs = (BasedataEdit)this.getView().getControl(STOCKINDEXS);
        BasedataEdit materialsetup = (BasedataEdit)this.getView().getControl(MATERIELORG);
        BasedataEdit stocknumber = (BasedataEdit)this.getView().getControl(STOCKNUMBER);
        BasedataEdit stock = (BasedataEdit)this.getView().getControl(STOCK);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stockorg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stockindex.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stockindexs.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        materialsetup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stocknumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        stock.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        int index = this.getModel().getEntryCurrentRowIndex(STOCKSETUPENTRY);
        int materialindex = this.getModel().getEntryCurrentRowIndex(MATERIALSETUP);
        List<Long> orglist = this.getOrgidlists();
        switch (key) {
            case "storageorg": {
                break;
            }
            case "stockorg": {
                if (orglist.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u7684\u6570\u636e\u3002", (String)"StockSupplyPolicyPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter orgfilter = new QFilter(ID, "in", orglist);
                ListShowParameter orgParameter = (ListShowParameter)e.getFormShowParameter();
                orgParameter.setMultiSelect(false);
                orgParameter.setCustomParam(INCLUDCHILD, (Object)Boolean.TRUE);
                orgParameter.getListFilterParameter().setFilter(orgfilter);
                break;
            }
            case "stockindex": {
                DynamicObject stock = this.getModel().getEntryRowEntity(STOCKSETUPENTRY, index);
                if (stock == null || stock.get("stocknumber.id") == null) break;
                List<Long> idlists = this.getLocationId4WareHouse(stock.getLong("stocknumber.id"));
                QFilter indexfilter = new QFilter(ID, "in", idlists);
                ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
                indexParameter.getListFilterParameter().setFilter(indexfilter);
                break;
            }
            case "stockindexs": {
                DynamicObject materialstock = this.getModel().getEntryRowEntity(MATERIALSETUP, materialindex);
                if (materialstock == null || materialstock.get("stock.id") == null) break;
                List<Long> idlists = this.getLocationId4WareHouse(materialstock.getLong("stock.id"));
                QFilter indexfilter = new QFilter(ID, "in", idlists);
                ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
                indexParameter.getListFilterParameter().setFilter(indexfilter);
                break;
            }
            case "stocknumber": {
                if (orglist.size() == 0) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7ec4\u7ec7\u8bbe\u7f6e\u4e2d\u5e93\u5b58\u7ec4\u7ec7\u7684\u6570\u636e\u3002", (String)"StockSupplyPolicyPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                this.setWareHouseFilter(e, STOCKORG, index);
                break;
            }
            case "stock": {
                this.setWareStockFilter(e, MATERIELORG, materialindex);
                break;
            }
            case "materialorg": {
                break;
            }
        }
    }

    private List<Long> getLocationId4WareHouse(Long warehouseId) {
        QFilter stockfilter = new QFilter(ID, "=", (Object)warehouseId);
        DynamicObjectCollection stocks = QueryServiceHelper.query((String)"bd_warehouse", (String)"entryentity.location", (QFilter[])new QFilter[]{stockfilter});
        ArrayList<Long> idlists = new ArrayList<Long>(stocks.size());
        for (DynamicObject object : stocks) {
            if (object.get("entryentity.location") == null) continue;
            idlists.add((Long)object.get("entryentity.location"));
        }
        return idlists;
    }

    private List<Long> getOrgidlists() {
        DynamicObjectCollection orgcoll = this.getModel().getEntryEntity(ENTRYENTITY);
        ArrayList<Long> orglist = new ArrayList<Long>(orgcoll.size());
        for (DynamicObject org : orgcoll) {
            if (org.get("storageorg.id") == null) continue;
            long orgid = (Long)org.get("storageorg.id");
            orglist.add(orgid);
        }
        return orglist;
    }

    private void setWareHouseFilter(BeforeF7SelectEvent e, String orgname, int index) {
        List<Long> list = this.getwareidlist(orgname, index);
        QFilter qfilter = new QFilter(ID, "in", (Object)list.toArray());
        ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
        indexParameter.getListFilterParameter().setFilter(qfilter);
    }

    private void setWareStockFilter(BeforeF7SelectEvent e, String orgname, int index) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)WAREHOUSE_SETUP, (String)"warehouse", (QFilter[])this.getStockQfilter(index, orgname));
        ArrayList<Object> list = new ArrayList<Object>(coll.size());
        for (DynamicObject obj : coll) {
            list.add(obj.get("warehouse"));
        }
        QFilter qfilter = new QFilter(ID, "in", (Object)list.toArray());
        ListShowParameter indexParameter = (ListShowParameter)e.getFormShowParameter();
        indexParameter.getListFilterParameter().setFilter(qfilter);
    }

    public QFilter[] getQfilterByOrg(int index, String orgname) {
        QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
        isinit.and(new QFilter("enable", "=", (Object)"1"));
        isinit.and(new QFilter("startstatus", "=", (Object)"B"));
        if (this.getModel().getValue(orgname, index) != null) {
            Object storageid = ((DynamicObject)this.getModel().getValue(orgname, index)).get(ID);
            QFilter storageflt = new QFilter("org", "=", storageid);
            return new QFilter[]{storageflt, isinit};
        }
        List<Long> idList = this.getOrgidlists();
        QFilter storageflt = new QFilter("org", "in", (Object)idList.toArray());
        return new QFilter[]{storageflt, isinit};
    }

    private QFilter[] getStockQfilter(int index, String orgname) {
        QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
        isinit.and(new QFilter("enable", "=", (Object)"1"));
        isinit.and(new QFilter("startstatus", "=", (Object)"B"));
        if (this.getModel().getValue(orgname, index) != null) {
            Object storageid = ((DynamicObject)this.getModel().getValue(orgname, index)).get(ID);
            QFilter storageflt = new QFilter("org", "=", storageid);
            return new QFilter[]{storageflt, isinit};
        }
        return new QFilter[]{isinit};
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        for (ChangeData change : e.getChangeSet()) {
            this.propertyChanged(change, key);
        }
    }

    private void propertyChanged(ChangeData changeData, String key) {
        Object oldValue = changeData.getOldValue();
        Object newValue = changeData.getNewValue();
        int index = changeData.getRowIndex();
        switch (key) {
            case "stocksetup": {
                this.setStockEnable();
                break;
            }
            case "stocknumber": {
                EntryGrid cgrid = (EntryGrid)this.getControl(STOCKSETUPENTRY);
                IFormView cview = cgrid.getView();
                this.getModel().setValue(STOCKINDEX, null, index);
                DynamicObject stockmodel = this.getModel().getEntryRowEntity(STOCKSETUPENTRY, index);
                if (stockmodel != null && stockmodel.get("stocknumber.id") != null) {
                    cview.setEnable(Boolean.TRUE, index, new String[]{STOCKINDEX});
                } else {
                    cview.setEnable(Boolean.FALSE, index, new String[]{STOCKINDEX});
                }
                DynamicObject stock = (DynamicObject)this.getModel().getValue(STOCKNUMBER, index);
                this.setWareText(stock, WAREHOUSE, index);
                this.setStockOrg4WareHouse(stock, STOCKORG, index);
                break;
            }
            case "stock": {
                EntryGrid materialgrid = (EntryGrid)this.getControl(MATERIALSETUP);
                IFormView materialview = materialgrid.getView();
                this.getModel().setValue(STOCKINDEXS, null, index);
                DynamicObject smodel = this.getModel().getEntryRowEntity(MATERIALSETUP, index);
                DynamicObject stomodel = (DynamicObject)this.getModel().getValue(STOCK, index);
                if (smodel != null && smodel.get("stock.id") != null) {
                    materialview.setEnable(Boolean.TRUE, index, new String[]{STOCKINDEXS});
                } else {
                    materialview.setEnable(Boolean.FALSE, index, new String[]{STOCKINDEXS});
                }
                this.setWareText(stomodel, STOADDRESS_TEXT, index);
                this.setStockOrg4WareHouse(stomodel, MATERIELORG, index);
                break;
            }
            case "stockorg": {
                this.setStockOrgFieldsNull(index, STOCKORG);
                break;
            }
            case "materialorg": {
                this.setMaterialFieldsNull(index, MATERIELORG);
                break;
            }
            case "storageorg": {
                long newid;
                if (oldValue == null) break;
                HashSet<Integer> set = new HashSet<Integer>();
                long orgid = ((DynamicObject)oldValue).getLong(ID);
                long l = newid = newValue == null ? 0L : ((DynamicObject)newValue).getLong(ID);
                if (this.isExistComplict(index, orgid)) break;
                DynamicObjectCollection orgsetup = this.getModel().getEntryEntity(STOCKSETUPENTRY);
                for (DynamicObject it : orgsetup) {
                    long sorgid;
                    if (it.get(STOCKORG) == null || orgid != (sorgid = ((DynamicObject)it.get(STOCKORG)).getLong(ID))) continue;
                    set.add(it.getInt(SEQ) - 1);
                }
                if (set.size() <= 0) break;
                this.excuteSynData(set, newid);
                break;
            }
        }
    }

    private boolean isExistComplict(int changerow, long orgid) {
        int rows = changerow + 1;
        DynamicObjectCollection setup = this.getModel().getEntryEntity(ENTRYENTITY);
        for (DynamicObject setit : setup) {
            long nowsid;
            if (setit.getInt(SEQ) == rows || setit.get(STORAGEORG) == null || (nowsid = ((DynamicObject)setit.get(STORAGEORG)).getLong(ID)) != orgid) continue;
            return true;
        }
        return false;
    }

    public void excuteSynData(Set<Integer> set, long newid) {
        int[] array = this.getArraysBySet(set);
        if (newid == 0L) {
            this.getModel().deleteEntryRows(STOCKSETUPENTRY, array);
        } else {
            for (int line : array) {
                this.getModel().setValue(STOCKORG, (Object)newid, line);
                this.getModel().setValue(STOCKNUMBER, null, line);
                this.getModel().setValue(STOCKINDEX, null, line);
                this.getModel().setValue(WAREHOUSE, null, line);
            }
        }
    }

    private int[] getArraysBySet(Set<Integer> set) {
        int[] number = new int[set.size()];
        int i = 0;
        for (Integer integer : set) {
            number[i++] = integer;
        }
        return number;
    }

    private List<Long> getwareidlist(String orgname, int index) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)WAREHOUSE_SETUP, (String)"warehouse", (QFilter[])this.getQfilterByOrg(index, orgname));
        ArrayList<Long> list = new ArrayList<Long>(coll.size());
        for (DynamicObject obj : coll) {
            list.add(obj.getLong("warehouse"));
        }
        return list;
    }

    private void setStockOrgFieldsNull(int index, String orgname) {
        Long id;
        List<Long> idlist;
        if (this.getModel().getValue(STOCKORG, index) != null && this.getModel().getValue(STOCKNUMBER, index) != null && !(idlist = this.getwareidlist(orgname, index)).contains(id = Long.valueOf(((DynamicObject)this.getModel().getValue(STOCKNUMBER, index)).getLong(ID)))) {
            this.getModel().setValue(STOCKNUMBER, null, index);
        }
    }

    private void setMaterialFieldsNull(int index, String orgname) {
        Long id;
        List<Long> idlist;
        if (this.getModel().getValue(MATERIELORG, index) != null && this.getModel().getValue(STOCK, index) != null && !(idlist = this.getwareidlist(orgname, index)).contains(id = Long.valueOf(((DynamicObject)this.getModel().getValue(STOCK, index)).getLong(ID)))) {
            this.getModel().setValue(STOCK, null, index);
        }
    }

    private void initWareText() {
        String value = (String)this.getModel().getValue(STOCKSETUP);
        if ("2".equals(value) || "3".equals(value)) {
            DynamicObjectCollection coll = this.getModel().getEntryEntity(STOCKSETUPENTRY);
            for (DynamicObject ware : coll) {
                DynamicObject stock = ware.getDynamicObject(STOCKNUMBER);
                this.setWareText(stock, WAREHOUSE, ware.getInt(SEQ) - 1);
            }
        }
    }

    private void initStockText() {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(MATERIALSETUP);
        for (DynamicObject ware : coll) {
            DynamicObject stock = ware.getDynamicObject(STOCK);
            this.setWareText(stock, STOADDRESS_TEXT, ware.getInt(SEQ) - 1);
        }
    }

    private void setWareText(DynamicObject ware, String fieldname, int index) {
        if (ware != null && ware.get("address") != null) {
            QFilter filter = new QFilter(ID, "=", (Object)ware.getLong("address"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bd_admindivision", (String)ADDRESS, (QFilter[])new QFilter[]{filter});
            if (!dynamicObjects.isEmpty()) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjects.get(0);
                String adminName = dynamicObject.getString(ADDRESS);
                this.getModel().setValue(fieldname, (Object)adminName, index);
            }
        } else {
            this.getModel().setValue(fieldname, null, index);
        }
    }

    private void setStockOrg4WareHouse(DynamicObject ware, String fieldname, int index) {
        if (ware != null && this.getModel().getValue(fieldname, index) == null) {
            QFilter isinit = new QFilter("initstatus", "=", (Object)"B");
            isinit.and(new QFilter("enable", "=", (Object)"1"));
            isinit.and(new QFilter("startstatus", "=", (Object)"B"));
            QFilter wareFilter = new QFilter("warehouse", "=", (Object)ware.getLong(ID));
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getSimpleName(), (String)WAREHOUSE_SETUP, (String)"org", (QFilter[])new QFilter[]{isinit, wareFilter}, null, (int)1);){
                if (dataSet.hasNext()) {
                    Long orgId = dataSet.next().getLong(0);
                    this.getModel().setValue(fieldname, (Object)orgId, index);
                }
            }
        }
    }
}

