/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.mrp.formplugin;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.property.TextProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;

public class TargetentityDetailEdit
extends AbstractBillPlugIn {
    private static final String TARGETENTITY = "targetentity";
    private static final String ENTRYENTITY = "entryentity";
    private static final String SIGNID = "signid";
    private static final String SIGNNAME = "signname";
    private static final String DATATYPE = "datatype";
    private static final String BIZDATATYPE = "bizdatatype";
    private static final String DEFAULTVALUE = "defaultvalue";
    private static final String SRCTYPE = "srctype";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        Object targetentity = parameterParams.get(TARGETENTITY);
        if (targetentity != null) {
            this.getModel().setValue(TARGETENTITY, targetentity);
            this.getView().updateView(TARGETENTITY);
            this.queryMetaDataInfo();
        }
    }

    private void queryMetaDataInfo() {
        Map allFields;
        this.getModel().deleteEntryData(ENTRYENTITY);
        MainEntityType dataEntityType = this.getMainEntityType(TARGETENTITY);
        if (dataEntityType != null && (allFields = dataEntityType.getAllFields()) != null && allFields.size() > 0) {
            this.getModel().batchCreateNewEntryRow(ENTRYENTITY, allFields.size());
            int rowIndex = 0;
            for (String field : allFields.keySet()) {
                this.buildRow(dataEntityType, rowIndex, field);
                ++rowIndex;
            }
        }
        this.getView().updateView(ENTRYENTITY);
    }

    private MainEntityType getMainEntityType(String entityname) {
        DynamicObject accEntity = (DynamicObject)this.getModel().getValue(entityname);
        if (accEntity != null) {
            Object billentityPkValue = accEntity.getPkValue();
            MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)billentityPkValue.toString());
            return dataEntityType;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u5c5e\u4e8e\u5b9e\u4f53\u7c7b\u578b\u7684\u5b57\u6bb5", (String)"TargetentityDetailEdit_4", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), entityname));
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String signid) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signid);
        this.getModel().setValue(SIGNID, (Object)signid, rowIndex);
        if (findProperty.getParent() instanceof EntryType) {
            EntryType entry = (EntryType)findProperty.getParent();
            this.getModel().setValue(SIGNID, (Object)(entry.getName() + '.' + signid), rowIndex);
        } else {
            this.getModel().setValue(SIGNID, (Object)signid, rowIndex);
        }
        LocaleString signName = findProperty.getDisplayName();
        this.getModel().setValue(SIGNNAME, (Object)signName, rowIndex);
        Object defaultValue = findProperty.getDefaultValue();
        if (StringUtils.isNotBlank((Object)defaultValue)) {
            this.getModel().setValue(DEFAULTVALUE, defaultValue, rowIndex);
        }
        String dataType = BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)findProperty);
        this.getModel().setValue(DATATYPE, (Object)dataType, rowIndex);
        if (findProperty instanceof TextProp) {
            this.getModel().setValue(BIZDATATYPE, (Object)ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"TargetentityDetailEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex);
        } else if (findProperty instanceof OrgProp) {
            this.getModel().setValue(BIZDATATYPE, (Object)ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"TargetentityDetailEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex);
        } else if (findProperty instanceof BasedataProp) {
            this.getModel().setValue(BIZDATATYPE, (Object)ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"TargetentityDetailEdit_3", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), rowIndex);
            BasedataProp baseData = (BasedataProp)findProperty;
            String baseEntityId = baseData.getBaseEntityId();
            this.getModel().setValue(SRCTYPE, (Object)baseEntityId, rowIndex);
        }
    }
}

