/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.pls;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.CellStyle;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.mvc.base.BaseView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msplan.mrp.common.util.DynamicObjDataUtil;

public class PLSCaculateLogEdit
extends AbstractBillPlugIn
implements ProgresssListener {
    private static final String PROGRESS_BARAP = "progressbarap";
    private static final String STOP = "stop_pls";
    private static final String CALCULATE_PRO = "calculatepro";
    private static final String START_DATE = "startdate";
    private static final String END_DATE = "enddate";
    private static final String SUM_MIN = "summin";
    private static final String CALCULATE_STATUS = "calculatestatus";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_RESULT = "entryresult";
    private static final String ID = "id";
    private static final String USEORG = "useorg";
    private static final String CREATEORG = "createorg";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String LABELAP = "labelap";
    private static final String IMAGE_FAIL = "image_fail";
    private static final String IMAGE_SUCCESS = "image_success";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        IFormView fv;
        super.afterBindData(e);
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        if (progressBar != null) {
            String calculatestatus = (String)this.getModel().getValue(CALCULATE_STATUS);
            if (StringUtils.equalsIgnoreCase((CharSequence)calculatestatus, (CharSequence)"D")) {
                progressBar.start();
            } else {
                this.sortEntryByResultSeq();
            }
            BigDecimal calculatepro = (BigDecimal)this.getModel().getValue(CALCULATE_PRO);
            progressBar.setPercent(calculatepro.intValue());
            this.setProgressBarColorAndStatus(calculatestatus);
        }
        this.setCellColor();
        DynamicObject useOrg = DynamicObjDataUtil.getDataModelDynamicObjectData((IDataModel)this.getModel(), (String)USEORG);
        if (useOrg == null) {
            this.getModel().setValue(USEORG, this.getModel().getValue(CREATEORG));
        }
        if (!((fv = this.getView()) instanceof BaseView)) {
            fv.setVisible(Boolean.FALSE, new String[]{"titleapanel"});
            fv.setVisible(Boolean.TRUE, new String[]{"flexpanelap2"});
        } else {
            fv.setVisible(Boolean.TRUE, new String[]{"titleapanel"});
            fv.setVisible(Boolean.FALSE, new String[]{"flexpanelap2"});
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"dataversion"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String key;
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String string = key = op != null ? op.getOperateKey() : "";
        if (key.equals(STOP)) {
            this.updateData();
        }
    }

    private int updateData() {
        ProgressBar progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP);
        String status = this.sortEntryByResultSeq();
        if (status != null) {
            this.getModel().setValue(CALCULATE_STATUS, (Object)status);
        } else {
            status = (String)this.getModel().getValue(CALCULATE_STATUS);
        }
        BigDecimal percent = (BigDecimal)this.getModel().getValue(CALCULATE_PRO);
        int newPercent = percent.intValue();
        progressBar.setPercent(newPercent);
        if (!"D".equalsIgnoreCase(status)) {
            this.endCalculat(progressBar);
        }
        return newPercent;
    }

    public void onProgress(ProgressEvent progressEvent) {
        progressEvent.setProgress(this.updateData());
    }

    private String sortEntryByResultSeq() {
        QFilter qfilter = new QFilter(ID, "=", this.getModel().getValue(ID));
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)MRP_CACULATE_LOG, (String)"calculatepro,calculatestatus,entryentity.*", (QFilter[])new QFilter[]{qfilter}, (String)"entryentity.entrystepseq");
        ArrayList list = new ArrayList(16);
        Iterator lits = dyn.iterator();
        while (lits.hasNext()) {
            list.add(lits.next());
        }
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        model.beginInit();
        model.deleteEntryData(ENTRY_ENTITY);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        Iterator its = list.iterator();
        String status = null;
        BigDecimal calculatepro = BigDecimal.ZERO;
        while (its.hasNext()) {
            DynamicObject it = (DynamicObject)its.next();
            vs.addField("seq", new Object[0]);
            vs.addField(ENTRY_RESULT, new Object[0]);
            vs.addField("entrystepseq", new Object[0]);
            vs.addField("entrystepname", new Object[0]);
            vs.addField("entryprocessdata", new Object[0]);
            vs.addField("entryoperatmin", new Object[0]);
            vs.addField("entrydetailmsg", new Object[0]);
            vs.addField("entrydetailmsg_tag", new Object[0]);
            vs.addRow(new Object[]{it.get("entryentity.seq"), it.get("entryentity.entryresult"), it.get("entryentity.entrystepseq"), it.get("entryentity.entrystepname"), it.get("entryentity.entryprocessdata"), it.get("entryentity.entryoperatmin"), it.get("entryentity.entrydetailmsg"), it.get("entryentity.entrydetailmsg_tag")});
            status = it.getString(CALCULATE_STATUS);
            calculatepro = it.getBigDecimal(CALCULATE_PRO);
        }
        model.batchCreateNewEntryRow(ENTRY_ENTITY, vs);
        model.endInit();
        this.getView().updateView(ENTRY_ENTITY);
        if (StringUtils.equalsIgnoreCase(status, (CharSequence)"D") && new BigDecimal("100").compareTo(calculatepro) <= 0) {
            calculatepro = new BigDecimal("99");
        }
        this.getModel().setValue(CALCULATE_PRO, (Object)calculatepro);
        return status;
    }

    private void endCalculat(ProgressBar progressBar) {
        progressBar.stop();
        QFilter qfilter = new QFilter(ID, "=", this.getModel().getValue(ID));
        DynamicObject calLog = QueryServiceHelper.queryOne((String)MRP_CACULATE_LOG, (String)"startdate,enddate,summin", (QFilter[])new QFilter[]{qfilter});
        if (calLog != null) {
            this.getModel().setValue(START_DATE, calLog.get(START_DATE));
            this.getModel().setValue(END_DATE, calLog.get(END_DATE));
            this.getModel().setValue(SUM_MIN, calLog.get(SUM_MIN));
        }
        this.setProgressBarColorAndStatus((String)this.getModel().getValue(CALCULATE_STATUS));
        this.setCellColor();
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        ProgressBar progressBar;
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)STOP) && result != null && result.isSuccess() && (progressBar = (ProgressBar)this.getControl(PROGRESS_BARAP)) != null) {
            this.getModel().deleteEntryData(ENTRY_ENTITY);
            progressBar.stop();
            DynamicObject calLog = BusinessDataServiceHelper.loadSingle((Object)this.getModel().getValue(ID), (DynamicObjectType)this.getModel().getDataEntityType());
            calLog.set(CALCULATE_PRO, (Object)progressBar.getPercent());
            SaveServiceHelper.update((DynamicObject)calLog);
            BaseDataServiceHelper.clearCache((DynamicObject)calLog);
        }
    }

    private void setCellColor() {
        IDataModel dm = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        if (entryGrid == null) {
            return;
        }
        int rows = dm.getEntryRowCount(ENTRY_ENTITY);
        ArrayList<CellStyle> cells = new ArrayList<CellStyle>(rows);
        for (int i = 0; i < rows; ++i) {
            CellStyle cell = new CellStyle();
            cell.setFieldKey(ENTRY_RESULT);
            cell.setRow(i);
            String data = (String)dm.getValue(ENTRY_RESULT, i);
            if (ResManager.loadKDString((String)"\u5df2\u5b8c\u6210", (String)"PLSCaculateLogEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(data)) {
                cell.setBackColor("");
                cell.setForeColor("#1BA854");
            } else if (ResManager.loadKDString((String)"\u8b66\u544a", (String)"PLSCaculateLogEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]).equals(data)) {
                cell.setBackColor("");
                cell.setForeColor("#FFCC33");
            } else {
                cell.setBackColor("");
                cell.setForeColor("rgba(255,0,0,0.7)");
            }
            cells.add(cell);
        }
        if (!cells.isEmpty()) {
            entryGrid.setCellStyle(cells);
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    private void setProgressBarColorAndStatus(String cStatus) {
        String color = "#1BA854";
        Label lab = (Label)this.getControl(LABELAP);
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"D")) {
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u4e2d...", (String)"CaculateLogEdit_0", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL, IMAGE_SUCCESS});
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"B") || StringUtils.equalsIgnoreCase((CharSequence)cStatus, (CharSequence)"C")) {
            color = "rgba(255,0,0,0.7)";
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u5931\u8d25", (String)"CaculateLogEdit_1", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_SUCCESS});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_FAIL});
        } else {
            lab.setText(ResManager.loadKDString((String)"\u8fd0\u884c\u6210\u529f", (String)"CaculateLogEdit_2", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{IMAGE_FAIL});
            this.getView().setVisible(Boolean.TRUE, new String[]{IMAGE_SUCCESS});
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("fc", color);
        this.getView().updateControlMetadata(PROGRESS_BARAP, fieldMap);
    }
}

