/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.MrpEntityTypeUtil;

public class CheckDataConditionFormPlugin
extends AbstractBillPlugIn {
    protected static final String FILTERGRIDAP = "filtergridap";
    private static final String BTNOK = "btnok";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map parameterParams = parameter.getCustomParams();
        String filter = (String)parameterParams.get("filter");
        String number = (String)parameterParams.get("number");
        if (StringUtils.isNotEmpty((CharSequence)number)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            this.setFilterByDestBillType(number, filterGrid);
            if (StringUtils.isNotEmpty((CharSequence)filter)) {
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
                filterGrid.SetValue(filterCondition);
                filterGrid.getFilterGridState();
            }
            this.getView().updateView(FILTERGRIDAP);
            String status = (String)parameterParams.get("status");
            if (status != null && !"A".equals(status)) {
                this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
                this.getView().setVisible(Boolean.FALSE, new String[]{BTNOK});
            }
        }
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
    }

    public void click(EventObject evt) {
        Control btn = (Control)evt.getSource();
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String key = btn.getKey();
        if (BTNOK.equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
            String filter = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
            FormShowParameter parameter = this.getView().getFormShowParameter();
            Map parameterParams = parameter.getCustomParams();
            int row = (Integer)parameterParams.get("row");
            String number = (String)parameterParams.get("number");
            params.put("filter", filter);
            params.put("row", row);
            params.put("number", number);
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void setFilterByDestBillType(String number, FilterGrid filterGrid) {
        if (number != null && filterGrid != null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            filterGrid.SetValue(new FilterCondition());
        }
    }
}

