/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.sqlscript.PreInsDataScriptBuilder;

public class ExportSqlUtils {
    public static final String APPPARAM = "mpscmm-msplan-formplugin";

    public static String export(Object[] pkIds) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)"msplan_resourcecheck");
        InsertTableInfo insertTableInfo = new InsertTableInfo(pkIds, (DynamicObjectType)mainEntityType);
        List<InsertTableInfo> allInsertTableInfos = insertTableInfo.getAllInseartTableInfos();
        StringBuilder result = new StringBuilder();
        allInsertTableInfos.forEach(insertTable -> {
            if (StringUtils.isNotEmpty((CharSequence)insertTable.getTableName())) {
                PreInsDataScriptBuilder builder = new PreInsDataScriptBuilder();
                try {
                    Map map = builder.genInsertSQLScript(DBRoute.of((String)insertTable.getRoute()), insertTable.getTableName(), insertTable.getSelectField(), insertTable.getWhere(), null, null);
                    result.append(map.get("sql"));
                }
                catch (Exception e) {
                    throw new KDBizException((Throwable)e, BosErrorCode.bOS, new Object[]{String.format("KSQLExpPlugin error:%s.", e.getMessage())});
                }
            }
        });
        String sql = result.toString();
        sql = sql.replaceAll("0E-10", "0");
        String headtext = ResManager.loadKDStringExt((String)"/*----------------\u9884\u7f6e\u811a\u672c\u5bfc\u51fa\uff0c\u8bf7\u4ed4\u7ec6\u68c0\u67e5\u6838\u5bf9\u5bfc\u51fa\u811a\u672c\u7684\u6b63\u786e\u6027-----------------*/", (String)"ExportSqlUtils_0", (String)APPPARAM, (Object[])new Object[0]);
        sql = headtext + "\r\n" + sql;
        return sql;
    }

    private static class InsertTableInfo {
        Object[] pks;
        String tableName;
        String route;
        String selectField;
        String where;
        DynamicObjectType mt;
        List<InsertTableInfo> allInseartTableInfos;
        Map<String, InsertTableInfo> groupTableMap = new HashMap<String, InsertTableInfo>();

        public String getRoute() {
            return this.route;
        }

        public String getSelectField() {
            return this.selectField;
        }

        public String getWhere() {
            return this.where;
        }

        public List<InsertTableInfo> getAllInseartTableInfos() {
            return this.allInseartTableInfos;
        }

        public Map<String, InsertTableInfo> getGroupTableMap() {
            return this.groupTableMap;
        }

        public String getTableName() {
            return this.tableName;
        }

        public InsertTableInfo(Object[] pks, DynamicObjectType mt) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.mt = mt;
            this.tableName = mt.getAlias();
            this.route = mt.getDBRouteKey();
            this.where = this.generateWhere();
            this.selectField = this.generateSelectField();
            this.generateEntryInsertTableInfo();
            this.generateGroupInsertTableInfo();
            if (StringUtils.isNotEmpty((CharSequence)this.tableName)) {
                this.allInseartTableInfos.add(this);
            }
            this.groupTableMap.forEach((groupTableKey, insertTableInfo) -> {
                if (StringUtils.isNotEmpty((CharSequence)insertTableInfo.getTableName())) {
                    this.allInseartTableInfos.add((InsertTableInfo)insertTableInfo);
                }
            });
        }

        public InsertTableInfo(Object[] pks, DynamicObjectType mt, String groupTable, String selectField) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.tableName = mt.getAlias() + '_' + groupTable;
            this.route = mt.getDBRouteKey();
            this.where = this.generateWhere();
            this.selectField = selectField;
        }

        public InsertTableInfo(Object[] pks, String route, String tableName, String selectField) {
            this.allInseartTableInfos = new ArrayList<InsertTableInfo>();
            this.pks = pks;
            this.tableName = tableName;
            this.route = route;
            this.where = this.generateWhere();
            this.selectField = selectField;
        }

        public void appendSelectField(String field) {
            this.selectField = this.selectField + "," + field;
        }

        private void generateGroupInsertTableInfo() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            properties.forEach(iDataEntityProperty -> {
                String field = iDataEntityProperty.getAlias();
                String tableGroupKey = iDataEntityProperty.getTableGroup();
                if (StringUtils.isNotEmpty((CharSequence)field) && (StringUtils.isNotEmpty((CharSequence)tableGroupKey) || iDataEntityProperty instanceof MuliLangTextProp)) {
                    InsertTableInfo groupInsertTableInfo;
                    if (iDataEntityProperty instanceof MuliLangTextProp) {
                        tableGroupKey = "l";
                    }
                    if ((groupInsertTableInfo = this.groupTableMap.get(this.tableName + '_' + tableGroupKey)) == null) {
                        field = "l".equals(tableGroupKey) ? "fpkid,fid,flocaleid," + field : "fid," + field;
                        if (!(this.mt instanceof EntryType && "l".equals(tableGroupKey) || !StringUtils.isNotEmpty((CharSequence)(groupInsertTableInfo = new InsertTableInfo(this.pks, this.mt, tableGroupKey, field)).getTableName()))) {
                            this.groupTableMap.put(groupInsertTableInfo.getTableName(), groupInsertTableInfo);
                        }
                    } else {
                        groupInsertTableInfo.appendSelectField(field);
                    }
                }
                if (iDataEntityProperty instanceof MulBasedataProp && !(this.mt instanceof EntryType)) {
                    this.allInseartTableInfos.add(new InsertTableInfo(this.pks, this.route, iDataEntityProperty.getAlias(), "fpkid,fid,fbasedataid"));
                }
            });
        }

        private void generateEntryInsertTableInfo() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            properties.forEach(iDataEntityProperty -> {
                if (iDataEntityProperty instanceof EntryProp) {
                    InsertTableInfo entryInsertTableInfo = new InsertTableInfo(this.pks, ((EntryProp)iDataEntityProperty).getDynamicCollectionItemPropertyType());
                    entryInsertTableInfo.appendSelectField("fid");
                    this.allInseartTableInfos.add(entryInsertTableInfo);
                    this.groupTableMap.putAll(entryInsertTableInfo.getGroupTableMap());
                }
            });
        }

        private String generateSelectField() {
            DataEntityPropertyCollection properties = this.mt.getProperties();
            StringBuilder selectFieldSb = new StringBuilder();
            properties.forEach(iDataEntityProperty -> {
                String field = iDataEntityProperty.getAlias();
                if (StringUtils.isNotEmpty((CharSequence)field) && StringUtils.isEmpty((CharSequence)iDataEntityProperty.getTableGroup()) && !(iDataEntityProperty instanceof MuliLangTextProp) && !(iDataEntityProperty instanceof MulBasedataProp)) {
                    selectFieldSb.append(field).append(',');
                }
            });
            selectFieldSb.delete(selectFieldSb.toString().length() - 1, selectFieldSb.toString().length());
            return selectFieldSb.toString();
        }

        private String generateWhere() {
            int d = 39;
            if (this.pks == null || this.pks.length == 0) {
                return "";
            }
            if (this.pks.length == 1) {
                return "fid = '" + this.pks[0] + '\'';
            }
            StringBuilder sb = new StringBuilder();
            sb.append("fid in (");
            for (Object pk : this.pks) {
                sb.append('\'');
                sb.append(pk).append("',");
            }
            sb.delete(sb.length() - 1, sb.length());
            sb.append(')');
            return sb.toString();
        }

        public String toString() {
            return "InsertTableInfo{tableName='" + this.tableName + '\'' + ", route='" + this.route + '\'' + ", selectField='" + this.selectField + '\'' + ", where='" + this.where + '\'' + '}';
        }
    }
}

