/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.designer.botp.BillTreeBuildParameter;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.mpscmm.msplan.mrp.business.helper.ResourceFieldHelper;
import kd.mpscmm.msplan.mservice.service.resourcecheck.ResourceCheckDataValidService;
import kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecUtils;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;
import kd.mpscmm.msplan.resourcecheck.utils.SqlParamUtils;

public class ResourceCheckEditFormPlugin
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener,
ItemClickListener,
CellClickListener {
    private static final String APPPARAM = "mpscmm-msplan-formplugin";
    public static final String BY_CAL = "1";
    public static final String BY_CONDITION = "2";
    public static final String BY_NUMBER = "3";
    public static final String BY_OTHER = "4";
    public static final String BY_FLEXMETRIC = "5";
    private static final String CACHE_SRCBILL_CAL = "cache_srcbilltree_cal";
    public static final String FormId_Formula = "botp_formula";
    public static final String CustParamKey_Formula = "formula";
    public static final String CustParamKey_TreeNodes = "treenodes";
    public static final String CustParamKey_EntityNumber = "entitynumber";
    public static final String CustParamKey_FunctionTypes = "functiontypes";
    private String[] supportMethodReport = new String[]{"ROUND", "ABS", "INT", "STRING", "LEFT", "RIGHT", "LOWER", "UPPER", "CONCAT", "REPLACE", "LEN", "NOW", "TO_DATE", "DATE", "YMDDATE", "YEAR", "MONTH", "DAY", "QUARTER", "DATEDIF", "DATEADD", "TO_CHAR", "GetInwareOrgByOrg", "GetPurChaseOrgByOrg"};

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String source = con.getKey();
        if ("resultentitynumber".equals(source)) {
            this.filterById(e, this.getAllResultEntityIdSet());
        } else if ("entryleftentity".equals(source) || "entryrightentity".equals(source)) {
            this.filterById(e, this.getHeadEntityNumberSet());
        } else if ("resourcecheckitem".equals(source)) {
            ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
            String entityNumber = this.getMainEntityNumber();
            QFilter qfilter = new QFilter("mainentity", "=", (Object)entityNumber);
            listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    private void filterById(BeforeF7SelectEvent e, Set<String> idSet) {
        ListShowParameter listShowParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter qfilter = null;
        qfilter = idSet == null || idSet.isEmpty() ? new QFilter("id", "=", (Object)"") : new QFilter("id", "in", idSet);
        listShowParameter.getListFilterParameter().getQFilters().add(qfilter);
    }

    private Set<String> getHeadEntityNumberSet() {
        HashSet<String> dsSet = new HashSet<String>(16);
        dsSet.add(this.getMainEntityNumber());
        dsSet.add(this.getSrcEntityNumber());
        return dsSet;
    }

    private String getMainEntityNumber() {
        DynamicObject entity = (DynamicObject)this.getModel().getValue("mainentity");
        return entity == null ? "" : (String)entity.getPkValue();
    }

    private String getSrcEntityNumber() {
        DynamicObject entity = this.getSrcEntityObject();
        return entity == null ? "" : (String)entity.getPkValue();
    }

    private DynamicObject getSrcEntityObject() {
        return (DynamicObject)this.getModel().getValue("srcentity");
    }

    private Set<String> getAllResultEntityIdSet() {
        HashSet<String> dsSet = new HashSet<String>(16);
        QFilter parentFilter = new QFilter("inheritpath", "like", (Object)"%445UHYN+EFU5%");
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ResourceCheckEditFormPlugin.class.getName(), (String)"bos_entitymeta", (String)"number", (QFilter[])new QFilter[]{parentFilter}, (String)"id");){
            while (ds.hasNext()) {
                Row arow = ds.next();
                dsSet.add(arow.getString("number"));
            }
        }
        dsSet.add("msplan_checkresult");
        return dsSet;
    }

    public void registerListener(EventObject e) {
        EntryGrid checkLogicEntryGrid;
        super.registerListener(e);
        this.addClickListeners(new String[]{"javafilterrule"});
        this.addClickListeners(new String[]{"calculatetext"});
        this.addClickListeners(new String[]{"targetfieldnumber"});
        this.addClickListeners(new String[]{"srcfieldnumber"});
        this.addClickListeners(new String[]{"entryleftfieldnumber"});
        this.addClickListeners(new String[]{"entryrightfieldnumber"});
        this.addClickListeners(new String[]{"resultcalculatetext"});
        this.addClickListeners(new String[]{"resultsrcfieldflag"});
        BasedataEdit resultEntityNumber = (BasedataEdit)this.getControl("resultentitynumber");
        resultEntityNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit groupCheckItemNumber = (BasedataEdit)this.getControl("resourcecheckitem");
        groupCheckItemNumber.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryLeftEntity = (BasedataEdit)this.getControl("entryleftentity");
        entryLeftEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit entryRightEntity = (BasedataEdit)this.getControl("entryrightentity");
        entryRightEntity.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid filterEntryGrid = (EntryGrid)this.getView().getControl("filterentry");
        if (filterEntryGrid != null) {
            filterEntryGrid.addCellClickListener((CellClickListener)this);
        }
        if ((checkLogicEntryGrid = (EntryGrid)this.getView().getControl("checklogicentry")) != null) {
            checkLogicEntryGrid.addCellClickListener((CellClickListener)this);
        }
        this.addClickListeners(new String[]{"bizresultfieldname"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (this.getPageCache().get("isIgnoreChangeListener") == "true") {
            return;
        }
        String proName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        Object newValue = changeSet[0].getNewValue();
        int rowIndex = changeSet[0].getRowIndex();
        if (Objects.equals(oldValue, newValue)) {
            return;
        }
        if ("checkrange".equals(proName)) {
            this.clearValueByChangeRange((String)newValue);
        } else if ("checktype".equals(proName)) {
            this.clearValueByCheckType((String)newValue);
        } else if ("mainentity".equals(proName)) {
            this.changeByMainEntity(oldValue == null ? null : (DynamicObject)oldValue, newValue == null ? null : (DynamicObject)newValue);
        } else if ("srcentity".equals(proName)) {
            this.changeBySrcEntity(oldValue == null ? null : (DynamicObject)oldValue, newValue == null ? null : (DynamicObject)newValue);
        } else if ("resultentitynumber".equals(proName)) {
            this.getModel().deleteEntryData("resultfieldentry");
            this.getView().updateView("resultfieldentry");
        } else if ("entryfiltertype".equals(proName)) {
            this.changeByEntryFilterType((String)newValue, rowIndex);
        } else if ("entryleftentitytype".equals(proName)) {
            this.changeByEntryLeftEntityType((String)newValue, rowIndex);
        } else if ("entryrightentitytype".equals(proName)) {
            this.changeByEntryRightEntityType((String)newValue, rowIndex);
        } else if ("targetfieldnumber".equals(proName) || "srcfieldnumber".equals(proName) || "entryleftfieldnumber".equals(proName) || "entryrightfieldnumber".equals(proName) || "resultsrcfieldflag".equals(proName)) {
            if (newValue == null || "".equals(newValue.toString())) {
                this.changeByFieldNumber(proName, rowIndex);
            }
        } else if ("converttype".equals(proName)) {
            this.clearValueByConvertType((String)newValue, rowIndex);
        } else if ("condition".equals(proName)) {
            this.clearValueByCondition((String)newValue, rowIndex);
        } else if ("resultconverttype".equals(proName)) {
            this.clearValueByResultConvertType((String)newValue, rowIndex);
        } else if ("resultcalculatetext".equals(proName)) {
            this.clearValueByResultCalculateText(newValue, rowIndex);
        } else if ("calculatetext".equals(proName)) {
            this.clearValueByCalculateText(newValue, rowIndex);
        } else if ("bizresultfieldname".equals(proName)) {
            if (newValue == null || "".equals(newValue.toString())) {
                this.getModel().setValue("bizresultfieldnumber", (Object)"");
            }
        } else if ("onetype".equals(proName)) {
            this.changeByOneType((Boolean)newValue);
        }
    }

    private void changeByMainEntity(DynamicObject oldValue, DynamicObject newValue) {
        if (this.isCheckTypeA()) {
            this.addEntityToFilterEntry(newValue, "A");
            this.getModel().deleteEntryData("fieldmatchentry");
            this.getModel().deleteEntryData("checklogicentry");
            this.getView().updateView("fieldmatchentry");
            this.getView().updateView("checklogicentry");
        }
        if (this.isCheckTypeC()) {
            this.clearJavaPageData();
        }
        this.clearAndResetResultPageData();
        this.clearGroupCheckPageData();
    }

    private void changeBySrcEntity(DynamicObject oldValue, DynamicObject newValue) {
        if (this.isCheckTypeA()) {
            this.addEntityToFilterEntry(newValue, "B");
            this.getModel().deleteEntryData("fieldmatchentry");
            this.getModel().deleteEntryData("checklogicentry");
            this.getView().updateView("fieldmatchentry");
            this.getView().updateView("checklogicentry");
        }
    }

    private void changeByOneType(boolean newValue) {
        ComboEdit combEntryLeftEntityType = (ComboEdit)this.getControl("entryleftentitytype");
        ArrayList<ComboItem> listAdd = new ArrayList<ComboItem>(16);
        listAdd.add(this.genCombItemData("A", ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4", (String)"ResourceCheckEditFormPlugin_06", (String)APPPARAM, (Object[])new Object[0])));
        if (newValue) {
            this.getModel().setValue("srcentity", null);
            this.getModel().deleteEntryData("checklogicentry");
        } else {
            listAdd.add(this.genCombItemData("B", ResManager.loadKDString((String)"\u68c0\u67e5\u5bf9\u8c61", (String)"ResourceCheckEditFormPlugin_07", (String)APPPARAM, (Object[])new Object[0])));
        }
        combEntryLeftEntityType.setComboItems(listAdd);
    }

    private ComboItem genCombItemData(String keyString, String displayName) {
        ComboItem comboItem = new ComboItem();
        comboItem.setCaption(new LocaleString(displayName));
        comboItem.setValue(keyString);
        return comboItem;
    }

    private DynamicObject getEntityByType(String entityNumberType) {
        String entityField = "A".equals(entityNumberType) ? "mainentity" : "srcentity";
        return (DynamicObject)this.getModel().getValue(entityField);
    }

    private void changeByEntryFilterType(String newValue, int rowIndex) {
        this.getModel().beginInit();
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getModel().setValue("entryleftfieldnumber", null, rowIndex);
        this.getModel().setValue("entryleftfieldname", null, rowIndex);
        this.getModel().setValue("condition", null, rowIndex);
        this.getModel().setValue("entryrightentitytype", null, rowIndex);
        this.getModel().setValue("entryrightentity", null, rowIndex);
        this.getModel().setValue("entryrightfieldnumber", null, rowIndex);
        this.getModel().setValue("entryrightfieldname", null, rowIndex);
        this.getModel().setValue("entryfilterrule", null, rowIndex);
        this.getModel().setValue("entryfiltervalue", null, rowIndex);
        this.getModel().setValue("entryfiltervalue_tag", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("entryleftfieldnumber", rowIndex);
        this.getView().updateView("entryleftfieldname", rowIndex);
        this.getView().updateView("condition", rowIndex);
        this.getView().updateView("entryrightentitytype", rowIndex);
        this.getView().updateView("entryrightentity", rowIndex);
        this.getView().updateView("entryrightfieldnumber", rowIndex);
        this.getView().updateView("entryrightfieldname", rowIndex);
        this.getView().updateView("entryfilterrule", rowIndex);
        this.getView().updateView("entryfiltervalue", rowIndex);
        this.getView().updateView("entryfiltervalue_tag", rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void changeByEntryLeftEntityType(String newValue, int rowIndex) {
        DynamicObject entity = this.getEntityByType(newValue);
        this.getModel().beginInit();
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getModel().setValue("entryleftentity", (Object)entity, rowIndex);
        this.getModel().setValue("entryleftfieldnumber", null, rowIndex);
        this.getModel().setValue("entryleftfieldname", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("entryleftentity", rowIndex);
        this.getView().updateView("entryleftfieldnumber", rowIndex);
        this.getView().updateView("entryleftfieldname", rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void changeByEntryRightEntityType(String newValue, int rowIndex) {
        DynamicObject entity = this.getEntityByType(newValue);
        this.getModel().beginInit();
        this.getPageCache().put("isIgnoreChangeListener", "true");
        this.getModel().setValue("entryrightentity", (Object)entity, rowIndex);
        this.getModel().setValue("entryrightfieldnumber", null, rowIndex);
        this.getModel().setValue("entryrightfieldname", null, rowIndex);
        this.getModel().endInit();
        this.getView().updateView("entryrightentity", rowIndex);
        this.getView().updateView("entryrightfieldnumber", rowIndex);
        this.getView().updateView("entryrightfieldname", rowIndex);
        this.getPageCache().put("isIgnoreChangeListener", "false");
    }

    private void changeByFieldNumber(String fieldNumber, int rowIndex) {
        String fieldName = this.getFieldNameByFieldNumber(fieldNumber);
        this.getModel().setValue(fieldName, null, rowIndex);
        this.getView().updateView(fieldName, rowIndex);
        if ("targetfieldnumber".equals(fieldNumber)) {
            this.getModel().setValue("srcfieldnumber", null, rowIndex);
            this.getModel().setValue("srcfieldname", null, rowIndex);
            this.getModel().setValue("calculatetext", null, rowIndex);
            this.getModel().setValue("calculateexc", null, rowIndex);
            this.getModel().setValue("calculateexc_tag", null, rowIndex);
        }
    }

    private DynamicObject getFilterEntryByType(String type) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity("filterentry");
        for (DynamicObject entry : coll) {
            if (!type.equals(entry.getString("entitytype"))) continue;
            return entry;
        }
        return null;
    }

    private void addEntityToFilterEntry(DynamicObject newValue, String type) {
        DynamicObject entry = this.getFilterEntryByType(type);
        DynamicObjectCollection coll = this.getModel().getEntryEntity("filterentry");
        if (newValue != null) {
            if (entry == null) {
                entry = coll.addNew();
            }
            entry.set("seq", (Object)coll.size());
            entry.set("entitytype", (Object)type);
            entry.set("filterentity", (Object)newValue);
            entry.set("filterrule", (Object)"");
            entry.set("filterrulevalue", (Object)"");
            entry.set("filterrulevalue_tag", (Object)"");
        } else if (entry != null) {
            coll.remove((Object)entry);
        }
        this.getModel().updateEntryCache(coll);
        this.getView().updateView("filterentry");
    }

    private boolean isCheckTypeA() {
        return "A".equals((String)this.getModel().getValue("checktype"));
    }

    private boolean isCheckTypeB() {
        return "B".equals((String)this.getModel().getValue("checktype"));
    }

    private boolean isCheckTypeC() {
        return "C".equals((String)this.getModel().getValue("checktype"));
    }

    private boolean isGroupCheckRange() {
        return "B".equals((String)this.getModel().getValue("checkrange"));
    }

    public void clearValueByConvertType(String newData, int rowIndex) {
        this.getModel().setValue("srcfieldnumber", null, rowIndex);
        this.getModel().setValue("srcfieldname", null, rowIndex);
        this.getModel().setValue("calculatetext", null, rowIndex);
        this.getModel().setValue("calculateexc", null, rowIndex);
        this.getModel().setValue("calculateexc_tag", null, rowIndex);
    }

    public void clearValueByResultConvertType(String newData, int rowIndex) {
        this.getModel().setValue("resultsrcfieldflag", null, rowIndex);
        this.getModel().setValue("resultsrcfieldname", null, rowIndex);
        this.getModel().setValue("resultcalculateexc", null, rowIndex);
        this.getModel().setValue("resultcalculateexc_tag", null, rowIndex);
        this.getModel().setValue("resultcalculatetext", null, rowIndex);
    }

    public void clearValueByCalculateText(Object newData, int rowIndex) {
        if (newData == null || "".equals(newData.toString())) {
            this.getModel().setValue("calculateexc", null, rowIndex);
            this.getModel().setValue("calculateexc_tag", null, rowIndex);
        }
    }

    public void clearValueByResultCalculateText(Object newData, int rowIndex) {
        if (newData == null || "".equals(newData.toString())) {
            this.getModel().setValue("resultcalculateexc", null, rowIndex);
            this.getModel().setValue("resultcalculateexc_tag", null, rowIndex);
        }
    }

    public void clearValueByCondition(String newData, int rowIndex) {
        if ("G".equals(newData) || "H".equals(newData)) {
            this.getModel().setValue("entryrightentitytype", null, rowIndex);
            this.getModel().setValue("entryrightentity", null, rowIndex);
            this.getModel().setValue("entryrightfieldnumber", null, rowIndex);
            this.getModel().setValue("entryrightfieldname", null, rowIndex);
        }
    }

    public void clearValueByCheckType(String newData) {
        if ("A".equals(newData)) {
            this.clearSqlPageData();
            this.clearJavaPageData();
        } else if ("B".equals(newData)) {
            this.getModel().setValue("srcentity", null);
            this.clearEntityConfigPageData();
            this.clearJavaPageData();
        } else if ("C".equals(newData)) {
            this.getModel().setValue("srcentity", null);
            this.clearEntityConfigPageData();
            this.clearSqlPageData();
        }
    }

    public void clearValueByChangeRange(String newData) {
        if ("A".equals(newData)) {
            this.clearGroupCheckPageData();
        } else if ("B".equals(newData)) {
            this.getModel().setValue("srcentity", null);
            this.clearEntityConfigPageData();
            this.clearSqlPageData();
            this.clearJavaPageData();
            this.clearAndResetResultPageData();
        }
    }

    private void clearEntityConfigPageData() {
        this.getModel().deleteEntryData("filterentry");
        this.getModel().deleteEntryData("fieldmatchentry");
        this.getModel().deleteEntryData("checklogicentry");
        this.getView().updateView("filterentry");
        this.getView().updateView("fieldmatchentry");
        this.getView().updateView("checklogicentry");
    }

    private void clearSqlPageData() {
        this.getModel().setValue("txtsql", (Object)"");
        this.getModel().setValue("txtsql_tag", (Object)"");
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codesql");
        codeSQLshow.setText("");
    }

    private void clearJavaPageData() {
        this.getModel().setValue("javapluginclass", (Object)"");
        this.getModel().setValue("javafilterrule", (Object)"");
        this.getModel().setValue("javafilterrulevalue", (Object)"");
        this.getModel().setValue("javafilterrulevalue_tag", (Object)"");
    }

    private void clearAndResetResultPageData() {
        this.getModel().deleteEntryData("resultfieldentry");
        this.getView().updateView("resultfieldentry");
        this.initResultFieldEntryColumn();
    }

    private void clearGroupCheckPageData() {
        this.getModel().deleteEntryData("groupcheckentry");
        this.getView().updateView("groupcheckentry");
    }

    private void setSqlCodeToModel() {
        if (!this.isCheckTypeB()) {
            return;
        }
        IDataModel model = this.getModel();
        CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codesql");
        String sql = codeSQLshow.getText();
        model.setValue("txtsql", (Object)SqlParamUtils.getSimpleSql((String)sql));
        model.setValue("txtsql_tag", (Object)sql);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        String key = ((AbstractOperate)e.getSource()).getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            this.setSqlCodeToModel();
        }
        if ("updateresultfieldentry".equals(key)) {
            String mainEntityNumber = this.getMainEntityNumber();
            if (kd.bos.util.StringUtils.isEmpty((String)mainEntityNumber)) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ResourceCheckEditFormPlugin_01", (String)APPPARAM, (Object[])new Object[0]));
                return;
            }
            DynamicObject resultEntity = (DynamicObject)this.getModel().getValue("resultentitynumber");
            if (resultEntity == null) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u679c\u8868\u5b9e\u4f53\u6807\u8bc6\u4e3a\u7a7a\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"ResourceCheckEditFormPlugin_02", (String)APPPARAM, (Object[])new Object[0]));
            }
        }
        if ("optest".equals(key)) {
            this.setSqlCodeToModel();
            ResourceCheckDataValidService services = new ResourceCheckDataValidService();
            Map resultMap = services.checkData(this.getModel().getDataEntity(true), key, true);
            boolean isValid = (Boolean)resultMap.get("result");
            if (!isValid) {
                this.openShowDetialForm(resultMap.get("msg").toString());
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u6d4b\u8bd5\u6210\u529f\u3002", (String)"ResourceCheckEditFormPlugin_04", (String)APPPARAM, (Object[])new Object[0]));
            }
        }
        if ("newfieldmatchentry".equals(key) || "insertfieldmatchentry".equals(key)) {
            DynamicObject mainObject = this.getAndCheckMainObjectEntity();
            if (mainObject == null) {
                e.setCancel(true);
                return;
            }
            String srcEntityNumber = this.getSrcEntityNumber();
            if (kd.bos.util.StringUtils.isEmpty((String)srcEntityNumber)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u68c0\u67e5\u5bf9\u8c61\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\u5339\u914d\u7ef4\u5ea6\u5206\u5f55\u3002", (String)"ResourceCheckEditFormPlugin_05", (String)APPPARAM, (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        if ("viewsqlparamlist".equals(key)) {
            ListFilterParameter listFilter = new ListFilterParameter();
            QFilter qFilter = new QFilter("enable", "=", (Object)BY_CAL);
            qFilter.and(new QFilter("status", "=", (Object)"C"));
            listFilter.setFilter(qFilter);
            ListShowParameter showParam = new ListShowParameter();
            showParam.setHasRight(true);
            showParam.setBillFormId("msplan_sqlparam");
            showParam.setLookUp(true);
            showParam.setFormId("bos_list");
            showParam.getListFilterParameter().setQFilters(null);
            showParam.getOpenStyle().setShowType(ShowType.Modal);
            showParam.setShowFilter(false);
            showParam.setShowQuickFilter(true);
            showParam.setListFilterParameter(listFilter);
            showParam.setF7Style(0);
            StyleCss css = new StyleCss();
            css.setHeight("680");
            css.setWidth("960");
            showParam.getOpenStyle().setInlineStyleCss(css);
            showParam.setShowTitle(false);
            showParam.setMultiSelect(false);
            this.getView().showForm((FormShowParameter)showParam);
        }
    }

    public void openShowDetialForm(String msg) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_rc_detialshow");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("msgString", (Object)msg);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "msplan_rc_detialshow"));
        this.getView().showForm(showParameter);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        Object sql = model.getValue("txtsql_tag");
        if (sql != null) {
            CodeEdit codeSQLshow = (CodeEdit)this.getView().getControl("codesql");
            codeSQLshow.setText(sql.toString());
            this.getView().updateView("codesql");
        }
        this.getView().setEnable(Boolean.valueOf(!this.checkHasResultData()), new String[]{"mainentity", "idsetfieldtag", "checkrange", "checktype", "onetype"});
        String fieldType = "";
        if (this.getModel().getValue("fieldappid") != null) {
            fieldType = (String)this.getModel().getValue("fieldappid");
        }
        if (kd.bos.util.StringUtils.isBlank((String)fieldType)) {
            this.getModel().setValue("fieldappid", (Object)this.getView().getFormShowParameter().getAppId());
            DynamicObject dy = this.getModel().getDataEntity(true);
            dy.getDataEntityState().setBizChanged(((IDataEntityProperty)dy.getDataEntityType().getProperties().get((Object)"fieldappid")).getOrdinal(), false);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        if ("updateresultfieldentry".equals(key)) {
            this.initResultFieldEntryColumn();
        }
        if ("audit".equals(key) && e.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public Set<String> getUnInitResultSysFields() {
        HashSet<String> fieldNumberSet = new HashSet<String>(16);
        fieldNumberSet.add("id");
        fieldNumberSet.add("seq");
        fieldNumberSet.add("modifierfield");
        fieldNumberSet.add("modifydatefield");
        return fieldNumberSet;
    }

    public void initResultFieldEntryColumn() {
        DynamicObject resultEntity = (DynamicObject)this.getModel().getValue("resultentitynumber");
        String mainEntityNumber = this.getMainEntityNumber();
        if (resultEntity == null || kd.bos.util.StringUtils.isEmpty((String)mainEntityNumber) || this.isGroupCheckRange()) {
            return;
        }
        Map allFields = ResourceCheckUtils.getEntityEntryFields((String)((String)resultEntity.getPkValue()), (String)"entryentity");
        Set<String> notInsertColumnSet = this.getUnInitResultSysFields();
        HashSet<String> existsFieldNumberSet = new HashSet<String>(16);
        DynamicObjectCollection coll = this.getModel().getEntryEntity("resultfieldentry");
        if (!coll.isEmpty()) {
            HashSet<DynamicObject> removeSet = new HashSet<DynamicObject>(16);
            for (DynamicObject dy : coll) {
                String fieldNumber = dy.getString("resultfieldflag");
                if (allFields.get(fieldNumber) == null || notInsertColumnSet.contains(fieldNumber)) {
                    removeSet.add(dy);
                    continue;
                }
                existsFieldNumberSet.add(fieldNumber);
            }
            if (!removeSet.isEmpty()) {
                for (DynamicObject dy : removeSet) {
                    coll.remove((Object)dy);
                }
            }
        }
        List<String> addFields = this.getAddFieldNumberSet(existsFieldNumberSet, allFields, notInsertColumnSet);
        this.getModel().beginInit();
        if (addFields != null && !addFields.isEmpty()) {
            int rowIndex = coll.size();
            this.getModel().batchCreateNewEntryRow("resultfieldentry", addFields.size());
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)((String)resultEntity.getPkValue()));
            for (String field : addFields) {
                this.buildRow(mainType, rowIndex, field, resultEntity);
                ++rowIndex;
            }
        }
        this.getView().updateView("resultfieldentry");
        coll = this.getModel().getEntryEntity("resultfieldentry");
        Map defFieldTransMap = ExecUtils.getDefFieldTransferMap((String)mainEntityNumber, (String)this.getIdSetTag());
        if (defFieldTransMap != null && !defFieldTransMap.isEmpty()) {
            for (DynamicObject dy : coll) {
                String fieldNumber = dy.getString("resultfieldflag");
                String fromField = (String)defFieldTransMap.get(fieldNumber);
                if (kd.bos.util.StringUtils.isEmpty((String)fromField)) continue;
                dy.set("resultconverttype", (Object)"0");
                dy.set("resultsrcfieldflag", (Object)fromField);
                dy.set("resultsrcfieldname", (Object)ResourceCheckUtils.getFieldName((String)mainEntityNumber, (String)fromField));
                dy.set("resultcalculatetext", (Object)"");
                dy.set("resultcalculateexc", (Object)"");
                dy.set("resultcalculateexc_tag", (Object)"");
            }
            this.getModel().updateEntryCache(coll);
        }
        this.getModel().endInit();
        this.getView().updateView("resultfieldentry");
    }

    public String getIdSetTag() {
        Object data = this.getModel().getValue("idsetfieldtag");
        return data == null || kd.bos.util.StringUtils.isEmpty((String)data.toString()) ? "id" : data.toString();
    }

    public List<String> getAddFieldNumberSet(Set<String> existsFieldNumberSet, Map<String, IDataEntityProperty> allFields, Set<String> notInsertColumnSet) {
        ArrayList<String> addList = new ArrayList<String>(16);
        for (String field : allFields.keySet()) {
            if (existsFieldNumberSet.contains(field) || notInsertColumnSet.contains(field)) continue;
            addList.add(field);
        }
        return addList;
    }

    private void buildRow(MainEntityType dataEntityType, int rowIndex, String signid, DynamicObject entityNumber) {
        DynamicProperty findProperty = (DynamicProperty)dataEntityType.findProperty(signid);
        this.getModel().setValue("resultentityflag", entityNumber.getPkValue(), rowIndex);
        this.getModel().setValue("resultfieldflag", (Object)signid, rowIndex);
        LocaleString signName = findProperty.getDisplayName();
        this.getModel().setValue("resultfieldname", (Object)signName, rowIndex);
        String dataType = BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)findProperty);
        this.getModel().setValue("resultdatatype", (Object)dataType, rowIndex);
        this.getModel().setValue("resultsrcentityflag", (Object)this.getMainEntityNumber(), rowIndex);
    }

    public void cellClick(CellClickEvent e) {
        Object filterds;
        DynamicObject entity;
        String fieldKey = e.getFieldKey();
        int row = e.getRow();
        if ("filterrule".equals(fieldKey) && (entity = (DynamicObject)this.getModel().getValue("filterentity", row)) != null) {
            filterds = this.getModel().getValue("filterrulevalue_tag", row);
            this.openFilterSetForm(row, "configfilterconditiondatacallback", entity.getString("number"), filterds);
        }
        if ("entryfilterrule".equals(fieldKey) && (entity = (DynamicObject)this.getModel().getValue("entryleftentity", row)) != null && !this.isFilterTypeA(row)) {
            filterds = this.getModel().getValue("entryfiltervalue_tag", row);
            this.openFilterSetForm(row, "configchecklogicconditiondatacallback", entity.getString("number"), filterds);
        }
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }

    public DynamicObject getAndCheckMainObjectEntity() {
        DynamicObject objectentity = (DynamicObject)this.getModel().getValue("mainentity");
        if (objectentity == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u68c0\u67e5\u8303\u56f4\u6570\u636e\u3002", (String)"ResourceCheckEditFormPlugin_03", (String)APPPARAM, (Object[])new Object[0]));
            return null;
        }
        return objectentity;
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        EntryProp prop = e.getEntryProp();
        String key = prop.getName();
        if ("fieldmatchentry".equals(key)) {
            RowDataEntity[] rowDataEntities;
            DynamicObject mainObject = this.getAndCheckMainObjectEntity();
            DynamicObject srcObject = this.getSrcEntityObject();
            for (RowDataEntity rowData : rowDataEntities = e.getRowDataEntities()) {
                int row = rowData.getRowIndex();
                this.getModel().setValue("entrytargetentity", (Object)mainObject, row);
                this.getModel().setValue("entrysrcentity", (Object)srcObject, row);
                this.getView().updateView("entrytargetentity", row);
                this.getView().updateView("entrysrcentity", row);
            }
        }
    }

    public void click(EventObject event) {
        super.click(event);
        if (event == null) {
            return;
        }
        Object srcObj = event.getSource();
        Control srcC = srcObj instanceof Control ? (Control)srcObj : null;
        String srcKey = srcC == null ? null : srcC.getKey();
        IFormView fv = this.getView();
        if (fv == null) {
            return;
        }
        if (srcKey == null) {
            return;
        }
        switch (srcKey) {
            case "javafilterrule": {
                DynamicObject objectentity = this.getAndCheckMainObjectEntity();
                if (objectentity == null) {
                    return;
                }
                Object filterds = this.getModel().getValue("javafilterrulevalue_tag");
                this.openFilterSetForm(0, "javafilterconditiondatacallback", objectentity.getString("number"), filterds);
                break;
            }
            case "targetfieldnumber": {
                this.openFieldSelect(srcKey, "fieldmatchentry");
                break;
            }
            case "srcfieldnumber": {
                this.openFieldSelect(srcKey, "fieldmatchentry");
                break;
            }
            case "entryleftfieldnumber": {
                this.openFieldSelect(srcKey, "checklogicentry");
                break;
            }
            case "entryrightfieldnumber": {
                this.openFieldSelect(srcKey, "checklogicentry");
                break;
            }
            case "resultsrcfieldflag": {
                this.openFieldSelect(srcKey, "resultfieldentry");
                break;
            }
            case "calculatetext": {
                int row = this.getModel().getEntryCurrentRowIndex("fieldmatchentry");
                String convertType = (String)this.getModel().getValue("converttype", row);
                String entityNumber = this.getEntityNumberByRow("entrysrcentity", row);
                if (entityNumber == null || "".equals(entityNumber) || !BY_CAL.equals(convertType) && !BY_OTHER.equals(convertType)) break;
                this.openCalBillFieldView(row, srcKey, entityNumber);
                break;
            }
            case "resultcalculatetext": {
                int row2 = this.getModel().getEntryCurrentRowIndex("resultfieldentry");
                String convertType2 = (String)this.getModel().getValue("resultconverttype", row2);
                String entityNumber2 = this.getEntityNumberByRow("resultsrcentityflag", row2);
                if (entityNumber2 == null || "".equals(entityNumber2) || !BY_CAL.equals(convertType2) && !BY_OTHER.equals(convertType2)) break;
                this.openCalBillFieldView(row2, srcKey, entityNumber2);
                break;
            }
            case "bizresultfieldname": {
                DynamicObject mainEntity = this.getAndCheckMainObjectEntity();
                if (mainEntity == null) break;
                this.openBillFieldListWithTextProp((String)mainEntity.getPkValue(), srcKey);
                break;
            }
        }
    }

    private void openFilterSetForm(int row, String customerParam, String entityNumber, Object filterds) {
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("msplan_data_filterset");
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, customerParam));
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        String status = (String)this.getModel().getValue("status");
        params.put("filter", filterds);
        params.put("number", entityNumber);
        params.put("row", row);
        params.put("status", status);
        fsp.setCustomParams(params);
        this.getView().showForm(fsp);
    }

    public boolean isSrcFieldByConvertType(String convertType) {
        return "0".equals(convertType);
    }

    public boolean isFilterTypeA(int row) {
        String filterType = (String)this.getModel().getValue("entryfiltertype", row);
        return "A".equals(filterType);
    }

    public void openFieldSelect(String fieldNumber, String entryEntity) {
        int row = this.getModel().getEntryCurrentRowIndex(entryEntity);
        String entityNumber = null;
        if ("targetfieldnumber".equals(fieldNumber)) {
            entityNumber = this.getEntityNumberByRow("entrytargetentity", row);
        } else if ("srcfieldnumber".equals(fieldNumber)) {
            entityNumber = this.getEntityNumberByRow("entrysrcentity", row);
            String converttype = (String)this.getModel().getValue("converttype", row);
            if (!this.isSrcFieldByConvertType(converttype)) {
                return;
            }
        } else if ("entryleftfieldnumber".equals(fieldNumber)) {
            entityNumber = this.isFilterTypeA(row) ? this.getEntityNumberByRow("entryleftentity", row) : "";
        } else if ("entryrightfieldnumber".equals(fieldNumber)) {
            entityNumber = this.isFilterTypeA(row) ? this.getEntityNumberByRow("entryrightentity", row) : "";
        } else if ("resultsrcfieldflag".equals(fieldNumber)) {
            entityNumber = this.getEntityNumberByRow("resultsrcentityflag", row);
            String converttype = (String)this.getModel().getValue("resultconverttype", row);
            if (!this.isSrcFieldByConvertType(converttype)) {
                return;
            }
        } else if ("bizresultfieldname".equals(fieldNumber)) {
            // empty if block
        }
        if (entityNumber != null && !"".equals(entityNumber)) {
            this.openBillFieldList(entityNumber, entryEntity, fieldNumber);
        }
    }

    public String getEntityNumberByRow(String fieldNumber, int row) {
        Object data = this.getModel().getValue(fieldNumber, row);
        if (data instanceof DynamicObject) {
            return (String)((DynamicObject)data).getPkValue();
        }
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    public String getEntryEntityByField(String fieldNumber) {
        String entryName = "";
        if ("targetfieldnumber".equals(fieldNumber) || "srcfieldnumber".equals(fieldNumber) || "calculatetext".equals(fieldNumber)) {
            entryName = "fieldmatchentry";
        }
        if ("entryleftfieldnumber".equals(fieldNumber) || "entryrightfieldnumber".equals(fieldNumber)) {
            entryName = "checklogicentry";
        }
        if ("resultsrcfieldflag".equals(fieldNumber) || "resultcalculatetext".equals(fieldNumber)) {
            entryName = "resultfieldentry";
        }
        return entryName;
    }

    public String getFieldNameByFieldNumber(String fieldNumber) {
        String fieldName = "";
        switch (fieldNumber) {
            case "targetfieldnumber": {
                fieldName = "targetfieldname";
                break;
            }
            case "srcfieldnumber": {
                fieldName = "srcfieldname";
                break;
            }
            case "entryleftfieldnumber": {
                fieldName = "entryleftfieldname";
                break;
            }
            case "entryrightfieldnumber": {
                fieldName = "entryrightfieldname";
                break;
            }
            case "resultsrcfieldflag": {
                fieldName = "resultsrcfieldname";
                break;
            }
        }
        return fieldName;
    }

    public String getCalcExecFieldByText(String textFieldNumber, boolean isTag) {
        String fieldName = "";
        switch (textFieldNumber) {
            case "calculatetext": {
                fieldName = isTag ? "calculateexc_tag" : "calculateexc";
                break;
            }
            case "resultcalculatetext": {
                fieldName = isTag ? "resultcalculateexc_tag" : "resultcalculateexc";
                break;
            }
        }
        return fieldName;
    }

    public String getEntityNumberFieldByFieldNumber(String fieldNumber) {
        String entityNumberField = "";
        switch (fieldNumber) {
            case "targetfieldnumber": {
                entityNumberField = "entrytargetentity";
                break;
            }
            case "srcfieldnumber": {
                entityNumberField = "entrysrcentity";
                break;
            }
            case "entryleftfieldnumber": {
                entityNumberField = "entryleftentity";
                break;
            }
            case "entryrightfieldnumber": {
                entityNumberField = "entryrightentity";
                break;
            }
            case "resultsrcfieldflag": {
                entityNumberField = "resultsrcentityflag";
                break;
            }
        }
        return entityNumberField;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String fieldNumber;
        Object returnData;
        String number;
        String filter;
        Map data;
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if ("javafilterconditiondatacallback".equals(actionId) && (data = (Map)event.getReturnData()) != null) {
            filter = (String)data.get("filter");
            number = (String)data.get("number");
            String filterDesc = ResourceCheckUtils.translateJsonString((String)filter, (String)number);
            this.getModel().setValue("javafilterrule", (Object)filterDesc);
            this.getModel().setValue("javafilterrulevalue_tag", (Object)filter);
        }
        if (("configfilterconditiondatacallback".equals(actionId) || "configchecklogicconditiondatacallback".equals(actionId)) && (data = (Map)event.getReturnData()) != null) {
            filter = (String)data.get("filter");
            number = (String)data.get("number");
            int returnRow = (Integer)data.get("row");
            String filterDesc = ResourceCheckUtils.translateJsonString((String)filter, (String)number);
            if ("configfilterconditiondatacallback".equals(actionId)) {
                this.getModel().setValue("filterrule", (Object)filterDesc, returnRow);
                this.getModel().setValue("filterrulevalue_tag", (Object)filter, returnRow);
            } else {
                this.getModel().setValue("entryfilterrule", (Object)filterDesc, returnRow);
                this.getModel().setValue("entryfiltervalue_tag", (Object)filter, returnRow);
            }
        }
        if (("targetfieldnumber".equals(actionId) || "srcfieldnumber".equals(actionId) || "entryleftfieldnumber".equals(actionId) || "entryrightfieldnumber".equals(actionId) || "resultsrcfieldflag".equals(actionId)) && (returnData = event.getReturnData()) != null) {
            fieldNumber = (String)returnData;
            String entityField = this.getEntityNumberFieldByFieldNumber(actionId);
            int row = this.getModel().getEntryCurrentRowIndex(this.getEntryEntityByField(actionId));
            String entityNumber = this.getEntityNumberByRow(entityField, row);
            String fieldCaption = ResourceCheckUtils.getFieldName((String)entityNumber, (String)fieldNumber);
            String numberField = actionId;
            String nameField = this.getFieldNameByFieldNumber(actionId);
            String startStr = entityNumber + ".";
            if (fieldNumber.startsWith(startStr)) {
                fieldNumber = fieldNumber.replace(startStr, "");
            }
            this.getModel().setValue(numberField, (Object)fieldNumber, row);
            this.getModel().setValue(nameField, (Object)fieldCaption, row);
        }
        if ("bizresultfieldname".equals(actionId) && (returnData = event.getReturnData()) != null) {
            fieldNumber = (String)returnData;
            String entityNumber = this.getMainEntityNumber();
            String fieldCaption = ResourceCheckUtils.getFieldName((String)entityNumber, (String)fieldNumber);
            String startStr = entityNumber + ".";
            if (fieldNumber.startsWith(startStr)) {
                fieldNumber = fieldNumber.replace(startStr, "");
            }
            this.getModel().setValue("bizresultfieldname", (Object)fieldCaption);
            this.getModel().setValue("bizresultfieldnumber", (Object)fieldNumber);
        }
        if ("calculatetext".equals(actionId) || "resultcalculatetext".equals(actionId)) {
            returnData = event.getReturnData();
            int row = this.getModel().getEntryCurrentRowIndex(this.getEntryEntityByField(actionId));
            if (returnData instanceof String && StringUtils.isNotBlank((Object)returnData)) {
                String formulaJson = (String)returnData;
                String convertTypeField = "calculatetext".equals(actionId) ? "converttype" : "resultconverttype";
                String convertType = (String)this.getModel().getValue(convertTypeField, row);
                if (BY_CAL.equals(convertType) || BY_OTHER.equals(convertType) || BY_FLEXMETRIC.equals(convertType)) {
                    this.setCurrentRowForCRFormula(formulaJson, row, actionId);
                }
            }
        }
    }

    private void setCurrentRowForCRFormula(String formulaJson, int row, String fieldText) {
        CRFormula formula = (CRFormula)SerializationUtils.fromJsonString((String)formulaJson, CRFormula.class);
        this.getModel().setValue(this.getCalcExecFieldByText(fieldText, true), (Object)formulaJson, row);
        this.getModel().setValue(this.getCalcExecFieldByText(fieldText, false), (Object)formula.getExpression(), row);
        this.getModel().setValue(fieldText, (Object)formula.getExprDesc(), row);
    }

    private void openBillFieldList(String entityNumber, String entryEntity, String fieldNumber) {
        int row = this.getModel().getEntryCurrentRowIndex(entryEntity);
        MainEntityType billMainType = ResourceCheckUtils.getMainEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(true);
        parameter.setOnlyPhysicsField(true);
        if (row >= 0) {
            TreeNode srcBillNode = this.buildBillTreeNodes(parameter, "", true);
            String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
            this.showBillFieldForm(nodesJson, fieldNumber);
        }
    }

    private void openBillFieldListWithTextProp(String entityNumber, String fieldNumber) {
        MainEntityType billMainType = ResourceCheckUtils.getMainEntityType((String)entityNumber);
        BillTreeBuildParameter parameter = new BillTreeBuildParameter(billMainType);
        parameter.setIncludePKField(false);
        parameter.setOnlyPhysicsField(true);
        parameter.setMatchedProperty(this.getTextProp());
        TreeNode srcBillNode = this.buildBillTreeNodes(parameter, "", false);
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        this.showBillFieldForm(nodesJson, fieldNumber);
    }

    private IDataEntityProperty getTextProp() {
        return this.getModel().getDataEntityType().findProperty("bizresultfieldnumber");
    }

    private void showBillFieldForm(String nodesJson, String custumparam) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_billfieldselect");
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, custumparam));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private TreeNode buildBillTreeNodes(BillTreeBuildParameter parameter, String field, boolean isShowIdField) {
        MainEntityType mainType = parameter.getMainType();
        TreeNode billNode = new TreeNode("", mainType.getName(), mainType.getDisplayName().toString());
        billNode.setIsOpened(true);
        List fldNodes = isShowIdField ? BillFieldEntityHelper.buildFldCalTreeNodes((BillTreeBuildParameter)parameter) : BillFieldEntityHelper.buildFldTreeNodes((BillTreeBuildParameter)parameter);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(16);
        for (TreeNode node : fldNodes) {
            nodeMap.put(node.getId(), node);
        }
        for (TreeNode node : fldNodes) {
            TreeNode parentNode = (TreeNode)nodeMap.get(node.getParentid());
            if (parentNode == null) {
                node.setParentid(billNode.getId());
                billNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        return billNode;
    }

    private String getPageCache(String cache) {
        String json = this.getPageCache().get(cache);
        return json;
    }

    private void openCalBillFieldView(int row, String fieldNumber, String srcEntityPk) {
        MainEntityType sourceMainType = ResourceCheckUtils.getMainEntityType((String)srcEntityPk);
        String cacheJs = "cache_srcbilltree_cal_" + srcEntityPk;
        String nodesJson = this.getPageCache(cacheJs);
        if (StringUtils.isBlank((CharSequence)nodesJson)) {
            BillTreeBuildParameter parameter = new BillTreeBuildParameter(sourceMainType);
            parameter.setIncludePKField(true);
            TreeNode billTreeNode = ResourceFieldHelper.buildCalTreeNodes((BillTreeBuildParameter)parameter);
            nodesJson = SerializationUtils.toJsonString((Object)billTreeNode);
            this.getPageCache().put(cacheJs, nodesJson);
            String formula = (String)this.getModel().getValue(this.getCalcExecFieldByText(fieldNumber, true), row);
            if (kd.bos.util.StringUtils.isBlank((String)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, sourceMainType.getName(), nodesJson, fieldNumber);
        } else {
            String formula = (String)this.getModel().getValue(this.getCalcExecFieldByText(fieldNumber, true), row);
            if (kd.bos.util.StringUtils.isBlank((String)formula)) {
                CRFormula crFormula = new CRFormula();
                formula = SerializationUtils.toJsonString((Object)crFormula);
            }
            this.showFormulaForm(formula, sourceMainType.getName(), nodesJson, fieldNumber);
        }
    }

    private void showFormulaForm(String formulaJson, String entityNumber, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(FormId_Formula);
        showParameter.getCustomParams().put(CustParamKey_Formula, formulaJson);
        showParameter.getCustomParams().put(CustParamKey_EntityNumber, entityNumber);
        showParameter.getCustomParams().put(CustParamKey_TreeNodes, fieldNodes);
        String funcsXML = ResourceFieldHelper.getFuncsXML((String[])this.supportMethodReport);
        showParameter.getCustomParams().put(CustParamKey_FunctionTypes, funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private boolean checkHasResultData() {
        if (this.getModel().getDataEntity().getPkValue() == null) {
            return false;
        }
        Long pkId = (Long)this.getModel().getDataEntity().getPkValue();
        QFilter qfilter = new QFilter("resourcecheck", "=", (Object)pkId);
        return QueryServiceHelper.exists((String)"msplan_checkresult", (QFilter[])new QFilter[]{qfilter});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        Object opname = this.getModel().getValue("opname");
        if (opname == null || "".equals(opname.toString())) {
            this.getModel().setValue("opname", (Object)ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5", (String)"ResourceCheckEditFormPlugin_08", (String)APPPARAM, (Object[])new Object[0]));
        }
    }
}

