/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;
import kd.mpscmm.msplan.resourcecheck.ResourceCheckListFormPlugin;

public class ResourceCheckExecBaseFormPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ResourceCheckListFormPlugin.class);
    private String billListAp = "billlistap";
    public static final String APPPARAM = "mpscmm-msplan-formplugin";

    public String getBillListAp() {
        return this.billListAp;
    }

    public void setBillListAp(String billlistAp) {
        this.billListAp = billlistAp;
    }

    public Object[] getSelectIdValues() {
        BillList billList = (BillList)this.getView().getControl(this.getBillListAp());
        ListSelectedRowCollection selects = billList.getSelectedRows();
        return selects.getPrimaryKeyValues();
    }

    public void createJob(Long tagId, Set<Long> allResourceCheckIdSet, String operateKey, Map<Long, Set<Long>> srcMap) {
        try {
            String formNum = ((ListView)this.getView()).getBillFormId();
            String appIdByFormNum = BizAppServiceHelp.getAppIdByFormNum((String)formNum);
            String appId = StringUtils.isEmpty((String)this.getView().getFormShowParameter().getAppId()) ? appIdByFormNum : this.getView().getFormShowParameter().getAppId();
            appId = StringUtils.isEmpty((String)appId) ? "msplan" : appId;
            JobInfo jobInfo = new JobInfo();
            jobInfo.setRunByLang(Lang.get());
            jobInfo.setAppId("msplan");
            jobInfo.setJobType(JobType.REALTIME);
            jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
            jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
            jobInfo.setName("msplan-resourcecheck-task-job");
            String jobId = UUID.randomUUID().toString();
            jobInfo.setId(jobId);
            jobInfo.setTaskClassname("kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecResourceCheckTask");
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("appId", appId);
            params.put("formNum", formNum);
            params.put("pageId", this.getPageCache().getPageId());
            params.put("tagid", tagId);
            params.put("srcmap", srcMap);
            params.put("resourcecheckids", allResourceCheckIdSet.toString());
            jobInfo.setParams(params);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, operateKey);
            JobFormInfo jobFormInfo = new JobFormInfo(jobInfo);
            jobFormInfo.setCaption(ResManager.loadKDString((String)"\u8d44\u6e90\u68c0\u67e5\u5f02\u6b65\u4efb\u52a1\u7684\u6267\u884c", (String)"ResourceCheckExecBaseFormPlugin_01", (String)APPPARAM, (Object[])new Object[0]));
            jobFormInfo.setCloseCallBack(closeCallBack);
            jobFormInfo.setCanBackground(true);
            jobFormInfo.setCanStop(true);
            jobFormInfo.setClickClassName("kd.mpscmm.msplan.mservice.service.resourcecheck.task.ExecResourceCheckClickTask");
            JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.getView());
        }
        catch (Exception e1) {
            logger.warn("ResourceCheckListFormPlugin.execcheck error", (Throwable)e1);
            throw new KDBizException(new ErrorCode("0", e1.getMessage()), new Object[0]);
        }
    }

    public void handleTaskCallBack(Object returnData) {
        try {
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result;
            if (returnData instanceof Map && (result = (Map)returnData).containsKey("taskinfo") && !StringUtils.isBlank((String)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd()) {
                String msgType;
                String data = taskInfo.getData();
                Map dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
                IFormView view = this.getView();
                String msg = String.valueOf(dataMap.get("msg"));
                switch (msgType = String.valueOf(dataMap.get("msgType"))) {
                    case "errorNotice": {
                        view.showErrorNotification(msg);
                        break;
                    }
                    case "showMess": {
                        view.showMessage(msg);
                        break;
                    }
                    case "successNotice": {
                        Integer showTime = (Integer)dataMap.get("showTime");
                        view.showSuccessNotification(msg, showTime);
                        BillList billList = (BillList)this.getView().getControl(this.getBillListAp());
                        billList.refresh();
                        break;
                    }
                }
            }
        }
        catch (Exception e1) {
            logger.warn("ResourceCheckExecBaseFormPlugin.handleTaskCallBack error", (Throwable)e1);
        }
    }
}

