/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.resourcecheck;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mpscmm.msplan.mservice.service.resourcecheck.ResourceCheckDataValidService;
import kd.mpscmm.msplan.resourcecheck.ResourceCheckExecBaseFormPlugin;
import kd.mpscmm.msplan.resourcecheck.consts.ResourceCheckConsts;
import kd.mpscmm.msplan.resourcecheck.utils.ResourceCheckUtils;

public class ResourceCheckListFormPlugin
extends ResourceCheckExecBaseFormPlugin {
    private static final Log logger = LogFactory.getLog(ResourceCheckListFormPlugin.class);
    private static final String OP_EXECCHECK_SEL = "execcheck_select";
    private static final String OP_EXECCHECK = "execcheck";
    private static final String OP_PARAMSET = "paramset";
    private static final String OP_SETDEFAULTVALUE = "setdefaultvale";
    private static final String OP_UNSETDEFAULTVALUE = "unsetdefaultvale";
    private static final String OP_OPTEST = "optest";

    public String getSelectProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("id");
        sb.append(",").append("number");
        sb.append(",").append("enable");
        sb.append(",").append("status");
        sb.append(",").append("idsetfieldtag");
        sb.append(",").append("resultentitynumber");
        sb.append(",").append("isdefault");
        sb.append(",").append("mainentity");
        return sb.toString();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        if (OP_EXECCHECK.equals(operateKey) || OP_EXECCHECK_SEL.equals(operateKey) || OP_SETDEFAULTVALUE.equals(operateKey) || OP_UNSETDEFAULTVALUE.equals(operateKey)) {
            RefObject afterConfirm = new RefObject();
            if (operate.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                return;
            }
            boolean isSetDefValue = OP_SETDEFAULTVALUE.equals(operateKey);
            boolean isUnSetDefValue = OP_UNSETDEFAULTVALUE.equals(operateKey);
            boolean isSelectExec = OP_EXECCHECK_SEL.equals(operateKey);
            Object[] entryPrimaryKeyValues = this.getSelectIdValues();
            QFilter qFilter = new QFilter("id", "in", (Object)entryPrimaryKeyValues);
            String selectProperties = this.getSelectProperties();
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"msplan_resourcecheck", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
            StringBuilder checkMsg = new StringBuilder();
            HashSet<String> mainEntityNumberSet = new HashSet<String>(16);
            HashSet<String> selectRepeatSet = new HashSet<String>(16);
            String mainEntityNumber = "";
            String idSetTag = "";
            for (DynamicObject dy : coll) {
                String number = dy.getString("number");
                String enable = dy.getString("enable");
                String status = dy.getString("status");
                boolean isDef = dy.getBoolean("isdefault");
                mainEntityNumber = dy.getString("mainentity");
                idSetTag = dy.getString("idsetfieldtag");
                if (!(isUnSetDefValue || "1".equals(enable) && "C".equals(status))) {
                    checkMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u68c0\u67e5\u914d\u7f6e\u4e0d\u5904\u4e8e\u5ba1\u6838\u53ef\u7528\u72b6\u6001\u3002", (String)"ResourceCheckListFormPlugin_01", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), number));
                }
                if (isSetDefValue) {
                    if (isDef) {
                        checkMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u68c0\u67e5\u914d\u7f6e\u5df2\u52fe\u9009\u201c\u4e1a\u52a1\u5355\u636e\u5217\u8868\u8fdb\u884c\u8d44\u6e90\u68c0\u67e5\u201d\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u8bbe\u7f6e\u3002", (String)"ResourceCheckListFormPlugin_05", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), number));
                        break;
                    }
                    if (!mainEntityNumberSet.add(mainEntityNumber)) {
                        checkMsg.append(String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u8303\u56f4\u201c%1$s\u201d\u53ea\u5141\u8bb8\u9009\u62e9\u4e00\u4e2a\u914d\u7f6e\u8bbe\u7f6e\u4e3a\u68c0\u67e5\u9879\u70b9\u3002", (String)"ResourceCheckListFormPlugin_06", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), mainEntityNumber));
                        break;
                    }
                }
                if (isUnSetDefValue && !isDef) {
                    checkMsg.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\u201c%1$s\u201d\u7684\u8d44\u6e90\u68c0\u67e5\u914d\u7f6e\u672a\u52fe\u9009\u201c\u4e1a\u52a1\u5355\u636e\u5217\u8868\u8fdb\u884c\u8d44\u6e90\u68c0\u67e5\u201d\uff0c\u4e0d\u5141\u8bb8\u53d6\u6d88\u8bbe\u7f6e\u3002", (String)"ResourceCheckListFormPlugin_09", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), number));
                    break;
                }
                if (!isSelectExec) continue;
                selectRepeatSet.add(idSetTag + "_" + mainEntityNumber);
            }
            if (checkMsg.length() > 1) {
                e.setCancel(true);
                this.getView().showTipNotification(checkMsg.toString());
                return;
            }
            if (isSelectExec) {
                if (selectRepeatSet.size() > 1) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u540c\u4e00\u201c\u68c0\u67e5\u8303\u56f4\u201d\u53ca\u201c\u8fd4\u56de\u5b57\u6bb5\u6807\u8bc6\u201d\u7684\u65b9\u6848\u8fdb\u884c\u9009\u5355\u68c0\u67e5\u3002", (String)"ResourceCheckListFormPlugin_11", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
                } else {
                    List<Long> allPermissionOrgs = this.filterOrgPermission(mainEntityNumber);
                    if (null == allPermissionOrgs || allPermissionOrgs.isEmpty()) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u68c0\u67e5\u8303\u56f4\u201c%1$s\u201d\u7684\u67e5\u770b\u4e1a\u52a1\u6743\u9650\u3002", (String)"ResourceCheckListFormPlugin_12", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]), mainEntityNumber));
                        return;
                    }
                    this.openBizBillF7(mainEntityNumber, idSetTag, allPermissionOrgs);
                }
                return;
            }
            FormOperate source = (FormOperate)e.getSource();
            if (!source.getOption().tryGetVariableValue("afterconfirm", afterConfirm)) {
                ConfirmCallBackListener listener = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                String msg = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5bf9\u9009\u62e9\u7684\u6570\u636e\u6267\u884c\u68c0\u67e5\u5417\uff1f", (String)"ResourceCheckListFormPlugin_02", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                if (isSetDefValue) {
                    msg = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5bf9\u9009\u62e9\u7684\u6570\u636e\u8bbe\u7f6e\u4e3a\u4e1a\u52a1\u5355\u636e\u5217\u8868\u68c0\u67e5\u70b9\u5417\uff1f", (String)"ResourceCheckListFormPlugin_07", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                }
                if (isUnSetDefValue) {
                    msg = ResManager.loadKDString((String)"\u60a8\u786e\u5b9a\u8981\u5bf9\u9009\u62e9\u7684\u6570\u636e\u53d6\u6d88\u4e1a\u52a1\u5355\u636e\u5217\u8868\u68c0\u67e5\u70b9\u5417\uff1f", (String)"ResourceCheckListFormPlugin_10", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                }
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, listener);
                e.setCancel(true);
            }
        } else if (OP_OPTEST.equals(operateKey)) {
            Object[] entryPrimaryKeyValues = this.getSelectIdValues();
            DynamicObject[] dys = BusinessDataServiceHelper.load((Object[])entryPrimaryKeyValues, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"msplan_resourcecheck"));
            StringBuilder msg = new StringBuilder();
            DynamicObject[] dynamicObjectArray = dys;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                ResourceCheckDataValidService services = new ResourceCheckDataValidService();
                DynamicObject dy = dynamicObjectArray[i];
                Map resultMap = services.checkData(dy, "submit", true);
                boolean isValid = (Boolean)resultMap.get("result");
                if (isValid) continue;
                msg.append(dy.getString("number")).append(" ");
                msg.append(resultMap.get("msg").toString());
                msg.append("\r\n");
            }
            if (msg.length() < 1) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6821\u9a8c\u6d4b\u8bd5\u6210\u529f\u3002", (String)"ResourceCheckListFormPlugin_13", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
            } else {
                this.openShowDetialForm(msg.toString());
            }
        } else if (e.getSource() instanceof Save || e.getSource() instanceof Submit) {
            operate.getOption().setVariableValue("appId", this.getView().getFormShowParameter().getAppId());
        }
    }

    private void openShowDetialForm(String msg) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("msplan_rc_detialshow");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setCustomParam("msgString", (Object)msg);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "msplan_rc_detialshow"));
        this.getView().showForm(showParameter);
    }

    private List<Long> filterOrgPermission(String keyEntity) {
        String permItemId = "47150e89000000ac";
        PermissionServiceHelper.clearAllCache();
        Long userId = RequestContext.get().getCurrUserId();
        String appId = ShowFormHelper.getBizAppId((FormShowParameter)this.getView().getFormShowParameter());
        boolean hasViewPermission = PermissionServiceHelper.hasViewPermission((long)userId, (String)appId, (String)keyEntity);
        return hasViewPermission ? PermissionServiceHelper.getAllPermissionOrgs((Long)userId, (String)appId, (String)keyEntity, (String)permItemId) : Collections.emptyList();
    }

    public void openBizBillF7(String bizEntityNumber, String idSetTag, List<Long> allPermissionOrgs) {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)bizEntityNumber, (boolean)true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "execcheck_select_f7"));
        listShowParameter.setCustomParam("useorgIdFilter", allPermissionOrgs);
        listShowParameter.setShowFilter(true);
        listShowParameter.setShowFullScreen(true);
        listShowParameter.setUseOrgIds(allPermissionOrgs);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        MessageBoxResult result;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((OP_EXECCHECK.equals(callBackId) || OP_SETDEFAULTVALUE.equals(callBackId) || OP_UNSETDEFAULTVALUE.equals(callBackId)) && MessageBoxResult.Yes.equals((Object)(result = messageBoxClosedEvent.getResult()))) {
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("afterconfirm", "true");
            this.getView().invokeOperation(callBackId, operateOption);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if (OP_EXECCHECK.equals(operateKey)) {
            Object[] entryPrimaryKeyValues = this.getSelectIdValues();
            HashSet<Long> allResourceCheckIds = new HashSet<Long>(16);
            HashMap<Long, Set<Long>> srcMap = new HashMap<Long, Set<Long>>(16);
            Long tagId = ResourceCheckUtils.buildResultData((Object[])entryPrimaryKeyValues, allResourceCheckIds, srcMap);
            this.createJob(tagId, allResourceCheckIds, operateKey, srcMap);
        }
        if (OP_PARAMSET.equals(operateKey)) {
            this.showConfigSetForm();
        }
        if (OP_SETDEFAULTVALUE.equals(operateKey) || OP_UNSETDEFAULTVALUE.equals(operateKey)) {
            ResourceCheckUtils.setDefaultValue((Object[])this.getSelectIdValues(), (boolean)OP_SETDEFAULTVALUE.equals(operateKey));
            this.refreshData();
        }
    }

    private void refreshData() {
        BillList billList = (BillList)this.getView().getControl(this.getBillListAp());
        billList.refresh();
    }

    private void showConfigSetForm() {
        BaseShowParameter baseShowParameter = new BaseShowParameter();
        baseShowParameter.setFormId("msplan_rc_paramset");
        baseShowParameter.setPkId((Object)ResourceCheckConsts.KEY_PARAMDEFID);
        baseShowParameter.setCustomParam("view", (Object)Boolean.TRUE);
        baseShowParameter.setShowTitle(true);
        baseShowParameter.setCaption(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e", (String)"ResourceCheckListFormPlugin_04", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]));
        OperationStatus operationStatus = OperationStatus.EDIT;
        baseShowParameter.setStatus(operationStatus);
        baseShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss css = new StyleCss();
        css.setWidth("1080px");
        css.setHeight("400px");
        baseShowParameter.getOpenStyle().setInlineStyleCss(css);
        this.getView().showForm((FormShowParameter)baseShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        if (OP_EXECCHECK.equals(actionId) || OP_EXECCHECK_SEL.equals(actionId)) {
            this.handleTaskCallBack(closedCallBackEvent.getReturnData());
        }
        if ("execcheck_select_f7".equals(actionId)) {
            ListSelectedRowCollection returnLSRC;
            ListSelectedRowCollection listSelectedRowCollection = returnLSRC = returnData instanceof ListSelectedRowCollection ? (ListSelectedRowCollection)returnData : null;
            if (returnLSRC == null || returnLSRC.isEmpty()) {
                return;
            }
            Object[] bizIds = returnLSRC.getPrimaryKeyValues();
            Set bizIdSet = Arrays.stream(bizIds).mapToLong(obj -> (Long)obj).boxed().collect(Collectors.toSet());
            Object[] resourceCheckIds = this.getSelectIdValues();
            Set resourceCheckIdSet = Arrays.stream(resourceCheckIds).mapToLong(obj -> (Long)obj).boxed().collect(Collectors.toSet());
            HashSet<Long> allResourceCheckIds = new HashSet<Long>(16);
            HashMap<Long, Set<Long>> srcMap = new HashMap<Long, Set<Long>>(16);
            Long tagId = ResourceCheckUtils.buildResultData(bizIdSet, resourceCheckIdSet, allResourceCheckIds, srcMap);
            this.createJob(tagId, allResourceCheckIds, OP_EXECCHECK_SEL, srcMap);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        super.billListHyperLinkClick(e);
        if (e == null || e.getFieldName() == null) {
            return;
        }
        String fieldName = e.getFieldName();
        if ("lastcheckresult".equals(fieldName)) {
            e.setCancel(true);
            BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)e.getHyperLinkClickEvent();
            if (event != null) {
                String entityNumber;
                ListSelectedRow currentRow = event.getCurrentRow() == null ? this.getSelectedRows().get(0) : event.getCurrentRow();
                Long pkId = (Long)currentRow.getPrimaryKeyValue();
                DynamicObject resourceCheck = this.getResourceCheck(pkId);
                Long resultId = resourceCheck == null ? 0L : resourceCheck.getLong("lastcheckresultid");
                String string = entityNumber = resourceCheck == null ? "" : resourceCheck.getString("resultentitynumber");
                if (resultId == null || resultId.equals(0L)) {
                    String msg = ResManager.loadKDString((String)"\u5f53\u524d\u8d44\u6e90\u68c0\u67e5\u914d\u7f6e\u6ca1\u6709\u5bf9\u5e94\u7684\u68c0\u67e5\u7ed3\u679c\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u5237\u65b0\u5904\u7406\u3002", (String)"ResourceCheckListFormPlugin_08", (String)"mpscmm-msplan-formplugin", (Object[])new Object[0]);
                    this.getView().showTipNotification(msg);
                    e.setCancel(true);
                    return;
                }
                this.toResouceCheckResultView(entityNumber, resultId);
            }
        }
    }

    public DynamicObject getResourceCheck(Long id) {
        String selectFields = "lastcheckresultid,resultentitynumber";
        QFilter qf = new QFilter("id", "=", (Object)id);
        return QueryServiceHelper.queryOne((String)"msplan_resourcecheck", (String)selectFields, (QFilter[])new QFilter[]{qf});
    }

    private void toResouceCheckResultView(String entityName, Long resultId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(entityName);
        showParameter.setPkId((Object)resultId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String showMode = this.getView().getFormShowParameter().getAppId();
        if (!"msplan".equals(showMode) && !"msmpmm".equals(showMode)) {
            e.getQFilters().add(new QFilter("fieldappid", "=", (Object)showMode));
        }
    }
}

