/*
 * Decompiled with CFR 0.152.
 */
package kd.mpscmm.msplan.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.HttpClientUtils;
import kd.bos.util.JSONUtils;
import kd.mpscmm.common.enums.CfgItemEnum;
import kd.mpscmm.common.enums.ConfigItemDataType;
import kd.mpscmm.metadatascan.MetadataDTO;
import kd.mpscmm.msplan.webapi.enums.SQLErrorTypeEnum;
import kd.mpscmm.msplan.webapi.extpoint.IScriptCheckExtPlugin;
import kd.mpscmm.msplan.webapi.extpoint.ScriptCheckExtFactory;
import kd.mpscmm.msplan.webapi.helper.CheckToolParam;
import kd.mpscmm.msplan.webapi.helper.SQLScriptScanHelper;
import kd.mpscmm.msplan.webapi.model.PipelineCustomApiModel;

@ApiController(desc="\u5143\u6570\u636e\u68c0\u67e5\u63a5\u53e3", value="msplan")
public class MetadataCheckApiService
implements Serializable {
    private final Log log = LogFactory.getLog(MetadataCheckApiService.class);
    private final String METADATA_CHECK_REGION = "METADATA_CHECK_REGION";
    private final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("METADATA_CHECK_REGION");

    private String getType() {
        String METADATA_CHECK_REGION_TYPE = "METADATA_CHECK_REGION_TYPE";
        return METADATA_CHECK_REGION_TYPE + "." + CacheKeyUtil.getAcctId();
    }

    private String getCache(String key) {
        return (String)this.cache.get(this.getType(), key);
    }

    private void putCache(String key, String value) {
        int timeout = 3600;
        this.cache.put(this.getType(), key, value, timeout, TimeUnit.SECONDS);
    }

    private void removeCache(String key) {
        this.cache.remove(this.getType(), key);
    }

    @ApiPostMapping(value="metadataCheck")
    public CustomApiResult<PipelineCustomApiModel<String>> metadataCheck(@ApiParam(value="pId") @ApiParam(value="pId") String pId, @ApiParam(value="runId") @ApiParam(value="runId") String runId, @ApiParam(value="taskId") @ApiParam(value="taskId") String taskId, @ApiParam(value="pipelineInfo") @ApiParam(value="pipelineInfo") Map<String, Object> pipelineInfo) {
        PipelineCustomApiModel<String> pipelineCustomApiModel = PipelineCustomApiModel.success("");
        if (StringUtils.isBlank((CharSequence)pId)) {
            String errorString = ResManager.loadKDString((String)"pId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_2", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3002", errorString);
        }
        if (StringUtils.isBlank((CharSequence)runId)) {
            String errorString = ResManager.loadKDString((String)"runId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_3", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3000", errorString);
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            String errorString = ResManager.loadKDString((String)"taskId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_4", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3001", errorString);
        }
        if (pipelineInfo == null || pipelineInfo.isEmpty()) {
            String errorString = ResManager.loadKDString((String)"\u4f20\u5165\u7684pipelineInfo\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_1", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3002", errorString);
        }
        ThreadPools.executeOnceIncludeRequestContext((String)"metadataCheck-sync", () -> {
            String groupKey = String.format("%s-%s-%s", pId, runId, taskId);
            this.putCache(groupKey, "1");
            try {
                String appBranchType = pipelineInfo.getOrDefault("appBranchType", "patch");
                appBranchType = appBranchType == null ? "patch" : appBranchType;
                String appName = (String)pipelineInfo.get("appName");
                appName = appName == null ? "" : appName;
                String key = String.format("MetadataCheckApiService/metadataCheck/%s/%s", appBranchType, appName);
                try (DLock lock = DLock.create((String)key);){
                    String state;
                    String level;
                    String error;
                    lock.lock();
                    try {
                        error = SQLScriptScanHelper.metadataAndSqlCheck4GitBranch(runId, appBranchType, appName);
                    }
                    catch (Exception e) {
                        error = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                    }
                    if (StringUtils.isNotBlank((CharSequence)appName)) {
                        String[] str1 = appName.split("-");
                        String o = "";
                        if (str1.length > 1) {
                            MetadataDTO metadataDTO = new MetadataDTO(str1[0], str1[1], appBranchType);
                            try {
                                o = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"MetadataCheckService", (String)"metadataCheck", (Object[])new Object[]{metadataDTO});
                            }
                            catch (Exception e) {
                                o = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                            }
                        }
                        if (StringUtils.isNotBlank((CharSequence)o)) {
                            String msg = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u5dee\u5f02\u626b\u63cf\u7ed3\u679c\uff1a%1$s\u3002", (String)"MetadataCheckApiService_5", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), o);
                            error = error + "\r\n" + msg;
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)error)) {
                        level = "error";
                        state = "4";
                    } else {
                        level = "info";
                        state = "3";
                    }
                    Map<CfgItemEnum, Object> sysConfig = MetadataCheckApiService.load();
                    boolean isProdEnv = (Boolean)sysConfig.getOrDefault(CfgItemEnum.IS_PROD_ENV, CfgItemEnum.IS_PROD_ENV.getDefaultValue());
                    boolean isTest = !isProdEnv;
                    Map<String, DynamicObject> paramSetMap = this.initParamSet(appName, isTest);
                    ApiParamSet apiParamSet = MetadataCheckApiService.getApiParamBySet(paramSetMap, isTest ? "pipeline" : "csp", isTest);
                    String finalError = error;
                    HashMap<String, String> header = new HashMap<String, String>();
                    header.put("Content-type", "application/json;charset=UTF-8");
                    String accesstoken = this.getAccessToken(header, apiParamSet.getTenantId(), apiParamSet.getAccountId(), apiParamSet.getHost(), apiParamSet.getAppId(), apiParamSet.getAppSecret());
                    header.put("accesstoken", accesstoken);
                    HashMap<String, Object> logParams = new HashMap<String, Object>();
                    logParams.put("serviceId", appName);
                    logParams.put("serviceName", ResManager.loadKDString((String)"\u5143\u6570\u636e\u68c0\u67e5\u670d\u52a1\uff08\u5236\u9020\uff09", (String)"MetadataCheckApiService_12", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]));
                    logParams.put("pipelineId", pId);
                    logParams.put("runId", runId);
                    logParams.put("taskId", taskId);
                    logParams.put("logTime", System.currentTimeMillis());
                    logParams.put("level", level);
                    logParams.put("data", StringUtils.isNotBlank((CharSequence)finalError) ? finalError : ResManager.loadKDString((String)"\u5143\u6570\u636e\u811a\u672c\u68c0\u67e5\u5b8c\u6210\uff0c\u672a\u53d1\u73b0\u5f02\u5e38\u4fe1\u606f", (String)"MetadataCheckApiService_13", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]));
                    HashMap<String, Object> callBackParams = new HashMap<String, Object>();
                    callBackParams.put("state", state);
                    callBackParams.put("pId", pId);
                    callBackParams.put("runId", runId);
                    callBackParams.put("taskId", taskId);
                    if (StringUtils.isNotBlank((CharSequence)apiParamSet.getHost())) {
                        this.httpRequestPostJson(header, logParams, apiParamSet.getHost(), "/kapi/app/pipe/LogForwardApi");
                        this.httpRequestPostJson(header, callBackParams, apiParamSet.getHost(), "/kapi/app/pipe/callbackTask");
                    }
                    this.autoInputBug(runId, appBranchType, appName, isTest, paramSetMap, sysConfig);
                }
            }
            catch (Exception e) {
                this.log.error("metadataAndSqlCheck4GitBranch-metadataCheckError", (Throwable)e);
            }
            finally {
                this.removeCache(groupKey);
            }
        });
        return CustomApiResult.success(pipelineCustomApiModel);
    }

    private static ApiParamSet getApiParamBySet(Map<String, DynamicObject> paramSetMap, String appId, boolean isTest) {
        String key = "0-" + appId + (isTest ? "-0" : "-1");
        DynamicObject paramSet = paramSetMap.get(key);
        ApiParamSet apiParamSet = new ApiParamSet();
        if (paramSet != null) {
            apiParamSet.setHost(paramSet.getString("host"));
            apiParamSet.setAccountId(paramSet.getString("accountid"));
            apiParamSet.setTenantId(paramSet.getString("tenantid"));
            apiParamSet.setAppId(appId);
            apiParamSet.setAppSecret(paramSet.getString("appsecuret"));
        }
        return apiParamSet;
    }

    private static Map<CfgItemEnum, Object> load() {
        DynamicObjectCollection col = QueryServiceHelper.query((String)"msplan_metasql_calcset", (String)"id,number,name,paramtype,param", (QFilter[])new QFilter[]{new QFilter("number", "is not null", (Object)"")});
        HashMap<CfgItemEnum, Object> sysConfig = new HashMap<CfgItemEnum, Object>(col.size());
        for (DynamicObject obj : col) {
            CfgItemEnum item = CfgItemEnum.valueOf((String)obj.getString("number"));
            Object val = item.getValueType() == ConfigItemDataType.VT_INT ? Integer.valueOf(obj.getString("param")) : (item.getValueType() == ConfigItemDataType.VT_STRING ? obj.getString("param") : (item.getValueType() == ConfigItemDataType.VT_BOOLEAN ? (Serializable)Boolean.valueOf(obj.getString("param")) : (Serializable)(item.getValueType() == ConfigItemDataType.VT_BIGDECIMAL ? new BigDecimal(obj.getString("param")) : (item.getValueType() == ConfigItemDataType.VT_LONG ? Long.valueOf(obj.getString("param")) : null))));
            sysConfig.put(item, val);
        }
        return sysConfig;
    }

    private Map<String, DynamicObject> initParamSet(String appName, boolean isTest) {
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            String[] str = appName.split("-");
            appName = str.length > 1 ? str[1] : appName;
        }
        QFilter qFilter = new QFilter("isproconfig", "=", (Object)(!isTest ? 1 : 0));
        DynamicObjectCollection datas = QueryServiceHelper.query((String)"msplan_metasql_paramset", (String)"paramtype,appid,pic,appname,appsecuret,host,tenantid,accountid,isproconfig", (QFilter[])new QFilter[]{qFilter});
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(datas.size());
        for (DynamicObject data : datas) {
            if ("1".equals(data.getString("paramtype")) && StringUtils.isNotBlank((CharSequence)appName) && !appName.equals(data.getString("appid"))) continue;
            String key = data.getString("paramtype") + "-" + data.getString("appid") + "-" + (data.getBoolean("isproconfig") ? "1" : "0");
            map.put(key, data);
        }
        return map;
    }

    private String getAccessToken(Map<String, String> header, String tenantId, String accountId, String host, String appId, String appSecret) {
        HashMap<String, String> params = new HashMap<String, String>(4);
        params.put("appId", appId);
        params.put("appKey", appSecret);
        params.put("appSecret", appSecret);
        params.put("tenantId", tenantId);
        params.put("accountId", accountId);
        params.put("language", "zh_CN");
        String accesstoken = "";
        try {
            JSONObject data;
            KDBizException kdBizException;
            JSONObject resp;
            String app_token = "";
            String param = JSONUtils.toString(params);
            String sHttpResponse = HttpClientUtils.postjson((String)(host + "/api/getAppToken.do"), header, (String)param);
            if (StringUtils.isNotBlank((CharSequence)sHttpResponse)) {
                resp = JSONObject.parseObject((String)sHttpResponse);
                if (resp.containsKey((Object)"success") && !resp.getBoolean("success").booleanValue() || resp.containsKey((Object)"status") && !resp.getBoolean("status").booleanValue()) {
                    kdBizException = this.getKDBizExceptionByHttpResponse(resp);
                    this.log.error("metadataAndSqlCheck4GitBranch-getAppTokenFail", (Throwable)kdBizException);
                } else {
                    data = resp.getJSONObject("data");
                    app_token = data.getString("app_token");
                }
            }
            if (StringUtils.isNotBlank((CharSequence)app_token)) {
                params.put("user", "17299999999");
                params.put("usertype", "Mobile");
                params.put("apptoken", app_token);
                param = JSONUtils.toString(params);
                sHttpResponse = HttpClientUtils.postjson((String)(host + "/api/login.do"), header, (String)param);
                if (StringUtils.isNotBlank((CharSequence)sHttpResponse)) {
                    resp = JSONObject.parseObject((String)sHttpResponse);
                    if (resp.containsKey((Object)"success") && !resp.getBoolean("success").booleanValue() || resp.containsKey((Object)"status") && !resp.getBoolean("status").booleanValue()) {
                        kdBizException = this.getKDBizExceptionByHttpResponse(resp);
                        this.log.error("metadataAndSqlCheck4GitBranch-getLoginFail", (Throwable)kdBizException);
                    } else {
                        data = resp.getJSONObject("data");
                        accesstoken = data.getString("access_token");
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error("metadataAndSqlCheck4GitBranch-getAppTokenError", (Throwable)e);
        }
        return accesstoken;
    }

    private void httpRequestPostJson(Map<String, String> header, Map<String, Object> params, String host, String service) {
        try {
            JSONObject resp;
            String param = JSONUtils.toString(params);
            String sHttpResponse = HttpClientUtils.postjson((String)(host + service), header, (String)param);
            if (StringUtils.isNotBlank((CharSequence)sHttpResponse) && ((resp = JSONObject.parseObject((String)sHttpResponse)).containsKey((Object)"success") && !resp.getBoolean("success").booleanValue() || resp.containsKey((Object)"status") && !resp.getBoolean("status").booleanValue())) {
                KDBizException kdBizException = this.getKDBizExceptionByHttpResponse(resp);
                this.log.error("metadataAndSqlCheck4GitBranch-httpRequestPostJsonFail", (Throwable)kdBizException);
            }
        }
        catch (Exception e) {
            this.log.error("metadataAndSqlCheck4GitBranch-httpRequestPostJsonError", (Throwable)e);
        }
    }

    private KDBizException getKDBizExceptionByHttpResponse(JSONObject resp) {
        String errorCode;
        String errorMsg = resp.getString("message");
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = resp.getString("error_desc");
        }
        if (StringUtils.isBlank((CharSequence)errorMsg)) {
            errorMsg = resp.getString("error");
        }
        if (StringUtils.isBlank((CharSequence)(errorCode = resp.getString("errorCode")))) {
            errorCode = resp.getString("error_code");
        }
        return new KDBizException(new ErrorCode(errorCode, errorMsg), new Object[0]);
    }

    private CustomApiResult<PipelineCustomApiModel<String>> getFailResult(String errorCode, String errorMessage) {
        CustomApiResult result = CustomApiResult.fail((String)errorCode, (String)errorMessage);
        result.setData(PipelineCustomApiModel.fail(errorCode, errorMessage));
        return result;
    }

    private void autoInputBug(String buildId, String gitBranch, String appName, boolean isTest, Map<String, DynamicObject> paramSetMap, Map<CfgItemEnum, Object> sysConfig) {
        ApiParamSet apiParamSet = MetadataCheckApiService.getApiParamBySet(paramSetMap, isTest ? "ksm" : "metadata-scan-server", isTest);
        ArrayList<String> bugs = new ArrayList<String>(4);
        HashMap<String, DynamicObject> bug2Log = new HashMap<String, DynamicObject>(4);
        ArrayList<DynamicObject> needInputBugData = new ArrayList<DynamicObject>(4);
        ArrayList<DynamicObject> saves = new ArrayList<DynamicObject>(16);
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(16);
        QFilter qFilterBuild = new QFilter("buildid", "=", (Object)buildId);
        QFilter qFilter = new QFilter("gitbranch", "=", (Object)gitBranch);
        QFilter qFilterWhite = new QFilter("iswhitelist", "=", (Object)false);
        QFilter qFilterHost = new QFilter("host", "=", (Object)apiParamSet.getHost());
        boolean isInputBug = (Boolean)sysConfig.getOrDefault(CfgItemEnum.IS_INPUT_DMP_BUG, CfgItemEnum.IS_INPUT_DMP_BUG.getDefaultValue());
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            String[] str = appName.split("-");
            qFilter.and("appid", "=", (Object)(str.length > 1 ? str[1] : appName));
        }
        DynamicObject[] existBugDatas = BusinessDataServiceHelper.load((String)"msplan_metasql_buglog", (String)"id,buildid,gitbranch,exceptioninfo,appid,sqlname,metadatakey,tablename,errortype,sql,bugno,bugstatus,host,isinputbug", (QFilter[])new QFilter[]{qFilter, qFilterHost});
        HashMap<String, Map> existErrorType2Infos = new HashMap<String, Map>(8);
        for (DynamicObject data : existBugDatas) {
            String errorType = data.getString("errortype");
            Map map = existErrorType2Infos.computeIfAbsent(errorType, k -> new HashMap(16));
            String key = this.getKeyBySqlErrorType(errorType, new CheckToolParam.OnlyGetMap(data));
            if (StringUtils.isNotBlank((CharSequence)key)) {
                List list = map.computeIfAbsent(key, k -> new ArrayList(1));
                list.add(data);
            }
            String bug = data.getString("bugno");
            String bugstatus = data.getString("bugstatus");
            if (StringUtils.isNotBlank((CharSequence)bug)) {
                if (ResManager.loadKDString((String)"\u9a8c\u8bc1\u901a\u8fc7", (String)"MetadataCheckApiService_11", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]).equals(bugstatus)) continue;
                bugs.add(bug);
                bug2Log.put(bug, data);
                continue;
            }
            if (!data.getBoolean("isinputbug") || !isInputBug) continue;
            needInputBugData.add(data);
            updates.add(data);
        }
        HashMap<String, Map> errorType2Infos = new HashMap<String, Map>(8);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getSimpleName(), (String)"msplan_metasql_checklog", (String)"buildid,gitbranch,exceptioninfo,appid,sqlname,metadatakey,tablename,errortype,sql", (QFilter[])new QFilter[]{qFilterBuild, qFilter, qFilterWhite}, null);){
            Field[] fields = dataSet.getRowMeta().getFields();
            for (Row row : dataSet) {
                DynamicObject bugLog;
                List listBugs;
                String errorType = row.getString("errortype");
                Map map = errorType2Infos.computeIfAbsent(errorType, k -> new HashMap(16));
                String key = this.getKeyBySqlErrorType(errorType, new CheckToolParam.OnlyGetMap(row));
                String newExceptioninfo = row.getString("exceptioninfo");
                Map existMap = (Map)existErrorType2Infos.get(errorType);
                if (!StringUtils.isNotBlank((CharSequence)key)) continue;
                if (existMap != null && (listBugs = (List)existMap.get(key)) != null) {
                    boolean isExist = false;
                    for (DynamicObject existBug : listBugs) {
                        if (existBug == null) continue;
                        String bugstatus = existBug.getString("bugstatus");
                        String bug = existBug.getString("bugno");
                        if (!existBug.getString("exceptioninfo").contains(newExceptioninfo) || !StringUtils.isBlank((CharSequence)bug) && ResManager.loadKDString((String)"\u9a8c\u8bc1\u901a\u8fc7", (String)"MetadataCheckApiService_11", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]).equals(bugstatus)) continue;
                        isExist = true;
                        break;
                    }
                    if (isExist) continue;
                }
                if ((bugLog = (DynamicObject)map.get(key)) == null) {
                    bugLog = BusinessDataServiceHelper.newDynamicObject((String)"msplan_metasql_buglog");
                    for (Field field : fields) {
                        bugLog.set(field.getName(), (Object)row.getString(field.getAlias()));
                    }
                    bugLog.set("host", (Object)apiParamSet.getHost());
                    bugLog.set("isinputbug", (Object)isInputBug);
                    map.put(key, bugLog);
                    saves.add(bugLog);
                    if (!isInputBug) continue;
                    needInputBugData.add(bugLog);
                    continue;
                }
                newExceptioninfo = bugLog.getString("exceptioninfo") + "\r\n" + newExceptioninfo;
                bugLog.set("exceptioninfo", (Object)newExceptioninfo);
            }
        }
        int batch = 5;
        HashMap<String, String> module2route = new HashMap<String, String>(4);
        HashMap<String, String> appId2appName = new HashMap<String, String>(4);
        ExeMethodParam exeMethodParam = new ExeMethodParam();
        exeMethodParam.setBug2Log(bug2Log);
        exeMethodParam.setUpdates(updates);
        exeMethodParam.setAppId2appName(appId2appName);
        exeMethodParam.setModule2route(module2route);
        exeMethodParam.setTest(isTest);
        exeMethodParam.setParamSetMap(paramSetMap);
        this.loopBatchExeMethod(batch, apiParamSet.getHost(), apiParamSet.getAppId(), apiParamSet.getAppSecret(), apiParamSet.getAccountId(), bugs, exeMethodParam, String.class);
        this.loopBatchExeMethod(batch, apiParamSet.getHost(), apiParamSet.getAppId(), apiParamSet.getAppSecret(), apiParamSet.getAccountId(), needInputBugData, exeMethodParam, DynamicObject.class);
        if (!saves.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])saves.toArray(new DynamicObject[0]));
        }
        if (!updates.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])updates.toArray(new DynamicObject[0]));
        }
    }

    private <T> void loopBatchExeMethod(int batch, String host, String appId, String appSecret, String accountId, List<T> params, ExeMethodParam exeMethodParam, Class<?> paramClass) {
        int count = 0;
        ArrayList<String> values = new ArrayList<String>(batch);
        Iterator<T> iter = params.iterator();
        do {
            count = 0;
            values.clear();
            while (iter.hasNext()) {
                T v = iter.next();
                values.add((String)v);
                if (++count != batch) continue;
                break;
            }
            if (paramClass == String.class) {
                this.queryDmpBugMethod(host, appId, appSecret, accountId, values, exeMethodParam);
                continue;
            }
            if (paramClass != DynamicObject.class) continue;
            this.insertDmpBugMethod(host, appId, appSecret, accountId, values, exeMethodParam);
        } while (count >= batch);
    }

    private void insertDmpBugMethod(String host, String appId, String appSecret, String accountId, List<DynamicObject> needInputBugData, ExeMethodParam exeMethodParam) {
        try {
            JSONArray jsonArray = this.insertDmpBug(host, appId, appSecret, accountId, needInputBugData, exeMethodParam);
            if (jsonArray != null) {
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    Integer dindex = jsonObject.getInteger("dindex");
                    String bugno = jsonObject.getString("number");
                    if (dindex == null || dindex < 0 || dindex >= needInputBugData.size()) continue;
                    DynamicObject bugData = needInputBugData.get(dindex);
                    bugData.set("bugno", (Object)bugno);
                    bugData.set("bugstatus", (Object)ResManager.loadKDString((String)"\u5f85\u4fee\u590d", (String)"MetadataCheckApiService_10", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            this.log.error("metadataAndSqlCheck4GitBranch-insertDmpBugError", (Throwable)exception);
        }
    }

    private void queryDmpBugMethod(String host, String appId, String appSecret, String accountId, List<String> bugs, ExeMethodParam exeMethodParam) {
        try {
            JSONArray jsonArray = this.queryDmpBug(host, appId, appSecret, accountId, bugs);
            if (jsonArray != null) {
                for (Object obj : jsonArray) {
                    JSONObject jsonObject = (JSONObject)obj;
                    String bugno = jsonObject.getString("number");
                    String bugstatus = jsonObject.getString("processstatus");
                    DynamicObject bugLog = exeMethodParam.getBug2Log().get(bugno);
                    if (bugLog == null || bugLog.getString("bugstatus").equals(bugstatus)) continue;
                    bugLog.set("bugstatus", (Object)bugstatus);
                    exeMethodParam.getUpdates().add(bugLog);
                }
            }
        }
        catch (Exception exception) {
            this.log.error("metadataAndSqlCheck4GitBranch-queryDmpBugError", (Throwable)exception);
        }
    }

    private String getKeyBySqlErrorType(String sqlErrorType, CheckToolParam.OnlyGetMap onlyGetMap) {
        IScriptCheckExtPlugin scriptCheckExtPlugin;
        SQLErrorTypeEnum sqlErrorTypeEnum = SQLErrorTypeEnum.getByValue(sqlErrorType);
        String key = null;
        switch (sqlErrorTypeEnum) {
            case TABLE_MISS_ERROR: {
                key = onlyGetMap.getString("appid") + "-" + onlyGetMap.getString("metadatakey") + "-" + onlyGetMap.getString("tablename");
                break;
            }
            case FIELD_TYPE_INCONSISTENT: 
            case APPLICATION_INCONSISTENT: 
            case BIZ_CREATE_BOS_TABLE: {
                key = onlyGetMap.getString("appid") + "-" + onlyGetMap.getString("metadatakey") + "-" + onlyGetMap.getString("tablename") + "-" + onlyGetMap.getString("sqlname");
                break;
            }
            case SQL_EXCEPTION: 
            case TABLE_FIELD_NOT_UPPER: 
            case SQL_VIOLATION_NOTNULL: {
                String sql = onlyGetMap.getString("sql").replaceAll("\\s*|\r|\n|\t", "");
                key = onlyGetMap.getString("appid") + "-" + onlyGetMap.getString("sqlname") + "-" + sql;
                break;
            }
            case SQL_FILE_ENCODING_ERROR: {
                key = onlyGetMap.getString("appid") + "-" + onlyGetMap.getString("sqlname");
                break;
            }
        }
        if (StringUtils.isBlank(key) && (scriptCheckExtPlugin = ScriptCheckExtFactory.getScriptCheckExtPlugin(sqlErrorType)) != null) {
            key = scriptCheckExtPlugin.getBugRecordUniqueKey(onlyGetMap);
        }
        return key;
    }

    private JSONArray insertDmpBug(String host, String appId, String appSecret, String accountId, List<DynamicObject> needInputBugDatas, ExeMethodParam exeMethodParam) throws Exception {
        if (needInputBugDatas == null || needInputBugDatas.isEmpty()) {
            return null;
        }
        ArrayList dataList = new ArrayList(needInputBugDatas.size());
        for (DynamicObject bugLog : needInputBugDatas) {
            String appkey = bugLog.getString("appid");
            String gitbranch = bugLog.getString("gitbranch");
            String appName = exeMethodParam.getAppId2appName().computeIfAbsent(appkey, k -> {
                DynamicObject bizApp = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_devportal_bizapp", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)appkey)});
                return bizApp == null ? "" : bizApp.getString("name");
            });
            String routeId = exeMethodParam.getModule2route().computeIfAbsent(appkey.toUpperCase(Locale.ENGLISH), k -> {
                try {
                    return this.queryDmpModuleId(host, appId, appSecret, (String)k);
                }
                catch (Exception exception) {
                    return "";
                }
            });
            String des = bugLog.getString("exceptioninfo");
            String sql = bugLog.getString("sql");
            if (StringUtils.isNotBlank((CharSequence)sql)) {
                des = String.format("%s\r\nSQL\uff1a%s", des, sql);
            }
            String dataenv = ResManager.loadKDString((String)"https://feature.kingdee.com:1024/patchscm/?formId=pc_devportal_main  \u4e3b\u5e72\u5192\u70df\u73af\u5883-\u5f00\u53d1\u5e73\u53f0-\u5143\u6570\u636e\u811a\u672c\u68c0\u67e5BUG\u8bb0\u5f55\uff08msplan_metasql_buglog\uff09", (String)"MetadataCheckApiService_8", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            if ("feature_sit".equals(gitbranch)) {
                dataenv = ResManager.loadKDString((String)"https://feature.kingdee.com:1024/feature_sit_scm/?formId=pc_devportal_main  \u957f\u5206\u652f\u5192\u70df\u73af\u5883-\u5f00\u53d1\u5e73\u53f0-\u5143\u6570\u636e\u811a\u672c\u68c0\u67e5BUG\u8bb0\u5f55\uff08msplan_metasql_buglog\uff09", (String)"MetadataCheckApiService_9", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            }
            String bugdes = String.format(ResManager.loadKDString((String)"\u3010\u5143\u6570\u636e\u811a\u672c\u68c0\u67e5\u5de5\u5177\u3011\u3010%1$s\u3011\uff1a%2$s", (String)"MetadataCheckApiService_7", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]), appName, des);
            HashMap<String, String> map = new HashMap<String, String>(8);
            map.put("name", bugdes.length() > 100 ? bugdes.substring(0, 100) : bugdes);
            map.put("bugdes", des);
            map.put("dataenv", dataenv);
            String pic = "";
            DynamicObject paramSet = exeMethodParam.getParamSetMap().get("1-" + appkey + (exeMethodParam.isTest() ? "-0" : "-1"));
            if (paramSet != null) {
                pic = paramSet.getString("pic");
            }
            if (StringUtils.isNotBlank((CharSequence)pic)) {
                map.put("pic", pic);
            }
            map.put("route", routeId);
            map.put("product", ResManager.loadKDString((String)"\u5236\u9020\u811a\u672c\u5143\u6570\u636e\u5de5\u5177\u626b\u63cf", (String)"MetadataCheckApiService_14", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]));
            dataList.add(map);
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("action", "insert");
        params.put("data", dataList);
        String data = JSON.toJSONString(params);
        return this.postDmpApiByJson(host, appId, appSecret, accountId, data);
    }

    private JSONArray queryDmpBug(String host, String appId, String appSecret, String accountId, List<String> bugs) throws Exception {
        if (bugs == null || bugs.isEmpty()) {
            return null;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("action", "query");
        params.put("data", bugs);
        String data = JSON.toJSONString(params);
        return this.postDmpApiByJson(host, appId, appSecret, accountId, data);
    }

    private JSONArray postDmpApiByJson(String host, String appId, String appSecret, String accountId, String postJson) throws Exception {
        String uudid = UUID.randomUUID().toString().replace("-", "");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        String digest = postJson + date + uudid;
        String sign1 = this.HMACSHA256StrByKey(digest, appSecret);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        headerMap.put("appId", appId);
        headerMap.put("signature", sign1);
        headerMap.put("timestamp", date);
        headerMap.put("signatureNonce", uudid);
        headerMap.put("user", "13899999999");
        headerMap.put("usertype", "Mobile");
        headerMap.put("accountId", accountId);
        String json = HttpClientUtils.postjson((String)(host + "/kapi/app/dmp/DmpBugApi"), headerMap, (String)postJson);
        JSONObject jsonObject = JSON.parseObject((String)json);
        if (jsonObject.getBoolean("success").booleanValue()) {
            return jsonObject.getJSONArray("data");
        }
        KDBizException kdBizException = this.getKDBizExceptionByHttpResponse(jsonObject);
        this.log.error("metadataAndSqlCheck4GitBranch-postDmpApiFail", (Throwable)kdBizException);
        return null;
    }

    private String queryDmpModuleId(String host, String appId, String appSecret, String dmpModuleCode) throws Exception {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String content = "select=id,number,name,useorg,group,parentmoduleid,levelnum,modulecode,relevanceteam&filter=group.number EQ P000398 and levelnum in 1,2 and modulecode EQ " + dmpModuleCode;
        String encyptString = this.HMACSHA256StrByKey(content + timestamp + uuid, appSecret);
        HashMap<String, String> queryParaMap = new HashMap<String, String>();
        queryParaMap.put("appId", appId);
        queryParaMap.put("user", "13899999999");
        queryParaMap.put("signatureNonce", uuid);
        queryParaMap.put("select", "id,number,name,useorg,group,parentmoduleid,levelnum,modulecode,relevanceteam");
        queryParaMap.put("filter", "group.number EQ P000398 and levelnum in 1,2 and modulecode EQ " + dmpModuleCode);
        queryParaMap.put("signature", encyptString);
        queryParaMap.put("parameters", "select,filter");
        queryParaMap.put("timestamp", timestamp);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json");
        String responseString = HttpClientUtils.get((String)(host + "/kapi/sys/dmp_module_org/query"), headerMap, queryParaMap);
        JSONObject response = JSON.parseObject((String)responseString);
        if (response.getBoolean("success").booleanValue()) {
            JSONObject data = response.getJSONObject("data");
            JSONArray rows = data.getJSONArray("rows");
            return rows != null && !rows.isEmpty() ? rows.getJSONArray(rows.size() - 1).getString(0) : "";
        }
        KDBizException kdBizException = this.getKDBizExceptionByHttpResponse(response);
        this.log.error("metadataAndSqlCheck4GitBranch-queryDmpModuleOrgFail", (Throwable)kdBizException);
        return "";
    }

    private String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "HmacSHA256");
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    @ApiPostMapping(value="metadataCheckStop")
    public CustomApiResult<PipelineCustomApiModel<String>> metadataCheckStop(@ApiParam(value="pId") @ApiParam(value="pId") String pId, @ApiParam(value="runId") @ApiParam(value="runId") String runId, @ApiParam(value="taskId") @ApiParam(value="taskId") String taskId) {
        PipelineCustomApiModel<String> pipelineCustomApiModel = PipelineCustomApiModel.success("");
        if (StringUtils.isBlank((CharSequence)pId)) {
            String errorString = ResManager.loadKDString((String)"pId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_2", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3002", errorString);
        }
        if (StringUtils.isBlank((CharSequence)runId)) {
            String errorString = ResManager.loadKDString((String)"runId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_3", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3000", errorString);
        }
        if (StringUtils.isBlank((CharSequence)taskId)) {
            String errorString = ResManager.loadKDString((String)"taskId\u4e3a\u7a7a\u3002", (String)"MetadataCheckApiService_4", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
            return this.getFailResult("3001", errorString);
        }
        String groupKey = String.format("%s-%s-%s", pId, runId, taskId);
        String value = this.getCache(groupKey);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            return CustomApiResult.success(pipelineCustomApiModel);
        }
        String errorString = ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u6267\u884c\u4e2d\u7684\u4efb\u52a1\u3002", (String)"MetadataCheckApiService_6", (String)"mpscmm-msplan-webapi", (Object[])new Object[0]);
        return this.getFailResult("3005", errorString);
    }

    private static class ExeMethodParam {
        private Map<String, DynamicObject> bug2Log;
        private List<DynamicObject> updates;
        private Map<String, String> module2route;
        private Map<String, String> appId2appName;
        private boolean test;
        private Map<String, DynamicObject> paramSetMap;

        private ExeMethodParam() {
        }

        public Map<String, DynamicObject> getBug2Log() {
            return this.bug2Log;
        }

        public void setBug2Log(Map<String, DynamicObject> bug2Log) {
            this.bug2Log = bug2Log;
        }

        public List<DynamicObject> getUpdates() {
            return this.updates;
        }

        public void setUpdates(List<DynamicObject> updates) {
            this.updates = updates;
        }

        public Map<String, String> getModule2route() {
            return this.module2route;
        }

        public void setModule2route(Map<String, String> module2route) {
            this.module2route = module2route;
        }

        public Map<String, String> getAppId2appName() {
            return this.appId2appName;
        }

        public void setAppId2appName(Map<String, String> appId2appName) {
            this.appId2appName = appId2appName;
        }

        public boolean isTest() {
            return this.test;
        }

        public void setTest(boolean test) {
            this.test = test;
        }

        public Map<String, DynamicObject> getParamSetMap() {
            return this.paramSetMap;
        }

        public void setParamSetMap(Map<String, DynamicObject> paramSetMap) {
            this.paramSetMap = paramSetMap;
        }
    }

    private static class ApiParamSet {
        private String host = "";
        private String accountId = "";
        private String tenantId = "";
        private String appId = "";
        private String appSecret = "";

        private ApiParamSet() {
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getAppId() {
            return this.appId;
        }

        public void setAppId(String appId) {
            this.appId = appId;
        }

        public String getAppSecret() {
            return this.appSecret;
        }

        public void setAppSecret(String appSecret) {
            this.appSecret = appSecret;
        }
    }
}

